/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.nullspace;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.MemoryFactory;
import ch.javasoft.metabolic.efm.memory.ReadWriteMemory;
import ch.javasoft.metabolic.efm.model.AbstractNetworkEfmModel;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifierFactory;
import ch.javasoft.metabolic.efm.model.ColumnToFluxDistributionConverter;
import ch.javasoft.metabolic.efm.model.DefaultIterationStepModel;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.model.nullspace.NullspaceColumnToFluxDistributionConverter;
import ch.javasoft.metabolic.efm.util.EfmHelper;
import ch.javasoft.metabolic.efm.util.ReactionMapping;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.logging.LogPrintWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullspaceEfmModel
extends AbstractNetworkEfmModel {
    protected final ReadableMatrix kernelMatrix;

    public <N extends Number> NullspaceEfmModel(ColumnHome<N, ?> columnHome, MetabolicNetwork net, Config config, ColumnInspectorModifierFactory factory) {
        super(columnHome, net, config, factory);
        ReadableMatrix<BigFraction> stoich = EfmHelper.createKernel(net, this.getStoichRational(), this.getReactionSorting(), config, false);
        this.kernelMatrix = columnHome.convertMatrix(stoich, false, true);
        this.getReactionMapping().refreshSortMapping();
    }

    @Override
    public <N extends Number, Col extends Column> ColumnToFluxDistributionConverter<N, Col> getColumnToFluxDistributionConverter(ColumnHome<N, Col> columnHome) {
        return new NullspaceColumnToFluxDistributionConverter<N, Col>(columnHome);
    }

    @Override
    public <N extends Number, Col extends Column> AppendableMemory<Col> createInitialMemory(ColumnHome<N, Col> columnHome, MemoryFactory memoryFactory) throws IOException {
        Column[] cols = columnHome.newInstances(this.getKernelMatrix(columnHome), 0);
        DefaultIterationStepModel itModel = new DefaultIterationStepModel(this, 0);
        int i = 0;
        while (i < cols.length) {
            cols[i] = cols[i].convert(columnHome, this, itModel, false);
            ++i;
        }
        ReadWriteMemory<Column> memory = memoryFactory.createReadWriteMemory(columnHome, this, 1, null);
        memory.appendColumns(Arrays.asList(cols));
        return memory;
    }

    @Override
    public boolean cutOff(NetworkEfmModel.Partition partition) {
        return NetworkEfmModel.Partition.Negative.equals((Object)partition);
    }

    @Override
    public int getHyperplaneIndex(int iteration) {
        return this.getBooleanSize(iteration);
    }

    public <N extends Number> ReadableMatrix<N> getKernelMatrix(ColumnHome<N, ?> columnHome) {
        return columnHome.castMatrix(this.kernelMatrix);
    }

    @Override
    public int getIterationCount() {
        return this.kernelMatrix.getRowCount() - this.kernelMatrix.getColumnCount() - this.getOutOfIterationLoopCount();
    }

    @Override
    public int getBooleanSize(int iteration) {
        return iteration == 0 ? 0 : this.kernelMatrix.getColumnCount() + iteration - 1;
    }

    @Override
    public int getNumericSize(int iteration) {
        return this.kernelMatrix.getRowCount() - this.getBooleanSize(iteration);
    }

    @Override
    public int getFinalBooleanSize() {
        return this.kernelMatrix.getRowCount() - this.getFinalNumericSize();
    }

    @Override
    public int getFinalNumericSize() {
        return this.getOutOfIterationLoopCount();
    }

    @Override
    public <N extends Number> void log(ColumnHome<N, ?> columnHome, Logger logger) {
        super.log(columnHome, logger);
        logger.info("kernel matrix has dimensions " + this.kernelMatrix.getRowCount() + "x" + this.kernelMatrix.getColumnCount());
        if (logger.isLoggable(Level.FINER)) {
            LogPrintWriter finerWriter = new LogPrintWriter(logger, Level.FINER);
            finerWriter.println("kernel matrix (unmapped):");
            this.kernelMatrix.writeToMultiline(finerWriter);
            finerWriter.println("kernel matrix:");
            ReactionMapping.unsortKernelMatrixRows(this.getKernelMatrix(columnHome), this.getReactionSorting()).writeToMultiline(finerWriter);
            finerWriter.println("mx * kernel:");
            EfmHelper.mulMapped(this.getStoichiometricMatrix(columnHome), this.getKernelMatrix(columnHome), this.getReactionSorting()).writeToMultiline(finerWriter);
        }
    }
}

