/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.dist.impl;

import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.dist.impl.LogPkg;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.PartId;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.progress.AbstractStringProgressWriter;
import ch.javasoft.metabolic.efm.progress.FileProgressWriter;
import ch.javasoft.metabolic.efm.progress.IntProgressAggregator;
import ch.javasoft.metabolic.efm.progress.ProgressAggregator;
import ch.javasoft.util.logging.LogPrintWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistServer<Col extends Column> {
    private final CountDownLatch activeNodeLatch;
    private final int partCount;
    private final AtomicInteger partIndex = new AtomicInteger();
    private final AtomicReference<IOException> exception = new AtomicReference();
    private final ServerSocket socket;
    private final EntityMarshaller<Col> writeMarshaller;
    private final EntityMarshaller<Col> readMarshaller;
    private final AdjEnumModel<Col> adjModel;
    private final ProgressAggregator progress;

    public DistServer(ColumnHome<?, Col> columnHome, Config config, AdjEnumModel<Col> adjModel, int nodeCount) throws UnknownHostException, IOException {
        this(columnHome, config, adjModel, nodeCount, 0);
    }

    public DistServer(ColumnHome<?, Col> columnHome, Config config, AdjEnumModel<Col> adjModel, int nodeCount, int port) throws UnknownHostException, IOException {
        this.activeNodeLatch = new CountDownLatch(nodeCount);
        this.partCount = config.getDistributedConfig().getPartition();
        this.socket = new ServerSocket(port);
        this.writeMarshaller = columnHome.getEntityMarshaller(adjModel.getNextState().getBooleanSize(), adjModel.getNextState().getNumericSize());
        this.readMarshaller = columnHome.getEntityMarshaller(adjModel.getCurrentState().getBooleanSize(), adjModel.getCurrentState().getNumericSize());
        this.adjModel = adjModel;
        this.progress = config.getProgressPartition() <= 0 ? null : new IntProgressAggregator(new FileProgressWriter(new File(config.getTempDir().getPersonalizedDir(), "progress-" + adjModel.getIterationIndex() + ".txt"), AbstractStringProgressWriter.Mode.Partition, config.getProgressPartition()));
    }

    public int getPartCount() {
        return this.partCount;
    }

    public int getNextPart() {
        int ix = this.partIndex.getAndIncrement();
        if (ix >= this.partCount) {
            this.partIndex.set(this.partCount);
            return -1;
        }
        return ix;
    }

    public void start() {
        final int nodeCount = (int)this.activeNodeLatch.getCount();
        new Thread(){

            public void run() {
                int i = 0;
                while (i < nodeCount) {
                    try {
                        Socket client = DistServer.this.socket.accept();
                        DistServer.this.handleRequest(client);
                    }
                    catch (SocketException client) {
                    }
                    catch (IOException e) {
                        DistServer.this.handleException(e);
                    }
                    ++i;
                }
            }
        }.start();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    private void handleRequest(final Socket client) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        block28: {
                            boolean stop;
                            DataOutputStream dataOut;
                            DataInputStream dataIn;
                            block27: {
                                dataIn = new DataInputStream(client.getInputStream());
                                dataOut = new DataOutputStream(client.getOutputStream());
                                stop = false;
                                if (!true) break block27;
                                if (stop) return;
                                if (DistServer.this.activeNodeLatch.getCount() <= 0L) break block28;
                            }
                            do {
                                byte icommand;
                                if ((icommand = dataIn.readByte()) < 0) throw new IOException("invalid command: " + icommand);
                                if (icommand >= Command.values().length) {
                                    throw new IOException("invalid command: " + icommand);
                                }
                                Command command = Command.values()[icommand];
                                switch (command) {
                                    case COUNT: {
                                        int count;
                                        SortableMemory memory;
                                        PartId part = PartId.values()[dataIn.readByte()];
                                        SortableMemory sortableMemory = memory = DistServer.this.adjModel.getMemory(part);
                                        synchronized (sortableMemory) {
                                            count = memory.getColumnCount();
                                        }
                                        dataOut.writeInt(count);
                                        dataOut.flush();
                                        break;
                                    }
                                    case GET: {
                                        Object col;
                                        SortableMemory memory;
                                        PartId part = PartId.values()[dataIn.readByte()];
                                        int index = dataIn.readInt();
                                        SortableMemory sortableMemory = memory = DistServer.this.adjModel.getMemory(part);
                                        synchronized (sortableMemory) {
                                            col = memory.getColumn(index);
                                        }
                                        DistServer.this.readMarshaller.writeTo(col, dataOut);
                                        dataOut.flush();
                                        break;
                                    }
                                    case APPEND: {
                                        Column col = (Column)DistServer.this.writeMarshaller.readFrom(dataIn);
                                        DistServer.this.adjModel.getMemoryForNewFromAdj().appendColumn(col);
                                        break;
                                    }
                                    case NEXTJOB: {
                                        int nextPart = DistServer.this.getNextPart();
                                        dataOut.writeInt(nextPart);
                                        dataOut.flush();
                                        if (nextPart >= 0) break;
                                        stop = true;
                                        break;
                                    }
                                    case PROGRESS: {
                                        int inc = dataIn.readInt();
                                        DistServer.this.progress.updateProgress(inc);
                                        break;
                                    }
                                    default: {
                                        throw new IOException("unsupported command: " + (Object)((Object)command));
                                    }
                                }
                                if (stop) return;
                            } while (DistServer.this.activeNodeLatch.getCount() > 0L);
                        }
                        return;
                    }
                    catch (IOException e) {
                        DistServer.this.handleException(e);
                        DistServer.this.activeNodeLatch.countDown();
                        try {
                            client.close();
                            return;
                        }
                        catch (IOException e2) {
                            LogPkg.LOGGER.warning("could not close client sochet, e=" + e2);
                            e2.printStackTrace(new LogPrintWriter(LogPkg.LOGGER, Level.WARNING));
                            return;
                        }
                    }
                }
                finally {
                    DistServer.this.activeNodeLatch.countDown();
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        LogPkg.LOGGER.warning("could not close client sochet, e=" + e);
                        e.printStackTrace(new LogPrintWriter(LogPkg.LOGGER, Level.WARNING));
                    }
                }
            }
        };
        thread.start();
    }

    private void handleException(IOException e) {
        this.exception.compareAndSet(null, e);
    }

    public void awaitCompletion() throws InterruptedException {
        this.activeNodeLatch.await();
    }

    public AppendableMemory<Col> close() throws IOException {
        while (this.activeNodeLatch.getCount() > 0L) {
            this.activeNodeLatch.countDown();
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LogPkg.LOGGER.warning("could not close server sochet, e=" + e);
            e.printStackTrace(new LogPrintWriter(LogPkg.LOGGER, Level.WARNING));
        }
        if (this.progress != null) {
            this.progress.close();
        }
        if (this.exception.get() != null) {
            throw this.exception.get();
        }
        AppendableMemory<Col> memory = this.adjModel.getMemoryForNewFromAdj();
        memory.flush();
        return memory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        COUNT,
        GET,
        APPEND,
        NEXTJOB,
        PROGRESS;

    }
}

