/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.dist.impl;

import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.dist.PartIterator;
import ch.javasoft.metabolic.efm.dist.impl.DistServer;
import ch.javasoft.metabolic.efm.dist.impl.LogPkg;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.PartId;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.MemoryAccessor;
import ch.javasoft.metabolic.efm.model.ModelPersister;
import ch.javasoft.metabolic.efm.progress.ProgressAggregator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistClient<Col extends Column>
implements MemoryAccessor<Col>,
PartIterator {
    private final Socket socket;
    private final DataInputStream dataInput;
    private final DataOutputStream dataOutput;
    private final AdjEnumModel<Col> adjEnumModel;
    private final EntityMarshaller<Col> writeMarshaller;
    private final EntityMarshaller<Col> readMarshaller;
    private final Lock lock = new ReentrantLock();
    private final AppendableMemory<Col> memory;
    private final ProgressAggregator progress;

    public DistClient(ColumnHome<?, Col> columnHome, ModelPersister modelPersister, File adjEnumPropsFile, String host, int port) throws UnknownHostException, IOException {
        this.socket = new Socket(host, port);
        this.dataInput = new DataInputStream(this.socket.getInputStream());
        this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
        this.memory = new Memory();
        this.progress = new Progress();
        this.adjEnumModel = modelPersister.readAdjEnumModel(columnHome, adjEnumPropsFile, this);
        this.writeMarshaller = columnHome.getEntityMarshaller(this.adjEnumModel.getNextState().getBooleanSize(), this.adjEnumModel.getNextState().getNumericSize());
        this.readMarshaller = columnHome.getEntityMarshaller(this.adjEnumModel.getCurrentState().getBooleanSize(), this.adjEnumModel.getCurrentState().getNumericSize());
        LogPkg.LOGGER.finest("CLIENT CONNECTED: " + this.socket);
    }

    public AdjEnumModel<Col> getAdjEnumModel() {
        return this.adjEnumModel;
    }

    @Override
    public AppendableMemory<Col> getAppendableMemory() {
        return this.memory;
    }

    public ProgressAggregator getProgressAggregator() {
        return this.progress;
    }

    @Override
    public Col getColumn(PartId part, int index) throws IOException {
        this.lock.lock();
        try {
            LogPkg.LOGGER.finest("CLIENT GET: " + this.socket);
            this.dataOutput.writeByte(DistServer.Command.GET.ordinal());
            this.dataOutput.writeByte(part.ordinal());
            this.dataOutput.writeInt(index);
            this.dataOutput.flush();
            Column column = (Column)this.readMarshaller.readFrom(this.dataInput);
            return (Col)column;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getColumnCount(PartId part) throws IOException {
        this.lock.lock();
        try {
            LogPkg.LOGGER.finest("CLIENT GET: " + this.socket);
            this.dataOutput.writeByte(DistServer.Command.COUNT.ordinal());
            this.dataOutput.writeByte(part.ordinal());
            this.dataOutput.flush();
            int n = this.dataInput.readInt();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getNextPart() throws IOException {
        this.lock.lock();
        try {
            LogPkg.LOGGER.finest("CLIENT NEXTJOB: " + this.socket);
            this.dataOutput.writeByte(DistServer.Command.NEXTJOB.ordinal());
            this.dataOutput.flush();
            int next = this.dataInput.readInt();
            if (next < 0) {
                this.close();
            }
            int n = next;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void close() throws IOException {
        this.memory.close(false);
        this.progress.close();
        this.adjEnumModel.closeForThread();
        this.socket.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Memory
    implements AppendableMemory<Col> {
        private Memory() {
        }

        @Override
        public void appendColumn(Col column) throws IOException {
            DistClient.this.lock.lock();
            try {
                LogPkg.LOGGER.finest("CLIENT APPEND: " + column);
                DistClient.this.dataOutput.writeByte(DistServer.Command.APPEND.ordinal());
                DistClient.this.writeMarshaller.writeTo(column, DistClient.this.dataOutput);
            }
            finally {
                DistClient.this.lock.unlock();
            }
        }

        @Override
        public void appendColumns(Iterable<? extends Col> columns) throws IOException {
            for (Column col : columns) {
                this.appendColumn(col);
            }
        }

        @Override
        public void appendFrom(IndexableMemory<? extends Col> memory) throws IOException {
            this.appendColumns(memory);
        }

        @Override
        public void flush() throws IOException {
            DistClient.this.dataOutput.flush();
        }

        @Override
        public void close(boolean erase) throws IOException {
            if (erase) {
                throw new IOException("erasing not supported");
            }
            DistClient.this.lock.lock();
            try {
                LogPkg.LOGGER.finest("CLOSE CLIENT: " + DistClient.this.socket);
                DistClient.this.dataInput.close();
                DistClient.this.dataOutput.close();
                DistClient.this.socket.close();
                DistClient.this.progress.close();
                DistClient.this.adjEnumModel.closeForThread();
            }
            finally {
                DistClient.this.lock.unlock();
            }
        }

        @Override
        public String fileId() throws IOException {
            throw new IOException("not supported");
        }

        @Override
        public SortableMemory<Col> toSortableMemory() throws IOException {
            throw new IOException("not supported");
        }

        @Override
        public int getColumnCount() throws IOException {
            throw new IOException("not supported");
        }

        @Override
        public Iterator<Col> iterator() {
            throw new RuntimeException("not supported");
        }
    }

    private class Progress
    implements ProgressAggregator {
        private Progress() {
        }

        public void updateProgress(int e) throws IOException, IllegalArgumentException {
            if (e > this.getSmallestIncrement()) {
                throw new IllegalArgumentException("progress increment too small, i.e. e > " + this.getSmallestIncrement() + ": " + e);
            }
            if (e < 0) {
                throw new IllegalArgumentException("negative progress increment: " + e);
            }
            DistClient.this.lock.lock();
            try {
                LogPkg.LOGGER.finest("CLIENT PROGRESS: " + DistClient.this.socket);
                DistClient.this.dataOutput.writeByte(DistServer.Command.PROGRESS.ordinal());
                DistClient.this.dataOutput.writeInt(e);
                DistClient.this.dataOutput.flush();
            }
            finally {
                DistClient.this.lock.unlock();
            }
        }

        public int getSmallestIncrement() {
            return 10;
        }

        public void close() throws IOException {
        }
    }
}

