/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.urank.dbl2;

import ch.javasoft.metabolic.efm.adj.incore.tree.urank.RankUpdateJobScheduleTreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.urank.RankUpdateRoot;
import ch.javasoft.metabolic.efm.adj.incore.tree.urank.dbl2.Double2PreprocessedMatrix;
import ch.javasoft.metabolic.efm.concurrent.RankUpdateToken;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.rankup.PreprocessableMatrix;
import ch.javasoft.metabolic.efm.rankup.PreprocessedMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.numeric.Zero;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Double2RankUpdateTreeFactory
extends RankUpdateJobScheduleTreeFactory {
    public Double2RankUpdateTreeFactory(EfmModel efmModel) {
        super(efmModel);
    }

    @Override
    protected PreprocessedMatrix createInitialPreprocessedMatrix(PreprocessableMatrix owner, RankUpdateToken token, RankUpdateRoot root) {
        return new Double2PreprocessedMatrix(owner, root, Double2RankUpdateTreeFactory.convertToDoubleMatrix(root.getStoichRational()));
    }

    @Override
    protected PreprocessedMatrix createChildPreprocessedMatrix(PreprocessableMatrix owner, RankUpdateToken token, RankUpdateRoot root, PreprocessedMatrix parentPreprocessedMatrix) {
        Double2PreprocessedMatrix parent = (Double2PreprocessedMatrix)parentPreprocessedMatrix;
        return new Double2PreprocessedMatrix(owner, root, parent);
    }

    public int getRank(Zero zero, ReadableMatrix<? extends Number> matrix) {
        DoubleMatrix mx = Double2RankUpdateTreeFactory.convertToDoubleMatrix(matrix);
        return new Gauss(zero.mZeroPos).rank(mx);
    }

    private static DoubleMatrix convertToDoubleMatrix(ReadableMatrix mx) {
        if (mx instanceof ReadableDoubleMatrix) {
            return ((ReadableDoubleMatrix)mx).toDoubleMatrix(true);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }
}

