/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.search;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.tree.AbstractRoot;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.search.TestMethod;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRoot<T>
extends AbstractRoot<T> {
    private final Node<T> mZero;
    private final int mRequiredZeroCount;
    private final TestMethod mTestMethod;

    public SearchRoot(Config config, EfmModel model, TreeFactory<T> treeFactory, int requiredZeroCount, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols) throws IOException {
        super(config, model, treeFactory, posCols, zeroCols, negCols);
        this.mZero = treeFactory.createNode(zeroCols, this.mSelectiveBits, -1, 0, zeroCols.getColumnCount());
        this.mRequiredZeroCount = requiredZeroCount;
        this.mTestMethod = SearchRoot.createTestMethod(this, posCols.getColumnCount(), negCols.getColumnCount(), zeroCols.getColumnCount());
    }

    @Override
    public boolean isRequiredZeroBitCount(T token, int count) {
        return count >= this.mRequiredZeroCount;
    }

    private static TestMethod createTestMethod(SearchRoot<?> root, int posCnt, int negCnt, int zerCnt) {
        if (posCnt > negCnt) {
            if (posCnt > zerCnt) {
                if (negCnt > zerCnt) {
                    return new TestMethod(){

                        @Override
                        public void filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, AdjCandidates<Column> adjacentPairs) throws IOException {
                            if (filterCutPattern != null) {
                                filterCutPattern = SearchRoot.this.mPos.filterAdjacentPairs(filterCutPattern, posCols, adjacentPairs);
                            }
                            if (filterCutPattern != null) {
                                filterCutPattern = SearchRoot.this.mNeg.filterAdjacentPairs(filterCutPattern, negCols, adjacentPairs);
                            }
                            if (filterCutPattern != null) {
                                filterCutPattern = SearchRoot.this.mZero.filterAdjacentPairs(filterCutPattern, zeroCols, adjacentPairs);
                            }
                        }
                    };
                }
                return new TestMethod(){

                    @Override
                    public void filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, AdjCandidates<Column> adjacentPairs) throws IOException {
                        if (filterCutPattern != null) {
                            filterCutPattern = SearchRoot.this.mPos.filterAdjacentPairs(filterCutPattern, posCols, adjacentPairs);
                        }
                        if (filterCutPattern != null) {
                            filterCutPattern = SearchRoot.this.mZero.filterAdjacentPairs(filterCutPattern, zeroCols, adjacentPairs);
                        }
                        if (filterCutPattern != null) {
                            filterCutPattern = SearchRoot.this.mNeg.filterAdjacentPairs(filterCutPattern, negCols, adjacentPairs);
                        }
                    }
                };
            }
            return new TestMethod(){

                @Override
                public void filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, AdjCandidates<Column> adjacentPairs) throws IOException {
                    if (filterCutPattern != null) {
                        filterCutPattern = SearchRoot.this.mZero.filterAdjacentPairs(filterCutPattern, zeroCols, adjacentPairs);
                    }
                    if (filterCutPattern != null) {
                        filterCutPattern = SearchRoot.this.mPos.filterAdjacentPairs(filterCutPattern, posCols, adjacentPairs);
                    }
                    if (filterCutPattern != null) {
                        filterCutPattern = SearchRoot.this.mNeg.filterAdjacentPairs(filterCutPattern, negCols, adjacentPairs);
                    }
                }
            };
        }
        if (negCnt > zerCnt) {
            if (posCnt > zerCnt) {
                return new TestMethod(){

                    @Override
                    public void filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, AdjCandidates<Column> adjacentPairs) throws IOException {
                        if (filterCutPattern != null) {
                            filterCutPattern = SearchRoot.this.mNeg.filterAdjacentPairs(filterCutPattern, negCols, adjacentPairs);
                        }
                        if (filterCutPattern != null) {
                            filterCutPattern = SearchRoot.this.mPos.filterAdjacentPairs(filterCutPattern, posCols, adjacentPairs);
                        }
                        if (filterCutPattern != null) {
                            filterCutPattern = SearchRoot.this.mZero.filterAdjacentPairs(filterCutPattern, zeroCols, adjacentPairs);
                        }
                    }
                };
            }
            return new TestMethod(){

                @Override
                public void filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, AdjCandidates<Column> adjacentPairs) throws IOException {
                    if (filterCutPattern != null) {
                        filterCutPattern = SearchRoot.this.mNeg.filterAdjacentPairs(filterCutPattern, negCols, adjacentPairs);
                    }
                    if (filterCutPattern != null) {
                        filterCutPattern = SearchRoot.this.mZero.filterAdjacentPairs(filterCutPattern, zeroCols, adjacentPairs);
                    }
                    if (filterCutPattern != null) {
                        filterCutPattern = SearchRoot.this.mPos.filterAdjacentPairs(filterCutPattern, posCols, adjacentPairs);
                    }
                }
            };
        }
        return new TestMethod(){

            @Override
            public void filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, AdjCandidates<Column> adjacentPairs) throws IOException {
                if (filterCutPattern != null) {
                    filterCutPattern = SearchRoot.this.mZero.filterAdjacentPairs(filterCutPattern, zeroCols, adjacentPairs);
                }
                if (filterCutPattern != null) {
                    filterCutPattern = SearchRoot.this.mNeg.filterAdjacentPairs(filterCutPattern, negCols, adjacentPairs);
                }
                if (filterCutPattern != null) {
                    filterCutPattern = SearchRoot.this.mPos.filterAdjacentPairs(filterCutPattern, posCols, adjacentPairs);
                }
            }
        };
    }

    @Override
    public void filterAdjacentPairs(T token, Node<T> nodeA, Node<T> nodeB, IBitSet filterCutPattern, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, AdjCandidates<Column> candidates) throws IOException {
        this.mTestMethod.filterAdjacentPairs(filterCutPattern, posCols, zeroCols, negCols, candidates);
    }
}

