/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.metabolic.efm.adj.incore.tree.EmptyLeaf;
import ch.javasoft.metabolic.efm.adj.incore.tree.InterNode;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.UnaryLeaf;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeFactory<T>
implements TreeFactory<T> {
    protected final EfmModel efmModel;

    public AbstractTreeFactory(EfmModel efmModel) {
        this.efmModel = efmModel;
    }

    protected Node<T> createInterNode(SortableMemory<Column> cols, int[] selectiveBits, int prevSelBitIndex, int iStart, int iEnd) throws IOException {
        return new InterNode(this, cols, selectiveBits, prevSelBitIndex, iStart, iEnd);
    }

    protected Node<T> createLeaf(SortableMemory<Column> cols, int[] selectiveBits, int prevSelBitIndex, int iStart, int iEnd) throws IOException {
        if (iEnd - iStart == 1) {
            return new UnaryLeaf(this, cols, iStart);
        }
        if (iEnd - iStart == 0) {
            return EmptyLeaf.instance();
        }
        throw new IllegalArgumentException("start=" + iStart + ", end=" + iEnd);
    }

    @Override
    public Node<T> createNode(SortableMemory<Column> cols, int[] selectiveBits, int prevSelBitIndex, int iStart, int iEnd) throws IOException {
        return iEnd - iStart <= 1 ? this.createLeaf(cols, selectiveBits, prevSelBitIndex, iStart, iEnd) : this.createInterNode(cols, selectiveBits, prevSelBitIndex, iStart, iEnd);
    }
}

