/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore;

import ch.javasoft.metabolic.efm.adj.AdjEnum;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdjacencyEnumerator
implements AdjEnum {
    protected Config mConfig;
    protected EfmModel mModel;

    @Override
    public <Col extends Column, N extends Number> void initialize(ColumnHome<N, Col> columnHome, Config config, EfmModel model) {
        this.mConfig = config;
        this.mModel = model;
    }

    @Override
    public <Col extends Column, N extends Number> void adjacentPairs(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> adjModel) throws IOException {
        ConcurrentLinkedQueue<ColumnPair> adjacentPairs = new ConcurrentLinkedQueue<ColumnPair>();
        SortableMemory<Column> memZer = adjModel.getMemoryZero();
        SortableMemory<Column> memPos = adjModel.getMemoryPos();
        SortableMemory<Column> memNeg = adjModel.getMemoryNeg();
        this.adjacentPairs(adjacentPairs, memZer, memPos, memNeg);
        while (!adjacentPairs.isEmpty()) {
            ColumnPair pair = (ColumnPair)adjacentPairs.poll();
            Col colA = columnHome.castColumn((Column)pair.getColumnA());
            Col colB = columnHome.castColumn((Column)pair.getColumnB());
            Col colN = colA.mergeWith(columnHome, this.mModel, colB, adjModel);
            adjModel.getMemoryForNewFromAdj().appendColumn(colN);
        }
    }

    public abstract void adjacentPairs(Queue<ColumnPair> var1, SortableMemory<Column> var2, SortableMemory<Column> var3, SortableMemory<Column> var4) throws IOException;

    public Config getConfig() {
        return this.mConfig;
    }

    public EfmModel getEfmModel() {
        return this.mModel;
    }
}

