/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.varint;

import ch.javasoft.math.varint.IntVarInt;
import ch.javasoft.math.varint.LongVarInt;
import ch.javasoft.math.varint.VarInt;
import ch.javasoft.math.varint.VarIntFactory;
import ch.javasoft.math.varint.VarIntNumber;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class BigIntegerVarInt
extends VarIntNumber {
    private static final long serialVersionUID = 822046479881991852L;
    private final BigInteger value;

    protected BigIntegerVarInt(BigInteger value) {
        this.value = value;
    }

    public static BigIntegerVarInt valueOf(BigInteger value) {
        return VarIntFactory.CACHE.cacheGet(value);
    }

    public VarIntNumber compact() {
        int bitlen = this.value.bitLength();
        if (bitlen <= 31) {
            return IntVarInt.valueOf(this.value.intValue());
        }
        if (bitlen <= 63) {
            return LongVarInt.valueOf(this.value.longValue());
        }
        return this;
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    public boolean isOne() {
        return BigInteger.ONE.equals(this.value);
    }

    public boolean isNegative() {
        return this.value.signum() < 0;
    }

    public boolean isPositive() {
        return this.value.signum() > 0;
    }

    public boolean isNonNegative() {
        return this.value.signum() >= 0;
    }

    public boolean isNonPositive() {
        return this.value.signum() <= 0;
    }

    public boolean isEven() {
        return !this.value.testBit(0);
    }

    public boolean testBit(int n) {
        return this.value.testBit(n);
    }

    public int bitCount() {
        return this.value.bitCount();
    }

    public int bitLength() {
        return this.value.bitLength();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public VarIntNumber abs() {
        return this.value.signum() < 0 ? BigIntegerVarInt.valueOf(this.value.abs()) : this;
    }

    public VarIntNumber add(VarInt val) {
        return BigIntegerVarInt.valueOf(this.value.add(val.toBigInteger()));
    }

    public VarIntNumber divide(VarInt val) {
        return BigIntegerVarInt.valueOf(this.value.divide(val.toBigInteger()));
    }

    public VarIntNumber gcd(VarInt val) {
        return BigIntegerVarInt.valueOf(this.value.gcd(val.toBigInteger()));
    }

    public VarIntNumber max(VarInt val) {
        return BigIntegerVarInt.valueOf(this.value.max(val.toBigInteger()));
    }

    public VarIntNumber min(VarInt val) {
        return BigIntegerVarInt.valueOf(this.value.min(val.toBigInteger()));
    }

    public VarIntNumber mod(VarInt m) {
        return BigIntegerVarInt.valueOf(this.value.mod(m.toBigInteger()));
    }

    public VarIntNumber multiply(VarInt val) {
        return BigIntegerVarInt.valueOf(this.value.multiply(val.toBigInteger()));
    }

    public VarIntNumber negate() {
        return BigIntegerVarInt.valueOf(this.value.negate());
    }

    public VarIntNumber pow(int exponent) {
        return BigIntegerVarInt.valueOf(this.value.pow(exponent));
    }

    public VarIntNumber remainder(VarInt val) {
        return BigIntegerVarInt.valueOf(this.value.remainder(val.toBigInteger()));
    }

    public VarIntNumber shiftLeft(int n) {
        return BigIntegerVarInt.valueOf(this.value.shiftLeft(n));
    }

    public VarIntNumber shiftRight(int n) {
        return BigIntegerVarInt.valueOf(this.value.shiftRight(n));
    }

    public int signum() {
        return this.value.signum();
    }

    public VarIntNumber subtract(VarInt val) {
        return BigIntegerVarInt.valueOf(this.value.subtract(val.toBigInteger()));
    }

    public BigInteger toBigInteger() {
        return this.value;
    }

    public byte[] toByteArray() {
        return this.value.toByteArray();
    }

    public void writeTo(OutputStream out) throws IOException {
        VarIntFactory.writeBytes(out, this.value.toByteArray());
    }

    public String toString(int radix) {
        return this.value.toString(radix);
    }

    public int compareTo(VarInt o) {
        return this.value.compareTo(o.toBigInteger());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VarInt) {
            return this.value.equals(((VarInt)obj).toBigInteger());
        }
        return false;
    }

    public static /* bridge */ /* synthetic */ VarIntNumber valueOf(BigInteger bigInteger) {
        return BigIntegerVarInt.valueOf(bigInteger);
    }
}

