/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.operator.impl;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.impl.DoubleArrayOperations;
import ch.javasoft.math.linalg.DefaultLinAlgOperations;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.linalg.impl.DoubleGaussPivoting;
import ch.javasoft.math.operator.AbstractBinaryOperator;
import ch.javasoft.math.operator.AbstractBooleanBinaryOperator;
import ch.javasoft.math.operator.AbstractBooleanUnaryOperator;
import ch.javasoft.math.operator.AbstractIntBinaryOperator;
import ch.javasoft.math.operator.AbstractIntUnaryOperator;
import ch.javasoft.math.operator.AbstractNullaryOperator;
import ch.javasoft.math.operator.AbstractUnaryOperator;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanBinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.ConvertingUnaryOperator;
import ch.javasoft.math.operator.DivisionSupport;
import ch.javasoft.math.operator.IntBinaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.util.numeric.Zero;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleOperators
implements NumberOperators<Double, double[]> {
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    public static final DoubleOperators DEFAULT = new DoubleOperators();
    private final LinAlgOperations<Double, double[]> linAlgOps;
    private final NullaryOperator<Double, double[]>[] nullary = DoubleOperators.initNullary();
    private final UnaryOperator<Double, double[]>[] unary;
    private final BooleanUnaryOperator<Double, double[]>[] boolUnary;
    private final IntUnaryOperator<Double, double[]>[] intUnary;
    private final ConvertingUnaryOperator<Number, Number[], Double, double[]> converter;
    private final BinaryOperator<Double, double[]>[] binary;
    private final BooleanBinaryOperator<Double, double[]>[] boolBinary;
    private final IntBinaryOperator<Double, double[]>[] intBinary;
    private final AggregatingUnaryOperator<Double, double[]>[] aggUnary;
    private final AggregatingBinaryOperator<Double, double[]>[] aggBinary;

    protected DoubleOperators() {
        this.unary = DoubleOperators.initUnary();
        this.boolUnary = DoubleOperators.initBoolUnary();
        this.intUnary = DoubleOperators.initIntUnary();
        this.converter = this.initConverter();
        this.binary = DoubleOperators.initBinary();
        this.boolBinary = DoubleOperators.initBoolBinary();
        this.intBinary = DoubleOperators.initIntBinary();
        this.aggUnary = DoubleOperators.initAggUnary();
        this.aggBinary = DoubleOperators.initAggBinary();
        this.linAlgOps = new DefaultLinAlgOperations<Double, double[]>(this, DoubleArrayOperations.INSTANCE, DoubleGaussPivoting.ABS_G);
    }

    public DoubleOperators(Zero zero) {
        this.unary = DoubleOperators.initUnary(zero);
        this.boolUnary = DoubleOperators.initBoolUnary(zero);
        this.intUnary = DoubleOperators.initIntUnary(zero);
        this.converter = this.initConverter();
        this.binary = DoubleOperators.initBinary();
        this.boolBinary = DoubleOperators.initBoolBinary(zero);
        this.intBinary = DoubleOperators.initIntBinary(zero);
        this.aggUnary = DoubleOperators.initAggUnary(zero);
        this.aggBinary = DoubleOperators.initAggBinary();
        this.linAlgOps = new DefaultLinAlgOperations<Double, double[]>(this, DoubleArrayOperations.INSTANCE, DoubleGaussPivoting.ABS_G);
    }

    @Override
    public Class<Double> numberClass() {
        return Double.class;
    }

    @Override
    public Class<double[]> arrayClass() {
        return double[].class;
    }

    @Override
    public DivisionSupport getDivisionSupport() {
        return DivisionSupport.SUFFICIENTLY_EXACT;
    }

    @Override
    public LinAlgOperations<Double, double[]> getLinAlgOperations() {
        return this.linAlgOps;
    }

    @Override
    public LinAlgOperations<Double, double[]> getLinAlgOperations(GaussPivotingFactory<Double, double[]> gaussPivotingFactory) {
        return new DefaultLinAlgOperations<Double, double[]>(this.getNumberArrayOperations(), gaussPivotingFactory);
    }

    @Override
    public ArrayOperations<double[]> getArrayOperations() {
        return this.linAlgOps.getArrayOperations();
    }

    @Override
    public NumberArrayOperations<Double, double[]> getNumberArrayOperations() {
        return this.linAlgOps.getNumberArrayOperations();
    }

    @Override
    public Double zero() {
        return ZERO;
    }

    @Override
    public Double one() {
        return ONE;
    }

    @Override
    public NullaryOperator<Double, double[]> constant(Double value) {
        double dval = value;
        if (dval == 0.0) {
            return this.nullary(NullaryOperator.Id.zero);
        }
        if (dval == 1.0) {
            return this.nullary(NullaryOperator.Id.one);
        }
        return new DoubleConstOperator(dval);
    }

    @Override
    public ConvertingUnaryOperator<Number, Number[], Double, double[]> converter() {
        return this.converter;
    }

    @Override
    public NullaryOperator<Double, double[]> nullary(NullaryOperator.Id id) {
        return this.nullary[id.ordinal()];
    }

    @Override
    public UnaryOperator<Double, double[]> unary(UnaryOperator.Id id) {
        return this.unary[id.ordinal()];
    }

    @Override
    public BooleanUnaryOperator<Double, double[]> booleanUnary(BooleanUnaryOperator.Id id) {
        return this.boolUnary[id.ordinal()];
    }

    @Override
    public IntUnaryOperator<Double, double[]> intUnary(IntUnaryOperator.Id id) {
        return this.intUnary[id.ordinal()];
    }

    @Override
    public BinaryOperator<Double, double[]> binary(BinaryOperator.Id id) {
        return this.binary[id.ordinal()];
    }

    @Override
    public BooleanBinaryOperator<Double, double[]> booleanBinary(BooleanBinaryOperator.Id id) {
        return this.boolBinary[id.ordinal()];
    }

    @Override
    public IntBinaryOperator<Double, double[]> intBinary(IntBinaryOperator.Id id) {
        return this.intBinary[id.ordinal()];
    }

    @Override
    public AggregatingUnaryOperator<Double, double[]> aggregatingUnary(AggregatingUnaryOperator.Id id) {
        return this.aggUnary[id.ordinal()];
    }

    @Override
    public AggregatingBinaryOperator<Double, double[]> aggregatingBinary(AggregatingBinaryOperator.Id id) {
        return this.aggBinary[id.ordinal()];
    }

    private static NullaryOperator<Double, double[]>[] initNullary() {
        NullaryOperator[] ops = new NullaryOperator[NullaryOperator.Id.values().length];
        ops[NullaryOperator.Id.zero.ordinal()] = new DoubleConstOperator(0.0);
        ops[NullaryOperator.Id.one.ordinal()] = new DoubleConstOperator(1.0);
        ops[NullaryOperator.Id.random.ordinal()] = new AbstractNullaryOperator<Double, double[]>(){

            @Override
            public Double operate() {
                return Math.random();
            }

            @Override
            public void operate(double[] dst, int dstIndex) {
                dst[dstIndex] = Math.random();
            }
        };
        return DoubleOperators.checkComplete(ops, NullaryOperator.Id.values());
    }

    private static UnaryOperator<Double, double[]>[] initUnary() {
        UnaryOperator<Double, double[]>[] ops = DoubleOperators.initUnary(null);
        ops[UnaryOperator.Id.normalize.ordinal()] = ops[UnaryOperator.Id.identity.ordinal()];
        return ops;
    }

    private static UnaryOperator<Double, double[]>[] initUnary(final Zero zero) {
        UnaryOperator[] ops = new UnaryOperator[UnaryOperator.Id.values().length];
        ops[UnaryOperator.Id.identity.ordinal()] = new AbstractUnaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand) {
                return operand;
            }

            @Override
            public Double operate(double[] src, int srcIndex) {
                return src[srcIndex];
            }

            @Override
            public void operate(double[] src, int srcIndex, double[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex];
            }
        };
        ops[UnaryOperator.Id.normalize.ordinal()] = new AbstractUnaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand) {
                return zero.isInteger(operand) ? Double.valueOf(zero.roundInteger(operand)) : operand;
            }

            @Override
            public Double operate(double[] src, int srcIndex) {
                return zero.roundInteger(src[srcIndex]);
            }

            @Override
            public void operate(double[] src, int srcIndex, double[] dst, int dstIndex) {
                dst[dstIndex] = zero.roundInteger(src[srcIndex]);
            }
        };
        ops[UnaryOperator.Id.abs.ordinal()] = new AbstractUnaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand) {
                return Math.abs(operand);
            }

            @Override
            public Double operate(double[] src, int srcIndex) {
                return Math.abs(src[srcIndex]);
            }

            @Override
            public void operate(double[] src, int srcIndex, double[] dst, int dstIndex) {
                dst[dstIndex] = Math.abs(src[srcIndex]);
            }
        };
        ops[UnaryOperator.Id.negate.ordinal()] = new AbstractUnaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand) {
                return -operand.doubleValue();
            }

            @Override
            public Double operate(double[] src, int srcIndex) {
                return -src[srcIndex];
            }

            @Override
            public void operate(double[] src, int srcIndex, double[] dst, int dstIndex) {
                dst[dstIndex] = -src[srcIndex];
            }
        };
        ops[UnaryOperator.Id.invert.ordinal()] = new AbstractUnaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand) {
                return 1.0 / operand;
            }

            @Override
            public Double operate(double[] src, int srcIndex) {
                return 1.0 / src[srcIndex];
            }

            @Override
            public void operate(double[] src, int srcIndex, double[] dst, int dstIndex) {
                dst[dstIndex] = 1.0 / src[srcIndex];
            }
        };
        ops[UnaryOperator.Id.square.ordinal()] = new AbstractUnaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand) {
                double val = operand;
                return val * val;
            }

            @Override
            public Double operate(double[] src, int srcIndex) {
                double val = src[srcIndex];
                return val * val;
            }

            @Override
            public void operate(double[] src, int srcIndex, double[] dst, int dstIndex) {
                double val = src[srcIndex];
                dst[dstIndex] = val * val;
            }
        };
        return DoubleOperators.checkComplete(ops, UnaryOperator.Id.values());
    }

    private static IntUnaryOperator<Double, double[]>[] initIntUnary() {
        IntUnaryOperator[] ops = new IntUnaryOperator[IntUnaryOperator.Id.values().length];
        ops[IntUnaryOperator.Id.signum.ordinal()] = new AbstractIntUnaryOperator<Double, double[]>(){

            @Override
            public int intOperate(Double operand) {
                return (int)Math.signum(operand);
            }

            @Override
            public int intOperate(double[] operand, int index) {
                return (int)Math.signum(operand[index]);
            }

            @Override
            public void operate(double[] src, int srcIndex, int[] dst, int dstIndex) {
                dst[dstIndex] = (int)Math.signum(src[srcIndex]);
            }
        };
        return DoubleOperators.checkComplete(ops, IntUnaryOperator.Id.values());
    }

    private ConvertingUnaryOperator<Number, Number[], Double, double[]> initConverter() {
        return new ConvertingUnaryOperator<Number, Number[], Double, double[]>(){

            @Override
            public Double operate(Number operand) {
                return operand instanceof Double ? (Double)operand : Double.valueOf(operand.doubleValue());
            }

            @Override
            public void operate(Number[] src, int srcIndex, double[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].doubleValue();
            }
        };
    }

    private static IntUnaryOperator<Double, double[]>[] initIntUnary(final Zero zero) {
        IntUnaryOperator[] ops = new IntUnaryOperator[IntUnaryOperator.Id.values().length];
        ops[IntUnaryOperator.Id.signum.ordinal()] = new AbstractIntUnaryOperator<Double, double[]>(){

            @Override
            public int intOperate(Double operand) {
                return zero.sgn(operand);
            }

            @Override
            public int intOperate(double[] operand, int index) {
                return zero.sgn(operand[index]);
            }

            @Override
            public void operate(double[] src, int srcIndex, int[] dst, int dstIndex) {
                dst[dstIndex] = zero.sgn(src[srcIndex]);
            }
        };
        return DoubleOperators.checkComplete(ops, IntUnaryOperator.Id.values());
    }

    private static BooleanUnaryOperator<Double, double[]>[] initBoolUnary() {
        BooleanUnaryOperator[] ops = new BooleanUnaryOperator[BooleanUnaryOperator.Id.values().length];
        ops[BooleanUnaryOperator.Id.isZero.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return operand == 0.0;
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return src[srcIndex] == 0.0;
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex] == 0.0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNonZero.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return operand != 0.0;
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return src[srcIndex] != 0.0;
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex] != 0.0;
            }
        };
        ops[BooleanUnaryOperator.Id.isOne.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return operand == 1.0;
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return src[srcIndex] == 1.0;
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex] == 1.0;
            }
        };
        ops[BooleanUnaryOperator.Id.isPositive.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return operand > 0.0;
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return src[srcIndex] > 0.0;
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex] > 0.0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNegative.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return operand < 0.0;
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return src[srcIndex] < 0.0;
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex] < 0.0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNonPositive.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return operand <= 0.0;
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return src[srcIndex] <= 0.0;
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex] <= 0.0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNonNegative.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return operand >= 0.0;
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return src[srcIndex] >= 0.0;
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex] >= 0.0;
            }
        };
        return DoubleOperators.checkComplete(ops, BooleanUnaryOperator.Id.values());
    }

    private static BooleanUnaryOperator<Double, double[]>[] initBoolUnary(final Zero zero) {
        BooleanUnaryOperator[] ops = new BooleanUnaryOperator[BooleanUnaryOperator.Id.values().length];
        ops[BooleanUnaryOperator.Id.isZero.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return zero.isZero(operand);
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return zero.isZero(src[srcIndex]);
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isZero(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isNonZero.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return zero.isNonZero(operand);
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return zero.isNonZero(src[srcIndex]);
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isNonZero(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isOne.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return zero.isZero(operand - 1.0);
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return zero.isZero(src[srcIndex] - 1.0);
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isZero(src[srcIndex] - 1.0);
            }
        };
        ops[BooleanUnaryOperator.Id.isPositive.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return zero.isPositive(operand);
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return zero.isPositive(src[srcIndex]);
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isPositive(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isNegative.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return zero.isNegative(operand);
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return zero.isNegative(src[srcIndex]);
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isNegative(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isNonPositive.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return !zero.isPositive(operand);
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return !zero.isPositive(src[srcIndex]);
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !zero.isPositive(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isNonNegative.ordinal()] = new AbstractBooleanUnaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand) {
                return !zero.isNegative(operand);
            }

            @Override
            public boolean booleanOperate(double[] src, int srcIndex) {
                return !zero.isNegative(src[srcIndex]);
            }

            @Override
            public void operate(double[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !zero.isNegative(src[srcIndex]);
            }
        };
        return DoubleOperators.checkComplete(ops, BooleanUnaryOperator.Id.values());
    }

    private static BinaryOperator<Double, double[]>[] initBinary() {
        BinaryOperator[] ops = new BinaryOperator[BinaryOperator.Id.values().length];
        ops[BinaryOperator.Id.add.ordinal()] = new AbstractBinaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand1, Double operand2) {
                return operand1 + operand2;
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, double[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] + operand2[index2];
            }
        };
        ops[BinaryOperator.Id.subtract.ordinal()] = new AbstractBinaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand1, Double operand2) {
                return operand1 - operand2;
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, double[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] - operand2[index2];
            }
        };
        ops[BinaryOperator.Id.multiply.ordinal()] = new AbstractBinaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand1, Double operand2) {
                return operand1 * operand2;
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, double[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] * operand2[index2];
            }
        };
        ops[BinaryOperator.Id.divide.ordinal()] = new AbstractBinaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand1, Double operand2) {
                return operand1 / operand2;
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, double[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] / operand2[index2];
            }
        };
        ops[BinaryOperator.Id.min.ordinal()] = new AbstractBinaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand1, Double operand2) {
                return operand1.compareTo(operand2) <= 0 ? operand1 : operand2;
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, double[] dst, int dstIndex) {
                dst[dstIndex] = Math.min(operand1[index1], operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.max.ordinal()] = new AbstractBinaryOperator<Double, double[]>(){

            @Override
            public Double operate(Double operand1, Double operand2) {
                return operand1.compareTo(operand2) >= 0 ? operand1 : operand2;
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, double[] dst, int dstIndex) {
                dst[dstIndex] = Math.max(operand1[index1], operand2[index2]);
            }
        };
        return DoubleOperators.checkComplete(ops, BinaryOperator.Id.values());
    }

    private static BooleanBinaryOperator<Double, double[]>[] initBoolBinary() {
        BooleanBinaryOperator[] ops = new BooleanBinaryOperator[BooleanBinaryOperator.Id.values().length];
        ops[BooleanBinaryOperator.Id.less.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return operand1 < operand2;
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return operand1[index1] < operand2[index2];
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] < operand2[index2];
            }
        };
        ops[BooleanBinaryOperator.Id.lessOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return operand1 <= operand2;
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return operand1[index1] <= operand2[index2];
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] <= operand2[index2];
            }
        };
        ops[BooleanBinaryOperator.Id.equal.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return operand1.doubleValue() == operand2.doubleValue();
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return operand1[index1] == operand2[index2];
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] == operand2[index2];
            }
        };
        ops[BooleanBinaryOperator.Id.unequal.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return operand1.doubleValue() != operand2.doubleValue();
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return operand1[index1] != operand2[index2];
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] != operand2[index2];
            }
        };
        ops[BooleanBinaryOperator.Id.greaterOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return operand1 >= operand2;
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return operand1[index1] >= operand2[index2];
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] >= operand2[index2];
            }
        };
        ops[BooleanBinaryOperator.Id.greater.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return operand1 > operand2;
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return operand1[index1] > operand2[index2];
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1] > operand2[index2];
            }
        };
        return DoubleOperators.checkComplete(ops, BooleanBinaryOperator.Id.values());
    }

    private static BooleanBinaryOperator<Double, double[]>[] initBoolBinary(final Zero zero) {
        BooleanBinaryOperator[] ops = new BooleanBinaryOperator[BooleanBinaryOperator.Id.values().length];
        ops[BooleanBinaryOperator.Id.less.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return zero.isNegative(operand1 - operand2);
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return zero.isNegative(operand1[index1] - operand2[index2]);
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isNegative(operand1[index1] - operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.lessOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return !zero.isPositive(operand1 - operand2);
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return !zero.isPositive(operand1[index1] - operand2[index2]);
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !zero.isPositive(operand1[index1] - operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.equal.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return zero.isZero(operand1 - operand2);
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return zero.isZero(operand1[index1] - operand2[index2]);
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isZero(operand1[index1] - operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.unequal.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return zero.isNonZero(operand1 - operand2);
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return zero.isNonZero(operand1[index1] - operand2[index2]);
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isNonZero(operand1[index1] - operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.greaterOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return !zero.isNegative(operand1 - operand2);
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return !zero.isNegative(operand1[index1] - operand2[index2]);
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !zero.isNegative(operand1[index1] - operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.greater.ordinal()] = new AbstractBooleanBinaryOperator<Double, double[]>(){

            @Override
            public boolean booleanOperate(Double operand1, Double operand2) {
                return zero.isPositive(operand1 - operand2);
            }

            @Override
            public boolean booleanOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return zero.isPositive(operand1[index1] - operand2[index2]);
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = zero.isPositive(operand1[index1] - operand2[index2]);
            }
        };
        return DoubleOperators.checkComplete(ops, BooleanBinaryOperator.Id.values());
    }

    private static IntBinaryOperator<Double, double[]>[] initIntBinary() {
        IntBinaryOperator[] ops = new IntBinaryOperator[IntBinaryOperator.Id.values().length];
        ops[IntBinaryOperator.Id.compare.ordinal()] = new AbstractIntBinaryOperator<Double, double[]>(){

            @Override
            public int intOperate(Double operand1, Double operand2) {
                return operand1.compareTo(operand2);
            }

            @Override
            public int intOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return Double.compare(operand1[index1], operand2[index2]);
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, int[] dst, int dstIndex) {
                dst[dstIndex] = Double.compare(operand1[index1], operand2[index2]);
            }
        };
        return DoubleOperators.checkComplete(ops, IntBinaryOperator.Id.values());
    }

    private static IntBinaryOperator<Double, double[]>[] initIntBinary(final Zero zero) {
        IntBinaryOperator[] ops = new IntBinaryOperator[IntBinaryOperator.Id.values().length];
        ops[IntBinaryOperator.Id.compare.ordinal()] = new AbstractIntBinaryOperator<Double, double[]>(){

            @Override
            public int intOperate(Double operand1, Double operand2) {
                return zero.sgn(operand1 - operand2);
            }

            @Override
            public int intOperate(double[] operand1, int index1, double[] operand2, int index2) {
                return zero.sgn(operand1[index1] - operand2[index2]);
            }

            @Override
            public void operate(double[] operand1, int index1, double[] operand2, int index2, int[] dst, int dstIndex) {
                dst[dstIndex] = zero.sgn(operand1[index1] - operand2[index2]);
            }
        };
        return DoubleOperators.checkComplete(ops, IntBinaryOperator.Id.values());
    }

    private static AggregatingUnaryOperator<Double, double[]>[] initAggUnary() {
        AggregatingUnaryOperator[] ops = new AggregatingUnaryOperator[AggregatingUnaryOperator.Id.values().length];
        ops[AggregatingUnaryOperator.Id.min.ordinal()] = new DoubleAggregatingUnaryOperator(){

            protected double doubleOperate(double[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return Double.NaN;
                }
                double min = src[srcIndexFrom];
                int i = 1;
                while (i < length) {
                    min = Math.min(min, src[srcIndexFrom + i]);
                    ++i;
                }
                return min;
            }

            protected double doubleOperate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return Double.NaN;
                }
                double min = src[srcRowFrom][srcColFrom];
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        min = Math.min(min, src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return min;
            }
        };
        ops[AggregatingUnaryOperator.Id.max.ordinal()] = new DoubleAggregatingUnaryOperator(){

            protected double doubleOperate(double[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return Double.NaN;
                }
                double max = src[srcIndexFrom];
                int i = 1;
                while (i < length) {
                    max = Math.max(max, src[srcIndexFrom + i]);
                    ++i;
                }
                return max;
            }

            protected double doubleOperate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return Double.NaN;
                }
                double max = src[srcRowFrom][srcColFrom];
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        max = Math.max(max, src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return max;
            }
        };
        ops[AggregatingUnaryOperator.Id.sum.ordinal()] = new DoubleAggregatingUnaryOperator(){

            protected double doubleOperate(double[] src, int srcIndexFrom, int length) {
                double sum = 0.0;
                int i = 0;
                while (i < length) {
                    sum += src[srcIndexFrom + i];
                    ++i;
                }
                return sum;
            }

            protected double doubleOperate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                double sum = 0.0;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum += src[srcRowFrom + r][srcColFrom + c];
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.prod.ordinal()] = new DoubleAggregatingUnaryOperator(){

            protected double doubleOperate(double[] src, int srcIndexFrom, int length) {
                double sum = 1.0;
                int i = 0;
                while (i < length) {
                    sum *= src[srcIndexFrom + i];
                    ++i;
                }
                return sum;
            }

            protected double doubleOperate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                double sum = 1.0;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum *= src[srcRowFrom + r][srcColFrom + c];
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        final DoubleAggregatingUnaryOperator sumSquared = new DoubleAggregatingUnaryOperator(){

            protected double doubleOperate(double[] src, int srcIndexFrom, int length) {
                double sum = 0.0;
                int i = 0;
                while (i < length) {
                    double val = src[srcIndexFrom + i];
                    sum += val * val;
                    ++i;
                }
                return sum;
            }

            protected double doubleOperate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                double sum = 0.0;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        double val = src[srcRowFrom + r][srcColFrom + c];
                        sum += val * val;
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.sumSquared.ordinal()] = sumSquared;
        ops[AggregatingUnaryOperator.Id.normDivisor.ordinal()] = new DoubleAggregatingUnaryOperator(){

            protected double doubleOperate(double[] src, int srcIndexFrom, int length) {
                double sum2 = sumSquared.doubleOperate(src, srcIndexFrom, length);
                return Math.sqrt(sum2);
            }

            protected double doubleOperate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                double sum2 = sumSquared.doubleOperate(src, srcRowFrom, srcColFrom, rows, cols);
                return Math.sqrt(sum2);
            }
        };
        ops[AggregatingUnaryOperator.Id.squeezeDivisor.ordinal()] = new DoubleAggregatingUnaryOperator(){

            protected double doubleOperate(double[] src, int srcIndexFrom, int length) {
                double min = 0.0;
                int i = 0;
                while (i < length) {
                    double abs = Math.abs(src[srcIndexFrom + i]);
                    if (abs > 0.0) {
                        if (min == 0.0) {
                            min = abs;
                        } else if (min > abs) {
                            min = Math.min(min, abs);
                        }
                    }
                    ++i;
                }
                return min;
            }

            protected double doubleOperate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                double min = 0.0;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        double abs = Math.abs(src[srcRowFrom + r][srcColFrom + c]);
                        if (abs > 0.0) {
                            if (min == 0.0) {
                                min = abs;
                            } else if (min > abs) {
                                min = Math.min(min, abs);
                            }
                        }
                        ++c;
                    }
                    ++r;
                }
                return min;
            }
        };
        return DoubleOperators.checkComplete(ops, AggregatingUnaryOperator.Id.values());
    }

    private static AggregatingUnaryOperator<Double, double[]>[] initAggUnary(final Zero zero) {
        AggregatingUnaryOperator<Double, double[]>[] ops = DoubleOperators.initAggUnary();
        ops[AggregatingUnaryOperator.Id.squeezeDivisor.ordinal()] = new DoubleAggregatingUnaryOperator(){

            protected double doubleOperate(double[] src, int srcIndexFrom, int length) {
                double min = 0.0;
                int i = 0;
                while (i < length) {
                    double abs = Math.abs(zero.roundZero(src[srcIndexFrom + i]));
                    if (abs > 0.0) {
                        if (min == 0.0) {
                            min = abs;
                        } else if (min > abs) {
                            min = Math.min(min, abs);
                        }
                    }
                    ++i;
                }
                return min;
            }

            protected double doubleOperate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                double min = 0.0;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        double abs = Math.abs(zero.roundZero(src[srcRowFrom + r][srcColFrom + c]));
                        if (abs > 0.0) {
                            if (min == 0.0) {
                                min = abs;
                            } else if (min > abs) {
                                min = Math.min(min, abs);
                            }
                        }
                        ++c;
                    }
                    ++r;
                }
                return min;
            }
        };
        return DoubleOperators.checkComplete(ops, AggregatingUnaryOperator.Id.values());
    }

    private static AggregatingBinaryOperator<Double, double[]>[] initAggBinary() {
        AggregatingBinaryOperator[] ops = new AggregatingBinaryOperator[AggregatingBinaryOperator.Id.values().length];
        ops[AggregatingBinaryOperator.Id.innerProduct.ordinal()] = new DoubleAggregatingBinaryOperator(){

            protected double doubleOperate(double[] src1, int src1IndexFrom, double[] src2, int src2IndexFrom, int length) {
                double sum = 0.0;
                int i = 0;
                while (i < length) {
                    sum += src1[src1IndexFrom + i] * src2[src2IndexFrom + i];
                    ++i;
                }
                return sum;
            }

            protected double doubleOperate(double[][] src1, int src1RowFrom, int src1Col, double[] src2, int src2IndexFrom, int length) {
                double sum = 0.0;
                int i = 0;
                while (i < length) {
                    sum += src1[src1RowFrom + i][src1Col] * src2[src2IndexFrom + i];
                    ++i;
                }
                return sum;
            }

            protected double doubleOperate(double[][] src1, int src1RowFrom, int src1Col, double[][] src2, int src2RowFrom, int src2Col, int length) {
                double sum = 0.0;
                int i = 0;
                while (i < length) {
                    sum += src1[src1RowFrom + i][src1Col] * src2[src2RowFrom + i][src2Col];
                    ++i;
                }
                return sum;
            }
        };
        return DoubleOperators.checkComplete(ops, AggregatingBinaryOperator.Id.values());
    }

    private static <A> A[] checkComplete(A[] arr, Enum[] ids) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == null) {
                throw new RuntimeException("internal error, implementation missing for " + arr.getClass().getComponentType().getName() + " for constant " + ids[i]);
            }
            ++i;
        }
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DoubleAggregatingBinaryOperator
    implements AggregatingBinaryOperator<Double, double[]> {
        private DoubleAggregatingBinaryOperator() {
        }

        protected abstract double doubleOperate(double[] var1, int var2, double[] var3, int var4, int var5);

        protected abstract double doubleOperate(double[][] var1, int var2, int var3, double[] var4, int var5, int var6);

        protected abstract double doubleOperate(double[][] var1, int var2, int var3, double[][] var4, int var5, int var6, int var7);

        @Override
        public Double operate(double[] src1, int src1IndexFrom, double[] src2, int src2IndexFrom, int length) {
            return this.doubleOperate(src1, src1IndexFrom, src2, src2IndexFrom, length);
        }

        @Override
        public void operate(double[] src1, int src1IndexFrom, double[] src2, int src2IndexFrom, double[] dst, int dstIndex, int length) {
            dst[dstIndex] = this.doubleOperate(src1, src1IndexFrom, src2, src2IndexFrom, length);
        }

        public Double operate(double[][] src1, int src1RowFrom, int src1Col, double[] src2, int src2IndexFrom, int length) {
            return this.doubleOperate(src1, src1RowFrom, src1Col, src2, src2IndexFrom, length);
        }

        public void operate(double[][] src1, int src1RowFrom, int src1Col, double[] src2, int src2IndexFrom, double[] dst, int dstIndex, int length) {
            dst[dstIndex] = this.doubleOperate(src1, src1RowFrom, src1Col, src2, src2IndexFrom, length);
        }

        public Double operate(double[][] src1, int src1RowFrom, int src1Col, double[][] src2, int src2RowFrom, int src2Col, int length) {
            return this.doubleOperate(src1, src1RowFrom, src1Col, src2, src2RowFrom, src2Col, length);
        }

        public void operate(double[][] src1, int src1RowFrom, int src1Col, double[][] src2, int src2RowFrom, int src2Col, double[] dst, int dstIndex, int length) {
            dst[dstIndex] = this.doubleOperate(src1, src1RowFrom, src1Col, src2, src2RowFrom, src2Col, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DoubleAggregatingUnaryOperator
    implements AggregatingUnaryOperator<Double, double[]> {
        private DoubleAggregatingUnaryOperator() {
        }

        protected abstract double doubleOperate(double[] var1, int var2, int var3);

        protected abstract double doubleOperate(double[][] var1, int var2, int var3, int var4, int var5);

        @Override
        public Double operate(double[] src, int srcIndexFrom, int srcIndexTo) {
            return this.doubleOperate(src, srcIndexFrom, srcIndexTo);
        }

        @Override
        public void operate(double[] src, int srcIndexFrom, int srcIndexTo, double[] dst, int dstIndex) {
            dst[dstIndex] = this.doubleOperate(src, srcIndexFrom, srcIndexTo);
        }

        public Double operate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
            return this.doubleOperate(src, srcRowFrom, srcColFrom, rows, cols);
        }

        public void operate(double[][] src, int srcRowFrom, int srcColFrom, int rows, int cols, double[] dst, int dstIndex) {
            dst[dstIndex] = this.doubleOperate(src, srcRowFrom, srcColFrom, rows, cols);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleConstOperator
    extends AbstractNullaryOperator<Double, double[]> {
        private final double value;

        public DoubleConstOperator(double value) {
            this.value = value;
        }

        @Override
        public Double operate() {
            return this.value;
        }

        @Override
        public void operate(double[] dst, int dstIndex) {
            dst[dstIndex] = this.value;
        }
    }
}

