/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.operator.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.impl.DefaultArrayOperations;
import ch.javasoft.math.linalg.DefaultLinAlgOperations;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.linalg.impl.BigIntegerGaussPivoting;
import ch.javasoft.math.operator.AbstractBinaryOperator;
import ch.javasoft.math.operator.AbstractBooleanBinaryOperator;
import ch.javasoft.math.operator.AbstractBooleanUnaryOperator;
import ch.javasoft.math.operator.AbstractIntBinaryOperator;
import ch.javasoft.math.operator.AbstractIntUnaryOperator;
import ch.javasoft.math.operator.AbstractNullaryOperator;
import ch.javasoft.math.operator.AbstractUnaryOperator;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanBinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.ConvertingUnaryOperator;
import ch.javasoft.math.operator.DivisionSupport;
import ch.javasoft.math.operator.IntBinaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerOperators
implements NumberOperators<BigInteger, BigInteger[]> {
    public static final BigIntegerOperators INTEGER_DIVISION_INSTANCE = new BigIntegerOperators(DivisionMode.Integer, ConversionMode.Truncate);
    public static final BigIntegerOperators NO_DIVISION_INSTANCE = new BigIntegerOperators(DivisionMode.None, ConversionMode.Exact);
    public static final BigIntegerOperators EXACT_DIVISION_INSTANCE = new BigIntegerOperators(DivisionMode.Exact, ConversionMode.Exact);
    public static final BigIntegerOperators ROUNDED_DIVISION_INSTANCE = new BigIntegerOperators(DivisionMode.Round, ConversionMode.Round);
    private final LinAlgOperations<BigInteger, BigInteger[]> linAlgOps;
    private final DivisionMode divisionMode;
    private final ConversionMode conversionMode;
    private final NullaryOperator<BigInteger, BigInteger[]>[] nullary;
    private final UnaryOperator<BigInteger, BigInteger[]>[] unary;
    private final BooleanUnaryOperator<BigInteger, BigInteger[]>[] boolUnary;
    private final IntUnaryOperator<BigInteger, BigInteger[]>[] intUnary;
    private final ConvertingUnaryOperator<Number, Number[], BigInteger, BigInteger[]> converter;
    private final BinaryOperator<BigInteger, BigInteger[]>[] binary;
    private final BooleanBinaryOperator<BigInteger, BigInteger[]>[] boolBinary;
    private final IntBinaryOperator<BigInteger, BigInteger[]>[] intBinary;
    private final AggregatingUnaryOperator<BigInteger, BigInteger[]>[] aggUnary;
    private final AggregatingBinaryOperator<BigInteger, BigInteger[]>[] aggBinary;

    public BigIntegerOperators(DivisionMode divMode, ConversionMode convMode) {
        this.divisionMode = divMode;
        this.conversionMode = convMode;
        this.nullary = BigIntegerOperators.initNullary();
        this.unary = BigIntegerOperators.initUnary(divMode);
        this.boolUnary = BigIntegerOperators.initBoolUnary();
        this.intUnary = BigIntegerOperators.initIntUnary();
        this.converter = this.initConverter(convMode);
        this.binary = BigIntegerOperators.initBinary(divMode);
        this.boolBinary = BigIntegerOperators.initBoolBinary();
        this.intBinary = BigIntegerOperators.initIntBinary();
        this.aggUnary = BigIntegerOperators.initAggUnary();
        this.aggBinary = BigIntegerOperators.initAggBinary();
        this.linAlgOps = new DefaultLinAlgOperations<BigInteger, BigInteger[]>(this, new DefaultArrayOperations((Class<C[]>)BigInteger[].class), BigIntegerGaussPivoting.LEN_L);
    }

    @Override
    public Class<BigInteger> numberClass() {
        return BigInteger.class;
    }

    @Override
    public Class<BigInteger[]> arrayClass() {
        return BigInteger[].class;
    }

    public DivisionMode getDivisionMode() {
        return this.divisionMode;
    }

    @Override
    public LinAlgOperations<BigInteger, BigInteger[]> getLinAlgOperations() {
        return this.linAlgOps;
    }

    @Override
    public LinAlgOperations<BigInteger, BigInteger[]> getLinAlgOperations(GaussPivotingFactory<BigInteger, BigInteger[]> gaussPivotingFactory) {
        return new DefaultLinAlgOperations<BigInteger, BigInteger[]>(this.getNumberArrayOperations(), gaussPivotingFactory);
    }

    @Override
    public ArrayOperations<BigInteger[]> getArrayOperations() {
        return this.linAlgOps.getArrayOperations();
    }

    @Override
    public NumberArrayOperations<BigInteger, BigInteger[]> getNumberArrayOperations() {
        return this.linAlgOps.getNumberArrayOperations();
    }

    public ConversionMode getConversionMode() {
        return this.conversionMode;
    }

    @Override
    public DivisionSupport getDivisionSupport() {
        return this.divisionMode;
    }

    @Override
    public BigInteger zero() {
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger one() {
        return BigInteger.ONE;
    }

    @Override
    public NullaryOperator<BigInteger, BigInteger[]> constant(BigInteger value) {
        if (value.equals(BigInteger.ZERO)) {
            return this.nullary(NullaryOperator.Id.zero);
        }
        if (value.equals(BigInteger.ONE)) {
            return this.nullary(NullaryOperator.Id.one);
        }
        return new BigIntegerConstOperator(value);
    }

    @Override
    public ConvertingUnaryOperator<Number, Number[], BigInteger, BigInteger[]> converter() {
        return this.converter;
    }

    @Override
    public NullaryOperator<BigInteger, BigInteger[]> nullary(NullaryOperator.Id id) {
        return this.nullary[id.ordinal()];
    }

    @Override
    public UnaryOperator<BigInteger, BigInteger[]> unary(UnaryOperator.Id id) {
        return this.unary[id.ordinal()];
    }

    @Override
    public BooleanUnaryOperator<BigInteger, BigInteger[]> booleanUnary(BooleanUnaryOperator.Id id) {
        return this.boolUnary[id.ordinal()];
    }

    @Override
    public IntUnaryOperator<BigInteger, BigInteger[]> intUnary(IntUnaryOperator.Id id) {
        return this.intUnary[id.ordinal()];
    }

    @Override
    public BinaryOperator<BigInteger, BigInteger[]> binary(BinaryOperator.Id id) {
        return this.binary[id.ordinal()];
    }

    @Override
    public BooleanBinaryOperator<BigInteger, BigInteger[]> booleanBinary(BooleanBinaryOperator.Id id) {
        return this.boolBinary[id.ordinal()];
    }

    @Override
    public IntBinaryOperator<BigInteger, BigInteger[]> intBinary(IntBinaryOperator.Id id) {
        return this.intBinary[id.ordinal()];
    }

    @Override
    public AggregatingUnaryOperator<BigInteger, BigInteger[]> aggregatingUnary(AggregatingUnaryOperator.Id id) {
        return this.aggUnary[id.ordinal()];
    }

    @Override
    public AggregatingBinaryOperator<BigInteger, BigInteger[]> aggregatingBinary(AggregatingBinaryOperator.Id id) {
        return this.aggBinary[id.ordinal()];
    }

    private static NullaryOperator<BigInteger, BigInteger[]>[] initNullary() {
        NullaryOperator[] ops = new NullaryOperator[NullaryOperator.Id.values().length];
        ops[NullaryOperator.Id.zero.ordinal()] = new BigIntegerConstOperator(BigInteger.ZERO);
        ops[NullaryOperator.Id.one.ordinal()] = new BigIntegerConstOperator(BigInteger.ONE);
        ops[NullaryOperator.Id.random.ordinal()] = new AbstractNullaryOperator<BigInteger, BigInteger[]>(){
            private final Random rnd = new Random();

            @Override
            public BigInteger operate() {
                return BigInteger.valueOf(this.rnd.nextLong());
            }

            @Override
            public void operate(BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = BigInteger.valueOf(this.rnd.nextLong());
            }
        };
        return BigIntegerOperators.checkComplete(ops, NullaryOperator.Id.values());
    }

    private static UnaryOperator<BigInteger, BigInteger[]>[] initUnary(final DivisionMode divMode) {
        UnaryOperator[] ops = new UnaryOperator[UnaryOperator.Id.values().length];
        ops[UnaryOperator.Id.identity.ordinal()] = new AbstractUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand) {
                return operand;
            }

            @Override
            public BigInteger operate(BigInteger[] src, int srcIndex) {
                return src[srcIndex];
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex];
            }
        };
        ops[UnaryOperator.Id.normalize.ordinal()] = ops[UnaryOperator.Id.identity.ordinal()];
        ops[UnaryOperator.Id.abs.ordinal()] = new AbstractUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand) {
                return operand.abs();
            }

            @Override
            public BigInteger operate(BigInteger[] src, int srcIndex) {
                return src[srcIndex].abs();
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].abs();
            }
        };
        ops[UnaryOperator.Id.negate.ordinal()] = new AbstractUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand) {
                return operand.negate();
            }

            @Override
            public BigInteger operate(BigInteger[] src, int srcIndex) {
                return src[srcIndex].negate();
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].negate();
            }
        };
        ops[UnaryOperator.Id.invert.ordinal()] = new AbstractUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand) {
                return divMode.divide(BigInteger.ONE, operand);
            }

            @Override
            public BigInteger operate(BigInteger[] src, int srcIndex) {
                return divMode.divide(BigInteger.ONE, src[srcIndex]);
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = divMode.divide(BigInteger.ONE, src[srcIndex]);
            }
        };
        ops[UnaryOperator.Id.square.ordinal()] = new AbstractUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand) {
                return operand.pow(2);
            }

            @Override
            public BigInteger operate(BigInteger[] src, int srcIndex) {
                return src[srcIndex].pow(2);
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].pow(2);
            }
        };
        return BigIntegerOperators.checkComplete(ops, UnaryOperator.Id.values());
    }

    private static IntUnaryOperator<BigInteger, BigInteger[]>[] initIntUnary() {
        IntUnaryOperator[] ops = new IntUnaryOperator[IntUnaryOperator.Id.values().length];
        ops[IntUnaryOperator.Id.signum.ordinal()] = new AbstractIntUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public int intOperate(BigInteger operand) {
                return operand.signum();
            }

            @Override
            public int intOperate(BigInteger[] operand, int index) {
                return operand[index].signum();
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, int[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum();
            }
        };
        return BigIntegerOperators.checkComplete(ops, IntUnaryOperator.Id.values());
    }

    private ConvertingUnaryOperator<Number, Number[], BigInteger, BigInteger[]> initConverter(final ConversionMode convMode) {
        return new ConvertingUnaryOperator<Number, Number[], BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(Number operand) {
                return convMode.convert(operand);
            }

            @Override
            public void operate(Number[] src, int srcIndex, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = convMode.convert(src[srcIndex]);
            }
        };
    }

    private static BooleanUnaryOperator<BigInteger, BigInteger[]>[] initBoolUnary() {
        BooleanUnaryOperator[] ops = new BooleanUnaryOperator[BooleanUnaryOperator.Id.values().length];
        ops[BooleanUnaryOperator.Id.isZero.ordinal()] = new AbstractBooleanUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand) {
                return BigInteger.ZERO.equals(operand);
            }

            @Override
            public boolean booleanOperate(BigInteger[] src, int srcIndex) {
                return BigInteger.ZERO.equals(src[srcIndex]);
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = BigInteger.ZERO.equals(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isNonZero.ordinal()] = new AbstractBooleanUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand) {
                return !BigInteger.ZERO.equals(operand);
            }

            @Override
            public boolean booleanOperate(BigInteger[] src, int srcIndex) {
                return !BigInteger.ZERO.equals(src[srcIndex]);
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !BigInteger.ZERO.equals(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isOne.ordinal()] = new AbstractBooleanUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand) {
                return BigInteger.ONE.equals(operand);
            }

            @Override
            public boolean booleanOperate(BigInteger[] src, int srcIndex) {
                return BigInteger.ONE.equals(src[srcIndex]);
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = BigInteger.ONE.equals(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isPositive.ordinal()] = new AbstractBooleanUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand) {
                return operand.signum() > 0;
            }

            @Override
            public boolean booleanOperate(BigInteger[] src, int srcIndex) {
                return src[srcIndex].signum() > 0;
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum() > 0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNegative.ordinal()] = new AbstractBooleanUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand) {
                return operand.signum() < 0;
            }

            @Override
            public boolean booleanOperate(BigInteger[] src, int srcIndex) {
                return src[srcIndex].signum() < 0;
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum() < 0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNonPositive.ordinal()] = new AbstractBooleanUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand) {
                return operand.signum() <= 0;
            }

            @Override
            public boolean booleanOperate(BigInteger[] src, int srcIndex) {
                return src[srcIndex].signum() <= 0;
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum() <= 0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNonNegative.ordinal()] = new AbstractBooleanUnaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand) {
                return operand.signum() >= 0;
            }

            @Override
            public boolean booleanOperate(BigInteger[] src, int srcIndex) {
                return src[srcIndex].signum() >= 0;
            }

            @Override
            public void operate(BigInteger[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum() >= 0;
            }
        };
        return BigIntegerOperators.checkComplete(ops, BooleanUnaryOperator.Id.values());
    }

    private static BinaryOperator<BigInteger, BigInteger[]>[] initBinary(final DivisionMode divMode) {
        BinaryOperator[] ops = new BinaryOperator[BinaryOperator.Id.values().length];
        ops[BinaryOperator.Id.add.ordinal()] = new AbstractBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand1, BigInteger operand2) {
                return operand1.add(operand2);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].add(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.subtract.ordinal()] = new AbstractBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand1, BigInteger operand2) {
                return operand1.subtract(operand2);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].subtract(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.multiply.ordinal()] = new AbstractBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand1, BigInteger operand2) {
                return operand1.multiply(operand2);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].multiply(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.divide.ordinal()] = new AbstractBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand1, BigInteger operand2) {
                return divMode.divide(operand1, operand2);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = divMode.divide(operand1[index1], operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.min.ordinal()] = new AbstractBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand1, BigInteger operand2) {
                return operand1.min(operand2);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].min(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.max.ordinal()] = new AbstractBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public BigInteger operate(BigInteger operand1, BigInteger operand2) {
                return operand1.max(operand2);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, BigInteger[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].max(operand2[index2]);
            }
        };
        return BigIntegerOperators.checkComplete(ops, BinaryOperator.Id.values());
    }

    private static BooleanBinaryOperator<BigInteger, BigInteger[]>[] initBoolBinary() {
        BooleanBinaryOperator[] ops = new BooleanBinaryOperator[BooleanBinaryOperator.Id.values().length];
        ops[BooleanBinaryOperator.Id.less.ordinal()] = new AbstractBooleanBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand1, BigInteger operand2) {
                return operand1.compareTo(operand2) < 0;
            }

            @Override
            public boolean booleanOperate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) < 0;
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) < 0;
            }
        };
        ops[BooleanBinaryOperator.Id.lessOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand1, BigInteger operand2) {
                return operand1.compareTo(operand2) <= 0;
            }

            @Override
            public boolean booleanOperate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) <= 0;
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) <= 0;
            }
        };
        ops[BooleanBinaryOperator.Id.equal.ordinal()] = new AbstractBooleanBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand1, BigInteger operand2) {
                return operand1.equals(operand2);
            }

            @Override
            public boolean booleanOperate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2) {
                return operand1[index1].equals(operand2[index2]);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].equals(operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.unequal.ordinal()] = new AbstractBooleanBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand1, BigInteger operand2) {
                return !operand1.equals(operand2);
            }

            @Override
            public boolean booleanOperate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2) {
                return !operand1[index1].equals(operand2[index2]);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !operand1[index1].equals(operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.greaterOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand1, BigInteger operand2) {
                return operand1.compareTo(operand2) >= 0;
            }

            @Override
            public boolean booleanOperate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) >= 0;
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) >= 0;
            }
        };
        ops[BooleanBinaryOperator.Id.greater.ordinal()] = new AbstractBooleanBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public boolean booleanOperate(BigInteger operand1, BigInteger operand2) {
                return operand1.compareTo(operand2) > 0;
            }

            @Override
            public boolean booleanOperate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) > 0;
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) > 0;
            }
        };
        return BigIntegerOperators.checkComplete(ops, BooleanBinaryOperator.Id.values());
    }

    private static IntBinaryOperator<BigInteger, BigInteger[]>[] initIntBinary() {
        IntBinaryOperator[] ops = new IntBinaryOperator[IntBinaryOperator.Id.values().length];
        ops[IntBinaryOperator.Id.compare.ordinal()] = new AbstractIntBinaryOperator<BigInteger, BigInteger[]>(){

            @Override
            public int intOperate(BigInteger operand1, BigInteger operand2) {
                return operand1.compareTo(operand2);
            }

            @Override
            public int intOperate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]);
            }

            @Override
            public void operate(BigInteger[] operand1, int index1, BigInteger[] operand2, int index2, int[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]);
            }
        };
        return BigIntegerOperators.checkComplete(ops, IntBinaryOperator.Id.values());
    }

    private static AggregatingUnaryOperator<BigInteger, BigInteger[]>[] initAggUnary() {
        AggregatingUnaryOperator[] ops = new AggregatingUnaryOperator[AggregatingUnaryOperator.Id.values().length];
        ops[AggregatingUnaryOperator.Id.min.ordinal()] = new BigIntegerAggregatingUnaryOperator(){

            public BigInteger operate(BigInteger[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return null;
                }
                BigInteger min = src[srcIndexFrom];
                int i = 1;
                while (i < length) {
                    min = min.min(src[srcIndexFrom + i]);
                    ++i;
                }
                return min;
            }

            public BigInteger operate(BigInteger[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return null;
                }
                BigInteger min = src[srcRowFrom][srcColFrom];
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        min = min.min(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return min;
            }
        };
        ops[AggregatingUnaryOperator.Id.max.ordinal()] = new BigIntegerAggregatingUnaryOperator(){

            public BigInteger operate(BigInteger[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return null;
                }
                BigInteger max = src[srcIndexFrom];
                int i = 1;
                while (i < length) {
                    max = max.max(src[srcIndexFrom + i]);
                    ++i;
                }
                return max;
            }

            public BigInteger operate(BigInteger[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return null;
                }
                BigInteger max = src[srcRowFrom][srcColFrom];
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        max = max.max(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return max;
            }
        };
        ops[AggregatingUnaryOperator.Id.sum.ordinal()] = new BigIntegerAggregatingUnaryOperator(){

            public BigInteger operate(BigInteger[] src, int srcIndexFrom, int length) {
                BigInteger sum = BigInteger.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src[srcIndexFrom + i]);
                    ++i;
                }
                return sum;
            }

            public BigInteger operate(BigInteger[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                BigInteger sum = BigInteger.ZERO;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = sum.add(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.prod.ordinal()] = new BigIntegerAggregatingUnaryOperator(){

            public BigInteger operate(BigInteger[] src, int srcIndexFrom, int length) {
                BigInteger sum = BigInteger.ONE;
                int i = 0;
                while (i < length) {
                    sum = sum.multiply(src[srcIndexFrom + i]);
                    ++i;
                }
                return sum;
            }

            public BigInteger operate(BigInteger[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                BigInteger sum = BigInteger.ONE;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = sum.multiply(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.sumSquared.ordinal()] = new BigIntegerAggregatingUnaryOperator(){

            public BigInteger operate(BigInteger[] src, int srcIndexFrom, int length) {
                BigInteger sum = BigInteger.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src[srcIndexFrom + i].pow(2));
                    ++i;
                }
                return sum;
            }

            public BigInteger operate(BigInteger[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                BigInteger sum = BigInteger.ZERO;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = sum.add(src[srcRowFrom + r][srcColFrom + c].pow(2));
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.normDivisor.ordinal()] = new BigIntegerAggregatingUnaryOperator(){

            public BigInteger operate(BigInteger[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return BigInteger.ZERO;
                }
                BigInteger gcd = src[srcIndexFrom].abs();
                int i = 1;
                while (i < length) {
                    BigInteger val = src[srcIndexFrom + i];
                    if (gcd.equals(BigInteger.ONE)) break;
                    gcd = gcd.gcd(val);
                    ++i;
                }
                return gcd.signum() == 0 ? BigInteger.ZERO : gcd;
            }

            public BigInteger operate(BigInteger[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return BigInteger.ZERO;
                }
                BigInteger gcd = src[srcRowFrom][srcColFrom].abs();
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        BigInteger val = src[srcRowFrom + r][srcColFrom + c];
                        if (gcd.equals(BigInteger.ONE)) break;
                        gcd = gcd.gcd(val);
                        ++c;
                    }
                    ++r;
                }
                return gcd.signum() == 0 ? BigInteger.ZERO : gcd;
            }
        };
        ops[AggregatingUnaryOperator.Id.squeezeDivisor.ordinal()] = ops[AggregatingUnaryOperator.Id.normDivisor.ordinal()];
        return BigIntegerOperators.checkComplete(ops, AggregatingUnaryOperator.Id.values());
    }

    private static AggregatingBinaryOperator<BigInteger, BigInteger[]>[] initAggBinary() {
        AggregatingBinaryOperator[] ops = new AggregatingBinaryOperator[AggregatingBinaryOperator.Id.values().length];
        ops[AggregatingBinaryOperator.Id.innerProduct.ordinal()] = new BigIntegerAggregatingBinaryOperator(){

            public BigInteger operate(BigInteger[] src1, int src1IndexFrom, BigInteger[] src2, int src2IndexFrom, int length) {
                BigInteger sum = BigInteger.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src1[src1IndexFrom + i].multiply(src2[src2IndexFrom + i]));
                    ++i;
                }
                return sum;
            }

            public BigInteger operate(BigInteger[][] src1, int src1RowFrom, int src1Col, BigInteger[] src2, int src2IndexFrom, int length) {
                BigInteger sum = BigInteger.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src1[src1RowFrom + i][src1Col].multiply(src2[src2IndexFrom + i]));
                    ++i;
                }
                return sum;
            }

            public BigInteger operate(BigInteger[][] src1, int src1RowFrom, int src1Col, BigInteger[][] src2, int src2RowFrom, int src2Col, int length) {
                BigInteger sum = BigInteger.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src1[src1RowFrom + i][src1Col].multiply(src2[src2RowFrom + i][src2Col]));
                    ++i;
                }
                return sum;
            }
        };
        return BigIntegerOperators.checkComplete(ops, AggregatingBinaryOperator.Id.values());
    }

    private static <A> A[] checkComplete(A[] arr, Enum[] ids) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == null) {
                throw new RuntimeException("internal error, implementation missing for " + arr.getClass().getComponentType().getName() + " for constant " + ids[i]);
            }
            ++i;
        }
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BigIntegerAggregatingBinaryOperator
    implements AggregatingBinaryOperator<BigInteger, BigInteger[]> {
        private BigIntegerAggregatingBinaryOperator() {
        }

        @Override
        public void operate(BigInteger[] src1, int src1IndexFrom, BigInteger[] src2, int src2IndexFrom, BigInteger[] dst, int dstIndex, int length) {
            dst[dstIndex] = (BigInteger)this.operate(src1, src1IndexFrom, src2, src2IndexFrom, length);
        }

        public void operate(BigInteger[][] src1, int src1RowFrom, int src1Col, BigInteger[] src2, int src2IndexFrom, BigInteger[] dst, int dstIndex, int length) {
            dst[dstIndex] = (BigInteger)this.operate((A[])src1, src1RowFrom, src1Col, src2, src2IndexFrom, length);
        }

        public void operate(BigInteger[][] src1, int src1RowFrom, int src1Col, BigInteger[][] src2, int src2RowFrom, int src2Col, BigInteger[] dst, int dstIndex, int length) {
            dst[dstIndex] = (BigInteger)this.operate((A[])src1, src1RowFrom, src1Col, (A[])src2, src2RowFrom, src2Col, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BigIntegerAggregatingUnaryOperator
    implements AggregatingUnaryOperator<BigInteger, BigInteger[]> {
        private BigIntegerAggregatingUnaryOperator() {
        }

        @Override
        public void operate(BigInteger[] src, int srcIndexFrom, int srcIndexTo, BigInteger[] dst, int dstIndex) {
            dst[dstIndex] = (BigInteger)this.operate(src, srcIndexFrom, srcIndexTo);
        }

        public void operate(BigInteger[][] src, int srcRowFrom, int srcColFrom, int rows, int cols, BigInteger[] dst, int dstIndex) {
            dst[dstIndex] = (BigInteger)this.operate((A[])src, srcRowFrom, srcColFrom, rows, cols);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigIntegerConstOperator
    extends AbstractNullaryOperator<BigInteger, BigInteger[]> {
        private final BigInteger value;

        public BigIntegerConstOperator(BigInteger value) {
            this.value = value;
        }

        @Override
        public BigInteger operate() {
            return this.value;
        }

        @Override
        public void operate(BigInteger[] dst, int dstIndex) {
            dst[dstIndex] = this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConversionMode {
        Exact{

            public BigInteger convert(Number value) {
                if (value instanceof BigInteger) {
                    return (BigInteger)value;
                }
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).toBigIntegerExact();
                }
                if (value instanceof BigFraction) {
                    return ((BigFraction)value).toBigIntegerExact();
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof AtomicInteger || value instanceof AtomicLong) {
                    return BigInteger.valueOf(value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return BigDecimal.valueOf(value.doubleValue()).toBigIntegerExact();
                }
                return new BigInteger(value.toString());
            }
        }
        ,
        Truncate{

            public BigInteger convert(Number value) {
                if (value instanceof BigInteger) {
                    return (BigInteger)value;
                }
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).toBigInteger();
                }
                if (value instanceof BigFraction) {
                    return ((BigFraction)value).toBigInteger();
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof AtomicInteger || value instanceof AtomicLong) {
                    return BigInteger.valueOf(value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return BigDecimal.valueOf(value.doubleValue()).toBigInteger();
                }
                return new BigInteger(value.toString());
            }
        }
        ,
        Round{

            public BigInteger convertBigDecimal(BigDecimal value) {
                return value.divide(BigDecimal.ONE, 0, RoundingMode.HALF_EVEN).toBigIntegerExact();
            }

            public BigInteger convert(Number value) {
                if (value instanceof BigInteger) {
                    return (BigInteger)value;
                }
                if (value instanceof BigDecimal) {
                    return this.convertBigDecimal((BigDecimal)value);
                }
                if (value instanceof BigFraction) {
                    return ((BigFraction)value).toBigInteger(RoundingMode.HALF_EVEN);
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof AtomicInteger || value instanceof AtomicLong) {
                    return BigInteger.valueOf(value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return this.convertBigDecimal(BigDecimal.valueOf(value.doubleValue()));
                }
                return new BigInteger(value.toString());
            }
        };


        public boolean conversionMightCauseException() {
            return Exact.equals((Object)this);
        }

        public abstract BigInteger convert(Number var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DivisionMode implements DivisionSupport
    {
        None{

            public BigInteger divide(BigInteger dividend, BigInteger divisor) {
                throw new ArithmeticException("division not supported");
            }
        }
        ,
        Exact{

            public BigInteger divide(BigInteger dividend, BigInteger divisor) {
                if (BigInteger.ZERO.equals(divisor)) {
                    throw new ArithmeticException("division by 0");
                }
                if (BigInteger.ONE.equals(divisor)) {
                    return dividend;
                }
                BigDecimal a = new BigDecimal(dividend);
                BigDecimal b = new BigDecimal(divisor);
                return a.divide(b, 0, RoundingMode.UNNECESSARY).toBigIntegerExact();
            }
        }
        ,
        Integer{

            public BigInteger divide(BigInteger dividend, BigInteger divisor) {
                return dividend.divide(divisor);
            }
        }
        ,
        Round{

            public BigInteger divide(BigInteger dividend, BigInteger divisor) {
                if (BigInteger.ZERO.equals(divisor)) {
                    throw new ArithmeticException("division by 0");
                }
                if (BigInteger.ONE.equals(divisor)) {
                    return dividend;
                }
                BigDecimal a = new BigDecimal(dividend);
                BigDecimal b = new BigDecimal(divisor);
                return a.divide(b, 0, RoundingMode.HALF_EVEN).toBigIntegerExact();
            }
        };


        @Override
        public boolean alwaysCausesException() {
            return None.equals(this);
        }

        @Override
        public boolean mightCauseException() {
            return None.equals(this) || Exact.equals(this);
        }

        @Override
        public boolean isExact() {
            return Exact.equals(this);
        }

        @Override
        public boolean isSufficientlyExact() {
            return Exact.equals(this);
        }

        public abstract BigInteger divide(BigInteger var1, BigInteger var2);
    }
}

