/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanBinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.ConvertingUnaryOperator;
import ch.javasoft.math.operator.DivisionSupport;
import ch.javasoft.math.operator.IntBinaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.UnaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NumberOperators<N extends Number, A> {
    public Class<N> numberClass();

    public Class<A> arrayClass();

    public DivisionSupport getDivisionSupport();

    public ArrayOperations<A> getArrayOperations();

    public NumberArrayOperations<N, A> getNumberArrayOperations();

    public LinAlgOperations<N, A> getLinAlgOperations();

    public LinAlgOperations<N, A> getLinAlgOperations(GaussPivotingFactory<N, A> var1);

    public N zero();

    public N one();

    public NullaryOperator<N, A> constant(N var1);

    public ConvertingUnaryOperator<Number, Number[], N, A> converter();

    public NullaryOperator<N, A> nullary(NullaryOperator.Id var1);

    public UnaryOperator<N, A> unary(UnaryOperator.Id var1);

    public IntUnaryOperator<N, A> intUnary(IntUnaryOperator.Id var1);

    public BooleanUnaryOperator<N, A> booleanUnary(BooleanUnaryOperator.Id var1);

    public BinaryOperator<N, A> binary(BinaryOperator.Id var1);

    public IntBinaryOperator<N, A> intBinary(IntBinaryOperator.Id var1);

    public BooleanBinaryOperator<N, A> booleanBinary(BooleanBinaryOperator.Id var1);

    public AggregatingUnaryOperator<N, A> aggregatingUnary(AggregatingUnaryOperator.Id var1);

    public AggregatingBinaryOperator<N, A> aggregatingBinary(AggregatingBinaryOperator.Id var1);
}

