/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.lang.management;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JVMTimer {
    private final long interval;
    private final ConcurrentMap<Long, ThreadTime> history = new ConcurrentHashMap<Long, ThreadTime>();
    private volatile Thread runner = null;

    public JVMTimer(long intervalMS) {
        this.interval = intervalMS;
    }

    public void start() {
        if (this.runner != null) {
            throw new IllegalStateException("already started");
        }
        this.runner = new Thread(){

            public void run() {
                while (JVMTimer.this.runner != null) {
                    JVMTimer.this.update();
                    try {
                        1.sleep(JVMTimer.this.interval);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        };
        this.runner.setDaemon(true);
        this.runner.start();
    }

    public void stop() {
        Thread r = this.runner;
        this.runner = null;
        if (r != null) {
            try {
                r.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void update() {
        long[] ids;
        long threadId = Thread.currentThread().getId();
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] lArray = ids = bean.getAllThreadIds();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            if (id != threadId) {
                long c = bean.getThreadCpuTime(id);
                long u = bean.getThreadUserTime(id);
                if (c != -1L && u != -1L) {
                    ThreadTime times = (ThreadTime)this.history.get(id);
                    if (times == null) {
                        times = new ThreadTime(id, c, u);
                        this.history.put(id, times);
                    } else {
                        times.endCpuTime = c;
                        times.endUserTime = u;
                    }
                }
            }
            ++n2;
        }
    }

    public static long getProcessCpuTimeMS() {
        return JVMTimer.getProcessCpuTimeNS() / 1000000L;
    }

    public static long getProcessCpuTimeNS() {
        java.lang.management.OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        if (bean instanceof OperatingSystemMXBean) {
            return ((OperatingSystemMXBean)bean).getProcessCpuTime();
        }
        return 0L;
    }

    public long getTotalCpuTimeMS() {
        return this.getTotalCpuTimeNS() / 1000000L;
    }

    public long getTotalCpuTimeNS() {
        Collection hist = this.history.values();
        long time = 0L;
        for (ThreadTime times : hist) {
            time += times.endCpuTime - times.startCpuTime;
        }
        return time;
    }

    public long getTotalUserTimeMS() {
        return this.getTotalUserTimeNS() / 1000000L;
    }

    public long getTotalUserTimeNS() {
        Collection hist = this.history.values();
        long time = 0L;
        for (ThreadTime times : hist) {
            time += times.endUserTime - times.startUserTime;
        }
        return time;
    }

    public long getTotalSystemTimeMS() {
        return this.getTotalSystemTimeNS() / 1000000L;
    }

    public long getTotalSystemTimeNS() {
        Collection hist = this.history.values();
        long time = 0L;
        for (ThreadTime times : hist) {
            time += times.endCpuTime - times.startCpuTime - (times.endUserTime - times.startUserTime);
        }
        return time;
    }

    public String toString() {
        long cpu = this.getTotalCpuTimeMS();
        long user = this.getTotalUserTimeMS();
        return String.valueOf(this.getClass().getSimpleName()) + "[CPU=" + cpu + "ms, user=" + user + "ms, system=" + (cpu - user) + "ms]";
    }

    private static class ThreadTime {
        public final long id;
        public final long startCpuTime;
        public final long startUserTime;
        public volatile long endCpuTime;
        public volatile long endUserTime;

        public ThreadTime(long id, long c, long u) {
            this.id = id;
            this.startCpuTime = c;
            this.startUserTime = u;
            this.endCpuTime = c;
            this.endUserTime = u;
        }
    }
}

