/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.job.ExecException;
import ch.javasoft.job.ExecJobMonitor;
import ch.javasoft.job.ExecJobProcessor;
import ch.javasoft.job.Executable;
import ch.javasoft.job.ExitValueException;
import ch.javasoft.job.Job;
import ch.javasoft.job.JobResult;
import ch.javasoft.job.JobTerminationHandler;
import ch.javasoft.job.StdErrNonEmptyException;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecJob
implements Job<ExecJobMonitor>,
Executable<Void> {
    private final String[] mCmdArray;
    private final String[] mEnvp;
    private final File mDir;

    public ExecJob(String command) {
        this(command, null, null);
    }

    public ExecJob(String command, String[] envp) {
        this(command, envp, null);
    }

    public ExecJob(String command, File dir) {
        this(command, null, dir);
    }

    public ExecJob(String command, String[] envp, File dir) {
        this(command.split("\\s+"), envp, dir);
    }

    public ExecJob(String[] cmdarray) {
        this(cmdarray, null, null);
    }

    public ExecJob(String[] cmdarray, String[] envp) {
        this(cmdarray, envp, null);
    }

    public ExecJob(String[] cmdarray, File dir) {
        this(cmdarray, null, dir);
    }

    public ExecJob(String[] cmdarray, String[] envp, File dir) {
        if (cmdarray == null) {
            throw new NullPointerException();
        }
        this.mCmdArray = cmdarray;
        this.mEnvp = envp;
        this.mDir = dir;
    }

    public Object id() {
        return this;
    }

    @Override
    public ExecJobMonitor run() throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = this.mEnvp == null && this.mDir == null ? rt.exec(this.mCmdArray) : (this.mEnvp == null ? rt.exec(this.mCmdArray, null, this.mDir) : (this.mDir == null ? rt.exec(this.mCmdArray, this.mEnvp) : rt.exec(this.mCmdArray, this.mEnvp, this.mDir)));
        return new ExecJobMonitor(proc);
    }

    public ExecJobMonitor exec() {
        return ExecJobProcessor.INSTANCE.exec(this);
    }

    public ExecJobMonitor exec(JobTerminationHandler<Void> terminationHandler) {
        ExecJobProcessor proc = new ExecJobProcessor();
        proc.addJobTerminatedHandler(terminationHandler);
        return proc.exec(this);
    }

    @Override
    public JobResult<Void> execAndWait() throws InterruptedException {
        return ExecJobProcessor.INSTANCE.execAndWait(this);
    }

    @Override
    public Void execAndWaitThrowException() throws InterruptedException, Throwable {
        JobResult<Void> result = this.execAndWait();
        if (result.isException()) {
            throw result.getException();
        }
        return result.getResult();
    }

    public <E extends Throwable> void execWaitForResultThrowException(Class<E> exClass) throws E {
        this.exec().waitForResultThrowException(exClass);
    }

    public String execWaitForStdOutString() throws ExecException, ExitValueException, StdErrNonEmptyException, InterruptedException {
        return this.exec().waitForStdOutString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.mCmdArray.length) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.mCmdArray[i]);
            ++i;
        }
        return sb.toString();
    }
}

