/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset.search.tree;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.bitset.search.tree.InterNode;
import ch.javasoft.bitset.search.tree.Node;

public class LeafNode
implements Node {
    protected final IBitSet set;

    public LeafNode(IBitSet set) {
        this.set = set;
    }

    public Node add(IBitSet set, int bit) {
        if (this.set.equals(set)) {
            return null;
        }
        return InterNode.create(this, new LeafNode(set), bit);
    }

    public Node remove(IBitSet set) {
        return set.equals(this.set) ? Node.EMPTY : null;
    }

    public IBitSet findSubSet(IBitSet of) {
        return this.set.isSubSetOf(of) ? this.set : null;
    }

    public IBitSet findSubSet(IBitSet of, IBitSet after) {
        return this.set.isSubSetOf(of) && this.set.compareTo(after) > 0 ? this.set : null;
    }

    public IBitSet findSuperSet(IBitSet of) {
        return of.isSubSetOf(this.set) ? this.set : null;
    }

    public IBitSet findSuperSet(IBitSet of, IBitSet after) {
        return of.isSubSetOf(this.set) && this.set.compareTo(after) > 0 ? this.set : null;
    }

    public IBitSet union() {
        return this.set;
    }

    public IBitSet inter() {
        return this.set;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('{');
        sb.append(this.set);
        return sb.append('}').toString();
    }
}

