/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Stack;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.AreaNPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RefNPtg;
import org.apache.poi.hssf.record.formula.RefPtg;

public final class SharedFormulaRecord
extends Record {
    public static final short sid = 1212;
    private int field_1_first_row;
    private int field_2_last_row;
    private short field_3_first_column;
    private short field_4_last_column;
    private int field_5_reserved;
    private short field_6_expression_len;
    private Stack field_7_parsed_expr;

    public SharedFormulaRecord() {
    }

    public SharedFormulaRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 1212) {
            throw new RecordFormatException("Not a valid SharedFormula");
        }
    }

    public int getFirstRow() {
        return this.field_1_first_row;
    }

    public int getLastRow() {
        return this.field_2_last_row;
    }

    public short getFirstColumn() {
        return this.field_3_first_column;
    }

    public short getLastColumn() {
        return this.field_4_last_column;
    }

    public short getExpressionLength() {
        return this.field_6_expression_len;
    }

    public int serialize(int offset, byte[] data) {
        throw new UnsupportedOperationException("Cannot serialize a SharedFormulaRecord");
    }

    public int getRecordSize() {
        throw new UnsupportedOperationException("Cannot get the size for a SharedFormulaRecord");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SHARED FORMULA RECORD:" + Integer.toHexString(1212) + "]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(1212)).append("\n");
        buffer.append("    .first_row       = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        buffer.append("    .last_row    = ").append(Integer.toHexString(this.getLastRow())).append("\n");
        buffer.append("    .first_column       = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        buffer.append("    .last_column    = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        buffer.append("    .reserved    = ").append(Integer.toHexString(this.field_5_reserved)).append("\n");
        buffer.append("    .expressionlength= ").append(this.getExpressionLength()).append("\n");
        buffer.append("    .numptgsinarray  = ").append(this.field_7_parsed_expr.size()).append("\n");
        for (int k = 0; k < this.field_7_parsed_expr.size(); ++k) {
            buffer.append("Formula ").append(k).append("\n").append(this.field_7_parsed_expr.get(k).toString()).append("\n");
        }
        buffer.append("[/SHARED FORMULA RECORD]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 1212;
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_first_row = in.readUShort();
        this.field_2_last_row = in.readUShort();
        this.field_3_first_column = in.readUByte();
        this.field_4_last_column = in.readUByte();
        this.field_5_reserved = in.readShort();
        this.field_6_expression_len = in.readShort();
        this.field_7_parsed_expr = this.getParsedExpressionTokens(in);
    }

    private Stack getParsedExpressionTokens(RecordInputStream in) {
        Stack<Ptg> stack = new Stack<Ptg>();
        while (in.remaining() != 0) {
            Ptg ptg = Ptg.createPtg(in);
            stack.push(ptg);
        }
        return stack;
    }

    public boolean isFormulaInShared(FormulaRecord formula) {
        int formulaRow = formula.getRow();
        short formulaColumn = formula.getColumn();
        return this.getFirstRow() <= formulaRow && this.getLastRow() >= formulaRow && this.getFirstColumn() <= formulaColumn && this.getLastColumn() >= formulaColumn;
    }

    protected static Stack convertSharedFormulas(Stack ptgs, int formulaRow, int formulaColumn) {
        Stack<Ptg> newPtgStack = new Stack<Ptg>();
        if (ptgs != null) {
            for (int k = 0; k < ptgs.size(); ++k) {
                Ptg ptg = (Ptg)ptgs.get(k);
                byte originalOperandClass = -1;
                if (!ptg.isBaseToken()) {
                    originalOperandClass = ptg.getPtgClass();
                }
                if (ptg instanceof RefNPtg) {
                    RefNPtg refNPtg = (RefNPtg)ptg;
                    ptg = new RefPtg(SharedFormulaRecord.fixupRelativeRow(formulaRow, refNPtg.getRow(), refNPtg.isRowRelative()), SharedFormulaRecord.fixupRelativeColumn(formulaColumn, refNPtg.getColumn(), refNPtg.isColRelative()), refNPtg.isRowRelative(), refNPtg.isColRelative());
                } else if (ptg instanceof AreaNPtg) {
                    AreaNPtg areaNPtg = (AreaNPtg)ptg;
                    ptg = new AreaPtg(SharedFormulaRecord.fixupRelativeRow(formulaRow, areaNPtg.getFirstRow(), areaNPtg.isFirstRowRelative()), SharedFormulaRecord.fixupRelativeRow(formulaRow, areaNPtg.getLastRow(), areaNPtg.isLastRowRelative()), SharedFormulaRecord.fixupRelativeColumn(formulaColumn, areaNPtg.getFirstColumn(), areaNPtg.isFirstColRelative()), SharedFormulaRecord.fixupRelativeColumn(formulaColumn, areaNPtg.getLastColumn(), areaNPtg.isLastColRelative()), areaNPtg.isFirstRowRelative(), areaNPtg.isLastRowRelative(), areaNPtg.isFirstColRelative(), areaNPtg.isLastColRelative());
                }
                if (!ptg.isBaseToken()) {
                    ptg.setClass(originalOperandClass);
                }
                newPtgStack.add(ptg);
            }
        }
        return newPtgStack;
    }

    public void convertSharedFormulaRecord(FormulaRecord formula) {
        int formulaRow = formula.getRow();
        short formulaColumn = formula.getColumn();
        if (!this.isFormulaInShared(formula)) {
            throw new RuntimeException("Shared Formula Conversion: Coding Error");
        }
        formula.setExpressionLength(this.getExpressionLength());
        Stack newPtgStack = SharedFormulaRecord.convertSharedFormulas(this.field_7_parsed_expr, formulaRow, formulaColumn);
        formula.setParsedExpression(newPtgStack);
        formula.setSharedFormula(false);
    }

    private static int fixupRelativeColumn(int currentcolumn, int column, boolean relative) {
        if (relative) {
            return column + currentcolumn & 0xFF;
        }
        return column;
    }

    private static int fixupRelativeRow(int currentrow, int row, boolean relative) {
        if (relative) {
            return row + currentrow & 0xFFFF;
        }
        return row;
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object clone() {
        throw new UnsupportedOperationException("Cannot clone a SharedFormulaRecord");
    }
}

