/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.poi.hssf.model.OperandClassTransformer;
import org.apache.poi.hssf.model.ParseNode;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ErrPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MemAreaPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.ValueOperatorPtg;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class FormulaParser {
    public static final int FORMULA_TYPE_CELL = 0;
    public static final int FORMULA_TYPE_SHARED = 1;
    public static final int FORMULA_TYPE_ARRAY = 2;
    public static final int FORMULA_TYPE_CONDFOMRAT = 3;
    public static final int FORMULA_TYPE_NAMEDRANGE = 4;
    private final String formulaString;
    private final int formulaLength;
    private int pointer;
    private ParseNode _rootNode;
    private static final Pattern CELL_REFERENCE_PATTERN = Pattern.compile("(?:('?)[^:\\\\/\\?\\*\\[\\]]+\\1!)?\\$?[A-Za-z]+\\$?[\\d]+");
    private static char TAB = (char)9;
    private char look;
    private HSSFWorkbook book;

    public FormulaParser(String formula, HSSFWorkbook book) {
        this.formulaString = formula;
        this.pointer = 0;
        this.book = book;
        this.formulaLength = this.formulaString.length();
    }

    public static Ptg[] parse(String formula, HSSFWorkbook book) {
        FormulaParser fp = new FormulaParser(formula, book);
        fp.parse();
        return fp.getRPNPtg();
    }

    private void GetChar() {
        if (this.pointer > this.formulaLength) {
            throw new RuntimeException("too far");
        }
        this.look = this.pointer < this.formulaLength ? this.formulaString.charAt(this.pointer) : (char)'\u0000';
        ++this.pointer;
    }

    private RuntimeException expected(String s) {
        String msg = "Parse error near char " + (this.pointer - 1) + " '" + this.look + "'" + " in specified formula '" + this.formulaString + "'. Expected " + s;
        return new FormulaParseException(msg);
    }

    private boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$' || c == '_';
    }

    private boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean IsAlNum(char c) {
        return this.IsAlpha(c) || this.IsDigit(c);
    }

    private boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private void SkipWhite() {
        while (this.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char x) {
        if (this.look != x) {
            throw this.expected("'" + x + "'");
        }
        this.GetChar();
    }

    private String GetName() {
        StringBuffer Token = new StringBuffer();
        if (!this.IsAlpha(this.look) && this.look != '\'') {
            throw this.expected("Name");
        }
        if (this.look == '\'') {
            boolean done;
            this.Match('\'');
            boolean bl = done = this.look == '\'';
            while (!done) {
                Token.append(this.look);
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                done = this.look != '\'';
            }
        } else {
            while (this.IsAlNum(this.look)) {
                Token.append(this.look);
                this.GetChar();
            }
        }
        return Token.toString();
    }

    private String GetNum() {
        StringBuffer value = new StringBuffer();
        while (this.IsDigit(this.look)) {
            value.append(this.look);
            this.GetChar();
        }
        return value.length() == 0 ? null : value.toString();
    }

    private ParseNode parseFunctionOrIdentifier() {
        String name = this.GetName();
        if (this.look == '(') {
            return this.function(name);
        }
        return new ParseNode(this.parseIdentifier(name));
    }

    private Ptg parseIdentifier(String name) {
        if (this.look == ':' || this.look == '.') {
            this.GetChar();
            while (this.look == '.') {
                this.GetChar();
            }
            String first = name;
            String second = this.GetName();
            return new AreaPtg(first + ":" + second);
        }
        if (this.look == '!') {
            this.Match('!');
            String sheetName = name;
            String first = this.GetName();
            short externIdx = this.book.getExternalSheetIndex(this.book.getSheetIndex(sheetName));
            if (this.look == ':') {
                this.Match(':');
                String second = this.GetName();
                if (this.look == '!') {
                    this.Match('!');
                    String third = this.GetName();
                    if (!sheetName.equals(second)) {
                        throw new RuntimeException("Unhandled double sheet reference.");
                    }
                    return new Area3DPtg(first + ":" + third, externIdx);
                }
                return new Area3DPtg(first + ":" + second, externIdx);
            }
            return new Ref3DPtg(first, externIdx);
        }
        if (name.equalsIgnoreCase("TRUE") || name.equalsIgnoreCase("FALSE")) {
            return new BoolPtg(name.toUpperCase());
        }
        boolean cellRef = CELL_REFERENCE_PATTERN.matcher(name).matches();
        if (cellRef) {
            return new RefPtg(name);
        }
        for (int i = 0; i < this.book.getNumberOfNames(); ++i) {
            if (!this.book.getNameAt(i).getNameName().equalsIgnoreCase(name)) continue;
            return new NamePtg(name, this.book);
        }
        throw new FormulaParseException("Found reference to named range \"" + name + "\", but that named range wasn't defined!");
    }

    private ParseNode function(String name) {
        NamePtg nameToken = null;
        if (!AbstractFunctionPtg.isInternalFunctionName(name)) {
            nameToken = new NamePtg(name, this.book);
        }
        this.Match('(');
        ParseNode[] args = this.Arguments();
        this.Match(')');
        return this.getFunction(name, nameToken, args);
    }

    private ParseNode getFunction(String name, NamePtg namePtg, ParseNode[] args) {
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByName(name.toUpperCase());
        int numArgs = args.length;
        if (fm == null) {
            if (namePtg == null) {
                throw new IllegalStateException("NamePtg must be supplied for external functions");
            }
            ParseNode[] allArgs = new ParseNode[numArgs + 1];
            allArgs[0] = new ParseNode(namePtg);
            System.arraycopy(args, 0, allArgs, 1, numArgs);
            return new ParseNode((Ptg)new FuncVarPtg(name, (byte)(numArgs + 1)), allArgs);
        }
        if (namePtg != null) {
            throw new IllegalStateException("NamePtg no applicable to internal functions");
        }
        boolean isVarArgs = !fm.hasFixedArgsLength();
        int funcIx = fm.getIndex();
        this.validateNumArgs(args.length, fm);
        AbstractFunctionPtg retval = isVarArgs ? new FuncVarPtg(name, (byte)numArgs) : new FuncPtg(funcIx);
        return new ParseNode((Ptg)retval, args);
    }

    private void validateNumArgs(int numArgs, FunctionMetadata fm) {
        if (numArgs < fm.getMinParams()) {
            String msg = "Too few arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMinParams() : msg + "At least " + fm.getMinParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
        if (numArgs > fm.getMaxParams()) {
            String msg = "Too many arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMaxParams() : msg + "At most " + fm.getMaxParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
    }

    private static boolean isArgumentDelimiter(char ch) {
        return ch == ',' || ch == ')';
    }

    private ParseNode[] Arguments() {
        ArrayList<ParseNode> temp;
        block5: {
            temp = new ArrayList<ParseNode>(2);
            this.SkipWhite();
            if (this.look == ')') {
                return ParseNode.EMPTY_ARRAY;
            }
            boolean missedPrevArg = true;
            int numArgs = 0;
            while (true) {
                this.SkipWhite();
                if (FormulaParser.isArgumentDelimiter(this.look)) {
                    if (missedPrevArg) {
                        temp.add(new ParseNode(MissingArgPtg.instance));
                        ++numArgs;
                    }
                    if (this.look != ')') {
                        this.Match(',');
                        missedPrevArg = true;
                        continue;
                    }
                    break block5;
                }
                temp.add(this.comparisonExpression());
                ++numArgs;
                missedPrevArg = false;
                this.SkipWhite();
                if (!FormulaParser.isArgumentDelimiter(this.look)) break;
            }
            throw this.expected("',' or ')'");
        }
        ParseNode[] result = new ParseNode[temp.size()];
        temp.toArray(result);
        return result;
    }

    private ParseNode powerFactor() {
        ParseNode result = this.percentFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '^') {
                return result;
            }
            this.Match('^');
            ParseNode other = this.percentFactor();
            result = new ParseNode(PowerPtg.instance, result, other);
        }
    }

    private ParseNode percentFactor() {
        ParseNode result = this.parseSimpleFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '%') {
                return result;
            }
            this.Match('%');
            result = new ParseNode((Ptg)PercentPtg.instance, result);
        }
    }

    private ParseNode parseSimpleFactor() {
        this.SkipWhite();
        switch (this.look) {
            case '#': {
                return new ParseNode(this.parseErrorLiteral());
            }
            case '-': {
                this.Match('-');
                return new ParseNode((Ptg)UnaryMinusPtg.instance, this.powerFactor());
            }
            case '+': {
                this.Match('+');
                return new ParseNode((Ptg)UnaryPlusPtg.instance, this.powerFactor());
            }
            case '(': {
                this.Match('(');
                ParseNode inside = this.comparisonExpression();
                this.Match(')');
                return new ParseNode((Ptg)ParenthesisPtg.instance, inside);
            }
            case '\"': {
                return new ParseNode(this.parseStringLiteral());
            }
        }
        if (this.IsAlpha(this.look) || this.look == '\'') {
            return this.parseFunctionOrIdentifier();
        }
        return new ParseNode(this.parseNumber());
    }

    private Ptg parseNumber() {
        String number2 = null;
        String exponent = null;
        String number1 = this.GetNum();
        if (this.look == '.') {
            this.GetChar();
            number2 = this.GetNum();
        }
        if (this.look == 'E') {
            this.GetChar();
            String sign = "";
            if (this.look == '+') {
                this.GetChar();
            } else if (this.look == '-') {
                this.GetChar();
                sign = "-";
            }
            String number = this.GetNum();
            if (number == null) {
                throw this.expected("Integer");
            }
            exponent = sign + number;
        }
        if (number1 == null && number2 == null) {
            throw this.expected("Integer");
        }
        return FormulaParser.getNumberPtgFromString(number1, number2, exponent);
    }

    private ErrPtg parseErrorLiteral() {
        this.Match('#');
        String part1 = this.GetName().toUpperCase();
        switch (part1.charAt(0)) {
            case 'V': {
                if (part1.equals("VALUE")) {
                    this.Match('!');
                    return ErrPtg.VALUE_INVALID;
                }
                throw this.expected("#VALUE!");
            }
            case 'R': {
                if (part1.equals("REF")) {
                    this.Match('!');
                    return ErrPtg.REF_INVALID;
                }
                throw this.expected("#REF!");
            }
            case 'D': {
                if (part1.equals("DIV")) {
                    this.Match('/');
                    this.Match('0');
                    this.Match('!');
                    return ErrPtg.DIV_ZERO;
                }
                throw this.expected("#DIV/0!");
            }
            case 'N': {
                if (part1.equals("NAME")) {
                    this.Match('?');
                    return ErrPtg.NAME_INVALID;
                }
                if (part1.equals("NUM")) {
                    this.Match('!');
                    return ErrPtg.NUM_ERROR;
                }
                if (part1.equals("NULL")) {
                    this.Match('!');
                    return ErrPtg.NULL_INTERSECTION;
                }
                if (part1.equals("N")) {
                    this.Match('/');
                    if (this.look != 'A' && this.look != 'a') {
                        throw this.expected("#N/A");
                    }
                    this.Match(this.look);
                    return ErrPtg.N_A;
                }
                throw this.expected("#NAME?, #NUM!, #NULL! or #N/A");
            }
        }
        throw this.expected("#VALUE!, #REF!, #DIV/0!, #NAME?, #NUM!, #NULL! or #N/A");
    }

    private static Ptg getNumberPtgFromString(String number1, String number2, String exponent) {
        StringBuffer number = new StringBuffer();
        if (number2 == null) {
            int intVal;
            number.append(number1);
            if (exponent != null) {
                number.append('E');
                number.append(exponent);
            }
            String numberStr = number.toString();
            try {
                intVal = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException e) {
                return new NumberPtg(numberStr);
            }
            if (IntPtg.isInRange(intVal)) {
                return new IntPtg(intVal);
            }
            return new NumberPtg(numberStr);
        }
        if (number1 != null) {
            number.append(number1);
        }
        number.append('.');
        number.append(number2);
        if (exponent != null) {
            number.append('E');
            number.append(exponent);
        }
        return new NumberPtg(number.toString());
    }

    private StringPtg parseStringLiteral() {
        this.Match('\"');
        StringBuffer token = new StringBuffer();
        while (true) {
            if (this.look == '\"') {
                this.GetChar();
                if (this.look != '\"') break;
            }
            token.append(this.look);
            this.GetChar();
        }
        return new StringPtg(token.toString());
    }

    private ParseNode Term() {
        ParseNode result = this.powerFactor();
        while (true) {
            ValueOperatorPtg operator;
            this.SkipWhite();
            switch (this.look) {
                case '*': {
                    this.Match('*');
                    operator = MultiplyPtg.instance;
                    break;
                }
                case '/': {
                    this.Match('/');
                    operator = DividePtg.instance;
                    break;
                }
                default: {
                    return result;
                }
            }
            ParseNode other = this.powerFactor();
            result = new ParseNode(operator, result, other);
        }
    }

    private ParseNode comparisonExpression() {
        ParseNode result = this.concatExpression();
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case '<': 
                case '=': 
                case '>': {
                    Ptg comparisonToken = this.getComparisonToken();
                    ParseNode other = this.concatExpression();
                    result = new ParseNode(comparisonToken, result, other);
                    continue block3;
                }
            }
            break;
        }
        return result;
    }

    private Ptg getComparisonToken() {
        if (this.look == '=') {
            this.Match(this.look);
            return EqualPtg.instance;
        }
        boolean isGreater = this.look == '>';
        this.Match(this.look);
        if (isGreater) {
            if (this.look == '=') {
                this.Match('=');
                return GreaterEqualPtg.instance;
            }
            return GreaterThanPtg.instance;
        }
        switch (this.look) {
            case '=': {
                this.Match('=');
                return LessEqualPtg.instance;
            }
            case '>': {
                this.Match('>');
                return NotEqualPtg.instance;
            }
        }
        return LessThanPtg.instance;
    }

    private ParseNode concatExpression() {
        ParseNode result = this.additiveExpression();
        while (true) {
            this.SkipWhite();
            if (this.look != '&') break;
            this.Match('&');
            ParseNode other = this.additiveExpression();
            result = new ParseNode(ConcatPtg.instance, result, other);
        }
        return result;
    }

    private ParseNode additiveExpression() {
        ParseNode result = this.Term();
        while (true) {
            ValueOperatorPtg operator;
            this.SkipWhite();
            switch (this.look) {
                case '+': {
                    this.Match('+');
                    operator = AddPtg.instance;
                    break;
                }
                case '-': {
                    this.Match('-');
                    operator = SubtractPtg.instance;
                    break;
                }
                default: {
                    return result;
                }
            }
            ParseNode other = this.Term();
            result = new ParseNode(operator, result, other);
        }
    }

    public void parse() {
        this.pointer = 0;
        this.GetChar();
        this._rootNode = this.comparisonExpression();
        if (this.pointer <= this.formulaLength) {
            String msg = "Unused input [" + this.formulaString.substring(this.pointer - 1) + "] after attempting to parse the formula [" + this.formulaString + "]";
            throw new FormulaParseException(msg);
        }
    }

    public Ptg[] getRPNPtg() {
        return this.getRPNPtg(0);
    }

    public Ptg[] getRPNPtg(int formulaType) {
        OperandClassTransformer oct = new OperandClassTransformer(formulaType);
        oct.transformFormula(this._rootNode);
        return ParseNode.toTokenArray(this._rootNode);
    }

    public static String toFormulaString(HSSFWorkbook book, List lptgs) {
        String retval = null;
        if (lptgs == null || lptgs.size() == 0) {
            return "#NAME";
        }
        Ptg[] ptgs = new Ptg[lptgs.size()];
        ptgs = lptgs.toArray(ptgs);
        retval = FormulaParser.toFormulaString(book, ptgs);
        return retval;
    }

    public String toFormulaString(List lptgs) {
        return FormulaParser.toFormulaString(this.book, lptgs);
    }

    public static String toFormulaString(HSSFWorkbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            return "#NAME";
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < ptgs.length; ++i) {
            String[] operands;
            Ptg ptg = ptgs[i];
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof ParenthesisPtg) {
                String contents = (String)stack.pop();
                stack.push("(" + contents + ")");
                continue;
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isOptimizedIf() || attrPtg.isOptimizedChoose() || attrPtg.isGoto() || attrPtg.isSpace() || attrPtg.isSemiVolatile()) continue;
                if (attrPtg.isSum()) {
                    operands = FormulaParser.getOperands(stack, attrPtg.getNumberOfOperands());
                    stack.push(attrPtg.toFormulaString(operands));
                    continue;
                }
                throw new RuntimeException("Unexpected tAttr: " + attrPtg.toString());
            }
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg.toFormulaString(book));
                continue;
            }
            OperationPtg o = (OperationPtg)ptg;
            operands = FormulaParser.getOperands(stack, o.getNumberOfOperands());
            stack.push(o.toFormulaString(operands));
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String result = (String)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return result;
    }

    private static String[] getOperands(Stack stack, int nOperands) {
        String[] operands = new String[nOperands];
        for (int j = nOperands - 1; j >= 0; --j) {
            if (stack.isEmpty()) {
                String msg = "Too few arguments supplied to operation. Expected (" + nOperands + ") operands but got (" + (nOperands - j - 1) + ")";
                throw new IllegalStateException(msg);
            }
            operands[j] = (String)stack.pop();
        }
        return operands;
    }

    public String toFormulaString(Ptg[] ptgs) {
        return FormulaParser.toFormulaString(this.book, ptgs);
    }

    static final class FormulaParseException
    extends RuntimeException {
        public FormulaParseException(String msg) {
            super(msg);
        }
    }
}

