# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.2.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class PortfolioInformation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'portfolio_id': 'str',
        'currency': 'str',
        'exchange_otr': 'float',
        'tenant_otr': 'float',
        'portfolio_otr': 'float',
        'net_cash_pos': 'float',
        'trades_spending': 'float',
        'trades_earnings': 'float',
        'net_pos': 'float',
        'net_pos_aggregate': 'float',
        'abs_pos': 'float',
        'max_net_pos_buy_with_orders': 'float',
        'min_net_pos_sell_with_orders': 'float',
        'orders_spending': 'float',
        'orders_earnings': 'float'
    }

    attribute_map = {
        'portfolio_id': 'portfolio_id',
        'currency': 'currency',
        'exchange_otr': 'exchange_otr',
        'tenant_otr': 'tenant_otr',
        'portfolio_otr': 'portfolio_otr',
        'net_cash_pos': 'net_cash_pos',
        'trades_spending': 'trades_spending',
        'trades_earnings': 'trades_earnings',
        'net_pos': 'net_pos',
        'net_pos_aggregate': 'net_pos_aggregate',
        'abs_pos': 'abs_pos',
        'max_net_pos_buy_with_orders': 'max_net_pos_buy_with_orders',
        'min_net_pos_sell_with_orders': 'min_net_pos_sell_with_orders',
        'orders_spending': 'orders_spending',
        'orders_earnings': 'orders_earnings'
    }

    def __init__(self, portfolio_id=None, currency=None, exchange_otr=None, tenant_otr=None, portfolio_otr=None, net_cash_pos=None, trades_spending=None, trades_earnings=None, net_pos=None, net_pos_aggregate=None, abs_pos=None, max_net_pos_buy_with_orders=None, min_net_pos_sell_with_orders=None, orders_spending=None, orders_earnings=None, local_vars_configuration=None):  # noqa: E501
        """PortfolioInformation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._portfolio_id = None
        self._currency = None
        self._exchange_otr = None
        self._tenant_otr = None
        self._portfolio_otr = None
        self._net_cash_pos = None
        self._trades_spending = None
        self._trades_earnings = None
        self._net_pos = None
        self._net_pos_aggregate = None
        self._abs_pos = None
        self._max_net_pos_buy_with_orders = None
        self._min_net_pos_sell_with_orders = None
        self._orders_spending = None
        self._orders_earnings = None
        self.discriminator = None

        if portfolio_id is not None:
            self.portfolio_id = portfolio_id
        if currency is not None:
            self.currency = currency
        if exchange_otr is not None:
            self.exchange_otr = exchange_otr
        if tenant_otr is not None:
            self.tenant_otr = tenant_otr
        if portfolio_otr is not None:
            self.portfolio_otr = portfolio_otr
        if net_cash_pos is not None:
            self.net_cash_pos = net_cash_pos
        if trades_spending is not None:
            self.trades_spending = trades_spending
        if trades_earnings is not None:
            self.trades_earnings = trades_earnings
        if net_pos is not None:
            self.net_pos = net_pos
        if net_pos_aggregate is not None:
            self.net_pos_aggregate = net_pos_aggregate
        if abs_pos is not None:
            self.abs_pos = abs_pos
        if max_net_pos_buy_with_orders is not None:
            self.max_net_pos_buy_with_orders = max_net_pos_buy_with_orders
        if min_net_pos_sell_with_orders is not None:
            self.min_net_pos_sell_with_orders = min_net_pos_sell_with_orders
        if orders_spending is not None:
            self.orders_spending = orders_spending
        if orders_earnings is not None:
            self.orders_earnings = orders_earnings

    @property
    def portfolio_id(self):
        """Gets the portfolio_id of this PortfolioInformation.  # noqa: E501


        :return: The portfolio_id of this PortfolioInformation.  # noqa: E501
        :rtype: str
        """
        return self._portfolio_id

    @portfolio_id.setter
    def portfolio_id(self, portfolio_id):
        """Sets the portfolio_id of this PortfolioInformation.


        :param portfolio_id: The portfolio_id of this PortfolioInformation.  # noqa: E501
        :type portfolio_id: str
        """

        self._portfolio_id = portfolio_id

    @property
    def currency(self):
        """Gets the currency of this PortfolioInformation.  # noqa: E501

        the currency used for the request context  # noqa: E501

        :return: The currency of this PortfolioInformation.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this PortfolioInformation.

        the currency used for the request context  # noqa: E501

        :param currency: The currency of this PortfolioInformation.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    @property
    def exchange_otr(self):
        """Gets the exchange_otr of this PortfolioInformation.  # noqa: E501

        The OTR for this contract  # noqa: E501

        :return: The exchange_otr of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._exchange_otr

    @exchange_otr.setter
    def exchange_otr(self, exchange_otr):
        """Sets the exchange_otr of this PortfolioInformation.

        The OTR for this contract  # noqa: E501

        :param exchange_otr: The exchange_otr of this PortfolioInformation.  # noqa: E501
        :type exchange_otr: float
        """

        self._exchange_otr = exchange_otr

    @property
    def tenant_otr(self):
        """Gets the tenant_otr of this PortfolioInformation.  # noqa: E501

        The OTR for this contract for your tenant  # noqa: E501

        :return: The tenant_otr of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._tenant_otr

    @tenant_otr.setter
    def tenant_otr(self, tenant_otr):
        """Sets the tenant_otr of this PortfolioInformation.

        The OTR for this contract for your tenant  # noqa: E501

        :param tenant_otr: The tenant_otr of this PortfolioInformation.  # noqa: E501
        :type tenant_otr: float
        """

        self._tenant_otr = tenant_otr

    @property
    def portfolio_otr(self):
        """Gets the portfolio_otr of this PortfolioInformation.  # noqa: E501

        The portfolio related order to trade ratio (for this exchange)  # noqa: E501

        :return: The portfolio_otr of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._portfolio_otr

    @portfolio_otr.setter
    def portfolio_otr(self, portfolio_otr):
        """Sets the portfolio_otr of this PortfolioInformation.

        The portfolio related order to trade ratio (for this exchange)  # noqa: E501

        :param portfolio_otr: The portfolio_otr of this PortfolioInformation.  # noqa: E501
        :type portfolio_otr: float
        """

        self._portfolio_otr = portfolio_otr

    @property
    def net_cash_pos(self):
        """Gets the net_cash_pos of this PortfolioInformation.  # noqa: E501

        The portfolio related net cash position (for all exchanges and contracts) of today  # noqa: E501

        :return: The net_cash_pos of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._net_cash_pos

    @net_cash_pos.setter
    def net_cash_pos(self, net_cash_pos):
        """Sets the net_cash_pos of this PortfolioInformation.

        The portfolio related net cash position (for all exchanges and contracts) of today  # noqa: E501

        :param net_cash_pos: The net_cash_pos of this PortfolioInformation.  # noqa: E501
        :type net_cash_pos: float
        """

        self._net_cash_pos = net_cash_pos

    @property
    def trades_spending(self):
        """Gets the trades_spending of this PortfolioInformation.  # noqa: E501

        Sum of the costs of all trades from today which are decreasing the cash position. Orders decreasing the cash position are BUY-Trades with a price greater than 0 and SELL-Trades with a price less than 0.  # noqa: E501

        :return: The trades_spending of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._trades_spending

    @trades_spending.setter
    def trades_spending(self, trades_spending):
        """Sets the trades_spending of this PortfolioInformation.

        Sum of the costs of all trades from today which are decreasing the cash position. Orders decreasing the cash position are BUY-Trades with a price greater than 0 and SELL-Trades with a price less than 0.  # noqa: E501

        :param trades_spending: The trades_spending of this PortfolioInformation.  # noqa: E501
        :type trades_spending: float
        """

        self._trades_spending = trades_spending

    @property
    def trades_earnings(self):
        """Gets the trades_earnings of this PortfolioInformation.  # noqa: E501

        Sum of the costs of all trades from today which are increasing the cash position. Orders increasing the cash position are SELL-Trades with a price greater than 0 and BUY-Trades with a price less than 0.  # noqa: E501

        :return: The trades_earnings of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._trades_earnings

    @trades_earnings.setter
    def trades_earnings(self, trades_earnings):
        """Sets the trades_earnings of this PortfolioInformation.

        Sum of the costs of all trades from today which are increasing the cash position. Orders increasing the cash position are SELL-Trades with a price greater than 0 and BUY-Trades with a price less than 0.  # noqa: E501

        :param trades_earnings: The trades_earnings of this PortfolioInformation.  # noqa: E501
        :type trades_earnings: float
        """

        self._trades_earnings = trades_earnings

    @property
    def net_pos(self):
        """Gets the net_pos of this PortfolioInformation.  # noqa: E501

        The portfolio related net position (for this exchange)  # noqa: E501

        :return: The net_pos of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._net_pos

    @net_pos.setter
    def net_pos(self, net_pos):
        """Sets the net_pos of this PortfolioInformation.

        The portfolio related net position (for this exchange)  # noqa: E501

        :param net_pos: The net_pos of this PortfolioInformation.  # noqa: E501
        :type net_pos: float
        """

        self._net_pos = net_pos

    @property
    def net_pos_aggregate(self):
        """Gets the net_pos_aggregate of this PortfolioInformation.  # noqa: E501

        The aggregated net position of all contracts which fully overlap with the delivery period of this contract (e.g. for quarterhourly contracts this will include the net pos of the quarter-hourly, the half-hourly and the hourly contracts)  # noqa: E501

        :return: The net_pos_aggregate of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._net_pos_aggregate

    @net_pos_aggregate.setter
    def net_pos_aggregate(self, net_pos_aggregate):
        """Sets the net_pos_aggregate of this PortfolioInformation.

        The aggregated net position of all contracts which fully overlap with the delivery period of this contract (e.g. for quarterhourly contracts this will include the net pos of the quarter-hourly, the half-hourly and the hourly contracts)  # noqa: E501

        :param net_pos_aggregate: The net_pos_aggregate of this PortfolioInformation.  # noqa: E501
        :type net_pos_aggregate: float
        """

        self._net_pos_aggregate = net_pos_aggregate

    @property
    def abs_pos(self):
        """Gets the abs_pos of this PortfolioInformation.  # noqa: E501

        The portfolio related absolute position (for this exchange)  # noqa: E501

        :return: The abs_pos of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._abs_pos

    @abs_pos.setter
    def abs_pos(self, abs_pos):
        """Sets the abs_pos of this PortfolioInformation.

        The portfolio related absolute position (for this exchange)  # noqa: E501

        :param abs_pos: The abs_pos of this PortfolioInformation.  # noqa: E501
        :type abs_pos: float
        """

        self._abs_pos = abs_pos

    @property
    def max_net_pos_buy_with_orders(self):
        """Gets the max_net_pos_buy_with_orders of this PortfolioInformation.  # noqa: E501

        The expected net_pos (sum of all trades). Standing Orders which would decrease the cash position on execution can be included with \"include_standing_orders\". Orders decreasing the cash position are BUY-Orders with a price greater than 0 and SELL-Orders with a price less than 0.  # noqa: E501

        :return: The max_net_pos_buy_with_orders of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._max_net_pos_buy_with_orders

    @max_net_pos_buy_with_orders.setter
    def max_net_pos_buy_with_orders(self, max_net_pos_buy_with_orders):
        """Sets the max_net_pos_buy_with_orders of this PortfolioInformation.

        The expected net_pos (sum of all trades). Standing Orders which would decrease the cash position on execution can be included with \"include_standing_orders\". Orders decreasing the cash position are BUY-Orders with a price greater than 0 and SELL-Orders with a price less than 0.  # noqa: E501

        :param max_net_pos_buy_with_orders: The max_net_pos_buy_with_orders of this PortfolioInformation.  # noqa: E501
        :type max_net_pos_buy_with_orders: float
        """

        self._max_net_pos_buy_with_orders = max_net_pos_buy_with_orders

    @property
    def min_net_pos_sell_with_orders(self):
        """Gets the min_net_pos_sell_with_orders of this PortfolioInformation.  # noqa: E501

        The expected net_pos (sum of all trades). Standing Orders which would increase the cash position on execution can be included with \"include_standing_orders\". Orders increasing the cash position are SELL-Orders with a price greater than 0 and BUY-Orders with a price less than 0.  # noqa: E501

        :return: The min_net_pos_sell_with_orders of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._min_net_pos_sell_with_orders

    @min_net_pos_sell_with_orders.setter
    def min_net_pos_sell_with_orders(self, min_net_pos_sell_with_orders):
        """Sets the min_net_pos_sell_with_orders of this PortfolioInformation.

        The expected net_pos (sum of all trades). Standing Orders which would increase the cash position on execution can be included with \"include_standing_orders\". Orders increasing the cash position are SELL-Orders with a price greater than 0 and BUY-Orders with a price less than 0.  # noqa: E501

        :param min_net_pos_sell_with_orders: The min_net_pos_sell_with_orders of this PortfolioInformation.  # noqa: E501
        :type min_net_pos_sell_with_orders: float
        """

        self._min_net_pos_sell_with_orders = min_net_pos_sell_with_orders

    @property
    def orders_spending(self):
        """Gets the orders_spending of this PortfolioInformation.  # noqa: E501

        Sum of all costs of standing orders which are decreasing the cash position. Orders decreasing the cash position are BUY-Orders with a price greater than 0 and SELL-Orders with a price less than 0.  # noqa: E501

        :return: The orders_spending of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._orders_spending

    @orders_spending.setter
    def orders_spending(self, orders_spending):
        """Sets the orders_spending of this PortfolioInformation.

        Sum of all costs of standing orders which are decreasing the cash position. Orders decreasing the cash position are BUY-Orders with a price greater than 0 and SELL-Orders with a price less than 0.  # noqa: E501

        :param orders_spending: The orders_spending of this PortfolioInformation.  # noqa: E501
        :type orders_spending: float
        """

        self._orders_spending = orders_spending

    @property
    def orders_earnings(self):
        """Gets the orders_earnings of this PortfolioInformation.  # noqa: E501

        Sum of all costs of standing orders which are increasing the cash position. Orders increasing the cash position are SELL-Orders with a price greater than 0 and BUY-Orders with a price less than 0.  # noqa: E501

        :return: The orders_earnings of this PortfolioInformation.  # noqa: E501
        :rtype: float
        """
        return self._orders_earnings

    @orders_earnings.setter
    def orders_earnings(self, orders_earnings):
        """Sets the orders_earnings of this PortfolioInformation.

        Sum of all costs of standing orders which are increasing the cash position. Orders increasing the cash position are SELL-Orders with a price greater than 0 and BUY-Orders with a price less than 0.  # noqa: E501

        :param orders_earnings: The orders_earnings of this PortfolioInformation.  # noqa: E501
        :type orders_earnings: float
        """

        self._orders_earnings = orders_earnings

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PortfolioInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PortfolioInformation):
            return True

        return self.to_dict() != other.to_dict()
