# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.2.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class OrderEntry(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'delivery_area': 'str',
        'portfolio_id': 'str',
        'side': 'str',
        'prod': 'str',
        'quantity': 'float',
        'price': 'float',
        'display_qty': 'float',
        'contract_id': 'str',
        'contract_name': 'str',
        'cl_ordr_id': 'str',
        'clearing_acct_type': 'str',
        'ordr_exe_restriction': 'str',
        'pre_arranged': 'bool',
        'pre_arranged_acct': 'str',
        'type': 'str',
        'validity_res': 'str',
        'state': 'str',
        'validity_date': 'datetime',
        'txt': 'str',
        'ppd': 'float',
        'dlvry_start': 'datetime',
        'dlvry_end': 'datetime',
        'expected_net_pos': 'float',
        'expected_max_net_pos': 'float',
        'expected_min_net_pos': 'float'
    }

    attribute_map = {
        'delivery_area': 'delivery_area',
        'portfolio_id': 'portfolio_id',
        'side': 'side',
        'prod': 'prod',
        'quantity': 'quantity',
        'price': 'price',
        'display_qty': 'displayQty',
        'contract_id': 'contractId',
        'contract_name': 'contractName',
        'cl_ordr_id': 'clOrdrId',
        'clearing_acct_type': 'clearingAcctType',
        'ordr_exe_restriction': 'ordrExeRestriction',
        'pre_arranged': 'preArranged',
        'pre_arranged_acct': 'preArrangedAcct',
        'type': 'type',
        'validity_res': 'validityRes',
        'state': 'state',
        'validity_date': 'validityDate',
        'txt': 'txt',
        'ppd': 'ppd',
        'dlvry_start': 'dlvryStart',
        'dlvry_end': 'dlvryEnd',
        'expected_net_pos': 'expectedNetPos',
        'expected_max_net_pos': 'expectedMaxNetPos',
        'expected_min_net_pos': 'expectedMinNetPos'
    }

    def __init__(self, delivery_area=None, portfolio_id=None, side=None, prod=None, quantity=None, price=None, display_qty=None, contract_id=None, contract_name=None, cl_ordr_id=None, clearing_acct_type=None, ordr_exe_restriction='NON', pre_arranged=False, pre_arranged_acct=None, type='O', validity_res='GFS', state=None, validity_date=None, txt=None, ppd=None, dlvry_start=None, dlvry_end=None, expected_net_pos=None, expected_max_net_pos=None, expected_min_net_pos=None, local_vars_configuration=None):  # noqa: E501
        """OrderEntry - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._delivery_area = None
        self._portfolio_id = None
        self._side = None
        self._prod = None
        self._quantity = None
        self._price = None
        self._display_qty = None
        self._contract_id = None
        self._contract_name = None
        self._cl_ordr_id = None
        self._clearing_acct_type = None
        self._ordr_exe_restriction = None
        self._pre_arranged = None
        self._pre_arranged_acct = None
        self._type = None
        self._validity_res = None
        self._state = None
        self._validity_date = None
        self._txt = None
        self._ppd = None
        self._dlvry_start = None
        self._dlvry_end = None
        self._expected_net_pos = None
        self._expected_max_net_pos = None
        self._expected_min_net_pos = None
        self.discriminator = None

        if delivery_area is not None:
            self.delivery_area = delivery_area
        if portfolio_id is not None:
            self.portfolio_id = portfolio_id
        if side is not None:
            self.side = side
        if prod is not None:
            self.prod = prod
        self.quantity = quantity
        self.price = price
        if display_qty is not None:
            self.display_qty = display_qty
        if contract_id is not None:
            self.contract_id = contract_id
        if contract_name is not None:
            self.contract_name = contract_name
        if cl_ordr_id is not None:
            self.cl_ordr_id = cl_ordr_id
        if clearing_acct_type is not None:
            self.clearing_acct_type = clearing_acct_type
        if ordr_exe_restriction is not None:
            self.ordr_exe_restriction = ordr_exe_restriction
        if pre_arranged is not None:
            self.pre_arranged = pre_arranged
        if pre_arranged_acct is not None:
            self.pre_arranged_acct = pre_arranged_acct
        if type is not None:
            self.type = type
        if validity_res is not None:
            self.validity_res = validity_res
        if state is not None:
            self.state = state
        if validity_date is not None:
            self.validity_date = validity_date
        if txt is not None:
            self.txt = txt
        if ppd is not None:
            self.ppd = ppd
        if dlvry_start is not None:
            self.dlvry_start = dlvry_start
        if dlvry_end is not None:
            self.dlvry_end = dlvry_end
        if expected_net_pos is not None:
            self.expected_net_pos = expected_net_pos
        if expected_max_net_pos is not None:
            self.expected_max_net_pos = expected_max_net_pos
        if expected_min_net_pos is not None:
            self.expected_min_net_pos = expected_min_net_pos

    @property
    def delivery_area(self):
        """Gets the delivery_area of this OrderEntry.  # noqa: E501

        The delivery area of the orderbook's product. Mandatory in a multi-delivery-area configuration  # noqa: E501

        :return: The delivery_area of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this OrderEntry.

        The delivery area of the orderbook's product. Mandatory in a multi-delivery-area configuration  # noqa: E501

        :param delivery_area: The delivery_area of this OrderEntry.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def portfolio_id(self):
        """Gets the portfolio_id of this OrderEntry.  # noqa: E501


        :return: The portfolio_id of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._portfolio_id

    @portfolio_id.setter
    def portfolio_id(self, portfolio_id):
        """Sets the portfolio_id of this OrderEntry.


        :param portfolio_id: The portfolio_id of this OrderEntry.  # noqa: E501
        :type portfolio_id: str
        """

        self._portfolio_id = portfolio_id

    @property
    def side(self):
        """Gets the side of this OrderEntry.  # noqa: E501


        :return: The side of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._side

    @side.setter
    def side(self, side):
        """Sets the side of this OrderEntry.


        :param side: The side of this OrderEntry.  # noqa: E501
        :type side: str
        """
        allowed_values = ["SELL", "BUY"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and side not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `side` ({0}), must be one of {1}"  # noqa: E501
                .format(side, allowed_values)
            )

        self._side = side

    @property
    def prod(self):
        """Gets the prod of this OrderEntry.  # noqa: E501

        The product of the order  # noqa: E501

        :return: The prod of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._prod

    @prod.setter
    def prod(self, prod):
        """Sets the prod of this OrderEntry.

        The product of the order  # noqa: E501

        :param prod: The prod of this OrderEntry.  # noqa: E501
        :type prod: str
        """

        self._prod = prod

    @property
    def quantity(self):
        """Gets the quantity of this OrderEntry.  # noqa: E501

        The quantity of the order in MW.  # noqa: E501

        :return: The quantity of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderEntry.

        The quantity of the order in MW.  # noqa: E501

        :param quantity: The quantity of this OrderEntry.  # noqa: E501
        :type quantity: float
        """
        if self.local_vars_configuration.client_side_validation and quantity is None:  # noqa: E501
            raise ValueError("Invalid value for `quantity`, must not be `None`")  # noqa: E501

        self._quantity = quantity

    @property
    def price(self):
        """Gets the price of this OrderEntry.  # noqa: E501

        The price of the order in the traded currency (usually EUR)  # noqa: E501

        :return: The price of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OrderEntry.

        The price of the order in the traded currency (usually EUR)  # noqa: E501

        :param price: The price of this OrderEntry.  # noqa: E501
        :type price: float
        """
        if self.local_vars_configuration.client_side_validation and price is None:  # noqa: E501
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    @property
    def display_qty(self):
        """Gets the display_qty of this OrderEntry.  # noqa: E501

        Used to define display quantity of an Iceberg Order. This field is required only in the case of type=?I?.  # noqa: E501

        :return: The display_qty of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._display_qty

    @display_qty.setter
    def display_qty(self, display_qty):
        """Sets the display_qty of this OrderEntry.

        Used to define display quantity of an Iceberg Order. This field is required only in the case of type=?I?.  # noqa: E501

        :param display_qty: The display_qty of this OrderEntry.  # noqa: E501
        :type display_qty: float
        """

        self._display_qty = display_qty

    @property
    def contract_id(self):
        """Gets the contract_id of this OrderEntry.  # noqa: E501

        The contractId of the order, can be omitted if contractName is specified instead.  # noqa: E501

        :return: The contract_id of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this OrderEntry.

        The contractId of the order, can be omitted if contractName is specified instead.  # noqa: E501

        :param contract_id: The contract_id of this OrderEntry.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def contract_name(self):
        """Gets the contract_name of this OrderEntry.  # noqa: E501

        Set a contract name instead of the contractId, and the attempt is made to look up the contract via it's name. If contractId is set, the contractName field is ignored.  # noqa: E501

        :return: The contract_name of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._contract_name

    @contract_name.setter
    def contract_name(self, contract_name):
        """Sets the contract_name of this OrderEntry.

        Set a contract name instead of the contractId, and the attempt is made to look up the contract via it's name. If contractId is set, the contractName field is ignored.  # noqa: E501

        :param contract_name: The contract_name of this OrderEntry.  # noqa: E501
        :type contract_name: str
        """

        self._contract_name = contract_name

    @property
    def cl_ordr_id(self):
        """Gets the cl_ordr_id of this OrderEntry.  # noqa: E501

        the \"client order id\" which can be used to identify the order at a later point (i.e. within a trade)  # noqa: E501

        :return: The cl_ordr_id of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._cl_ordr_id

    @cl_ordr_id.setter
    def cl_ordr_id(self, cl_ordr_id):
        """Sets the cl_ordr_id of this OrderEntry.

        the \"client order id\" which can be used to identify the order at a later point (i.e. within a trade)  # noqa: E501

        :param cl_ordr_id: The cl_ordr_id of this OrderEntry.  # noqa: E501
        :type cl_ordr_id: str
        """
        if (self.local_vars_configuration.client_side_validation and
                cl_ordr_id is not None and len(cl_ordr_id) > 40):
            raise ValueError("Invalid value for `cl_ordr_id`, length must be less than or equal to `40`")  # noqa: E501

        self._cl_ordr_id = cl_ordr_id

    @property
    def clearing_acct_type(self):
        """Gets the clearing_acct_type of this OrderEntry.  # noqa: E501

        Defines if the order is entered on own account or as an agent. For the set of valid values please refer to values from attribute allowedClearingAcctTypes in SystemInfoResp message (e.g. ?A,P? for spot markets)  # noqa: E501

        :return: The clearing_acct_type of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._clearing_acct_type

    @clearing_acct_type.setter
    def clearing_acct_type(self, clearing_acct_type):
        """Sets the clearing_acct_type of this OrderEntry.

        Defines if the order is entered on own account or as an agent. For the set of valid values please refer to values from attribute allowedClearingAcctTypes in SystemInfoResp message (e.g. ?A,P? for spot markets)  # noqa: E501

        :param clearing_acct_type: The clearing_acct_type of this OrderEntry.  # noqa: E501
        :type clearing_acct_type: str
        """

        self._clearing_acct_type = clearing_acct_type

    @property
    def ordr_exe_restriction(self):
        """Gets the ordr_exe_restriction of this OrderEntry.  # noqa: E501

        Execution restriction of the order.  * NON: No restriction. This is the default. * FOK: (Fill or Kill) - The order is immediately fully executed or deleted. * IOC: (Immediate and cancel): The order is executed immediately to its maximum extent. In case of a partial execution, the remaining volume is removed from the order book. * AON: (All or None): The order must be filled completely or not at all. The order stays in the order book until it is executed or removed by the system or user. AON is only allowed for User Defined Contracts (UDC). * AU (Auction): The order was entered in auction phase (no restriction is applied)  # noqa: E501

        :return: The ordr_exe_restriction of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._ordr_exe_restriction

    @ordr_exe_restriction.setter
    def ordr_exe_restriction(self, ordr_exe_restriction):
        """Sets the ordr_exe_restriction of this OrderEntry.

        Execution restriction of the order.  * NON: No restriction. This is the default. * FOK: (Fill or Kill) - The order is immediately fully executed or deleted. * IOC: (Immediate and cancel): The order is executed immediately to its maximum extent. In case of a partial execution, the remaining volume is removed from the order book. * AON: (All or None): The order must be filled completely or not at all. The order stays in the order book until it is executed or removed by the system or user. AON is only allowed for User Defined Contracts (UDC). * AU (Auction): The order was entered in auction phase (no restriction is applied)  # noqa: E501

        :param ordr_exe_restriction: The ordr_exe_restriction of this OrderEntry.  # noqa: E501
        :type ordr_exe_restriction: str
        """
        allowed_values = ["FOK", "IOC", "NON", "AON", "AU"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and ordr_exe_restriction not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `ordr_exe_restriction` ({0}), must be one of {1}"  # noqa: E501
                .format(ordr_exe_restriction, allowed_values)
            )

        self._ordr_exe_restriction = ordr_exe_restriction

    @property
    def pre_arranged(self):
        """Gets the pre_arranged of this OrderEntry.  # noqa: E501

        Flag which indicates if the entered order is a pre-arranged order or not.  # noqa: E501

        :return: The pre_arranged of this OrderEntry.  # noqa: E501
        :rtype: bool
        """
        return self._pre_arranged

    @pre_arranged.setter
    def pre_arranged(self, pre_arranged):
        """Sets the pre_arranged of this OrderEntry.

        Flag which indicates if the entered order is a pre-arranged order or not.  # noqa: E501

        :param pre_arranged: The pre_arranged of this OrderEntry.  # noqa: E501
        :type pre_arranged: bool
        """

        self._pre_arranged = pre_arranged

    @property
    def pre_arranged_acct(self):
        """Gets the pre_arranged_acct of this OrderEntry.  # noqa: E501

        Required in case of a pre-arranged order. Contains the account of the counterpart.  # noqa: E501

        :return: The pre_arranged_acct of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._pre_arranged_acct

    @pre_arranged_acct.setter
    def pre_arranged_acct(self, pre_arranged_acct):
        """Sets the pre_arranged_acct of this OrderEntry.

        Required in case of a pre-arranged order. Contains the account of the counterpart.  # noqa: E501

        :param pre_arranged_acct: The pre_arranged_acct of this OrderEntry.  # noqa: E501
        :type pre_arranged_acct: str
        """

        self._pre_arranged_acct = pre_arranged_acct

    @property
    def type(self):
        """Gets the type of this OrderEntry.  # noqa: E501

        * O: Regular limit order. * B: User defined block order. * I: Iceberg order. * L: Balance order. * C: Indicative order. * S: Stop limit order. * E: On exchange prearranged trade * N: Private and confidential trade * H: Lifting order for products with Hit & Lift matcher * Q: Quote order * W: Indicative quote order  # noqa: E501

        :return: The type of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OrderEntry.

        * O: Regular limit order. * B: User defined block order. * I: Iceberg order. * L: Balance order. * C: Indicative order. * S: Stop limit order. * E: On exchange prearranged trade * N: Private and confidential trade * H: Lifting order for products with Hit & Lift matcher * Q: Quote order * W: Indicative quote order  # noqa: E501

        :param type: The type of this OrderEntry.  # noqa: E501
        :type type: str
        """
        allowed_values = ["B", "O", "I", "L", "S", "H", "C", "N", "E"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def validity_res(self):
        """Gets the validity_res of this OrderEntry.  # noqa: E501

        Validity restriction of the order. * GFS (Good for trading session): The order rests in the order book until it is either executed, removed by the user or the current trading session (trading phase) of the underlying contract ends. * GTD (Good till date, will be introduced with CX 3.5): The order rests in the order book until the date specified in the validityDate field. * NON (No validity restriction): Mandatory for orders with the execution restriction ?FOK? or ?IOC?.  # noqa: E501

        :return: The validity_res of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._validity_res

    @validity_res.setter
    def validity_res(self, validity_res):
        """Sets the validity_res of this OrderEntry.

        Validity restriction of the order. * GFS (Good for trading session): The order rests in the order book until it is either executed, removed by the user or the current trading session (trading phase) of the underlying contract ends. * GTD (Good till date, will be introduced with CX 3.5): The order rests in the order book until the date specified in the validityDate field. * NON (No validity restriction): Mandatory for orders with the execution restriction ?FOK? or ?IOC?.  # noqa: E501

        :param validity_res: The validity_res of this OrderEntry.  # noqa: E501
        :type validity_res: str
        """
        allowed_values = ["GFS", "GTD", "NON"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and validity_res not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `validity_res` ({0}), must be one of {1}"  # noqa: E501
                .format(validity_res, allowed_values)
            )

        self._validity_res = validity_res

    @property
    def state(self):
        """Gets the state of this OrderEntry.  # noqa: E501

        * ACTI: The order is entered and immediately exposed to the market for execution. This is the default value. * HIBE: The order is entered into the backend system but not exposed to the market.  # noqa: E501

        :return: The state of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this OrderEntry.

        * ACTI: The order is entered and immediately exposed to the market for execution. This is the default value. * HIBE: The order is entered into the backend system but not exposed to the market.  # noqa: E501

        :param state: The state of this OrderEntry.  # noqa: E501
        :type state: str
        """
        allowed_values = ["ACTI", "HIBE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def validity_date(self):
        """Gets the validity_date of this OrderEntry.  # noqa: E501

        mandatory in case of validityRes equals ?GTD?. It is used to define the date until which the order is valid. The remaining part of the order will be removed from the order book after this point in time.  # noqa: E501

        :return: The validity_date of this OrderEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._validity_date

    @validity_date.setter
    def validity_date(self, validity_date):
        """Sets the validity_date of this OrderEntry.

        mandatory in case of validityRes equals ?GTD?. It is used to define the date until which the order is valid. The remaining part of the order will be removed from the order book after this point in time.  # noqa: E501

        :param validity_date: The validity_date of this OrderEntry.  # noqa: E501
        :type validity_date: datetime
        """

        self._validity_date = validity_date

    @property
    def txt(self):
        """Gets the txt of this OrderEntry.  # noqa: E501

        Text which can be retrieved at a later point (i.e. via a trade which was triggered by the order)  # noqa: E501

        :return: The txt of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._txt

    @txt.setter
    def txt(self, txt):
        """Sets the txt of this OrderEntry.

        Text which can be retrieved at a later point (i.e. via a trade which was triggered by the order)  # noqa: E501

        :param txt: The txt of this OrderEntry.  # noqa: E501
        :type txt: str
        """
        if (self.local_vars_configuration.client_side_validation and
                txt is not None and len(txt) > 150):
            raise ValueError("Invalid value for `txt`, length must be less than or equal to `150`")  # noqa: E501

        self._txt = txt

    @property
    def ppd(self):
        """Gets the ppd of this OrderEntry.  # noqa: E501

        Peak price delta for Iceberg orders. * The ppd of buy orders must be smaller or equal than zero. * The ppd of sell orders must be greater or equal than zero. If it is omitted the system will assume a value of ?0,00?.  # noqa: E501

        :return: The ppd of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._ppd

    @ppd.setter
    def ppd(self, ppd):
        """Sets the ppd of this OrderEntry.

        Peak price delta for Iceberg orders. * The ppd of buy orders must be smaller or equal than zero. * The ppd of sell orders must be greater or equal than zero. If it is omitted the system will assume a value of ?0,00?.  # noqa: E501

        :param ppd: The ppd of this OrderEntry.  # noqa: E501
        :type ppd: float
        """

        self._ppd = ppd

    @property
    def dlvry_start(self):
        """Gets the dlvry_start of this OrderEntry.  # noqa: E501

        (optional) Start of delivery of the underlying contract.  # noqa: E501

        :return: The dlvry_start of this OrderEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._dlvry_start

    @dlvry_start.setter
    def dlvry_start(self, dlvry_start):
        """Sets the dlvry_start of this OrderEntry.

        (optional) Start of delivery of the underlying contract.  # noqa: E501

        :param dlvry_start: The dlvry_start of this OrderEntry.  # noqa: E501
        :type dlvry_start: datetime
        """

        self._dlvry_start = dlvry_start

    @property
    def dlvry_end(self):
        """Gets the dlvry_end of this OrderEntry.  # noqa: E501

        (optional) End of delivery of the underlying contract.  # noqa: E501

        :return: The dlvry_end of this OrderEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._dlvry_end

    @dlvry_end.setter
    def dlvry_end(self, dlvry_end):
        """Sets the dlvry_end of this OrderEntry.

        (optional) End of delivery of the underlying contract.  # noqa: E501

        :param dlvry_end: The dlvry_end of this OrderEntry.  # noqa: E501
        :type dlvry_end: datetime
        """

        self._dlvry_end = dlvry_end

    @property
    def expected_net_pos(self):
        """Gets the expected_net_pos of this OrderEntry.  # noqa: E501

        The expected net_pos (sum of all trades). Do not use this field when posting a block product.  # noqa: E501

        :return: The expected_net_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_net_pos

    @expected_net_pos.setter
    def expected_net_pos(self, expected_net_pos):
        """Sets the expected_net_pos of this OrderEntry.

        The expected net_pos (sum of all trades). Do not use this field when posting a block product.  # noqa: E501

        :param expected_net_pos: The expected_net_pos of this OrderEntry.  # noqa: E501
        :type expected_net_pos: float
        """

        self._expected_net_pos = expected_net_pos

    @property
    def expected_max_net_pos(self):
        """Gets the expected_max_net_pos of this OrderEntry.  # noqa: E501

        The expected net_pos (sum of all trades) plus the quantity of all standing BUY-Orders.  Do not use this field when posting a block product.  # noqa: E501

        :return: The expected_max_net_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_max_net_pos

    @expected_max_net_pos.setter
    def expected_max_net_pos(self, expected_max_net_pos):
        """Sets the expected_max_net_pos of this OrderEntry.

        The expected net_pos (sum of all trades) plus the quantity of all standing BUY-Orders.  Do not use this field when posting a block product.  # noqa: E501

        :param expected_max_net_pos: The expected_max_net_pos of this OrderEntry.  # noqa: E501
        :type expected_max_net_pos: float
        """

        self._expected_max_net_pos = expected_max_net_pos

    @property
    def expected_min_net_pos(self):
        """Gets the expected_min_net_pos of this OrderEntry.  # noqa: E501

        The expected net_pos (sum of all trades) minus the quantity of all standing SELL-Orders.  Do not use this field when posting a block product.  # noqa: E501

        :return: The expected_min_net_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_min_net_pos

    @expected_min_net_pos.setter
    def expected_min_net_pos(self, expected_min_net_pos):
        """Sets the expected_min_net_pos of this OrderEntry.

        The expected net_pos (sum of all trades) minus the quantity of all standing SELL-Orders.  Do not use this field when posting a block product.  # noqa: E501

        :param expected_min_net_pos: The expected_min_net_pos of this OrderEntry.  # noqa: E501
        :type expected_min_net_pos: float
        """

        self._expected_min_net_pos = expected_min_net_pos

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrderEntry):
            return True

        return self.to_dict() != other.to_dict()
