# coding: utf-8

# flake8: noqa

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

__version__ = "1.0.0"

# import apis into sdk package
from powerbot_client.api.algorithms_api import AlgorithmsApi
from powerbot_client.api.authentication_api import AuthenticationApi
from powerbot_client.api.capacities_api import CapacitiesApi
from powerbot_client.api.contract_api import ContractApi
from powerbot_client.api.logs_api import LogsApi
from powerbot_client.api.market_api import MarketApi
from powerbot_client.api.messages_api import MessagesApi
from powerbot_client.api.orders_api import OrdersApi
from powerbot_client.api.portfolios_api import PortfoliosApi
from powerbot_client.api.report_api import ReportApi
from powerbot_client.api.signals_api import SignalsApi
from powerbot_client.api.subscriptions_api import SubscriptionsApi
from powerbot_client.api.tenants_api import TenantsApi
from powerbot_client.api.trades_api import TradesApi

# import ApiClient
from powerbot_client.api_client import ApiClient
from powerbot_client.configuration import Configuration
from powerbot_client.exceptions import OpenApiException
from powerbot_client.exceptions import ApiTypeError
from powerbot_client.exceptions import ApiValueError
from powerbot_client.exceptions import ApiKeyError
from powerbot_client.exceptions import ApiAttributeError
from powerbot_client.exceptions import ApiException
# import models into sdk package
from powerbot_client.models.algo_command import AlgoCommand
from powerbot_client.models.algo_details import AlgoDetails
from powerbot_client.models.algo_event import AlgoEvent
from powerbot_client.models.algo_heartbeat import AlgoHeartbeat
from powerbot_client.models.algo_instance import AlgoInstance
from powerbot_client.models.algo_instance_event import AlgoInstanceEvent
from powerbot_client.models.algo_instance_parameters import AlgoInstanceParameters
from powerbot_client.models.algo_setup import AlgoSetup
from powerbot_client.models.api_key import ApiKey
from powerbot_client.models.api_key_description import ApiKeyDescription
from powerbot_client.models.api_key_details import ApiKeyDetails
from powerbot_client.models.atc_status import AtcStatus
from powerbot_client.models.available_portfolio import AvailablePortfolio
from powerbot_client.models.bulk_signal import BulkSignal
from powerbot_client.models.bulk_signal_response import BulkSignalResponse
from powerbot_client.models.capacity import Capacity
from powerbot_client.models.capacity_changes import CapacityChanges
from powerbot_client.models.cash_limit import CashLimit
from powerbot_client.models.changed_credentials import ChangedCredentials
from powerbot_client.models.contract import Contract
from powerbot_client.models.contract_changed_event import ContractChangedEvent
from powerbot_client.models.contract_history_item import ContractHistoryItem
from powerbot_client.models.contract_item import ContractItem
from powerbot_client.models.contract_reference import ContractReference
from powerbot_client.models.contract_statistics import ContractStatistics
from powerbot_client.models.credentials import Credentials
from powerbot_client.models.error_response import ErrorResponse
from powerbot_client.models.exchange_cash_limit import ExchangeCashLimit
from powerbot_client.models.initialization import Initialization
from powerbot_client.models.internal_trade import InternalTrade
from powerbot_client.models.limit_violation import LimitViolation
from powerbot_client.models.log_entry import LogEntry
from powerbot_client.models.market_mode import MarketMode
from powerbot_client.models.market_options import MarketOptions
from powerbot_client.models.market_status import MarketStatus
from powerbot_client.models.market_status_changed_event import MarketStatusChangedEvent
from powerbot_client.models.message import Message
from powerbot_client.models.new_api_key import NewApiKey
from powerbot_client.models.new_internal_trade import NewInternalTrade
from powerbot_client.models.new_portfolio import NewPortfolio
from powerbot_client.models.new_tenant import NewTenant
from powerbot_client.models.notification import Notification
from powerbot_client.models.order_book import OrderBook
from powerbot_client.models.order_book_changed_event import OrderBookChangedEvent
from powerbot_client.models.order_book_changes import OrderBookChanges
from powerbot_client.models.order_book_entry import OrderBookEntry
from powerbot_client.models.order_books import OrderBooks
from powerbot_client.models.order_entry import OrderEntry
from powerbot_client.models.order_modify import OrderModify
from powerbot_client.models.order_modify_item import OrderModifyItem
from powerbot_client.models.orders import Orders
from powerbot_client.models.otr_limit import OtrLimit
from powerbot_client.models.own_order import OwnOrder
from powerbot_client.models.own_order_changed_event import OwnOrderChangedEvent
from powerbot_client.models.own_order_changes import OwnOrderChanges
from powerbot_client.models.own_trade_changes import OwnTradeChanges
from powerbot_client.models.portfolio import Portfolio
from powerbot_client.models.portfolio_changes import PortfolioChanges
from powerbot_client.models.portfolio_information import PortfolioInformation
from powerbot_client.models.position_limit import PositionLimit
from powerbot_client.models.product_information import ProductInformation
from powerbot_client.models.public_trade import PublicTrade
from powerbot_client.models.public_trade_changes import PublicTradeChanges
from powerbot_client.models.report import Report
from powerbot_client.models.report_element import ReportElement
from powerbot_client.models.risk_management_settings import RiskManagementSettings
from powerbot_client.models.risk_settings_and_portfolio_information import RiskSettingsAndPortfolioInformation
from powerbot_client.models.signal import Signal
from powerbot_client.models.signal_changes import SignalChanges
from powerbot_client.models.subscription_endpoint import SubscriptionEndpoint
from powerbot_client.models.tenant import Tenant
from powerbot_client.models.trade import Trade
from powerbot_client.models.trade_changed_event import TradeChangedEvent
from powerbot_client.models.trading_area import TradingArea
from powerbot_client.models.trading_period import TradingPeriod
from powerbot_client.models.update_algo_setup import UpdateAlgoSetup
from powerbot_client.models.update_status import UpdateStatus
from powerbot_client.models.updated_api_key import UpdatedApiKey
from powerbot_client.models.updated_portfolio import UpdatedPortfolio
from powerbot_client.models.updated_tenant import UpdatedTenant

