from osrsmath.combat.experience import *
import unittest

XP_TABLE = {  # https://oldschool.runescape.wiki/w/Experience
	1 : ( 0 , None),
	2 : ( 83, 83 ),
	3 : ( 174, 91 ),
	4 : ( 276, 102 ),
	5 : ( 388, 112 ),
	6 : ( 512, 124 ),
	7 : ( 650, 138),
	8 : ( 801, 151),
	9 : ( 969, 168),
	10 : ( 1_154, 185),
	11 : ( 1_358, 204),
	12 : ( 1_584, 226),
	13 : ( 1_833, 249),
	14 : ( 2_107, 274),
	15 : ( 2_411, 304),
	16 : ( 2_746, 335),
	17 : ( 3_115, 369),
	18 : ( 3_523, 408),
	19 : ( 3_973, 450),
	20 : ( 4_470, 497),
	21 : ( 5_018, 548),
	22 : ( 5_624, 606),
	23 : ( 6_291, 667),
	24 : ( 7_028, 737),
	25 : ( 7_842, 814),
	26 : ( 8_740, 898),
	27 : ( 9_730, 990),
	28 : ( 10_824, 1_094),
	29 : ( 12_031, 1_207),
	30 : ( 13_363, 1_332),
	31 : ( 14_833, 1_470),
	32 : ( 16_456, 1_623),
	33 : ( 18_247, 1_791),
	34 : ( 20_224, 1_977),
	35 : ( 22_406, 2_182),
	36 : ( 24_815, 2_409),
	37 : ( 27_473, 2_658),
	38 : ( 30_408, 2_935),
	39 : ( 33_648, 3_240),
	40 : ( 37_224, 3_576),
	41 : ( 41_171, 3_947),
	42 : ( 45_529, 4_358),
	43 : ( 50_339, 4_810),
	44 : ( 55_649, 5_310),
	45 : ( 61_512, 5_863),
	46 : ( 67_983, 6_471),
	47 : ( 75_127, 7_144),
	48 : ( 83_014, 7_887),
	49 : ( 91_721, 8_707),
	50 : ( 101_333, 9_612),
	51 : ( 111_945, 10_612),
	52 : ( 123_660, 11_715),
	53 : ( 136_594, 12_934),
	54 : ( 150_872, 14_278),
	55 : ( 166_636, 15_764),
	56 : ( 184_040, 17_404),
	57 : ( 203_254, 19_214),
	58 : ( 224_466, 21_212),
	59 : ( 247_886, 23_420),
	60 : ( 273_742, 25_856),
	61 : ( 302_288, 28_546),
	62 : ( 333_804, 31_516),
	63 : ( 368_599, 34_795),
	64 : ( 407_015, 38_416),
	65 : ( 449_428, 42_413),
	66 : ( 496_254, 46_826),
	67 : ( 547_953, 51_699),
	68 : ( 605_032, 57_079),
	69 : ( 668_051, 63_019),
	70 : ( 737_627, 69_576),
	71 : ( 814_445, 76_818),
	72 : ( 899_257, 84_812),
	73 : ( 992_895, 93_638),
	74 : ( 1_096_278, 103_383),
	75 : ( 1_210_421, 114_143),
	76 : ( 1_336_443, 126_022),
	77 : ( 1_475_581, 139_138),
	78 : ( 1_629_200, 153_619),
	79 : ( 1_798_808, 169_608),
	80 : ( 1_986_068, 187_260),
	81 : ( 2_192_818, 206_750),
	82 : ( 2_421_087, 228_269),
	83 : ( 2_673_114, 252_027),
	84 : ( 2_951_373, 278_259),
	85 : ( 3_258_594, 307_221),
	86 : ( 3_597_792, 339_198),
	87 : ( 3_972_294, 374_502),
	88 : ( 4_385_776, 413_482),
	89 : ( 4_842_295, 456_519),
	90 : ( 5_346_332, 504_037),
	91 : ( 5_902_831, 556_499),
	92 : ( 6_517_253, 614_422),
	93 : ( 7_195_629, 678_376),
	94 : ( 7_944_614, 748_985),
	95 : ( 8_771_558, 826_944),
	96 : ( 9_684_577, 913_019),
	97 : ( 10_692_629, 1_008_052),
	98 : ( 11_805_606, 1_112_977),
	99 : ( 13_034_431, 1_228_825),
	100 : ( 14_391_160, 1_356_729),
	101 : ( 15_889_109, 1_497_949),
	102 : ( 17_542_976, 1_653_867),
	103 : ( 19_368_992, 1_826_016),
	104 : ( 21_385_073, 2_016_081),
	105 : ( 23_611_006, 2_225_933),
	106 : ( 26_068_632, 2_457_626),
	107 : ( 28_782_069, 2_713_437),
	108 : ( 31_777_943, 2_995_874),
	109 : ( 35_085_654, 3_307_711),
	110 : ( 38_737_661, 3_652_007),
	111 : ( 42_769_801, 4_032_140),
	112 : ( 47_221_641, 4_451_840),
	113 : ( 52_136_869, 4_915_228),
	114 : ( 57_563_718, 5_426_849),
	115 : ( 63_555_443, 5_991_725),
	116 : ( 70_170_840, 6_615_397),
	117 : ( 77_474_828, 7_303_988),
	118 : ( 85_539_082, 8_064_254),
	119 : ( 94_442_737, 8_903_655),
	120 : ( 104_273_167, 9_830_430),
	121 : ( 115_126_838, 10_853_671),
	122 : ( 127_110_260, 11_983_422),
	123 : ( 140_341_028, 13_230_768),
	124 : ( 154_948_977, 14_607_949),
	125 : ( 171_077_457, 16_128_480),
	126 : ( 188_884_740, 17_807_283),
	'max' : ( 200_000_000, 11_115_260),
}



class TestCombatLevel(unittest.TestCase):
	#  https://oldschool.tools/calculators/combat-level
	cmb = lambda self, a, s, r, m, d, h, p: combat_level({
		'attack': a, 'strength': s, 'ranged': r, 'magic': m, 'defence': d, 'hitpoints': h, 'prayer': p
	}, integer=False)

	def test_new_account_is_level_3(self):
		self.assertEqual(self.cmb(1, 1, 1, 1, 1, 10, 1), 3.4)

	def test_melee_based(self):
		self.assertAlmostEqual(self.cmb(80, 1, 1, 1, 1, 10, 1), 29.08, places=2)

	def test_ranged_based(self):
		self.assertAlmostEqual(self.cmb(80, 1, 98, 1, 1, 10, 1), 50.53, places=1)

	def test_mage_based(self):
		self.assertAlmostEqual(self.cmb(80, 1, 30, 97, 1, 10, 1), 49.88, places=1)

	def test_random_stats_for_melee_based(self):
		self.assertAlmostEqual(self.cmb(54, 87, 12, 93, 76, 18, 16), 71.33, places=2)

	def test_random_stats_for_ranged_based(self):
		self.assertAlmostEqual(self.cmb(54, 60, 90, 54, 76, 80, 43), 88.13, places=2)

	def test_random_stats_for_mage_based(self):
		self.assertAlmostEqual(self.cmb(54, 60, 38, 92, 76, 80, 43), 89.1, places=2)

	def test_exception_raised_if_missing_stat(self):
		self.assertRaises(ValueError, lambda: combat_level({
				'attack': 1, 'strength': 1, 'ranged': 1, 'magic': 1, 'defence': 1, 'hitpoints': 1
			}, integer=False)
		)

class TestExperienceUntilNextLevel(unittest.TestCase):
	def test_against_table(self):
		points = 0
		for level, (total, change) in XP_TABLE.items():
			if level == 1 or 'max':
				continue
			dE = experience_until_next_level(level)
			points += dE
			with self.subTest(level=level):
				self.assertEqual(total, floor(points))
				self.assertLess(abs(change - experience_until_next_level(level)), 1)
