(self["webpackChunk_jupyterlab_benchmarks_ui_profiler"] = self["webpackChunk_jupyterlab_benchmarks_ui_profiler"] || []).push([["vendors-node_modules_jupyterlab_json-extension_lib_component_js-node_modules_lumino_datagrid_-00b20a"],{

/***/ "../../node_modules/@jupyterlab/json-extension/lib/component.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/json-extension/lib/component.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Component": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "webpack/sharing/consume/default/@jupyterlab/translation");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_highlighter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-highlighter */ "../../node_modules/react-highlighter/lib/highlighter.js");
/* harmony import */ var react_highlighter__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_highlighter__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_json_tree__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-json-tree */ "../../node_modules/react-json-tree/lib/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * A component that renders JSON data as a collapsible tree.
 */
class Component extends react__WEBPACK_IMPORTED_MODULE_3__.Component {
    constructor() {
        super(...arguments);
        this.state = { filter: '', value: '' };
        this.timer = 0;
        this.handleChange = (event) => {
            const { value } = event.target;
            this.setState({ value });
            window.clearTimeout(this.timer);
            this.timer = window.setTimeout(() => {
                this.setState({ filter: value });
            }, 300);
        };
    }
    render() {
        const translator = this.props.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        const { data, metadata } = this.props;
        const root = metadata && metadata.root ? metadata.root : 'root';
        const keyPaths = this.state.filter
            ? filterPaths(data, this.state.filter, [root])
            : [root];
        return (react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", { className: "container" },
            react__WEBPACK_IMPORTED_MODULE_3__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.InputGroup, { className: "filter", type: "text", placeholder: trans.__('Filter…'), onChange: this.handleChange, value: this.state.value, rightIcon: "ui-components:search" }),
            react__WEBPACK_IMPORTED_MODULE_3__.createElement(react_json_tree__WEBPACK_IMPORTED_MODULE_5__["default"], { data: data, collectionLimit: 100, theme: {
                    extend: theme,
                    valueLabel: 'cm-variable',
                    valueText: 'cm-string',
                    nestedNodeItemString: 'cm-comment'
                }, invertTheme: false, keyPath: [root], getItemString: (type, data, itemType, itemString) => Array.isArray(data) ? (
                // Always display array type and the number of items i.e. "[] 2 items".
                react__WEBPACK_IMPORTED_MODULE_3__.createElement("span", null,
                    itemType,
                    " ",
                    itemString)) : Object.keys(data).length === 0 ? (
                // Only display object type when it's empty i.e. "{}".
                react__WEBPACK_IMPORTED_MODULE_3__.createElement("span", null, itemType)) : (null // Upstream typings don't accept null, but it should be ok
                ), labelRenderer: ([label, type]) => {
                    // let className = 'cm-variable';
                    // if (type === 'root') {
                    //   className = 'cm-variable-2';
                    // }
                    // if (type === 'array') {
                    //   className = 'cm-variable-2';
                    // }
                    // if (type === 'Object') {
                    //   className = 'cm-variable-3';
                    // }
                    return (react__WEBPACK_IMPORTED_MODULE_3__.createElement("span", { className: "cm-keyword" },
                        react__WEBPACK_IMPORTED_MODULE_3__.createElement((react_highlighter__WEBPACK_IMPORTED_MODULE_4___default()), { search: this.state.filter, matchStyle: { backgroundColor: 'yellow' } }, `${label}: `)));
                }, valueRenderer: raw => {
                    let className = 'cm-string';
                    if (typeof raw === 'number') {
                        className = 'cm-number';
                    }
                    if (raw === 'true' || raw === 'false') {
                        className = 'cm-keyword';
                    }
                    return (react__WEBPACK_IMPORTED_MODULE_3__.createElement("span", { className: className },
                        react__WEBPACK_IMPORTED_MODULE_3__.createElement((react_highlighter__WEBPACK_IMPORTED_MODULE_4___default()), { search: this.state.filter, matchStyle: { backgroundColor: 'yellow' } }, `${raw}`)));
                }, shouldExpandNode: (keyPath, data, level) => metadata && metadata.expanded
                    ? true
                    : keyPaths.join(',').includes(keyPath.join(',')) })));
    }
}
// Provide an invalid theme object (this is on purpose!) to invalidate the
// react-json-tree's inline styles that override CodeMirror CSS classes
const theme = {
    scheme: 'jupyter',
    base00: 'invalid',
    base01: 'invalid',
    base02: 'invalid',
    base03: 'invalid',
    base04: 'invalid',
    base05: 'invalid',
    base06: 'invalid',
    base07: 'invalid',
    base08: 'invalid',
    base09: 'invalid',
    base0A: 'invalid',
    base0B: 'invalid',
    base0C: 'invalid',
    base0D: 'invalid',
    base0E: 'invalid',
    base0F: 'invalid',
    author: 'invalid'
};
function objectIncludes(data, query) {
    return JSON.stringify(data).includes(query);
}
function filterPaths(data, query, parent = ['root']) {
    if (_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.JSONExt.isArray(data)) {
        return data.reduce((result, item, index) => {
            if (item && typeof item === 'object' && objectIncludes(item, query)) {
                return [
                    ...result,
                    [index, ...parent].join(','),
                    ...filterPaths(item, query, [index, ...parent])
                ];
            }
            return result;
        }, []);
    }
    if (_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.JSONExt.isObject(data)) {
        return Object.keys(data).reduce((result, key) => {
            const item = data[key];
            if (item &&
                typeof item === 'object' &&
                (key.includes(query) || objectIncludes(item, query))) {
                return [
                    ...result,
                    [key, ...parent].join(','),
                    ...filterPaths(item, query, [key, ...parent])
                ];
            }
            return result;
        }, []);
    }
    return [];
}
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "../../node_modules/@lumino/datagrid/dist/index.es6.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@lumino/datagrid/dist/index.es6.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BasicKeyHandler": () => (/* binding */ BasicKeyHandler),
/* harmony export */   "BasicMouseHandler": () => (/* binding */ BasicMouseHandler),
/* harmony export */   "BasicSelectionModel": () => (/* binding */ BasicSelectionModel),
/* harmony export */   "BooleanCellEditor": () => (/* binding */ BooleanCellEditor),
/* harmony export */   "CellEditor": () => (/* binding */ CellEditor),
/* harmony export */   "CellEditorController": () => (/* binding */ CellEditorController),
/* harmony export */   "CellGroup": () => (/* binding */ CellGroup),
/* harmony export */   "CellRenderer": () => (/* binding */ CellRenderer),
/* harmony export */   "DataGrid": () => (/* binding */ DataGrid),
/* harmony export */   "DataModel": () => (/* binding */ DataModel),
/* harmony export */   "DateCellEditor": () => (/* binding */ DateCellEditor),
/* harmony export */   "DynamicOptionCellEditor": () => (/* binding */ DynamicOptionCellEditor),
/* harmony export */   "GraphicsContext": () => (/* binding */ GraphicsContext),
/* harmony export */   "HyperlinkRenderer": () => (/* binding */ HyperlinkRenderer),
/* harmony export */   "InputCellEditor": () => (/* binding */ InputCellEditor),
/* harmony export */   "IntegerCellEditor": () => (/* binding */ IntegerCellEditor),
/* harmony export */   "IntegerInputValidator": () => (/* binding */ IntegerInputValidator),
/* harmony export */   "JSONModel": () => (/* binding */ JSONModel),
/* harmony export */   "MutableDataModel": () => (/* binding */ MutableDataModel),
/* harmony export */   "NumberCellEditor": () => (/* binding */ NumberCellEditor),
/* harmony export */   "NumberInputValidator": () => (/* binding */ NumberInputValidator),
/* harmony export */   "OptionCellEditor": () => (/* binding */ OptionCellEditor),
/* harmony export */   "PassInputValidator": () => (/* binding */ PassInputValidator),
/* harmony export */   "Private": () => (/* binding */ Private$6),
/* harmony export */   "RendererMap": () => (/* binding */ RendererMap),
/* harmony export */   "SectionList": () => (/* binding */ SectionList),
/* harmony export */   "SelectionModel": () => (/* binding */ SelectionModel),
/* harmony export */   "TextCellEditor": () => (/* binding */ TextCellEditor),
/* harmony export */   "TextInputValidator": () => (/* binding */ TextInputValidator),
/* harmony export */   "TextRenderer": () => (/* binding */ TextRenderer),
/* harmony export */   "resolveOption": () => (/* binding */ resolveOption)
/* harmony export */ });
/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/domutils */ "webpack/sharing/consume/default/@lumino/domutils");
/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_domutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_keyboard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/keyboard */ "../../node_modules/@lumino/keyboard/dist/index.es6.js");
/* harmony import */ var _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/dragdrop */ "webpack/sharing/consume/default/@lumino/dragdrop");
/* harmony import */ var _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_dragdrop__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/algorithm */ "webpack/sharing/consume/default/@lumino/algorithm");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/messaging */ "webpack/sharing/consume/default/@lumino/messaging");
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_lumino_messaging__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_7__);









// Copyright (c) Jupyter Development Team.
/**
 * A basic implementation of a data grid key handler.
 *
 * #### Notes
 * This class may be subclassed and customized as needed.
 */
var BasicKeyHandler = /** @class */ (function () {
    function BasicKeyHandler() {
        this._disposed = false;
    }
    Object.defineProperty(BasicKeyHandler.prototype, "isDisposed", {
        /**
         * Whether the key handler is disposed.
         */
        get: function () {
            return this._disposed;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Dispose of the resources held by the key handler.
     */
    BasicKeyHandler.prototype.dispose = function () {
        this._disposed = true;
    };
    /**
     * Handle the key down event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keydown event of interest.
     *
     * #### Notes
     * This will not be called if the mouse button is pressed.
     */
    BasicKeyHandler.prototype.onKeyDown = function (grid, event) {
        // if grid is editable and cell selection available, start cell editing
        // on key press (letters, numbers and space only)
        if (grid.editable &&
            grid.selectionModel.cursorRow !== -1 &&
            grid.selectionModel.cursorColumn !== -1) {
            var input = String.fromCharCode(event.keyCode);
            if (/[a-zA-Z0-9-_ ]/.test(input)) {
                var row = grid.selectionModel.cursorRow;
                var column = grid.selectionModel.cursorColumn;
                var cell = {
                    grid: grid,
                    row: row,
                    column: column
                };
                grid.editorController.edit(cell);
                if ((0,_lumino_keyboard__WEBPACK_IMPORTED_MODULE_1__.getKeyboardLayout)().keyForKeydownEvent(event) === 'Space') {
                    event.stopPropagation();
                    event.preventDefault();
                }
                return;
            }
        }
        switch ((0,_lumino_keyboard__WEBPACK_IMPORTED_MODULE_1__.getKeyboardLayout)().keyForKeydownEvent(event)) {
            case 'ArrowLeft':
                this.onArrowLeft(grid, event);
                break;
            case 'ArrowRight':
                this.onArrowRight(grid, event);
                break;
            case 'ArrowUp':
                this.onArrowUp(grid, event);
                break;
            case 'ArrowDown':
                this.onArrowDown(grid, event);
                break;
            case 'PageUp':
                this.onPageUp(grid, event);
                break;
            case 'PageDown':
                this.onPageDown(grid, event);
                break;
            case 'Escape':
                this.onEscape(grid, event);
                break;
            case 'Delete':
                this.onDelete(grid, event);
                break;
            case 'C':
                this.onKeyC(grid, event);
                break;
            case 'Enter':
                if (grid.selectionModel) {
                    grid.moveCursor(event.shiftKey ? 'up' : 'down');
                    grid.scrollToCursor();
                }
                break;
            case 'Tab':
                if (grid.selectionModel) {
                    grid.moveCursor(event.shiftKey ? 'left' : 'right');
                    grid.scrollToCursor();
                    event.stopPropagation();
                    event.preventDefault();
                }
                break;
        }
    };
    /**
     * Handle the `'ArrowLeft'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onArrowLeft = function (grid, event) {
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Fetch the modifier flags.
        var shift = event.shiftKey;
        var accel = _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event);
        // Handle no model with the accel modifier.
        if (!model && accel) {
            grid.scrollTo(0, grid.scrollY);
            return;
        }
        // Handle no model and no modifier. (ignore shift)
        if (!model) {
            grid.scrollByStep('left');
            return;
        }
        // Fetch the selection mode.
        var mode = model.selectionMode;
        // Handle the row selection mode with accel key.
        if (mode === 'row' && accel) {
            grid.scrollTo(0, grid.scrollY);
            return;
        }
        // Handle the row selection mode with no modifier. (ignore shift)
        if (mode === 'row') {
            grid.scrollByStep('left');
            return;
        }
        // Fetch the cursor and selection.
        var r = model.cursorRow;
        var c = model.cursorColumn;
        var cs = model.currentSelection();
        // Set up the selection variables.
        var r1;
        var r2;
        var c1;
        var c2;
        var cr;
        var cc;
        var clear;
        // Dispatch based on the modifier keys.
        if (accel && shift) {
            r1 = cs ? cs.r1 : 0;
            r2 = cs ? cs.r2 : 0;
            c1 = cs ? cs.c1 : 0;
            c2 = 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else if (shift) {
            r1 = cs ? cs.r1 : 0;
            r2 = cs ? cs.r2 : 0;
            c1 = cs ? cs.c1 : 0;
            c2 = cs ? cs.c2 - 1 : 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else if (accel) {
            r1 = r;
            r2 = r;
            c1 = 0;
            c2 = 0;
            cr = r1;
            cc = c1;
            clear = 'all';
        }
        else {
            r1 = r;
            r2 = r;
            c1 = c - 1;
            c2 = c - 1;
            cr = r1;
            cc = c1;
            clear = 'all';
        }
        // Create the new selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cr, cursorColumn: cc, clear: clear });
        // Re-fetch the current selection.
        cs = model.currentSelection();
        // Bail if there is no selection.
        if (!cs) {
            return;
        }
        // Scroll the grid appropriately.
        if (shift || mode === 'column') {
            grid.scrollToColumn(cs.c2);
        }
        else {
            grid.scrollToCursor();
        }
    };
    /**
     * Handle the `'ArrowRight'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onArrowRight = function (grid, event) {
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Fetch the modifier flags.
        var shift = event.shiftKey;
        var accel = _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event);
        // Handle no model with the accel modifier.
        if (!model && accel) {
            grid.scrollTo(grid.maxScrollX, grid.scrollY);
            return;
        }
        // Handle no model and no modifier. (ignore shift)
        if (!model) {
            grid.scrollByStep('right');
            return;
        }
        // Fetch the selection mode.
        var mode = model.selectionMode;
        // Handle the row selection model with accel key.
        if (mode === 'row' && accel) {
            grid.scrollTo(grid.maxScrollX, grid.scrollY);
            return;
        }
        // Handle the row selection mode with no modifier. (ignore shift)
        if (mode === 'row') {
            grid.scrollByStep('right');
            return;
        }
        // Fetch the cursor and selection.
        var r = model.cursorRow;
        var c = model.cursorColumn;
        var cs = model.currentSelection();
        // Set up the selection variables.
        var r1;
        var r2;
        var c1;
        var c2;
        var cr;
        var cc;
        var clear;
        // Dispatch based on the modifier keys.
        if (accel && shift) {
            r1 = cs ? cs.r1 : 0;
            r2 = cs ? cs.r2 : 0;
            c1 = cs ? cs.c1 : 0;
            c2 = Infinity;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else if (shift) {
            r1 = cs ? cs.r1 : 0;
            r2 = cs ? cs.r2 : 0;
            c1 = cs ? cs.c1 : 0;
            c2 = cs ? cs.c2 + 1 : 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else if (accel) {
            r1 = r;
            r2 = r;
            c1 = Infinity;
            c2 = Infinity;
            cr = r1;
            cc = c1;
            clear = 'all';
        }
        else {
            r1 = r;
            r2 = r;
            c1 = c + 1;
            c2 = c + 1;
            cr = r1;
            cc = c1;
            clear = 'all';
        }
        // Create the new selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cr, cursorColumn: cc, clear: clear });
        // Re-fetch the current selection.
        cs = model.currentSelection();
        // Bail if there is no selection.
        if (!cs) {
            return;
        }
        // Scroll the grid appropriately.
        if (shift || mode === 'column') {
            grid.scrollToColumn(cs.c2);
        }
        else {
            grid.scrollToCursor();
        }
    };
    /**
     * Handle the `'ArrowUp'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onArrowUp = function (grid, event) {
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Fetch the modifier flags.
        var shift = event.shiftKey;
        var accel = _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event);
        // Handle no model with the accel modifier.
        if (!model && accel) {
            grid.scrollTo(grid.scrollX, 0);
            return;
        }
        // Handle no model and no modifier. (ignore shift)
        if (!model) {
            grid.scrollByStep('up');
            return;
        }
        // Fetch the selection mode.
        var mode = model.selectionMode;
        // Handle the column selection mode with accel key.
        if (mode === 'column' && accel) {
            grid.scrollTo(grid.scrollX, 0);
            return;
        }
        // Handle the column selection mode with no modifier. (ignore shift)
        if (mode === 'column') {
            grid.scrollByStep('up');
            return;
        }
        // Fetch the cursor and selection.
        var r = model.cursorRow;
        var c = model.cursorColumn;
        var cs = model.currentSelection();
        // Set up the selection variables.
        var r1;
        var r2;
        var c1;
        var c2;
        var cr;
        var cc;
        var clear;
        // Dispatch based on the modifier keys.
        if (accel && shift) {
            r1 = cs ? cs.r1 : 0;
            r2 = 0;
            c1 = cs ? cs.c1 : 0;
            c2 = cs ? cs.c2 : 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else if (shift) {
            r1 = cs ? cs.r1 : 0;
            r2 = cs ? cs.r2 - 1 : 0;
            c1 = cs ? cs.c1 : 0;
            c2 = cs ? cs.c2 : 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else if (accel) {
            r1 = 0;
            r2 = 0;
            c1 = c;
            c2 = c;
            cr = r1;
            cc = c1;
            clear = 'all';
        }
        else {
            r1 = r - 1;
            r2 = r - 1;
            c1 = c;
            c2 = c;
            cr = r1;
            cc = c1;
            clear = 'all';
        }
        // Create the new selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cr, cursorColumn: cc, clear: clear });
        // Re-fetch the current selection.
        cs = model.currentSelection();
        // Bail if there is no selection.
        if (!cs) {
            return;
        }
        // Scroll the grid appropriately.
        if (shift || mode === 'row') {
            grid.scrollToRow(cs.r2);
        }
        else {
            grid.scrollToCursor();
        }
    };
    /**
     * Handle the `'ArrowDown'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onArrowDown = function (grid, event) {
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Fetch the modifier flags.
        var shift = event.shiftKey;
        var accel = _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event);
        // Handle no model with the accel modifier.
        if (!model && accel) {
            grid.scrollTo(grid.scrollX, grid.maxScrollY);
            return;
        }
        // Handle no model and no modifier. (ignore shift)
        if (!model) {
            grid.scrollByStep('down');
            return;
        }
        // Fetch the selection mode.
        var mode = model.selectionMode;
        // Handle the column selection mode with accel key.
        if (mode === 'column' && accel) {
            grid.scrollTo(grid.scrollX, grid.maxScrollY);
            return;
        }
        // Handle the column selection mode with no modifier. (ignore shift)
        if (mode === 'column') {
            grid.scrollByStep('down');
            return;
        }
        // Fetch the cursor and selection.
        var r = model.cursorRow;
        var c = model.cursorColumn;
        var cs = model.currentSelection();
        // Set up the selection variables.
        var r1;
        var r2;
        var c1;
        var c2;
        var cr;
        var cc;
        var clear;
        // Dispatch based on the modifier keys.
        if (accel && shift) {
            r1 = cs ? cs.r1 : 0;
            r2 = Infinity;
            c1 = cs ? cs.c1 : 0;
            c2 = cs ? cs.c2 : 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else if (shift) {
            r1 = cs ? cs.r1 : 0;
            r2 = cs ? cs.r2 + 1 : 0;
            c1 = cs ? cs.c1 : 0;
            c2 = cs ? cs.c2 : 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else if (accel) {
            r1 = Infinity;
            r2 = Infinity;
            c1 = c;
            c2 = c;
            cr = r1;
            cc = c1;
            clear = 'all';
        }
        else {
            r1 = r + 1;
            r2 = r + 1;
            c1 = c;
            c2 = c;
            cr = r1;
            cc = c1;
            clear = 'all';
        }
        // Create the new selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cr, cursorColumn: cc, clear: clear });
        // Re-fetch the current selection.
        cs = model.currentSelection();
        // Bail if there is no selection.
        if (!cs) {
            return;
        }
        // Scroll the grid appropriately.
        if (shift || mode === 'row') {
            grid.scrollToRow(cs.r2);
        }
        else {
            grid.scrollToCursor();
        }
    };
    /**
     * Handle the `'PageUp'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onPageUp = function (grid, event) {
        // Ignore the event if the accel key is pressed.
        if (_lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event)) {
            return;
        }
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Scroll by page if there is no selection model.
        if (!model || model.selectionMode === 'column') {
            grid.scrollByPage('up');
            return;
        }
        // Get the normal number of cells in the page height.
        var n = Math.floor(grid.pageHeight / grid.defaultSizes.rowHeight);
        // Fetch the cursor and selection.
        var r = model.cursorRow;
        var c = model.cursorColumn;
        var cs = model.currentSelection();
        // Set up the selection variables.
        var r1;
        var r2;
        var c1;
        var c2;
        var cr;
        var cc;
        var clear;
        // Select or resize as needed.
        if (event.shiftKey) {
            r1 = cs ? cs.r1 : 0;
            r2 = cs ? cs.r2 - n : 0;
            c1 = cs ? cs.c1 : 0;
            c2 = cs ? cs.c2 : 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else {
            r1 = cs ? cs.r1 - n : 0;
            r2 = r1;
            c1 = c;
            c2 = c;
            cr = r1;
            cc = c;
            clear = 'all';
        }
        // Create the new selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cr, cursorColumn: cc, clear: clear });
        // Re-fetch the current selection.
        cs = model.currentSelection();
        // Bail if there is no selection.
        if (!cs) {
            return;
        }
        // Scroll the grid appropriately.
        grid.scrollToRow(cs.r2);
    };
    /**
     * Handle the `'PageDown'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onPageDown = function (grid, event) {
        // Ignore the event if the accel key is pressed.
        if (_lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event)) {
            return;
        }
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Scroll by page if there is no selection model.
        if (!model || model.selectionMode === 'column') {
            grid.scrollByPage('down');
            return;
        }
        // Get the normal number of cells in the page height.
        var n = Math.floor(grid.pageHeight / grid.defaultSizes.rowHeight);
        // Fetch the cursor and selection.
        var r = model.cursorRow;
        var c = model.cursorColumn;
        var cs = model.currentSelection();
        // Set up the selection variables.
        var r1;
        var r2;
        var c1;
        var c2;
        var cr;
        var cc;
        var clear;
        // Select or resize as needed.
        if (event.shiftKey) {
            r1 = cs ? cs.r1 : 0;
            r2 = cs ? cs.r2 + n : 0;
            c1 = cs ? cs.c1 : 0;
            c2 = cs ? cs.c2 : 0;
            cr = r;
            cc = c;
            clear = 'current';
        }
        else {
            r1 = cs ? cs.r1 + n : 0;
            r2 = r1;
            c1 = c;
            c2 = c;
            cr = r1;
            cc = c;
            clear = 'all';
        }
        // Create the new selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cr, cursorColumn: cc, clear: clear });
        // Re-fetch the current selection.
        cs = model.currentSelection();
        // Bail if there is no selection.
        if (!cs) {
            return;
        }
        // Scroll the grid appropriately.
        grid.scrollToRow(cs.r2);
    };
    /**
     * Handle the `'Escape'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onEscape = function (grid, event) {
        if (grid.selectionModel) {
            grid.selectionModel.clear();
        }
    };
    /**
     * Handle the `'Delete'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onDelete = function (grid, event) {
        if (grid.editable && !grid.selectionModel.isEmpty) {
            var dataModel = grid.dataModel;
            // Fetch the max row and column.
            var maxRow = dataModel.rowCount('body') - 1;
            var maxColumn = dataModel.columnCount('body') - 1;
            var it = grid.selectionModel.selections();
            var s = void 0;
            while ((s = it.next()) !== undefined) {
                // Clamp the cell to the model bounds.
                var sr1 = Math.max(0, Math.min(s.r1, maxRow));
                var sc1 = Math.max(0, Math.min(s.c1, maxColumn));
                var sr2 = Math.max(0, Math.min(s.r2, maxRow));
                var sc2 = Math.max(0, Math.min(s.c2, maxColumn));
                for (var r = sr1; r <= sr2; ++r) {
                    for (var c = sc1; c <= sc2; ++c) {
                        dataModel.setData('body', r, c, null);
                    }
                }
            }
        }
    };
    /**
     * Handle the `'C'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    BasicKeyHandler.prototype.onKeyC = function (grid, event) {
        // Bail early if the modifiers aren't correct for copy.
        if (event.shiftKey || !_lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event)) {
            return;
        }
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Copy the current selection to the clipboard.
        grid.copyToClipboard();
    };
    return BasicKeyHandler;
}());

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

/**
 * An object which renders the cells of a data grid.
 *
 * #### Notes
 * If the predefined cell renderers are insufficient for a particular
 * use case, a custom cell renderer can be defined which derives from
 * this class.
 *
 * The data grid renders cells in column-major order, by region. The
 * region order is: body, row header, column header, corner header.
 */
var CellRenderer = /** @class */ (function () {
    function CellRenderer() {
    }
    return CellRenderer;
}());
/**
 * The namespace for the `CellRenderer` class statics.
 */
(function (CellRenderer) {
    /**
     * Resolve a config option for a cell renderer.
     *
     * @param option - The config option to resolve.
     *
     * @param config - The cell config object.
     *
     * @returns The resolved value for the option.
     */
    function resolveOption(option, config) {
        return typeof option === 'function'
            ? option(config)
            : option;
    }
    CellRenderer.resolveOption = resolveOption;
})(CellRenderer || (CellRenderer = {}));

/**
 * A cell renderer which renders data values as text.
 */
var TextRenderer = /** @class */ (function (_super) {
    __extends(TextRenderer, _super);
    /**
     * Construct a new text renderer.
     *
     * @param options - The options for initializing the renderer.
     */
    function TextRenderer(options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this) || this;
        _this.font = options.font || '12px sans-serif';
        _this.textColor = options.textColor || '#000000';
        _this.backgroundColor = options.backgroundColor || '';
        _this.verticalAlignment = options.verticalAlignment || 'center';
        _this.horizontalAlignment = options.horizontalAlignment || 'left';
        _this.format = options.format || TextRenderer.formatGeneric();
        _this.elideDirection = options.elideDirection || 'right';
        _this.wrapText = options.wrapText || false;
        return _this;
    }
    /**
     * Paint the content for a cell.
     *
     * @param gc - The graphics context to use for drawing.
     *
     * @param config - The configuration data for the cell.
     */
    TextRenderer.prototype.paint = function (gc, config) {
        this.drawBackground(gc, config);
        this.drawText(gc, config);
    };
    /**
     * Draw the background for the cell.
     *
     * @param gc - The graphics context to use for drawing.
     *
     * @param config - The configuration data for the cell.
     */
    TextRenderer.prototype.drawBackground = function (gc, config) {
        // Resolve the background color for the cell.
        var color = CellRenderer.resolveOption(this.backgroundColor, config);
        // Bail if there is no background color to draw.
        if (!color) {
            return;
        }
        // Fill the cell with the background color.
        gc.fillStyle = color;
        gc.fillRect(config.x, config.y, config.width, config.height);
    };
    /**
     * Draw the text for the cell.
     *
     * @param gc - The graphics context to use for drawing.
     *
     * @param config - The configuration data for the cell.
     */
    TextRenderer.prototype.drawText = function (gc, config) {
        // Resolve the font for the cell.
        var font = CellRenderer.resolveOption(this.font, config);
        // Bail if there is no font to draw.
        if (!font) {
            return;
        }
        // Resolve the text color for the cell.
        var color = CellRenderer.resolveOption(this.textColor, config);
        // Bail if there is no text color to draw.
        if (!color) {
            return;
        }
        // Format the cell value to text.
        var format = this.format;
        var text = format(config);
        // Bail if there is no text to draw.
        if (!text) {
            return;
        }
        // Resolve the vertical and horizontal alignment.
        var vAlign = CellRenderer.resolveOption(this.verticalAlignment, config);
        var hAlign = CellRenderer.resolveOption(this.horizontalAlignment, config);
        // Resolve the elision direction
        var elideDirection = CellRenderer.resolveOption(this.elideDirection, config);
        // Resolve the text wrapping flag
        var wrapText = CellRenderer.resolveOption(this.wrapText, config);
        // Compute the padded text box height for the specified alignment.
        var boxHeight = config.height - (vAlign === 'center' ? 1 : 2);
        // Bail if the text box has no effective size.
        if (boxHeight <= 0) {
            return;
        }
        // Compute the text height for the gc font.
        var textHeight = TextRenderer.measureFontHeight(font);
        // Set up the text position variables.
        var textX;
        var textY;
        var boxWidth;
        // Compute the Y position for the text.
        switch (vAlign) {
            case 'top':
                textY = config.y + 2 + textHeight;
                break;
            case 'center':
                textY = config.y + config.height / 2 + textHeight / 2;
                break;
            case 'bottom':
                textY = config.y + config.height - 2;
                break;
            default:
                throw 'unreachable';
        }
        // Compute the X position for the text.
        switch (hAlign) {
            case 'left':
                textX = config.x + 8;
                boxWidth = config.width - 14;
                break;
            case 'center':
                textX = config.x + config.width / 2;
                boxWidth = config.width;
                break;
            case 'right':
                textX = config.x + config.width - 8;
                boxWidth = config.width - 14;
                break;
            default:
                throw 'unreachable';
        }
        // Clip the cell if the text is taller than the text box height.
        if (textHeight > boxHeight) {
            gc.beginPath();
            gc.rect(config.x, config.y, config.width, config.height - 1);
            gc.clip();
        }
        // Set the gc state.
        gc.font = font;
        gc.fillStyle = color;
        gc.textAlign = hAlign;
        gc.textBaseline = 'bottom';
        // The current text width in pixels.
        var textWidth = gc.measureText(text).width;
        // Apply text wrapping if enabled.
        if (wrapText && textWidth > boxWidth) {
            // Make sure box clipping happens.
            gc.beginPath();
            gc.rect(config.x, config.y, config.width, config.height - 1);
            gc.clip();
            // Split column name to words based on
            // whitespace preceding a word boundary.
            // "Hello  world" --> ["Hello  ", "world"]
            var wordsInColumn = text.split(/\s(?=\b)/);
            // Y-coordinate offset for any additional lines
            var curY = textY;
            var textInCurrentLine = wordsInColumn.shift();
            // Single word. Applying text wrap on word by splitting
            // it into characters and fitting the maximum number of
            // characters possible per line (box width).
            if (wordsInColumn.length === 0) {
                var curLineTextWidth = gc.measureText(textInCurrentLine).width;
                while (curLineTextWidth > boxWidth && textInCurrentLine !== '') {
                    // Iterating from the end of the string until we find a
                    // substring (0,i) which has a width less than the box width.
                    for (var i = textInCurrentLine.length; i > 0; i--) {
                        var curSubString = textInCurrentLine.substring(0, i);
                        var curSubStringWidth = gc.measureText(curSubString).width;
                        if (curSubStringWidth < boxWidth || curSubString.length === 1) {
                            // Found a substring which has a width less than the current
                            // box width. Rendering that substring on the current line
                            // and setting the remainder of the parent string as the next
                            // string to iterate on for the next line.
                            var nextLineText = textInCurrentLine.substring(i, textInCurrentLine.length);
                            textInCurrentLine = nextLineText;
                            curLineTextWidth = gc.measureText(textInCurrentLine).width;
                            gc.fillText(curSubString, textX, curY);
                            curY += textHeight;
                            // No need to continue iterating after we identified
                            // an index to break the string on.
                            break;
                        }
                    }
                }
            }
            // Multiple words in column header. Fitting maximum
            // number of words possible per line (box width).
            else {
                while (wordsInColumn.length !== 0) {
                    // Processing the next word in the queue.
                    var curWord = wordsInColumn.shift();
                    // Joining that word with the existing text for
                    // the current line.
                    var incrementedText = [textInCurrentLine, curWord].join(' ');
                    var incrementedTextWidth = gc.measureText(incrementedText).width;
                    if (incrementedTextWidth > boxWidth) {
                        // If the newly combined text has a width larger than
                        // the box width, we render the line before the current
                        // word was added. We set the current word as the next
                        // line.
                        gc.fillText(textInCurrentLine, textX, curY);
                        curY += textHeight;
                        textInCurrentLine = curWord;
                    }
                    else {
                        // The combined text hasd a width less than the box width. We
                        // set the the current line text to be the new combined text.
                        textInCurrentLine = incrementedText;
                    }
                }
            }
            gc.fillText(textInCurrentLine, textX, curY);
            // Terminating the call here as we don't want
            // to apply text eliding when wrapping is active.
            return;
        }
        // Elide text that is too long
        var elide = '\u2026';
        // Compute elided text
        if (elideDirection === 'right') {
            while (textWidth > boxWidth && text.length > 1) {
                if (text.length > 4 && textWidth >= 2 * boxWidth) {
                    // If text width is substantially bigger, take half the string
                    text = text.substring(0, text.length / 2 + 1) + elide;
                }
                else {
                    // Otherwise incrementally remove the last character
                    text = text.substring(0, text.length - 2) + elide;
                }
                textWidth = gc.measureText(text).width;
            }
        }
        else {
            while (textWidth > boxWidth && text.length > 1) {
                if (text.length > 4 && textWidth >= 2 * boxWidth) {
                    // If text width is substantially bigger, take half the string
                    text = elide + text.substring(text.length / 2);
                }
                else {
                    // Otherwise incrementally remove the last character
                    text = elide + text.substring(2);
                }
                textWidth = gc.measureText(text).width;
            }
        }
        // Draw the text for the cell.
        gc.fillText(text, textX, textY);
    };
    return TextRenderer;
}(CellRenderer));
/**
 * The namespace for the `TextRenderer` class statics.
 */
(function (TextRenderer) {
    /**
     * Create a generic text format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new generic text format function.
     *
     * #### Notes
     * This formatter uses the builtin `String()` to coerce any value
     * to a string.
     */
    function formatGeneric(options) {
        if (options === void 0) { options = {}; }
        var missing = options.missing || '';
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            return String(value);
        };
    }
    TextRenderer.formatGeneric = formatGeneric;
    /**
     * Create a fixed decimal format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new fixed decimal format function.
     *
     * #### Notes
     * This formatter uses the builtin `Number()` and `toFixed()` to
     * coerce values.
     *
     * The `formatIntlNumber()` formatter is more flexible, but slower.
     */
    function formatFixed(options) {
        if (options === void 0) { options = {}; }
        var digits = options.digits;
        var missing = options.missing || '';
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            return Number(value).toFixed(digits);
        };
    }
    TextRenderer.formatFixed = formatFixed;
    /**
     * Create a significant figure format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new significant figure format function.
     *
     * #### Notes
     * This formatter uses the builtin `Number()` and `toPrecision()`
     * to coerce values.
     *
     * The `formatIntlNumber()` formatter is more flexible, but slower.
     */
    function formatPrecision(options) {
        if (options === void 0) { options = {}; }
        var digits = options.digits;
        var missing = options.missing || '';
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            return Number(value).toPrecision(digits);
        };
    }
    TextRenderer.formatPrecision = formatPrecision;
    /**
     * Create a scientific notation format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new scientific notation format function.
     *
     * #### Notes
     * This formatter uses the builtin `Number()` and `toExponential()`
     * to coerce values.
     *
     * The `formatIntlNumber()` formatter is more flexible, but slower.
     */
    function formatExponential(options) {
        if (options === void 0) { options = {}; }
        var digits = options.digits;
        var missing = options.missing || '';
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            return Number(value).toExponential(digits);
        };
    }
    TextRenderer.formatExponential = formatExponential;
    /**
     * Create an international number format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new international number format function.
     *
     * #### Notes
     * This formatter uses the builtin `Intl.NumberFormat` object to
     * coerce values.
     *
     * This is the most flexible (but slowest) number formatter.
     */
    function formatIntlNumber(options) {
        if (options === void 0) { options = {}; }
        var missing = options.missing || '';
        var nft = new Intl.NumberFormat(options.locales, options.options);
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            return nft.format(value);
        };
    }
    TextRenderer.formatIntlNumber = formatIntlNumber;
    /**
     * Create a date format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new date format function.
     *
     * #### Notes
     * This formatter uses `Date.toDateString()` to format the values.
     *
     * If a value is not a `Date` object, `new Date(value)` is used to
     * coerce the value to a date.
     *
     * The `formatIntlDateTime()` formatter is more flexible, but slower.
     */
    function formatDate(options) {
        if (options === void 0) { options = {}; }
        var missing = options.missing || '';
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            if (value instanceof Date) {
                return value.toDateString();
            }
            return new Date(value).toDateString();
        };
    }
    TextRenderer.formatDate = formatDate;
    /**
     * Create a time format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new time format function.
     *
     * #### Notes
     * This formatter uses `Date.toTimeString()` to format the values.
     *
     * If a value is not a `Date` object, `new Date(value)` is used to
     * coerce the value to a date.
     *
     * The `formatIntlDateTime()` formatter is more flexible, but slower.
     */
    function formatTime(options) {
        if (options === void 0) { options = {}; }
        var missing = options.missing || '';
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            if (value instanceof Date) {
                return value.toTimeString();
            }
            return new Date(value).toTimeString();
        };
    }
    TextRenderer.formatTime = formatTime;
    /**
     * Create an ISO datetime format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new ISO datetime format function.
     *
     * #### Notes
     * This formatter uses `Date.toISOString()` to format the values.
     *
     * If a value is not a `Date` object, `new Date(value)` is used to
     * coerce the value to a date.
     *
     * The `formatIntlDateTime()` formatter is more flexible, but slower.
     */
    function formatISODateTime(options) {
        if (options === void 0) { options = {}; }
        var missing = options.missing || '';
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            if (value instanceof Date) {
                return value.toISOString();
            }
            return new Date(value).toISOString();
        };
    }
    TextRenderer.formatISODateTime = formatISODateTime;
    /**
     * Create a UTC datetime format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new UTC datetime format function.
     *
     * #### Notes
     * This formatter uses `Date.toUTCString()` to format the values.
     *
     * If a value is not a `Date` object, `new Date(value)` is used to
     * coerce the value to a date.
     *
     * The `formatIntlDateTime()` formatter is more flexible, but slower.
     */
    function formatUTCDateTime(options) {
        if (options === void 0) { options = {}; }
        var missing = options.missing || '';
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            if (value instanceof Date) {
                return value.toUTCString();
            }
            return new Date(value).toUTCString();
        };
    }
    TextRenderer.formatUTCDateTime = formatUTCDateTime;
    /**
     * Create an international datetime format function.
     *
     * @param options - The options for creating the format function.
     *
     * @returns A new international datetime format function.
     *
     * #### Notes
     * This formatter uses the builtin `Intl.DateTimeFormat` object to
     * coerce values.
     *
     * This is the most flexible (but slowest) datetime formatter.
     */
    function formatIntlDateTime(options) {
        if (options === void 0) { options = {}; }
        var missing = options.missing || '';
        var dtf = new Intl.DateTimeFormat(options.locales, options.options);
        return function (_a) {
            var value = _a.value;
            if (value === null || value === undefined) {
                return missing;
            }
            return dtf.format(value);
        };
    }
    TextRenderer.formatIntlDateTime = formatIntlDateTime;
    /**
     * Measure the height of a font.
     *
     * @param font - The CSS font string of interest.
     *
     * @returns The height of the font bounding box.
     *
     * #### Notes
     * This function uses a temporary DOM node to measure the text box
     * height for the specified font. The first call for a given font
     * will incur a DOM reflow, but the return value is cached, so any
     * subsequent call for the same font will return the cached value.
     */
    function measureFontHeight(font) {
        // Look up the cached font height.
        var height = Private$7.fontHeightCache[font];
        // Return the cached font height if it exists.
        if (height !== undefined) {
            return height;
        }
        // Normalize the font.
        Private$7.fontMeasurementGC.font = font;
        var normFont = Private$7.fontMeasurementGC.font;
        // Set the font on the measurement node.
        Private$7.fontMeasurementNode.style.font = normFont;
        // Add the measurement node to the document.
        document.body.appendChild(Private$7.fontMeasurementNode);
        // Measure the node height.
        height = Private$7.fontMeasurementNode.offsetHeight;
        // Remove the measurement node from the document.
        document.body.removeChild(Private$7.fontMeasurementNode);
        // Cache the measured height for the font and norm font.
        Private$7.fontHeightCache[font] = height;
        Private$7.fontHeightCache[normFont] = height;
        // Return the measured height.
        return height;
    }
    TextRenderer.measureFontHeight = measureFontHeight;
})(TextRenderer || (TextRenderer = {}));
/**
 * The namespace for the module implementation details.
 */
var Private$7;
(function (Private) {
    /**
     * A cache of measured font heights.
     */
    Private.fontHeightCache = Object.create(null);
    /**
     * The DOM node used for font height measurement.
     */
    Private.fontMeasurementNode = (function () {
        var node = document.createElement('div');
        node.style.position = 'absolute';
        node.style.top = '-99999px';
        node.style.left = '-99999px';
        node.style.visibility = 'hidden';
        node.textContent = 'M';
        return node;
    })();
    /**
     * The GC used for font measurement.
     */
    Private.fontMeasurementGC = (function () {
        var canvas = document.createElement('canvas');
        canvas.width = 0;
        canvas.height = 0;
        return canvas.getContext('2d');
    })();
})(Private$7 || (Private$7 = {}));

/**
 * A cell renderer which renders data values as text.
 */
var HyperlinkRenderer = /** @class */ (function (_super) {
    __extends(HyperlinkRenderer, _super);
    /**
     * Construct a new text renderer.
     *
     * @param options - The options for initializing the renderer.
     */
    function HyperlinkRenderer(options) {
        if (options === void 0) { options = {}; }
        var _this = this;
        // Set default parameters before passing over the super.
        options.textColor = options.textColor || 'navy';
        options.font = options.font || 'bold 12px sans-serif';
        _this = _super.call(this, options) || this;
        _this.url = options.url;
        _this.urlName = options.urlName;
        return _this;
    }
    /**
     * Draw the text for the cell.
     *
     * @param gc - The graphics context to use for drawing.
     *
     * @param config - The configuration data for the cell.
     */
    HyperlinkRenderer.prototype.drawText = function (gc, config) {
        // Resolve the font for the cell.
        var font = CellRenderer.resolveOption(this.font, config);
        // Bail if there is no font to draw.
        if (!font) {
            return;
        }
        // Resolve for the friendly URL name.
        var urlName = CellRenderer.resolveOption(this.urlName, config);
        // Resolve the text color for the cell.
        var color = CellRenderer.resolveOption(this.textColor, config);
        // Bail if there is no text color to draw.
        if (!color) {
            return;
        }
        var format = this.format;
        var text;
        // If we have a friendly URL name, use that.
        if (urlName) {
            text = format(__assign(__assign({}, config), { value: urlName }));
        }
        else {
            // Otherwise use the raw value attribute.
            text = format(config);
        }
        // Bail if there is no text to draw.
        if (!text) {
            return;
        }
        // Resolve the vertical and horizontal alignment.
        var vAlign = CellRenderer.resolveOption(this.verticalAlignment, config);
        var hAlign = CellRenderer.resolveOption(this.horizontalAlignment, config);
        // Resolve the elision direction
        var elideDirection = CellRenderer.resolveOption(this.elideDirection, config);
        // Resolve the text wrapping flag
        var wrapText = CellRenderer.resolveOption(this.wrapText, config);
        // Compute the padded text box height for the specified alignment.
        var boxHeight = config.height - (vAlign === 'center' ? 1 : 2);
        // Bail if the text box has no effective size.
        if (boxHeight <= 0) {
            return;
        }
        // Compute the text height for the gc font.
        var textHeight = HyperlinkRenderer.measureFontHeight(font);
        // Set up the text position variables.
        var textX;
        var textY;
        var boxWidth;
        // Compute the Y position for the text.
        switch (vAlign) {
            case 'top':
                textY = config.y + 2 + textHeight;
                break;
            case 'center':
                textY = config.y + config.height / 2 + textHeight / 2;
                break;
            case 'bottom':
                textY = config.y + config.height - 2;
                break;
            default:
                throw 'unreachable';
        }
        // Compute the X position for the text.
        switch (hAlign) {
            case 'left':
                textX = config.x + 8;
                boxWidth = config.width - 14;
                break;
            case 'center':
                textX = config.x + config.width / 2;
                boxWidth = config.width;
                break;
            case 'right':
                textX = config.x + config.width - 8;
                boxWidth = config.width - 14;
                break;
            default:
                throw 'unreachable';
        }
        // Clip the cell if the text is taller than the text box height.
        if (textHeight > boxHeight) {
            gc.beginPath();
            gc.rect(config.x, config.y, config.width, config.height - 1);
            gc.clip();
        }
        // Set the gc state.
        gc.font = font;
        gc.fillStyle = color;
        gc.textAlign = hAlign;
        gc.textBaseline = 'bottom';
        // The current text width in pixels.
        var textWidth = gc.measureText(text).width;
        // Apply text wrapping if enabled.
        if (wrapText && textWidth > boxWidth) {
            // Make sure box clipping happens.
            gc.beginPath();
            gc.rect(config.x, config.y, config.width, config.height - 1);
            gc.clip();
            // Split column name to words based on
            // whitespace preceding a word boundary.
            // "Hello  world" --> ["Hello  ", "world"]
            var wordsInColumn = text.split(/\s(?=\b)/);
            // Y-coordinate offset for any additional lines
            var curY = textY;
            var textInCurrentLine = wordsInColumn.shift();
            // Single word. Applying text wrap on word by splitting
            // it into characters and fitting the maximum number of
            // characters possible per line (box width).
            if (wordsInColumn.length === 0) {
                var curLineTextWidth = gc.measureText(textInCurrentLine).width;
                while (curLineTextWidth > boxWidth && textInCurrentLine !== '') {
                    // Iterating from the end of the string until we find a
                    // substring (0,i) which has a width less than the box width.
                    for (var i = textInCurrentLine.length; i > 0; i--) {
                        var curSubString = textInCurrentLine.substring(0, i);
                        var curSubStringWidth = gc.measureText(curSubString).width;
                        if (curSubStringWidth < boxWidth || curSubString.length === 1) {
                            // Found a substring which has a width less than the current
                            // box width. Rendering that substring on the current line
                            // and setting the remainder of the parent string as the next
                            // string to iterate on for the next line.
                            var nextLineText = textInCurrentLine.substring(i, textInCurrentLine.length);
                            textInCurrentLine = nextLineText;
                            curLineTextWidth = gc.measureText(textInCurrentLine).width;
                            gc.fillText(curSubString, textX, curY);
                            curY += textHeight;
                            // No need to continue iterating after we identified
                            // an index to break the string on.
                            break;
                        }
                    }
                }
            }
            // Multiple words in column header. Fitting maximum
            // number of words possible per line (box width).
            else {
                while (wordsInColumn.length !== 0) {
                    // Processing the next word in the queue.
                    var curWord = wordsInColumn.shift();
                    // Joining that word with the existing text for
                    // the current line.
                    var incrementedText = [textInCurrentLine, curWord].join(' ');
                    var incrementedTextWidth = gc.measureText(incrementedText).width;
                    if (incrementedTextWidth > boxWidth) {
                        // If the newly combined text has a width larger than
                        // the box width, we render the line before the current
                        // word was added. We set the current word as the next
                        // line.
                        gc.fillText(textInCurrentLine, textX, curY);
                        curY += textHeight;
                        textInCurrentLine = curWord;
                    }
                    else {
                        // The combined text hasd a width less than the box width. We
                        // set the the current line text to be the new combined text.
                        textInCurrentLine = incrementedText;
                    }
                }
            }
            gc.fillText(textInCurrentLine, textX, curY);
            // Terminating the call here as we don't want
            // to apply text eliding when wrapping is active.
            return;
        }
        // Elide text that is too long
        var elide = '\u2026';
        // Compute elided text
        if (elideDirection === 'right') {
            while (textWidth > boxWidth && text.length > 1) {
                if (text.length > 4 && textWidth >= 2 * boxWidth) {
                    // If text width is substantially bigger, take half the string
                    text = text.substring(0, text.length / 2 + 1) + elide;
                }
                else {
                    // Otherwise incrementally remove the last character
                    text = text.substring(0, text.length - 2) + elide;
                }
                textWidth = gc.measureText(text).width;
            }
        }
        else {
            while (textWidth > boxWidth && text.length > 1) {
                if (text.length > 4 && textWidth >= 2 * boxWidth) {
                    // If text width is substantially bigger, take half the string
                    text = elide + text.substring(text.length / 2);
                }
                else {
                    // Otherwise incrementally remove the last character
                    text = elide + text.substring(2);
                }
                textWidth = gc.measureText(text).width;
            }
        }
        // Draw the text for the cell.
        gc.fillText(text, textX, textY);
    };
    return HyperlinkRenderer;
}(TextRenderer));

/**
 * A collection of helper functions relating to merged cell groups
 */
var CellGroup;
(function (CellGroup) {
    function areCellsMerged(dataModel, rgn, cell1, cell2) {
        var numGroups = dataModel.groupCount(rgn);
        var row1 = cell1[0], column1 = cell1[1];
        var row2 = cell2[0], column2 = cell2[1];
        for (var i = 0; i < numGroups; i++) {
            var group = dataModel.group(rgn, i);
            if (row1 >= group.r1 &&
                row1 <= group.r2 &&
                column1 >= group.c1 &&
                column1 <= group.c2 &&
                row2 >= group.r1 &&
                row2 <= group.r2 &&
                column2 >= group.c1 &&
                column2 <= group.c2) {
                return true;
            }
        }
        return false;
    }
    CellGroup.areCellsMerged = areCellsMerged;
    /**
     * Calculates the cell boundary offsets needed for
     * a row or column at the given index by taking
     * into account merged cell groups in the region.
     * @param dataModel
     * @param regions
     * @param axis
     * @param sectionList
     * @param index
     */
    function calculateMergeOffsets(dataModel, regions, axis, sectionList, index) {
        var mergeStartOffset = 0;
        var mergeEndOffset = 0;
        var mergedCellGroups = [];
        for (var _i = 0, regions_1 = regions; _i < regions_1.length; _i++) {
            var region = regions_1[_i];
            mergedCellGroups = mergedCellGroups.concat(getCellGroupsAtRegion(dataModel, region));
        }
        var groupsAtAxis = [];
        if (axis === 'row') {
            for (var _a = 0, regions_2 = regions; _a < regions_2.length; _a++) {
                var region = regions_2[_a];
                groupsAtAxis = groupsAtAxis.concat(getCellGroupsAtRow(dataModel, region, index));
            }
        }
        else {
            for (var _b = 0, regions_3 = regions; _b < regions_3.length; _b++) {
                var region = regions_3[_b];
                groupsAtAxis = groupsAtAxis.concat(getCellGroupsAtColumn(dataModel, region, index));
            }
        }
        if (groupsAtAxis.length === 0) {
            return [0, 0, { r1: -1, r2: -1, c1: -1, c2: -1 }];
        }
        var joinedGroup = groupsAtAxis[0];
        for (var g = 0; g < mergedCellGroups.length; g++) {
            var group = mergedCellGroups[g];
            if (areCellGroupsIntersectingAtAxis(joinedGroup, group, axis)) {
                joinedGroup = joinCellGroups([group, joinedGroup]);
                mergedCellGroups.splice(g, 1);
                g = 0;
            }
        }
        var minRow = joinedGroup.r1;
        var maxRow = joinedGroup.r2;
        for (var r = index - 1; r >= minRow; r--) {
            mergeStartOffset += sectionList.sizeOf(r);
        }
        for (var r = index + 1; r <= maxRow; r++) {
            mergeEndOffset += sectionList.sizeOf(r);
        }
        return [mergeStartOffset, mergeEndOffset, joinedGroup];
    }
    CellGroup.calculateMergeOffsets = calculateMergeOffsets;
    /**
     * Checks if two cell-groups are intersecting
     * in the given axis.
     * @param group1
     * @param group2
     * @param axis
     */
    function areCellGroupsIntersectingAtAxis(group1, group2, axis) {
        if (axis === 'row') {
            return ((group1.r1 >= group2.r1 && group1.r1 <= group2.r2) ||
                (group1.r2 >= group2.r1 && group1.r2 <= group2.r2) ||
                (group2.r1 >= group1.r1 && group2.r1 <= group1.r2) ||
                (group2.r2 >= group1.r1 && group2.r2 <= group1.r2));
        }
        return ((group1.c1 >= group2.c1 && group1.c1 <= group2.c2) ||
            (group1.c2 >= group2.c1 && group1.c2 <= group2.c2) ||
            (group2.c1 >= group1.c1 && group2.c1 <= group1.c2) ||
            (group2.c2 >= group1.c1 && group2.c2 <= group1.c2));
    }
    CellGroup.areCellGroupsIntersectingAtAxis = areCellGroupsIntersectingAtAxis;
    /**
     * Checks if cell-groups are intersecting.
     * @param group1
     * @param group2
     */
    function areCellGroupsIntersecting(group1, group2) {
        return (((group1.r1 >= group2.r1 && group1.r1 <= group2.r2) ||
            (group1.r2 >= group2.r1 && group1.r2 <= group2.r2) ||
            (group2.r1 >= group1.r1 && group2.r1 <= group1.r2) ||
            (group2.r2 >= group1.r1 && group2.r2 <= group1.r2)) &&
            ((group1.c1 >= group2.c1 && group1.c1 <= group2.c2) ||
                (group1.c2 >= group2.c1 && group1.c2 <= group2.c2) ||
                (group2.c1 >= group1.c1 && group2.c1 <= group1.c2) ||
                (group2.c2 >= group1.c1 && group2.c2 <= group1.c2)));
    }
    CellGroup.areCellGroupsIntersecting = areCellGroupsIntersecting;
    /**
     * Retrieves the index of the cell-group to which
     * the cell at the given row, column belongs.
     * @param dataModel
     * @param rgn
     * @param row
     * @param column
     */
    function getGroupIndex(dataModel, rgn, row, column) {
        var numGroups = dataModel.groupCount(rgn);
        for (var i = 0; i < numGroups; i++) {
            var group = dataModel.group(rgn, i);
            if (row >= group.r1 &&
                row <= group.r2 &&
                column >= group.c1 &&
                column <= group.c2) {
                return i;
            }
        }
        return -1;
    }
    CellGroup.getGroupIndex = getGroupIndex;
    /**
     * Returns a cell-group for the given row/index coordinates.
     * @param dataModel
     * @param rgn
     * @param row
     * @param column
     */
    function getGroup(dataModel, rgn, row, column) {
        var groupIndex = getGroupIndex(dataModel, rgn, row, column);
        if (groupIndex === -1) {
            return null;
        }
        return dataModel.group(rgn, groupIndex);
    }
    CellGroup.getGroup = getGroup;
    /**
     * Returns all cell groups which belong to
     * a given cell cell region.
     * @param dataModel
     * @param rgn
     */
    function getCellGroupsAtRegion(dataModel, rgn) {
        var groupsAtRegion = [];
        var numGroups = dataModel.groupCount(rgn);
        for (var i = 0; i < numGroups; i++) {
            var group = dataModel.group(rgn, i);
            groupsAtRegion.push(group);
        }
        return groupsAtRegion;
    }
    CellGroup.getCellGroupsAtRegion = getCellGroupsAtRegion;
    /**
     * Calculates and returns a merged cell-group from
     * two cell-group objects.
     * @param groups
     */
    function joinCellGroups(groups) {
        var startRow = Number.MAX_VALUE;
        var endRow = Number.MIN_VALUE;
        var startColumn = Number.MAX_VALUE;
        var endColumn = Number.MIN_VALUE;
        for (var _i = 0, groups_1 = groups; _i < groups_1.length; _i++) {
            var group = groups_1[_i];
            startRow = Math.min(startRow, group.r1);
            endRow = Math.max(endRow, group.r2);
            startColumn = Math.min(startColumn, group.c1);
            endColumn = Math.max(endColumn, group.c2);
        }
        return { r1: startRow, r2: endRow, c1: startColumn, c2: endColumn };
    }
    CellGroup.joinCellGroups = joinCellGroups;
    /**
     * Merges a cell group with other cells groups in the
     * same region if they intersect.
     * @param dataModel the data model of the grid.
     * @param group the target cell group.
     * @param region the region of the cell group.
     * @returns a new cell group after merging has happened.
     */
    function joinCellGroupWithMergedCellGroups(dataModel, group, region) {
        var joinedGroup = __assign({}, group);
        var mergedCellGroups = getCellGroupsAtRegion(dataModel, region);
        for (var g = 0; g < mergedCellGroups.length; g++) {
            var mergedGroup = mergedCellGroups[g];
            if (areCellGroupsIntersecting(joinedGroup, mergedGroup)) {
                joinedGroup = joinCellGroups([joinedGroup, mergedGroup]);
            }
        }
        return joinedGroup;
    }
    CellGroup.joinCellGroupWithMergedCellGroups = joinCellGroupWithMergedCellGroups;
    /**
     * Retrieves a list of cell groups intersecting at
     * a given row.
     * @param dataModel data model of the grid.
     * @param rgn the cell region.
     * @param row the target row to look for intersections at.
     * @returns all cell groups intersecting with the row.
     */
    function getCellGroupsAtRow(dataModel, rgn, row) {
        var groupsAtRow = [];
        var numGroups = dataModel.groupCount(rgn);
        for (var i = 0; i < numGroups; i++) {
            var group = dataModel.group(rgn, i);
            if (row >= group.r1 && row <= group.r2) {
                groupsAtRow.push(group);
            }
        }
        return groupsAtRow;
    }
    CellGroup.getCellGroupsAtRow = getCellGroupsAtRow;
    /**
     * Retrieves a list of cell groups intersecting at
     * a given column.
     * @param dataModel data model of the grid.
     * @param rgn the cell region.
     * @param column the target column to look for intersections at.
     * @returns all cell groups intersecting with the column.
     */
    function getCellGroupsAtColumn(dataModel, rgn, column) {
        var groupsAtColumn = [];
        var numGroups = dataModel.groupCount(rgn);
        for (var i = 0; i < numGroups; i++) {
            var group = dataModel.group(rgn, i);
            if (column >= group.c1 && column <= group.c2) {
                groupsAtColumn.push(group);
            }
        }
        return groupsAtColumn;
    }
    CellGroup.getCellGroupsAtColumn = getCellGroupsAtColumn;
    /**
     * Checks if cell group 1 is above cell group 2.
     * @param group1 cell group 1.
     * @param group2 cell group 2.
     * @returns boolean.
     */
    function isCellGroupAbove(group1, group2) {
        return group2.r2 >= group1.r1;
    }
    CellGroup.isCellGroupAbove = isCellGroupAbove;
    /**
     * Checks if cell group 1 is below cell group 2.
     */
    function isCellGroupBelow(group1, group2) {
        return group2.r1 <= group1.r2;
    }
    CellGroup.isCellGroupBelow = isCellGroupBelow;
    /**
     * Merges a target cell group with any cell groups
     * it intersects with at a given row or column.
     * @param dataModel data model of the grid.
     * @param regions list of cell regions.
     * @param axis row or column.
     * @param group the target cell group.
     * @returns a new merged cell group.
     */
    function joinCellGroupsIntersectingAtAxis(dataModel, regions, axis, group) {
        var groupsAtAxis = [];
        if (axis === 'row') {
            for (var _i = 0, regions_4 = regions; _i < regions_4.length; _i++) {
                var region = regions_4[_i];
                for (var r = group.r1; r <= group.r2; r++) {
                    groupsAtAxis = groupsAtAxis.concat(CellGroup.getCellGroupsAtRow(dataModel, region, r));
                }
            }
        }
        else {
            for (var _a = 0, regions_5 = regions; _a < regions_5.length; _a++) {
                var region = regions_5[_a];
                for (var c = group.c1; c <= group.c2; c++) {
                    groupsAtAxis = groupsAtAxis.concat(CellGroup.getCellGroupsAtColumn(dataModel, region, c));
                }
            }
        }
        var mergedGroupAtAxis = CellGroup.joinCellGroups(groupsAtAxis);
        if (groupsAtAxis.length > 0) {
            var mergedCellGroups = [];
            for (var _b = 0, regions_6 = regions; _b < regions_6.length; _b++) {
                var region = regions_6[_b];
                mergedCellGroups = mergedCellGroups.concat(CellGroup.getCellGroupsAtRegion(dataModel, region));
            }
            for (var g = 0; g < mergedCellGroups.length; g++) {
                var group_1 = mergedCellGroups[g];
                if (CellGroup.areCellGroupsIntersectingAtAxis(mergedGroupAtAxis, group_1, axis)) {
                    mergedGroupAtAxis = CellGroup.joinCellGroups([
                        group_1,
                        mergedGroupAtAxis
                    ]);
                    mergedCellGroups.splice(g, 1);
                    g = 0;
                }
            }
        }
        return mergedGroupAtAxis;
    }
    CellGroup.joinCellGroupsIntersectingAtAxis = joinCellGroupsIntersectingAtAxis;
})(CellGroup || (CellGroup = {}));

/**
 * A basic implementation of a data grid mouse handler.
 *
 * #### Notes
 * This class may be subclassed and customized as needed.
 */
var BasicMouseHandler = /** @class */ (function () {
    function BasicMouseHandler() {
        this._disposed = false;
        this._pressData = null;
    }
    /**
     * Dispose of the resources held by the mouse handler.
     */
    BasicMouseHandler.prototype.dispose = function () {
        // Bail early if the handler is already disposed.
        if (this._disposed) {
            return;
        }
        // Release any held resources.
        this.release();
        // Mark the handler as disposed.
        this._disposed = true;
    };
    Object.defineProperty(BasicMouseHandler.prototype, "isDisposed", {
        /**
         * Whether the mouse handler is disposed.
         */
        get: function () {
            return this._disposed;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Release the resources held by the handler.
     */
    BasicMouseHandler.prototype.release = function () {
        // Bail early if the is no press data.
        if (!this._pressData) {
            return;
        }
        // Clear the autoselect timeout.
        if (this._pressData.type === 'select') {
            this._pressData.timeout = -1;
        }
        // Clear the press data.
        this._pressData.override.dispose();
        this._pressData = null;
    };
    /**
     * Handle the mouse hover event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The mouse hover event of interest.
     */
    BasicMouseHandler.prototype.onMouseHover = function (grid, event) {
        // Hit test the grid.
        var hit = grid.hitTest(event.clientX, event.clientY);
        // Get the resize handle for the hit test.
        var handle = Private$6.resizeHandleForHitTest(hit);
        // Fetch the cursor for the handle.
        var cursor = this.cursorForHandle(handle);
        // Hyperlink logic.
        var config = Private$6.createCellConfigObject(grid, hit);
        if (config) {
            // Retrieve renderer for hovered cell.
            var renderer = grid.cellRenderers.get(config);
            if (renderer instanceof HyperlinkRenderer) {
                cursor = this.cursorForHandle('hyperlink');
            }
        }
        // Update the viewport cursor based on the part.
        grid.viewport.node.style.cursor = cursor;
        // TODO support user-defined hover items
    };
    /**
     * Handle the mouse leave event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The mouse hover event of interest.
     */
    BasicMouseHandler.prototype.onMouseLeave = function (grid, event) {
        // TODO support user-defined hover popups.
        // Clear the viewport cursor.
        grid.viewport.node.style.cursor = '';
    };
    /**
     * Handle the mouse down event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The mouse down event of interest.
     */
    BasicMouseHandler.prototype.onMouseDown = function (grid, event) {
        // Unpack the event.
        var clientX = event.clientX, clientY = event.clientY;
        // Hit test the grid.
        var hit = grid.hitTest(clientX, clientY);
        // Unpack the hit test.
        var region = hit.region, row = hit.row, column = hit.column;
        // Bail if the hit test is on an uninteresting region.
        if (region === 'void') {
            return;
        }
        // Fetch the modifier flags.
        var shift = event.shiftKey;
        var accel = _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event);
        // Hyperlink logic.
        if (grid) {
            // Create cell config object.
            var config = Private$6.createCellConfigObject(grid, hit);
            // Retrieve cell renderer.
            var renderer = grid.cellRenderers.get(config);
            // Only process hyperlink renderers.
            if (renderer instanceof HyperlinkRenderer) {
                // Use the url param if it exists.
                var url = CellRenderer.resolveOption(renderer.url, config);
                // Otherwise assume cell value is the URL.
                if (!url) {
                    var format = TextRenderer.formatGeneric();
                    url = format(config);
                }
                // Open the hyperlink only if user hit Ctrl+Click.
                if (accel) {
                    window.open(url);
                    // Reset cursor default after clicking
                    var cursor_1 = this.cursorForHandle('none');
                    grid.viewport.node.style.cursor = cursor_1;
                    // Not applying selections if navigating away.
                    return;
                }
            }
        }
        // If the hit test is the body region, the only option is select.
        if (region === 'body') {
            // Fetch the selection model.
            var model_1 = grid.selectionModel;
            // Bail early if there is no selection model.
            if (!model_1) {
                return;
            }
            // Override the document cursor.
            var override_1 = _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_2__.Drag.overrideCursor('default');
            // Set up the press data.
            this._pressData = {
                type: 'select',
                region: region,
                row: row,
                column: column,
                override: override_1,
                localX: -1,
                localY: -1,
                timeout: -1
            };
            // Set up the selection variables.
            var r1_1;
            var c1_1;
            var r2_1;
            var c2_1;
            var cursorRow_1;
            var cursorColumn_1;
            var clear_1;
            // Accel == new selection, keep old selections.
            if (accel) {
                r1_1 = row;
                r2_1 = row;
                c1_1 = column;
                c2_1 = column;
                cursorRow_1 = row;
                cursorColumn_1 = column;
                clear_1 = 'none';
            }
            else if (shift) {
                r1_1 = model_1.cursorRow;
                r2_1 = row;
                c1_1 = model_1.cursorColumn;
                c2_1 = column;
                cursorRow_1 = model_1.cursorRow;
                cursorColumn_1 = model_1.cursorColumn;
                clear_1 = 'current';
            }
            else {
                r1_1 = row;
                r2_1 = row;
                c1_1 = column;
                c2_1 = column;
                cursorRow_1 = row;
                cursorColumn_1 = column;
                clear_1 = 'all';
            }
            // Make the selection.
            model_1.select({ r1: r1_1, c1: c1_1, r2: r2_1, c2: c2_1, cursorRow: cursorRow_1, cursorColumn: cursorColumn_1, clear: clear_1 });
            // Done.
            return;
        }
        // Otherwise, the hit test is on a header region.
        // Convert the hit test into a part.
        var handle = Private$6.resizeHandleForHitTest(hit);
        // Fetch the cursor for the handle.
        var cursor = this.cursorForHandle(handle);
        // Handle horizontal resize.
        if (handle === 'left' || handle === 'right') {
            // Set up the resize data type.
            var type = 'column-resize';
            // Determine the column region.
            var rgn = region === 'column-header' ? 'body' : 'row-header';
            // Determine the section index.
            var index = handle === 'left' ? column - 1 : column;
            // Fetch the section size.
            var size = grid.columnSize(rgn, index);
            // Override the document cursor.
            var override_2 = _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_2__.Drag.overrideCursor(cursor);
            // Create the temporary press data.
            this._pressData = { type: type, region: rgn, index: index, size: size, clientX: clientX, override: override_2 };
            // Done.
            return;
        }
        // Handle vertical resize
        if (handle === 'top' || handle === 'bottom') {
            // Set up the resize data type.
            var type = 'row-resize';
            // Determine the row region.
            var rgn = region === 'row-header' ? 'body' : 'column-header';
            // Determine the section index.
            var index = handle === 'top' ? row - 1 : row;
            // Fetch the section size.
            var size = grid.rowSize(rgn, index);
            // Override the document cursor.
            var override_3 = _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_2__.Drag.overrideCursor(cursor);
            // Create the temporary press data.
            this._pressData = { type: type, region: rgn, index: index, size: size, clientY: clientY, override: override_3 };
            // Done.
            return;
        }
        // Otherwise, the only option is select.
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Bail if there is no selection model.
        if (!model) {
            return;
        }
        // Override the document cursor.
        var override = _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_2__.Drag.overrideCursor('default');
        // Set up the press data.
        this._pressData = {
            type: 'select',
            region: region,
            row: row,
            column: column,
            override: override,
            localX: -1,
            localY: -1,
            timeout: -1
        };
        // Set up the selection variables.
        var r1;
        var c1;
        var r2;
        var c2;
        var cursorRow;
        var cursorColumn;
        var clear;
        // Compute the selection based on the pressed region.
        if (region === 'corner-header') {
            r1 = 0;
            r2 = Infinity;
            c1 = 0;
            c2 = Infinity;
            cursorRow = accel ? 0 : shift ? model.cursorRow : 0;
            cursorColumn = accel ? 0 : shift ? model.cursorColumn : 0;
            clear = accel ? 'none' : shift ? 'current' : 'all';
        }
        else if (region === 'row-header') {
            r1 = accel ? row : shift ? model.cursorRow : row;
            r2 = row;
            var selectionGroup = { r1: r1, c1: 0, r2: r2, c2: 0 };
            var joinedGroup = CellGroup.joinCellGroupsIntersectingAtAxis(grid.dataModel, ['row-header', 'body'], 'row', selectionGroup);
            // Check if there are any merges
            if (joinedGroup.r1 != Number.MAX_VALUE) {
                r1 = joinedGroup.r1;
                r2 = joinedGroup.r2;
            }
            c1 = 0;
            c2 = Infinity;
            cursorRow = accel ? row : shift ? model.cursorRow : row;
            cursorColumn = accel ? 0 : shift ? model.cursorColumn : 0;
            clear = accel ? 'none' : shift ? 'current' : 'all';
        }
        else if (region === 'column-header') {
            r1 = 0;
            r2 = Infinity;
            c1 = accel ? column : shift ? model.cursorColumn : column;
            c2 = column;
            var selectionGroup = { r1: 0, c1: c1, r2: 0, c2: c2 };
            var joinedGroup = CellGroup.joinCellGroupsIntersectingAtAxis(grid.dataModel, ['column-header', 'body'], 'column', selectionGroup);
            // Check if there are any merges
            if (joinedGroup.c1 != Number.MAX_VALUE) {
                c1 = joinedGroup.c1;
                c2 = joinedGroup.c2;
            }
            cursorRow = accel ? 0 : shift ? model.cursorRow : 0;
            cursorColumn = accel ? column : shift ? model.cursorColumn : column;
            clear = accel ? 'none' : shift ? 'current' : 'all';
        }
        else {
            r1 = accel ? row : shift ? model.cursorRow : row;
            r2 = row;
            c1 = accel ? column : shift ? model.cursorColumn : column;
            c2 = column;
            cursorRow = accel ? row : shift ? model.cursorRow : row;
            cursorColumn = accel ? column : shift ? model.cursorColumn : column;
            clear = accel ? 'none' : shift ? 'current' : 'all';
        }
        // Make the selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cursorRow, cursorColumn: cursorColumn, clear: clear });
    };
    /**
     * Handle the mouse move event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The mouse move event of interest.
     */
    BasicMouseHandler.prototype.onMouseMove = function (grid, event) {
        // Fetch the press data.
        var data = this._pressData;
        // Bail early if there is no press data.
        if (!data) {
            return;
        }
        // Handle a row resize.
        if (data.type === 'row-resize') {
            var dy = event.clientY - data.clientY;
            grid.resizeRow(data.region, data.index, data.size + dy);
            return;
        }
        // Handle a column resize.
        if (data.type === 'column-resize') {
            var dx = event.clientX - data.clientX;
            grid.resizeColumn(data.region, data.index, data.size + dx);
            return;
        }
        // Otherwise, it's a select.
        // Mouse moves during a corner header press are a no-op.
        if (data.region === 'corner-header') {
            return;
        }
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Bail early if the selection model was removed.
        if (!model) {
            return;
        }
        // Map to local coordinates.
        var _a = grid.mapToLocal(event.clientX, event.clientY), lx = _a.lx, ly = _a.ly;
        // Update the local mouse coordinates in the press data.
        data.localX = lx;
        data.localY = ly;
        // Fetch the grid geometry.
        var hw = grid.headerWidth;
        var hh = grid.headerHeight;
        var vpw = grid.viewportWidth;
        var vph = grid.viewportHeight;
        var sx = grid.scrollX;
        var sy = grid.scrollY;
        var msx = grid.maxScrollY;
        var msy = grid.maxScrollY;
        // Fetch the selection mode.
        var mode = model.selectionMode;
        // Set up the timeout variable.
        var timeout = -1;
        // Compute the timemout based on hit region and mouse position.
        if (data.region === 'row-header' || mode === 'row') {
            if (ly < hh && sy > 0) {
                timeout = Private$6.computeTimeout(hh - ly);
            }
            else if (ly >= vph && sy < msy) {
                timeout = Private$6.computeTimeout(ly - vph);
            }
        }
        else if (data.region === 'column-header' || mode === 'column') {
            if (lx < hw && sx > 0) {
                timeout = Private$6.computeTimeout(hw - lx);
            }
            else if (lx >= vpw && sx < msx) {
                timeout = Private$6.computeTimeout(lx - vpw);
            }
        }
        else {
            if (lx < hw && sx > 0) {
                timeout = Private$6.computeTimeout(hw - lx);
            }
            else if (lx >= vpw && sx < msx) {
                timeout = Private$6.computeTimeout(lx - vpw);
            }
            else if (ly < hh && sy > 0) {
                timeout = Private$6.computeTimeout(hh - ly);
            }
            else if (ly >= vph && sy < msy) {
                timeout = Private$6.computeTimeout(ly - vph);
            }
        }
        // Update or initiate the autoselect if needed.
        if (timeout >= 0) {
            if (data.timeout < 0) {
                data.timeout = timeout;
                setTimeout(function () {
                    Private$6.autoselect(grid, data);
                }, timeout);
            }
            else {
                data.timeout = timeout;
            }
            return;
        }
        // Otherwise, clear the autoselect timeout.
        data.timeout = -1;
        // Map the position to virtual coordinates.
        var _b = grid.mapToVirtual(event.clientX, event.clientY), vx = _b.vx, vy = _b.vy;
        // Clamp the coordinates to the limits.
        vx = Math.max(0, Math.min(vx, grid.bodyWidth - 1));
        vy = Math.max(0, Math.min(vy, grid.bodyHeight - 1));
        // Set up the selection variables.
        var r1;
        var c1;
        var r2;
        var c2;
        var cursorRow = model.cursorRow;
        var cursorColumn = model.cursorColumn;
        var clear = 'current';
        // Compute the selection based pressed region.
        if (data.region === 'row-header' || mode === 'row') {
            r1 = data.row;
            r2 = grid.rowAt('body', vy);
            var selectionGroup = { r1: r1, c1: 0, r2: r2, c2: 0 };
            var joinedGroup = CellGroup.joinCellGroupsIntersectingAtAxis(grid.dataModel, ['row-header', 'body'], 'row', selectionGroup);
            // Check if there are any merges
            if (joinedGroup.r1 != Number.MAX_VALUE) {
                r1 = Math.min(r1, joinedGroup.r1);
                r2 = Math.max(r2, joinedGroup.r2);
            }
            c1 = 0;
            c2 = Infinity;
        }
        else if (data.region === 'column-header' || mode === 'column') {
            r1 = 0;
            r2 = Infinity;
            c1 = data.column;
            c2 = grid.columnAt('body', vx);
            var selectionGroup = { r1: 0, c1: c1, r2: 0, c2: c2 };
            var joinedGroup = CellGroup.joinCellGroupsIntersectingAtAxis(grid.dataModel, ['column-header', 'body'], 'column', selectionGroup);
            // Check if there are any merges
            if (joinedGroup.c1 != Number.MAX_VALUE) {
                c1 = joinedGroup.c1;
                c2 = joinedGroup.c2;
            }
        }
        else {
            r1 = cursorRow;
            r2 = grid.rowAt('body', vy);
            c1 = cursorColumn;
            c2 = grid.columnAt('body', vx);
        }
        // Make the selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cursorRow, cursorColumn: cursorColumn, clear: clear });
    };
    /**
     * Handle the mouse up event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The mouse up event of interest.
     */
    BasicMouseHandler.prototype.onMouseUp = function (grid, event) {
        this.release();
    };
    /**
     * Handle the mouse double click event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The mouse up event of interest.
     */
    BasicMouseHandler.prototype.onMouseDoubleClick = function (grid, event) {
        if (!grid.dataModel) {
            this.release();
            return;
        }
        // Unpack the event.
        var clientX = event.clientX, clientY = event.clientY;
        // Hit test the grid.
        var hit = grid.hitTest(clientX, clientY);
        // Unpack the hit test.
        var region = hit.region, row = hit.row, column = hit.column;
        if (region === 'void') {
            this.release();
            return;
        }
        if (region === 'body') {
            if (grid.editable) {
                var cell = {
                    grid: grid,
                    row: row,
                    column: column
                };
                grid.editorController.edit(cell);
            }
        }
        this.release();
    };
    /**
     * Handle the context menu event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The context menu event of interest.
     */
    BasicMouseHandler.prototype.onContextMenu = function (grid, event) {
        // TODO support user-defined context menus
    };
    /**
     * Handle the wheel event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The wheel event of interest.
     */
    BasicMouseHandler.prototype.onWheel = function (grid, event) {
        // Bail if a mouse press is in progress.
        if (this._pressData) {
            return;
        }
        // Extract the delta X and Y movement.
        var dx = event.deltaX;
        var dy = event.deltaY;
        // Convert the delta values to pixel values.
        switch (event.deltaMode) {
            case 0: // DOM_DELTA_PIXEL
                break;
            case 1: // DOM_DELTA_LINE
                var ds = grid.defaultSizes;
                dx *= ds.columnWidth;
                dy *= ds.rowHeight;
                break;
            case 2: // DOM_DELTA_PAGE
                dx *= grid.pageWidth;
                dy *= grid.pageHeight;
                break;
            default:
                throw 'unreachable';
        }
        // Scroll by the desired amount.
        grid.scrollBy(dx, dy);
    };
    /**
     * Convert a resize handle into a cursor.
     */
    BasicMouseHandler.prototype.cursorForHandle = function (handle) {
        return Private$6.cursorMap[handle];
    };
    Object.defineProperty(BasicMouseHandler.prototype, "pressData", {
        /**
         * Get the current pressData
         */
        get: function () {
            return this._pressData;
        },
        enumerable: true,
        configurable: true
    });
    return BasicMouseHandler;
}());
/**
 * The namespace for the module implementation details.
 */
var Private$6;
(function (Private) {
    /**
     * Creates a CellConfig object from a hit region.
     */
    function createCellConfigObject(grid, hit) {
        var region = hit.region, row = hit.row, column = hit.column;
        // Terminate call if region is void.
        if (region === 'void') {
            return undefined;
        }
        // Augment hit region params with value and metadata.
        var value = grid.dataModel.data(region, row, column);
        var metadata = grid.dataModel.metadata(region, row, column);
        // Create cell config object to retrieve cell renderer.
        var config = __assign(__assign({}, hit), { value: value, metadata: metadata });
        return config;
    }
    Private.createCellConfigObject = createCellConfigObject;
    /**
     * Get the resize handle for a grid hit test.
     */
    function resizeHandleForHitTest(hit) {
        // Fetch the row and column.
        var r = hit.row;
        var c = hit.column;
        // Fetch the leading and trailing sizes.
        var lw = hit.x;
        var lh = hit.y;
        var tw = hit.width - hit.x;
        var th = hit.height - hit.y;
        // Set up the result variable.
        var result;
        // Dispatch based on hit test region.
        switch (hit.region) {
            case 'corner-header':
                if (c > 0 && lw <= 5) {
                    result = 'left';
                }
                else if (tw <= 6) {
                    result = 'right';
                }
                else if (r > 0 && lh <= 5) {
                    result = 'top';
                }
                else if (th <= 6) {
                    result = 'bottom';
                }
                else {
                    result = 'none';
                }
                break;
            case 'column-header':
                if (c > 0 && lw <= 5) {
                    result = 'left';
                }
                else if (tw <= 6) {
                    result = 'right';
                }
                else if (r > 0 && lh <= 5) {
                    result = 'top';
                }
                else if (th <= 6) {
                    result = 'bottom';
                }
                else {
                    result = 'none';
                }
                break;
            case 'row-header':
                if (c > 0 && lw <= 5) {
                    result = 'left';
                }
                else if (tw <= 6) {
                    result = 'right';
                }
                else if (r > 0 && lh <= 5) {
                    result = 'top';
                }
                else if (th <= 6) {
                    result = 'bottom';
                }
                else {
                    result = 'none';
                }
                break;
            case 'body':
                result = 'none';
                break;
            case 'void':
                result = 'none';
                break;
            default:
                throw 'unreachable';
        }
        // Return the result.
        return result;
    }
    Private.resizeHandleForHitTest = resizeHandleForHitTest;
    /**
     * A timer callback for the autoselect loop.
     *
     * @param grid - The datagrid of interest.
     *
     * @param data - The select data of interest.
     */
    function autoselect(grid, data) {
        // Bail early if the timeout has been reset.
        if (data.timeout < 0) {
            return;
        }
        // Fetch the selection model.
        var model = grid.selectionModel;
        // Bail early if the selection model has been removed.
        if (!model) {
            return;
        }
        // Fetch the current selection.
        var cs = model.currentSelection();
        // Bail early if there is no current selection.
        if (!cs) {
            return;
        }
        // Fetch local X and Y coordinates of the mouse.
        var lx = data.localX;
        var ly = data.localY;
        // Set up the selection variables.
        var r1 = cs.r1;
        var c1 = cs.c1;
        var r2 = cs.r2;
        var c2 = cs.c2;
        var cursorRow = model.cursorRow;
        var cursorColumn = model.cursorColumn;
        var clear = 'current';
        // Fetch the grid geometry.
        var hw = grid.headerWidth;
        var hh = grid.headerHeight;
        var vpw = grid.viewportWidth;
        var vph = grid.viewportHeight;
        // Fetch the selection mode.
        var mode = model.selectionMode;
        // Update the selection based on the hit region.
        if (data.region === 'row-header' || mode === 'row') {
            r2 += ly <= hh ? -1 : ly >= vph ? 1 : 0;
        }
        else if (data.region === 'column-header' || mode === 'column') {
            c2 += lx <= hw ? -1 : lx >= vpw ? 1 : 0;
        }
        else {
            r2 += ly <= hh ? -1 : ly >= vph ? 1 : 0;
            c2 += lx <= hw ? -1 : lx >= vpw ? 1 : 0;
        }
        // Update the current selection.
        model.select({ r1: r1, c1: c1, r2: r2, c2: c2, cursorRow: cursorRow, cursorColumn: cursorColumn, clear: clear });
        // Re-fetch the current selection.
        cs = model.currentSelection();
        // Bail if there is no selection.
        if (!cs) {
            return;
        }
        // Scroll the grid based on the hit region.
        if (data.region === 'row-header' || mode === 'row') {
            grid.scrollToRow(cs.r2);
        }
        else if (data.region === 'column-header' || mode == 'column') {
            grid.scrollToColumn(cs.c2);
        }
        else if (mode === 'cell') {
            grid.scrollToCell(cs.r2, cs.c2);
        }
        // Schedule the next call with the current timeout.
        setTimeout(function () {
            autoselect(grid, data);
        }, data.timeout);
    }
    Private.autoselect = autoselect;
    /**
     * Compute the scroll timeout for the given delta distance.
     *
     * @param delta - The delta pixels from the origin.
     *
     * @returns The scaled timeout in milliseconds.
     */
    function computeTimeout(delta) {
        return 5 + 120 * (1 - Math.min(128, Math.abs(delta)) / 128);
    }
    Private.computeTimeout = computeTimeout;
    /**
     * A mapping of resize handle to cursor.
     */
    Private.cursorMap = {
        top: 'ns-resize',
        left: 'ew-resize',
        right: 'ew-resize',
        bottom: 'ns-resize',
        hyperlink: 'pointer',
        none: 'default'
    };
})(Private$6 || (Private$6 = {}));

// Copyright (c) Jupyter Development Team.
/**
 * A base class for creating data grid selection models.
 *
 * #### Notes
 * If the predefined selection models are insufficient for a particular
 * use case, a custom model can be defined which derives from this class.
 */
var SelectionModel = /** @class */ (function () {
    /**
     * Construct a new selection model.
     *
     * @param options - The options for initializing the model.
     */
    function SelectionModel(options) {
        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);
        this._selectionMode = 'cell';
        this.dataModel = options.dataModel;
        this._selectionMode = options.selectionMode || 'cell';
        this.dataModel.changed.connect(this.onDataModelChanged, this);
    }
    Object.defineProperty(SelectionModel.prototype, "changed", {
        /**
         * A signal emitted when the selection model has changed.
         */
        get: function () {
            return this._changed;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelectionModel.prototype, "selectionMode", {
        /**
         * Get the selection mode for the model.
         */
        get: function () {
            return this._selectionMode;
        },
        /**
         * Set the selection mode for the model.
         *
         * #### Notes
         * This will clear the selection model.
         */
        set: function (value) {
            // Bail early if the mode does not change.
            if (this._selectionMode === value) {
                return;
            }
            // Update the internal mode.
            this._selectionMode = value;
            // Clear the current selections.
            this.clear();
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Test whether any selection intersects a row.
     *
     * @param index - The row index of interest.
     *
     * @returns Whether any selection intersects the row.
     *
     * #### Notes
     * This method may be reimplemented in a subclass.
     */
    SelectionModel.prototype.isRowSelected = function (index) {
        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.some)(this.selections(), function (s) { return Private$5.containsRow(s, index); });
    };
    /**
     * Test whether any selection intersects a column.
     *
     * @param index - The column index of interest.
     *
     * @returns Whether any selection intersects the column.
     *
     * #### Notes
     * This method may be reimplemented in a subclass.
     */
    SelectionModel.prototype.isColumnSelected = function (index) {
        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.some)(this.selections(), function (s) { return Private$5.containsColumn(s, index); });
    };
    /**
     * Test whether any selection intersects a cell.
     *
     * @param row - The row index of interest.
     *
     * @param column - The column index of interest.
     *
     * @returns Whether any selection intersects the cell.
     *
     * #### Notes
     * This method may be reimplemented in a subclass.
     */
    SelectionModel.prototype.isCellSelected = function (row, column) {
        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.some)(this.selections(), function (s) { return Private$5.containsCell(s, row, column); });
    };
    /**
     * A signal handler for the data model `changed` signal.
     *
     * @param args - The arguments for the signal.
     *
     * #### Notes
     * Selection model implementations should update their selections
     * in a manner that is relevant for the changes to the data model.
     *
     * The default implementation of this method is a no-op.
     */
    SelectionModel.prototype.onDataModelChanged = function (sender, args) {
        // pass
    };
    /**
     * Emit the `changed` signal for the selection model.
     *
     * #### Notes
     * Subclasses should call this method whenever the selection model
     * has changed so that attached data grids can update themselves.
     */
    SelectionModel.prototype.emitChanged = function () {
        this._changed.emit(undefined);
    };
    return SelectionModel;
}());
/**
 * The namespace for the module implementation details.
 */
var Private$5;
(function (Private) {
    /**
     * Test whether a selection contains a given row.
     */
    function containsRow(selection, row) {
        var r1 = selection.r1, r2 = selection.r2;
        return (row >= r1 && row <= r2) || (row >= r2 && row <= r1);
    }
    Private.containsRow = containsRow;
    /**
     * Test whether a selection contains a given column.
     */
    function containsColumn(selection, column) {
        var c1 = selection.c1, c2 = selection.c2;
        return (column >= c1 && column <= c2) || (column >= c2 && column <= c1);
    }
    Private.containsColumn = containsColumn;
    /**
     * Test whether a selection contains a given cell.
     */
    function containsCell(selection, row, column) {
        return containsRow(selection, row) && containsColumn(selection, column);
    }
    Private.containsCell = containsCell;
})(Private$5 || (Private$5 = {}));

/**
 * A basic selection model implementation.
 *
 * #### Notes
 * This selection model is sufficient for most use cases where
 * structural knowledge of the data source is *not* required.
 */
var BasicSelectionModel = /** @class */ (function (_super) {
    __extends(BasicSelectionModel, _super);
    function BasicSelectionModel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._cursorRow = -1;
        _this._cursorColumn = -1;
        _this._cursorRectIndex = -1;
        _this._selections = [];
        return _this;
    }
    Object.defineProperty(BasicSelectionModel.prototype, "isEmpty", {
        /**
         * Whether the selection model is empty.
         */
        get: function () {
            return this._selections.length === 0;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BasicSelectionModel.prototype, "cursorRow", {
        /**
         * The row index of the cursor.
         */
        get: function () {
            return this._cursorRow;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BasicSelectionModel.prototype, "cursorColumn", {
        /**
         * The column index of the cursor.
         */
        get: function () {
            return this._cursorColumn;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Move cursor down/up/left/right while making sure it remains
     * within the bounds of selected rectangles
     *
     * @param direction - The direction of the movement.
     */
    BasicSelectionModel.prototype.moveCursorWithinSelections = function (direction) {
        var _this = this;
        // Bail early if there are no selections or no existing cursor
        if (this.isEmpty || this.cursorRow === -1 || this._cursorColumn === -1) {
            return;
        }
        // Bail early if only single cell is selected
        var firstSelection = this._selections[0];
        if (this._selections.length === 1 &&
            firstSelection.r1 === firstSelection.r2 &&
            firstSelection.c1 === firstSelection.c2) {
            return;
        }
        // start from last selection rectangle
        if (this._cursorRectIndex === -1) {
            this._cursorRectIndex = this._selections.length - 1;
        }
        var cursorRect = this._selections[this._cursorRectIndex];
        var dr = direction === 'down' ? 1 : direction === 'up' ? -1 : 0;
        var dc = direction === 'right' ? 1 : direction === 'left' ? -1 : 0;
        var newRow = this._cursorRow + dr;
        var newColumn = this._cursorColumn + dc;
        var r1 = Math.min(cursorRect.r1, cursorRect.r2);
        var r2 = Math.max(cursorRect.r1, cursorRect.r2);
        var c1 = Math.min(cursorRect.c1, cursorRect.c2);
        var c2 = Math.max(cursorRect.c1, cursorRect.c2);
        var moveToNextRect = function () {
            _this._cursorRectIndex =
                (_this._cursorRectIndex + 1) % _this._selections.length;
            cursorRect = _this._selections[_this._cursorRectIndex];
            newRow = Math.min(cursorRect.r1, cursorRect.r2);
            newColumn = Math.min(cursorRect.c1, cursorRect.c2);
        };
        var moveToPreviousRect = function () {
            _this._cursorRectIndex =
                _this._cursorRectIndex === 0
                    ? _this._selections.length - 1
                    : _this._cursorRectIndex - 1;
            cursorRect = _this._selections[_this._cursorRectIndex];
            newRow = Math.max(cursorRect.r1, cursorRect.r2);
            newColumn = Math.max(cursorRect.c1, cursorRect.c2);
        };
        if (newRow > r2) {
            newRow = r1;
            newColumn += 1;
            if (newColumn > c2) {
                moveToNextRect();
            }
        }
        else if (newRow < r1) {
            newRow = r2;
            newColumn -= 1;
            if (newColumn < c1) {
                moveToPreviousRect();
            }
        }
        else if (newColumn > c2) {
            newColumn = c1;
            newRow += 1;
            if (newRow > r2) {
                moveToNextRect();
            }
        }
        else if (newColumn < c1) {
            newColumn = c2;
            newRow -= 1;
            if (newRow < r1) {
                moveToPreviousRect();
            }
        }
        this._cursorRow = newRow;
        this._cursorColumn = newColumn;
        // Emit the changed signal.
        this.emitChanged();
    };
    /**
     * Get the current selection in the selection model.
     *
     * @returns The current selection or `null`.
     *
     * #### Notes
     * This is the selection which holds the cursor.
     */
    BasicSelectionModel.prototype.currentSelection = function () {
        return this._selections[this._selections.length - 1] || null;
    };
    /**
     * Get an iterator of the selections in the model.
     *
     * @returns A new iterator of the current selections.
     *
     * #### Notes
     * The data grid will render the selections in order.
     */
    BasicSelectionModel.prototype.selections = function () {
        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.iter)(this._selections);
    };
    /**
     * Select the specified cells.
     *
     * @param args - The arguments for the selection.
     */
    BasicSelectionModel.prototype.select = function (args) {
        // Fetch the current row and column counts;
        var rowCount = this.dataModel.rowCount('body');
        var columnCount = this.dataModel.columnCount('body');
        // Bail early if there is no content.
        if (rowCount <= 0 || columnCount <= 0) {
            return;
        }
        // Unpack the arguments.
        var r1 = args.r1, c1 = args.c1, r2 = args.r2, c2 = args.c2, cursorRow = args.cursorRow, cursorColumn = args.cursorColumn, clear = args.clear;
        // Clear the necessary selections.
        if (clear === 'all') {
            this._selections.length = 0;
        }
        else if (clear === 'current') {
            this._selections.pop();
        }
        // Clamp to the data model bounds.
        r1 = Math.max(0, Math.min(r1, rowCount - 1));
        r2 = Math.max(0, Math.min(r2, rowCount - 1));
        c1 = Math.max(0, Math.min(c1, columnCount - 1));
        c2 = Math.max(0, Math.min(c2, columnCount - 1));
        // Indicate if a row/column has already been selected.
        var alreadySelected = false;
        // Handle the selection mode.
        if (this.selectionMode === 'row') {
            c1 = 0;
            c2 = columnCount - 1;
            alreadySelected =
                this._selections.filter(function (selection) { return selection.r1 === r1; }).length !== 0;
            // Remove from selections if already selected.
            this._selections = alreadySelected
                ? this._selections.filter(function (selection) { return selection.r1 !== r1; })
                : this._selections;
        }
        else if (this.selectionMode === 'column') {
            r1 = 0;
            r2 = rowCount - 1;
            alreadySelected =
                this._selections.filter(function (selection) { return selection.c1 === c1; }).length !== 0;
            // Remove from selections if already selected.
            this._selections = alreadySelected
                ? this._selections.filter(function (selection) { return selection.c1 !== c1; })
                : this._selections;
        }
        // Alias the cursor row and column.
        var cr = cursorRow;
        var cc = cursorColumn;
        // Compute the new cursor location.
        if (cr < 0 || (cr < r1 && cr < r2) || (cr > r1 && cr > r2)) {
            cr = r1;
        }
        if (cc < 0 || (cc < c1 && cc < c2) || (cc > c1 && cc > c2)) {
            cc = c1;
        }
        // Update the cursor.
        this._cursorRow = cr;
        this._cursorColumn = cc;
        this._cursorRectIndex = this._selections.length;
        // Add the new selection if it wasn't already selected.
        if (!alreadySelected) {
            this._selections.push({ r1: r1, c1: c1, r2: r2, c2: c2 });
        }
        // Emit the changed signal.
        this.emitChanged();
    };
    /**
     * Clear all selections in the selection model.
     */
    BasicSelectionModel.prototype.clear = function () {
        // Bail early if there are no selections.
        if (this._selections.length === 0) {
            return;
        }
        // Reset the internal state.
        this._cursorRow = -1;
        this._cursorColumn = -1;
        this._cursorRectIndex = -1;
        this._selections.length = 0;
        // Emit the changed signal.
        this.emitChanged();
    };
    /**
     * A signal handler for the data model `changed` signal.
     *
     * @param args - The arguments for the signal.
     */
    BasicSelectionModel.prototype.onDataModelChanged = function (sender, args) {
        // Bail early if the model has no current selections.
        if (this._selections.length === 0) {
            return;
        }
        // Bail early if the cells have changed in place.
        if (args.type === 'cells-changed') {
            return;
        }
        // Bail early if there is no change to the row or column count.
        if (args.type === 'rows-moved' || args.type === 'columns-moved') {
            return;
        }
        // Fetch the last row and column index.
        var lr = sender.rowCount('body') - 1;
        var lc = sender.columnCount('body') - 1;
        // Bail early if the data model is empty.
        if (lr < 0 || lc < 0) {
            this._selections.length = 0;
            this.emitChanged();
            return;
        }
        // Fetch the selection mode.
        var mode = this.selectionMode;
        // Set up the assignment index variable.
        var j = 0;
        // Iterate over the current selections.
        for (var i = 0, n = this._selections.length; i < n; ++i) {
            // Unpack the selection.
            var _a = this._selections[i], r1 = _a.r1, c1 = _a.c1, r2 = _a.r2, c2 = _a.c2;
            // Skip the selection if it will disappear.
            if ((lr < r1 && lr < r2) || (lc < c1 && lc < c2)) {
                continue;
            }
            // Modify the bounds based on the selection mode.
            if (mode === 'row') {
                r1 = Math.max(0, Math.min(r1, lr));
                r2 = Math.max(0, Math.min(r2, lr));
                c1 = 0;
                c2 = lc;
            }
            else if (mode === 'column') {
                r1 = 0;
                r2 = lr;
                c1 = Math.max(0, Math.min(c1, lc));
                c2 = Math.max(0, Math.min(c2, lc));
            }
            else {
                r1 = Math.max(0, Math.min(r1, lr));
                r2 = Math.max(0, Math.min(r2, lr));
                c1 = Math.max(0, Math.min(c1, lc));
                c2 = Math.max(0, Math.min(c2, lc));
            }
            // Assign the modified selection to the array.
            this._selections[j++] = { r1: r1, c1: c1, r2: r2, c2: c2 };
        }
        // Remove the stale selections.
        this._selections.length = j;
        // Emit the changed signal.
        this.emitChanged();
    };
    return BasicSelectionModel;
}(SelectionModel));

// Copyright (c) Jupyter Development Team.
/**
 * A widget which implements a notification popup.
 */
var Notification = /** @class */ (function (_super) {
    __extends(Notification, _super);
    /**
     * Construct a new notification.
     *
     * @param options - The options for initializing the notification.
     */
    function Notification(options) {
        var _this = _super.call(this, { node: Private$4.createNode() }) || this;
        _this._message = '';
        _this.addClass('lm-DataGrid-notification');
        _this.setFlag(_lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Widget.Flag.DisallowLayout);
        _this._target = options.target;
        _this._message = options.message || '';
        _this._placement = options.placement || 'bottom';
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Widget.attach(_this, document.body);
        if (options.timeout && options.timeout > 0) {
            setTimeout(function () {
                _this.close();
            }, options.timeout);
        }
        return _this;
    }
    /**
     * Handle the DOM events for the notification.
     *
     * @param event - The DOM event sent to the notification.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the notification's DOM node.
     *
     * This should not be called directly by user code.
     */
    Notification.prototype.handleEvent = function (event) {
        switch (event.type) {
            case 'mousedown':
                this._evtMouseDown(event);
                break;
            case 'contextmenu':
                event.preventDefault();
                event.stopPropagation();
                break;
        }
    };
    Object.defineProperty(Notification.prototype, "placement", {
        /**
         * Get the placement of the notification.
         */
        get: function () {
            return this._placement;
        },
        /**
         * Set the placement of the notification.
         */
        set: function (value) {
            // Do nothing if the placement does not change.
            if (this._placement === value) {
                return;
            }
            // Update the internal placement.
            this._placement = value;
            // Schedule an update for notification.
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Notification.prototype, "message", {
        /**
         * Get the current value of the message.
         */
        get: function () {
            return this._message;
        },
        /**
         * Set the current value of the message.
         *
         */
        set: function (value) {
            // Do nothing if the value does not change.
            if (this._message === value) {
                return;
            }
            // Update the internal value.
            this._message = value;
            // Schedule an update for notification.
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Notification.prototype, "messageNode", {
        /**
         * Get the node presenting the message.
         */
        get: function () {
            return this.node.getElementsByClassName('lm-DataGrid-notificationMessage')[0];
        },
        enumerable: true,
        configurable: true
    });
    /**
     * A method invoked on a 'before-attach' message.
     */
    Notification.prototype.onBeforeAttach = function (msg) {
        this.node.addEventListener('mousedown', this);
        this.update();
    };
    /**
     * A method invoked on an 'after-detach' message.
     */
    Notification.prototype.onAfterDetach = function (msg) {
        this.node.removeEventListener('mousedown', this);
    };
    /**
     * A method invoked on an 'update-request' message.
     */
    Notification.prototype.onUpdateRequest = function (msg) {
        var targetRect = this._target.getBoundingClientRect();
        var style = this.node.style;
        switch (this._placement) {
            case 'bottom':
                style.left = targetRect.left + 'px';
                style.top = targetRect.bottom + 'px';
                break;
            case 'top':
                style.left = targetRect.left + 'px';
                style.height = targetRect.top + 'px';
                style.top = '0';
                style.alignItems = 'flex-end';
                style.justifyContent = 'flex-end';
                break;
            case 'left':
                style.left = '0';
                style.width = targetRect.left + 'px';
                style.top = targetRect.top + 'px';
                style.alignItems = 'flex-end';
                style.justifyContent = 'flex-end';
                break;
            case 'right':
                style.left = targetRect.right + 'px';
                style.top = targetRect.top + 'px';
                break;
        }
        this.messageNode.innerHTML = this._message;
    };
    /**
     * Handle the `'mousedown'` event for the notification.
     */
    Notification.prototype._evtMouseDown = function (event) {
        // Do nothing if it's not a left mouse press.
        if (event.button !== 0) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        this.close();
    };
    return Notification;
}(_lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Widget));
/**
 * The namespace for the module implementation details.
 */
var Private$4;
(function (Private) {
    /**
     * Create the DOM node for notification.
     */
    function createNode() {
        var node = document.createElement('div');
        var container = document.createElement('div');
        container.className = 'lm-DataGrid-notificationContainer';
        var message = document.createElement('span');
        message.className = 'lm-DataGrid-notificationMessage';
        container.appendChild(message);
        node.appendChild(container);
        return node;
    }
    Private.createNode = createNode;
})(Private$4 || (Private$4 = {}));

// default validation error message
var DEFAULT_INVALID_INPUT_MESSAGE = 'Invalid input!';
/**
 * A cell input validator object which always returns valid.
 */
var PassInputValidator = /** @class */ (function () {
    function PassInputValidator() {
    }
    /**
     * Validate cell input.
     *
     * @param cell - The object holding cell configuration data.
     *
     * @param value - The cell value input.
     *
     * @returns An object with validation result.
     */
    PassInputValidator.prototype.validate = function (cell, value) {
        return { valid: true };
    };
    return PassInputValidator;
}());
/**
 * Text cell input validator.
 */
var TextInputValidator = /** @class */ (function () {
    function TextInputValidator() {
        /**
         * Minimum text length
         *
         * The default is Number.NaN, meaning no minimum constraint
         */
        this.minLength = Number.NaN;
        /**
         * Maximum text length
         *
         * The default is Number.NaN, meaning no maximum constraint
         */
        this.maxLength = Number.NaN;
        /**
         * Required text pattern as regular expression
         *
         * The default is null, meaning no pattern constraint
         */
        this.pattern = null;
    }
    /**
     * Validate cell input.
     *
     * @param cell - The object holding cell configuration data.
     *
     * @param value - The cell value input.
     *
     * @returns An object with validation result.
     */
    TextInputValidator.prototype.validate = function (cell, value) {
        if (value === null) {
            return { valid: true };
        }
        if (typeof value !== 'string') {
            return {
                valid: false,
                message: 'Input must be valid text'
            };
        }
        if (!isNaN(this.minLength) && value.length < this.minLength) {
            return {
                valid: false,
                message: "Text length must be greater than " + this.minLength
            };
        }
        if (!isNaN(this.maxLength) && value.length > this.maxLength) {
            return {
                valid: false,
                message: "Text length must be less than " + this.maxLength
            };
        }
        if (this.pattern && !this.pattern.test(value)) {
            return {
                valid: false,
                message: "Text doesn't match the required pattern"
            };
        }
        return { valid: true };
    };
    return TextInputValidator;
}());
/**
 * Integer cell input validator.
 */
var IntegerInputValidator = /** @class */ (function () {
    function IntegerInputValidator() {
        /**
         * Minimum value
         *
         * The default is Number.NaN, meaning no minimum constraint
         */
        this.min = Number.NaN;
        /**
         * Maximum value
         *
         * The default is Number.NaN, meaning no maximum constraint
         */
        this.max = Number.NaN;
    }
    /**
     * Validate cell input.
     *
     * @param cell - The object holding cell configuration data.
     *
     * @param value - The cell value input.
     *
     * @returns An object with validation result.
     */
    IntegerInputValidator.prototype.validate = function (cell, value) {
        if (value === null) {
            return { valid: true };
        }
        if (isNaN(value) || value % 1 !== 0) {
            return {
                valid: false,
                message: 'Input must be valid integer'
            };
        }
        if (!isNaN(this.min) && value < this.min) {
            return {
                valid: false,
                message: "Input must be greater than " + this.min
            };
        }
        if (!isNaN(this.max) && value > this.max) {
            return {
                valid: false,
                message: "Input must be less than " + this.max
            };
        }
        return { valid: true };
    };
    return IntegerInputValidator;
}());
/**
 * Real number cell input validator.
 */
var NumberInputValidator = /** @class */ (function () {
    function NumberInputValidator() {
        /**
         * Minimum value
         *
         * The default is Number.NaN, meaning no minimum constraint
         */
        this.min = Number.NaN;
        /**
         * Maximum value
         *
         * The default is Number.NaN, meaning no maximum constraint
         */
        this.max = Number.NaN;
    }
    /**
     * Validate cell input.
     *
     * @param cell - The object holding cell configuration data.
     *
     * @param value - The cell value input.
     *
     * @returns An object with validation result.
     */
    NumberInputValidator.prototype.validate = function (cell, value) {
        if (value === null) {
            return { valid: true };
        }
        if (isNaN(value)) {
            return {
                valid: false,
                message: 'Input must be valid number'
            };
        }
        if (!isNaN(this.min) && value < this.min) {
            return {
                valid: false,
                message: "Input must be greater than " + this.min
            };
        }
        if (!isNaN(this.max) && value > this.max) {
            return {
                valid: false,
                message: "Input must be less than " + this.max
            };
        }
        return { valid: true };
    };
    return NumberInputValidator;
}());
/**
 * An abstract base class that provides the most of the functionality
 * needed by a cell editor. All of the built-in cell editors
 * for various cell types are derived from this base class. Custom cell editors
 * can be easily implemented by extending this class.
 */
var CellEditor = /** @class */ (function () {
    /**
     * Construct a new cell editor.
     */
    function CellEditor() {
        var _this = this;
        /**
         * A signal emitted when input changes.
         */
        this.inputChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);
        /**
         * Notification popup used to show validation error messages.
         */
        this.validityNotification = null;
        /**
         * Whether the cell editor is disposed.
         */
        this._disposed = false;
        /**
         * Whether the value input is valid.
         */
        this._validInput = true;
        /**
         * Grid wheel event handler.
         */
        this._gridWheelEventHandler = null;
        this.inputChanged.connect(function () {
            _this.validate();
        });
    }
    Object.defineProperty(CellEditor.prototype, "isDisposed", {
        /**
         * Whether the cell editor is disposed.
         */
        get: function () {
            return this._disposed;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Dispose of the resources held by cell editor.
     */
    CellEditor.prototype.dispose = function () {
        if (this._disposed) {
            return;
        }
        if (this._gridWheelEventHandler) {
            this.cell.grid.node.removeEventListener('wheel', this._gridWheelEventHandler);
            this._gridWheelEventHandler = null;
        }
        this._closeValidityNotification();
        this._disposed = true;
        this.cell.grid.node.removeChild(this.viewportOccluder);
    };
    /**
     * Start editing the cell.
     *
     * @param cell - The object holding cell configuration data.
     *
     * @param options - The cell editing options.
     */
    CellEditor.prototype.edit = function (cell, options) {
        var _this = this;
        this.cell = cell;
        this.onCommit = options && options.onCommit;
        this.onCancel = options && options.onCancel;
        this.validator =
            options && options.validator
                ? options.validator
                : this.createValidatorBasedOnType();
        this._gridWheelEventHandler = function () {
            _this._closeValidityNotification();
            _this.updatePosition();
        };
        cell.grid.node.addEventListener('wheel', this._gridWheelEventHandler);
        this._addContainer();
        this.updatePosition();
        this.startEditing();
    };
    /**
     * Cancel editing the cell.
     */
    CellEditor.prototype.cancel = function () {
        if (this._disposed) {
            return;
        }
        this.dispose();
        if (this.onCancel) {
            this.onCancel();
        }
    };
    Object.defineProperty(CellEditor.prototype, "validInput", {
        /**
         * Whether the value input is valid.
         */
        get: function () {
            return this._validInput;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Validate the cell input. Shows validation error notification when input is invalid.
     */
    CellEditor.prototype.validate = function () {
        var value;
        try {
            value = this.getInput();
        }
        catch (error) {
            console.log("Input error: " + error.message);
            this.setValidity(false, error.message || DEFAULT_INVALID_INPUT_MESSAGE);
            return;
        }
        if (this.validator) {
            var result = this.validator.validate(this.cell, value);
            if (result.valid) {
                this.setValidity(true);
            }
            else {
                this.setValidity(false, result.message || DEFAULT_INVALID_INPUT_MESSAGE);
            }
        }
        else {
            this.setValidity(true);
        }
    };
    /**
     * Set validity flag.
     *
     * @param valid - Whether the input is valid.
     *
     * @param message - Notification message to show.
     *
     * If message is set to empty string (which is the default)
     * existing notification popup is removed if any.
     */
    CellEditor.prototype.setValidity = function (valid, message) {
        if (message === void 0) { message = ''; }
        this._validInput = valid;
        this._closeValidityNotification();
        if (valid) {
            this.editorContainer.classList.remove('lm-mod-invalid');
        }
        else {
            this.editorContainer.classList.add('lm-mod-invalid');
            // show a notification popup
            if (message !== '') {
                this.validityNotification = new Notification({
                    target: this.editorContainer,
                    message: message,
                    placement: 'bottom',
                    timeout: 5000
                });
                this.validityNotification.show();
            }
        }
    };
    /**
     * Create and return a cell input validator based on configuration of the
     * cell being edited. If no suitable validator can be found, it returns undefined.
     */
    CellEditor.prototype.createValidatorBasedOnType = function () {
        var cell = this.cell;
        var metadata = cell.grid.dataModel.metadata('body', cell.row, cell.column);
        switch (metadata && metadata.type) {
            case 'string':
                {
                    var validator = new TextInputValidator();
                    if (typeof metadata.format === 'string') {
                        var format = metadata.format;
                        switch (format) {
                            case 'email':
                                validator.pattern = new RegExp('^([a-z0-9_.-]+)@([da-z.-]+).([a-z.]{2,6})$');
                                break;
                            case 'uuid':
                                validator.pattern = new RegExp('[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}');
                                break;
                        }
                    }
                    if (metadata.constraint) {
                        if (metadata.constraint.minLength !== undefined) {
                            validator.minLength = metadata.constraint.minLength;
                        }
                        if (metadata.constraint.maxLength !== undefined) {
                            validator.maxLength = metadata.constraint.maxLength;
                        }
                        if (typeof metadata.constraint.pattern === 'string') {
                            validator.pattern = new RegExp(metadata.constraint.pattern);
                        }
                    }
                    return validator;
                }
            case 'number':
                {
                    var validator = new NumberInputValidator();
                    if (metadata.constraint) {
                        if (metadata.constraint.minimum !== undefined) {
                            validator.min = metadata.constraint.minimum;
                        }
                        if (metadata.constraint.maximum !== undefined) {
                            validator.max = metadata.constraint.maximum;
                        }
                    }
                    return validator;
                }
            case 'integer':
                {
                    var validator = new IntegerInputValidator();
                    if (metadata.constraint) {
                        if (metadata.constraint.minimum !== undefined) {
                            validator.min = metadata.constraint.minimum;
                        }
                        if (metadata.constraint.maximum !== undefined) {
                            validator.max = metadata.constraint.maximum;
                        }
                    }
                    return validator;
                }
        }
        return undefined;
    };
    /**
     * Compute cell rectangle and return with other cell properties.
     */
    CellEditor.prototype.getCellInfo = function (cell) {
        var grid = cell.grid, row = cell.row, column = cell.column;
        var data, columnX, rowY, width, height;
        var cellGroup = CellGroup.getGroup(grid.dataModel, 'body', row, column);
        if (cellGroup) {
            columnX =
                grid.headerWidth -
                    grid.scrollX +
                    grid.columnOffset('body', cellGroup.c1);
            rowY =
                grid.headerHeight - grid.scrollY + grid.rowOffset('body', cellGroup.r1);
            width = 0;
            height = 0;
            for (var r = cellGroup.r1; r <= cellGroup.r2; r++) {
                height += grid.rowSize('body', r);
            }
            for (var c = cellGroup.c1; c <= cellGroup.c2; c++) {
                width += grid.columnSize('body', c);
            }
            data = grid.dataModel.data('body', cellGroup.r1, cellGroup.c1);
        }
        else {
            columnX =
                grid.headerWidth - grid.scrollX + grid.columnOffset('body', column);
            rowY = grid.headerHeight - grid.scrollY + grid.rowOffset('body', row);
            width = grid.columnSize('body', column);
            height = grid.rowSize('body', row);
            data = grid.dataModel.data('body', row, column);
        }
        return {
            grid: grid,
            row: row,
            column: column,
            data: data,
            x: columnX,
            y: rowY,
            width: width,
            height: height
        };
    };
    /**
     * Reposition cell editor by moving viewport occluder and cell editor container.
     */
    CellEditor.prototype.updatePosition = function () {
        var grid = this.cell.grid;
        var cellInfo = this.getCellInfo(this.cell);
        var headerHeight = grid.headerHeight;
        var headerWidth = grid.headerWidth;
        this.viewportOccluder.style.top = headerHeight + 'px';
        this.viewportOccluder.style.left = headerWidth + 'px';
        this.viewportOccluder.style.width = grid.viewportWidth - headerWidth + 'px';
        this.viewportOccluder.style.height =
            grid.viewportHeight - headerHeight + 'px';
        this.viewportOccluder.style.position = 'absolute';
        this.editorContainer.style.left = cellInfo.x - 1 - headerWidth + 'px';
        this.editorContainer.style.top = cellInfo.y - 1 - headerHeight + 'px';
        this.editorContainer.style.width = cellInfo.width + 1 + 'px';
        this.editorContainer.style.height = cellInfo.height + 1 + 'px';
        this.editorContainer.style.visibility = 'visible';
        this.editorContainer.style.position = 'absolute';
    };
    /**
     * Commit the edited value.
     *
     * @param cursorMovement - Cursor move direction based on keys pressed to end the edit.
     *
     * @returns true on valid input, false otherwise.
     */
    CellEditor.prototype.commit = function (cursorMovement) {
        if (cursorMovement === void 0) { cursorMovement = 'none'; }
        this.validate();
        if (!this._validInput) {
            return false;
        }
        var value;
        try {
            value = this.getInput();
        }
        catch (error) {
            console.log("Input error: " + error.message);
            return false;
        }
        this.dispose();
        if (this.onCommit) {
            this.onCommit({
                cell: this.cell,
                value: value,
                cursorMovement: cursorMovement
            });
        }
        return true;
    };
    /**
     * Create container elements needed to prevent editor widget overflow
     * beyond viewport and to position cell editor widget.
     */
    CellEditor.prototype._addContainer = function () {
        var _this = this;
        this.viewportOccluder = document.createElement('div');
        this.viewportOccluder.className = 'lm-DataGrid-cellEditorOccluder';
        this.cell.grid.node.appendChild(this.viewportOccluder);
        this.editorContainer = document.createElement('div');
        this.editorContainer.className = 'lm-DataGrid-cellEditorContainer';
        this.viewportOccluder.appendChild(this.editorContainer);
        // update mouse event pass-through state based on input validity
        this.editorContainer.addEventListener('mouseleave', function (event) {
            _this.viewportOccluder.style.pointerEvents = _this._validInput
                ? 'none'
                : 'auto';
        });
        this.editorContainer.addEventListener('mouseenter', function (event) {
            _this.viewportOccluder.style.pointerEvents = 'none';
        });
    };
    /**
     * Remove validity notification popup.
     */
    CellEditor.prototype._closeValidityNotification = function () {
        if (this.validityNotification) {
            this.validityNotification.close();
            this.validityNotification = null;
        }
    };
    return CellEditor;
}());
/**
 * Abstract base class with shared functionality
 * for cell editors which use HTML Input widget as editor.
 */
var InputCellEditor = /** @class */ (function (_super) {
    __extends(InputCellEditor, _super);
    function InputCellEditor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Handle the DOM events for the editor.
     *
     * @param event - The DOM event sent to the editor.
     */
    InputCellEditor.prototype.handleEvent = function (event) {
        switch (event.type) {
            case 'keydown':
                this._onKeyDown(event);
                break;
            case 'blur':
                this._onBlur(event);
                break;
            case 'input':
                this._onInput(event);
                break;
        }
    };
    /**
     * Dispose of the resources held by cell editor.
     */
    InputCellEditor.prototype.dispose = function () {
        if (this.isDisposed) {
            return;
        }
        this._unbindEvents();
        _super.prototype.dispose.call(this);
    };
    /**
     * Start editing the cell.
     */
    InputCellEditor.prototype.startEditing = function () {
        this.createWidget();
        var cell = this.cell;
        var cellInfo = this.getCellInfo(cell);
        this.input.value = this.deserialize(cellInfo.data);
        this.editorContainer.appendChild(this.input);
        this.input.focus();
        this.input.select();
        this.bindEvents();
    };
    InputCellEditor.prototype.deserialize = function (value) {
        if (value === null || value === undefined) {
            return '';
        }
        return value.toString();
    };
    InputCellEditor.prototype.createWidget = function () {
        var input = document.createElement('input');
        input.classList.add('lm-DataGrid-cellEditorWidget');
        input.classList.add('lm-DataGrid-cellEditorInput');
        input.spellcheck = false;
        input.type = this.inputType;
        this.input = input;
    };
    InputCellEditor.prototype.bindEvents = function () {
        this.input.addEventListener('keydown', this);
        this.input.addEventListener('blur', this);
        this.input.addEventListener('input', this);
    };
    InputCellEditor.prototype._unbindEvents = function () {
        this.input.removeEventListener('keydown', this);
        this.input.removeEventListener('blur', this);
        this.input.removeEventListener('input', this);
    };
    InputCellEditor.prototype._onKeyDown = function (event) {
        switch ((0,_lumino_keyboard__WEBPACK_IMPORTED_MODULE_1__.getKeyboardLayout)().keyForKeydownEvent(event)) {
            case 'Enter':
                this.commit(event.shiftKey ? 'up' : 'down');
                break;
            case 'Tab':
                this.commit(event.shiftKey ? 'left' : 'right');
                event.stopPropagation();
                event.preventDefault();
                break;
            case 'Escape':
                this.cancel();
                break;
        }
    };
    InputCellEditor.prototype._onBlur = function (event) {
        if (this.isDisposed) {
            return;
        }
        if (!this.commit()) {
            event.preventDefault();
            event.stopPropagation();
            this.input.focus();
        }
    };
    InputCellEditor.prototype._onInput = function (event) {
        this.inputChanged.emit(void 0);
    };
    return InputCellEditor;
}(CellEditor));
/**
 * Cell editor for text cells.
 */
var TextCellEditor = /** @class */ (function (_super) {
    __extends(TextCellEditor, _super);
    function TextCellEditor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.inputType = 'text';
        return _this;
    }
    /**
     * Return the current text input entered.
     */
    TextCellEditor.prototype.getInput = function () {
        return this.input.value;
    };
    return TextCellEditor;
}(InputCellEditor));
/**
 * Cell editor for real number cells.
 */
var NumberCellEditor = /** @class */ (function (_super) {
    __extends(NumberCellEditor, _super);
    function NumberCellEditor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.inputType = 'number';
        return _this;
    }
    /**
     * Start editing the cell.
     */
    NumberCellEditor.prototype.startEditing = function () {
        _super.prototype.startEditing.call(this);
        this.input.step = 'any';
        var cell = this.cell;
        var metadata = cell.grid.dataModel.metadata('body', cell.row, cell.column);
        var constraint = metadata.constraint;
        if (constraint) {
            if (constraint.minimum) {
                this.input.min = constraint.minimum;
            }
            if (constraint.maximum) {
                this.input.max = constraint.maximum;
            }
        }
    };
    /**
     * Return the current number input entered. This method throws exception
     * if input is invalid.
     */
    NumberCellEditor.prototype.getInput = function () {
        var value = this.input.value;
        if (value.trim() === '') {
            return null;
        }
        var floatValue = parseFloat(value);
        if (isNaN(floatValue)) {
            throw new Error('Invalid input');
        }
        return floatValue;
    };
    return NumberCellEditor;
}(InputCellEditor));
/**
 * Cell editor for integer cells.
 */
var IntegerCellEditor = /** @class */ (function (_super) {
    __extends(IntegerCellEditor, _super);
    function IntegerCellEditor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.inputType = 'number';
        return _this;
    }
    /**
     * Start editing the cell.
     */
    IntegerCellEditor.prototype.startEditing = function () {
        _super.prototype.startEditing.call(this);
        this.input.step = '1';
        var cell = this.cell;
        var metadata = cell.grid.dataModel.metadata('body', cell.row, cell.column);
        var constraint = metadata.constraint;
        if (constraint) {
            if (constraint.minimum) {
                this.input.min = constraint.minimum;
            }
            if (constraint.maximum) {
                this.input.max = constraint.maximum;
            }
        }
    };
    /**
     * Return the current integer input entered. This method throws exception
     * if input is invalid.
     */
    IntegerCellEditor.prototype.getInput = function () {
        var value = this.input.value;
        if (value.trim() === '') {
            return null;
        }
        var intValue = parseInt(value);
        if (isNaN(intValue)) {
            throw new Error('Invalid input');
        }
        return intValue;
    };
    return IntegerCellEditor;
}(InputCellEditor));
/**
 * Cell editor for date cells.
 */
var DateCellEditor = /** @class */ (function (_super) {
    __extends(DateCellEditor, _super);
    function DateCellEditor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Handle the DOM events for the editor.
     *
     * @param event - The DOM event sent to the editor.
     */
    DateCellEditor.prototype.handleEvent = function (event) {
        switch (event.type) {
            case 'keydown':
                this._onKeyDown(event);
                break;
            case 'blur':
                this._onBlur(event);
                break;
        }
    };
    /**
     * Dispose of the resources held by cell editor.
     */
    DateCellEditor.prototype.dispose = function () {
        if (this.isDisposed) {
            return;
        }
        this._unbindEvents();
        _super.prototype.dispose.call(this);
    };
    /**
     * Start editing the cell.
     */
    DateCellEditor.prototype.startEditing = function () {
        this._createWidget();
        var cell = this.cell;
        var cellInfo = this.getCellInfo(cell);
        this._input.value = this._deserialize(cellInfo.data);
        this.editorContainer.appendChild(this._input);
        this._input.focus();
        this._bindEvents();
    };
    /**
     * Return the current date input entered.
     */
    DateCellEditor.prototype.getInput = function () {
        return this._input.value;
    };
    DateCellEditor.prototype._deserialize = function (value) {
        if (value === null || value === undefined) {
            return '';
        }
        return value.toString();
    };
    DateCellEditor.prototype._createWidget = function () {
        var input = document.createElement('input');
        input.type = 'date';
        input.pattern = 'd{4}-d{2}-d{2}';
        input.classList.add('lm-DataGrid-cellEditorWidget');
        input.classList.add('lm-DataGrid-cellEditorInput');
        this._input = input;
    };
    DateCellEditor.prototype._bindEvents = function () {
        this._input.addEventListener('keydown', this);
        this._input.addEventListener('blur', this);
    };
    DateCellEditor.prototype._unbindEvents = function () {
        this._input.removeEventListener('keydown', this);
        this._input.removeEventListener('blur', this);
    };
    DateCellEditor.prototype._onKeyDown = function (event) {
        switch ((0,_lumino_keyboard__WEBPACK_IMPORTED_MODULE_1__.getKeyboardLayout)().keyForKeydownEvent(event)) {
            case 'Enter':
                this.commit(event.shiftKey ? 'up' : 'down');
                break;
            case 'Tab':
                this.commit(event.shiftKey ? 'left' : 'right');
                event.stopPropagation();
                event.preventDefault();
                break;
            case 'Escape':
                this.cancel();
                break;
        }
    };
    DateCellEditor.prototype._onBlur = function (event) {
        if (this.isDisposed) {
            return;
        }
        if (!this.commit()) {
            event.preventDefault();
            event.stopPropagation();
            this._input.focus();
        }
    };
    return DateCellEditor;
}(CellEditor));
/**
 * Cell editor for boolean cells.
 */
var BooleanCellEditor = /** @class */ (function (_super) {
    __extends(BooleanCellEditor, _super);
    function BooleanCellEditor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Handle the DOM events for the editor.
     *
     * @param event - The DOM event sent to the editor.
     */
    BooleanCellEditor.prototype.handleEvent = function (event) {
        switch (event.type) {
            case 'keydown':
                this._onKeyDown(event);
                break;
            case 'mousedown':
                // fix focus loss problem in Safari and Firefox
                this._input.focus();
                event.stopPropagation();
                event.preventDefault();
                break;
            case 'blur':
                this._onBlur(event);
                break;
        }
    };
    /**
     * Dispose of the resources held by cell editor.
     */
    BooleanCellEditor.prototype.dispose = function () {
        if (this.isDisposed) {
            return;
        }
        this._unbindEvents();
        _super.prototype.dispose.call(this);
    };
    /**
     * Start editing the cell.
     */
    BooleanCellEditor.prototype.startEditing = function () {
        this._createWidget();
        var cell = this.cell;
        var cellInfo = this.getCellInfo(cell);
        this._input.checked = this._deserialize(cellInfo.data);
        this.editorContainer.appendChild(this._input);
        this._input.focus();
        this._bindEvents();
    };
    /**
     * Return the current boolean input entered.
     */
    BooleanCellEditor.prototype.getInput = function () {
        return this._input.checked;
    };
    BooleanCellEditor.prototype._deserialize = function (value) {
        if (value === null || value === undefined) {
            return false;
        }
        return value == true;
    };
    BooleanCellEditor.prototype._createWidget = function () {
        var input = document.createElement('input');
        input.classList.add('lm-DataGrid-cellEditorWidget');
        input.classList.add('lm-DataGrid-cellEditorCheckbox');
        input.type = 'checkbox';
        input.spellcheck = false;
        this._input = input;
    };
    BooleanCellEditor.prototype._bindEvents = function () {
        this._input.addEventListener('keydown', this);
        this._input.addEventListener('mousedown', this);
        this._input.addEventListener('blur', this);
    };
    BooleanCellEditor.prototype._unbindEvents = function () {
        this._input.removeEventListener('keydown', this);
        this._input.removeEventListener('mousedown', this);
        this._input.removeEventListener('blur', this);
    };
    BooleanCellEditor.prototype._onKeyDown = function (event) {
        switch ((0,_lumino_keyboard__WEBPACK_IMPORTED_MODULE_1__.getKeyboardLayout)().keyForKeydownEvent(event)) {
            case 'Enter':
                this.commit(event.shiftKey ? 'up' : 'down');
                break;
            case 'Tab':
                this.commit(event.shiftKey ? 'left' : 'right');
                event.stopPropagation();
                event.preventDefault();
                break;
            case 'Escape':
                this.cancel();
                break;
        }
    };
    BooleanCellEditor.prototype._onBlur = function (event) {
        if (this.isDisposed) {
            return;
        }
        if (!this.commit()) {
            event.preventDefault();
            event.stopPropagation();
            this._input.focus();
        }
    };
    return BooleanCellEditor;
}(CellEditor));
/**
 * Cell editor for option cells.
 *
 * It supports multiple option selection. If cell metadata contains
 * type attribute 'array', then it behaves as a multi select.
 * In that case cell data is expected to be list of string values.
 */
var OptionCellEditor = /** @class */ (function (_super) {
    __extends(OptionCellEditor, _super);
    function OptionCellEditor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._isMultiSelect = false;
        return _this;
    }
    /**
     * Dispose of the resources held by cell editor.
     */
    OptionCellEditor.prototype.dispose = function () {
        if (this.isDisposed) {
            return;
        }
        _super.prototype.dispose.call(this);
        if (this._isMultiSelect) {
            document.body.removeChild(this._select);
        }
    };
    /**
     * Start editing the cell.
     */
    OptionCellEditor.prototype.startEditing = function () {
        var cell = this.cell;
        var cellInfo = this.getCellInfo(cell);
        var metadata = cell.grid.dataModel.metadata('body', cell.row, cell.column);
        this._isMultiSelect = metadata.type === 'array';
        this._createWidget();
        if (this._isMultiSelect) {
            this._select.multiple = true;
            var values = this._deserialize(cellInfo.data);
            for (var i = 0; i < this._select.options.length; ++i) {
                var option = this._select.options.item(i);
                option.selected = values.indexOf(option.value) !== -1;
            }
            document.body.appendChild(this._select);
        }
        else {
            this._select.value = this._deserialize(cellInfo.data);
            this.editorContainer.appendChild(this._select);
        }
        this._select.focus();
        this._bindEvents();
        this.updatePosition();
    };
    /**
     * Return the current option input.
     */
    OptionCellEditor.prototype.getInput = function () {
        if (this._isMultiSelect) {
            var input = [];
            for (var i = 0; i < this._select.selectedOptions.length; ++i) {
                input.push(this._select.selectedOptions.item(i).value);
            }
            return input;
        }
        else {
            return this._select.value;
        }
    };
    /**
     * Reposition cell editor.
     */
    OptionCellEditor.prototype.updatePosition = function () {
        _super.prototype.updatePosition.call(this);
        if (!this._isMultiSelect) {
            return;
        }
        var cellInfo = this.getCellInfo(this.cell);
        this._select.style.position = 'absolute';
        var editorContainerRect = this.editorContainer.getBoundingClientRect();
        this._select.style.left = editorContainerRect.left + 'px';
        this._select.style.top = editorContainerRect.top + cellInfo.height + 'px';
        this._select.style.width = editorContainerRect.width + 'px';
        this._select.style.maxHeight = '60px';
        this.editorContainer.style.visibility = 'hidden';
    };
    OptionCellEditor.prototype._deserialize = function (value) {
        if (value === null || value === undefined) {
            return '';
        }
        if (this._isMultiSelect) {
            var values = [];
            if (Array.isArray(value)) {
                for (var _i = 0, value_1 = value; _i < value_1.length; _i++) {
                    var item = value_1[_i];
                    values.push(item.toString());
                }
            }
            return values;
        }
        else {
            return value.toString();
        }
    };
    OptionCellEditor.prototype._createWidget = function () {
        var cell = this.cell;
        var metadata = cell.grid.dataModel.metadata('body', cell.row, cell.column);
        var items = metadata.constraint.enum;
        var select = document.createElement('select');
        select.classList.add('lm-DataGrid-cellEditorWidget');
        for (var _i = 0, items_1 = items; _i < items_1.length; _i++) {
            var item = items_1[_i];
            var option = document.createElement('option');
            option.value = item;
            option.text = item;
            select.appendChild(option);
        }
        this._select = select;
    };
    OptionCellEditor.prototype._bindEvents = function () {
        this._select.addEventListener('keydown', this._onKeyDown.bind(this));
        this._select.addEventListener('blur', this._onBlur.bind(this));
    };
    OptionCellEditor.prototype._onKeyDown = function (event) {
        switch ((0,_lumino_keyboard__WEBPACK_IMPORTED_MODULE_1__.getKeyboardLayout)().keyForKeydownEvent(event)) {
            case 'Enter':
                this.commit(event.shiftKey ? 'up' : 'down');
                break;
            case 'Tab':
                this.commit(event.shiftKey ? 'left' : 'right');
                event.stopPropagation();
                event.preventDefault();
                break;
            case 'Escape':
                this.cancel();
                break;
        }
    };
    OptionCellEditor.prototype._onBlur = function (event) {
        if (this.isDisposed) {
            return;
        }
        if (!this.commit()) {
            event.preventDefault();
            event.stopPropagation();
            this._select.focus();
        }
    };
    return OptionCellEditor;
}(CellEditor));
/**
 * Cell editor for option cells whose value can be any value
 * from set of pre-defined options or values that can be input by user.
 */
var DynamicOptionCellEditor = /** @class */ (function (_super) {
    __extends(DynamicOptionCellEditor, _super);
    function DynamicOptionCellEditor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Handle the DOM events for the editor.
     *
     * @param event - The DOM event sent to the editor.
     */
    DynamicOptionCellEditor.prototype.handleEvent = function (event) {
        switch (event.type) {
            case 'keydown':
                this._onKeyDown(event);
                break;
            case 'blur':
                this._onBlur(event);
                break;
        }
    };
    /**
     * Dispose of the resources held by cell editor.
     */
    DynamicOptionCellEditor.prototype.dispose = function () {
        if (this.isDisposed) {
            return;
        }
        this._unbindEvents();
        _super.prototype.dispose.call(this);
    };
    /**
     * Start editing the cell.
     */
    DynamicOptionCellEditor.prototype.startEditing = function () {
        this._createWidget();
        var cell = this.cell;
        var cellInfo = this.getCellInfo(cell);
        this._input.value = this._deserialize(cellInfo.data);
        this.editorContainer.appendChild(this._input);
        this._input.focus();
        this._input.select();
        this._bindEvents();
    };
    /**
     * Return the current option input.
     */
    DynamicOptionCellEditor.prototype.getInput = function () {
        return this._input.value;
    };
    DynamicOptionCellEditor.prototype._deserialize = function (value) {
        if (value === null || value === undefined) {
            return '';
        }
        return value.toString();
    };
    DynamicOptionCellEditor.prototype._createWidget = function () {
        var cell = this.cell;
        var grid = cell.grid;
        var dataModel = grid.dataModel;
        var rowCount = dataModel.rowCount('body');
        var listId = 'cell-editor-list';
        var list = document.createElement('datalist');
        list.id = listId;
        var input = document.createElement('input');
        input.classList.add('lm-DataGrid-cellEditorWidget');
        input.classList.add('lm-DataGrid-cellEditorInput');
        var valueSet = new Set();
        for (var r = 0; r < rowCount; ++r) {
            var data = dataModel.data('body', r, cell.column);
            if (data) {
                valueSet.add(data);
            }
        }
        valueSet.forEach(function (value) {
            var option = document.createElement('option');
            option.value = value;
            option.text = value;
            list.appendChild(option);
        });
        this.editorContainer.appendChild(list);
        input.setAttribute('list', listId);
        this._input = input;
    };
    DynamicOptionCellEditor.prototype._bindEvents = function () {
        this._input.addEventListener('keydown', this);
        this._input.addEventListener('blur', this);
    };
    DynamicOptionCellEditor.prototype._unbindEvents = function () {
        this._input.removeEventListener('keydown', this);
        this._input.removeEventListener('blur', this);
    };
    DynamicOptionCellEditor.prototype._onKeyDown = function (event) {
        switch ((0,_lumino_keyboard__WEBPACK_IMPORTED_MODULE_1__.getKeyboardLayout)().keyForKeydownEvent(event)) {
            case 'Enter':
                this.commit(event.shiftKey ? 'up' : 'down');
                break;
            case 'Tab':
                this.commit(event.shiftKey ? 'left' : 'right');
                event.stopPropagation();
                event.preventDefault();
                break;
            case 'Escape':
                this.cancel();
                break;
        }
    };
    DynamicOptionCellEditor.prototype._onBlur = function (event) {
        if (this.isDisposed) {
            return;
        }
        if (!this.commit()) {
            event.preventDefault();
            event.stopPropagation();
            this._input.focus();
        }
    };
    return DynamicOptionCellEditor;
}(CellEditor));

/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2019, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Resolve a config option for a cell editor.
 *
 * @param option - The config option to resolve.
 *
 * @param config - The cell config object.
 *
 * @returns The resolved value for the option.
 */
function resolveOption(option, config) {
    return typeof option === 'function'
        ? option(config)
        : option;
}
/**
 * An object which manages cell editing. It stores editor overrides,
 * decides which editor to use for a cell, makes sure there is only one editor active.
 */
var CellEditorController = /** @class */ (function () {
    function CellEditorController() {
        // active cell editor
        this._editor = null;
        // active cell being edited
        this._cell = null;
        // cell editor overrides based on cell data type identifier
        this._typeBasedOverrides = new Map();
        // cell editor overrides based on partial metadata match
        this._metadataBasedOverrides = new Map();
    }
    /**
     * Override cell editor for the cells matching the identifier.
     *
     * @param identifier - Cell identifier to use when matching cells.
     * if identifier is a CellDataType, then cell matching is done using data type of the cell,
     * if identifier is a Metadata, then partial match of the cell metadata with identifier is used for match,
     * if identifier is 'default' then override is used as default editor when no other editor is found suitable
     *
     * @param editor - The cell editor to use or resolver to use to get an editor for matching cells.
     */
    CellEditorController.prototype.setEditor = function (identifier, editor) {
        if (typeof identifier === 'string') {
            this._typeBasedOverrides.set(identifier, editor);
        }
        else {
            var key = this._metadataIdentifierToKey(identifier);
            this._metadataBasedOverrides.set(key, [identifier, editor]);
        }
    };
    /**
     * Start editing a cell.
     *
     * @param cell - The object holding cell configuration data.
     *
     * @param options - The cell editing options.
     */
    CellEditorController.prototype.edit = function (cell, options) {
        var grid = cell.grid;
        if (!grid.editable) {
            console.error('Grid cannot be edited!');
            return false;
        }
        this.cancel();
        this._cell = cell;
        options = options || {};
        options.onCommit = options.onCommit || this._onCommit.bind(this);
        options.onCancel = options.onCancel || this._onCancel.bind(this);
        // if an editor is passed in with options, then use it for editing
        if (options.editor) {
            this._editor = options.editor;
            options.editor.edit(cell, options);
            return true;
        }
        // choose an editor based on overrides / cell data type
        var editor = this._getEditor(cell);
        if (editor) {
            this._editor = editor;
            editor.edit(cell, options);
            return true;
        }
        return false;
    };
    /**
     * Cancel editing.
     */
    CellEditorController.prototype.cancel = function () {
        if (this._editor) {
            this._editor.cancel();
            this._editor = null;
        }
        this._cell = null;
    };
    CellEditorController.prototype._onCommit = function (response) {
        var cell = this._cell;
        if (!cell) {
            return;
        }
        var grid = cell.grid;
        var dataModel = grid.dataModel;
        var row = cell.row;
        var column = cell.column;
        var cellGroup = CellGroup.getGroup(grid.dataModel, 'body', row, column);
        if (cellGroup) {
            row = cellGroup.r1;
            column = cellGroup.c1;
        }
        dataModel.setData('body', row, column, response.value);
        grid.viewport.node.focus();
        if (response.cursorMovement !== 'none') {
            grid.moveCursor(response.cursorMovement);
            grid.scrollToCursor();
        }
    };
    CellEditorController.prototype._onCancel = function () {
        if (!this._cell) {
            return;
        }
        this._cell.grid.viewport.node.focus();
    };
    CellEditorController.prototype._getDataTypeKey = function (cell) {
        var metadata = cell.grid.dataModel
            ? cell.grid.dataModel.metadata('body', cell.row, cell.column)
            : null;
        if (!metadata) {
            return 'default';
        }
        var key = '';
        if (metadata) {
            key = metadata.type;
        }
        if (metadata.constraint && metadata.constraint.enum) {
            if (metadata.constraint.enum === 'dynamic') {
                key += ':dynamic-option';
            }
            else {
                key += ':option';
            }
        }
        return key;
    };
    CellEditorController.prototype._objectToKey = function (object) {
        var str = '';
        for (var key in object) {
            var value = object[key];
            if (typeof value === 'object') {
                str += key + ":" + this._objectToKey(value);
            }
            else {
                str += "[" + key + ":" + value + "]";
            }
        }
        return str;
    };
    CellEditorController.prototype._metadataIdentifierToKey = function (metadata) {
        return this._objectToKey(metadata);
    };
    CellEditorController.prototype._metadataMatchesIdentifier = function (metadata, identifier) {
        for (var key in identifier) {
            if (!metadata.hasOwnProperty(key)) {
                return false;
            }
            var identifierValue = identifier[key];
            var metadataValue = metadata[key];
            if (typeof identifierValue === 'object') {
                if (!this._metadataMatchesIdentifier(metadataValue, identifierValue)) {
                    return false;
                }
            }
            else if (metadataValue !== identifierValue) {
                return false;
            }
        }
        return true;
    };
    CellEditorController.prototype._getMetadataBasedEditor = function (cell) {
        var _this = this;
        var editorMatched;
        var metadata = cell.grid.dataModel.metadata('body', cell.row, cell.column);
        if (metadata) {
            this._metadataBasedOverrides.forEach(function (value) {
                if (!editorMatched) {
                    var identifier = value[0], editor = value[1];
                    if (_this._metadataMatchesIdentifier(metadata, identifier)) {
                        editorMatched = resolveOption(editor, cell);
                    }
                }
            });
        }
        return editorMatched;
    };
    /**
     * Choose the most appropriate cell editor to use based on overrides / cell data type.
     *
     * If no match is found in overrides or based on cell data type, and if cell has a primitive
     * data type then TextCellEditor is used as default cell editor. If 'default' cell editor
     * is overridden, then it is used instead of TextCellEditor for default.
     */
    CellEditorController.prototype._getEditor = function (cell) {
        var dtKey = this._getDataTypeKey(cell);
        // find an editor based on data type based override
        if (this._typeBasedOverrides.has(dtKey)) {
            var editor = this._typeBasedOverrides.get(dtKey);
            return resolveOption(editor, cell);
        } // find an editor based on metadata match based override
        else if (this._metadataBasedOverrides.size > 0) {
            var editor = this._getMetadataBasedEditor(cell);
            if (editor) {
                return editor;
            }
        }
        // choose an editor based on data type
        switch (dtKey) {
            case 'string':
                return new TextCellEditor();
            case 'number':
                return new NumberCellEditor();
            case 'integer':
                return new IntegerCellEditor();
            case 'boolean':
                return new BooleanCellEditor();
            case 'date':
                return new DateCellEditor();
            case 'string:option':
            case 'number:option':
            case 'integer:option':
            case 'date:option':
            case 'array:option':
                return new OptionCellEditor();
            case 'string:dynamic-option':
            case 'number:dynamic-option':
            case 'integer:dynamic-option':
            case 'date:dynamic-option':
                return new DynamicOptionCellEditor();
        }
        // if an override exists for 'default', then use it
        if (this._typeBasedOverrides.has('default')) {
            var editor = this._typeBasedOverrides.get('default');
            return resolveOption(editor, cell);
        }
        // if cell has a primitive data type then use TextCellEditor
        var data = cell.grid.dataModel.data('body', cell.row, cell.column);
        if (!data || typeof data !== 'object') {
            return new TextCellEditor();
        }
        // no suitable editor found for the cell
        return undefined;
    };
    return CellEditorController;
}());

/**
 * An object which provides the data for a data grid.
 *
 * #### Notes
 * If the predefined data models are insufficient for a particular use
 * case, a custom model can be defined which derives from this class.
 */
var DataModel = /** @class */ (function () {
    function DataModel() {
        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);
    }
    Object.defineProperty(DataModel.prototype, "changed", {
        /**
         * A signal emitted when the data model has changed.
         */
        get: function () {
            return this._changed;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Get the count of merged cell groups pertaining to a given
     * cell region.
     * @param region the target cell region.
     */
    DataModel.prototype.groupCount = function (region) {
        return 0;
    };
    /**
     * Get the metadata for a cell in the data model.
     *
     * @param region - The cell region of interest.
     *
     * @param row - The row index of the cell of interest.
     *
     * @param column - The column index of the cell of interest.
     *
     * @returns The metadata for the specified cell.
     *
     * #### Notes
     * The returned metadata should be treated as immutable.
     *
     * This method is called often, and so should be efficient.
     *
     * The default implementation returns `{}`.
     */
    DataModel.prototype.metadata = function (region, row, column) {
        return DataModel.emptyMetadata;
    };
    /**
     * Get the merged cell group corresponding to a region and index number.
     * @param region the cell region of cell group.
     * @param groupIndex the group index of the cell group.
     * @returns a cell group.
     */
    DataModel.prototype.group = function (region, groupIndex) {
        return null;
    };
    /**
     * Emit the `changed` signal for the data model.
     *
     * #### Notes
     * Subclasses should call this method whenever the data model has
     * changed so that attached data grids can update themselves.
     */
    DataModel.prototype.emitChanged = function (args) {
        this._changed.emit(args);
    };
    return DataModel;
}());
/**
 * An object which provides the mutable data for a data grid.
 *
 * #### Notes
 * This object is an extension to `DataModel` and it only adds ability to
 * change data for cells.
 */
var MutableDataModel = /** @class */ (function (_super) {
    __extends(MutableDataModel, _super);
    function MutableDataModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return MutableDataModel;
}(DataModel));
/**
 * The namespace for the `DataModel` class statics.
 */
(function (DataModel) {
    /**
     * A singleton empty metadata object.
     */
    DataModel.emptyMetadata = Object.freeze({});
})(DataModel || (DataModel = {}));

/**
 * A thin caching wrapper around a 2D canvas rendering context.
 *
 * #### Notes
 * This class is mostly a transparent wrapper around a canvas rendering
 * context which improves performance when writing context state.
 *
 * For best performance, avoid reading state from the `gc`. Writes are
 * cached based on the previously written value.
 *
 * Unless otherwise specified, the API and semantics of this class are
 * identical to the builtin 2D canvas rendering context:
 * https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D
 *
 * The wrapped canvas context should not be manipulated externally
 * until the wrapping `GraphicsContext` object is disposed.
 */
var GraphicsContext = /** @class */ (function () {
    /**
     * Create a new graphics context object.
     *
     * @param context - The 2D canvas rendering context to wrap.
     */
    function GraphicsContext(context) {
        this._disposed = false;
        this._context = context;
        this._state = Private$3.State.create(context);
    }
    GraphicsContext.prototype.dispose = function () {
        // Bail if the gc is already disposed.
        if (this._disposed) {
            return;
        }
        // Mark the gc as disposed.
        this._disposed = true;
        // Pop any unrestored saves.
        while (this._state.next) {
            this._state = this._state.next;
            this._context.restore();
        }
    };
    Object.defineProperty(GraphicsContext.prototype, "isDisposed", {
        get: function () {
            return this._disposed;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "fillStyle", {
        get: function () {
            return this._context.fillStyle;
        },
        set: function (value) {
            if (this._state.fillStyle !== value) {
                this._state.fillStyle = value;
                this._context.fillStyle = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "strokeStyle", {
        get: function () {
            return this._context.strokeStyle;
        },
        set: function (value) {
            if (this._state.strokeStyle !== value) {
                this._state.strokeStyle = value;
                this._context.strokeStyle = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "font", {
        get: function () {
            return this._context.font;
        },
        set: function (value) {
            if (this._state.font !== value) {
                this._state.font = value;
                this._context.font = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "textAlign", {
        get: function () {
            return this._context.textAlign;
        },
        set: function (value) {
            if (this._state.textAlign !== value) {
                this._state.textAlign = value;
                this._context.textAlign = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "textBaseline", {
        get: function () {
            return this._context.textBaseline;
        },
        set: function (value) {
            if (this._state.textBaseline !== value) {
                this._state.textBaseline = value;
                this._context.textBaseline = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "lineCap", {
        get: function () {
            return this._context.lineCap;
        },
        set: function (value) {
            if (this._state.lineCap !== value) {
                this._state.lineCap = value;
                this._context.lineCap = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "lineDashOffset", {
        get: function () {
            return this._context.lineDashOffset;
        },
        set: function (value) {
            if (this._state.lineDashOffset !== value) {
                this._state.lineDashOffset = value;
                this._context.lineDashOffset = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "lineJoin", {
        get: function () {
            return this._context.lineJoin;
        },
        set: function (value) {
            if (this._state.lineJoin !== value) {
                this._state.lineJoin = value;
                this._context.lineJoin = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "lineWidth", {
        get: function () {
            return this._context.lineWidth;
        },
        set: function (value) {
            if (this._state.lineWidth !== value) {
                this._state.lineWidth = value;
                this._context.lineWidth = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "miterLimit", {
        get: function () {
            return this._context.miterLimit;
        },
        set: function (value) {
            if (this._state.miterLimit !== value) {
                this._state.miterLimit = value;
                this._context.miterLimit = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "shadowBlur", {
        get: function () {
            return this._context.shadowBlur;
        },
        set: function (value) {
            if (this._state.shadowBlur !== value) {
                this._state.shadowBlur = value;
                this._context.shadowBlur = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "shadowColor", {
        get: function () {
            return this._context.shadowColor;
        },
        set: function (value) {
            if (this._state.shadowColor !== value) {
                this._state.shadowColor = value;
                this._context.shadowColor = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "shadowOffsetX", {
        get: function () {
            return this._context.shadowOffsetX;
        },
        set: function (value) {
            if (this._state.shadowOffsetX !== value) {
                this._state.shadowOffsetX = value;
                this._context.shadowOffsetX = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "shadowOffsetY", {
        get: function () {
            return this._context.shadowOffsetY;
        },
        set: function (value) {
            if (this._state.shadowOffsetY !== value) {
                this._state.shadowOffsetY = value;
                this._context.shadowOffsetY = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "imageSmoothingEnabled", {
        get: function () {
            return this._context.imageSmoothingEnabled;
        },
        set: function (value) {
            if (this._state.imageSmoothingEnabled !== value) {
                this._state.imageSmoothingEnabled = value;
                this._context.imageSmoothingEnabled = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "globalAlpha", {
        get: function () {
            return this._context.globalAlpha;
        },
        set: function (value) {
            if (this._state.globalAlpha !== value) {
                this._state.globalAlpha = value;
                this._context.globalAlpha = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GraphicsContext.prototype, "globalCompositeOperation", {
        get: function () {
            return this._context.globalCompositeOperation;
        },
        set: function (value) {
            if (this._state.globalCompositeOperation !== value) {
                this._state.globalCompositeOperation = value;
                this._context.globalCompositeOperation = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    GraphicsContext.prototype.getLineDash = function () {
        return this._context.getLineDash();
    };
    GraphicsContext.prototype.setLineDash = function (segments) {
        this._context.setLineDash(segments);
    };
    GraphicsContext.prototype.rotate = function (angle) {
        this._context.rotate(angle);
    };
    GraphicsContext.prototype.scale = function (x, y) {
        this._context.scale(x, y);
    };
    GraphicsContext.prototype.transform = function (m11, m12, m21, m22, dx, dy) {
        this._context.transform(m11, m12, m21, m22, dx, dy);
    };
    GraphicsContext.prototype.translate = function (x, y) {
        this._context.translate(x, y);
    };
    GraphicsContext.prototype.setTransform = function (m11, m12, m21, m22, dx, dy) {
        this._context.setTransform(m11, m12, m21, m22, dx, dy);
    };
    GraphicsContext.prototype.save = function () {
        // Clone an push the current state to the stack.
        this._state = Private$3.State.push(this._state);
        // Save the wrapped context state.
        this._context.save();
    };
    GraphicsContext.prototype.restore = function () {
        // Bail if there is no state to restore.
        if (!this._state.next) {
            return;
        }
        // Pop the saved state from the stack.
        this._state = Private$3.State.pop(this._state);
        // Restore the wrapped context state.
        this._context.restore();
    };
    GraphicsContext.prototype.beginPath = function () {
        return this._context.beginPath();
    };
    GraphicsContext.prototype.closePath = function () {
        this._context.closePath();
    };
    GraphicsContext.prototype.isPointInPath = function (x, y, fillRule) {
        var result;
        if (arguments.length === 2) {
            result = this._context.isPointInPath(x, y);
        }
        else {
            result = this._context.isPointInPath(x, y, fillRule);
        }
        return result;
    };
    GraphicsContext.prototype.arc = function (x, y, radius, startAngle, endAngle, anticlockwise) {
        if (arguments.length === 5) {
            this._context.arc(x, y, radius, startAngle, endAngle);
        }
        else {
            this._context.arc(x, y, radius, startAngle, endAngle, anticlockwise);
        }
    };
    GraphicsContext.prototype.arcTo = function (x1, y1, x2, y2, radius) {
        this._context.arcTo(x1, y1, x2, y2, radius);
    };
    GraphicsContext.prototype.bezierCurveTo = function (cp1x, cp1y, cp2x, cp2y, x, y) {
        this._context.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    };
    GraphicsContext.prototype.ellipse = function (x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise) {
        if (arguments.length === 7) {
            this._context.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle);
        }
        else {
            this._context.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
        }
    };
    GraphicsContext.prototype.lineTo = function (x, y) {
        this._context.lineTo(x, y);
    };
    GraphicsContext.prototype.moveTo = function (x, y) {
        this._context.moveTo(x, y);
    };
    GraphicsContext.prototype.quadraticCurveTo = function (cpx, cpy, x, y) {
        this._context.quadraticCurveTo(cpx, cpy, x, y);
    };
    GraphicsContext.prototype.rect = function (x, y, w, h) {
        this._context.rect(x, y, w, h);
    };
    GraphicsContext.prototype.clip = function (fillRule) {
        if (arguments.length === 0) {
            this._context.clip();
        }
        else {
            this._context.clip(fillRule);
        }
    };
    GraphicsContext.prototype.fill = function (fillRule) {
        if (arguments.length === 0) {
            this._context.fill();
        }
        else {
            this._context.fill(fillRule);
        }
    };
    GraphicsContext.prototype.stroke = function () {
        this._context.stroke();
    };
    GraphicsContext.prototype.clearRect = function (x, y, w, h) {
        return this._context.clearRect(x, y, w, h);
    };
    GraphicsContext.prototype.fillRect = function (x, y, w, h) {
        this._context.fillRect(x, y, w, h);
    };
    GraphicsContext.prototype.fillText = function (text, x, y, maxWidth) {
        if (arguments.length === 3) {
            this._context.fillText(text, x, y);
        }
        else {
            this._context.fillText(text, x, y, maxWidth);
        }
    };
    GraphicsContext.prototype.strokeRect = function (x, y, w, h) {
        this._context.strokeRect(x, y, w, h);
    };
    GraphicsContext.prototype.strokeText = function (text, x, y, maxWidth) {
        if (arguments.length === 3) {
            this._context.strokeText(text, x, y);
        }
        else {
            this._context.strokeText(text, x, y, maxWidth);
        }
    };
    GraphicsContext.prototype.measureText = function (text) {
        return this._context.measureText(text);
    };
    GraphicsContext.prototype.createLinearGradient = function (x0, y0, x1, y1) {
        return this._context.createLinearGradient(x0, y0, x1, y1);
    };
    GraphicsContext.prototype.createRadialGradient = function (x0, y0, r0, x1, y1, r1) {
        return this._context.createRadialGradient(x0, y0, r0, x1, y1, r1);
    };
    GraphicsContext.prototype.createPattern = function (image, repetition) {
        return this._context.createPattern(image, repetition);
    };
    GraphicsContext.prototype.createImageData = function () {
        // eslint-disable-next-line prefer-spread, prefer-rest-params
        return this._context.createImageData.apply(this._context, arguments);
    };
    GraphicsContext.prototype.getImageData = function (sx, sy, sw, sh) {
        return this._context.getImageData(sx, sy, sw, sh);
    };
    GraphicsContext.prototype.putImageData = function () {
        // eslint-disable-next-line prefer-spread, prefer-rest-params
        this._context.putImageData.apply(this._context, arguments);
    };
    GraphicsContext.prototype.drawImage = function () {
        // eslint-disable-next-line prefer-spread, prefer-rest-params
        this._context.drawImage.apply(this._context, arguments);
    };
    GraphicsContext.prototype.drawFocusIfNeeded = function (element) {
        this._context.drawFocusIfNeeded(element);
    };
    return GraphicsContext;
}());
/**
 * The namespace for the module implementation details.
 */
var Private$3;
(function (Private) {
    /**
     * The index of next valid pool object.
     */
    var pi = -1;
    /**
     * A state object allocation pool.
     */
    var pool = [];
    /**
     * An object which holds the state for a gc.
     */
    var State = /** @class */ (function () {
        function State() {
        }
        /**
         * Create a gc state object from a 2D canvas context.
         */
        State.create = function (context) {
            var state = pi < 0 ? new State() : pool[pi--];
            state.next = null;
            state.fillStyle = context.fillStyle;
            state.font = context.font;
            state.globalAlpha = context.globalAlpha;
            state.globalCompositeOperation = context.globalCompositeOperation;
            state.imageSmoothingEnabled = context.imageSmoothingEnabled;
            state.lineCap = context.lineCap;
            state.lineDashOffset = context.lineDashOffset;
            state.lineJoin = context.lineJoin;
            state.lineWidth = context.lineWidth;
            state.miterLimit = context.miterLimit;
            state.shadowBlur = context.shadowBlur;
            state.shadowColor = context.shadowColor;
            state.shadowOffsetX = context.shadowOffsetX;
            state.shadowOffsetY = context.shadowOffsetY;
            state.strokeStyle = context.strokeStyle;
            state.textAlign = context.textAlign;
            state.textBaseline = context.textBaseline;
            return state;
        };
        /**
         * Clone an existing gc state object and add it to the state stack.
         */
        State.push = function (other) {
            var state = pi < 0 ? new State() : pool[pi--];
            state.next = other;
            state.fillStyle = other.fillStyle;
            state.font = other.font;
            state.globalAlpha = other.globalAlpha;
            state.globalCompositeOperation = other.globalCompositeOperation;
            state.imageSmoothingEnabled = other.imageSmoothingEnabled;
            state.lineCap = other.lineCap;
            state.lineDashOffset = other.lineDashOffset;
            state.lineJoin = other.lineJoin;
            state.lineWidth = other.lineWidth;
            state.miterLimit = other.miterLimit;
            state.shadowBlur = other.shadowBlur;
            state.shadowColor = other.shadowColor;
            state.shadowOffsetX = other.shadowOffsetX;
            state.shadowOffsetY = other.shadowOffsetY;
            state.strokeStyle = other.strokeStyle;
            state.textAlign = other.textAlign;
            state.textBaseline = other.textBaseline;
            return state;
        };
        /**
         * Pop the next state object and return the current to the pool
         */
        State.pop = function (state) {
            state.fillStyle = '';
            state.strokeStyle = '';
            pool[++pi] = state;
            return state.next;
        };
        return State;
    }());
    Private.State = State;
})(Private$3 || (Private$3 = {}));

/**
 * A class which manages the mapping of cell renderers.
 */
var RendererMap = /** @class */ (function () {
    /**
     * Construct a new renderer map.
     *
     * @param values - The initial values for the map.
     *
     * @param fallback - The renderer of last resort.
     */
    function RendererMap(values, fallback) {
        if (values === void 0) { values = {}; }
        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);
        this._values = __assign({}, values);
        this._fallback = fallback || new TextRenderer();
    }
    Object.defineProperty(RendererMap.prototype, "changed", {
        /**
         * A signal emitted when the renderer map has changed.
         */
        get: function () {
            return this._changed;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Get the cell renderer to use for the given cell config.
     *
     * @param config - The cell config of interest.
     *
     * @returns The renderer to use for the cell.
     */
    RendererMap.prototype.get = function (config) {
        // Fetch the renderer from the values map.
        var renderer = this._values[config.region];
        // Execute a resolver function if necessary.
        if (typeof renderer === 'function') {
            try {
                renderer = renderer(config);
            }
            catch (err) {
                renderer = undefined;
                console.error(err);
            }
        }
        // Return the renderer or the fallback.
        return renderer || this._fallback;
    };
    /**
     * Update the renderer map with new values
     *
     * @param values - The updated values for the map.
     *
     * @param fallback - The renderer of last resort.
     *
     * #### Notes
     * This method always emits the `changed` signal.
     */
    RendererMap.prototype.update = function (values, fallback) {
        if (values === void 0) { values = {}; }
        this._values = __assign(__assign({}, this._values), values);
        this._fallback = fallback || this._fallback;
        this._changed.emit(undefined);
    };
    return RendererMap;
}());

// Copyright (c) Jupyter Development Team.
/**
 * An object which manages a collection of variable sized sections.
 *
 * #### Notes
 * This class is an implementation detail. It is designed to manage
 * the variable row and column sizes for a data grid. User code will
 * not interact with this class directly.
 */
var SectionList = /** @class */ (function () {
    /**
     * Construct a new section list.
     *
     * @param options - The options for initializing the list.
     */
    function SectionList(options) {
        this._count = 0;
        this._length = 0;
        this._sections = [];
        this._minimumSize = options.minimumSize || 2;
        this._defaultSize = Math.max(this._minimumSize, Math.floor(options.defaultSize));
    }
    Object.defineProperty(SectionList.prototype, "length", {
        /**
         * The total size of all sections in the list.
         *
         * #### Complexity
         * Constant.
         */
        get: function () {
            return this._length;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SectionList.prototype, "count", {
        /**
         * The total number of sections in the list.
         *
         * #### Complexity
         * Constant.
         */
        get: function () {
            return this._count;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SectionList.prototype, "minimumSize", {
        /**
         * Get the minimum size of sections in the list.
         *
         * #### Complexity
         * Constant.
         */
        get: function () {
            return this._minimumSize;
        },
        /**
         * Set the minimum size of sections in the list.
         *
         * #### Complexity
         * Linear on the number of resized sections.
         */
        set: function (value) {
            // Normalize the value.
            value = Math.max(2, Math.floor(value));
            // Bail early if the value does not change.
            if (this._minimumSize === value) {
                return;
            }
            // Update the internal minimum size.
            this._minimumSize = value;
            // Update default size if larger than minimum size
            if (value > this._defaultSize) {
                this.defaultSize = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SectionList.prototype, "defaultSize", {
        /**
         * Get the default size of sections in the list.
         *
         * #### Complexity
         * Constant.
         */
        get: function () {
            return this._defaultSize;
        },
        /**
         * Set the default size of sections in the list.
         *
         * #### Complexity
         * Linear on the number of resized sections.
         */
        set: function (value) {
            // Normalize the value.
            value = Math.max(this._minimumSize, Math.floor(value));
            // Bail early if the value does not change.
            if (this._defaultSize === value) {
                return;
            }
            // Compute the delta default size.
            var delta = value - this._defaultSize;
            // Update the internal default size.
            this._defaultSize = value;
            // Update the length.
            this._length += delta * (this._count - this._sections.length);
            // Bail early if there are no modified sections.
            if (this._sections.length === 0) {
                return;
            }
            // Recompute the offsets of the modified sections.
            for (var i = 0, n = this._sections.length; i < n; ++i) {
                // Look up the previous and current modified sections.
                var prev = this._sections[i - 1];
                var curr = this._sections[i];
                // Adjust the offset for the current section.
                if (prev) {
                    var count = curr.index - prev.index - 1;
                    curr.offset = prev.offset + prev.size + count * value;
                }
                else {
                    curr.offset = curr.index * value;
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Clamp a size to the minimum section size
     *
     * @param size - The size to clamp.
     *
     * @returns The size or the section minimum size, whichever is larger
     */
    SectionList.prototype.clampSize = function (size) {
        return Math.max(this._minimumSize, Math.floor(size));
    };
    /**
     * Find the index of the section which covers the given offset.
     *
     * @param offset - The offset of the section of interest.
     *
     * @returns The index of the section which covers the given offset,
     *   or `-1` if the offset is out of range.
     *
     * #### Complexity
     * Logarithmic on the number of resized sections.
     */
    SectionList.prototype.indexOf = function (offset) {
        // Bail early if the offset is out of range.
        if (offset < 0 || offset >= this._length || this._count === 0) {
            return -1;
        }
        // Handle the simple case of no modified sections.
        if (this._sections.length === 0) {
            return Math.floor(offset / this._defaultSize);
        }
        // Find the modified section for the given offset.
        var i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, offset, Private$2.offsetCmp);
        // Return the index of an exact match.
        if (i < this._sections.length && this._sections[i].offset <= offset) {
            return this._sections[i].index;
        }
        // Handle the case of no modified sections before the offset.
        if (i === 0) {
            return Math.floor(offset / this._defaultSize);
        }
        // Compute the index from the previous modified section.
        var section = this._sections[i - 1];
        var span = offset - (section.offset + section.size);
        return section.index + Math.floor(span / this._defaultSize) + 1;
    };
    /**
     * Find the offset of the section at the given index.
     *
     * @param index - The index of the section of interest.
     *
     * @returns The offset of the section at the given index, or `-1`
     *   if the index is out of range.
     *
     * #### Undefined Behavior
     * An `index` which is non-integral.
     *
     * #### Complexity
     * Logarithmic on the number of resized sections.
     */
    SectionList.prototype.offsetOf = function (index) {
        // Bail early if the index is out of range.
        if (index < 0 || index >= this._count) {
            return -1;
        }
        // Handle the simple case of no modified sections.
        if (this._sections.length === 0) {
            return index * this._defaultSize;
        }
        // Find the modified section for the given index.
        var i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, index, Private$2.indexCmp);
        // Return the offset of an exact match.
        if (i < this._sections.length && this._sections[i].index === index) {
            return this._sections[i].offset;
        }
        // Handle the case of no modified sections before the index.
        if (i === 0) {
            return index * this._defaultSize;
        }
        // Compute the offset from the previous modified section.
        var section = this._sections[i - 1];
        var span = index - section.index - 1;
        return section.offset + section.size + span * this._defaultSize;
    };
    /**
     * Find the extent of the section at the given index.
     *
     * @param index - The index of the section of interest.
     *
     * @returns The extent of the section at the given index, or `-1`
     *   if the index is out of range.
     *
     * #### Undefined Behavior
     * An `index` which is non-integral.
     *
     * #### Complexity
     * Logarithmic on the number of resized sections.
     */
    SectionList.prototype.extentOf = function (index) {
        // Bail early if the index is out of range.
        if (index < 0 || index >= this._count) {
            return -1;
        }
        // Handle the simple case of no modified sections.
        if (this._sections.length === 0) {
            return (index + 1) * this._defaultSize - 1;
        }
        // Find the modified section for the given index.
        var i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, index, Private$2.indexCmp);
        // Return the offset of an exact match.
        if (i < this._sections.length && this._sections[i].index === index) {
            return this._sections[i].offset + this._sections[i].size - 1;
        }
        // Handle the case of no modified sections before the index.
        if (i === 0) {
            return (index + 1) * this._defaultSize - 1;
        }
        // Compute the offset from the previous modified section.
        var section = this._sections[i - 1];
        var span = index - section.index;
        return section.offset + section.size + span * this._defaultSize - 1;
    };
    /**
     * Find the size of the section at the given index.
     *
     * @param index - The index of the section of interest.
     *
     * @returns The size of the section at the given index, or `-1`
     *   if the index is out of range.
     *
     * #### Undefined Behavior
     * An `index` which is non-integral.
     *
     * #### Complexity
     * Logarithmic on the number of resized sections.
     */
    SectionList.prototype.sizeOf = function (index) {
        // Bail early if the index is out of range.
        if (index < 0 || index >= this._count) {
            return -1;
        }
        // Handle the simple case of no modified sections.
        if (this._sections.length === 0) {
            return this._defaultSize;
        }
        // Find the modified section for the given index.
        var i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, index, Private$2.indexCmp);
        // Return the size of an exact match.
        if (i < this._sections.length && this._sections[i].index === index) {
            return this._sections[i].size;
        }
        // Return the default size for all other cases.
        return this._defaultSize;
    };
    /**
     * Resize a section in the list.
     *
     * @param index - The index of the section to resize. This method
     *   is a no-op if this value is out of range.
     *
     * @param size - The new size of the section. This value will be
     *   clamped to an integer `>= 0`.
     *
     * #### Undefined Behavior
     * An `index` which is non-integral.
     *
     * #### Complexity
     * Linear on the number of resized sections.
     */
    SectionList.prototype.resize = function (index, size) {
        // Bail early if the index is out of range.
        if (index < 0 || index >= this._count) {
            return;
        }
        // Clamp the size to an integer >= minimum size.
        size = Math.max(this._minimumSize, Math.floor(size));
        // Find the modified section for the given index.
        var i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, index, Private$2.indexCmp);
        // Update or create the modified section as needed.
        var delta;
        if (i < this._sections.length && this._sections[i].index === index) {
            var section = this._sections[i];
            delta = size - section.size;
            section.size = size;
        }
        else if (i === 0) {
            var offset = index * this._defaultSize;
            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.insert(this._sections, i, { index: index, offset: offset, size: size });
            delta = size - this._defaultSize;
        }
        else {
            var section = this._sections[i - 1];
            var span = index - section.index - 1;
            var offset = section.offset + section.size + span * this._defaultSize;
            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.insert(this._sections, i, { index: index, offset: offset, size: size });
            delta = size - this._defaultSize;
        }
        // Adjust the length.
        this._length += delta;
        // Update all modified sections after the resized section.
        for (var j = i + 1, n = this._sections.length; j < n; ++j) {
            this._sections[j].offset += delta;
        }
    };
    /**
     * Insert sections into the list.
     *
     * @param index - The index at which to insert the sections. This
     *   value will be clamped to the bounds of the list.
     *
     * @param count - The number of sections to insert. This method
     *   is a no-op if this value is `<= 0`.
     *
     * #### Undefined Behavior
     * An `index` or `count` which is non-integral.
     *
     * #### Complexity
     * Linear on the number of resized sections.
     */
    SectionList.prototype.insert = function (index, count) {
        // Bail early if there are no sections to insert.
        if (count <= 0) {
            return;
        }
        // Clamp the index to the bounds of the list.
        index = Math.max(0, Math.min(index, this._count));
        // Add the new sections to the totals.
        var span = count * this._defaultSize;
        this._count += count;
        this._length += span;
        // Bail early if there are no modified sections to update.
        if (this._sections.length === 0) {
            return;
        }
        // Find the modified section for the given index.
        var i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, index, Private$2.indexCmp);
        // Update all modified sections after the insert location.
        for (var n = this._sections.length; i < n; ++i) {
            var section = this._sections[i];
            section.index += count;
            section.offset += span;
        }
    };
    /**
     * Remove sections from the list.
     *
     * @param index - The index of the first section to remove. This
     *   method is a no-op if this value is out of range.
     *
     * @param count - The number of sections to remove. This method
     *   is a no-op if this value is `<= 0`.
     *
     * #### Undefined Behavior
     * An `index` or `count` which is non-integral.
     *
     * #### Complexity
     * Linear on the number of resized sections.
     */
    SectionList.prototype.remove = function (index, count) {
        // Bail early if there is nothing to remove.
        if (index < 0 || index >= this._count || count <= 0) {
            return;
        }
        // Clamp the count to the bounds of the list.
        count = Math.min(this._count - index, count);
        // Handle the simple case of no modified sections to update.
        if (this._sections.length === 0) {
            this._count -= count;
            this._length -= count * this._defaultSize;
            return;
        }
        // Handle the simple case of removing all sections.
        if (count === this._count) {
            this._length = 0;
            this._count = 0;
            this._sections.length = 0;
            return;
        }
        // Find the modified section for the start index.
        var i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, index, Private$2.indexCmp);
        // Find the modified section for the end index.
        var j = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, index + count, Private$2.indexCmp);
        // Remove the relevant modified sections.
        var removed = this._sections.splice(i, j - i);
        // Compute the total removed span.
        var span = (count - removed.length) * this._defaultSize;
        for (var k = 0, n = removed.length; k < n; ++k) {
            span += removed[k].size;
        }
        // Adjust the totals.
        this._count -= count;
        this._length -= span;
        // Update all modified sections after the removed span.
        for (var k = i, n = this._sections.length; k < n; ++k) {
            var section = this._sections[k];
            section.index -= count;
            section.offset -= span;
        }
    };
    /**
     * Move sections within the list.
     *
     * @param index - The index of the first section to move. This method
     *   is a no-op if this value is out of range.
     *
     * @param count - The number of sections to move. This method is a
     *   no-op if this value is `<= 0`.
     *
     * @param destination - The destination index for the first section.
     *   This value will be clamped to the allowable range.
     *
     * #### Undefined Behavior
     * An `index`, `count`, or `destination` which is non-integral.
     *
     * #### Complexity
     * Linear on the number of moved resized sections.
     */
    SectionList.prototype.move = function (index, count, destination) {
        // Bail early if there is nothing to move.
        if (index < 0 || index >= this._count || count <= 0) {
            return;
        }
        // Handle the simple case of no modified sections.
        if (this._sections.length === 0) {
            return;
        }
        // Clamp the move count to the limit.
        count = Math.min(count, this._count - index);
        // Clamp the destination index to the limit.
        destination = Math.min(Math.max(0, destination), this._count - count);
        // Bail early if there is no effective move.
        if (index === destination) {
            return;
        }
        // Compute the first affected index.
        var i1 = Math.min(index, destination);
        // Look up the first affected modified section.
        var k1 = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, i1, Private$2.indexCmp);
        // Bail early if there are no affected modified sections.
        if (k1 === this._sections.length) {
            return;
        }
        // Compute the last affected index.
        var i2 = Math.max(index + count - 1, destination + count - 1);
        // Look up the last affected modified section.
        var k2 = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.upperBound(this._sections, i2, Private$2.indexCmp) - 1;
        // Bail early if there are no affected modified sections.
        if (k2 < k1) {
            return;
        }
        // Compute the pivot index.
        var pivot = destination < index ? index : index + count;
        // Compute the count for each side of the pivot.
        var count1 = pivot - i1;
        var count2 = i2 - pivot + 1;
        // Compute the span for each side of the pivot.
        var span1 = count1 * this._defaultSize;
        var span2 = count2 * this._defaultSize;
        // Adjust the spans for the modified sections.
        for (var j = k1; j <= k2; ++j) {
            var section = this._sections[j];
            if (section.index < pivot) {
                span1 += section.size - this._defaultSize;
            }
            else {
                span2 += section.size - this._defaultSize;
            }
        }
        // Look up the pivot section.
        var k3 = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.lowerBound(this._sections, pivot, Private$2.indexCmp);
        // Rotate the modified sections if needed.
        if (k1 <= k3 && k3 <= k2) {
            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.rotate(this._sections, k3 - k1, k1, k2);
        }
        // Adjust the modified section indices and offsets.
        for (var j = k1; j <= k2; ++j) {
            var section = this._sections[j];
            if (section.index < pivot) {
                section.index += count2;
                section.offset += span2;
            }
            else {
                section.index -= count1;
                section.offset -= span1;
            }
        }
    };
    /**
     * Reset all modified sections to the default size.
     *
     * #### Complexity
     * Constant.
     */
    SectionList.prototype.reset = function () {
        this._sections.length = 0;
        this._length = this._count * this._defaultSize;
    };
    /**
     * Remove all sections from the list.
     *
     * #### Complexity
     * Constant.
     */
    SectionList.prototype.clear = function () {
        this._count = 0;
        this._length = 0;
        this._sections.length = 0;
    };
    return SectionList;
}());
/**
 * The namespace for the module implementation details.
 */
var Private$2;
(function (Private) {
    /**
     * A comparison function for searching by offset.
     */
    function offsetCmp(section, offset) {
        if (offset < section.offset) {
            return 1;
        }
        if (section.offset + section.size <= offset) {
            return -1;
        }
        return 0;
    }
    Private.offsetCmp = offsetCmp;
    /**
     * A comparison function for searching by index.
     */
    function indexCmp(section, index) {
        return section.index - index;
    }
    Private.indexCmp = indexCmp;
})(Private$2 || (Private$2 = {}));

/**
 * A widget which implements a high-performance tabular data grid.
 *
 * #### Notes
 * A data grid is implemented as a composition of child widgets. These
 * child widgets are considered an implementation detail. Manipulating
 * the child widgets of a data grid directly is undefined behavior.
 *
 * This class is not designed to be subclassed.
 */
var DataGrid = /** @class */ (function (_super) {
    __extends(DataGrid, _super);
    /**
     * Construct a new data grid.
     *
     * @param options - The options for initializing the data grid.
     */
    function DataGrid(options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this) || this;
        _this._scrollX = 0;
        _this._scrollY = 0;
        _this._viewportWidth = 0;
        _this._viewportHeight = 0;
        _this._mousedown = false;
        _this._keyHandler = null;
        _this._mouseHandler = null;
        _this._vScrollBarMinWidth = 0;
        _this._hScrollBarMinHeight = 0;
        _this._dpiRatio = Math.ceil(window.devicePixelRatio);
        _this._dataModel = null;
        _this._selectionModel = null;
        _this._editingEnabled = false;
        _this.addClass('lm-DataGrid');
        /* <DEPRECATED> */
        _this.addClass('p-DataGrid');
        /* </DEPRECATED> */
        // Parse the simple options.
        _this._style = options.style || DataGrid.defaultStyle;
        _this._stretchLastRow = options.stretchLastRow || false;
        _this._stretchLastColumn = options.stretchLastColumn || false;
        _this._headerVisibility = options.headerVisibility || 'all';
        _this._cellRenderers = options.cellRenderers || new RendererMap();
        _this._copyConfig = options.copyConfig || DataGrid.defaultCopyConfig;
        // Connect to the renderer map changed signal.
        _this._cellRenderers.changed.connect(_this._onRenderersChanged, _this);
        // Parse the default sizes.
        var defaultSizes = options.defaultSizes || DataGrid.defaultSizes;
        var minimumSizes = options.minimumSizes || DataGrid.minimumSizes;
        // Set up the sections lists.
        _this._rowSections = new SectionList({
            defaultSize: defaultSizes.rowHeight,
            minimumSize: minimumSizes.rowHeight
        });
        _this._columnSections = new SectionList({
            defaultSize: defaultSizes.columnWidth,
            minimumSize: minimumSizes.columnWidth
        });
        _this._rowHeaderSections = new SectionList({
            defaultSize: defaultSizes.rowHeaderWidth,
            minimumSize: minimumSizes.rowHeaderWidth
        });
        _this._columnHeaderSections = new SectionList({
            defaultSize: defaultSizes.columnHeaderHeight,
            minimumSize: minimumSizes.columnHeaderHeight
        });
        // Create the canvas, buffer, and overlay objects.
        _this._canvas = Private$1.createCanvas();
        _this._buffer = Private$1.createCanvas();
        _this._overlay = Private$1.createCanvas();
        // Get the graphics contexts for the canvases.
        _this._canvasGC = _this._canvas.getContext('2d');
        _this._bufferGC = _this._buffer.getContext('2d');
        _this._overlayGC = _this._overlay.getContext('2d');
        // Set up the on-screen canvas.
        _this._canvas.style.position = 'absolute';
        _this._canvas.style.top = '0px';
        _this._canvas.style.left = '0px';
        _this._canvas.style.width = '0px';
        _this._canvas.style.height = '0px';
        // Set up the on-screen overlay.
        _this._overlay.style.position = 'absolute';
        _this._overlay.style.top = '0px';
        _this._overlay.style.left = '0px';
        _this._overlay.style.width = '0px';
        _this._overlay.style.height = '0px';
        // Create the internal widgets for the data grid.
        _this._viewport = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Widget();
        _this._viewport.node.tabIndex = -1;
        _this._viewport.node.style.outline = 'none';
        _this._vScrollBar = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.ScrollBar({ orientation: 'vertical' });
        _this._hScrollBar = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.ScrollBar({ orientation: 'horizontal' });
        _this._scrollCorner = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Widget();
        _this._editorController = new CellEditorController();
        // Add the extra class names to the child widgets.
        _this._viewport.addClass('lm-DataGrid-viewport');
        _this._vScrollBar.addClass('lm-DataGrid-scrollBar');
        _this._hScrollBar.addClass('lm-DataGrid-scrollBar');
        _this._scrollCorner.addClass('lm-DataGrid-scrollCorner');
        /* <DEPRECATED> */
        _this._viewport.addClass('p-DataGrid-viewport');
        _this._vScrollBar.addClass('p-DataGrid-scrollBar');
        _this._hScrollBar.addClass('p-DataGrid-scrollBar');
        _this._scrollCorner.addClass('p-DataGrid-scrollCorner');
        /* </DEPRECATED> */
        // Add the on-screen canvas to the viewport node.
        _this._viewport.node.appendChild(_this._canvas);
        // Add the on-screen overlay to the viewport node.
        _this._viewport.node.appendChild(_this._overlay);
        // Install the message hooks.
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.installMessageHook(_this._viewport, _this);
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.installMessageHook(_this._hScrollBar, _this);
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.installMessageHook(_this._vScrollBar, _this);
        // Hide the scroll bars and corner from the outset.
        _this._vScrollBar.hide();
        _this._hScrollBar.hide();
        _this._scrollCorner.hide();
        // Connect to the scroll bar signals.
        _this._vScrollBar.thumbMoved.connect(_this._onThumbMoved, _this);
        _this._hScrollBar.thumbMoved.connect(_this._onThumbMoved, _this);
        _this._vScrollBar.pageRequested.connect(_this._onPageRequested, _this);
        _this._hScrollBar.pageRequested.connect(_this._onPageRequested, _this);
        _this._vScrollBar.stepRequested.connect(_this._onStepRequested, _this);
        _this._hScrollBar.stepRequested.connect(_this._onStepRequested, _this);
        // Set the layout cell config for the child widgets.
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.GridLayout.setCellConfig(_this._viewport, { row: 0, column: 0 });
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.GridLayout.setCellConfig(_this._vScrollBar, { row: 0, column: 1 });
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.GridLayout.setCellConfig(_this._hScrollBar, { row: 1, column: 0 });
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.GridLayout.setCellConfig(_this._scrollCorner, { row: 1, column: 1 });
        // Create the layout for the data grid.
        var layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.GridLayout({
            rowCount: 2,
            columnCount: 2,
            rowSpacing: 0,
            columnSpacing: 0,
            fitPolicy: 'set-no-constraint'
        });
        // Set the stretch factors for the grid.
        layout.setRowStretch(0, 1);
        layout.setRowStretch(1, 0);
        layout.setColumnStretch(0, 1);
        layout.setColumnStretch(1, 0);
        // Add the child widgets to the layout.
        layout.addWidget(_this._viewport);
        layout.addWidget(_this._vScrollBar);
        layout.addWidget(_this._hScrollBar);
        layout.addWidget(_this._scrollCorner);
        // Install the layout on the data grid.
        _this.layout = layout;
        return _this;
    }
    /**
     * Dispose of the resources held by the widgets.
     */
    DataGrid.prototype.dispose = function () {
        // Release the mouse.
        this._releaseMouse();
        // Dispose of the handlers.
        if (this._keyHandler) {
            this._keyHandler.dispose();
        }
        if (this._mouseHandler) {
            this._mouseHandler.dispose();
        }
        this._keyHandler = null;
        this._mouseHandler = null;
        // Clear the models.
        this._dataModel = null;
        this._selectionModel = null;
        // Clear the section lists.
        this._rowSections.clear();
        this._columnSections.clear();
        this._rowHeaderSections.clear();
        this._columnHeaderSections.clear();
        // Dispose of the base class.
        _super.prototype.dispose.call(this);
    };
    Object.defineProperty(DataGrid.prototype, "dataModel", {
        /**
         * Get the data model for the data grid.
         */
        get: function () {
            return this._dataModel;
        },
        /**
         * Set the data model for the data grid.
         *
         * #### Notes
         * This will automatically remove the current selection model.
         */
        set: function (value) {
            // Do nothing if the model does not change.
            if (this._dataModel === value) {
                return;
            }
            // Release the mouse.
            this._releaseMouse();
            // Clear the selection model.
            this.selectionModel = null;
            // Disconnect the change handler from the old model.
            if (this._dataModel) {
                this._dataModel.changed.disconnect(this._onDataModelChanged, this);
            }
            // Connect the change handler for the new model.
            if (value) {
                value.changed.connect(this._onDataModelChanged, this);
            }
            // Update the internal model reference.
            this._dataModel = value;
            // Clear the section lists.
            this._rowSections.clear();
            this._columnSections.clear();
            this._rowHeaderSections.clear();
            this._columnHeaderSections.clear();
            // Populate the section lists.
            if (value) {
                this._rowSections.insert(0, value.rowCount('body'));
                this._columnSections.insert(0, value.columnCount('body'));
                this._rowHeaderSections.insert(0, value.columnCount('row-header'));
                this._columnHeaderSections.insert(0, value.rowCount('column-header'));
            }
            // Reset the scroll position.
            this._scrollX = 0;
            this._scrollY = 0;
            // Sync the viewport.
            this._syncViewport();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "selectionModel", {
        /**
         * Get the selection model for the data grid.
         */
        get: function () {
            return this._selectionModel;
        },
        /**
         * Set the selection model for the data grid.
         */
        set: function (value) {
            // Do nothing if the selection model does not change.
            if (this._selectionModel === value) {
                return;
            }
            // Release the mouse.
            this._releaseMouse();
            // Ensure the data models are a match.
            if (value && value.dataModel !== this._dataModel) {
                throw new Error('SelectionModel.dataModel !== DataGrid.dataModel');
            }
            // Disconnect the change handler from the old model.
            if (this._selectionModel) {
                this._selectionModel.changed.disconnect(this._onSelectionsChanged, this);
            }
            // Connect the change handler for the new model.
            if (value) {
                value.changed.connect(this._onSelectionsChanged, this);
            }
            // Update the internal selection model reference.
            this._selectionModel = value;
            // Schedule a repaint of the overlay.
            this.repaintOverlay();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "keyHandler", {
        /**
         * Get the key handler for the data grid.
         */
        get: function () {
            return this._keyHandler;
        },
        /**
         * Set the key handler for the data grid.
         */
        set: function (value) {
            this._keyHandler = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "mouseHandler", {
        /**
         * Get the mouse handler for the data grid.
         */
        get: function () {
            return this._mouseHandler;
        },
        /**
         * Set the mouse handler for the data grid.
         */
        set: function (value) {
            // Bail early if the mouse handler does not change.
            if (this._mouseHandler === value) {
                return;
            }
            // Release the mouse.
            this._releaseMouse();
            // Update the internal mouse handler.
            this._mouseHandler = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "style", {
        /**
         * Get the style for the data grid.
         */
        get: function () {
            return this._style;
        },
        /**
         * Set the style for the data grid.
         */
        set: function (value) {
            // Bail if the style does not change.
            if (this._style === value) {
                return;
            }
            // Update the internal style.
            this._style = __assign({}, value);
            // Schedule a repaint of the content.
            this.repaintContent();
            // Schedule a repaint of the overlay.
            this.repaintOverlay();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "cellRenderers", {
        /**
         * Get the cell renderer map for the data grid.
         */
        get: function () {
            return this._cellRenderers;
        },
        /**
         * Set the cell renderer map for the data grid.
         */
        set: function (value) {
            // Bail if the renderer map does not change.
            if (this._cellRenderers === value) {
                return;
            }
            // Disconnect the old map.
            this._cellRenderers.changed.disconnect(this._onRenderersChanged, this);
            // Connect the new map.
            value.changed.connect(this._onRenderersChanged, this);
            // Update the internal renderer map.
            this._cellRenderers = value;
            // Schedule a repaint of the grid content.
            this.repaintContent();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "headerVisibility", {
        /**
         * Get the header visibility for the data grid.
         */
        get: function () {
            return this._headerVisibility;
        },
        /**
         * Set the header visibility for the data grid.
         */
        set: function (value) {
            // Bail if the visibility does not change.
            if (this._headerVisibility === value) {
                return;
            }
            // Update the internal visibility.
            this._headerVisibility = value;
            // Sync the viewport.
            this._syncViewport();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "defaultSizes", {
        /**
         * Get the default sizes for the various sections of the data grid.
         */
        get: function () {
            var rowHeight = this._rowSections.defaultSize;
            var columnWidth = this._columnSections.defaultSize;
            var rowHeaderWidth = this._rowHeaderSections.defaultSize;
            var columnHeaderHeight = this._columnHeaderSections.defaultSize;
            return { rowHeight: rowHeight, columnWidth: columnWidth, rowHeaderWidth: rowHeaderWidth, columnHeaderHeight: columnHeaderHeight };
        },
        /**
         * Set the default sizes for the various sections of the data grid.
         */
        set: function (value) {
            // Update the section default sizes.
            this._rowSections.defaultSize = value.rowHeight;
            this._columnSections.defaultSize = value.columnWidth;
            this._rowHeaderSections.defaultSize = value.rowHeaderWidth;
            this._columnHeaderSections.defaultSize = value.columnHeaderHeight;
            // Sync the viewport.
            this._syncViewport();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "minimumSizes", {
        /**
         * Get the minimum sizes for the various sections of the data grid.
         */
        get: function () {
            var rowHeight = this._rowSections.minimumSize;
            var columnWidth = this._columnSections.minimumSize;
            var rowHeaderWidth = this._rowHeaderSections.minimumSize;
            var columnHeaderHeight = this._columnHeaderSections.minimumSize;
            return { rowHeight: rowHeight, columnWidth: columnWidth, rowHeaderWidth: rowHeaderWidth, columnHeaderHeight: columnHeaderHeight };
        },
        /**
         * Set the minimum sizes for the various sections of the data grid.
         */
        set: function (value) {
            // Update the section default sizes.
            this._rowSections.minimumSize = value.rowHeight;
            this._columnSections.minimumSize = value.columnWidth;
            this._rowHeaderSections.minimumSize = value.rowHeaderWidth;
            this._columnHeaderSections.minimumSize = value.columnHeaderHeight;
            // Sync the viewport.
            this._syncViewport();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "copyConfig", {
        /**
         * Get the copy configuration for the data grid.
         */
        get: function () {
            return this._copyConfig;
        },
        /**
         * Set the copy configuration for the data grid.
         */
        set: function (value) {
            this._copyConfig = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "stretchLastRow", {
        /**
         * Get whether the last row is stretched.
         */
        get: function () {
            return this._stretchLastRow;
        },
        /**
         * Set whether the last row is stretched.
         */
        set: function (value) {
            // Bail early if the value does not change.
            if (value === this._stretchLastRow) {
                return;
            }
            // Update the internal value.
            this._stretchLastRow = value;
            // Sync the viewport
            this._syncViewport();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "stretchLastColumn", {
        /**
         * Get whether the last column is stretched.
         */
        get: function () {
            return this._stretchLastColumn;
        },
        /**
         * Set whether the last column is stretched.
         */
        set: function (value) {
            // Bail early if the value does not change.
            if (value === this._stretchLastColumn) {
                return;
            }
            // Update the internal value.
            this._stretchLastColumn = value;
            // Sync the viewport
            this._syncViewport();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "headerWidth", {
        /**
         * The virtual width of the row headers.
         */
        get: function () {
            if (this._headerVisibility === 'none') {
                return 0;
            }
            if (this._headerVisibility === 'column') {
                return 0;
            }
            return this._rowHeaderSections.length;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "headerHeight", {
        /**
         * The virtual height of the column headers.
         */
        get: function () {
            if (this._headerVisibility === 'none') {
                return 0;
            }
            if (this._headerVisibility === 'row') {
                return 0;
            }
            return this._columnHeaderSections.length;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "bodyWidth", {
        /**
         * The virtual width of the grid body.
         *
         * #### Notes
         * This does *not* account for a stretched last column.
         */
        get: function () {
            return this._columnSections.length;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "bodyHeight", {
        /**
         * The virtual height of the grid body.
         *
         * #### Notes
         * This does *not* account for a stretched last row.
         */
        get: function () {
            return this._rowSections.length;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "totalWidth", {
        /**
         * The virtual width of the entire grid.
         *
         * #### Notes
         * This does *not* account for a stretched last column.
         */
        get: function () {
            return this.headerWidth + this.bodyWidth;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "totalHeight", {
        /**
         * The virtual height of the entire grid.
         *
         * #### Notes
         * This does *not* account for a stretched last row.
         */
        get: function () {
            return this.headerHeight + this.bodyHeight;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "viewportWidth", {
        /**
         * The actual width of the viewport.
         */
        get: function () {
            return this._viewportWidth;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "viewportHeight", {
        /**
         * The actual height of the viewport.
         */
        get: function () {
            return this._viewportHeight;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "pageWidth", {
        /**
         * The width of the visible portion of the grid body.
         */
        get: function () {
            return Math.max(0, this.viewportWidth - this.headerWidth);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "pageHeight", {
        /**
         * The height of the visible portion of the grid body.
         */
        get: function () {
            return Math.max(0, this.viewportHeight - this.headerHeight);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "scrollX", {
        /**
         * The current scroll X position of the viewport.
         */
        get: function () {
            return this._hScrollBar.value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "scrollY", {
        /**
         * The current scroll Y position of the viewport.
         */
        get: function () {
            return this._vScrollBar.value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "maxScrollX", {
        /**
         * The maximum scroll X position for the grid.
         */
        get: function () {
            return Math.max(0, this.bodyWidth - this.pageWidth - 1);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "maxScrollY", {
        /**
         * The maximum scroll Y position for the grid.
         */
        get: function () {
            return Math.max(0, this.bodyHeight - this.pageHeight - 1);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "viewport", {
        /**
         * The viewport widget for the data grid.
         */
        get: function () {
            return this._viewport;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "editorController", {
        /**
         * The cell editor controller object for the data grid.
         */
        get: function () {
            return this._editorController;
        },
        set: function (controller) {
            this._editorController = controller;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "editingEnabled", {
        /**
         * Whether the cell editing is enabled for the data grid.
         */
        get: function () {
            return this._editingEnabled;
        },
        set: function (enabled) {
            this._editingEnabled = enabled;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "editable", {
        /**
         * Whether the grid cells are editable.
         *
         * `editingEnabled` flag must be on and grid must have required
         * selection model, editor controller and data model properties.
         */
        get: function () {
            return (this._editingEnabled &&
                this._selectionModel !== null &&
                this._editorController !== null &&
                this.dataModel instanceof MutableDataModel);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "canvasGC", {
        /**
         * The rendering context for painting the data grid.
         */
        get: function () {
            return this._canvasGC;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "rowSections", {
        /**
         * The row sections of the data grid.
         */
        get: function () {
            return this._rowSections;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "columnSections", {
        /**
         * The column sections of the data grid.
         */
        get: function () {
            return this._columnSections;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "rowHeaderSections", {
        /**
         * The row header sections of the data grid.
         */
        get: function () {
            return this._rowHeaderSections;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataGrid.prototype, "columnHeaderSections", {
        /**
         * The column header sections of the data grid.
         */
        get: function () {
            return this._columnHeaderSections;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Scroll the grid to the specified row.
     *
     * @param row - The row index of the cell.
     *
     * #### Notes
     * This is a no-op if the row is already visible.
     */
    DataGrid.prototype.scrollToRow = function (row) {
        // Fetch the row count.
        var nr = this._rowSections.count;
        // Bail early if there is no content.
        if (nr === 0) {
            return;
        }
        // Floor the row index.
        row = Math.floor(row);
        // Clamp the row index.
        row = Math.max(0, Math.min(row, nr - 1));
        // Get the virtual bounds of the row.
        var y1 = this._rowSections.offsetOf(row);
        var y2 = this._rowSections.extentOf(row);
        // Get the virtual bounds of the viewport.
        var vy1 = this._scrollY;
        var vy2 = this._scrollY + this.pageHeight - 1;
        // Set up the delta variables.
        var dy = 0;
        // Compute the delta Y scroll.
        if (y1 < vy1) {
            dy = y1 - vy1 - 10;
        }
        else if (y2 > vy2) {
            dy = y2 - vy2 + 10;
        }
        // Bail early if no scroll is needed.
        if (dy === 0) {
            return;
        }
        // Scroll by the computed delta.
        this.scrollBy(0, dy);
    };
    /**
     * Scroll the grid to the specified column.
     *
     * @param column - The column index of the cell.
     *
     * #### Notes
     * This is a no-op if the column is already visible.
     */
    DataGrid.prototype.scrollToColumn = function (column) {
        // Fetch the column count.
        var nc = this._columnSections.count;
        // Bail early if there is no content.
        if (nc === 0) {
            return;
        }
        // Floor the column index.
        column = Math.floor(column);
        // Clamp the column index.
        column = Math.max(0, Math.min(column, nc - 1));
        // Get the virtual bounds of the column.
        var x1 = this._columnSections.offsetOf(column);
        var x2 = this._columnSections.extentOf(column);
        // Get the virtual bounds of the viewport.
        var vx1 = this._scrollX;
        var vx2 = this._scrollX + this.pageWidth - 1;
        // Set up the delta variables.
        var dx = 0;
        // Compute the delta X scroll.
        if (x1 < vx1) {
            dx = x1 - vx1 - 10;
        }
        else if (x2 > vx2) {
            dx = x2 - vx2 + 10;
        }
        // Bail early if no scroll is needed.
        if (dx === 0) {
            return;
        }
        // Scroll by the computed delta.
        this.scrollBy(dx, 0);
    };
    /**
     * Scroll the grid to the specified cell.
     *
     * @param row - The row index of the cell.
     *
     * @param column - The column index of the cell.
     *
     * #### Notes
     * This is a no-op if the cell is already visible.
     */
    DataGrid.prototype.scrollToCell = function (row, column) {
        // Fetch the row and column count.
        var nr = this._rowSections.count;
        var nc = this._columnSections.count;
        // Bail early if there is no content.
        if (nr === 0 || nc === 0) {
            return;
        }
        // Floor the cell index.
        row = Math.floor(row);
        column = Math.floor(column);
        // Clamp the cell index.
        row = Math.max(0, Math.min(row, nr - 1));
        column = Math.max(0, Math.min(column, nc - 1));
        // Get the virtual bounds of the cell.
        var x1 = this._columnSections.offsetOf(column);
        var x2 = this._columnSections.extentOf(column);
        var y1 = this._rowSections.offsetOf(row);
        var y2 = this._rowSections.extentOf(row);
        // Get the virtual bounds of the viewport.
        var vx1 = this._scrollX;
        var vx2 = this._scrollX + this.pageWidth - 1;
        var vy1 = this._scrollY;
        var vy2 = this._scrollY + this.pageHeight - 1;
        // Set up the delta variables.
        var dx = 0;
        var dy = 0;
        // Compute the delta X scroll.
        if (x1 < vx1) {
            dx = x1 - vx1 - 10;
        }
        else if (x2 > vx2) {
            dx = x2 - vx2 + 10;
        }
        // Compute the delta Y scroll.
        if (y1 < vy1) {
            dy = y1 - vy1 - 10;
        }
        else if (y2 > vy2) {
            dy = y2 - vy2 + 10;
        }
        // Bail early if no scroll is needed.
        if (dx === 0 && dy === 0) {
            return;
        }
        // Scroll by the computed delta.
        this.scrollBy(dx, dy);
    };
    /**
     * Move cursor down/up/left/right while making sure it remains
     * within the bounds of selected rectangles
     *
     * @param direction - The direction of the movement.
     */
    DataGrid.prototype.moveCursor = function (direction) {
        // Bail early if there is no selection
        if (!this.dataModel ||
            !this._selectionModel ||
            this._selectionModel.isEmpty) {
            return;
        }
        var iter = this._selectionModel.selections();
        var onlyOne = iter.next() && !iter.next();
        // if there is a single selection that is a single cell selection
        // then move the selection and cursor within grid bounds
        if (onlyOne) {
            var currentSel = this._selectionModel.currentSelection();
            if (currentSel.r1 === currentSel.r2 && currentSel.c1 === currentSel.c2) {
                var dr = direction === 'down' ? 1 : direction === 'up' ? -1 : 0;
                var dc = direction === 'right' ? 1 : direction === 'left' ? -1 : 0;
                var newRow = currentSel.r1 + dr;
                var newColumn = currentSel.c1 + dc;
                var rowCount = this.dataModel.rowCount('body');
                var columnCount = this.dataModel.columnCount('body');
                if (newRow >= rowCount) {
                    newRow = 0;
                    newColumn += 1;
                }
                else if (newRow === -1) {
                    newRow = rowCount - 1;
                    newColumn -= 1;
                }
                if (newColumn >= columnCount) {
                    newColumn = 0;
                    newRow += 1;
                    if (newRow >= rowCount) {
                        newRow = 0;
                    }
                }
                else if (newColumn === -1) {
                    newColumn = columnCount - 1;
                    newRow -= 1;
                    if (newRow === -1) {
                        newRow = rowCount - 1;
                    }
                }
                this._selectionModel.select({
                    r1: newRow,
                    c1: newColumn,
                    r2: newRow,
                    c2: newColumn,
                    cursorRow: newRow,
                    cursorColumn: newColumn,
                    clear: 'all'
                });
                return;
            }
        }
        // if there are multiple selections, move cursor
        // within selection rectangles
        this._selectionModel.moveCursorWithinSelections(direction);
    };
    /**
     * Scroll the grid to the current cursor position.
     *
     * #### Notes
     * This is a no-op if the cursor is already visible or
     * if there is no selection model installed on the grid.
     */
    DataGrid.prototype.scrollToCursor = function () {
        // Bail early if there is no selection model.
        if (!this._selectionModel) {
            return;
        }
        // Fetch the cursor row and column.
        var row = this._selectionModel.cursorRow;
        var column = this._selectionModel.cursorColumn;
        // Scroll to the cursor cell.
        this.scrollToCell(row, column);
    };
    /**
     * Scroll the viewport by the specified amount.
     *
     * @param dx - The X scroll amount.
     *
     * @param dy - The Y scroll amount.
     */
    DataGrid.prototype.scrollBy = function (dx, dy) {
        this.scrollTo(this.scrollX + dx, this.scrollY + dy);
    };
    /**
     * Scroll the viewport by one page.
     *
     * @param dir - The desired direction of the scroll.
     */
    DataGrid.prototype.scrollByPage = function (dir) {
        var dx = 0;
        var dy = 0;
        switch (dir) {
            case 'up':
                dy = -this.pageHeight;
                break;
            case 'down':
                dy = this.pageHeight;
                break;
            case 'left':
                dx = -this.pageWidth;
                break;
            case 'right':
                dx = this.pageWidth;
                break;
            default:
                throw 'unreachable';
        }
        this.scrollTo(this.scrollX + dx, this.scrollY + dy);
    };
    /**
     * Scroll the viewport by one cell-aligned step.
     *
     * @param dir - The desired direction of the scroll.
     */
    DataGrid.prototype.scrollByStep = function (dir) {
        var r;
        var c;
        var x = this.scrollX;
        var y = this.scrollY;
        var rows = this._rowSections;
        var columns = this._columnSections;
        switch (dir) {
            case 'up':
                r = rows.indexOf(y - 1);
                y = r < 0 ? y : rows.offsetOf(r);
                break;
            case 'down':
                r = rows.indexOf(y);
                y = r < 0 ? y : rows.offsetOf(r) + rows.sizeOf(r);
                break;
            case 'left':
                c = columns.indexOf(x - 1);
                x = c < 0 ? x : columns.offsetOf(c);
                break;
            case 'right':
                c = columns.indexOf(x);
                x = c < 0 ? x : columns.offsetOf(c) + columns.sizeOf(c);
                break;
            default:
                throw 'unreachable';
        }
        this.scrollTo(x, y);
    };
    /**
     * Scroll to the specified offset position.
     *
     * @param x - The desired X position.
     *
     * @param y - The desired Y position.
     */
    DataGrid.prototype.scrollTo = function (x, y) {
        // Floor and clamp the position to the allowable range.
        x = Math.max(0, Math.min(Math.floor(x), this.maxScrollX));
        y = Math.max(0, Math.min(Math.floor(y), this.maxScrollY));
        // Update the scroll bar values with the desired position.
        this._hScrollBar.value = x;
        this._vScrollBar.value = y;
        // Post a scroll request message to the viewport.
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.postMessage(this._viewport, Private$1.ScrollRequest);
    };
    /**
     * Get the row count for a particular region in the data grid.
     *
     * @param region - The row region of interest.
     *
     * @returns The row count for the specified region.
     */
    DataGrid.prototype.rowCount = function (region) {
        var count;
        if (region === 'body') {
            count = this._rowSections.count;
        }
        else {
            count = this._columnHeaderSections.count;
        }
        return count;
    };
    /**
     * Get the column count for a particular region in the data grid.
     *
     * @param region - The column region of interest.
     *
     * @returns The column count for the specified region.
     */
    DataGrid.prototype.columnCount = function (region) {
        var count;
        if (region === 'body') {
            count = this._columnSections.count;
        }
        else {
            count = this._rowHeaderSections.count;
        }
        return count;
    };
    /**
     * Get the row at a virtual offset in the data grid.
     *
     * @param region - The region which holds the row of interest.
     *
     * @param offset - The virtual offset of the row of interest.
     *
     * @returns The index of the row, or `-1` if the offset is out of range.
     *
     * #### Notes
     * This method accounts for a stretched last row.
     */
    DataGrid.prototype.rowAt = function (region, offset) {
        // Bail early if the offset is negative.
        if (offset < 0) {
            return -1;
        }
        // Return early for the column header region.
        if (region === 'column-header') {
            return this._columnHeaderSections.indexOf(offset);
        }
        // Fetch the index.
        var index = this._rowSections.indexOf(offset);
        // Return early if the section is found.
        if (index >= 0) {
            return index;
        }
        // Bail early if the last row is not stretched.
        if (!this._stretchLastRow) {
            return -1;
        }
        // Fetch the geometry.
        var bh = this.bodyHeight;
        var ph = this.pageHeight;
        // Bail early if no row stretching is required.
        if (ph <= bh) {
            return -1;
        }
        // Bail early if the offset is out of bounds.
        if (offset >= ph) {
            return -1;
        }
        // Otherwise, return the last row.
        return this._rowSections.count - 1;
    };
    /**
     * Get the column at a virtual offset in the data grid.
     *
     * @param region - The region which holds the column of interest.
     *
     * @param offset - The virtual offset of the column of interest.
     *
     * @returns The index of the column, or `-1` if the offset is out of range.
     *
     * #### Notes
     * This method accounts for a stretched last column.
     */
    DataGrid.prototype.columnAt = function (region, offset) {
        if (offset < 0) {
            return -1;
        }
        // Return early for the row header region.
        if (region === 'row-header') {
            return this._rowHeaderSections.indexOf(offset);
        }
        // Fetch the index.
        var index = this._columnSections.indexOf(offset);
        // Return early if the section is found.
        if (index >= 0) {
            return index;
        }
        // Bail early if the last column is not stretched.
        if (!this._stretchLastColumn) {
            return -1;
        }
        // Fetch the geometry.
        var bw = this.bodyWidth;
        var pw = this.pageWidth;
        // Bail early if no column stretching is required.
        if (pw <= bw) {
            return -1;
        }
        // Bail early if the offset is out of bounds.
        if (offset >= pw) {
            return -1;
        }
        // Otherwise, return the last column.
        return this._columnSections.count - 1;
    };
    /**
     * Get the offset of a row in the data grid.
     *
     * @param region - The region which holds the row of interest.
     *
     * @param index - The index of the row of interest.
     *
     * @returns The offset of the row, or `-1` if the index is out of range.
     *
     * #### Notes
     * A stretched last row has no effect on the return value.
     */
    DataGrid.prototype.rowOffset = function (region, index) {
        var offset;
        if (region === 'body') {
            offset = this._rowSections.offsetOf(index);
        }
        else {
            offset = this._columnHeaderSections.offsetOf(index);
        }
        return offset;
    };
    /**
     * Get the offset of a column in the data grid.
     *
     * @param region - The region which holds the column of interest.
     *
     * @param index - The index of the column of interest.
     *
     * @returns The offset of the column, or `-1` if the index is out of range.
     *
     * #### Notes
     * A stretched last column has no effect on the return value.
     */
    DataGrid.prototype.columnOffset = function (region, index) {
        var offset;
        if (region === 'body') {
            offset = this._columnSections.offsetOf(index);
        }
        else {
            offset = this._rowHeaderSections.offsetOf(index);
        }
        return offset;
    };
    /**
     * Get the size of a row in the data grid.
     *
     * @param region - The region which holds the row of interest.
     *
     * @param index - The index of the row of interest.
     *
     * @returns The size of the row, or `-1` if the index is out of range.
     *
     * #### Notes
     * This method accounts for a stretched last row.
     */
    DataGrid.prototype.rowSize = function (region, index) {
        // Return early for the column header region.
        if (region === 'column-header') {
            return this._columnHeaderSections.sizeOf(index);
        }
        // Fetch the row size.
        var size = this._rowSections.sizeOf(index);
        // Bail early if the index is out of bounds.
        if (size < 0) {
            return size;
        }
        // Return early if the last row is not stretched.
        if (!this._stretchLastRow) {
            return size;
        }
        // Return early if its not the last row.
        if (index < this._rowSections.count - 1) {
            return size;
        }
        // Fetch the geometry.
        var bh = this.bodyHeight;
        var ph = this.pageHeight;
        // Return early if no stretching is needed.
        if (ph <= bh) {
            return size;
        }
        // Return the adjusted size.
        return size + (ph - bh);
    };
    /**
     * Get the size of a column in the data grid.
     *
     * @param region - The region which holds the column of interest.
     *
     * @param index - The index of the column of interest.
     *
     * @returns The size of the column, or `-1` if the index is out of range.
     *
     * #### Notes
     * This method accounts for a stretched last column.
     */
    DataGrid.prototype.columnSize = function (region, index) {
        // Return early for the row header region.
        if (region === 'row-header') {
            return this._rowHeaderSections.sizeOf(index);
        }
        // Fetch the column size.
        var size = this._columnSections.sizeOf(index);
        // Bail early if the index is out of bounds.
        if (size < 0) {
            return size;
        }
        // Return early if the last column is not stretched.
        if (!this._stretchLastColumn) {
            return size;
        }
        // Return early if its not the last column.
        if (index < this._columnSections.count - 1) {
            return size;
        }
        // Fetch the geometry.
        var bw = this.bodyWidth;
        var pw = this.pageWidth;
        // Return early if no stretching is needed.
        if (pw <= bw) {
            return size;
        }
        // Return the adjusted size.
        return size + (pw - bw);
    };
    /**
     * Resize a row in the data grid.
     *
     * @param region - The region which holds the row of interest.
     *
     * @param index - The index of the row of interest.
     *
     * @param size - The desired size of the row.
     */
    DataGrid.prototype.resizeRow = function (region, index, size) {
        var msg = new Private$1.RowResizeRequest(region, index, size);
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.postMessage(this._viewport, msg);
    };
    /**
     * Resize a column in the data grid.
     *
     * @param region - The region which holds the column of interest.
     *
     * @param index - The index of the column of interest.
     *
     * @param size - The desired size of the column.
     */
    DataGrid.prototype.resizeColumn = function (region, index, size) {
        var msg = new Private$1.ColumnResizeRequest(region, index, size);
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.postMessage(this._viewport, msg);
    };
    /**
     * Reset modified rows to their default size.
     *
     * @param region - The row region of interest.
     */
    DataGrid.prototype.resetRows = function (region) {
        switch (region) {
            case 'all':
                this._rowSections.reset();
                this._columnHeaderSections.reset();
                break;
            case 'body':
                this._rowSections.reset();
                break;
            case 'column-header':
                this._columnHeaderSections.reset();
                break;
            default:
                throw 'unreachable';
        }
        this.repaintContent();
        this.repaintOverlay();
    };
    /**
     * Reset modified columns to their default size.
     *
     * @param region - The column region of interest.
     */
    DataGrid.prototype.resetColumns = function (region) {
        switch (region) {
            case 'all':
                this._columnSections.reset();
                this._rowHeaderSections.reset();
                break;
            case 'body':
                this._columnSections.reset();
                break;
            case 'row-header':
                this._rowHeaderSections.reset();
                break;
            default:
                throw 'unreachable';
        }
        this.repaintContent();
        this.repaintOverlay();
    };
    /**
     * Auto sizes column widths based on their text content.
     * @param area which area to resize: 'body', 'row-header' or 'all'.
     * @param padding padding added to resized columns (pixels).
     * @param numCols specify cap on the number of column resizes (optional).
     */
    DataGrid.prototype.fitColumnNames = function (area, padding, numCols) {
        if (area === void 0) { area = 'all'; }
        if (padding === void 0) { padding = 15; }
        // Attempt resizing only if a data model is present.
        if (this.dataModel) {
            // Tracking remaining columns to be resized if numCols arg passed.
            var colsRemaining = numCols === undefined || numCols < 0 ? undefined : numCols;
            if (area === 'row-header' || area === 'all') {
                // Respecting any column resize cap, if one has been passed.
                if (colsRemaining !== undefined) {
                    var rowColumnCount = this.dataModel.columnCount('row-header');
                    /*
                      If we have more row-header columns than columns available
                      for resize, resize only remaining columns as per allowance
                      and set remaining resize allowance number to 0.
                    */
                    if (colsRemaining - rowColumnCount < 0) {
                        this._fitRowColumnHeaders(this.dataModel, padding, colsRemaining);
                        colsRemaining = 0;
                    }
                    else {
                        /*
                          Otherwise the entire row-header column count can be resized.
                          Resize all row-header columns and subtract from remaining
                          column resize allowance.
                        */
                        this._fitRowColumnHeaders(this.dataModel, padding, rowColumnCount);
                        colsRemaining = colsRemaining - rowColumnCount;
                    }
                }
                else {
                    // No column resize cap passed - resizing all columns.
                    this._fitRowColumnHeaders(this.dataModel, padding);
                }
            }
            if (area === 'body' || area === 'all') {
                // Respecting any column resize cap, if one has been passed.
                if (colsRemaining !== undefined) {
                    var bodyColumnCount = this.dataModel.columnCount('body');
                    /*
                      If we have more body columns than columns available
                      for resize, resize only remaining columns as per allowance
                      and set remaining resize allowance number to 0.
                    */
                    if (colsRemaining - bodyColumnCount < 0) {
                        this._fitBodyColumnHeaders(this.dataModel, padding, colsRemaining);
                        colsRemaining = 0;
                    }
                    else {
                        /*
                          Otherwise the entire body column count can be resized.
                          Resize based on the smallest number between remaining
                          resize allowance and body column count.
                        */
                        this._fitBodyColumnHeaders(this.dataModel, padding, Math.min(colsRemaining, bodyColumnCount));
                    }
                }
                else {
                    // No column resize cap passed - resizing all columns.
                    this._fitBodyColumnHeaders(this.dataModel, padding);
                }
            }
        }
    };
    /**
     * Map a client position to local viewport coordinates.
     *
     * @param clientX - The client X position of the mouse.
     *
     * @param clientY - The client Y position of the mouse.
     *
     * @returns The local viewport coordinates for the position.
     */
    DataGrid.prototype.mapToLocal = function (clientX, clientY) {
        // Fetch the viewport rect.
        var rect = this._viewport.node.getBoundingClientRect();
        // Extract the rect coordinates.
        var left = rect.left, top = rect.top;
        // Round the rect coordinates for sub-pixel positioning.
        left = Math.floor(left);
        top = Math.floor(top);
        // Convert to local coordinates.
        var lx = clientX - left;
        var ly = clientY - top;
        // Return the local coordinates.
        return { lx: lx, ly: ly };
    };
    /**
     * Map a client position to virtual grid coordinates.
     *
     * @param clientX - The client X position of the mouse.
     *
     * @param clientY - The client Y position of the mouse.
     *
     * @returns The virtual grid coordinates for the position.
     */
    DataGrid.prototype.mapToVirtual = function (clientX, clientY) {
        // Convert to local coordiates.
        var _a = this.mapToLocal(clientX, clientY), lx = _a.lx, ly = _a.ly;
        // Convert to virtual coordinates.
        var vx = lx + this.scrollX - this.headerWidth;
        var vy = ly + this.scrollY - this.headerHeight;
        // Return the local coordinates.
        return { vx: vx, vy: vy };
    };
    /**
     * Hit test the viewport for the given client position.
     *
     * @param clientX - The client X position of the mouse.
     *
     * @param clientY - The client Y position of the mouse.
     *
     * @returns The hit test result, or `null` if the client
     *   position is out of bounds.
     *
     * #### Notes
     * This method accounts for a stretched last row and/or column.
     */
    DataGrid.prototype.hitTest = function (clientX, clientY) {
        // Convert the mouse position into local coordinates.
        var _a = this.mapToLocal(clientX, clientY), lx = _a.lx, ly = _a.ly;
        // Fetch the header and body dimensions.
        var hw = this.headerWidth;
        var hh = this.headerHeight;
        var bw = this.bodyWidth;
        var bh = this.bodyHeight;
        var ph = this.pageHeight;
        var pw = this.pageWidth;
        // Adjust the body width for a stretched last column.
        if (this._stretchLastColumn && pw > bw) {
            bw = pw;
        }
        // Adjust the body height for a stretched last row.
        if (this._stretchLastRow && ph > bh) {
            bh = ph;
        }
        // Check for a corner header hit.
        if (lx >= 0 && lx < hw && ly >= 0 && ly < hh) {
            // Convert to unscrolled virtual coordinates.
            var vx = lx;
            var vy = ly;
            // Fetch the row and column index.
            var row_1 = this.rowAt('column-header', vy);
            var column_1 = this.columnAt('row-header', vx);
            // Fetch the cell offset position.
            var ox = this.columnOffset('row-header', column_1);
            var oy = this.rowOffset('column-header', row_1);
            // Fetch cell width and height.
            var width_1 = this.columnSize('row-header', column_1);
            var height_1 = this.rowSize('column-header', row_1);
            // Compute the leading and trailing positions.
            var x_1 = vx - ox;
            var y_1 = vy - oy;
            // Return the hit test result.
            return { region: 'corner-header', row: row_1, column: column_1, x: x_1, y: y_1, width: width_1, height: height_1 };
        }
        // Check for a column header hit.
        if (ly >= 0 && ly < hh && lx >= 0 && lx < hw + bw) {
            // Convert to unscrolled virtual coordinates.
            var vx = lx + this._scrollX - hw;
            var vy = ly;
            // Fetch the row and column index.
            var row_2 = this.rowAt('column-header', vy);
            var column_2 = this.columnAt('body', vx);
            // Fetch the cell offset position.
            var ox = this.columnOffset('body', column_2);
            var oy = this.rowOffset('column-header', row_2);
            // Fetch the cell width and height.
            var width_2 = this.columnSize('body', column_2);
            var height_2 = this.rowSize('column-header', row_2);
            // Compute the leading and trailing positions.
            var x_2 = vx - ox;
            var y_2 = vy - oy;
            // Return the hit test result.
            return { region: 'column-header', row: row_2, column: column_2, x: x_2, y: y_2, width: width_2, height: height_2 };
        }
        // Check for a row header hit.
        if (lx >= 0 && lx < hw && ly >= 0 && ly < hh + bh) {
            // Convert to unscrolled virtual coordinates.
            var vx = lx;
            var vy = ly + this._scrollY - hh;
            // Fetch the row and column index.
            var row_3 = this.rowAt('body', vy);
            var column_3 = this.columnAt('row-header', vx);
            // Fetch the cell offset position.
            var ox = this.columnOffset('row-header', column_3);
            var oy = this.rowOffset('body', row_3);
            // Fetch the cell width and height.
            var width_3 = this.columnSize('row-header', column_3);
            var height_3 = this.rowSize('body', row_3);
            // Compute the leading and trailing positions.
            var x_3 = vx - ox;
            var y_3 = vy - oy;
            // Return the hit test result.
            return { region: 'row-header', row: row_3, column: column_3, x: x_3, y: y_3, width: width_3, height: height_3 };
        }
        // Check for a body hit.
        if (lx >= hw && lx < hw + bw && ly >= hh && ly < hh + bh) {
            // Convert to unscrolled virtual coordinates.
            var vx = lx + this._scrollX - hw;
            var vy = ly + this._scrollY - hh;
            // Fetch the row and column index.
            var row_4 = this.rowAt('body', vy);
            var column_4 = this.columnAt('body', vx);
            // Fetch the cell offset position.
            var ox = this.columnOffset('body', column_4);
            var oy = this.rowOffset('body', row_4);
            // Fetch the cell width and height.
            var width_4 = this.columnSize('body', column_4);
            var height_4 = this.rowSize('body', row_4);
            // Compute the part coordinates.
            var x_4 = vx - ox;
            var y_4 = vy - oy;
            // Return the result.
            return { region: 'body', row: row_4, column: column_4, x: x_4, y: y_4, width: width_4, height: height_4 };
        }
        // Otherwise, it's a void space hit.
        var row = -1;
        var column = -1;
        var x = -1;
        var y = -1;
        var width = -1;
        var height = -1;
        // Return the hit test result.
        return { region: 'void', row: row, column: column, x: x, y: y, width: width, height: height };
    };
    /**
     * Copy the current selection to the system clipboard.
     *
     * #### Notes
     * The grid must have a data model and a selection model.
     *
     * The behavior can be configured via `DataGrid.copyConfig`.
     */
    DataGrid.prototype.copyToClipboard = function () {
        var _a, _b;
        // Fetch the data model.
        var dataModel = this._dataModel;
        // Bail early if there is no data model.
        if (!dataModel) {
            return;
        }
        // Fetch the selection model.
        var selectionModel = this._selectionModel;
        // Bail early if there is no selection model.
        if (!selectionModel) {
            return;
        }
        // Coerce the selections to an array.
        var selections = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.toArray)(selectionModel.selections());
        // Bail early if there are no selections.
        if (selections.length === 0) {
            return;
        }
        // Alert that multiple selections cannot be copied.
        if (selections.length > 1) {
            alert('Cannot copy multiple grid selections.');
            return;
        }
        // Fetch the model counts.
        var br = dataModel.rowCount('body');
        var bc = dataModel.columnCount('body');
        // Bail early if there is nothing to copy.
        if (br === 0 || bc === 0) {
            return;
        }
        // Unpack the selection.
        var _c = selections[0], r1 = _c.r1, c1 = _c.c1, r2 = _c.r2, c2 = _c.c2;
        // Clamp the selection to the model bounds.
        r1 = Math.max(0, Math.min(r1, br - 1));
        c1 = Math.max(0, Math.min(c1, bc - 1));
        r2 = Math.max(0, Math.min(r2, br - 1));
        c2 = Math.max(0, Math.min(c2, bc - 1));
        // Ensure the limits are well-orderd.
        if (r2 < r1)
            _a = [r2, r1], r1 = _a[0], r2 = _a[1];
        if (c2 < c1)
            _b = [c2, c1], c1 = _b[0], c2 = _b[1];
        // Fetch the header counts.
        var rhc = dataModel.columnCount('row-header');
        var chr = dataModel.rowCount('column-header');
        // Unpack the copy config.
        var separator = this._copyConfig.separator;
        var format = this._copyConfig.format;
        var headers = this._copyConfig.headers;
        var warningThreshold = this._copyConfig.warningThreshold;
        // Compute the number of cells to be copied.
        var rowCount = r2 - r1 + 1;
        var colCount = c2 - c1 + 1;
        switch (headers) {
            case 'none':
                rhc = 0;
                chr = 0;
                break;
            case 'row':
                chr = 0;
                colCount += rhc;
                break;
            case 'column':
                rhc = 0;
                rowCount += chr;
                break;
            case 'all':
                rowCount += chr;
                colCount += rhc;
                break;
            default:
                throw 'unreachable';
        }
        // Compute the total cell count.
        var cellCount = rowCount * colCount;
        // Allow the user to cancel a large copy request.
        if (cellCount > warningThreshold) {
            var msg = "Copying " + cellCount + " cells may take a while. Continue?";
            if (!window.confirm(msg)) {
                return;
            }
        }
        // Set up the format args.
        var args = {
            region: 'body',
            row: 0,
            column: 0,
            value: null,
            metadata: {}
        };
        // Allocate the array of rows.
        var rows = new Array(rowCount);
        // Iterate over the rows.
        for (var j = 0; j < rowCount; ++j) {
            // Allocate the array of cells.
            var cells = new Array(colCount);
            // Iterate over the columns.
            for (var i = 0; i < colCount; ++i) {
                // Set up the format variables.
                var region = void 0;
                var row = void 0;
                var column = void 0;
                // Populate the format variables.
                if (j < chr && i < rhc) {
                    region = 'corner-header';
                    row = j;
                    column = i;
                }
                else if (j < chr) {
                    region = 'column-header';
                    row = j;
                    column = i - rhc + c1;
                }
                else if (i < rhc) {
                    region = 'row-header';
                    row = j - chr + r1;
                    column = i;
                }
                else {
                    region = 'body';
                    row = j - chr + r1;
                    column = i - rhc + c1;
                }
                // Populate the format args.
                args.region = region;
                args.row = row;
                args.column = column;
                args.value = dataModel.data(region, row, column);
                args.metadata = dataModel.metadata(region, row, column);
                // Format the cell.
                cells[i] = format(args);
            }
            // Save the row of cells.
            rows[j] = cells;
        }
        // Convert the cells into lines.
        var lines = rows.map(function (cells) { return cells.join(separator); });
        // Convert the lines into text.
        var text = lines.join('\n');
        // Copy the text to the clipboard.
        _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.ClipboardExt.copyText(text);
    };
    /**
     * Process a message sent to the widget.
     *
     * @param msg - The message sent to the widget.
     */
    DataGrid.prototype.processMessage = function (msg) {
        // Ignore child show/hide messages. The data grid controls the
        // visibility of its children, and will manually dispatch the
        // fit-request messages as a result of visibility change.
        if (msg.type === 'child-shown' || msg.type === 'child-hidden') {
            return;
        }
        // Recompute the scroll bar minimums before the layout refits.
        if (msg.type === 'fit-request') {
            var vsbLimits = _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.ElementExt.sizeLimits(this._vScrollBar.node);
            var hsbLimits = _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.ElementExt.sizeLimits(this._hScrollBar.node);
            this._vScrollBarMinWidth = vsbLimits.minWidth;
            this._hScrollBarMinHeight = hsbLimits.minHeight;
        }
        // Process all other messages as normal.
        _super.prototype.processMessage.call(this, msg);
    };
    /**
     * Intercept a message sent to a message handler.
     *
     * @param handler - The target handler of the message.
     *
     * @param msg - The message to be sent to the handler.
     *
     * @returns `true` if the message should continue to be processed
     *   as normal, or `false` if processing should cease immediately.
     */
    DataGrid.prototype.messageHook = function (handler, msg) {
        // Process viewport messages.
        if (handler === this._viewport) {
            this._processViewportMessage(msg);
            return true;
        }
        // Process horizontal scroll bar messages.
        if (handler === this._hScrollBar && msg.type === 'activate-request') {
            this.activate();
            return false;
        }
        // Process vertical scroll bar messages.
        if (handler === this._vScrollBar && msg.type === 'activate-request') {
            this.activate();
            return false;
        }
        // Ignore all other messages.
        return true;
    };
    /**
     * Handle the DOM events for the data grid.
     *
     * @param event - The DOM event sent to the data grid.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the data grid's DOM node. It
     * should not be called directly by user code.
     */
    DataGrid.prototype.handleEvent = function (event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeyDown(event);
                break;
            case 'mousedown':
                this._evtMouseDown(event);
                break;
            case 'mousemove':
                this._evtMouseMove(event);
                break;
            case 'mouseup':
                this._evtMouseUp(event);
                break;
            case 'dblclick':
                this._evtMouseDoubleClick(event);
                break;
            case 'mouseleave':
                this._evtMouseLeave(event);
                break;
            case 'contextmenu':
                this._evtContextMenu(event);
                break;
            case 'wheel':
                this._evtWheel(event);
                break;
            case 'resize':
                this._refreshDPI();
                break;
        }
    };
    /**
     * A message handler invoked on an `'activate-request'` message.
     */
    DataGrid.prototype.onActivateRequest = function (msg) {
        this.viewport.node.focus({ preventScroll: true });
    };
    /**
     * A message handler invoked on a `'before-attach'` message.
     */
    DataGrid.prototype.onBeforeAttach = function (msg) {
        window.addEventListener('resize', this);
        this.node.addEventListener('wheel', this);
        this._viewport.node.addEventListener('keydown', this);
        this._viewport.node.addEventListener('mousedown', this);
        this._viewport.node.addEventListener('mousemove', this);
        this._viewport.node.addEventListener('dblclick', this);
        this._viewport.node.addEventListener('mouseleave', this);
        this._viewport.node.addEventListener('contextmenu', this);
        this.repaintContent();
        this.repaintOverlay();
    };
    /**
     * A message handler invoked on an `'after-detach'` message.
     */
    DataGrid.prototype.onAfterDetach = function (msg) {
        window.removeEventListener('resize', this);
        this.node.removeEventListener('wheel', this);
        this._viewport.node.removeEventListener('keydown', this);
        this._viewport.node.removeEventListener('mousedown', this);
        this._viewport.node.removeEventListener('mousemove', this);
        this._viewport.node.removeEventListener('mouseleave', this);
        this._viewport.node.removeEventListener('dblclick', this);
        this._viewport.node.removeEventListener('contextmenu', this);
        this._releaseMouse();
    };
    /**
     * A message handler invoked on a `'before-show'` message.
     */
    DataGrid.prototype.onBeforeShow = function (msg) {
        this.repaintContent();
        this.repaintOverlay();
    };
    /**
     * A message handler invoked on a `'resize'` message.
     */
    DataGrid.prototype.onResize = function (msg) {
        if (this._editorController) {
            this._editorController.cancel();
        }
        this._syncScrollState();
    };
    /**
     * Schedule a repaint of all of the grid content.
     */
    DataGrid.prototype.repaintContent = function () {
        var msg = new Private$1.PaintRequest('all', 0, 0, 0, 0);
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.postMessage(this._viewport, msg);
    };
    /**
     * Schedule a repaint of specific grid content.
     */
    DataGrid.prototype.repaintRegion = function (region, r1, c1, r2, c2) {
        var msg = new Private$1.PaintRequest(region, r1, c1, r2, c2);
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.postMessage(this._viewport, msg);
    };
    /**
     * Schedule a repaint of the overlay.
     */
    DataGrid.prototype.repaintOverlay = function () {
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.postMessage(this._viewport, Private$1.OverlayPaintRequest);
    };
    /**
     * Ensure the canvas is at least the specified size.
     *
     * This method will retain the valid canvas content.
     */
    DataGrid.prototype._resizeCanvasIfNeeded = function (width, height) {
        // Scale the size by the dpi ratio.
        width = width * this._dpiRatio;
        height = height * this._dpiRatio;
        // Compute the maximum canvas size for the given width and height.
        var maxW = (Math.ceil((width + 1) / 512) + 1) * 512;
        var maxH = (Math.ceil((height + 1) / 512) + 1) * 512;
        // Get the current size of the canvas.
        var curW = this._canvas.width;
        var curH = this._canvas.height;
        // Bail early if the canvas size is within bounds.
        if (curW >= width && curH >= height && curW <= maxW && curH <= maxH) {
            return;
        }
        // Compute the expanded canvas size.
        var expW = maxW - 512;
        var expH = maxH - 512;
        // Set the transforms to the identity matrix.
        this._canvasGC.setTransform(1, 0, 0, 1, 0, 0);
        this._bufferGC.setTransform(1, 0, 0, 1, 0, 0);
        this._overlayGC.setTransform(1, 0, 0, 1, 0, 0);
        // Resize the buffer if needed.
        if (curW < width) {
            this._buffer.width = expW;
        }
        else if (curW > maxW) {
            this._buffer.width = maxW;
        }
        // Resize the buffer height if needed.
        if (curH < height) {
            this._buffer.height = expH;
        }
        else if (curH > maxH) {
            this._buffer.height = maxH;
        }
        // Test whether there is content to blit.
        var needBlit = curH > 0 && curH > 0 && width > 0 && height > 0;
        // Copy the valid canvas content into the buffer if needed.
        if (needBlit) {
            this._bufferGC.drawImage(this._canvas, 0, 0);
        }
        // Resize the canvas width if needed.
        if (curW < width) {
            this._canvas.width = expW;
            this._canvas.style.width = expW / this._dpiRatio + "px";
        }
        else if (curW > maxW) {
            this._canvas.width = maxW;
            this._canvas.style.width = maxW / this._dpiRatio + "px";
        }
        // Resize the canvas height if needed.
        if (curH < height) {
            this._canvas.height = expH;
            this._canvas.style.height = expH / this._dpiRatio + "px";
        }
        else if (curH > maxH) {
            this._canvas.height = maxH;
            this._canvas.style.height = maxH / this._dpiRatio + "px";
        }
        // Copy the valid canvas content from the buffer if needed.
        if (needBlit) {
            this._canvasGC.drawImage(this._buffer, 0, 0);
        }
        // Copy the valid overlay content into the buffer if needed.
        if (needBlit) {
            this._bufferGC.drawImage(this._overlay, 0, 0);
        }
        // Resize the overlay width if needed.
        if (curW < width) {
            this._overlay.width = expW;
            this._overlay.style.width = expW / this._dpiRatio + "px";
        }
        else if (curW > maxW) {
            this._overlay.width = maxW;
            this._overlay.style.width = maxW / this._dpiRatio + "px";
        }
        // Resize the overlay height if needed.
        if (curH < height) {
            this._overlay.height = expH;
            this._overlay.style.height = expH / this._dpiRatio + "px";
        }
        else if (curH > maxH) {
            this._overlay.height = maxH;
            this._overlay.style.height = maxH / this._dpiRatio + "px";
        }
        // Copy the valid overlay content from the buffer if needed.
        if (needBlit) {
            this._overlayGC.drawImage(this._buffer, 0, 0);
        }
    };
    /**
     * Sync the scroll bars and scroll state with the viewport.
     *
     * #### Notes
     * If the visibility of either scroll bar changes, a synchronous
     * fit-request will be dispatched to the data grid to immediately
     * resize the viewport.
     */
    DataGrid.prototype._syncScrollState = function () {
        // Fetch the viewport dimensions.
        var bw = this.bodyWidth;
        var bh = this.bodyHeight;
        var pw = this.pageWidth;
        var ph = this.pageHeight;
        // Get the current scroll bar visibility.
        var hasVScroll = !this._vScrollBar.isHidden;
        var hasHScroll = !this._hScrollBar.isHidden;
        // Get the minimum sizes of the scroll bars.
        var vsw = this._vScrollBarMinWidth;
        var hsh = this._hScrollBarMinHeight;
        // Get the page size as if no scroll bars are visible.
        var apw = pw + (hasVScroll ? vsw : 0);
        var aph = ph + (hasHScroll ? hsh : 0);
        // Test whether scroll bars are needed for the adjusted size.
        var needVScroll = aph < bh - 1;
        var needHScroll = apw < bw - 1;
        // Re-test the horizontal scroll if a vertical scroll is needed.
        if (needVScroll && !needHScroll) {
            needHScroll = apw - vsw < bw - 1;
        }
        // Re-test the vertical scroll if a horizontal scroll is needed.
        if (needHScroll && !needVScroll) {
            needVScroll = aph - hsh < bh - 1;
        }
        // If the visibility changes, immediately refit the grid.
        if (needVScroll !== hasVScroll || needHScroll !== hasHScroll) {
            this._vScrollBar.setHidden(!needVScroll);
            this._hScrollBar.setHidden(!needHScroll);
            this._scrollCorner.setHidden(!needVScroll || !needHScroll);
            _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.sendMessage(this, _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Widget.Msg.FitRequest);
        }
        // Update the scroll bar limits.
        this._vScrollBar.maximum = this.maxScrollY;
        this._vScrollBar.page = this.pageHeight;
        this._hScrollBar.maximum = this.maxScrollX;
        this._hScrollBar.page = this.pageWidth;
        // Re-clamp the scroll position.
        this._scrollTo(this._scrollX, this._scrollY);
    };
    /**
     * Sync the viewport to the given scroll position.
     *
     * #### Notes
     * This schedules a full repaint and syncs the scroll state.
     */
    DataGrid.prototype._syncViewport = function () {
        this.repaintContent();
        this.repaintOverlay();
        this._syncScrollState();
    };
    /**
     * Process a message sent to the viewport
     */
    DataGrid.prototype._processViewportMessage = function (msg) {
        switch (msg.type) {
            case 'resize':
                this._onViewportResize(msg);
                break;
            case 'scroll-request':
                this._onViewportScrollRequest(msg);
                break;
            case 'paint-request':
                this._onViewportPaintRequest(msg);
                break;
            case 'overlay-paint-request':
                this._onViewportOverlayPaintRequest(msg);
                break;
            case 'row-resize-request':
                this._onViewportRowResizeRequest(msg);
                break;
            case 'column-resize-request':
                this._onViewportColumnResizeRequest(msg);
                break;
        }
    };
    /**
     * A message hook invoked on a viewport `'resize'` message.
     */
    DataGrid.prototype._onViewportResize = function (msg) {
        // Bail early if the viewport is not visible.
        if (!this._viewport.isVisible) {
            return;
        }
        // Unpack the message data.
        var width = msg.width, height = msg.height;
        // Measure the viewport node if the dimensions are unknown.
        if (width === -1) {
            width = this._viewport.node.offsetWidth;
        }
        if (height === -1) {
            height = this._viewport.node.offsetHeight;
        }
        // Round the dimensions to the nearest pixel.
        width = Math.round(width);
        height = Math.round(height);
        // Get the current size of the viewport.
        var oldWidth = this._viewportWidth;
        var oldHeight = this._viewportHeight;
        // Updated internal viewport size.
        this._viewportWidth = width;
        this._viewportHeight = height;
        // Resize the canvas if needed.
        this._resizeCanvasIfNeeded(width, height);
        // Bail early if there is nothing to paint.
        if (width === 0 || height === 0) {
            return;
        }
        // Paint the whole grid if the old size was zero.
        if (oldWidth === 0 || oldHeight === 0) {
            this.paintContent(0, 0, width, height);
            this._paintOverlay();
            return;
        }
        // Paint the right edge as needed.
        if (this._stretchLastColumn && this.pageWidth > this.bodyWidth) {
            var bx = this._columnSections.offsetOf(this._columnSections.count - 1);
            var x = Math.min(this.headerWidth + bx, oldWidth);
            this.paintContent(x, 0, width - x, height);
        }
        else if (width > oldWidth) {
            this.paintContent(oldWidth, 0, width - oldWidth + 1, height);
        }
        // Paint the bottom edge as needed.
        if (this._stretchLastRow && this.pageHeight > this.bodyHeight) {
            var by = this._rowSections.offsetOf(this._rowSections.count - 1);
            var y = Math.min(this.headerHeight + by, oldHeight);
            this.paintContent(0, y, width, height - y);
        }
        else if (height > oldHeight) {
            this.paintContent(0, oldHeight, width, height - oldHeight + 1);
        }
        // Paint the overlay.
        this._paintOverlay();
    };
    /**
     * A message hook invoked on a viewport `'scroll-request'` message.
     */
    DataGrid.prototype._onViewportScrollRequest = function (msg) {
        this._scrollTo(this._hScrollBar.value, this._vScrollBar.value);
    };
    /**
     * A message hook invoked on a viewport `'paint-request'` message.
     */
    DataGrid.prototype._onViewportPaintRequest = function (msg) {
        // Bail early if the viewport is not visible.
        if (!this._viewport.isVisible) {
            return;
        }
        // Bail early if the viewport has zero area.
        if (this._viewportWidth === 0 || this._viewportHeight === 0) {
            return;
        }
        // Set up the paint limits.
        var xMin = 0;
        var yMin = 0;
        var xMax = this._viewportWidth - 1;
        var yMax = this._viewportHeight - 1;
        // Fetch the scroll position.
        var sx = this._scrollX;
        var sy = this._scrollY;
        // Fetch the header dimensions.
        var hw = this.headerWidth;
        var hh = this.headerHeight;
        // Fetch the section lists.
        var rs = this._rowSections;
        var cs = this._columnSections;
        var rhs = this._rowHeaderSections;
        var chs = this._columnHeaderSections;
        // Unpack the message data.
        var region = msg.region, r1 = msg.r1, c1 = msg.c1, r2 = msg.r2, c2 = msg.c2;
        // Set up the paint variables.
        var x1;
        var y1;
        var x2;
        var y2;
        // Fill the paint variables based on the paint region.
        switch (region) {
            case 'all':
                x1 = xMin;
                y1 = yMin;
                x2 = xMax;
                y2 = yMax;
                break;
            case 'body':
                r1 = Math.max(0, Math.min(r1, rs.count));
                c1 = Math.max(0, Math.min(c1, cs.count));
                r2 = Math.max(0, Math.min(r2, rs.count));
                c2 = Math.max(0, Math.min(c2, cs.count));
                x1 = cs.offsetOf(c1) - sx + hw;
                y1 = rs.offsetOf(r1) - sy + hh;
                x2 = cs.extentOf(c2) - sx + hw;
                y2 = rs.extentOf(r2) - sy + hh;
                break;
            case 'row-header':
                r1 = Math.max(0, Math.min(r1, rs.count));
                c1 = Math.max(0, Math.min(c1, rhs.count));
                r2 = Math.max(0, Math.min(r2, rs.count));
                c2 = Math.max(0, Math.min(c2, rhs.count));
                x1 = rhs.offsetOf(c1);
                y1 = rs.offsetOf(r1) - sy + hh;
                x2 = rhs.extentOf(c2);
                y2 = rs.extentOf(r2) - sy + hh;
                break;
            case 'column-header':
                r1 = Math.max(0, Math.min(r1, chs.count));
                c1 = Math.max(0, Math.min(c1, cs.count));
                r2 = Math.max(0, Math.min(r2, chs.count));
                c2 = Math.max(0, Math.min(c2, cs.count));
                x1 = cs.offsetOf(c1) - sx + hw;
                y1 = chs.offsetOf(r1);
                x2 = cs.extentOf(c2) - sx + hw;
                y2 = chs.extentOf(r2);
                break;
            case 'corner-header':
                r1 = Math.max(0, Math.min(r1, chs.count));
                c1 = Math.max(0, Math.min(c1, rhs.count));
                r2 = Math.max(0, Math.min(r2, chs.count));
                c2 = Math.max(0, Math.min(c2, rhs.count));
                x1 = rhs.offsetOf(c1);
                y1 = chs.offsetOf(r1);
                x2 = rhs.extentOf(c2);
                y2 = chs.extentOf(r2);
                break;
            default:
                throw 'unreachable';
        }
        // Bail early if the dirty rect is outside the bounds.
        if (x2 < xMin || y2 < yMin || x1 > xMax || y1 > yMax) {
            return;
        }
        // Clamp the dirty rect to the paint bounds.
        x1 = Math.max(xMin, Math.min(x1, xMax));
        y1 = Math.max(yMin, Math.min(y1, yMax));
        x2 = Math.max(xMin, Math.min(x2, xMax));
        y2 = Math.max(yMin, Math.min(y2, yMax));
        // Paint the content of the dirty rect.
        this.paintContent(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    };
    /**
     * A message hook invoked on a viewport `'overlay-paint-request'` message.
     */
    DataGrid.prototype._onViewportOverlayPaintRequest = function (msg) {
        // Bail early if the viewport is not visible.
        if (!this._viewport.isVisible) {
            return;
        }
        // Bail early if the viewport has zero area.
        if (this._viewportWidth === 0 || this._viewportHeight === 0) {
            return;
        }
        // Paint the content of the overlay.
        this._paintOverlay();
    };
    /**
     * A message hook invoked on a viewport `'row-resize-request'` message.
     */
    DataGrid.prototype._onViewportRowResizeRequest = function (msg) {
        if (msg.region === 'body') {
            this._resizeRow(msg.index, msg.size);
        }
        else {
            this._resizeColumnHeader(msg.index, msg.size);
        }
    };
    /**
     * A message hook invoked on a viewport `'column-resize-request'` message.
     */
    DataGrid.prototype._onViewportColumnResizeRequest = function (msg) {
        if (msg.region === 'body') {
            this._resizeColumn(msg.index, msg.size);
        }
        else {
            this._resizeRowHeader(msg.index, msg.size);
        }
    };
    /**
     * Handle the `thumbMoved` signal from a scroll bar.
     */
    DataGrid.prototype._onThumbMoved = function (sender) {
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.MessageLoop.postMessage(this._viewport, Private$1.ScrollRequest);
    };
    /**
     * Handle the `pageRequested` signal from a scroll bar.
     */
    DataGrid.prototype._onPageRequested = function (sender, dir) {
        if (sender === this._vScrollBar) {
            this.scrollByPage(dir === 'decrement' ? 'up' : 'down');
        }
        else {
            this.scrollByPage(dir === 'decrement' ? 'left' : 'right');
        }
    };
    /**
     * Handle the `stepRequested` signal from a scroll bar.
     */
    DataGrid.prototype._onStepRequested = function (sender, dir) {
        if (sender === this._vScrollBar) {
            this.scrollByStep(dir === 'decrement' ? 'up' : 'down');
        }
        else {
            this.scrollByStep(dir === 'decrement' ? 'left' : 'right');
        }
    };
    /**
     * A signal handler for the data model `changed` signal.
     */
    DataGrid.prototype._onDataModelChanged = function (sender, args) {
        switch (args.type) {
            case 'rows-inserted':
                this._onRowsInserted(args);
                break;
            case 'columns-inserted':
                this._onColumnsInserted(args);
                break;
            case 'rows-removed':
                this._onRowsRemoved(args);
                break;
            case 'columns-removed':
                this._onColumnsRemoved(args);
                break;
            case 'rows-moved':
                this._onRowsMoved(args);
                break;
            case 'columns-moved':
                this._onColumnsMoved(args);
                break;
            case 'cells-changed':
                this._onCellsChanged(args);
                break;
            case 'model-reset':
                this._onModelReset(args);
                break;
            default:
                throw 'unreachable';
        }
    };
    /**
     * A signal handler for the selection model `changed` signal.
     */
    DataGrid.prototype._onSelectionsChanged = function (sender) {
        this.repaintOverlay();
    };
    /**
     * Handle rows being inserted in the data model.
     */
    DataGrid.prototype._onRowsInserted = function (args) {
        // Unpack the arg data.
        var region = args.region, index = args.index, span = args.span;
        // Bail early if there are no sections to insert.
        if (span <= 0) {
            return;
        }
        // Look up the relevant section list.
        var list;
        if (region === 'body') {
            list = this._rowSections;
        }
        else {
            list = this._columnHeaderSections;
        }
        // Insert the span, maintaining the scroll position as needed.
        if (this._scrollY === this.maxScrollY && this.maxScrollY > 0) {
            list.insert(index, span);
            this._scrollY = this.maxScrollY;
        }
        else {
            list.insert(index, span);
        }
        // Sync the viewport.
        this._syncViewport();
    };
    /**
     * Handle columns being inserted into the data model.
     */
    DataGrid.prototype._onColumnsInserted = function (args) {
        // Unpack the arg data.
        var region = args.region, index = args.index, span = args.span;
        // Bail early if there are no sections to insert.
        if (span <= 0) {
            return;
        }
        // Look up the relevant section list.
        var list;
        if (region === 'body') {
            list = this._columnSections;
        }
        else {
            list = this._rowHeaderSections;
        }
        // Insert the span, maintaining the scroll position as needed.
        if (this._scrollX === this.maxScrollX && this.maxScrollX > 0) {
            list.insert(index, span);
            this._scrollX = this.maxScrollX;
        }
        else {
            list.insert(index, span);
        }
        // Sync the viewport.
        this._syncViewport();
    };
    /**
     * Handle rows being removed from the data model.
     */
    DataGrid.prototype._onRowsRemoved = function (args) {
        // Unpack the arg data.
        var region = args.region, index = args.index, span = args.span;
        // Bail early if there are no sections to remove.
        if (span <= 0) {
            return;
        }
        // Look up the relevant section list.
        var list;
        if (region === 'body') {
            list = this._rowSections;
        }
        else {
            list = this._columnHeaderSections;
        }
        // Bail if the index or is invalid
        if (index < 0 || index >= list.count) {
            return;
        }
        // Remove the span, maintaining the scroll position as needed.
        if (this._scrollY === this.maxScrollY && this.maxScrollY > 0) {
            list.remove(index, span);
            this._scrollY = this.maxScrollY;
        }
        else {
            list.remove(index, span);
        }
        // Sync the viewport.
        this._syncViewport();
    };
    /**
     * Handle columns being removed from the data model.
     */
    DataGrid.prototype._onColumnsRemoved = function (args) {
        // Unpack the arg data.
        var region = args.region, index = args.index, span = args.span;
        // Bail early if there are no sections to remove.
        if (span <= 0) {
            return;
        }
        // Look up the relevant section list.
        var list;
        if (region === 'body') {
            list = this._columnSections;
        }
        else {
            list = this._rowHeaderSections;
        }
        // Bail if the index or is invalid
        if (index < 0 || index >= list.count) {
            return;
        }
        // Remove the span, maintaining the scroll position as needed.
        if (this._scrollX === this.maxScrollX && this.maxScrollX > 0) {
            list.remove(index, span);
            this._scrollX = this.maxScrollX;
        }
        else {
            list.remove(index, span);
        }
        // Sync the viewport.
        this._syncViewport();
    };
    /**
     * Handle rows moving in the data model.
     */
    DataGrid.prototype._onRowsMoved = function (args) {
        // Unpack the arg data.
        var region = args.region, index = args.index, span = args.span, destination = args.destination;
        // Bail early if there are no sections to move.
        if (span <= 0) {
            return;
        }
        // Look up the relevant section list.
        var list;
        if (region === 'body') {
            list = this._rowSections;
        }
        else {
            list = this._columnHeaderSections;
        }
        // Bail early if the index is out of range.
        if (index < 0 || index >= list.count) {
            return;
        }
        // Clamp the move span to the limit.
        span = Math.min(span, list.count - index);
        // Clamp the destination index to the limit.
        destination = Math.min(Math.max(0, destination), list.count - span);
        // Bail early if there is no effective move.
        if (index === destination) {
            return;
        }
        // Compute the first affected index.
        var r1 = Math.min(index, destination);
        // Compute the last affected index.
        var r2 = Math.max(index + span - 1, destination + span - 1);
        // Move the sections in the list.
        list.move(index, span, destination);
        // Schedule a repaint of the dirty cells.
        if (region === 'body') {
            this.repaintRegion('body', r1, 0, r2, Infinity);
            this.repaintRegion('row-header', r1, 0, r2, Infinity);
        }
        else {
            this.repaintRegion('column-header', r1, 0, r2, Infinity);
            this.repaintRegion('corner-header', r1, 0, r2, Infinity);
        }
        // Sync the viewport.
        this._syncViewport();
    };
    /**
     * Handle columns moving in the data model.
     */
    DataGrid.prototype._onColumnsMoved = function (args) {
        // Unpack the arg data.
        var region = args.region, index = args.index, span = args.span, destination = args.destination;
        // Bail early if there are no sections to move.
        if (span <= 0) {
            return;
        }
        // Look up the relevant section list.
        var list;
        if (region === 'body') {
            list = this._columnSections;
        }
        else {
            list = this._rowHeaderSections;
        }
        // Bail early if the index is out of range.
        if (index < 0 || index >= list.count) {
            return;
        }
        // Clamp the move span to the limit.
        span = Math.min(span, list.count - index);
        // Clamp the destination index to the limit.
        destination = Math.min(Math.max(0, destination), list.count - span);
        // Bail early if there is no effective move.
        if (index === destination) {
            return;
        }
        // Move the sections in the list.
        list.move(index, span, destination);
        // Compute the first affected index.
        var c1 = Math.min(index, destination);
        // Compute the last affected index.
        var c2 = Math.max(index + span - 1, destination + span - 1);
        // Schedule a repaint of the dirty cells.
        if (region === 'body') {
            this.repaintRegion('body', 0, c1, Infinity, c2);
            this.repaintRegion('column-header', 0, c1, Infinity, c2);
        }
        else {
            this.repaintRegion('row-header', 0, c1, Infinity, c2);
            this.repaintRegion('corner-header', 0, c1, Infinity, c2);
        }
        // Sync the viewport.
        this._syncViewport();
    };
    /**
     * Handle cells changing in the data model.
     */
    DataGrid.prototype._onCellsChanged = function (args) {
        // Unpack the arg data.
        var region = args.region, row = args.row, column = args.column, rowSpan = args.rowSpan, columnSpan = args.columnSpan;
        // Bail early if there are no cells to modify.
        if (rowSpan <= 0 && columnSpan <= 0) {
            return;
        }
        // Compute the changed cell bounds.
        var r1 = row;
        var c1 = column;
        var r2 = r1 + rowSpan - 1;
        var c2 = c1 + columnSpan - 1;
        // Schedule a repaint of the cell content.
        this.repaintRegion(region, r1, c1, r2, c2);
    };
    /**
     * Handle a full data model reset.
     */
    DataGrid.prototype._onModelReset = function (args) {
        // Look up the various current section counts.
        var nr = this._rowSections.count;
        var nc = this._columnSections.count;
        var nrh = this._rowHeaderSections.count;
        var nch = this._columnHeaderSections.count;
        // Compute the delta count for each region.
        var dr = this._dataModel.rowCount('body') - nr;
        var dc = this._dataModel.columnCount('body') - nc;
        var drh = this._dataModel.columnCount('row-header') - nrh;
        var dch = this._dataModel.rowCount('column-header') - nch;
        // Update the row sections, if needed.
        if (dr > 0) {
            this._rowSections.insert(nr, dr);
        }
        else if (dr < 0) {
            this._rowSections.remove(nr + dr, -dr);
        }
        // Update the column sections, if needed.
        if (dc > 0) {
            this._columnSections.insert(nc, dc);
        }
        else if (dc < 0) {
            this._columnSections.remove(nc + dc, -dc);
        }
        // Update the row header sections, if needed.
        if (drh > 0) {
            this._rowHeaderSections.insert(nrh, drh);
        }
        else if (drh < 0) {
            this._rowHeaderSections.remove(nrh + drh, -drh);
        }
        // Update the column header sections, if needed.
        if (dch > 0) {
            this._columnHeaderSections.insert(nch, dch);
        }
        else if (dch < 0) {
            this._columnHeaderSections.remove(nch + dch, -dch);
        }
        // Sync the viewport.
        this._syncViewport();
    };
    /**
     * A signal handler for the renderer map `changed` signal.
     */
    DataGrid.prototype._onRenderersChanged = function () {
        this.repaintContent();
    };
    /**
     * Handle the `'keydown'` event for the data grid.
     */
    DataGrid.prototype._evtKeyDown = function (event) {
        if (this._mousedown) {
            event.preventDefault();
            event.stopPropagation();
        }
        else if (this._keyHandler) {
            this._keyHandler.onKeyDown(this, event);
        }
    };
    /**
     * Handle the `'mousedown'` event for the data grid.
     */
    DataGrid.prototype._evtMouseDown = function (event) {
        // Ignore everything except the left mouse button.
        if (event.button !== 0) {
            return;
        }
        // Activate the grid.
        this.activate();
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Add the extra document listeners.
        document.addEventListener('keydown', this, true);
        document.addEventListener('mouseup', this, true);
        document.addEventListener('mousedown', this, true);
        document.addEventListener('mousemove', this, true);
        document.addEventListener('contextmenu', this, true);
        // Flip the mousedown flag.
        this._mousedown = true;
        // Dispatch to the mouse handler.
        if (this._mouseHandler) {
            this._mouseHandler.onMouseDown(this, event);
        }
    };
    /**
     * Handle the `'mousemove'` event for the data grid.
     */
    DataGrid.prototype._evtMouseMove = function (event) {
        // Stop the event propagation if the mouse is down.
        if (this._mousedown) {
            event.preventDefault();
            event.stopPropagation();
        }
        // Bail if there is no mouse handler.
        if (!this._mouseHandler) {
            return;
        }
        // Dispatch to the mouse handler.
        if (this._mousedown) {
            this._mouseHandler.onMouseMove(this, event);
        }
        else {
            this._mouseHandler.onMouseHover(this, event);
        }
    };
    /**
     * Handle the `'mouseup'` event for the data grid.
     */
    DataGrid.prototype._evtMouseUp = function (event) {
        // Ignore everything except the left mouse button.
        if (event.button !== 0) {
            return;
        }
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Dispatch to the mouse handler.
        if (this._mouseHandler) {
            this._mouseHandler.onMouseUp(this, event);
        }
        // Release the mouse.
        this._releaseMouse();
    };
    /**
     * Handle the `'dblclick'` event for the data grid.
     */
    DataGrid.prototype._evtMouseDoubleClick = function (event) {
        // Ignore everything except the left mouse button.
        if (event.button !== 0) {
            return;
        }
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Dispatch to the mouse handler.
        if (this._mouseHandler) {
            this._mouseHandler.onMouseDoubleClick(this, event);
        }
        // Release the mouse.
        this._releaseMouse();
    };
    /**
     * Handle the `'mouseleave'` event for the data grid.
     */
    DataGrid.prototype._evtMouseLeave = function (event) {
        if (this._mousedown) {
            event.preventDefault();
            event.stopPropagation();
        }
        else if (this._mouseHandler) {
            this._mouseHandler.onMouseLeave(this, event);
        }
    };
    /**
     * Handle the `'contextmenu'` event for the data grid.
     */
    DataGrid.prototype._evtContextMenu = function (event) {
        if (this._mousedown) {
            event.preventDefault();
            event.stopPropagation();
        }
        else if (this._mouseHandler) {
            this._mouseHandler.onContextMenu(this, event);
        }
    };
    /**
     * Handle the `'wheel'` event for the data grid.
     */
    DataGrid.prototype._evtWheel = function (event) {
        // Ignore the event if `accel` is held.
        if (_lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.Platform.accelKey(event)) {
            return;
        }
        // Bail early if there is no mouse handler.
        if (!this._mouseHandler) {
            return;
        }
        // Stop the event propagation.
        event.preventDefault();
        event.stopPropagation();
        // Dispatch to the mouse handler.
        this._mouseHandler.onWheel(this, event);
    };
    /**
     * Release the mouse grab.
     */
    DataGrid.prototype._releaseMouse = function () {
        // Clear the mousedown flag.
        this._mousedown = false;
        // Relase the mouse handler.
        if (this._mouseHandler) {
            this._mouseHandler.release();
        }
        // Remove the document listeners.
        document.removeEventListener('keydown', this, true);
        document.removeEventListener('mouseup', this, true);
        document.removeEventListener('mousedown', this, true);
        document.removeEventListener('mousemove', this, true);
        document.removeEventListener('contextmenu', this, true);
    };
    /**
     * Refresh the dpi ratio.
     */
    DataGrid.prototype._refreshDPI = function () {
        // Get the best integral value for the dpi ratio.
        var dpiRatio = Math.ceil(window.devicePixelRatio);
        // Bail early if the computed dpi ratio has not changed.
        if (this._dpiRatio === dpiRatio) {
            return;
        }
        // Update the internal dpi ratio.
        this._dpiRatio = dpiRatio;
        // Schedule a repaint of the content.
        this.repaintContent();
        // Schedule a repaint of the overlay.
        this.repaintOverlay();
        // Update the canvas size for the new dpi ratio.
        this._resizeCanvasIfNeeded(this._viewportWidth, this._viewportHeight);
        // Ensure the canvas style is scaled for the new ratio.
        this._canvas.style.width = this._canvas.width / this._dpiRatio + "px";
        this._canvas.style.height = this._canvas.height / this._dpiRatio + "px";
        // Ensure the overlay style is scaled for the new ratio.
        this._overlay.style.width = this._overlay.width / this._dpiRatio + "px";
        this._overlay.style.height = this._overlay.height / this._dpiRatio + "px";
    };
    /**
     * Resize a row section immediately.
     */
    DataGrid.prototype._resizeRow = function (index, size) {
        // Look up the target section list.
        var list = this._rowSections;
        // Bail early if the index is out of range.
        if (index < 0 || index >= list.count) {
            return;
        }
        // Look up the old size of the section.
        var oldSize = list.sizeOf(index);
        // Normalize the new size of the section.
        var newSize = list.clampSize(size);
        // Bail early if the size does not change.
        if (oldSize === newSize) {
            return;
        }
        // Resize the section in the list.
        list.resize(index, newSize);
        // Get the current size of the viewport.
        var vw = this._viewportWidth;
        var vh = this._viewportHeight;
        // If there is nothing to paint, sync the scroll state.
        if (!this._viewport.isVisible || vw === 0 || vh === 0) {
            this._syncScrollState();
            return;
        }
        // Render entire grid if scrolling merged cells grid
        var paintEverything = Private$1.shouldPaintEverything(this._dataModel);
        if (paintEverything) {
            this.paintContent(0, 0, vw, vh);
            this._paintOverlay();
            this._syncScrollState();
            return;
        }
        // Compute the size delta.
        var delta = newSize - oldSize;
        // Look up the column header height.
        var hh = this.headerHeight;
        // Compute the viewport offset of the section.
        var offset = list.offsetOf(index) + hh - this._scrollY;
        // Bail early if there is nothing to paint.
        if (hh >= vh || offset >= vh) {
            this._syncScrollState();
            return;
        }
        // Update the scroll position if the section is not visible.
        if (offset + oldSize <= hh) {
            this._scrollY += delta;
            this._syncScrollState();
            return;
        }
        // Compute the paint origin of the section.
        var pos = Math.max(hh, offset);
        // Paint from the section onward if it spans the viewport.
        if (offset + oldSize >= vh || offset + newSize >= vh) {
            this.paintContent(0, pos, vw, vh - pos);
            this._paintOverlay();
            this._syncScrollState();
            return;
        }
        // Compute the X blit dimensions.
        var sx = 0;
        var sw = vw;
        var dx = 0;
        // Compute the Y blit dimensions.
        var sy;
        var sh;
        var dy;
        if (offset + newSize <= hh) {
            sy = hh - delta;
            sh = vh - sy;
            dy = hh;
        }
        else {
            sy = offset + oldSize;
            sh = vh - sy;
            dy = sy + delta;
        }
        // Blit the valid content to the destination.
        this._blitContent(this._canvas, sx, sy, sw, sh, dx, dy);
        // Repaint the section if needed.
        if (newSize > 0 && offset + newSize > hh) {
            this.paintContent(0, pos, vw, offset + newSize - pos);
        }
        // Paint the trailing space as needed.
        if (this._stretchLastRow && this.pageHeight > this.bodyHeight) {
            var r = this._rowSections.count - 1;
            var y = hh + this._rowSections.offsetOf(r);
            this.paintContent(0, y, vw, vh - y);
        }
        else if (delta < 0) {
            this.paintContent(0, vh + delta, vw, -delta);
        }
        // Paint the overlay.
        this._paintOverlay();
        // Sync the scroll state.
        this._syncScrollState();
    };
    /**
     * Resize a column section immediately.
     */
    DataGrid.prototype._resizeColumn = function (index, size) {
        // Look up the target section list.
        var list = this._columnSections;
        // Bail early if the index is out of range.
        if (index < 0 || index >= list.count) {
            return;
        }
        // Look up the old size of the section.
        var oldSize = list.sizeOf(index);
        // Normalize the new size of the section.
        var newSize = list.clampSize(size);
        // Bail early if the size does not change.
        if (oldSize === newSize) {
            return;
        }
        // Resize the section in the list.
        list.resize(index, newSize);
        // Get the current size of the viewport.
        var vw = this._viewportWidth;
        var vh = this._viewportHeight;
        // If there is nothing to paint, sync the scroll state.
        if (!this._viewport.isVisible || vw === 0 || vh === 0) {
            this._syncScrollState();
            return;
        }
        // Render entire grid if scrolling merged cells grid
        var paintEverything = Private$1.shouldPaintEverything(this._dataModel);
        if (paintEverything) {
            this.paintContent(0, 0, vw, vh);
            this._paintOverlay();
            this._syncScrollState();
            return;
        }
        // Compute the size delta.
        var delta = newSize - oldSize;
        // Look up the row header width.
        var hw = this.headerWidth;
        // Compute the viewport offset of the section.
        var offset = list.offsetOf(index) + hw - this._scrollX;
        // Bail early if there is nothing to paint.
        if (hw >= vw || offset >= vw) {
            this._syncScrollState();
            return;
        }
        // Update the scroll position if the section is not visible.
        if (offset + oldSize <= hw) {
            this._scrollX += delta;
            this._syncScrollState();
            return;
        }
        // Compute the paint origin of the section.
        var pos = Math.max(hw, offset);
        // Paint from the section onward if it spans the viewport.
        if (offset + oldSize >= vw || offset + newSize >= vw) {
            this.paintContent(pos, 0, vw - pos, vh);
            this._paintOverlay();
            this._syncScrollState();
            return;
        }
        // Compute the Y blit dimensions.
        var sy = 0;
        var sh = vh;
        var dy = 0;
        // Compute the X blit dimensions.
        var sx;
        var sw;
        var dx;
        if (offset + newSize <= hw) {
            sx = hw - delta;
            sw = vw - sx;
            dx = hw;
        }
        else {
            sx = offset + oldSize;
            sw = vw - sx;
            dx = sx + delta;
        }
        // Blit the valid content to the destination.
        this._blitContent(this._canvas, sx, sy, sw, sh, dx, dy);
        // Repaint the section if needed.
        if (newSize > 0 && offset + newSize > hw) {
            this.paintContent(pos, 0, offset + newSize - pos, vh);
        }
        // Paint the trailing space as needed.
        if (this._stretchLastColumn && this.pageWidth > this.bodyWidth) {
            var c = this._columnSections.count - 1;
            var x = hw + this._columnSections.offsetOf(c);
            this.paintContent(x, 0, vw - x, vh);
        }
        else if (delta < 0) {
            this.paintContent(vw + delta, 0, -delta, vh);
        }
        // Paint the overlay.
        this._paintOverlay();
        // Sync the scroll state after painting.
        this._syncScrollState();
    };
    /**
     * Resize a row header section immediately.
     */
    DataGrid.prototype._resizeRowHeader = function (index, size) {
        // Look up the target section list.
        var list = this._rowHeaderSections;
        // Bail early if the index is out of range.
        if (index < 0 || index >= list.count) {
            return;
        }
        // Look up the old size of the section.
        var oldSize = list.sizeOf(index);
        // Normalize the new size of the section.
        var newSize = list.clampSize(size);
        // Bail early if the size does not change.
        if (oldSize === newSize) {
            return;
        }
        // Resize the section in the list.
        list.resize(index, newSize);
        // Get the current size of the viewport.
        var vw = this._viewportWidth;
        var vh = this._viewportHeight;
        // If there is nothing to paint, sync the scroll state.
        if (!this._viewport.isVisible || vw === 0 || vh === 0) {
            this._syncScrollState();
            return;
        }
        // Render entire grid if scrolling merged cells grid
        var paintEverything = Private$1.shouldPaintEverything(this._dataModel);
        if (paintEverything) {
            this.paintContent(0, 0, vw, vh);
            this._paintOverlay();
            this._syncScrollState();
            return;
        }
        // Compute the size delta.
        var delta = newSize - oldSize;
        // Look up the offset of the section.
        var offset = list.offsetOf(index);
        // Bail early if the section is fully outside the viewport.
        if (offset >= vw) {
            this._syncScrollState();
            return;
        }
        // Paint the entire tail if the section spans the viewport.
        if (offset + oldSize >= vw || offset + newSize >= vw) {
            this.paintContent(offset, 0, vw - offset, vh);
            this._paintOverlay();
            this._syncScrollState();
            return;
        }
        // Compute the blit content dimensions.
        var sx = offset + oldSize;
        var sy = 0;
        var sw = vw - sx;
        var sh = vh;
        var dx = sx + delta;
        var dy = 0;
        // Blit the valid content to the destination.
        this._blitContent(this._canvas, sx, sy, sw, sh, dx, dy);
        // Repaint the header section if needed.
        if (newSize > 0) {
            this.paintContent(offset, 0, newSize, vh);
        }
        // Paint the trailing space as needed.
        if (this._stretchLastColumn && this.pageWidth > this.bodyWidth) {
            var c = this._columnSections.count - 1;
            var x = this.headerWidth + this._columnSections.offsetOf(c);
            this.paintContent(x, 0, vw - x, vh);
        }
        else if (delta < 0) {
            this.paintContent(vw + delta, 0, -delta + 1, vh);
        }
        // Paint the overlay.
        this._paintOverlay();
        // Sync the scroll state after painting.
        this._syncScrollState();
    };
    /**
     * Resize a column header section immediately.
     */
    DataGrid.prototype._resizeColumnHeader = function (index, size) {
        // Look up the target section list.
        var list = this._columnHeaderSections;
        // Bail early if the index is out of range.
        if (index < 0 || index >= list.count) {
            return;
        }
        // Look up the old size of the section.
        var oldSize = list.sizeOf(index);
        // Normalize the new size of the section.
        var newSize = list.clampSize(size);
        // Bail early if the size does not change.
        if (oldSize === newSize) {
            return;
        }
        // Resize the section in the list.
        list.resize(index, newSize);
        // Get the current size of the viewport.
        var vw = this._viewportWidth;
        var vh = this._viewportHeight;
        // If there is nothing to paint, sync the scroll state.
        if (!this._viewport.isVisible || vw === 0 || vh === 0) {
            this._syncScrollState();
            return;
        }
        // Render entire grid if scrolling merged cells grid
        var paintEverything = Private$1.shouldPaintEverything(this._dataModel);
        if (paintEverything) {
            this.paintContent(0, 0, vw, vh);
            this._paintOverlay();
            this._syncScrollState();
            return;
        }
        // Paint the overlay.
        this._paintOverlay();
        // Compute the size delta.
        var delta = newSize - oldSize;
        // Look up the offset of the section.
        var offset = list.offsetOf(index);
        // Bail early if the section is fully outside the viewport.
        if (offset >= vh) {
            this._syncScrollState();
            return;
        }
        // Paint the entire tail if the section spans the viewport.
        if (offset + oldSize >= vh || offset + newSize >= vh) {
            this.paintContent(0, offset, vw, vh - offset);
            this._paintOverlay();
            this._syncScrollState();
            return;
        }
        // Compute the blit content dimensions.
        var sx = 0;
        var sy = offset + oldSize;
        var sw = vw;
        var sh = vh - sy;
        var dx = 0;
        var dy = sy + delta;
        // Blit the valid contents to the destination.
        this._blitContent(this._canvas, sx, sy, sw, sh, dx, dy);
        // Repaint the header section if needed.
        if (newSize > 0) {
            this.paintContent(0, offset, vw, newSize);
        }
        // Paint the trailing space as needed.
        if (this._stretchLastRow && this.pageHeight > this.bodyHeight) {
            var r = this._rowSections.count - 1;
            var y = this.headerHeight + this._rowSections.offsetOf(r);
            this.paintContent(0, y, vw, vh - y);
        }
        else if (delta < 0) {
            this.paintContent(0, vh + delta, vw, -delta + 1);
        }
        // Paint the overlay.
        this._paintOverlay();
        // Sync the scroll state after painting.
        this._syncScrollState();
    };
    /**
     * Scroll immediately to the specified offset position.
     */
    DataGrid.prototype._scrollTo = function (x, y) {
        // Bail if no data model found.
        if (!this.dataModel) {
            return;
        }
        // Floor and clamp the position to the allowable range.
        x = Math.max(0, Math.min(Math.floor(x), this.maxScrollX));
        y = Math.max(0, Math.min(Math.floor(y), this.maxScrollY));
        // Synchronize the scroll bar values.
        this._hScrollBar.value = x;
        this._vScrollBar.value = y;
        // Compute the delta scroll amount.
        var dx = x - this._scrollX;
        var dy = y - this._scrollY;
        // Bail early if there is no effective scroll.
        if (dx === 0 && dy === 0) {
            return;
        }
        // Bail early if the viewport is not visible.
        if (!this._viewport.isVisible) {
            this._scrollX = x;
            this._scrollY = y;
            return;
        }
        // Get the current size of the viewport.
        var width = this._viewportWidth;
        var height = this._viewportHeight;
        // Bail early if the viewport is empty.
        if (width === 0 || height === 0) {
            this._scrollX = x;
            this._scrollY = y;
            return;
        }
        // Get the visible content origin.
        var contentX = this.headerWidth;
        var contentY = this.headerHeight;
        // Get the visible content dimensions.
        var contentWidth = width - contentX;
        var contentHeight = height - contentY;
        // Bail early if there is no content to draw.
        if (contentWidth <= 0 && contentHeight <= 0) {
            this._scrollX = x;
            this._scrollY = y;
            return;
        }
        // Compute the area which needs painting for the `dx` scroll.
        var dxArea = 0;
        if (dx !== 0 && contentWidth > 0) {
            if (Math.abs(dx) >= contentWidth) {
                dxArea = contentWidth * height;
            }
            else {
                dxArea = Math.abs(dx) * height;
            }
        }
        // Compute the area which needs painting for the `dy` scroll.
        var dyArea = 0;
        if (dy !== 0 && contentHeight > 0) {
            if (Math.abs(dy) >= contentHeight) {
                dyArea = width * contentHeight;
            }
            else {
                dyArea = width * Math.abs(dy);
            }
        }
        // If the area sum is larger than the total, paint everything.
        if (dxArea + dyArea >= width * height) {
            this._scrollX = x;
            this._scrollY = y;
            this.paintContent(0, 0, width, height);
            this._paintOverlay();
            return;
        }
        // Update the internal Y scroll position.
        this._scrollY = y;
        // Scroll the Y axis if needed. If the scroll distance exceeds
        // the visible height, paint everything. Otherwise, blit the
        // valid content and paint the dirty region.
        if (dy !== 0 && contentHeight > 0) {
            if (Math.abs(dy) >= contentHeight) {
                this.paintContent(0, contentY, width, contentHeight);
            }
            else {
                var x_5 = 0;
                var y_5 = dy < 0 ? contentY : contentY + dy;
                var w = width;
                var h = contentHeight - Math.abs(dy);
                this._blitContent(this._canvas, x_5, y_5, w, h, x_5, y_5 - dy);
                this.paintContent(0, dy < 0 ? contentY : height - dy, width, Math.abs(dy));
            }
        }
        // Update the internal X scroll position.
        this._scrollX = x;
        // Scroll the X axis if needed. If the scroll distance exceeds
        // the visible width, paint everything. Otherwise, blit the
        // valid content and paint the dirty region.
        if (dx !== 0 && contentWidth > 0) {
            if (Math.abs(dx) >= contentWidth) {
                this.paintContent(contentX, 0, contentWidth, height);
            }
            else {
                var x_6 = dx < 0 ? contentX : contentX + dx;
                var y_6 = 0;
                var w = contentWidth - Math.abs(dx);
                var h = height;
                this._blitContent(this._canvas, x_6, y_6, w, h, x_6 - dx, y_6);
                this.paintContent(dx < 0 ? contentX : width - dx, 0, Math.abs(dx), height);
            }
        }
        // Paint the overlay.
        this._paintOverlay();
    };
    /**
     * Blit content into the on-screen grid canvas.
     *
     * The rect should be expressed in viewport coordinates.
     *
     * This automatically accounts for the dpi ratio.
     */
    DataGrid.prototype._blitContent = function (source, x, y, w, h, dx, dy) {
        // Scale the blit coordinates by the dpi ratio.
        x *= this._dpiRatio;
        y *= this._dpiRatio;
        w *= this._dpiRatio;
        h *= this._dpiRatio;
        dx *= this._dpiRatio;
        dy *= this._dpiRatio;
        // Save the current gc state.
        this._canvasGC.save();
        // Set the transform to the identity matrix.
        this._canvasGC.setTransform(1, 0, 0, 1, 0, 0);
        // Draw the specified content.
        this._canvasGC.drawImage(source, x, y, w, h, dx, dy, w, h);
        // Restore the gc state.
        this._canvasGC.restore();
    };
    /**
     * Paint the grid content for the given dirty rect.
     *
     * The rect should be expressed in valid viewport coordinates.
     *
     * This is the primary paint entry point. The individual `_draw*`
     * methods should not be invoked directly. This method dispatches
     * to the drawing methods in the correct order.
     */
    DataGrid.prototype.paintContent = function (rx, ry, rw, rh) {
        // Scale the canvas and buffer GC for the dpi ratio.
        this._canvasGC.setTransform(this._dpiRatio, 0, 0, this._dpiRatio, 0, 0);
        this._bufferGC.setTransform(this._dpiRatio, 0, 0, this._dpiRatio, 0, 0);
        // Clear the dirty rect of all content.
        this._canvasGC.clearRect(rx, ry, rw, rh);
        // Draw the void region.
        this._drawVoidRegion(rx, ry, rw, rh);
        // Draw the body region.
        this._drawBodyRegion(rx, ry, rw, rh);
        // Draw the row header region.
        this._drawRowHeaderRegion(rx, ry, rw, rh);
        // Draw the column header region.
        this._drawColumnHeaderRegion(rx, ry, rw, rh);
        // Draw the corner header region.
        this.drawCornerHeaderRegion(rx, ry, rw, rh);
    };
    /**
     * Resizes body column headers so their text fits
     * without clipping or wrapping.
     * @param dataModel
     */
    DataGrid.prototype._fitBodyColumnHeaders = function (dataModel, padding, numCols) {
        // Get the body column count
        var bodyColumnCount = numCols === undefined ? dataModel.columnCount('body') : numCols;
        for (var i = 0; i < bodyColumnCount; i++) {
            /*
              if we're working with nested column headers,
              retrieve the nested levels and iterate on them.
            */
            var numRows = dataModel.rowCount('column-header');
            /*
              Calculate the maximum text width vertically, across
              all nested rows under a given column number.
            */
            var maxWidth = 0;
            for (var j = 0; j < numRows; j++) {
                var cellValue = dataModel.data('column-header', j, i);
                // Basic CellConfig object to get the renderer for that cell
                var config = {
                    x: 0,
                    y: 0,
                    width: 0,
                    height: 0,
                    region: 'column-header',
                    row: 0,
                    column: i,
                    value: null,
                    metadata: DataModel.emptyMetadata
                };
                // Get the renderer for the given cell
                var renderer = this.cellRenderers.get(config);
                // Use the canvas context to measure the cell's text width
                var gc = this.canvasGC;
                gc.font = CellRenderer.resolveOption(renderer.font, config);
                var textWidth = gc.measureText(cellValue).width;
                // Update the maximum width for that column.
                maxWidth = Math.max(maxWidth, textWidth);
            }
            /*
              Send a resize message with new width for the given column.
              Using a padding of 15 pixels to leave some room.
            */
            this.resizeColumn('body', i, maxWidth + padding);
        }
    };
    /**
     * Resizes row header columns so their text fits
     * without clipping or wrapping.
     * @param dataModel
     */
    DataGrid.prototype._fitRowColumnHeaders = function (dataModel, padding, numCols) {
        /*
          if we're working with nested row headers,
          retrieve the nested levels and iterate on them.
        */
        var rowColumnCount = numCols === undefined ? dataModel.columnCount('row-header') : numCols;
        for (var i = 0; i < rowColumnCount; i++) {
            var numCols_1 = dataModel.rowCount('column-header');
            /*
              Calculate the maximum text width vertically, across
              all nested columns under a given row index.
            */
            var maxWidth = 0;
            for (var j = 0; j < numCols_1; j++) {
                var cellValue = dataModel.data('corner-header', j, i);
                // Basic CellConfig object to get the renderer for that cell.
                var config = {
                    x: 0,
                    y: 0,
                    width: 0,
                    height: 0,
                    region: 'column-header',
                    row: 0,
                    column: i,
                    value: null,
                    metadata: DataModel.emptyMetadata
                };
                // Get the renderer for the given cell.
                var renderer = this.cellRenderers.get(config);
                // Use the canvas context to measure the cell's text width
                var gc = this.canvasGC;
                gc.font = CellRenderer.resolveOption(renderer.font, config);
                var textWidth = gc.measureText(cellValue).width;
                maxWidth = Math.max(maxWidth, textWidth);
            }
            /*
              Send a resize message with new width for the given column.
              Using a padding of 15 pixels to leave some room.
            */
            this.resizeColumn('row-header', i, maxWidth + padding);
        }
    };
    /**
     * Paint the overlay content for the entire grid.
     *
     * This is the primary overlay paint entry point. The individual
     * `_draw*` methods should not be invoked directly. This method
     * dispatches to the drawing methods in the correct order.
     */
    DataGrid.prototype._paintOverlay = function () {
        // Scale the overlay GC for the dpi ratio.
        this._overlayGC.setTransform(this._dpiRatio, 0, 0, this._dpiRatio, 0, 0);
        // Clear the overlay of all content.
        this._overlayGC.clearRect(0, 0, this._overlay.width, this._overlay.height);
        // Draw the body selections.
        this._drawBodySelections();
        // Draw the row header selections.
        this._drawRowHeaderSelections();
        // Draw the column header selections.
        this._drawColumnHeaderSelections();
        // Draw the cursor.
        this._drawCursor();
        // Draw the shadows.
        this._drawShadows();
    };
    /**
     * Draw the void region for the dirty rect.
     */
    DataGrid.prototype._drawVoidRegion = function (rx, ry, rw, rh) {
        // Look up the void color.
        var color = this._style.voidColor;
        // Bail if there is no void color.
        if (!color) {
            return;
        }
        // Fill the dirty rect with the void color.
        this._canvasGC.fillStyle = color;
        this._canvasGC.fillRect(rx, ry, rw, rh);
    };
    /**
     * Draw the body region which intersects the dirty rect.
     */
    DataGrid.prototype._drawBodyRegion = function (rx, ry, rw, rh) {
        // Get the visible content dimensions.
        var contentW = this._columnSections.length - this._scrollX;
        var contentH = this._rowSections.length - this._scrollY;
        // Bail if there is no content to draw.
        if (contentW <= 0 || contentH <= 0) {
            return;
        }
        // Get the visible content origin.
        var contentX = this.headerWidth;
        var contentY = this.headerHeight;
        // Bail if the dirty rect does not intersect the content area.
        if (rx + rw <= contentX) {
            return;
        }
        if (ry + rh <= contentY) {
            return;
        }
        if (rx >= contentX + contentW) {
            return;
        }
        if (ry >= contentY + contentH) {
            return;
        }
        // Fetch the geometry.
        var bh = this.bodyHeight;
        var bw = this.bodyWidth;
        var ph = this.pageHeight;
        var pw = this.pageWidth;
        // Get the upper and lower bounds of the dirty content area.
        var x1 = Math.max(rx, contentX);
        var y1 = Math.max(ry, contentY);
        var x2 = Math.min(rx + rw - 1, contentX + contentW - 1);
        var y2 = Math.min(ry + rh - 1, contentY + contentH - 1);
        // Convert the dirty content bounds into cell bounds.
        var r1 = this._rowSections.indexOf(y1 - contentY + this._scrollY);
        var c1 = this._columnSections.indexOf(x1 - contentX + this._scrollX);
        var r2 = this._rowSections.indexOf(y2 - contentY + this._scrollY);
        var c2 = this._columnSections.indexOf(x2 - contentX + this._scrollX);
        // Fetch the max row and column.
        var maxRow = this._rowSections.count - 1;
        var maxColumn = this._columnSections.count - 1;
        // Handle a dirty content area larger than the cell count.
        if (r2 < 0) {
            r2 = maxRow;
        }
        if (c2 < 0) {
            c2 = maxColumn;
        }
        // Convert the cell bounds back to visible coordinates.
        var x = this._columnSections.offsetOf(c1) + contentX - this._scrollX;
        var y = this._rowSections.offsetOf(r1) + contentY - this._scrollY;
        // Set up the paint region size variables.
        var width = 0;
        var height = 0;
        // Allocate the section sizes arrays.
        var rowSizes = new Array(r2 - r1 + 1);
        var columnSizes = new Array(c2 - c1 + 1);
        // Get the row sizes for the region.
        for (var j = r1; j <= r2; ++j) {
            var size = this._rowSections.sizeOf(j);
            rowSizes[j - r1] = size;
            height += size;
        }
        // Get the column sizes for the region.
        for (var i = c1; i <= c2; ++i) {
            var size = this._columnSections.sizeOf(i);
            columnSizes[i - c1] = size;
            width += size;
        }
        // Adjust the geometry if the last row is streched.
        if (this._stretchLastRow && ph > bh && r2 === maxRow) {
            var dh = this.pageHeight - this.bodyHeight;
            rowSizes[rowSizes.length - 1] += dh;
            height += dh;
            y2 += dh;
        }
        // Adjust the geometry if the last column is streched.
        if (this._stretchLastColumn && pw > bw && c2 === maxColumn) {
            var dw = this.pageWidth - this.bodyWidth;
            columnSizes[columnSizes.length - 1] += dw;
            width += dw;
            x2 += dw;
        }
        // Create the paint region object.
        var rgn = {
            region: 'body',
            xMin: x1,
            yMin: y1,
            xMax: x2,
            yMax: y2,
            x: x,
            y: y,
            width: width,
            height: height,
            row: r1,
            column: c1,
            rowSizes: rowSizes,
            columnSizes: columnSizes
        };
        // Draw the background.
        this._drawBackground(rgn, this._style.backgroundColor);
        // Draw the row background.
        this._drawRowBackground(rgn, this._style.rowBackgroundColor);
        // Draw the column background.
        this._drawColumnBackground(rgn, this._style.columnBackgroundColor);
        // Draw the cell content for the paint region.
        this._drawCells(rgn);
        // Draw the horizontal grid lines.
        this._drawHorizontalGridLines(rgn, this._style.horizontalGridLineColor || this._style.gridLineColor);
        // Draw the vertical grid lines.
        this._drawVerticalGridLines(rgn, this._style.verticalGridLineColor || this._style.gridLineColor);
    };
    /**
     * Draw the row header region which intersects the dirty rect.
     */
    DataGrid.prototype._drawRowHeaderRegion = function (rx, ry, rw, rh) {
        // Get the visible content dimensions.
        var contentW = this.headerWidth;
        var contentH = this.bodyHeight - this._scrollY;
        // Bail if there is no content to draw.
        if (contentW <= 0 || contentH <= 0) {
            return;
        }
        // Get the visible content origin.
        var contentX = 0;
        var contentY = this.headerHeight;
        // Bail if the dirty rect does not intersect the content area.
        if (rx + rw <= contentX) {
            return;
        }
        if (ry + rh <= contentY) {
            return;
        }
        if (rx >= contentX + contentW) {
            return;
        }
        if (ry >= contentY + contentH) {
            return;
        }
        // Fetch the geometry.
        var bh = this.bodyHeight;
        var ph = this.pageHeight;
        // Get the upper and lower bounds of the dirty content area.
        var x1 = rx;
        var y1 = Math.max(ry, contentY);
        var x2 = Math.min(rx + rw - 1, contentX + contentW - 1);
        var y2 = Math.min(ry + rh - 1, contentY + contentH - 1);
        // Convert the dirty content bounds into cell bounds.
        var r1 = this._rowSections.indexOf(y1 - contentY + this._scrollY);
        var c1 = this._rowHeaderSections.indexOf(x1);
        var r2 = this._rowSections.indexOf(y2 - contentY + this._scrollY);
        var c2 = this._rowHeaderSections.indexOf(x2);
        // Fetch max row and column.
        var maxRow = this._rowSections.count - 1;
        var maxColumn = this._rowHeaderSections.count - 1;
        // Handle a dirty content area larger than the cell count.
        if (r2 < 0) {
            r2 = maxRow;
        }
        if (c2 < 0) {
            c2 = maxColumn;
        }
        // Convert the cell bounds back to visible coordinates.
        var x = this._rowHeaderSections.offsetOf(c1);
        var y = this._rowSections.offsetOf(r1) + contentY - this._scrollY;
        // Set up the paint region size variables.
        var width = 0;
        var height = 0;
        // Allocate the section sizes arrays.
        var rowSizes = new Array(r2 - r1 + 1);
        var columnSizes = new Array(c2 - c1 + 1);
        // Get the row sizes for the region.
        for (var j = r1; j <= r2; ++j) {
            var size = this._rowSections.sizeOf(j);
            rowSizes[j - r1] = size;
            height += size;
        }
        // Get the column sizes for the region.
        for (var i = c1; i <= c2; ++i) {
            var size = this._rowHeaderSections.sizeOf(i);
            columnSizes[i - c1] = size;
            width += size;
        }
        // Adjust the geometry if the last row is stretched.
        if (this._stretchLastRow && ph > bh && r2 === maxRow) {
            var dh = this.pageHeight - this.bodyHeight;
            rowSizes[rowSizes.length - 1] += dh;
            height += dh;
            y2 += dh;
        }
        // Create the paint region object.
        var rgn = {
            region: 'row-header',
            xMin: x1,
            yMin: y1,
            xMax: x2,
            yMax: y2,
            x: x,
            y: y,
            width: width,
            height: height,
            row: r1,
            column: c1,
            rowSizes: rowSizes,
            columnSizes: columnSizes
        };
        // Draw the background.
        this._drawBackground(rgn, this._style.headerBackgroundColor);
        // Draw the cell content for the paint region.
        this._drawCells(rgn);
        // Draw the horizontal grid lines.
        this._drawHorizontalGridLines(rgn, this._style.headerHorizontalGridLineColor ||
            this._style.headerGridLineColor);
        // Draw the vertical grid lines.
        this._drawVerticalGridLines(rgn, this._style.headerVerticalGridLineColor || this._style.headerGridLineColor);
    };
    /**
     * Draw the column header region which intersects the dirty rect.
     */
    DataGrid.prototype._drawColumnHeaderRegion = function (rx, ry, rw, rh) {
        // Get the visible content dimensions.
        var contentW = this.bodyWidth - this._scrollX;
        var contentH = this.headerHeight;
        // Bail if there is no content to draw.
        if (contentW <= 0 || contentH <= 0) {
            return;
        }
        // Get the visible content origin.
        var contentX = this.headerWidth;
        var contentY = 0;
        // Bail if the dirty rect does not intersect the content area.
        if (rx + rw <= contentX) {
            return;
        }
        if (ry + rh <= contentY) {
            return;
        }
        if (rx >= contentX + contentW) {
            return;
        }
        if (ry >= contentY + contentH) {
            return;
        }
        // Fetch the geometry.
        var bw = this.bodyWidth;
        var pw = this.pageWidth;
        // Get the upper and lower bounds of the dirty content area.
        var x1 = Math.max(rx, contentX);
        var y1 = ry;
        var x2 = Math.min(rx + rw - 1, contentX + contentW - 1);
        var y2 = Math.min(ry + rh - 1, contentY + contentH - 1);
        // Convert the dirty content bounds into cell bounds.
        var r1 = this._columnHeaderSections.indexOf(y1);
        var c1 = this._columnSections.indexOf(x1 - contentX + this._scrollX);
        var r2 = this._columnHeaderSections.indexOf(y2);
        var c2 = this._columnSections.indexOf(x2 - contentX + this._scrollX);
        // Fetch the max row and column.
        var maxRow = this._columnHeaderSections.count - 1;
        var maxColumn = this._columnSections.count - 1;
        // Handle a dirty content area larger than the cell count.
        if (r2 < 0) {
            r2 = maxRow;
        }
        if (c2 < 0) {
            c2 = maxColumn;
        }
        // Convert the cell bounds back to visible coordinates.
        var x = this._columnSections.offsetOf(c1) + contentX - this._scrollX;
        var y = this._columnHeaderSections.offsetOf(r1);
        // Set up the paint region size variables.
        var width = 0;
        var height = 0;
        // Allocate the section sizes arrays.
        var rowSizes = new Array(r2 - r1 + 1);
        var columnSizes = new Array(c2 - c1 + 1);
        // Get the row sizes for the region.
        for (var j = r1; j <= r2; ++j) {
            var size = this._columnHeaderSections.sizeOf(j);
            rowSizes[j - r1] = size;
            height += size;
        }
        // Get the column sizes for the region.
        for (var i = c1; i <= c2; ++i) {
            var size = this._columnSections.sizeOf(i);
            columnSizes[i - c1] = size;
            width += size;
        }
        // Adjust the geometry if the last column is stretched.
        if (this._stretchLastColumn && pw > bw && c2 === maxColumn) {
            var dw = this.pageWidth - this.bodyWidth;
            columnSizes[columnSizes.length - 1] += dw;
            width += dw;
            x2 += dw;
        }
        // Create the paint region object.
        var rgn = {
            region: 'column-header',
            xMin: x1,
            yMin: y1,
            xMax: x2,
            yMax: y2,
            x: x,
            y: y,
            width: width,
            height: height,
            row: r1,
            column: c1,
            rowSizes: rowSizes,
            columnSizes: columnSizes
        };
        // Draw the background.
        this._drawBackground(rgn, this._style.headerBackgroundColor);
        // Draw the cell content for the paint region.
        this._drawCells(rgn);
        // Draw the horizontal grid lines.
        this._drawHorizontalGridLines(rgn, this._style.headerHorizontalGridLineColor ||
            this._style.headerGridLineColor);
        // Draw the vertical grid lines.
        this._drawVerticalGridLines(rgn, this._style.headerVerticalGridLineColor || this._style.headerGridLineColor);
    };
    /**
     * Draw the corner header region which intersects the dirty rect.
     */
    DataGrid.prototype.drawCornerHeaderRegion = function (rx, ry, rw, rh) {
        // Get the visible content dimensions.
        var contentW = this.headerWidth;
        var contentH = this.headerHeight;
        // Bail if there is no content to draw.
        if (contentW <= 0 || contentH <= 0) {
            return;
        }
        // Get the visible content origin.
        var contentX = 0;
        var contentY = 0;
        // Bail if the dirty rect does not intersect the content area.
        if (rx + rw <= contentX) {
            return;
        }
        if (ry + rh <= contentY) {
            return;
        }
        if (rx >= contentX + contentW) {
            return;
        }
        if (ry >= contentY + contentH) {
            return;
        }
        // Get the upper and lower bounds of the dirty content area.
        var x1 = rx;
        var y1 = ry;
        var x2 = Math.min(rx + rw - 1, contentX + contentW - 1);
        var y2 = Math.min(ry + rh - 1, contentY + contentH - 1);
        // Convert the dirty content bounds into cell bounds.
        var r1 = this._columnHeaderSections.indexOf(y1);
        var c1 = this._rowHeaderSections.indexOf(x1);
        var r2 = this._columnHeaderSections.indexOf(y2);
        var c2 = this._rowHeaderSections.indexOf(x2);
        // Handle a dirty content area larger than the cell count.
        if (r2 < 0) {
            r2 = this._columnHeaderSections.count - 1;
        }
        if (c2 < 0) {
            c2 = this._rowHeaderSections.count - 1;
        }
        // Convert the cell bounds back to visible coordinates.
        var x = this._rowHeaderSections.offsetOf(c1);
        var y = this._columnHeaderSections.offsetOf(r1);
        // Set up the paint region size variables.
        var width = 0;
        var height = 0;
        // Allocate the section sizes arrays.
        var rowSizes = new Array(r2 - r1 + 1);
        var columnSizes = new Array(c2 - c1 + 1);
        // Get the row sizes for the region.
        for (var j = r1; j <= r2; ++j) {
            var size = this._columnHeaderSections.sizeOf(j);
            rowSizes[j - r1] = size;
            height += size;
        }
        // Get the column sizes for the region.
        for (var i = c1; i <= c2; ++i) {
            var size = this._rowHeaderSections.sizeOf(i);
            columnSizes[i - c1] = size;
            width += size;
        }
        // Create the paint region object.
        var rgn = {
            region: 'corner-header',
            xMin: x1,
            yMin: y1,
            xMax: x2,
            yMax: y2,
            x: x,
            y: y,
            width: width,
            height: height,
            row: r1,
            column: c1,
            rowSizes: rowSizes,
            columnSizes: columnSizes
        };
        // Draw the background.
        this._drawBackground(rgn, this._style.headerBackgroundColor);
        // Draw the cell content for the paint region.
        this._drawCells(rgn);
        // Draw the horizontal grid lines.
        this._drawHorizontalGridLines(rgn, this._style.headerHorizontalGridLineColor ||
            this._style.headerGridLineColor);
        // Draw the vertical grid lines.
        this._drawVerticalGridLines(rgn, this._style.headerVerticalGridLineColor || this._style.headerGridLineColor);
    };
    /**
     * Draw the background for the given paint region.
     */
    DataGrid.prototype._drawBackground = function (rgn, color) {
        // Bail if there is no color to draw.
        if (!color) {
            return;
        }
        // Unpack the region.
        var xMin = rgn.xMin, yMin = rgn.yMin, xMax = rgn.xMax, yMax = rgn.yMax;
        // Fill the region with the specified color.
        this._canvasGC.fillStyle = color;
        this._canvasGC.fillRect(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
    };
    /**
     * Draw the row background for the given paint region.
     */
    DataGrid.prototype._drawRowBackground = function (rgn, colorFn) {
        // Bail if there is no color function.
        if (!colorFn) {
            return;
        }
        // Compute the X bounds for the row.
        var x1 = Math.max(rgn.xMin, rgn.x);
        var x2 = Math.min(rgn.x + rgn.width - 1, rgn.xMax);
        // Draw the background for the rows in the region.
        for (var y = rgn.y, j = 0, n = rgn.rowSizes.length; j < n; ++j) {
            // Fetch the size of the row.
            var size = rgn.rowSizes[j];
            // Skip zero sized rows.
            if (size === 0) {
                continue;
            }
            // Get the background color for the row.
            var color = colorFn(rgn.row + j);
            // Fill the row with the background color if needed.
            if (color) {
                var y1 = Math.max(rgn.yMin, y);
                var y2 = Math.min(y + size - 1, rgn.yMax);
                this._canvasGC.fillStyle = color;
                this._canvasGC.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
            }
            // Increment the running Y coordinate.
            y += size;
        }
    };
    /**
     * Draw the column background for the given paint region.
     */
    DataGrid.prototype._drawColumnBackground = function (rgn, colorFn) {
        // Bail if there is no color function.
        if (!colorFn) {
            return;
        }
        // Compute the Y bounds for the column.
        var y1 = Math.max(rgn.yMin, rgn.y);
        var y2 = Math.min(rgn.y + rgn.height - 1, rgn.yMax);
        // Draw the background for the columns in the region.
        for (var x = rgn.x, i = 0, n = rgn.columnSizes.length; i < n; ++i) {
            // Fetch the size of the column.
            var size = rgn.columnSizes[i];
            // Skip zero sized columns.
            if (size === 0) {
                continue;
            }
            // Get the background color for the column.
            var color = colorFn(rgn.column + i);
            // Fill the column with the background color if needed.
            if (color) {
                var x1 = Math.max(rgn.xMin, x);
                var x2 = Math.min(x + size - 1, rgn.xMax);
                this._canvasGC.fillStyle = color;
                this._canvasGC.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
            }
            // Increment the running X coordinate.
            x += size;
        }
    };
    /**
     * Returns column size
     * @param region
     * @param index
     */
    DataGrid.prototype._getColumnSize = function (region, index) {
        if (region === 'corner-header') {
            return this._rowHeaderSections.sizeOf(index);
        }
        return this.columnSize(region, index);
    };
    /**
     * Returns row size
     * @param region
     * @param index
     */
    DataGrid.prototype._getRowSize = function (region, index) {
        if (region === 'corner-header') {
            return this._columnHeaderSections.sizeOf(index);
        }
        return this.rowSize(region, index);
    };
    /**
     * Draw the cells for the given paint region.
     */
    DataGrid.prototype._drawCells = function (rgn) {
        // Bail if there is no data model.
        if (!this._dataModel) {
            return;
        }
        // Determine if the cell intersects with a merged group at row or column
        var intersectingColumnGroups = CellGroup.getCellGroupsAtColumn(this._dataModel, rgn.region, rgn.column);
        var intersectingRowGroups = CellGroup.getCellGroupsAtRow(this._dataModel, rgn.region, rgn.row);
        // move the bounds of the region if edges of the region are part of a merge group.
        // after the move, new region contains entirety of the merge groups
        rgn = _lumino_coreutils__WEBPACK_IMPORTED_MODULE_7__.JSONExt.deepCopy(rgn);
        var joinedGroup = CellGroup.joinCellGroupWithMergedCellGroups(this.dataModel, {
            r1: rgn.row,
            r2: rgn.row + rgn.rowSizes.length - 1,
            c1: rgn.column,
            c2: rgn.column + rgn.columnSizes.length - 1
        }, rgn.region);
        for (var r = joinedGroup.r1; r < rgn.row; r++) {
            var h = this._getRowSize(rgn.region, r);
            rgn.y -= h;
            rgn.rowSizes = [h].concat(rgn.rowSizes);
        }
        rgn.row = joinedGroup.r1;
        for (var c = joinedGroup.c1; c < rgn.column; c++) {
            var w = this._getColumnSize(rgn.region, c);
            rgn.x -= w;
            rgn.columnSizes = [w].concat(rgn.columnSizes);
        }
        rgn.column = joinedGroup.c1;
        // Set up the cell config object for rendering.
        var config = {
            x: 0,
            y: 0,
            width: 0,
            height: 0,
            region: rgn.region,
            row: 0,
            column: 0,
            value: null,
            metadata: DataModel.emptyMetadata
        };
        var groupIndex = -1;
        // Save the buffer gc before wrapping.
        this._bufferGC.save();
        // Wrap the buffer gc for painting the cells.
        var gc = new GraphicsContext(this._bufferGC);
        var height = 0;
        // Loop over the columns in the region.
        for (var x = rgn.x, i = 0, n = rgn.columnSizes.length; i < n; ++i) {
            var xOffset = 0;
            var yOffset = 0;
            // Fetch the size of the column.
            var width = rgn.columnSizes[i];
            // Skip zero sized columns.
            if (width === 0) {
                continue;
            }
            xOffset = width;
            // Compute the column index.
            var column = rgn.column + i;
            // Update the config for the current column.
            config.x = x;
            config.width = width;
            config.column = column;
            // Loop over the rows in the column.
            for (var y = rgn.y, j = 0, n_1 = rgn.rowSizes.length; j < n_1; ++j) {
                // Fetch the size of the row.
                height = rgn.rowSizes[j];
                // Skip zero sized rows.
                if (height === 0) {
                    continue;
                }
                // Compute the row index.
                var row = rgn.row + j;
                groupIndex = CellGroup.getGroupIndex(this.dataModel, config.region, row, column);
                yOffset = height;
                /**
                 * For merged cell regions, only rendering the merged region
                 * if the "parent" cell is the one being painted. Bail otherwise.
                 */
                if (groupIndex !== -1) {
                    var group = this.dataModel.group(config.region, groupIndex);
                    if (group.r1 === row && group.c1 === column) {
                        width = 0;
                        for (var c = group.c1; c <= group.c2; c++) {
                            width += this._getColumnSize(config.region, c);
                        }
                        height = 0;
                        for (var r = group.r1; r <= group.r2; r++) {
                            height += this._getRowSize(config.region, r);
                        }
                    }
                    else {
                        y += yOffset;
                        continue;
                    }
                }
                else {
                    /**
                     * Reset column width if we're rendering a column-header
                     * which is not part of a merged cell group.
                     */
                    if (rgn.region == 'column-header') {
                        width = rgn.columnSizes[i];
                    }
                }
                // Clear the buffer rect for the cell.
                gc.clearRect(x, y, width, height);
                // Save the GC state.
                gc.save();
                // Get the value for the cell.
                var value = void 0;
                try {
                    value = this._dataModel.data(rgn.region, row, column);
                }
                catch (err) {
                    value = undefined;
                    console.error(err);
                }
                // Get the metadata for the cell.
                var metadata = void 0;
                try {
                    metadata = this._dataModel.metadata(rgn.region, row, column);
                }
                catch (err) {
                    metadata = DataModel.emptyMetadata;
                    console.error(err);
                }
                // Update the config for the current cell.
                config.y = y;
                config.height = height;
                config.width = width;
                config.row = row;
                config.value = value;
                config.metadata = metadata;
                // Get the renderer for the cell.
                var renderer = this._cellRenderers.get(config);
                // Save the GC state.
                gc.save();
                // Paint the cell into the off-screen buffer.
                try {
                    renderer.paint(gc, config);
                }
                catch (err) {
                    console.error(err);
                }
                // Restore the GC state.
                gc.restore();
                // Compute the actual X bounds for the cell.
                var x1 = Math.max(rgn.xMin, config.x);
                var x2 = Math.min(config.x + config.width - 1, rgn.xMax);
                // Compute the actual Y bounds for the cell.
                var y1 = Math.max(rgn.yMin, config.y);
                var y2 = Math.min(config.y + config.height - 1, rgn.yMax);
                if (intersectingColumnGroups.length !== 0 ||
                    intersectingRowGroups.length !== 0) {
                    if (x2 > x1 && y2 > y1) {
                        this._blitContent(this._buffer, x1, y1, x2 - x1 + 1, y2 - y1 + 1, x1, y1);
                    }
                }
                else {
                    this._blitContent(this._buffer, x1, y1, x2 - x1 + 1, y2 - y1 + 1, x1, y1);
                }
                // Increment the running Y coordinate.
                y += yOffset;
            }
            // Restore the GC state.
            gc.restore();
            // Increment the running X coordinate.
            x += xOffset;
        }
        // Dispose of the wrapped gc.
        gc.dispose();
        // Restore the final buffer gc state.
        this._bufferGC.restore();
    };
    /**
     * Draw the horizontal grid lines for the given paint region.
     */
    DataGrid.prototype._drawHorizontalGridLines = function (rgn, color) {
        // Bail if there is no color to draw.
        if (!color) {
            return;
        }
        // Compute the X bounds for the horizontal lines.
        var x1 = Math.max(rgn.xMin, rgn.x);
        // Begin the path for the grid lines.
        this._canvasGC.beginPath();
        // Set the line width for the grid lines.
        this._canvasGC.lineWidth = 1;
        // Fetch the geometry.
        var bh = this.bodyHeight;
        var ph = this.pageHeight;
        // Fetch the number of grid lines to be drawn.
        var n = rgn.rowSizes.length;
        // Adjust the count down if the last line shouldn't be drawn.
        if (this._stretchLastRow && ph > bh) {
            if (rgn.row + n === this._rowSections.count) {
                n -= 1;
            }
        }
        // Draw the horizontal grid lines.
        for (var y = rgn.y, j = 0; j < n; ++j) {
            // Fetch the size of the row.
            var size = rgn.rowSizes[j];
            // Skip zero sized rows.
            if (size === 0) {
                continue;
            }
            var xStart = 0;
            var lineStarted = false;
            var lines = [];
            var leftCurrent = x1;
            for (var c = rgn.column; c < rgn.column + rgn.columnSizes.length; c++) {
                var cIndex = c - rgn.column;
                var cellUp = [rgn.row + j, c];
                var cellDown = [rgn.row + j + 1, c];
                if (CellGroup.areCellsMerged(this.dataModel, rgn.region, cellUp, cellDown)) {
                    if (lineStarted) {
                        lines.push([xStart, leftCurrent]);
                    }
                    lineStarted = false;
                }
                else {
                    if (!lineStarted) {
                        lineStarted = true;
                        xStart = leftCurrent;
                    }
                }
                leftCurrent += rgn.columnSizes[cIndex];
                if (c === rgn.column) {
                    leftCurrent -= rgn.xMin - rgn.x;
                }
            }
            if (lineStarted) {
                lines.push([xStart, rgn.xMax + 1]);
            }
            // Compute the Y position of the line.
            var pos = y + size - 1;
            // Draw the line if it's in range of the dirty rect.
            if (pos >= rgn.yMin && pos <= rgn.yMax) {
                // Render entire grid if scrolling merged cells grid
                var extendLines = Private$1.shouldPaintEverything(this._dataModel);
                if (extendLines) {
                    for (var _i = 0, lines_1 = lines; _i < lines_1.length; _i++) {
                        var line = lines_1[_i];
                        var x1_1 = line[0], x2 = line[1];
                        this._canvasGC.moveTo(x1_1, pos + 0.5);
                        this._canvasGC.lineTo(x2, pos + 0.5);
                    }
                }
                else {
                    var x2 = Math.min(rgn.x + rgn.width, rgn.xMax + 1);
                    this._canvasGC.moveTo(x1, pos + 0.5);
                    this._canvasGC.lineTo(x2, pos + 0.5);
                }
            }
            // Increment the running Y coordinate.
            y += size;
        }
        // Stroke the lines with the specified color.
        this._canvasGC.strokeStyle = color;
        this._canvasGC.stroke();
    };
    /**
     * Draw the vertical grid lines for the given paint region.
     */
    DataGrid.prototype._drawVerticalGridLines = function (rgn, color) {
        // Bail if there is no color to draw.
        if (!color) {
            return;
        }
        // Compute the Y bounds for the vertical lines.
        var y1 = Math.max(rgn.yMin, rgn.y);
        // Begin the path for the grid lines
        this._canvasGC.beginPath();
        // Set the line width for the grid lines.
        this._canvasGC.lineWidth = 1;
        // Fetch the geometry.
        var bw = this.bodyWidth;
        var pw = this.pageWidth;
        // Fetch the number of grid lines to be drawn.
        var n = rgn.columnSizes.length;
        // Adjust the count down if the last line shouldn't be drawn.
        if (this._stretchLastColumn && pw > bw) {
            if (rgn.column + n === this._columnSections.count) {
                n -= 1;
            }
        }
        // Draw the vertical grid lines.
        for (var x = rgn.x, i = 0; i < n; ++i) {
            // Fetch the size of the column.
            var size = rgn.columnSizes[i];
            // Skip zero sized columns.
            if (size === 0) {
                continue;
            }
            var yStart = 0;
            var lineStarted = false;
            var lines = [];
            var topCurrent = y1;
            for (var r = rgn.row; r < rgn.row + rgn.rowSizes.length; r++) {
                var rIndex = r - rgn.row;
                var cellLeft = [r, rgn.column + i];
                var cellRight = [r, rgn.column + i + 1];
                if (CellGroup.areCellsMerged(this.dataModel, rgn.region, cellLeft, cellRight)) {
                    if (lineStarted) {
                        lines.push([yStart, topCurrent]);
                    }
                    lineStarted = false;
                }
                else {
                    if (!lineStarted) {
                        lineStarted = true;
                        yStart = topCurrent;
                    }
                }
                topCurrent += rgn.rowSizes[rIndex];
                if (r === rgn.row) {
                    topCurrent -= rgn.yMin - rgn.y;
                }
            }
            if (lineStarted) {
                lines.push([yStart, rgn.yMax + 1]);
            }
            // Compute the X position of the line.
            var pos = x + size - 1;
            // Draw the line if it's in range of the dirty rect.
            if (pos >= rgn.xMin && pos <= rgn.xMax) {
                // Render entire grid if scrolling merged cells grid
                var extendLines = Private$1.shouldPaintEverything(this._dataModel);
                if (extendLines) {
                    for (var _i = 0, lines_2 = lines; _i < lines_2.length; _i++) {
                        var line = lines_2[_i];
                        // this._canvasGC.strokeStyle = color;
                        this._canvasGC.moveTo(pos + 0.5, line[0]);
                        this._canvasGC.lineTo(pos + 0.5, line[1]);
                    }
                }
                else {
                    var y2 = Math.min(rgn.y + rgn.height, rgn.yMax + 1);
                    this._canvasGC.moveTo(pos + 0.5, y1);
                    this._canvasGC.lineTo(pos + 0.5, y2);
                }
            }
            // Increment the running X coordinate.
            x += size;
        }
        // Stroke the lines with the specified color.
        this._canvasGC.strokeStyle = color;
        this._canvasGC.stroke();
    };
    /**
     * Draw the body selections for the data grid.
     */
    DataGrid.prototype._drawBodySelections = function () {
        // Fetch the selection model.
        var model = this._selectionModel;
        // Bail early if there are no selections.
        if (!model || model.isEmpty) {
            return;
        }
        // Fetch the selection colors.
        var fill = this._style.selectionFillColor;
        var stroke = this._style.selectionBorderColor;
        // Bail early if there is nothing to draw.
        if (!fill && !stroke) {
            return;
        }
        // Fetch the scroll geometry.
        var sx = this._scrollX;
        var sy = this._scrollY;
        // Get the first visible cell of the grid.
        var r1 = this._rowSections.indexOf(sy);
        var c1 = this._columnSections.indexOf(sx);
        // Bail early if there are no visible cells.
        if (r1 < 0 || c1 < 0) {
            return;
        }
        // Fetch the extra geometry.
        var bw = this.bodyWidth;
        var bh = this.bodyHeight;
        var pw = this.pageWidth;
        var ph = this.pageHeight;
        var hw = this.headerWidth;
        var hh = this.headerHeight;
        // Get the last visible cell of the grid.
        var r2 = this._rowSections.indexOf(sy + ph);
        var c2 = this._columnSections.indexOf(sx + pw);
        // Fetch the max row and column.
        var maxRow = this._rowSections.count - 1;
        var maxColumn = this._columnSections.count - 1;
        // Clamp the last cell if the void space is visible.
        r2 = r2 < 0 ? maxRow : r2;
        c2 = c2 < 0 ? maxColumn : c2;
        // Fetch the overlay gc.
        var gc = this._overlayGC;
        // Save the gc state.
        gc.save();
        // Set up the body clipping rect.
        gc.beginPath();
        gc.rect(hw, hh, pw, ph);
        gc.clip();
        // Set up the gc style.
        if (fill) {
            gc.fillStyle = fill;
        }
        if (stroke) {
            gc.strokeStyle = stroke;
            gc.lineWidth = 1;
        }
        // Iterate over the selections.
        var it = model.selections();
        var s;
        while ((s = it.next()) !== undefined) {
            // Skip the section if it's not visible.
            if (s.r1 < r1 && s.r2 < r1) {
                continue;
            }
            if (s.r1 > r2 && s.r2 > r2) {
                continue;
            }
            if (s.c1 < c1 && s.c2 < c1) {
                continue;
            }
            if (s.c1 > c2 && s.c2 > c2) {
                continue;
            }
            // Clamp the cell to the model bounds.
            var sr1 = Math.max(0, Math.min(s.r1, maxRow));
            var sc1 = Math.max(0, Math.min(s.c1, maxColumn));
            var sr2 = Math.max(0, Math.min(s.r2, maxRow));
            var sc2 = Math.max(0, Math.min(s.c2, maxColumn));
            // Swap index order if needed.
            var tmp = void 0;
            if (sr1 > sr2) {
                tmp = sr1;
                sr1 = sr2;
                sr2 = tmp;
            }
            if (sc1 > sc2) {
                tmp = sc1;
                sc1 = sc2;
                sc2 = tmp;
            }
            var joinedGroup = CellGroup.joinCellGroupWithMergedCellGroups(this.dataModel, { r1: sr1, r2: sr2, c1: sc1, c2: sc2 }, 'body');
            sr1 = joinedGroup.r1;
            sr2 = joinedGroup.r2;
            sc1 = joinedGroup.c1;
            sc2 = joinedGroup.c2;
            // Convert to pixel coordinates.
            var x1 = this._columnSections.offsetOf(sc1) - sx + hw;
            var y1 = this._rowSections.offsetOf(sr1) - sy + hh;
            var x2 = this._columnSections.extentOf(sc2) - sx + hw;
            var y2 = this._rowSections.extentOf(sr2) - sy + hh;
            // Adjust the trailing X coordinate for column stretch.
            if (this._stretchLastColumn && pw > bw && sc2 === maxColumn) {
                x2 = hw + pw - 1;
            }
            // Adjust the trailing Y coordinate for row stretch.
            if (this._stretchLastRow && ph > bh && sr2 === maxRow) {
                y2 = hh + ph - 1;
            }
            // Clamp the bounds to just outside of the clipping rect.
            x1 = Math.max(hw - 1, x1);
            y1 = Math.max(hh - 1, y1);
            x2 = Math.min(hw + pw + 1, x2);
            y2 = Math.min(hh + ph + 1, y2);
            // Skip zero sized ranges.
            if (x2 < x1 || y2 < y1) {
                continue;
            }
            // Fill the rect if needed.
            if (fill) {
                gc.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
            }
            // Stroke the rect if needed.
            if (stroke) {
                gc.strokeRect(x1 - 0.5, y1 - 0.5, x2 - x1 + 1, y2 - y1 + 1);
            }
        }
        // Restore the gc state.
        gc.restore();
    };
    /**
     * Draw the row header selections for the data grid.
     */
    DataGrid.prototype._drawRowHeaderSelections = function () {
        // Fetch the selection model.
        var model = this._selectionModel;
        // Bail early if there are no selections or if the selectionMode is the entire column.
        if (!model || model.isEmpty || model.selectionMode == 'column') {
            return;
        }
        // Bail early if the row headers are not visible.
        if (this.headerWidth === 0 || this.pageHeight === 0) {
            return;
        }
        // Fetch the selection colors.
        var fill = this._style.headerSelectionFillColor;
        var stroke = this._style.headerSelectionBorderColor;
        // Bail early if there is nothing to draw.
        if (!fill && !stroke) {
            return;
        }
        // Fetch common geometry.
        var sy = this._scrollY;
        var bh = this.bodyHeight;
        var ph = this.pageHeight;
        var hw = this.headerWidth;
        var hh = this.headerHeight;
        var rs = this._rowSections;
        // Fetch the overlay gc.
        var gc = this._overlayGC;
        // Save the gc state.
        gc.save();
        // Set up the header clipping rect.
        gc.beginPath();
        gc.rect(0, hh, hw, ph);
        gc.clip();
        // Set up the gc style.
        if (fill) {
            gc.fillStyle = fill;
        }
        if (stroke) {
            gc.strokeStyle = stroke;
            gc.lineWidth = 1;
        }
        // Fetch the max row.
        var maxRow = rs.count - 1;
        // Fetch the visible rows.
        var r1 = rs.indexOf(sy);
        var r2 = rs.indexOf(sy + ph - 1);
        r2 = r2 < 0 ? maxRow : r2;
        // Iterate over the visible rows.
        for (var j = r1; j <= r2; ++j) {
            // Skip rows which aren't selected.
            if (!model.isRowSelected(j)) {
                continue;
            }
            // Get the dimensions of the row.
            var y = rs.offsetOf(j) - sy + hh;
            var h = rs.sizeOf(j);
            // Adjust the height for row stretch.
            if (this._stretchLastRow && ph > bh && j === maxRow) {
                h = hh + ph - y;
            }
            // Skip zero sized rows.
            if (h === 0) {
                continue;
            }
            // Fill the rect if needed.
            if (fill) {
                gc.fillRect(0, y, hw, h);
            }
            // Draw the border if needed.
            if (stroke) {
                gc.beginPath();
                gc.moveTo(hw - 0.5, y - 1);
                gc.lineTo(hw - 0.5, y + h);
                gc.stroke();
            }
        }
        // Restore the gc state.
        gc.restore();
    };
    /**
     * Draw the column header selections for the data grid.
     */
    DataGrid.prototype._drawColumnHeaderSelections = function () {
        // Fetch the selection model.
        var model = this._selectionModel;
        // Bail early if there are no selections or if the selectionMode is the entire row
        if (!model || model.isEmpty || model.selectionMode == 'row') {
            return;
        }
        // Bail early if the column headers are not visible.
        if (this.headerHeight === 0 || this.pageWidth === 0) {
            return;
        }
        // Fetch the selection colors.
        var fill = this._style.headerSelectionFillColor;
        var stroke = this._style.headerSelectionBorderColor;
        // Bail early if there is nothing to draw.
        if (!fill && !stroke) {
            return;
        }
        // Fetch common geometry.
        var sx = this._scrollX;
        var bw = this.bodyWidth;
        var pw = this.pageWidth;
        var hw = this.headerWidth;
        var hh = this.headerHeight;
        var cs = this._columnSections;
        // Fetch the overlay gc.
        var gc = this._overlayGC;
        // Save the gc state.
        gc.save();
        // Set up the header clipping rect.
        gc.beginPath();
        gc.rect(hw, 0, pw, hh);
        gc.clip();
        // Set up the gc style.
        if (fill) {
            gc.fillStyle = fill;
        }
        if (stroke) {
            gc.strokeStyle = stroke;
            gc.lineWidth = 1;
        }
        // Fetch the max column.
        var maxCol = cs.count - 1;
        // Fetch the visible columns.
        var c1 = cs.indexOf(sx);
        var c2 = cs.indexOf(sx + pw - 1);
        c2 = c2 < 0 ? maxCol : c2;
        // Iterate over the visible columns.
        for (var i = c1; i <= c2; ++i) {
            // Skip columns which aren't selected.
            if (!model.isColumnSelected(i)) {
                continue;
            }
            // Get the dimensions of the column.
            var x = cs.offsetOf(i) - sx + hw;
            var w = cs.sizeOf(i);
            // Adjust the width for column stretch.
            if (this._stretchLastColumn && pw > bw && i === maxCol) {
                w = hw + pw - x;
            }
            // Skip zero sized columns.
            if (w === 0) {
                continue;
            }
            // Fill the rect if needed.
            if (fill) {
                gc.fillRect(x, 0, w, hh);
            }
            // Draw the border if needed.
            if (stroke) {
                gc.beginPath();
                gc.moveTo(x - 1, hh - 0.5);
                gc.lineTo(x + w, hh - 0.5);
                gc.stroke();
            }
        }
        // Restore the gc state.
        gc.restore();
    };
    /**
     * Draw the overlay cursor for the data grid.
     */
    DataGrid.prototype._drawCursor = function () {
        // Fetch the selection model.
        var model = this._selectionModel;
        // Bail early if there is no cursor.
        if (!model || model.isEmpty || model.selectionMode !== 'cell') {
            return;
        }
        // Extract the style information.
        var fill = this._style.cursorFillColor;
        var stroke = this._style.cursorBorderColor;
        // Bail early if there is nothing to draw.
        if (!fill && !stroke) {
            return;
        }
        // Fetch the cursor location.
        var startRow = model.cursorRow;
        var startColumn = model.cursorColumn;
        // Fetch the max row and column.
        var maxRow = this._rowSections.count - 1;
        var maxColumn = this._columnSections.count - 1;
        // Bail early if the cursor is out of bounds.
        if (startRow < 0 || startRow > maxRow) {
            return;
        }
        if (startColumn < 0 || startColumn > maxColumn) {
            return;
        }
        var endRow = startRow;
        var endColumn = startColumn;
        var joinedGroup = CellGroup.joinCellGroupWithMergedCellGroups(this.dataModel, { r1: startRow, r2: endRow, c1: startColumn, c2: endColumn }, 'body');
        startRow = joinedGroup.r1;
        endRow = joinedGroup.r2;
        startColumn = joinedGroup.c1;
        endColumn = joinedGroup.c2;
        // Fetch geometry.
        var sx = this._scrollX;
        var sy = this._scrollY;
        var bw = this.bodyWidth;
        var bh = this.bodyHeight;
        var pw = this.pageWidth;
        var ph = this.pageHeight;
        var hw = this.headerWidth;
        var hh = this.headerHeight;
        var vw = this._viewportWidth;
        var vh = this._viewportHeight;
        // Get the cursor bounds in viewport coordinates.
        var x1 = this._columnSections.offsetOf(startColumn) - sx + hw;
        var x2 = this._columnSections.extentOf(endColumn) - sx + hw;
        var y1 = this._rowSections.offsetOf(startRow) - sy + hh;
        var y2 = this._rowSections.extentOf(endRow) - sy + hh;
        // Adjust the trailing X coordinate for column stretch.
        if (this._stretchLastColumn && pw > bw && startColumn === maxColumn) {
            x2 = vw - 1;
        }
        // Adjust the trailing Y coordinate for row stretch.
        if (this._stretchLastRow && ph > bh && startRow === maxRow) {
            y2 = vh - 1;
        }
        // Skip zero sized cursors.
        if (x2 < x1 || y2 < y1) {
            return;
        }
        // Bail early if the cursor is off the screen.
        if (x1 - 1 >= vw || y1 - 1 >= vh || x2 + 1 < hw || y2 + 1 < hh) {
            return;
        }
        // Fetch the overlay gc.
        var gc = this._overlayGC;
        // Save the gc state.
        gc.save();
        // Set up the body clipping rect.
        gc.beginPath();
        gc.rect(hw, hh, pw, ph);
        gc.clip();
        // Clear any existing overlay content.
        gc.clearRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        // Fill the cursor rect if needed.
        if (fill) {
            // Set up the fill style.
            gc.fillStyle = fill;
            // Fill the cursor rect.
            gc.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        }
        // Stroke the cursor border if needed.
        if (stroke) {
            // Set up the stroke style.
            gc.strokeStyle = stroke;
            gc.lineWidth = 2;
            // Stroke the cursor rect.
            gc.strokeRect(x1, y1, x2 - x1, y2 - y1);
        }
        // Restore the gc state.
        gc.restore();
    };
    /**
     * Draw the overlay shadows for the data grid.
     */
    DataGrid.prototype._drawShadows = function () {
        // Fetch the scroll shadow from the style.
        var shadow = this._style.scrollShadow;
        // Bail early if there is no shadow to draw.
        if (!shadow) {
            return;
        }
        // Fetch the scroll position.
        var sx = this._scrollX;
        var sy = this._scrollY;
        // Fetch maximum scroll position.
        var sxMax = this.maxScrollX;
        var syMax = this.maxScrollY;
        // Fetch the header width and height.
        var hw = this.headerWidth;
        var hh = this.headerHeight;
        // Fetch the page width and height.
        var pw = this.pageWidth;
        var ph = this.pageHeight;
        // Fetch the viewport width and height.
        var vw = this._viewportWidth;
        var vh = this._viewportHeight;
        // Fetch the body width and height.
        var bw = this.bodyWidth;
        var bh = this.bodyHeight;
        // Adjust the body size for row and column stretch.
        if (this._stretchLastRow && ph > bh) {
            bh = ph;
        }
        if (this._stretchLastColumn && pw > bw) {
            bw = pw;
        }
        // Fetch the gc object.
        var gc = this._overlayGC;
        // Save the gc state.
        gc.save();
        // Draw the column header shadow if needed.
        if (sy > 0) {
            // Set up the gradient coordinates.
            var x0 = 0;
            var y0 = hh;
            var x1 = 0;
            var y1 = y0 + shadow.size;
            // Create the gradient object.
            var grad = gc.createLinearGradient(x0, y0, x1, y1);
            // Set the gradient stops.
            grad.addColorStop(0, shadow.color1);
            grad.addColorStop(0.5, shadow.color2);
            grad.addColorStop(1, shadow.color3);
            // Set up the rect coordinates.
            var x = 0;
            var y = hh;
            var w = hw + Math.min(pw, bw - sx);
            var h = shadow.size;
            // Fill the shadow rect with the fill style.
            gc.fillStyle = grad;
            gc.fillRect(x, y, w, h);
        }
        // Draw the row header shadow if needed.
        if (sx > 0) {
            // Set up the gradient coordinates.
            var x0 = hw;
            var y0 = 0;
            var x1 = x0 + shadow.size;
            var y1 = 0;
            // Create the gradient object.
            var grad = gc.createLinearGradient(x0, y0, x1, y1);
            // Set the gradient stops.
            grad.addColorStop(0, shadow.color1);
            grad.addColorStop(0.5, shadow.color2);
            grad.addColorStop(1, shadow.color3);
            // Set up the rect coordinates.
            var x = hw;
            var y = 0;
            var w = shadow.size;
            var h = hh + Math.min(ph, bh - sy);
            // Fill the shadow rect with the fill style.
            gc.fillStyle = grad;
            gc.fillRect(x, y, w, h);
        }
        // Draw the column footer shadow if needed.
        if (sy < syMax) {
            // Set up the gradient coordinates.
            var x0 = 0;
            var y0 = vh;
            var x1 = 0;
            var y1 = vh - shadow.size;
            // Create the gradient object.
            var grad = gc.createLinearGradient(x0, y0, x1, y1);
            // Set the gradient stops.
            grad.addColorStop(0, shadow.color1);
            grad.addColorStop(0.5, shadow.color2);
            grad.addColorStop(1, shadow.color3);
            // Set up the rect coordinates.
            var x = 0;
            var y = vh - shadow.size;
            var w = hw + Math.min(pw, bw - sx);
            var h = shadow.size;
            // Fill the shadow rect with the fill style.
            gc.fillStyle = grad;
            gc.fillRect(x, y, w, h);
        }
        // Draw the row footer shadow if needed.
        if (sx < sxMax) {
            // Set up the gradient coordinates.
            var x0 = vw;
            var y0 = 0;
            var x1 = vw - shadow.size;
            var y1 = 0;
            // Create the gradient object.
            var grad = gc.createLinearGradient(x0, y0, x1, y1);
            // Set the gradient stops.
            grad.addColorStop(0, shadow.color1);
            grad.addColorStop(0.5, shadow.color2);
            grad.addColorStop(1, shadow.color3);
            // Set up the rect coordinates.
            var x = vw - shadow.size;
            var y = 0;
            var w = shadow.size;
            var h = hh + Math.min(ph, bh - sy);
            // Fill the shadow rect with the fill style.
            gc.fillStyle = grad;
            gc.fillRect(x, y, w, h);
        }
        // Restore the gc state.
        gc.restore();
    };
    return DataGrid;
}(_lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Widget));
/**
 * The namespace for the `DataGrid` class statics.
 */
(function (DataGrid) {
    /**
     * A generic format function for the copy handler.
     *
     * @param args - The format args for the function.
     *
     * @returns The string representation of the value.
     *
     * #### Notes
     * This function uses `String()` to coerce a value to a string.
     */
    function copyFormatGeneric(args) {
        if (args.value === null || args.value === undefined) {
            return '';
        }
        return String(args.value);
    }
    DataGrid.copyFormatGeneric = copyFormatGeneric;
    /**
     * The default theme for a data grid.
     */
    DataGrid.defaultStyle = {
        voidColor: '#F3F3F3',
        backgroundColor: '#FFFFFF',
        gridLineColor: 'rgba(20, 20, 20, 0.15)',
        headerBackgroundColor: '#F3F3F3',
        headerGridLineColor: 'rgba(20, 20, 20, 0.25)',
        selectionFillColor: 'rgba(49, 119, 229, 0.2)',
        selectionBorderColor: 'rgba(0, 107, 247, 1.0)',
        cursorBorderColor: 'rgba(0, 107, 247, 1.0)',
        headerSelectionFillColor: 'rgba(20, 20, 20, 0.1)',
        headerSelectionBorderColor: 'rgba(0, 107, 247, 1.0)',
        scrollShadow: {
            size: 10,
            color1: 'rgba(0, 0, 0, 0.20)',
            color2: 'rgba(0, 0, 0, 0.05)',
            color3: 'rgba(0, 0, 0, 0.00)'
        }
    };
    /**
     * The default sizes for a data grid.
     */
    DataGrid.defaultSizes = {
        rowHeight: 20,
        columnWidth: 64,
        rowHeaderWidth: 64,
        columnHeaderHeight: 20
    };
    /**
     * The default minimum sizes for a data grid.
     */
    DataGrid.minimumSizes = {
        rowHeight: 20,
        columnWidth: 10,
        rowHeaderWidth: 10,
        columnHeaderHeight: 20
    };
    /**
     * The default copy config for a data grid.
     */
    DataGrid.defaultCopyConfig = {
        separator: '\t',
        format: copyFormatGeneric,
        headers: 'none',
        warningThreshold: 1e6
    };
})(DataGrid || (DataGrid = {}));
/**
 * The namespace for the module implementation details.
 */
var Private$1;
(function (Private) {
    /**
     * A singleton `scroll-request` conflatable message.
     */
    Private.ScrollRequest = new _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.ConflatableMessage('scroll-request');
    /**
     * A singleton `overlay-paint-request` conflatable message.
     */
    Private.OverlayPaintRequest = new _lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.ConflatableMessage('overlay-paint-request');
    /**
     * Create a new zero-sized canvas element.
     */
    function createCanvas() {
        var canvas = document.createElement('canvas');
        canvas.width = 0;
        canvas.height = 0;
        return canvas;
    }
    Private.createCanvas = createCanvas;
    /**
     * A function to check whether the entire grid should be rendered
     * when dealing with merged cell regions.
     * @param dataModel grid's data model.
     * @returns boolean.
     */
    function shouldPaintEverything(dataModel) {
        var colGroups = CellGroup.getCellGroupsAtRegion(dataModel, 'column-header');
        var rowHeaderGroups = CellGroup.getCellGroupsAtRegion(dataModel, 'row-header');
        var cornerHeaderGroups = CellGroup.getCellGroupsAtRegion(dataModel, 'corner-header');
        var bodyGroups = CellGroup.getCellGroupsAtRegion(dataModel, 'body');
        return (colGroups.length > 0 ||
            rowHeaderGroups.length > 0 ||
            cornerHeaderGroups.length > 0 ||
            bodyGroups.length > 0);
    }
    Private.shouldPaintEverything = shouldPaintEverything;
    /**
     * Checks whether a given regions has merged cells in it.
     * @param dataModel grid's data model.
     * @param region the paint region to be checked.
     * @returns boolean.
     */
    function regionHasMergedCells(dataModel, region) {
        var regionGroups = CellGroup.getCellGroupsAtRegion(dataModel, region);
        return regionGroups.length > 0;
    }
    Private.regionHasMergedCells = regionHasMergedCells;
    /**
     * A conflatable message which merges dirty paint regions.
     */
    var PaintRequest = /** @class */ (function (_super) {
        __extends(PaintRequest, _super);
        /**
         * Construct a new paint request messages.
         *
         * @param region - The cell region for the paint.
         *
         * @param r1 - The top-left row of the dirty region.
         *
         * @param c1 - The top-left column of the dirty region.
         *
         * @param r2 - The bottom-right row of the dirty region.
         *
         * @param c2 - The bottom-right column of the dirty region.
         */
        function PaintRequest(region, r1, c1, r2, c2) {
            var _this = _super.call(this, 'paint-request') || this;
            _this._region = region;
            _this._r1 = r1;
            _this._c1 = c1;
            _this._r2 = r2;
            _this._c2 = c2;
            return _this;
        }
        Object.defineProperty(PaintRequest.prototype, "region", {
            /**
             * The cell region for the paint.
             */
            get: function () {
                return this._region;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRequest.prototype, "r1", {
            /**
             * The top-left row of the dirty region.
             */
            get: function () {
                return this._r1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRequest.prototype, "c1", {
            /**
             * The top-left column of the dirty region.
             */
            get: function () {
                return this._c1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRequest.prototype, "r2", {
            /**
             * The bottom-right row of the dirty region.
             */
            get: function () {
                return this._r2;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRequest.prototype, "c2", {
            /**
             * The bottom-right column of the dirty region.
             */
            get: function () {
                return this._c2;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Conflate this message with another paint request.
         */
        PaintRequest.prototype.conflate = function (other) {
            // Bail early if the request is already painting everything.
            if (this._region === 'all') {
                return true;
            }
            // Any region can conflate with the `'all'` region.
            if (other._region === 'all') {
                this._region = 'all';
                return true;
            }
            // Otherwise, do not conflate with a different region.
            if (this._region !== other._region) {
                return false;
            }
            // Conflate the region to the total boundary.
            this._r1 = Math.min(this._r1, other._r1);
            this._c1 = Math.min(this._c1, other._c1);
            this._r2 = Math.max(this._r2, other._r2);
            this._c2 = Math.max(this._c2, other._c2);
            return true;
        };
        return PaintRequest;
    }(_lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.ConflatableMessage));
    Private.PaintRequest = PaintRequest;
    /**
     * A conflatable message for resizing rows.
     */
    var RowResizeRequest = /** @class */ (function (_super) {
        __extends(RowResizeRequest, _super);
        /**
         * Construct a new row resize request.
         *
         * @param region - The row region which holds the section.
         *
         * @param index - The index of row in the region.
         *
         * @param size - The target size of the section.
         */
        function RowResizeRequest(region, index, size) {
            var _this = _super.call(this, 'row-resize-request') || this;
            _this._region = region;
            _this._index = index;
            _this._size = size;
            return _this;
        }
        Object.defineProperty(RowResizeRequest.prototype, "region", {
            /**
             * The row region which holds the section.
             */
            get: function () {
                return this._region;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(RowResizeRequest.prototype, "index", {
            /**
             * The index of the row in the region.
             */
            get: function () {
                return this._index;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(RowResizeRequest.prototype, "size", {
            /**
             * The target size of the section.
             */
            get: function () {
                return this._size;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Conflate this message with another row resize request.
         */
        RowResizeRequest.prototype.conflate = function (other) {
            if (this._region !== other._region || this._index !== other._index) {
                return false;
            }
            this._size = other._size;
            return true;
        };
        return RowResizeRequest;
    }(_lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.ConflatableMessage));
    Private.RowResizeRequest = RowResizeRequest;
    /**
     * A conflatable message for resizing columns.
     */
    var ColumnResizeRequest = /** @class */ (function (_super) {
        __extends(ColumnResizeRequest, _super);
        /**
         * Construct a new column resize request.
         *
         * @param region - The column region which holds the section.
         *
         * @param index - The index of column in the region.
         *
         * @param size - The target size of the section.
         */
        function ColumnResizeRequest(region, index, size) {
            var _this = _super.call(this, 'column-resize-request') || this;
            _this._region = region;
            _this._index = index;
            _this._size = size;
            return _this;
        }
        Object.defineProperty(ColumnResizeRequest.prototype, "region", {
            /**
             * The column region which holds the section.
             */
            get: function () {
                return this._region;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ColumnResizeRequest.prototype, "index", {
            /**
             * The index of the column in the region.
             */
            get: function () {
                return this._index;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ColumnResizeRequest.prototype, "size", {
            /**
             * The target size of the section.
             */
            get: function () {
                return this._size;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Conflate this message with another column resize request.
         */
        ColumnResizeRequest.prototype.conflate = function (other) {
            if (this._region !== other._region || this._index !== other._index) {
                return false;
            }
            this._size = other._size;
            return true;
        };
        return ColumnResizeRequest;
    }(_lumino_messaging__WEBPACK_IMPORTED_MODULE_6__.ConflatableMessage));
    Private.ColumnResizeRequest = ColumnResizeRequest;
})(Private$1 || (Private$1 = {}));

/**
 * A data model implementation for in-memory JSON data.
 */
var JSONModel = /** @class */ (function (_super) {
    __extends(JSONModel, _super);
    /**
     * Create a data model with static JSON data.
     *
     * @param options - The options for initializing the data model.
     */
    function JSONModel(options) {
        var _this = _super.call(this) || this;
        var split = Private.splitFields(options.schema);
        _this._data = options.data;
        _this._bodyFields = split.bodyFields;
        _this._headerFields = split.headerFields;
        _this._missingValues = Private.createMissingMap(options.schema);
        return _this;
    }
    /**
     * Get the row count for a region in the data model.
     *
     * @param region - The row region of interest.
     *
     * @returns - The row count for the region.
     */
    JSONModel.prototype.rowCount = function (region) {
        if (region === 'body') {
            return this._data.length;
        }
        return 1; // TODO multiple column-header rows?
    };
    /**
     * Get the column count for a region in the data model.
     *
     * @param region - The column region of interest.
     *
     * @returns - The column count for the region.
     */
    JSONModel.prototype.columnCount = function (region) {
        if (region === 'body') {
            return this._bodyFields.length;
        }
        return this._headerFields.length;
    };
    /**
     * Get the data value for a cell in the data model.
     *
     * @param region - The cell region of interest.
     *
     * @param row - The row index of the cell of interest.
     *
     * @param column - The column index of the cell of interest.
     *
     * @returns - The data value for the specified cell.
     *
     * #### Notes
     * A `missingValue` as defined by the schema is converted to `null`.
     */
    JSONModel.prototype.data = function (region, row, column) {
        // Set up the field and value variables.
        var field;
        var value;
        // Look up the field and value for the region.
        switch (region) {
            case 'body':
                field = this._bodyFields[column];
                value = this._data[row][field.name];
                break;
            case 'column-header':
                field = this._bodyFields[column];
                value = field.title || field.name;
                break;
            case 'row-header':
                field = this._headerFields[column];
                value = this._data[row][field.name];
                break;
            case 'corner-header':
                field = this._headerFields[column];
                value = field.title || field.name;
                break;
            default:
                throw 'unreachable';
        }
        // Test whether the value is a missing value.
        var missing = this._missingValues !== null &&
            typeof value === 'string' &&
            this._missingValues[value] === true;
        // Return the final value.
        return missing ? null : value;
    };
    /**
     * Get the metadata for a cell in the data model.
     *
     * @param region - The cell region of interest.
     *
     * @param row - The row index of the cell of of interest.
     *
     * @param column - The column index of the cell of interest.
     *
     * @returns The metadata for the cell.
     */
    JSONModel.prototype.metadata = function (region, row, column) {
        if (region === 'body' || region === 'column-header') {
            return this._bodyFields[column];
        }
        return this._headerFields[column];
    };
    return JSONModel;
}(DataModel));
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
    /**
     * Split the schema fields into header and body fields.
     */
    function splitFields(schema) {
        // Normalize the primary keys.
        var primaryKeys;
        if (schema.primaryKey === undefined) {
            primaryKeys = [];
        }
        else if (typeof schema.primaryKey === 'string') {
            primaryKeys = [schema.primaryKey];
        }
        else {
            primaryKeys = schema.primaryKey;
        }
        // Separate the fields for the body and header.
        var bodyFields = [];
        var headerFields = [];
        for (var _i = 0, _a = schema.fields; _i < _a.length; _i++) {
            var field = _a[_i];
            if (primaryKeys.indexOf(field.name) === -1) {
                bodyFields.push(field);
            }
            else {
                headerFields.push(field);
            }
        }
        // Return the separated fields.
        return { bodyFields: bodyFields, headerFields: headerFields };
    }
    Private.splitFields = splitFields;
    /**
     * Create a missing values map for a schema.
     *
     * This returns `null` if there are no missing values.
     */
    function createMissingMap(schema) {
        // Bail early if there are no missing values.
        if (!schema.missingValues || schema.missingValues.length === 0) {
            return null;
        }
        // Collect the missing values into a map.
        var result = Object.create(null);
        for (var _i = 0, _a = schema.missingValues; _i < _a.length; _i++) {
            var value = _a[_i];
            result[value] = true;
        }
        // Return the populated map.
        return result;
    }
    Private.createMissingMap = createMissingMap;
})(Private || (Private = {}));


//# sourceMappingURL=index.es6.js.map


/***/ }),

/***/ "../../node_modules/@lumino/keyboard/dist/index.es6.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@lumino/keyboard/dist/index.es6.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EN_US": () => (/* binding */ EN_US),
/* harmony export */   "KeycodeLayout": () => (/* binding */ KeycodeLayout),
/* harmony export */   "getKeyboardLayout": () => (/* binding */ getKeyboardLayout),
/* harmony export */   "setKeyboardLayout": () => (/* binding */ setKeyboardLayout)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Get the global application keyboard layout instance.
 *
 * @returns The keyboard layout for use by the application.
 *
 * #### Notes
 * The default keyboard layout is US-English.
 */
function getKeyboardLayout() {
    return Private.keyboardLayout;
}
/**
 * Set the global application keyboard layout instance.
 *
 * @param - The keyboard layout for use by the application.
 *
 * #### Notes
 * The keyboard layout should typically be set on application startup
 * to a layout which is appropriate for the user's system.
 */
function setKeyboardLayout(layout) {
    Private.keyboardLayout = layout;
}
/**
 * A concrete implementation of [[IKeyboardLayout]] based on keycodes.
 *
 * The `keyCode` property of a `'keydown'` event is a browser and OS
 * specific representation of the physical key (not character) which
 * was pressed on a keyboard. While not the most convenient API, it
 * is currently the only one which works reliably on all browsers.
 *
 * This class accepts a user-defined mapping of keycode to key, which
 * allows for reliable shortcuts tailored to the user's system.
 */
var KeycodeLayout = /** @class */ (function () {
    /**
     * Construct a new keycode layout.
     *
     * @param name - The human readable name for the layout.
     *
     * @param codes - A mapping of keycode to key value.
     *
     * @param modifierKeys - Array of modifier key names
     */
    function KeycodeLayout(name, codes, modifierKeys) {
        if (modifierKeys === void 0) { modifierKeys = []; }
        this.name = name;
        this._codes = codes;
        this._keys = KeycodeLayout.extractKeys(codes);
        this._modifierKeys = KeycodeLayout.convertToKeySet(modifierKeys);
    }
    /**
     * Get an array of the key values supported by the layout.
     *
     * @returns A new array of the supported key values.
     */
    KeycodeLayout.prototype.keys = function () {
        return Object.keys(this._keys);
    };
    /**
     * Test whether the given key is a valid value for the layout.
     *
     * @param key - The user provided key to test for validity.
     *
     * @returns `true` if the key is valid, `false` otherwise.
     */
    KeycodeLayout.prototype.isValidKey = function (key) {
        return key in this._keys;
    };
    /**
     * Test whether the given key is a modifier key.
     *
     * @param key - The user provided key.
     *
     * @returns `true` if the key is a modifier key, `false` otherwise.
     */
    KeycodeLayout.prototype.isModifierKey = function (key) {
        return key in this._modifierKeys;
    };
    /**
     * Get the key for a `'keydown'` event.
     *
     * @param event - The event object for a `'keydown'` event.
     *
     * @returns The associated key value, or an empty string if
     *   the event does not represent a valid primary key.
     */
    KeycodeLayout.prototype.keyForKeydownEvent = function (event) {
        return this._codes[event.keyCode] || '';
    };
    return KeycodeLayout;
}());
/**
 * The namespace for the `KeycodeLayout` class statics.
 */
(function (KeycodeLayout) {
    /**
     * Extract the set of keys from a code map.
     *
     * @param code - The code map of interest.
     *
     * @returns A set of the keys in the code map.
     */
    function extractKeys(codes) {
        var keys = Object.create(null);
        for (var c in codes) {
            keys[codes[c]] = true;
        }
        return keys;
    }
    KeycodeLayout.extractKeys = extractKeys;
    /**
     * Convert array of keys to a key set.
     *
     * @param keys - The array that needs to be converted
     *
     * @returns A set of the keys in the array.
     */
    function convertToKeySet(keys) {
        var keySet = Object(null);
        for (var i = 0, n = keys.length; i < n; ++i) {
            keySet[keys[i]] = true;
        }
        return keySet;
    }
    KeycodeLayout.convertToKeySet = convertToKeySet;
})(KeycodeLayout || (KeycodeLayout = {}));
/**
 * A keycode-based keyboard layout for US English keyboards.
 *
 * This layout is valid for the following OS/Browser combinations.
 *
 * - Windows
 *   - Chrome
 *   - Firefox
 *   - IE
 *
 * - OSX
 *   - Chrome
 *   - Firefox
 *   - Safari
 *
 * - Linux
 *   - Chrome
 *   - Firefox
 *
 * Other combinations may also work, but are untested.
 */
var EN_US = new KeycodeLayout('en-us', {
    8: 'Backspace',
    9: 'Tab',
    13: 'Enter',
    16: 'Shift',
    17: 'Ctrl',
    18: 'Alt',
    19: 'Pause',
    27: 'Escape',
    32: 'Space',
    33: 'PageUp',
    34: 'PageDown',
    35: 'End',
    36: 'Home',
    37: 'ArrowLeft',
    38: 'ArrowUp',
    39: 'ArrowRight',
    40: 'ArrowDown',
    45: 'Insert',
    46: 'Delete',
    48: '0',
    49: '1',
    50: '2',
    51: '3',
    52: '4',
    53: '5',
    54: '6',
    55: '7',
    56: '8',
    57: '9',
    59: ';',
    61: '=',
    65: 'A',
    66: 'B',
    67: 'C',
    68: 'D',
    69: 'E',
    70: 'F',
    71: 'G',
    72: 'H',
    73: 'I',
    74: 'J',
    75: 'K',
    76: 'L',
    77: 'M',
    78: 'N',
    79: 'O',
    80: 'P',
    81: 'Q',
    82: 'R',
    83: 'S',
    84: 'T',
    85: 'U',
    86: 'V',
    87: 'W',
    88: 'X',
    89: 'Y',
    90: 'Z',
    91: 'Meta',
    93: 'ContextMenu',
    96: '0',
    97: '1',
    98: '2',
    99: '3',
    100: '4',
    101: '5',
    102: '6',
    103: '7',
    104: '8',
    105: '9',
    106: '*',
    107: '+',
    109: '-',
    110: '.',
    111: '/',
    112: 'F1',
    113: 'F2',
    114: 'F3',
    115: 'F4',
    116: 'F5',
    117: 'F6',
    118: 'F7',
    119: 'F8',
    120: 'F9',
    121: 'F10',
    122: 'F11',
    123: 'F12',
    173: '-',
    186: ';',
    187: '=',
    188: ',',
    189: '-',
    190: '.',
    191: '/',
    192: '`',
    219: '[',
    220: '\\',
    221: ']',
    222: "'",
    224: 'Meta' // firefox
}, ['Shift', 'Ctrl', 'Alt', 'Meta'] // modifier keys
);
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
    /**
     * The global keyboard layout instance.
     */
    Private.keyboardLayout = EN_US;
})(Private || (Private = {}));


//# sourceMappingURL=index.es6.js.map


/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/AddButton.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/AddButton.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AddButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./IconButton */ "../../node_modules/@rjsf/core/dist/es/components/IconButton.js");


function AddButton(_ref) {
  var className = _ref.className,
      onClick = _ref.onClick,
      disabled = _ref.disabled;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "row"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
    className: "col-xs-3 col-xs-offset-9 text-right ".concat(className)
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], {
    type: "info",
    icon: "plus",
    className: "btn-add col-xs-12",
    "aria-label": "Add",
    tabIndex: "0",
    onClick: onClick,
    disabled: disabled
  })));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21wb25lbnRzL0FkZEJ1dHRvbi5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsIkljb25CdXR0b24iLCJBZGRCdXR0b24iLCJjbGFzc05hbWUiLCJvbkNsaWNrIiwiZGlzYWJsZWQiXSwibWFwcGluZ3MiOiJBQUFBLE9BQU9BLEtBQVAsTUFBa0IsT0FBbEI7QUFDQSxPQUFPQyxVQUFQLE1BQXVCLGNBQXZCO0FBRUEsZUFBZSxTQUFTQyxTQUFULE9BQXFEO0FBQUEsTUFBaENDLFNBQWdDLFFBQWhDQSxTQUFnQztBQUFBLE1BQXJCQyxPQUFxQixRQUFyQkEsT0FBcUI7QUFBQSxNQUFaQyxRQUFZLFFBQVpBLFFBQVk7QUFDbEUsU0FDRTtBQUFLLElBQUEsU0FBUyxFQUFDO0FBQWYsS0FDRTtBQUFHLElBQUEsU0FBUyxnREFBeUNGLFNBQXpDO0FBQVosS0FDRSxvQkFBQyxVQUFEO0FBQ0UsSUFBQSxJQUFJLEVBQUMsTUFEUDtBQUVFLElBQUEsSUFBSSxFQUFDLE1BRlA7QUFHRSxJQUFBLFNBQVMsRUFBQyxtQkFIWjtBQUlFLGtCQUFXLEtBSmI7QUFLRSxJQUFBLFFBQVEsRUFBQyxHQUxYO0FBTUUsSUFBQSxPQUFPLEVBQUVDLE9BTlg7QUFPRSxJQUFBLFFBQVEsRUFBRUM7QUFQWixJQURGLENBREYsQ0FERjtBQWVEIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gXCJyZWFjdFwiO1xuaW1wb3J0IEljb25CdXR0b24gZnJvbSBcIi4vSWNvbkJ1dHRvblwiO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBBZGRCdXR0b24oeyBjbGFzc05hbWUsIG9uQ2xpY2ssIGRpc2FibGVkIH0pIHtcbiAgcmV0dXJuIChcbiAgICA8ZGl2IGNsYXNzTmFtZT1cInJvd1wiPlxuICAgICAgPHAgY2xhc3NOYW1lPXtgY29sLXhzLTMgY29sLXhzLW9mZnNldC05IHRleHQtcmlnaHQgJHtjbGFzc05hbWV9YH0+XG4gICAgICAgIDxJY29uQnV0dG9uXG4gICAgICAgICAgdHlwZT1cImluZm9cIlxuICAgICAgICAgIGljb249XCJwbHVzXCJcbiAgICAgICAgICBjbGFzc05hbWU9XCJidG4tYWRkIGNvbC14cy0xMlwiXG4gICAgICAgICAgYXJpYS1sYWJlbD1cIkFkZFwiXG4gICAgICAgICAgdGFiSW5kZXg9XCIwXCJcbiAgICAgICAgICBvbkNsaWNrPXtvbkNsaWNrfVxuICAgICAgICAgIGRpc2FibGVkPXtkaXNhYmxlZH1cbiAgICAgICAgLz5cbiAgICAgIDwvcD5cbiAgICA8L2Rpdj5cbiAgKTtcbn1cbiJdfQ==

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/ErrorList.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/ErrorList.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function ErrorList(props) {
  var errors = props.errors;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "panel panel-danger errors"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "panel-heading"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h3", {
    className: "panel-title"
  }, "Errors")), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
    className: "list-group"
  }, errors.map(function (error, i) {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
      key: i,
      className: "list-group-item text-danger"
    }, error.stack);
  })));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21wb25lbnRzL0Vycm9yTGlzdC5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsIkVycm9yTGlzdCIsInByb3BzIiwiZXJyb3JzIiwibWFwIiwiZXJyb3IiLCJpIiwic3RhY2siXSwibWFwcGluZ3MiOiJBQUFBLE9BQU9BLEtBQVAsTUFBa0IsT0FBbEI7QUFFQSxlQUFlLFNBQVNDLFNBQVQsQ0FBbUJDLEtBQW5CLEVBQTBCO0FBQUEsTUFDL0JDLE1BRCtCLEdBQ3BCRCxLQURvQixDQUMvQkMsTUFEK0I7QUFFdkMsU0FDRTtBQUFLLElBQUEsU0FBUyxFQUFDO0FBQWYsS0FDRTtBQUFLLElBQUEsU0FBUyxFQUFDO0FBQWYsS0FDRTtBQUFJLElBQUEsU0FBUyxFQUFDO0FBQWQsY0FERixDQURGLEVBSUU7QUFBSSxJQUFBLFNBQVMsRUFBQztBQUFkLEtBQ0dBLE1BQU0sQ0FBQ0MsR0FBUCxDQUFXLFVBQUNDLEtBQUQsRUFBUUMsQ0FBUixFQUFjO0FBQ3hCLFdBQ0U7QUFBSSxNQUFBLEdBQUcsRUFBRUEsQ0FBVDtBQUFZLE1BQUEsU0FBUyxFQUFDO0FBQXRCLE9BQ0dELEtBQUssQ0FBQ0UsS0FEVCxDQURGO0FBS0QsR0FOQSxDQURILENBSkYsQ0FERjtBQWdCRCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gRXJyb3JMaXN0KHByb3BzKSB7XG4gIGNvbnN0IHsgZXJyb3JzIH0gPSBwcm9wcztcbiAgcmV0dXJuIChcbiAgICA8ZGl2IGNsYXNzTmFtZT1cInBhbmVsIHBhbmVsLWRhbmdlciBlcnJvcnNcIj5cbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwicGFuZWwtaGVhZGluZ1wiPlxuICAgICAgICA8aDMgY2xhc3NOYW1lPVwicGFuZWwtdGl0bGVcIj5FcnJvcnM8L2gzPlxuICAgICAgPC9kaXY+XG4gICAgICA8dWwgY2xhc3NOYW1lPVwibGlzdC1ncm91cFwiPlxuICAgICAgICB7ZXJyb3JzLm1hcCgoZXJyb3IsIGkpID0+IHtcbiAgICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGxpIGtleT17aX0gY2xhc3NOYW1lPVwibGlzdC1ncm91cC1pdGVtIHRleHQtZGFuZ2VyXCI+XG4gICAgICAgICAgICAgIHtlcnJvci5zdGFja31cbiAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICAgKTtcbiAgICAgICAgfSl9XG4gICAgICA8L3VsPlxuICAgIDwvZGl2PlxuICApO1xufVxuIl19

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/Form.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/Form.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Form)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var lodash_pick__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/pick */ "../../node_modules/lodash/pick.js");
/* harmony import */ var lodash_pick__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_pick__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _ErrorList__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ErrorList */ "../../node_modules/@rjsf/core/dist/es/components/ErrorList.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
/* harmony import */ var _validate__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../validate */ "../../node_modules/@rjsf/core/dist/es/validate.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











var Form =
/*#__PURE__*/
function (_Component) {
  _inherits(Form, _Component);

  function Form(props) {
    var _this;

    _classCallCheck(this, Form);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Form).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "getUsedFormData", function (formData, fields) {
      //for the case of a single input form
      if (fields.length === 0 && _typeof(formData) !== "object") {
        return formData;
      }

      var data = lodash_pick__WEBPACK_IMPORTED_MODULE_1___default()(formData, fields);

      if (Array.isArray(formData)) {
        return Object.keys(data).map(function (key) {
          return data[key];
        });
      }

      return data;
    });

    _defineProperty(_assertThisInitialized(_this), "getFieldNames", function (pathSchema, formData) {
      var getAllPaths = function getAllPaths(_obj) {
        var acc = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var paths = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [""];
        Object.keys(_obj).forEach(function (key) {
          if (_typeof(_obj[key]) === "object") {
            var newPaths = paths.map(function (path) {
              return "".concat(path, ".").concat(key);
            }); // If an object is marked with additionalProperties, all its keys are valid

            if (_obj[key].__rjsf_additionalProperties && _obj[key].$name !== "") {
              acc.push(_obj[key].$name);
            } else {
              getAllPaths(_obj[key], acc, newPaths);
            }
          } else if (key === "$name" && _obj[key] !== "") {
            paths.forEach(function (path) {
              path = path.replace(/^\./, "");

              var formValue = lodash_get__WEBPACK_IMPORTED_MODULE_2___default()(formData, path); // adds path to fieldNames if it points to a value
              // or an empty object/array


              if (_typeof(formValue) !== "object" || lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default()(formValue)) {
                acc.push(path);
              }
            });
          }
        });
        return acc;
      };

      return getAllPaths(pathSchema);
    });

    _defineProperty(_assertThisInitialized(_this), "onChange", function (formData, newErrorSchema) {
      if ((0,_utils__WEBPACK_IMPORTED_MODULE_5__.isObject)(formData) || Array.isArray(formData)) {
        var newState = _this.getStateFromProps(_this.props, formData);

        formData = newState.formData;
      }

      var mustValidate = !_this.props.noValidate && _this.props.liveValidate;
      var state = {
        formData: formData
      };
      var newFormData = formData;

      if (_this.props.omitExtraData === true && _this.props.liveOmit === true) {
        var retrievedSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.retrieveSchema)(_this.state.schema, _this.state.schema, formData);
        var pathSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.toPathSchema)(retrievedSchema, "", _this.state.schema, formData);

        var fieldNames = _this.getFieldNames(pathSchema, formData);

        newFormData = _this.getUsedFormData(formData, fieldNames);
        state = {
          formData: newFormData
        };
      }

      if (mustValidate) {
        var schemaValidation = _this.validate(newFormData);

        var errors = schemaValidation.errors;
        var errorSchema = schemaValidation.errorSchema;
        var schemaValidationErrors = errors;
        var schemaValidationErrorSchema = errorSchema;

        if (_this.props.extraErrors) {
          errorSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.mergeObjects)(errorSchema, _this.props.extraErrors, !!"concat arrays");
          errors = (0,_validate__WEBPACK_IMPORTED_MODULE_6__.toErrorList)(errorSchema);
        }

        state = {
          formData: newFormData,
          errors: errors,
          errorSchema: errorSchema,
          schemaValidationErrors: schemaValidationErrors,
          schemaValidationErrorSchema: schemaValidationErrorSchema
        };
      } else if (!_this.props.noValidate && newErrorSchema) {
        var _errorSchema = _this.props.extraErrors ? (0,_utils__WEBPACK_IMPORTED_MODULE_5__.mergeObjects)(newErrorSchema, _this.props.extraErrors, !!"concat arrays") : newErrorSchema;

        state = {
          formData: newFormData,
          errorSchema: _errorSchema,
          errors: (0,_validate__WEBPACK_IMPORTED_MODULE_6__.toErrorList)(_errorSchema)
        };
      }

      _this.setState(state, function () {
        return _this.props.onChange && _this.props.onChange(_this.state);
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onBlur", function () {
      if (_this.props.onBlur) {
        var _this$props;

        (_this$props = _this.props).onBlur.apply(_this$props, arguments);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onFocus", function () {
      if (_this.props.onFocus) {
        var _this$props2;

        (_this$props2 = _this.props).onFocus.apply(_this$props2, arguments);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onSubmit", function (event) {
      event.preventDefault();

      if (event.target !== event.currentTarget) {
        return;
      }

      event.persist();
      var newFormData = _this.state.formData;

      if (_this.props.omitExtraData === true) {
        var retrievedSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.retrieveSchema)(_this.state.schema, _this.state.schema, newFormData);
        var pathSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.toPathSchema)(retrievedSchema, "", _this.state.schema, newFormData);

        var fieldNames = _this.getFieldNames(pathSchema, newFormData);

        newFormData = _this.getUsedFormData(newFormData, fieldNames);
      }

      if (!_this.props.noValidate) {
        var schemaValidation = _this.validate(newFormData);

        var _errors = schemaValidation.errors;
        var _errorSchema2 = schemaValidation.errorSchema;
        var schemaValidationErrors = _errors;
        var schemaValidationErrorSchema = _errorSchema2;

        if (Object.keys(_errors).length > 0) {
          if (_this.props.extraErrors) {
            _errorSchema2 = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.mergeObjects)(_errorSchema2, _this.props.extraErrors, !!"concat arrays");
            _errors = (0,_validate__WEBPACK_IMPORTED_MODULE_6__.toErrorList)(_errorSchema2);
          }

          _this.setState({
            errors: _errors,
            errorSchema: _errorSchema2,
            schemaValidationErrors: schemaValidationErrors,
            schemaValidationErrorSchema: schemaValidationErrorSchema
          }, function () {
            if (_this.props.onError) {
              _this.props.onError(_errors);
            } else {
              console.error("Form validation failed", _errors);
            }
          });

          return;
        }
      } // There are no errors generated through schema validation.
      // Check for user provided errors and update state accordingly.


      var errorSchema;
      var errors;

      if (_this.props.extraErrors) {
        errorSchema = _this.props.extraErrors;
        errors = (0,_validate__WEBPACK_IMPORTED_MODULE_6__.toErrorList)(errorSchema);
      } else {
        errorSchema = {};
        errors = [];
      }

      _this.setState({
        formData: newFormData,
        errors: errors,
        errorSchema: errorSchema,
        schemaValidationErrors: [],
        schemaValidationErrorSchema: {}
      }, function () {
        if (_this.props.onSubmit) {
          _this.props.onSubmit(_objectSpread({}, _this.state, {
            formData: newFormData,
            status: "submitted"
          }), event);
        }
      });
    });

    _this.state = _this.getStateFromProps(props, props.formData);

    if (_this.props.onChange && !(0,_utils__WEBPACK_IMPORTED_MODULE_5__.deepEquals)(_this.state.formData, _this.props.formData)) {
      _this.props.onChange(_this.state);
    }

    _this.formElement = null;
    return _this;
  }

  _createClass(Form, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      var nextState = this.getStateFromProps(nextProps, nextProps.formData);

      if (!(0,_utils__WEBPACK_IMPORTED_MODULE_5__.deepEquals)(nextState.formData, nextProps.formData) && !(0,_utils__WEBPACK_IMPORTED_MODULE_5__.deepEquals)(nextState.formData, this.state.formData) && this.props.onChange) {
        this.props.onChange(nextState);
      }

      this.setState(nextState);
    }
  }, {
    key: "getStateFromProps",
    value: function getStateFromProps(props, inputFormData) {
      var state = this.state || {};
      var schema = "schema" in props ? props.schema : this.props.schema;
      var uiSchema = "uiSchema" in props ? props.uiSchema : this.props.uiSchema;
      var edit = typeof inputFormData !== "undefined";
      var liveValidate = "liveValidate" in props ? props.liveValidate : this.props.liveValidate;
      var mustValidate = edit && !props.noValidate && liveValidate;
      var rootSchema = schema;
      var formData = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getDefaultFormState)(schema, inputFormData, rootSchema);
      var retrievedSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.retrieveSchema)(schema, rootSchema, formData);
      var customFormats = props.customFormats;
      var additionalMetaSchemas = props.additionalMetaSchemas;

      var getCurrentErrors = function getCurrentErrors() {
        if (props.noValidate) {
          return {
            errors: [],
            errorSchema: {}
          };
        } else if (!props.liveValidate) {
          return {
            errors: state.schemaValidationErrors || [],
            errorSchema: state.schemaValidationErrorSchema || {}
          };
        }

        return {
          errors: state.errors || [],
          errorSchema: state.errorSchema || {}
        };
      };

      var errors, errorSchema, schemaValidationErrors, schemaValidationErrorSchema;

      if (mustValidate) {
        var schemaValidation = this.validate(formData, schema, additionalMetaSchemas, customFormats);
        errors = schemaValidation.errors;
        errorSchema = schemaValidation.errorSchema;
        schemaValidationErrors = errors;
        schemaValidationErrorSchema = errorSchema;
      } else {
        var currentErrors = getCurrentErrors();
        errors = currentErrors.errors;
        errorSchema = currentErrors.errorSchema;
        schemaValidationErrors = state.schemaValidationErrors;
        schemaValidationErrorSchema = state.schemaValidationErrorSchema;
      }

      if (props.extraErrors) {
        errorSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.mergeObjects)(errorSchema, props.extraErrors, !!"concat arrays");
        errors = (0,_validate__WEBPACK_IMPORTED_MODULE_6__.toErrorList)(errorSchema);
      }

      var idSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.toIdSchema)(retrievedSchema, uiSchema["ui:rootFieldId"], rootSchema, formData, props.idPrefix);
      var nextState = {
        schema: schema,
        uiSchema: uiSchema,
        idSchema: idSchema,
        formData: formData,
        edit: edit,
        errors: errors,
        errorSchema: errorSchema,
        additionalMetaSchemas: additionalMetaSchemas
      };

      if (schemaValidationErrors) {
        nextState.schemaValidationErrors = schemaValidationErrors;
        nextState.schemaValidationErrorSchema = schemaValidationErrorSchema;
      }

      return nextState;
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return (0,_utils__WEBPACK_IMPORTED_MODULE_5__.shouldRender)(this, nextProps, nextState);
    }
  }, {
    key: "validate",
    value: function validate(formData) {
      var schema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.props.schema;
      var additionalMetaSchemas = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.props.additionalMetaSchemas;
      var customFormats = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : this.props.customFormats;
      var _this$props3 = this.props,
          validate = _this$props3.validate,
          transformErrors = _this$props3.transformErrors;

      var _this$getRegistry = this.getRegistry(),
          rootSchema = _this$getRegistry.rootSchema;

      var resolvedSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.retrieveSchema)(schema, rootSchema, formData);
      return (0,_validate__WEBPACK_IMPORTED_MODULE_6__["default"])(formData, resolvedSchema, validate, transformErrors, additionalMetaSchemas, customFormats);
    }
  }, {
    key: "renderErrors",
    value: function renderErrors() {
      var _this$state = this.state,
          errors = _this$state.errors,
          errorSchema = _this$state.errorSchema,
          schema = _this$state.schema,
          uiSchema = _this$state.uiSchema;
      var _this$props4 = this.props,
          ErrorList = _this$props4.ErrorList,
          showErrorList = _this$props4.showErrorList,
          formContext = _this$props4.formContext;

      if (errors.length && showErrorList != false) {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ErrorList, {
          errors: errors,
          errorSchema: errorSchema,
          schema: schema,
          uiSchema: uiSchema,
          formContext: formContext
        });
      }

      return null;
    }
  }, {
    key: "getRegistry",
    value: function getRegistry() {
      // For BC, accept passed SchemaField and TitleField props and pass them to
      // the "fields" registry one.
      var _getDefaultRegistry = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getDefaultRegistry)(),
          fields = _getDefaultRegistry.fields,
          widgets = _getDefaultRegistry.widgets;

      return {
        fields: _objectSpread({}, fields, this.props.fields),
        widgets: _objectSpread({}, widgets, this.props.widgets),
        ArrayFieldTemplate: this.props.ArrayFieldTemplate,
        ObjectFieldTemplate: this.props.ObjectFieldTemplate,
        FieldTemplate: this.props.FieldTemplate,
        definitions: this.props.schema.definitions || {},
        rootSchema: this.props.schema,
        formContext: this.props.formContext || {}
      };
    }
  }, {
    key: "submit",
    value: function submit() {
      if (this.formElement) {
        this.formElement.dispatchEvent(new CustomEvent("submit", {
          cancelable: true
        }));
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props5 = this.props,
          children = _this$props5.children,
          id = _this$props5.id,
          idPrefix = _this$props5.idPrefix,
          className = _this$props5.className,
          tagName = _this$props5.tagName,
          name = _this$props5.name,
          method = _this$props5.method,
          target = _this$props5.target,
          action = _this$props5.action,
          deprecatedAutocomplete = _this$props5.autocomplete,
          currentAutoComplete = _this$props5.autoComplete,
          enctype = _this$props5.enctype,
          acceptcharset = _this$props5.acceptcharset,
          noHtml5Validate = _this$props5.noHtml5Validate,
          disabled = _this$props5.disabled,
          readonly = _this$props5.readonly,
          formContext = _this$props5.formContext;
      var _this$state2 = this.state,
          schema = _this$state2.schema,
          uiSchema = _this$state2.uiSchema,
          formData = _this$state2.formData,
          errorSchema = _this$state2.errorSchema,
          idSchema = _this$state2.idSchema;
      var registry = this.getRegistry();
      var _SchemaField = registry.fields.SchemaField;
      var FormTag = tagName ? tagName : "form";

      if (deprecatedAutocomplete) {
        console.warn("Using autocomplete property of Form is deprecated, use autoComplete instead.");
      }

      var autoComplete = currentAutoComplete ? currentAutoComplete : deprecatedAutocomplete;
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FormTag, {
        className: className ? className : "rjsf",
        id: id,
        name: name,
        method: method,
        target: target,
        action: action,
        autoComplete: autoComplete,
        encType: enctype,
        acceptCharset: acceptcharset,
        noValidate: noHtml5Validate,
        onSubmit: this.onSubmit,
        ref: function ref(form) {
          _this2.formElement = form;
        }
      }, this.renderErrors(), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SchemaField, {
        schema: schema,
        uiSchema: uiSchema,
        errorSchema: errorSchema,
        idSchema: idSchema,
        idPrefix: idPrefix,
        formContext: formContext,
        formData: formData,
        onChange: this.onChange,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        registry: registry,
        disabled: disabled,
        readonly: readonly
      }), children ? children : react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
        type: "submit",
        className: "btn btn-info"
      }, "Submit")));
    }
  }]);

  return Form;
}(react__WEBPACK_IMPORTED_MODULE_0__.Component);

_defineProperty(Form, "defaultProps", {
  uiSchema: {},
  noValidate: false,
  liveValidate: false,
  disabled: false,
  readonly: false,
  noHtml5Validate: false,
  ErrorList: _ErrorList__WEBPACK_IMPORTED_MODULE_4__["default"],
  omitExtraData: false
});



if (true) {
  Form.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object.isRequired),
    uiSchema: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object),
    formData: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().any),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    widgets: prop_types__WEBPACK_IMPORTED_MODULE_7___default().objectOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)])),
    fields: prop_types__WEBPACK_IMPORTED_MODULE_7___default().objectOf((prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType)),
    ArrayFieldTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType),
    ObjectFieldTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType),
    FieldTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType),
    ErrorList: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
    onError: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
    showErrorList: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    onSubmit: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    tagName: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType),
    name: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    method: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    action: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    autocomplete: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    autoComplete: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    enctype: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    acceptcharset: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    noValidate: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    noHtml5Validate: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    liveValidate: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    validate: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
    transformErrors: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
    formContext: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object),
    customFormats: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object),
    additionalMetaSchemas: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)),
    omitExtraData: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    extraErrors: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/IconButton.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/IconButton.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }


function IconButton(props) {
  var _props$type = props.type,
      type = _props$type === void 0 ? "default" : _props$type,
      icon = props.icon,
      className = props.className,
      otherProps = _objectWithoutProperties(props, ["type", "icon", "className"]);

  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", _extends({
    type: "button",
    className: "btn btn-".concat(type, " ").concat(className)
  }, otherProps), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("i", {
    className: "glyphicon glyphicon-".concat(icon)
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21wb25lbnRzL0ljb25CdXR0b24uanMiXSwibmFtZXMiOlsiUmVhY3QiLCJJY29uQnV0dG9uIiwicHJvcHMiLCJ0eXBlIiwiaWNvbiIsImNsYXNzTmFtZSIsIm90aGVyUHJvcHMiXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLE9BQU9BLEtBQVAsTUFBa0IsT0FBbEI7QUFFQSxlQUFlLFNBQVNDLFVBQVQsQ0FBb0JDLEtBQXBCLEVBQTJCO0FBQUEsb0JBQ3FCQSxLQURyQixDQUNoQ0MsSUFEZ0M7QUFBQSxNQUNoQ0EsSUFEZ0MsNEJBQ3pCLFNBRHlCO0FBQUEsTUFDZEMsSUFEYyxHQUNxQkYsS0FEckIsQ0FDZEUsSUFEYztBQUFBLE1BQ1JDLFNBRFEsR0FDcUJILEtBRHJCLENBQ1JHLFNBRFE7QUFBQSxNQUNNQyxVQUROLDRCQUNxQkosS0FEckI7O0FBRXhDLFNBQ0U7QUFDRSxJQUFBLElBQUksRUFBQyxRQURQO0FBRUUsSUFBQSxTQUFTLG9CQUFhQyxJQUFiLGNBQXFCRSxTQUFyQjtBQUZYLEtBR01DLFVBSE4sR0FJRTtBQUFHLElBQUEsU0FBUyxnQ0FBeUJGLElBQXpCO0FBQVosSUFKRixDQURGO0FBUUQiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSBcInJlYWN0XCI7XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIEljb25CdXR0b24ocHJvcHMpIHtcbiAgY29uc3QgeyB0eXBlID0gXCJkZWZhdWx0XCIsIGljb24sIGNsYXNzTmFtZSwgLi4ub3RoZXJQcm9wcyB9ID0gcHJvcHM7XG4gIHJldHVybiAoXG4gICAgPGJ1dHRvblxuICAgICAgdHlwZT1cImJ1dHRvblwiXG4gICAgICBjbGFzc05hbWU9e2BidG4gYnRuLSR7dHlwZX0gJHtjbGFzc05hbWV9YH1cbiAgICAgIHsuLi5vdGhlclByb3BzfT5cbiAgICAgIDxpIGNsYXNzTmFtZT17YGdseXBoaWNvbiBnbHlwaGljb24tJHtpY29ufWB9IC8+XG4gICAgPC9idXR0b24+XG4gICk7XG59XG4iXX0=

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/ArrayField.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/ArrayField.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _AddButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../AddButton */ "../../node_modules/@rjsf/core/dist/es/components/AddButton.js");
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../IconButton */ "../../node_modules/@rjsf/core/dist/es/components/IconButton.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_pure_es_array_includes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js-pure/es/array/includes */ "../../node_modules/core-js-pure/es/array/includes.js");
/* harmony import */ var core_js_pure_es_array_includes__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_pure_es_array_includes__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../types */ "../../node_modules/@rjsf/core/dist/es/types.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! nanoid */ "../../node_modules/nanoid/index.browser.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }









function ArrayFieldTitle(_ref) {
  var TitleField = _ref.TitleField,
      idSchema = _ref.idSchema,
      title = _ref.title,
      required = _ref.required;

  if (!title) {
    return null;
  }

  var id = "".concat(idSchema.$id, "__title");
  return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(TitleField, {
    id: id,
    title: title,
    required: required
  });
}

function ArrayFieldDescription(_ref2) {
  var DescriptionField = _ref2.DescriptionField,
      idSchema = _ref2.idSchema,
      description = _ref2.description;

  if (!description) {
    return null;
  }

  var id = "".concat(idSchema.$id, "__description");
  return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(DescriptionField, {
    id: id,
    description: description
  });
} // Used in the two templates


function DefaultArrayItem(props) {
  var btnStyle = {
    flex: 1,
    paddingLeft: 6,
    paddingRight: 6,
    fontWeight: "bold"
  };
  return react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    key: props.key,
    className: props.className
  }, react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: props.hasToolbar ? "col-xs-9" : "col-xs-12"
  }, props.children), props.hasToolbar && react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "col-xs-3 array-item-toolbox"
  }, react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "btn-group",
    style: {
      display: "flex",
      justifyContent: "space-around"
    }
  }, (props.hasMoveUp || props.hasMoveDown) && react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], {
    icon: "arrow-up",
    "aria-label": "Move up",
    className: "array-item-move-up",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly || !props.hasMoveUp,
    onClick: props.onReorderClick(props.index, props.index - 1)
  }), (props.hasMoveUp || props.hasMoveDown) && react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], {
    icon: "arrow-down",
    className: "array-item-move-down",
    "aria-label": "Move down",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly || !props.hasMoveDown,
    onClick: props.onReorderClick(props.index, props.index + 1)
  }), props.hasRemove && react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], {
    type: "danger",
    icon: "remove",
    "aria-label": "Remove",
    className: "array-item-remove",
    tabIndex: "-1",
    style: btnStyle,
    disabled: props.disabled || props.readonly,
    onClick: props.onDropIndexClick(props.index)
  }))));
}

function DefaultFixedArrayFieldTemplate(props) {
  return react__WEBPACK_IMPORTED_MODULE_2___default().createElement("fieldset", {
    className: props.className,
    id: props.idSchema.$id
  }, react__WEBPACK_IMPORTED_MODULE_2___default().createElement(ArrayFieldTitle, {
    key: "array-field-title-".concat(props.idSchema.$id),
    TitleField: props.TitleField,
    idSchema: props.idSchema,
    title: props.uiSchema["ui:title"] || props.title,
    required: props.required
  }), (props.uiSchema["ui:description"] || props.schema.description) && react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "field-description",
    key: "field-description-".concat(props.idSchema.$id)
  }, props.uiSchema["ui:description"] || props.schema.description), react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "row array-item-list",
    key: "array-item-list-".concat(props.idSchema.$id)
  }, props.items && props.items.map(DefaultArrayItem)), props.canAdd && react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_AddButton__WEBPACK_IMPORTED_MODULE_0__["default"], {
    className: "array-item-add",
    onClick: props.onAddClick,
    disabled: props.disabled || props.readonly
  }));
}

function DefaultNormalArrayFieldTemplate(props) {
  return react__WEBPACK_IMPORTED_MODULE_2___default().createElement("fieldset", {
    className: props.className,
    id: props.idSchema.$id
  }, react__WEBPACK_IMPORTED_MODULE_2___default().createElement(ArrayFieldTitle, {
    key: "array-field-title-".concat(props.idSchema.$id),
    TitleField: props.TitleField,
    idSchema: props.idSchema,
    title: props.uiSchema["ui:title"] || props.title,
    required: props.required
  }), (props.uiSchema["ui:description"] || props.schema.description) && react__WEBPACK_IMPORTED_MODULE_2___default().createElement(ArrayFieldDescription, {
    key: "array-field-description-".concat(props.idSchema.$id),
    DescriptionField: props.DescriptionField,
    idSchema: props.idSchema,
    description: props.uiSchema["ui:description"] || props.schema.description
  }), react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "row array-item-list",
    key: "array-item-list-".concat(props.idSchema.$id)
  }, props.items && props.items.map(function (p) {
    return DefaultArrayItem(p);
  })), props.canAdd && react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_AddButton__WEBPACK_IMPORTED_MODULE_0__["default"], {
    className: "array-item-add",
    onClick: props.onAddClick,
    disabled: props.disabled || props.readonly
  }));
}

function generateRowId() {
  return (0,nanoid__WEBPACK_IMPORTED_MODULE_5__.nanoid)();
}

function generateKeyedFormData(formData) {
  return !Array.isArray(formData) ? [] : formData.map(function (item) {
    return {
      key: generateRowId(),
      item: item
    };
  });
}

function keyedToPlainFormData(keyedFormData) {
  return keyedFormData.map(function (keyedItem) {
    return keyedItem.item;
  });
}

var ArrayField =
/*#__PURE__*/
function (_Component) {
  _inherits(ArrayField, _Component);

  function ArrayField(props) {
    var _this;

    _classCallCheck(this, ArrayField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ArrayField).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "_getNewFormDataRow", function () {
      var _this$props = _this.props,
          schema = _this$props.schema,
          _this$props$registry = _this$props.registry,
          registry = _this$props$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getDefaultRegistry)() : _this$props$registry;
      var rootSchema = registry.rootSchema;
      var itemSchema = schema.items;

      if ((0,_utils__WEBPACK_IMPORTED_MODULE_4__.isFixedItems)(schema) && (0,_utils__WEBPACK_IMPORTED_MODULE_4__.allowAdditionalItems)(schema)) {
        itemSchema = schema.additionalItems;
      }

      return (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getDefaultFormState)(itemSchema, undefined, rootSchema);
    });

    _defineProperty(_assertThisInitialized(_this), "onAddClick", function (event) {
      if (event) {
        event.preventDefault();
      }

      var onChange = _this.props.onChange;
      var newKeyedFormDataRow = {
        key: generateRowId(),
        item: _this._getNewFormDataRow()
      };
      var newKeyedFormData = [].concat(_toConsumableArray(_this.state.keyedFormData), [newKeyedFormDataRow]);

      _this.setState({
        keyedFormData: newKeyedFormData,
        updatedKeyedFormData: true
      }, function () {
        return onChange(keyedToPlainFormData(newKeyedFormData));
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onAddIndexClick", function (index) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        var onChange = _this.props.onChange;
        var newKeyedFormDataRow = {
          key: generateRowId(),
          item: _this._getNewFormDataRow()
        };

        var newKeyedFormData = _toConsumableArray(_this.state.keyedFormData);

        newKeyedFormData.splice(index, 0, newKeyedFormDataRow);

        _this.setState({
          keyedFormData: newKeyedFormData,
          updatedKeyedFormData: true
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData));
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onDropIndexClick", function (index) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        var onChange = _this.props.onChange;
        var keyedFormData = _this.state.keyedFormData; // refs #195: revalidate to ensure properly reindexing errors

        var newErrorSchema;

        if (_this.props.errorSchema) {
          newErrorSchema = {};
          var errorSchema = _this.props.errorSchema;

          for (var i in errorSchema) {
            i = parseInt(i);

            if (i < index) {
              newErrorSchema[i] = errorSchema[i];
            } else if (i > index) {
              newErrorSchema[i - 1] = errorSchema[i];
            }
          }
        }

        var newKeyedFormData = keyedFormData.filter(function (_, i) {
          return i !== index;
        });

        _this.setState({
          keyedFormData: newKeyedFormData,
          updatedKeyedFormData: true
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema);
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onReorderClick", function (index, newIndex) {
      return function (event) {
        if (event) {
          event.preventDefault();
          event.target.blur();
        }

        var onChange = _this.props.onChange;
        var newErrorSchema;

        if (_this.props.errorSchema) {
          newErrorSchema = {};
          var errorSchema = _this.props.errorSchema;

          for (var i in errorSchema) {
            if (i == index) {
              newErrorSchema[newIndex] = errorSchema[index];
            } else if (i == newIndex) {
              newErrorSchema[index] = errorSchema[newIndex];
            } else {
              newErrorSchema[i] = errorSchema[i];
            }
          }
        }

        var keyedFormData = _this.state.keyedFormData;

        function reOrderArray() {
          // Copy item
          var _newKeyedFormData = keyedFormData.slice(); // Moves item from index to newIndex


          _newKeyedFormData.splice(index, 1);

          _newKeyedFormData.splice(newIndex, 0, keyedFormData[index]);

          return _newKeyedFormData;
        }

        var newKeyedFormData = reOrderArray();

        _this.setState({
          keyedFormData: newKeyedFormData
        }, function () {
          return onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema);
        });
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onChangeForIndex", function (index) {
      return function (value, errorSchema) {
        var _this$props2 = _this.props,
            formData = _this$props2.formData,
            onChange = _this$props2.onChange;
        var newFormData = formData.map(function (item, i) {
          // We need to treat undefined items as nulls to have validation.
          // See https://github.com/tdegrunt/jsonschema/issues/206
          var jsonValue = typeof value === "undefined" ? null : value;
          return index === i ? jsonValue : item;
        });
        onChange(newFormData, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, index, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onSelectChange", function (value) {
      _this.props.onChange(value);
    });

    var _formData = props.formData;

    var _keyedFormData = generateKeyedFormData(_formData);

    _this.state = {
      keyedFormData: _keyedFormData,
      updatedKeyedFormData: false
    };
    return _this;
  }

  _createClass(ArrayField, [{
    key: "isItemRequired",
    value: function isItemRequired(itemSchema) {
      if (Array.isArray(itemSchema.type)) {
        // While we don't yet support composite/nullable jsonschema types, it's
        // future-proof to check for requirement against these.
        return !core_js_pure_es_array_includes__WEBPACK_IMPORTED_MODULE_6___default()(itemSchema.type, "null");
      } // All non-null array item types are inherently required by design


      return itemSchema.type !== "null";
    }
  }, {
    key: "canAddItem",
    value: function canAddItem(formItems) {
      var _this$props3 = this.props,
          schema = _this$props3.schema,
          uiSchema = _this$props3.uiSchema;

      var _getUiOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getUiOptions)(uiSchema),
          addable = _getUiOptions.addable;

      if (addable !== false) {
        // if ui:options.addable was not explicitly set to false, we can add
        // another item if we have not exceeded maxItems yet
        if (schema.maxItems !== undefined) {
          addable = formItems.length < schema.maxItems;
        } else {
          addable = true;
        }
      }

      return addable;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          schema = _this$props4.schema,
          uiSchema = _this$props4.uiSchema,
          idSchema = _this$props4.idSchema,
          _this$props4$registry = _this$props4.registry,
          registry = _this$props4$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getDefaultRegistry)() : _this$props4$registry;
      var rootSchema = registry.rootSchema;

      if (!schema.hasOwnProperty("items")) {
        var fields = registry.fields;
        var UnsupportedField = fields.UnsupportedField;
        return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(UnsupportedField, {
          schema: schema,
          idSchema: idSchema,
          reason: "Missing items definition"
        });
      }

      if ((0,_utils__WEBPACK_IMPORTED_MODULE_4__.isFixedItems)(schema)) {
        return this.renderFixedArray();
      }

      if ((0,_utils__WEBPACK_IMPORTED_MODULE_4__.isFilesArray)(schema, uiSchema, rootSchema)) {
        return this.renderFiles();
      }

      if ((0,_utils__WEBPACK_IMPORTED_MODULE_4__.isMultiSelect)(schema, rootSchema)) {
        return this.renderMultiSelect();
      }

      return this.renderNormalArray();
    }
  }, {
    key: "renderNormalArray",
    value: function renderNormalArray() {
      var _this2 = this;

      var _this$props5 = this.props,
          schema = _this$props5.schema,
          uiSchema = _this$props5.uiSchema,
          errorSchema = _this$props5.errorSchema,
          idSchema = _this$props5.idSchema,
          name = _this$props5.name,
          required = _this$props5.required,
          disabled = _this$props5.disabled,
          readonly = _this$props5.readonly,
          autofocus = _this$props5.autofocus,
          _this$props5$registry = _this$props5.registry,
          registry = _this$props5$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getDefaultRegistry)() : _this$props5$registry,
          onBlur = _this$props5.onBlur,
          onFocus = _this$props5.onFocus,
          idPrefix = _this$props5.idPrefix,
          rawErrors = _this$props5.rawErrors;
      var title = schema.title === undefined ? name : schema.title;
      var ArrayFieldTemplate = registry.ArrayFieldTemplate,
          rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var TitleField = fields.TitleField,
          DescriptionField = fields.DescriptionField;
      var itemsSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.retrieveSchema)(schema.items, rootSchema);
      var formData = keyedToPlainFormData(this.state.keyedFormData);
      var arrayProps = {
        canAdd: this.canAddItem(formData),
        items: this.state.keyedFormData.map(function (keyedItem, index) {
          var key = keyedItem.key,
              item = keyedItem.item;
          var itemSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.retrieveSchema)(schema.items, rootSchema, item);
          var itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
          var itemIdPrefix = idSchema.$id + "_" + index;
          var itemIdSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.toIdSchema)(itemSchema, itemIdPrefix, rootSchema, item, idPrefix);
          return _this2.renderArrayFieldItem({
            key: key,
            index: index,
            canMoveUp: index > 0,
            canMoveDown: index < formData.length - 1,
            itemSchema: itemSchema,
            itemIdSchema: itemIdSchema,
            itemErrorSchema: itemErrorSchema,
            itemData: item,
            itemUiSchema: uiSchema.items,
            autofocus: autofocus && index === 0,
            onBlur: onBlur,
            onFocus: onFocus
          });
        }),
        className: "field field-array field-array-of-".concat(itemsSchema.type),
        DescriptionField: DescriptionField,
        disabled: disabled,
        idSchema: idSchema,
        uiSchema: uiSchema,
        onAddClick: this.onAddClick,
        readonly: readonly,
        required: required,
        schema: schema,
        title: title,
        TitleField: TitleField,
        formContext: formContext,
        formData: formData,
        rawErrors: rawErrors,
        registry: registry
      }; // Check if a custom render function was passed in

      var Component = uiSchema["ui:ArrayFieldTemplate"] || ArrayFieldTemplate || DefaultNormalArrayFieldTemplate;
      return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Component, arrayProps);
    }
  }, {
    key: "renderMultiSelect",
    value: function renderMultiSelect() {
      var _this$props6 = this.props,
          schema = _this$props6.schema,
          idSchema = _this$props6.idSchema,
          uiSchema = _this$props6.uiSchema,
          formData = _this$props6.formData,
          disabled = _this$props6.disabled,
          readonly = _this$props6.readonly,
          required = _this$props6.required,
          placeholder = _this$props6.placeholder,
          autofocus = _this$props6.autofocus,
          onBlur = _this$props6.onBlur,
          onFocus = _this$props6.onFocus,
          _this$props6$registry = _this$props6.registry,
          registry = _this$props6$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getDefaultRegistry)() : _this$props6$registry,
          rawErrors = _this$props6.rawErrors,
          name = _this$props6.name;
      var items = this.props.formData;
      var widgets = registry.widgets,
          rootSchema = registry.rootSchema,
          formContext = registry.formContext;
      var itemsSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.retrieveSchema)(schema.items, rootSchema, formData);
      var title = schema.title || name;
      var enumOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.optionsList)(itemsSchema);

      var _getUiOptions$enumOpt = _objectSpread({}, (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getUiOptions)(uiSchema), {
        enumOptions: enumOptions
      }),
          _getUiOptions$enumOpt2 = _getUiOptions$enumOpt.widget,
          widget = _getUiOptions$enumOpt2 === void 0 ? "select" : _getUiOptions$enumOpt2,
          options = _objectWithoutProperties(_getUiOptions$enumOpt, ["widget"]);

      var Widget = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getWidget)(schema, widget, widgets);
      return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Widget, {
        id: idSchema && idSchema.$id,
        multiple: true,
        onChange: this.onSelectChange,
        onBlur: onBlur,
        onFocus: onFocus,
        options: options,
        schema: schema,
        registry: registry,
        value: items,
        disabled: disabled,
        readonly: readonly,
        required: required,
        label: title,
        placeholder: placeholder,
        formContext: formContext,
        autofocus: autofocus,
        rawErrors: rawErrors
      });
    }
  }, {
    key: "renderFiles",
    value: function renderFiles() {
      var _this$props7 = this.props,
          schema = _this$props7.schema,
          uiSchema = _this$props7.uiSchema,
          idSchema = _this$props7.idSchema,
          name = _this$props7.name,
          disabled = _this$props7.disabled,
          readonly = _this$props7.readonly,
          autofocus = _this$props7.autofocus,
          onBlur = _this$props7.onBlur,
          onFocus = _this$props7.onFocus,
          _this$props7$registry = _this$props7.registry,
          registry = _this$props7$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getDefaultRegistry)() : _this$props7$registry,
          rawErrors = _this$props7.rawErrors;
      var title = schema.title || name;
      var items = this.props.formData;
      var widgets = registry.widgets,
          formContext = registry.formContext;

      var _getUiOptions2 = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getUiOptions)(uiSchema),
          _getUiOptions2$widget = _getUiOptions2.widget,
          widget = _getUiOptions2$widget === void 0 ? "files" : _getUiOptions2$widget,
          options = _objectWithoutProperties(_getUiOptions2, ["widget"]);

      var Widget = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getWidget)(schema, widget, widgets);
      return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Widget, {
        options: options,
        id: idSchema && idSchema.$id,
        multiple: true,
        onChange: this.onSelectChange,
        onBlur: onBlur,
        onFocus: onFocus,
        schema: schema,
        title: title,
        value: items,
        disabled: disabled,
        readonly: readonly,
        formContext: formContext,
        autofocus: autofocus,
        rawErrors: rawErrors
      });
    }
  }, {
    key: "renderFixedArray",
    value: function renderFixedArray() {
      var _this3 = this;

      var _this$props8 = this.props,
          schema = _this$props8.schema,
          uiSchema = _this$props8.uiSchema,
          formData = _this$props8.formData,
          errorSchema = _this$props8.errorSchema,
          idPrefix = _this$props8.idPrefix,
          idSchema = _this$props8.idSchema,
          name = _this$props8.name,
          required = _this$props8.required,
          disabled = _this$props8.disabled,
          readonly = _this$props8.readonly,
          autofocus = _this$props8.autofocus,
          _this$props8$registry = _this$props8.registry,
          registry = _this$props8$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getDefaultRegistry)() : _this$props8$registry,
          onBlur = _this$props8.onBlur,
          onFocus = _this$props8.onFocus,
          rawErrors = _this$props8.rawErrors;
      var title = schema.title || name;
      var items = this.props.formData;
      var ArrayFieldTemplate = registry.ArrayFieldTemplate,
          rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var TitleField = fields.TitleField;
      var itemSchemas = schema.items.map(function (item, index) {
        return (0,_utils__WEBPACK_IMPORTED_MODULE_4__.retrieveSchema)(item, rootSchema, formData[index]);
      });
      var additionalSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.allowAdditionalItems)(schema) ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.retrieveSchema)(schema.additionalItems, rootSchema, formData) : null;

      if (!items || items.length < itemSchemas.length) {
        // to make sure at least all fixed items are generated
        items = items || [];
        items = items.concat(new Array(itemSchemas.length - items.length));
      } // These are the props passed into the render function


      var arrayProps = {
        canAdd: this.canAddItem(items) && additionalSchema,
        className: "field field-array field-array-fixed-items",
        disabled: disabled,
        idSchema: idSchema,
        formData: formData,
        items: this.state.keyedFormData.map(function (keyedItem, index) {
          var key = keyedItem.key,
              item = keyedItem.item;
          var additional = index >= itemSchemas.length;
          var itemSchema = additional ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.retrieveSchema)(schema.additionalItems, rootSchema, item) : itemSchemas[index];
          var itemIdPrefix = idSchema.$id + "_" + index;
          var itemIdSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.toIdSchema)(itemSchema, itemIdPrefix, rootSchema, item, idPrefix);
          var itemUiSchema = additional ? uiSchema.additionalItems || {} : Array.isArray(uiSchema.items) ? uiSchema.items[index] : uiSchema.items || {};
          var itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
          return _this3.renderArrayFieldItem({
            key: key,
            index: index,
            canRemove: additional,
            canMoveUp: index >= itemSchemas.length + 1,
            canMoveDown: additional && index < items.length - 1,
            itemSchema: itemSchema,
            itemData: item,
            itemUiSchema: itemUiSchema,
            itemIdSchema: itemIdSchema,
            itemErrorSchema: itemErrorSchema,
            autofocus: autofocus && index === 0,
            onBlur: onBlur,
            onFocus: onFocus
          });
        }),
        onAddClick: this.onAddClick,
        readonly: readonly,
        required: required,
        schema: schema,
        uiSchema: uiSchema,
        title: title,
        TitleField: TitleField,
        formContext: formContext,
        rawErrors: rawErrors
      }; // Check if a custom template template was passed in

      var Template = uiSchema["ui:ArrayFieldTemplate"] || ArrayFieldTemplate || DefaultFixedArrayFieldTemplate;
      return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Template, arrayProps);
    }
  }, {
    key: "renderArrayFieldItem",
    value: function renderArrayFieldItem(props) {
      var key = props.key,
          index = props.index,
          _props$canRemove = props.canRemove,
          canRemove = _props$canRemove === void 0 ? true : _props$canRemove,
          _props$canMoveUp = props.canMoveUp,
          canMoveUp = _props$canMoveUp === void 0 ? true : _props$canMoveUp,
          _props$canMoveDown = props.canMoveDown,
          canMoveDown = _props$canMoveDown === void 0 ? true : _props$canMoveDown,
          itemSchema = props.itemSchema,
          itemData = props.itemData,
          itemUiSchema = props.itemUiSchema,
          itemIdSchema = props.itemIdSchema,
          itemErrorSchema = props.itemErrorSchema,
          autofocus = props.autofocus,
          onBlur = props.onBlur,
          onFocus = props.onFocus,
          rawErrors = props.rawErrors;
      var _this$props9 = this.props,
          disabled = _this$props9.disabled,
          readonly = _this$props9.readonly,
          uiSchema = _this$props9.uiSchema,
          _this$props9$registry = _this$props9.registry,
          registry = _this$props9$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getDefaultRegistry)() : _this$props9$registry;
      var SchemaField = registry.fields.SchemaField;

      var _orderable$removable$ = _objectSpread({
        orderable: true,
        removable: true
      }, uiSchema["ui:options"]),
          orderable = _orderable$removable$.orderable,
          removable = _orderable$removable$.removable;

      var has = {
        moveUp: orderable && canMoveUp,
        moveDown: orderable && canMoveDown,
        remove: removable && canRemove
      };
      has.toolbar = Object.keys(has).some(function (key) {
        return has[key];
      });
      return {
        children: react__WEBPACK_IMPORTED_MODULE_2___default().createElement(SchemaField, {
          index: index,
          schema: itemSchema,
          uiSchema: itemUiSchema,
          formData: itemData,
          errorSchema: itemErrorSchema,
          idSchema: itemIdSchema,
          required: this.isItemRequired(itemSchema),
          onChange: this.onChangeForIndex(index),
          onBlur: onBlur,
          onFocus: onFocus,
          registry: this.props.registry,
          disabled: this.props.disabled,
          readonly: this.props.readonly,
          autofocus: autofocus,
          rawErrors: rawErrors
        }),
        className: "array-item",
        disabled: disabled,
        hasToolbar: has.toolbar,
        hasMoveUp: has.moveUp,
        hasMoveDown: has.moveDown,
        hasRemove: has.remove,
        index: index,
        key: key,
        onAddIndexClick: this.onAddIndexClick,
        onDropIndexClick: this.onDropIndexClick,
        onReorderClick: this.onReorderClick,
        readonly: readonly
      };
    }
  }, {
    key: "itemTitle",
    get: function get() {
      var schema = this.props.schema;
      return schema.items.title || schema.items.description || "Item";
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      // Don't call getDerivedStateFromProps if keyed formdata was just updated.
      if (prevState.updatedKeyedFormData) {
        return {
          updatedKeyedFormData: false
        };
      }

      var nextFormData = nextProps.formData || [];
      var previousKeyedFormData = prevState.keyedFormData || [];
      var newKeyedFormData = nextFormData.length === previousKeyedFormData.length ? previousKeyedFormData.map(function (previousKeyedFormDatum, index) {
        return {
          key: previousKeyedFormDatum.key,
          item: nextFormData[index]
        };
      }) : generateKeyedFormData(nextFormData);
      return {
        keyedFormData: newKeyedFormData
      };
    }
  }]);

  return ArrayField;
}(react__WEBPACK_IMPORTED_MODULE_2__.Component);

_defineProperty(ArrayField, "defaultProps", {
  uiSchema: {},
  formData: [],
  idSchema: {},
  required: false,
  disabled: false,
  readonly: false,
  autofocus: false
});

if (true) {
  ArrayField.propTypes = _types__WEBPACK_IMPORTED_MODULE_3__.fieldProps;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ArrayField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/BooleanField.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/BooleanField.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../types */ "../../node_modules/@rjsf/core/dist/es/types.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }





function BooleanField(props) {
  var schema = props.schema,
      name = props.name,
      uiSchema = props.uiSchema,
      idSchema = props.idSchema,
      formData = props.formData,
      _props$registry = props.registry,
      registry = _props$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getDefaultRegistry)() : _props$registry,
      required = props.required,
      disabled = props.disabled,
      readonly = props.readonly,
      autofocus = props.autofocus,
      onChange = props.onChange,
      onFocus = props.onFocus,
      onBlur = props.onBlur,
      rawErrors = props.rawErrors;
  var title = schema.title;
  var widgets = registry.widgets,
      formContext = registry.formContext,
      fields = registry.fields;

  var _getUiOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema),
      _getUiOptions$widget = _getUiOptions.widget,
      widget = _getUiOptions$widget === void 0 ? "checkbox" : _getUiOptions$widget,
      options = _objectWithoutProperties(_getUiOptions, ["widget"]);

  var Widget = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);
  var enumOptions;

  if (Array.isArray(schema.oneOf)) {
    enumOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.optionsList)({
      oneOf: schema.oneOf.map(function (option) {
        return _objectSpread({}, option, {
          title: option.title || (option["const"] === true ? "Yes" : "No")
        });
      })
    });
  } else {
    enumOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.optionsList)({
      "enum": schema["enum"] || [true, false],
      enumNames: schema.enumNames || (schema["enum"] && schema["enum"][0] === false ? ["No", "Yes"] : ["Yes", "No"])
    });
  }

  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Widget, {
    options: _objectSpread({}, options, {
      enumOptions: enumOptions
    }),
    schema: schema,
    uiSchema: uiSchema,
    id: idSchema && idSchema.$id,
    onChange: onChange,
    onFocus: onFocus,
    onBlur: onBlur,
    label: title === undefined ? name : title,
    value: formData,
    required: required,
    disabled: disabled,
    readonly: readonly,
    registry: registry,
    formContext: formContext,
    autofocus: autofocus,
    rawErrors: rawErrors,
    DescriptionField: fields.DescriptionField
  });
}

if (true) {
  BooleanField.propTypes = _types__WEBPACK_IMPORTED_MODULE_1__.fieldProps;
}

BooleanField.defaultProps = {
  uiSchema: {},
  disabled: false,
  readonly: false,
  autofocus: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BooleanField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL2ZpZWxkcy9Cb29sZWFuRmllbGQuanMiXSwibmFtZXMiOlsiUmVhY3QiLCJ0eXBlcyIsImdldFdpZGdldCIsImdldFVpT3B0aW9ucyIsIm9wdGlvbnNMaXN0IiwiZ2V0RGVmYXVsdFJlZ2lzdHJ5IiwiQm9vbGVhbkZpZWxkIiwicHJvcHMiLCJzY2hlbWEiLCJuYW1lIiwidWlTY2hlbWEiLCJpZFNjaGVtYSIsImZvcm1EYXRhIiwicmVnaXN0cnkiLCJyZXF1aXJlZCIsImRpc2FibGVkIiwicmVhZG9ubHkiLCJhdXRvZm9jdXMiLCJvbkNoYW5nZSIsIm9uRm9jdXMiLCJvbkJsdXIiLCJyYXdFcnJvcnMiLCJ0aXRsZSIsIndpZGdldHMiLCJmb3JtQ29udGV4dCIsImZpZWxkcyIsIndpZGdldCIsIm9wdGlvbnMiLCJXaWRnZXQiLCJlbnVtT3B0aW9ucyIsIkFycmF5IiwiaXNBcnJheSIsIm9uZU9mIiwibWFwIiwib3B0aW9uIiwiZW51bU5hbWVzIiwiJGlkIiwidW5kZWZpbmVkIiwiRGVzY3JpcHRpb25GaWVsZCIsInByb2Nlc3MiLCJlbnYiLCJOT0RFX0VOViIsInByb3BUeXBlcyIsImZpZWxkUHJvcHMiLCJkZWZhdWx0UHJvcHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBQUEsT0FBT0EsS0FBUCxNQUFrQixPQUFsQjtBQUNBLE9BQU8sS0FBS0MsS0FBWixNQUF1QixhQUF2QjtBQUVBLFNBQ0VDLFNBREYsRUFFRUMsWUFGRixFQUdFQyxXQUhGLEVBSUVDLGtCQUpGLFFBS08sYUFMUDs7QUFPQSxTQUFTQyxZQUFULENBQXNCQyxLQUF0QixFQUE2QjtBQUFBLE1BRXpCQyxNQUZ5QixHQWdCdkJELEtBaEJ1QixDQUV6QkMsTUFGeUI7QUFBQSxNQUd6QkMsSUFIeUIsR0FnQnZCRixLQWhCdUIsQ0FHekJFLElBSHlCO0FBQUEsTUFJekJDLFFBSnlCLEdBZ0J2QkgsS0FoQnVCLENBSXpCRyxRQUp5QjtBQUFBLE1BS3pCQyxRQUx5QixHQWdCdkJKLEtBaEJ1QixDQUt6QkksUUFMeUI7QUFBQSxNQU16QkMsUUFOeUIsR0FnQnZCTCxLQWhCdUIsQ0FNekJLLFFBTnlCO0FBQUEsd0JBZ0J2QkwsS0FoQnVCLENBT3pCTSxRQVB5QjtBQUFBLE1BT3pCQSxRQVB5QixnQ0FPZFIsa0JBQWtCLEVBUEo7QUFBQSxNQVF6QlMsUUFSeUIsR0FnQnZCUCxLQWhCdUIsQ0FRekJPLFFBUnlCO0FBQUEsTUFTekJDLFFBVHlCLEdBZ0J2QlIsS0FoQnVCLENBU3pCUSxRQVR5QjtBQUFBLE1BVXpCQyxRQVZ5QixHQWdCdkJULEtBaEJ1QixDQVV6QlMsUUFWeUI7QUFBQSxNQVd6QkMsU0FYeUIsR0FnQnZCVixLQWhCdUIsQ0FXekJVLFNBWHlCO0FBQUEsTUFZekJDLFFBWnlCLEdBZ0J2QlgsS0FoQnVCLENBWXpCVyxRQVp5QjtBQUFBLE1BYXpCQyxPQWJ5QixHQWdCdkJaLEtBaEJ1QixDQWF6QlksT0FieUI7QUFBQSxNQWN6QkMsTUFkeUIsR0FnQnZCYixLQWhCdUIsQ0FjekJhLE1BZHlCO0FBQUEsTUFlekJDLFNBZnlCLEdBZ0J2QmQsS0FoQnVCLENBZXpCYyxTQWZ5QjtBQUFBLE1BaUJuQkMsS0FqQm1CLEdBaUJUZCxNQWpCUyxDQWlCbkJjLEtBakJtQjtBQUFBLE1Ba0JuQkMsT0FsQm1CLEdBa0JjVixRQWxCZCxDQWtCbkJVLE9BbEJtQjtBQUFBLE1Ba0JWQyxXQWxCVSxHQWtCY1gsUUFsQmQsQ0FrQlZXLFdBbEJVO0FBQUEsTUFrQkdDLE1BbEJILEdBa0JjWixRQWxCZCxDQWtCR1ksTUFsQkg7O0FBQUEsc0JBbUJpQnRCLFlBQVksQ0FBQ08sUUFBRCxDQW5CN0I7QUFBQSwyQ0FtQm5CZ0IsTUFuQm1CO0FBQUEsTUFtQm5CQSxNQW5CbUIscUNBbUJWLFVBbkJVO0FBQUEsTUFtQktDLE9BbkJMOztBQW9CM0IsTUFBTUMsTUFBTSxHQUFHMUIsU0FBUyxDQUFDTSxNQUFELEVBQVNrQixNQUFULEVBQWlCSCxPQUFqQixDQUF4QjtBQUVBLE1BQUlNLFdBQUo7O0FBRUEsTUFBSUMsS0FBSyxDQUFDQyxPQUFOLENBQWN2QixNQUFNLENBQUN3QixLQUFyQixDQUFKLEVBQWlDO0FBQy9CSCxJQUFBQSxXQUFXLEdBQUd6QixXQUFXLENBQUM7QUFDeEI0QixNQUFBQSxLQUFLLEVBQUV4QixNQUFNLENBQUN3QixLQUFQLENBQWFDLEdBQWIsQ0FBaUIsVUFBQUMsTUFBTTtBQUFBLGlDQUN6QkEsTUFEeUI7QUFFNUJaLFVBQUFBLEtBQUssRUFBRVksTUFBTSxDQUFDWixLQUFQLEtBQWlCWSxNQUFNLFNBQU4sS0FBaUIsSUFBakIsR0FBd0IsS0FBeEIsR0FBZ0MsSUFBakQ7QUFGcUI7QUFBQSxPQUF2QjtBQURpQixLQUFELENBQXpCO0FBTUQsR0FQRCxNQU9PO0FBQ0xMLElBQUFBLFdBQVcsR0FBR3pCLFdBQVcsQ0FBQztBQUN4QixjQUFNSSxNQUFNLFFBQU4sSUFBZSxDQUFDLElBQUQsRUFBTyxLQUFQLENBREc7QUFFeEIyQixNQUFBQSxTQUFTLEVBQ1AzQixNQUFNLENBQUMyQixTQUFQLEtBQ0MzQixNQUFNLFFBQU4sSUFBZUEsTUFBTSxRQUFOLENBQVksQ0FBWixNQUFtQixLQUFsQyxHQUNHLENBQUMsSUFBRCxFQUFPLEtBQVAsQ0FESCxHQUVHLENBQUMsS0FBRCxFQUFRLElBQVIsQ0FISjtBQUhzQixLQUFELENBQXpCO0FBUUQ7O0FBRUQsU0FDRSxvQkFBQyxNQUFEO0FBQ0UsSUFBQSxPQUFPLG9CQUFPbUIsT0FBUDtBQUFnQkUsTUFBQUEsV0FBVyxFQUFYQTtBQUFoQixNQURUO0FBRUUsSUFBQSxNQUFNLEVBQUVyQixNQUZWO0FBR0UsSUFBQSxRQUFRLEVBQUVFLFFBSFo7QUFJRSxJQUFBLEVBQUUsRUFBRUMsUUFBUSxJQUFJQSxRQUFRLENBQUN5QixHQUozQjtBQUtFLElBQUEsUUFBUSxFQUFFbEIsUUFMWjtBQU1FLElBQUEsT0FBTyxFQUFFQyxPQU5YO0FBT0UsSUFBQSxNQUFNLEVBQUVDLE1BUFY7QUFRRSxJQUFBLEtBQUssRUFBRUUsS0FBSyxLQUFLZSxTQUFWLEdBQXNCNUIsSUFBdEIsR0FBNkJhLEtBUnRDO0FBU0UsSUFBQSxLQUFLLEVBQUVWLFFBVFQ7QUFVRSxJQUFBLFFBQVEsRUFBRUUsUUFWWjtBQVdFLElBQUEsUUFBUSxFQUFFQyxRQVhaO0FBWUUsSUFBQSxRQUFRLEVBQUVDLFFBWlo7QUFhRSxJQUFBLFFBQVEsRUFBRUgsUUFiWjtBQWNFLElBQUEsV0FBVyxFQUFFVyxXQWRmO0FBZUUsSUFBQSxTQUFTLEVBQUVQLFNBZmI7QUFnQkUsSUFBQSxTQUFTLEVBQUVJLFNBaEJiO0FBaUJFLElBQUEsZ0JBQWdCLEVBQUVJLE1BQU0sQ0FBQ2E7QUFqQjNCLElBREY7QUFxQkQ7O0FBRUQsSUFBSUMsT0FBTyxDQUFDQyxHQUFSLENBQVlDLFFBQVosS0FBeUIsWUFBN0IsRUFBMkM7QUFDekNuQyxFQUFBQSxZQUFZLENBQUNvQyxTQUFiLEdBQXlCekMsS0FBSyxDQUFDMEMsVUFBL0I7QUFDRDs7QUFFRHJDLFlBQVksQ0FBQ3NDLFlBQWIsR0FBNEI7QUFDMUJsQyxFQUFBQSxRQUFRLEVBQUUsRUFEZ0I7QUFFMUJLLEVBQUFBLFFBQVEsRUFBRSxLQUZnQjtBQUcxQkMsRUFBQUEsUUFBUSxFQUFFLEtBSGdCO0FBSTFCQyxFQUFBQSxTQUFTLEVBQUU7QUFKZSxDQUE1QjtBQU9BLGVBQWVYLFlBQWYiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSBcInJlYWN0XCI7XG5pbXBvcnQgKiBhcyB0eXBlcyBmcm9tIFwiLi4vLi4vdHlwZXNcIjtcblxuaW1wb3J0IHtcbiAgZ2V0V2lkZ2V0LFxuICBnZXRVaU9wdGlvbnMsXG4gIG9wdGlvbnNMaXN0LFxuICBnZXREZWZhdWx0UmVnaXN0cnksXG59IGZyb20gXCIuLi8uLi91dGlsc1wiO1xuXG5mdW5jdGlvbiBCb29sZWFuRmllbGQocHJvcHMpIHtcbiAgY29uc3Qge1xuICAgIHNjaGVtYSxcbiAgICBuYW1lLFxuICAgIHVpU2NoZW1hLFxuICAgIGlkU2NoZW1hLFxuICAgIGZvcm1EYXRhLFxuICAgIHJlZ2lzdHJ5ID0gZ2V0RGVmYXVsdFJlZ2lzdHJ5KCksXG4gICAgcmVxdWlyZWQsXG4gICAgZGlzYWJsZWQsXG4gICAgcmVhZG9ubHksXG4gICAgYXV0b2ZvY3VzLFxuICAgIG9uQ2hhbmdlLFxuICAgIG9uRm9jdXMsXG4gICAgb25CbHVyLFxuICAgIHJhd0Vycm9ycyxcbiAgfSA9IHByb3BzO1xuICBjb25zdCB7IHRpdGxlIH0gPSBzY2hlbWE7XG4gIGNvbnN0IHsgd2lkZ2V0cywgZm9ybUNvbnRleHQsIGZpZWxkcyB9ID0gcmVnaXN0cnk7XG4gIGNvbnN0IHsgd2lkZ2V0ID0gXCJjaGVja2JveFwiLCAuLi5vcHRpb25zIH0gPSBnZXRVaU9wdGlvbnModWlTY2hlbWEpO1xuICBjb25zdCBXaWRnZXQgPSBnZXRXaWRnZXQoc2NoZW1hLCB3aWRnZXQsIHdpZGdldHMpO1xuXG4gIGxldCBlbnVtT3B0aW9ucztcblxuICBpZiAoQXJyYXkuaXNBcnJheShzY2hlbWEub25lT2YpKSB7XG4gICAgZW51bU9wdGlvbnMgPSBvcHRpb25zTGlzdCh7XG4gICAgICBvbmVPZjogc2NoZW1hLm9uZU9mLm1hcChvcHRpb24gPT4gKHtcbiAgICAgICAgLi4ub3B0aW9uLFxuICAgICAgICB0aXRsZTogb3B0aW9uLnRpdGxlIHx8IChvcHRpb24uY29uc3QgPT09IHRydWUgPyBcIlllc1wiIDogXCJOb1wiKSxcbiAgICAgIH0pKSxcbiAgICB9KTtcbiAgfSBlbHNlIHtcbiAgICBlbnVtT3B0aW9ucyA9IG9wdGlvbnNMaXN0KHtcbiAgICAgIGVudW06IHNjaGVtYS5lbnVtIHx8IFt0cnVlLCBmYWxzZV0sXG4gICAgICBlbnVtTmFtZXM6XG4gICAgICAgIHNjaGVtYS5lbnVtTmFtZXMgfHxcbiAgICAgICAgKHNjaGVtYS5lbnVtICYmIHNjaGVtYS5lbnVtWzBdID09PSBmYWxzZVxuICAgICAgICAgID8gW1wiTm9cIiwgXCJZZXNcIl1cbiAgICAgICAgICA6IFtcIlllc1wiLCBcIk5vXCJdKSxcbiAgICB9KTtcbiAgfVxuXG4gIHJldHVybiAoXG4gICAgPFdpZGdldFxuICAgICAgb3B0aW9ucz17eyAuLi5vcHRpb25zLCBlbnVtT3B0aW9ucyB9fVxuICAgICAgc2NoZW1hPXtzY2hlbWF9XG4gICAgICB1aVNjaGVtYT17dWlTY2hlbWF9XG4gICAgICBpZD17aWRTY2hlbWEgJiYgaWRTY2hlbWEuJGlkfVxuICAgICAgb25DaGFuZ2U9e29uQ2hhbmdlfVxuICAgICAgb25Gb2N1cz17b25Gb2N1c31cbiAgICAgIG9uQmx1cj17b25CbHVyfVxuICAgICAgbGFiZWw9e3RpdGxlID09PSB1bmRlZmluZWQgPyBuYW1lIDogdGl0bGV9XG4gICAgICB2YWx1ZT17Zm9ybURhdGF9XG4gICAgICByZXF1aXJlZD17cmVxdWlyZWR9XG4gICAgICBkaXNhYmxlZD17ZGlzYWJsZWR9XG4gICAgICByZWFkb25seT17cmVhZG9ubHl9XG4gICAgICByZWdpc3RyeT17cmVnaXN0cnl9XG4gICAgICBmb3JtQ29udGV4dD17Zm9ybUNvbnRleHR9XG4gICAgICBhdXRvZm9jdXM9e2F1dG9mb2N1c31cbiAgICAgIHJhd0Vycm9ycz17cmF3RXJyb3JzfVxuICAgICAgRGVzY3JpcHRpb25GaWVsZD17ZmllbGRzLkRlc2NyaXB0aW9uRmllbGR9XG4gICAgLz5cbiAgKTtcbn1cblxuaWYgKHByb2Nlc3MuZW52Lk5PREVfRU5WICE9PSBcInByb2R1Y3Rpb25cIikge1xuICBCb29sZWFuRmllbGQucHJvcFR5cGVzID0gdHlwZXMuZmllbGRQcm9wcztcbn1cblxuQm9vbGVhbkZpZWxkLmRlZmF1bHRQcm9wcyA9IHtcbiAgdWlTY2hlbWE6IHt9LFxuICBkaXNhYmxlZDogZmFsc2UsXG4gIHJlYWRvbmx5OiBmYWxzZSxcbiAgYXV0b2ZvY3VzOiBmYWxzZSxcbn07XG5cbmV4cG9ydCBkZWZhdWx0IEJvb2xlYW5GaWVsZDtcbiJdfQ==

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/DescriptionField.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/DescriptionField.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



function DescriptionField(props) {
  var id = props.id,
      description = props.description;

  if (!description) {
    return null;
  }

  if (typeof description === "string") {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", {
      id: id,
      className: "field-description"
    }, description);
  } else {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      id: id,
      className: "field-description"
    }, description);
  }
}

if (true) {
  DescriptionField.propTypes = {
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    description: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().element)])
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DescriptionField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/MultiSchemaField.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/MultiSchemaField.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../types */ "../../node_modules/@rjsf/core/dist/es/types.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






var AnyOfField =
/*#__PURE__*/
function (_Component) {
  _inherits(AnyOfField, _Component);

  function AnyOfField(props) {
    var _this;

    _classCallCheck(this, AnyOfField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AnyOfField).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "onOptionChange", function (option) {
      var selectedOption = parseInt(option, 10);
      var _this$props = _this.props,
          formData = _this$props.formData,
          onChange = _this$props.onChange,
          options = _this$props.options,
          registry = _this$props.registry;
      var rootSchema = registry.rootSchema;
      var newOption = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.retrieveSchema)(options[selectedOption], rootSchema, formData); // If the new option is of type object and the current data is an object,
      // discard properties added using the old option.

      var newFormData = undefined;

      if ((0,_utils__WEBPACK_IMPORTED_MODULE_2__.guessType)(formData) === "object" && (newOption.type === "object" || newOption.properties)) {
        newFormData = Object.assign({}, formData);
        var optionsToDiscard = options.slice();
        optionsToDiscard.splice(selectedOption, 1); // Discard any data added using other options

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = optionsToDiscard[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var _option = _step.value;

            if (_option.properties) {
              for (var key in _option.properties) {
                if (newFormData.hasOwnProperty(key)) {
                  delete newFormData[key];
                }
              }
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
              _iterator["return"]();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      } // Call getDefaultFormState to make sure defaults are populated on change.


      onChange((0,_utils__WEBPACK_IMPORTED_MODULE_2__.getDefaultFormState)(options[selectedOption], newFormData, rootSchema));

      _this.setState({
        selectedOption: parseInt(option, 10)
      });
    });

    var _this$props2 = _this.props,
        _formData = _this$props2.formData,
        _options = _this$props2.options;
    _this.state = {
      selectedOption: _this.getMatchingOption(_formData, _options)
    };
    return _this;
  }

  _createClass(AnyOfField, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (!(0,_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(this.props.formData, prevProps.formData) && this.props.idSchema.$id === prevProps.idSchema.$id) {
        var matchingOption = this.getMatchingOption(this.props.formData, this.props.options);

        if (!prevState || matchingOption === this.state.selectedOption) {
          return;
        }

        this.setState({
          selectedOption: matchingOption
        });
      }
    }
  }, {
    key: "getMatchingOption",
    value: function getMatchingOption(formData, options) {
      var rootSchema = this.props.registry.rootSchema;

      var option = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getMatchingOption)(formData, options, rootSchema);

      if (option !== 0) {
        return option;
      } // If the form data matches none of the options, use the currently selected
      // option, assuming it's available; otherwise use the first option


      return this && this.state ? this.state.selectedOption : 0;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          baseType = _this$props3.baseType,
          disabled = _this$props3.disabled,
          errorSchema = _this$props3.errorSchema,
          formData = _this$props3.formData,
          idPrefix = _this$props3.idPrefix,
          idSchema = _this$props3.idSchema,
          onBlur = _this$props3.onBlur,
          onChange = _this$props3.onChange,
          onFocus = _this$props3.onFocus,
          options = _this$props3.options,
          registry = _this$props3.registry,
          uiSchema = _this$props3.uiSchema,
          schema = _this$props3.schema;
      var _SchemaField = registry.fields.SchemaField;
      var widgets = registry.widgets;
      var selectedOption = this.state.selectedOption;

      var _getUiOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema),
          _getUiOptions$widget = _getUiOptions.widget,
          widget = _getUiOptions$widget === void 0 ? "select" : _getUiOptions$widget,
          uiOptions = _objectWithoutProperties(_getUiOptions, ["widget"]);

      var Widget = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)({
        type: "number"
      }, widget, widgets);
      var option = options[selectedOption] || null;
      var optionSchema;

      if (option) {
        // If the subschema doesn't declare a type, infer the type from the
        // parent schema
        optionSchema = option.type ? option : Object.assign({}, option, {
          type: baseType
        });
      }

      var enumOptions = options.map(function (option, index) {
        return {
          label: option.title || "Option ".concat(index + 1),
          value: index
        };
      });
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "panel panel-default panel-body"
      }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "form-group"
      }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Widget, _extends({
        id: "".concat(idSchema.$id).concat(schema.oneOf ? "__oneof_select" : "__anyof_select"),
        schema: {
          type: "number",
          "default": 0
        },
        onChange: this.onOptionChange,
        onBlur: onBlur,
        onFocus: onFocus,
        value: selectedOption,
        options: {
          enumOptions: enumOptions
        }
      }, uiOptions))), option !== null && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SchemaField, {
        schema: optionSchema,
        uiSchema: uiSchema,
        errorSchema: errorSchema,
        idSchema: idSchema,
        idPrefix: idPrefix,
        formData: formData,
        onChange: onChange,
        onBlur: onBlur,
        onFocus: onFocus,
        registry: registry,
        disabled: disabled
      }));
    }
  }]);

  return AnyOfField;
}(react__WEBPACK_IMPORTED_MODULE_0__.Component);

AnyOfField.defaultProps = {
  disabled: false,
  errorSchema: {},
  idSchema: {},
  uiSchema: {}
};

if (true) {
  AnyOfField.propTypes = {
    options: prop_types__WEBPACK_IMPORTED_MODULE_3___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_3___default().object)).isRequired,
    baseType: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
    uiSchema: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
    idSchema: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
    formData: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().any),
    errorSchema: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
    registry: _types__WEBPACK_IMPORTED_MODULE_1__.registry.isRequired
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AnyOfField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL2ZpZWxkcy9NdWx0aVNjaGVtYUZpZWxkLmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwiQ29tcG9uZW50IiwiUHJvcFR5cGVzIiwidHlwZXMiLCJnZXRVaU9wdGlvbnMiLCJnZXRXaWRnZXQiLCJndWVzc1R5cGUiLCJyZXRyaWV2ZVNjaGVtYSIsImdldERlZmF1bHRGb3JtU3RhdGUiLCJnZXRNYXRjaGluZ09wdGlvbiIsImRlZXBFcXVhbHMiLCJBbnlPZkZpZWxkIiwicHJvcHMiLCJvcHRpb24iLCJzZWxlY3RlZE9wdGlvbiIsInBhcnNlSW50IiwiZm9ybURhdGEiLCJvbkNoYW5nZSIsIm9wdGlvbnMiLCJyZWdpc3RyeSIsInJvb3RTY2hlbWEiLCJuZXdPcHRpb24iLCJuZXdGb3JtRGF0YSIsInVuZGVmaW5lZCIsInR5cGUiLCJwcm9wZXJ0aWVzIiwiT2JqZWN0IiwiYXNzaWduIiwib3B0aW9uc1RvRGlzY2FyZCIsInNsaWNlIiwic3BsaWNlIiwia2V5IiwiaGFzT3duUHJvcGVydHkiLCJzZXRTdGF0ZSIsInN0YXRlIiwicHJldlByb3BzIiwicHJldlN0YXRlIiwiaWRTY2hlbWEiLCIkaWQiLCJtYXRjaGluZ09wdGlvbiIsImJhc2VUeXBlIiwiZGlzYWJsZWQiLCJlcnJvclNjaGVtYSIsImlkUHJlZml4Iiwib25CbHVyIiwib25Gb2N1cyIsInVpU2NoZW1hIiwic2NoZW1hIiwiX1NjaGVtYUZpZWxkIiwiZmllbGRzIiwiU2NoZW1hRmllbGQiLCJ3aWRnZXRzIiwid2lkZ2V0IiwidWlPcHRpb25zIiwiV2lkZ2V0Iiwib3B0aW9uU2NoZW1hIiwiZW51bU9wdGlvbnMiLCJtYXAiLCJpbmRleCIsImxhYmVsIiwidGl0bGUiLCJ2YWx1ZSIsIm9uZU9mIiwib25PcHRpb25DaGFuZ2UiLCJkZWZhdWx0UHJvcHMiLCJwcm9jZXNzIiwiZW52IiwiTk9ERV9FTlYiLCJwcm9wVHlwZXMiLCJhcnJheU9mIiwib2JqZWN0IiwiaXNSZXF1aXJlZCIsInN0cmluZyIsImFueSJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSxPQUFPQSxLQUFQLElBQWdCQyxTQUFoQixRQUFpQyxPQUFqQztBQUNBLE9BQU9DLFNBQVAsTUFBc0IsWUFBdEI7QUFDQSxPQUFPLEtBQUtDLEtBQVosTUFBdUIsYUFBdkI7QUFDQSxTQUNFQyxZQURGLEVBRUVDLFNBRkYsRUFHRUMsU0FIRixFQUlFQyxjQUpGLEVBS0VDLG1CQUxGLEVBTUVDLGlCQUFpQixJQUFqQkEsa0JBTkYsRUFPRUMsVUFQRixRQVFPLGFBUlA7O0lBVU1DLFU7Ozs7O0FBQ0osc0JBQVlDLEtBQVosRUFBbUI7QUFBQTs7QUFBQTs7QUFDakIsb0ZBQU1BLEtBQU47O0FBRGlCLHFFQTBDRixVQUFBQyxNQUFNLEVBQUk7QUFDekIsVUFBTUMsY0FBYyxHQUFHQyxRQUFRLENBQUNGLE1BQUQsRUFBUyxFQUFULENBQS9CO0FBRHlCLHdCQUV5QixNQUFLRCxLQUY5QjtBQUFBLFVBRWpCSSxRQUZpQixlQUVqQkEsUUFGaUI7QUFBQSxVQUVQQyxRQUZPLGVBRVBBLFFBRk87QUFBQSxVQUVHQyxPQUZILGVBRUdBLE9BRkg7QUFBQSxVQUVZQyxRQUZaLGVBRVlBLFFBRlo7QUFBQSxVQUdqQkMsVUFIaUIsR0FHRkQsUUFIRSxDQUdqQkMsVUFIaUI7QUFJekIsVUFBTUMsU0FBUyxHQUFHZCxjQUFjLENBQzlCVyxPQUFPLENBQUNKLGNBQUQsQ0FEdUIsRUFFOUJNLFVBRjhCLEVBRzlCSixRQUg4QixDQUFoQyxDQUp5QixDQVV6QjtBQUNBOztBQUNBLFVBQUlNLFdBQVcsR0FBR0MsU0FBbEI7O0FBQ0EsVUFDRWpCLFNBQVMsQ0FBQ1UsUUFBRCxDQUFULEtBQXdCLFFBQXhCLEtBQ0NLLFNBQVMsQ0FBQ0csSUFBVixLQUFtQixRQUFuQixJQUErQkgsU0FBUyxDQUFDSSxVQUQxQyxDQURGLEVBR0U7QUFDQUgsUUFBQUEsV0FBVyxHQUFHSSxNQUFNLENBQUNDLE1BQVAsQ0FBYyxFQUFkLEVBQWtCWCxRQUFsQixDQUFkO0FBRUEsWUFBTVksZ0JBQWdCLEdBQUdWLE9BQU8sQ0FBQ1csS0FBUixFQUF6QjtBQUNBRCxRQUFBQSxnQkFBZ0IsQ0FBQ0UsTUFBakIsQ0FBd0JoQixjQUF4QixFQUF3QyxDQUF4QyxFQUpBLENBTUE7O0FBTkE7QUFBQTtBQUFBOztBQUFBO0FBT0EsK0JBQXFCYyxnQkFBckIsOEhBQXVDO0FBQUEsZ0JBQTVCZixPQUE0Qjs7QUFDckMsZ0JBQUlBLE9BQU0sQ0FBQ1ksVUFBWCxFQUF1QjtBQUNyQixtQkFBSyxJQUFNTSxHQUFYLElBQWtCbEIsT0FBTSxDQUFDWSxVQUF6QixFQUFxQztBQUNuQyxvQkFBSUgsV0FBVyxDQUFDVSxjQUFaLENBQTJCRCxHQUEzQixDQUFKLEVBQXFDO0FBQ25DLHlCQUFPVCxXQUFXLENBQUNTLEdBQUQsQ0FBbEI7QUFDRDtBQUNGO0FBQ0Y7QUFDRjtBQWZEO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFnQkQsT0FoQ3dCLENBaUN6Qjs7O0FBQ0FkLE1BQUFBLFFBQVEsQ0FDTlQsbUJBQW1CLENBQUNVLE9BQU8sQ0FBQ0osY0FBRCxDQUFSLEVBQTBCUSxXQUExQixFQUF1Q0YsVUFBdkMsQ0FEYixDQUFSOztBQUlBLFlBQUthLFFBQUwsQ0FBYztBQUNabkIsUUFBQUEsY0FBYyxFQUFFQyxRQUFRLENBQUNGLE1BQUQsRUFBUyxFQUFUO0FBRFosT0FBZDtBQUdELEtBbkZrQjs7QUFBQSx1QkFHYSxNQUFLRCxLQUhsQjtBQUFBLFFBR1RJLFNBSFMsZ0JBR1RBLFFBSFM7QUFBQSxRQUdDRSxRQUhELGdCQUdDQSxPQUhEO0FBS2pCLFVBQUtnQixLQUFMLEdBQWE7QUFDWHBCLE1BQUFBLGNBQWMsRUFBRSxNQUFLTCxpQkFBTCxDQUF1Qk8sU0FBdkIsRUFBaUNFLFFBQWpDO0FBREwsS0FBYjtBQUxpQjtBQVFsQjs7Ozt1Q0FFa0JpQixTLEVBQVdDLFMsRUFBVztBQUN2QyxVQUNFLENBQUMxQixVQUFVLENBQUMsS0FBS0UsS0FBTCxDQUFXSSxRQUFaLEVBQXNCbUIsU0FBUyxDQUFDbkIsUUFBaEMsQ0FBWCxJQUNBLEtBQUtKLEtBQUwsQ0FBV3lCLFFBQVgsQ0FBb0JDLEdBQXBCLEtBQTRCSCxTQUFTLENBQUNFLFFBQVYsQ0FBbUJDLEdBRmpELEVBR0U7QUFDQSxZQUFNQyxjQUFjLEdBQUcsS0FBSzlCLGlCQUFMLENBQ3JCLEtBQUtHLEtBQUwsQ0FBV0ksUUFEVSxFQUVyQixLQUFLSixLQUFMLENBQVdNLE9BRlUsQ0FBdkI7O0FBS0EsWUFBSSxDQUFDa0IsU0FBRCxJQUFjRyxjQUFjLEtBQUssS0FBS0wsS0FBTCxDQUFXcEIsY0FBaEQsRUFBZ0U7QUFDOUQ7QUFDRDs7QUFFRCxhQUFLbUIsUUFBTCxDQUFjO0FBQ1puQixVQUFBQSxjQUFjLEVBQUV5QjtBQURKLFNBQWQ7QUFHRDtBQUNGOzs7c0NBRWlCdkIsUSxFQUFVRSxPLEVBQVM7QUFBQSxVQUMzQkUsVUFEMkIsR0FDWixLQUFLUixLQUFMLENBQVdPLFFBREMsQ0FDM0JDLFVBRDJCOztBQUduQyxVQUFJUCxNQUFNLEdBQUdKLGtCQUFpQixDQUFDTyxRQUFELEVBQVdFLE9BQVgsRUFBb0JFLFVBQXBCLENBQTlCOztBQUNBLFVBQUlQLE1BQU0sS0FBSyxDQUFmLEVBQWtCO0FBQ2hCLGVBQU9BLE1BQVA7QUFDRCxPQU5rQyxDQU9uQztBQUNBOzs7QUFDQSxhQUFPLFFBQVEsS0FBS3FCLEtBQWIsR0FBcUIsS0FBS0EsS0FBTCxDQUFXcEIsY0FBaEMsR0FBaUQsQ0FBeEQ7QUFDRDs7OzZCQTZDUTtBQUFBLHlCQWVILEtBQUtGLEtBZkY7QUFBQSxVQUVMNEIsUUFGSyxnQkFFTEEsUUFGSztBQUFBLFVBR0xDLFFBSEssZ0JBR0xBLFFBSEs7QUFBQSxVQUlMQyxXQUpLLGdCQUlMQSxXQUpLO0FBQUEsVUFLTDFCLFFBTEssZ0JBS0xBLFFBTEs7QUFBQSxVQU1MMkIsUUFOSyxnQkFNTEEsUUFOSztBQUFBLFVBT0xOLFFBUEssZ0JBT0xBLFFBUEs7QUFBQSxVQVFMTyxNQVJLLGdCQVFMQSxNQVJLO0FBQUEsVUFTTDNCLFFBVEssZ0JBU0xBLFFBVEs7QUFBQSxVQVVMNEIsT0FWSyxnQkFVTEEsT0FWSztBQUFBLFVBV0wzQixPQVhLLGdCQVdMQSxPQVhLO0FBQUEsVUFZTEMsUUFaSyxnQkFZTEEsUUFaSztBQUFBLFVBYUwyQixRQWJLLGdCQWFMQSxRQWJLO0FBQUEsVUFjTEMsTUFkSyxnQkFjTEEsTUFkSztBQWlCUCxVQUFNQyxZQUFZLEdBQUc3QixRQUFRLENBQUM4QixNQUFULENBQWdCQyxXQUFyQztBQWpCTyxVQWtCQ0MsT0FsQkQsR0FrQmFoQyxRQWxCYixDQWtCQ2dDLE9BbEJEO0FBQUEsVUFtQkNyQyxjQW5CRCxHQW1Cb0IsS0FBS29CLEtBbkJ6QixDQW1CQ3BCLGNBbkJEOztBQUFBLDBCQW9CcUNWLFlBQVksQ0FBQzBDLFFBQUQsQ0FwQmpEO0FBQUEsK0NBb0JDTSxNQXBCRDtBQUFBLFVBb0JDQSxNQXBCRCxxQ0FvQlUsUUFwQlY7QUFBQSxVQW9CdUJDLFNBcEJ2Qjs7QUFxQlAsVUFBTUMsTUFBTSxHQUFHakQsU0FBUyxDQUFDO0FBQUVtQixRQUFBQSxJQUFJLEVBQUU7QUFBUixPQUFELEVBQXFCNEIsTUFBckIsRUFBNkJELE9BQTdCLENBQXhCO0FBRUEsVUFBTXRDLE1BQU0sR0FBR0ssT0FBTyxDQUFDSixjQUFELENBQVAsSUFBMkIsSUFBMUM7QUFDQSxVQUFJeUMsWUFBSjs7QUFFQSxVQUFJMUMsTUFBSixFQUFZO0FBQ1Y7QUFDQTtBQUNBMEMsUUFBQUEsWUFBWSxHQUFHMUMsTUFBTSxDQUFDVyxJQUFQLEdBQ1hYLE1BRFcsR0FFWGEsTUFBTSxDQUFDQyxNQUFQLENBQWMsRUFBZCxFQUFrQmQsTUFBbEIsRUFBMEI7QUFBRVcsVUFBQUEsSUFBSSxFQUFFZ0I7QUFBUixTQUExQixDQUZKO0FBR0Q7O0FBRUQsVUFBTWdCLFdBQVcsR0FBR3RDLE9BQU8sQ0FBQ3VDLEdBQVIsQ0FBWSxVQUFDNUMsTUFBRCxFQUFTNkMsS0FBVDtBQUFBLGVBQW9CO0FBQ2xEQyxVQUFBQSxLQUFLLEVBQUU5QyxNQUFNLENBQUMrQyxLQUFQLHFCQUEwQkYsS0FBSyxHQUFHLENBQWxDLENBRDJDO0FBRWxERyxVQUFBQSxLQUFLLEVBQUVIO0FBRjJDLFNBQXBCO0FBQUEsT0FBWixDQUFwQjtBQUtBLGFBQ0U7QUFBSyxRQUFBLFNBQVMsRUFBQztBQUFmLFNBQ0U7QUFBSyxRQUFBLFNBQVMsRUFBQztBQUFmLFNBQ0Usb0JBQUMsTUFBRDtBQUNFLFFBQUEsRUFBRSxZQUFLckIsUUFBUSxDQUFDQyxHQUFkLFNBQ0FTLE1BQU0sQ0FBQ2UsS0FBUCxHQUFlLGdCQUFmLEdBQWtDLGdCQURsQyxDQURKO0FBSUUsUUFBQSxNQUFNLEVBQUU7QUFBRXRDLFVBQUFBLElBQUksRUFBRSxRQUFSO0FBQWtCLHFCQUFTO0FBQTNCLFNBSlY7QUFLRSxRQUFBLFFBQVEsRUFBRSxLQUFLdUMsY0FMakI7QUFNRSxRQUFBLE1BQU0sRUFBRW5CLE1BTlY7QUFPRSxRQUFBLE9BQU8sRUFBRUMsT0FQWDtBQVFFLFFBQUEsS0FBSyxFQUFFL0IsY0FSVDtBQVNFLFFBQUEsT0FBTyxFQUFFO0FBQUUwQyxVQUFBQSxXQUFXLEVBQVhBO0FBQUY7QUFUWCxTQVVNSCxTQVZOLEVBREYsQ0FERixFQWdCR3hDLE1BQU0sS0FBSyxJQUFYLElBQ0Msb0JBQUMsWUFBRDtBQUNFLFFBQUEsTUFBTSxFQUFFMEMsWUFEVjtBQUVFLFFBQUEsUUFBUSxFQUFFVCxRQUZaO0FBR0UsUUFBQSxXQUFXLEVBQUVKLFdBSGY7QUFJRSxRQUFBLFFBQVEsRUFBRUwsUUFKWjtBQUtFLFFBQUEsUUFBUSxFQUFFTSxRQUxaO0FBTUUsUUFBQSxRQUFRLEVBQUUzQixRQU5aO0FBT0UsUUFBQSxRQUFRLEVBQUVDLFFBUFo7QUFRRSxRQUFBLE1BQU0sRUFBRTJCLE1BUlY7QUFTRSxRQUFBLE9BQU8sRUFBRUMsT0FUWDtBQVVFLFFBQUEsUUFBUSxFQUFFMUIsUUFWWjtBQVdFLFFBQUEsUUFBUSxFQUFFc0I7QUFYWixRQWpCSixDQURGO0FBa0NEOzs7O0VBL0pzQnhDLFM7O0FBa0t6QlUsVUFBVSxDQUFDcUQsWUFBWCxHQUEwQjtBQUN4QnZCLEVBQUFBLFFBQVEsRUFBRSxLQURjO0FBRXhCQyxFQUFBQSxXQUFXLEVBQUUsRUFGVztBQUd4QkwsRUFBQUEsUUFBUSxFQUFFLEVBSGM7QUFJeEJTLEVBQUFBLFFBQVEsRUFBRTtBQUpjLENBQTFCOztBQU9BLElBQUltQixPQUFPLENBQUNDLEdBQVIsQ0FBWUMsUUFBWixLQUF5QixZQUE3QixFQUEyQztBQUN6Q3hELEVBQUFBLFVBQVUsQ0FBQ3lELFNBQVgsR0FBdUI7QUFDckJsRCxJQUFBQSxPQUFPLEVBQUVoQixTQUFTLENBQUNtRSxPQUFWLENBQWtCbkUsU0FBUyxDQUFDb0UsTUFBNUIsRUFBb0NDLFVBRHhCO0FBRXJCL0IsSUFBQUEsUUFBUSxFQUFFdEMsU0FBUyxDQUFDc0UsTUFGQztBQUdyQjFCLElBQUFBLFFBQVEsRUFBRTVDLFNBQVMsQ0FBQ29FLE1BSEM7QUFJckJqQyxJQUFBQSxRQUFRLEVBQUVuQyxTQUFTLENBQUNvRSxNQUpDO0FBS3JCdEQsSUFBQUEsUUFBUSxFQUFFZCxTQUFTLENBQUN1RSxHQUxDO0FBTXJCL0IsSUFBQUEsV0FBVyxFQUFFeEMsU0FBUyxDQUFDb0UsTUFORjtBQU9yQm5ELElBQUFBLFFBQVEsRUFBRWhCLEtBQUssQ0FBQ2dCLFFBQU4sQ0FBZW9EO0FBUEosR0FBdkI7QUFTRDs7QUFFRCxlQUFlNUQsVUFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCwgeyBDb21wb25lbnQgfSBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcbmltcG9ydCAqIGFzIHR5cGVzIGZyb20gXCIuLi8uLi90eXBlc1wiO1xuaW1wb3J0IHtcbiAgZ2V0VWlPcHRpb25zLFxuICBnZXRXaWRnZXQsXG4gIGd1ZXNzVHlwZSxcbiAgcmV0cmlldmVTY2hlbWEsXG4gIGdldERlZmF1bHRGb3JtU3RhdGUsXG4gIGdldE1hdGNoaW5nT3B0aW9uLFxuICBkZWVwRXF1YWxzLFxufSBmcm9tIFwiLi4vLi4vdXRpbHNcIjtcblxuY2xhc3MgQW55T2ZGaWVsZCBleHRlbmRzIENvbXBvbmVudCB7XG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuXG4gICAgY29uc3QgeyBmb3JtRGF0YSwgb3B0aW9ucyB9ID0gdGhpcy5wcm9wcztcblxuICAgIHRoaXMuc3RhdGUgPSB7XG4gICAgICBzZWxlY3RlZE9wdGlvbjogdGhpcy5nZXRNYXRjaGluZ09wdGlvbihmb3JtRGF0YSwgb3B0aW9ucyksXG4gICAgfTtcbiAgfVxuXG4gIGNvbXBvbmVudERpZFVwZGF0ZShwcmV2UHJvcHMsIHByZXZTdGF0ZSkge1xuICAgIGlmIChcbiAgICAgICFkZWVwRXF1YWxzKHRoaXMucHJvcHMuZm9ybURhdGEsIHByZXZQcm9wcy5mb3JtRGF0YSkgJiZcbiAgICAgIHRoaXMucHJvcHMuaWRTY2hlbWEuJGlkID09PSBwcmV2UHJvcHMuaWRTY2hlbWEuJGlkXG4gICAgKSB7XG4gICAgICBjb25zdCBtYXRjaGluZ09wdGlvbiA9IHRoaXMuZ2V0TWF0Y2hpbmdPcHRpb24oXG4gICAgICAgIHRoaXMucHJvcHMuZm9ybURhdGEsXG4gICAgICAgIHRoaXMucHJvcHMub3B0aW9uc1xuICAgICAgKTtcblxuICAgICAgaWYgKCFwcmV2U3RhdGUgfHwgbWF0Y2hpbmdPcHRpb24gPT09IHRoaXMuc3RhdGUuc2VsZWN0ZWRPcHRpb24pIHtcbiAgICAgICAgcmV0dXJuO1xuICAgICAgfVxuXG4gICAgICB0aGlzLnNldFN0YXRlKHtcbiAgICAgICAgc2VsZWN0ZWRPcHRpb246IG1hdGNoaW5nT3B0aW9uLFxuICAgICAgfSk7XG4gICAgfVxuICB9XG5cbiAgZ2V0TWF0Y2hpbmdPcHRpb24oZm9ybURhdGEsIG9wdGlvbnMpIHtcbiAgICBjb25zdCB7IHJvb3RTY2hlbWEgfSA9IHRoaXMucHJvcHMucmVnaXN0cnk7XG5cbiAgICBsZXQgb3B0aW9uID0gZ2V0TWF0Y2hpbmdPcHRpb24oZm9ybURhdGEsIG9wdGlvbnMsIHJvb3RTY2hlbWEpO1xuICAgIGlmIChvcHRpb24gIT09IDApIHtcbiAgICAgIHJldHVybiBvcHRpb247XG4gICAgfVxuICAgIC8vIElmIHRoZSBmb3JtIGRhdGEgbWF0Y2hlcyBub25lIG9mIHRoZSBvcHRpb25zLCB1c2UgdGhlIGN1cnJlbnRseSBzZWxlY3RlZFxuICAgIC8vIG9wdGlvbiwgYXNzdW1pbmcgaXQncyBhdmFpbGFibGU7IG90aGVyd2lzZSB1c2UgdGhlIGZpcnN0IG9wdGlvblxuICAgIHJldHVybiB0aGlzICYmIHRoaXMuc3RhdGUgPyB0aGlzLnN0YXRlLnNlbGVjdGVkT3B0aW9uIDogMDtcbiAgfVxuXG4gIG9uT3B0aW9uQ2hhbmdlID0gb3B0aW9uID0+IHtcbiAgICBjb25zdCBzZWxlY3RlZE9wdGlvbiA9IHBhcnNlSW50KG9wdGlvbiwgMTApO1xuICAgIGNvbnN0IHsgZm9ybURhdGEsIG9uQ2hhbmdlLCBvcHRpb25zLCByZWdpc3RyeSB9ID0gdGhpcy5wcm9wcztcbiAgICBjb25zdCB7IHJvb3RTY2hlbWEgfSA9IHJlZ2lzdHJ5O1xuICAgIGNvbnN0IG5ld09wdGlvbiA9IHJldHJpZXZlU2NoZW1hKFxuICAgICAgb3B0aW9uc1tzZWxlY3RlZE9wdGlvbl0sXG4gICAgICByb290U2NoZW1hLFxuICAgICAgZm9ybURhdGFcbiAgICApO1xuXG4gICAgLy8gSWYgdGhlIG5ldyBvcHRpb24gaXMgb2YgdHlwZSBvYmplY3QgYW5kIHRoZSBjdXJyZW50IGRhdGEgaXMgYW4gb2JqZWN0LFxuICAgIC8vIGRpc2NhcmQgcHJvcGVydGllcyBhZGRlZCB1c2luZyB0aGUgb2xkIG9wdGlvbi5cbiAgICBsZXQgbmV3Rm9ybURhdGEgPSB1bmRlZmluZWQ7XG4gICAgaWYgKFxuICAgICAgZ3Vlc3NUeXBlKGZvcm1EYXRhKSA9PT0gXCJvYmplY3RcIiAmJlxuICAgICAgKG5ld09wdGlvbi50eXBlID09PSBcIm9iamVjdFwiIHx8IG5ld09wdGlvbi5wcm9wZXJ0aWVzKVxuICAgICkge1xuICAgICAgbmV3Rm9ybURhdGEgPSBPYmplY3QuYXNzaWduKHt9LCBmb3JtRGF0YSk7XG5cbiAgICAgIGNvbnN0IG9wdGlvbnNUb0Rpc2NhcmQgPSBvcHRpb25zLnNsaWNlKCk7XG4gICAgICBvcHRpb25zVG9EaXNjYXJkLnNwbGljZShzZWxlY3RlZE9wdGlvbiwgMSk7XG5cbiAgICAgIC8vIERpc2NhcmQgYW55IGRhdGEgYWRkZWQgdXNpbmcgb3RoZXIgb3B0aW9uc1xuICAgICAgZm9yIChjb25zdCBvcHRpb24gb2Ygb3B0aW9uc1RvRGlzY2FyZCkge1xuICAgICAgICBpZiAob3B0aW9uLnByb3BlcnRpZXMpIHtcbiAgICAgICAgICBmb3IgKGNvbnN0IGtleSBpbiBvcHRpb24ucHJvcGVydGllcykge1xuICAgICAgICAgICAgaWYgKG5ld0Zvcm1EYXRhLmhhc093blByb3BlcnR5KGtleSkpIHtcbiAgICAgICAgICAgICAgZGVsZXRlIG5ld0Zvcm1EYXRhW2tleV07XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICAgIC8vIENhbGwgZ2V0RGVmYXVsdEZvcm1TdGF0ZSB0byBtYWtlIHN1cmUgZGVmYXVsdHMgYXJlIHBvcHVsYXRlZCBvbiBjaGFuZ2UuXG4gICAgb25DaGFuZ2UoXG4gICAgICBnZXREZWZhdWx0Rm9ybVN0YXRlKG9wdGlvbnNbc2VsZWN0ZWRPcHRpb25dLCBuZXdGb3JtRGF0YSwgcm9vdFNjaGVtYSlcbiAgICApO1xuXG4gICAgdGhpcy5zZXRTdGF0ZSh7XG4gICAgICBzZWxlY3RlZE9wdGlvbjogcGFyc2VJbnQob3B0aW9uLCAxMCksXG4gICAgfSk7XG4gIH07XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IHtcbiAgICAgIGJhc2VUeXBlLFxuICAgICAgZGlzYWJsZWQsXG4gICAgICBlcnJvclNjaGVtYSxcbiAgICAgIGZvcm1EYXRhLFxuICAgICAgaWRQcmVmaXgsXG4gICAgICBpZFNjaGVtYSxcbiAgICAgIG9uQmx1cixcbiAgICAgIG9uQ2hhbmdlLFxuICAgICAgb25Gb2N1cyxcbiAgICAgIG9wdGlvbnMsXG4gICAgICByZWdpc3RyeSxcbiAgICAgIHVpU2NoZW1hLFxuICAgICAgc2NoZW1hLFxuICAgIH0gPSB0aGlzLnByb3BzO1xuXG4gICAgY29uc3QgX1NjaGVtYUZpZWxkID0gcmVnaXN0cnkuZmllbGRzLlNjaGVtYUZpZWxkO1xuICAgIGNvbnN0IHsgd2lkZ2V0cyB9ID0gcmVnaXN0cnk7XG4gICAgY29uc3QgeyBzZWxlY3RlZE9wdGlvbiB9ID0gdGhpcy5zdGF0ZTtcbiAgICBjb25zdCB7IHdpZGdldCA9IFwic2VsZWN0XCIsIC4uLnVpT3B0aW9ucyB9ID0gZ2V0VWlPcHRpb25zKHVpU2NoZW1hKTtcbiAgICBjb25zdCBXaWRnZXQgPSBnZXRXaWRnZXQoeyB0eXBlOiBcIm51bWJlclwiIH0sIHdpZGdldCwgd2lkZ2V0cyk7XG5cbiAgICBjb25zdCBvcHRpb24gPSBvcHRpb25zW3NlbGVjdGVkT3B0aW9uXSB8fCBudWxsO1xuICAgIGxldCBvcHRpb25TY2hlbWE7XG5cbiAgICBpZiAob3B0aW9uKSB7XG4gICAgICAvLyBJZiB0aGUgc3Vic2NoZW1hIGRvZXNuJ3QgZGVjbGFyZSBhIHR5cGUsIGluZmVyIHRoZSB0eXBlIGZyb20gdGhlXG4gICAgICAvLyBwYXJlbnQgc2NoZW1hXG4gICAgICBvcHRpb25TY2hlbWEgPSBvcHRpb24udHlwZVxuICAgICAgICA/IG9wdGlvblxuICAgICAgICA6IE9iamVjdC5hc3NpZ24oe30sIG9wdGlvbiwgeyB0eXBlOiBiYXNlVHlwZSB9KTtcbiAgICB9XG5cbiAgICBjb25zdCBlbnVtT3B0aW9ucyA9IG9wdGlvbnMubWFwKChvcHRpb24sIGluZGV4KSA9PiAoe1xuICAgICAgbGFiZWw6IG9wdGlvbi50aXRsZSB8fCBgT3B0aW9uICR7aW5kZXggKyAxfWAsXG4gICAgICB2YWx1ZTogaW5kZXgsXG4gICAgfSkpO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwicGFuZWwgcGFuZWwtZGVmYXVsdCBwYW5lbC1ib2R5XCI+XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZm9ybS1ncm91cFwiPlxuICAgICAgICAgIDxXaWRnZXRcbiAgICAgICAgICAgIGlkPXtgJHtpZFNjaGVtYS4kaWR9JHtcbiAgICAgICAgICAgICAgc2NoZW1hLm9uZU9mID8gXCJfX29uZW9mX3NlbGVjdFwiIDogXCJfX2FueW9mX3NlbGVjdFwiXG4gICAgICAgICAgICB9YH1cbiAgICAgICAgICAgIHNjaGVtYT17eyB0eXBlOiBcIm51bWJlclwiLCBkZWZhdWx0OiAwIH19XG4gICAgICAgICAgICBvbkNoYW5nZT17dGhpcy5vbk9wdGlvbkNoYW5nZX1cbiAgICAgICAgICAgIG9uQmx1cj17b25CbHVyfVxuICAgICAgICAgICAgb25Gb2N1cz17b25Gb2N1c31cbiAgICAgICAgICAgIHZhbHVlPXtzZWxlY3RlZE9wdGlvbn1cbiAgICAgICAgICAgIG9wdGlvbnM9e3sgZW51bU9wdGlvbnMgfX1cbiAgICAgICAgICAgIHsuLi51aU9wdGlvbnN9XG4gICAgICAgICAgLz5cbiAgICAgICAgPC9kaXY+XG5cbiAgICAgICAge29wdGlvbiAhPT0gbnVsbCAmJiAoXG4gICAgICAgICAgPF9TY2hlbWFGaWVsZFxuICAgICAgICAgICAgc2NoZW1hPXtvcHRpb25TY2hlbWF9XG4gICAgICAgICAgICB1aVNjaGVtYT17dWlTY2hlbWF9XG4gICAgICAgICAgICBlcnJvclNjaGVtYT17ZXJyb3JTY2hlbWF9XG4gICAgICAgICAgICBpZFNjaGVtYT17aWRTY2hlbWF9XG4gICAgICAgICAgICBpZFByZWZpeD17aWRQcmVmaXh9XG4gICAgICAgICAgICBmb3JtRGF0YT17Zm9ybURhdGF9XG4gICAgICAgICAgICBvbkNoYW5nZT17b25DaGFuZ2V9XG4gICAgICAgICAgICBvbkJsdXI9e29uQmx1cn1cbiAgICAgICAgICAgIG9uRm9jdXM9e29uRm9jdXN9XG4gICAgICAgICAgICByZWdpc3RyeT17cmVnaXN0cnl9XG4gICAgICAgICAgICBkaXNhYmxlZD17ZGlzYWJsZWR9XG4gICAgICAgICAgLz5cbiAgICAgICAgKX1cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cbn1cblxuQW55T2ZGaWVsZC5kZWZhdWx0UHJvcHMgPSB7XG4gIGRpc2FibGVkOiBmYWxzZSxcbiAgZXJyb3JTY2hlbWE6IHt9LFxuICBpZFNjaGVtYToge30sXG4gIHVpU2NoZW1hOiB7fSxcbn07XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViAhPT0gXCJwcm9kdWN0aW9uXCIpIHtcbiAgQW55T2ZGaWVsZC5wcm9wVHlwZXMgPSB7XG4gICAgb3B0aW9uczogUHJvcFR5cGVzLmFycmF5T2YoUHJvcFR5cGVzLm9iamVjdCkuaXNSZXF1aXJlZCxcbiAgICBiYXNlVHlwZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgICB1aVNjaGVtYTogUHJvcFR5cGVzLm9iamVjdCxcbiAgICBpZFNjaGVtYTogUHJvcFR5cGVzLm9iamVjdCxcbiAgICBmb3JtRGF0YTogUHJvcFR5cGVzLmFueSxcbiAgICBlcnJvclNjaGVtYTogUHJvcFR5cGVzLm9iamVjdCxcbiAgICByZWdpc3RyeTogdHlwZXMucmVnaXN0cnkuaXNSZXF1aXJlZCxcbiAgfTtcbn1cblxuZXhwb3J0IGRlZmF1bHQgQW55T2ZGaWVsZDtcbiJdfQ==

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/NullField.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/NullField.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../types */ "../../node_modules/@rjsf/core/dist/es/types.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }




var NullField =
/*#__PURE__*/
function (_Component) {
  _inherits(NullField, _Component);

  function NullField() {
    _classCallCheck(this, NullField);

    return _possibleConstructorReturn(this, _getPrototypeOf(NullField).apply(this, arguments));
  }

  _createClass(NullField, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.formData === undefined) {
        this.props.onChange(null);
      }
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return NullField;
}(react__WEBPACK_IMPORTED_MODULE_0__.Component);

if (true) {
  NullField.propTypes = _types__WEBPACK_IMPORTED_MODULE_1__.fieldProps;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NullField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL2ZpZWxkcy9OdWxsRmllbGQuanMiXSwibmFtZXMiOlsiQ29tcG9uZW50IiwidHlwZXMiLCJOdWxsRmllbGQiLCJwcm9wcyIsImZvcm1EYXRhIiwidW5kZWZpbmVkIiwib25DaGFuZ2UiLCJwcm9jZXNzIiwiZW52IiwiTk9ERV9FTlYiLCJwcm9wVHlwZXMiLCJmaWVsZFByb3BzIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSxTQUFTQSxTQUFULFFBQTBCLE9BQTFCO0FBQ0EsT0FBTyxLQUFLQyxLQUFaLE1BQXVCLGFBQXZCOztJQUVNQyxTOzs7Ozs7Ozs7Ozs7O3dDQUNnQjtBQUNsQixVQUFJLEtBQUtDLEtBQUwsQ0FBV0MsUUFBWCxLQUF3QkMsU0FBNUIsRUFBdUM7QUFDckMsYUFBS0YsS0FBTCxDQUFXRyxRQUFYLENBQW9CLElBQXBCO0FBQ0Q7QUFDRjs7OzZCQUVRO0FBQ1AsYUFBTyxJQUFQO0FBQ0Q7Ozs7RUFUcUJOLFM7O0FBWXhCLElBQUlPLE9BQU8sQ0FBQ0MsR0FBUixDQUFZQyxRQUFaLEtBQXlCLFlBQTdCLEVBQTJDO0FBQ3pDUCxFQUFBQSxTQUFTLENBQUNRLFNBQVYsR0FBc0JULEtBQUssQ0FBQ1UsVUFBNUI7QUFDRDs7QUFFRCxlQUFlVCxTQUFmIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSBcInJlYWN0XCI7XG5pbXBvcnQgKiBhcyB0eXBlcyBmcm9tIFwiLi4vLi4vdHlwZXNcIjtcblxuY2xhc3MgTnVsbEZpZWxkIGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgaWYgKHRoaXMucHJvcHMuZm9ybURhdGEgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5wcm9wcy5vbkNoYW5nZShudWxsKTtcbiAgICB9XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cbn1cblxuaWYgKHByb2Nlc3MuZW52Lk5PREVfRU5WICE9PSBcInByb2R1Y3Rpb25cIikge1xuICBOdWxsRmllbGQucHJvcFR5cGVzID0gdHlwZXMuZmllbGRQcm9wcztcbn1cblxuZXhwb3J0IGRlZmF1bHQgTnVsbEZpZWxkO1xuIl19

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/NumberField.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/NumberField.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../types */ "../../node_modules/@rjsf/core/dist/es/types.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }



 // Matches a string that ends in a . character, optionally followed by a sequence of
// digits followed by any number of 0 characters up until the end of the line.
// Ensuring that there is at least one prefixed character is important so that
// you don't incorrectly match against "0".

var trailingCharMatcherWithPrefix = /\.([0-9]*0)*$/; // This is used for trimming the trailing 0 and . characters without affecting
// the rest of the string. Its possible to use one RegEx with groups for this
// functionality, but it is fairly complex compared to simply defining two
// different matchers.

var trailingCharMatcher = /[0.]0*$/;
/**
 * The NumberField class has some special handling for dealing with trailing
 * decimal points and/or zeroes. This logic is designed to allow trailing values
 * to be visible in the input element, but not be represented in the
 * corresponding form data.
 *
 * The algorithm is as follows:
 *
 * 1. When the input value changes the value is cached in the component state
 *
 * 2. The value is then normalized, removing trailing decimal points and zeros,
 *    then passed to the "onChange" callback
 *
 * 3. When the component is rendered, the formData value is checked against the
 *    value cached in the state. If it matches the cached value, the cached
 *    value is passed to the input instead of the formData value
 */

var NumberField =
/*#__PURE__*/
function (_React$Component) {
  _inherits(NumberField, _React$Component);

  function NumberField(props) {
    var _this;

    _classCallCheck(this, NumberField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(NumberField).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (value) {
      // Cache the original value in component state
      _this.setState({
        lastValue: value
      }); // Normalize decimals that don't start with a zero character in advance so
      // that the rest of the normalization logic is simpler


      if ("".concat(value).charAt(0) === ".") {
        value = "0".concat(value);
      } // Check that the value is a string (this can happen if the widget used is a
      // <select>, due to an enum declaration etc) then, if the value ends in a
      // trailing decimal point or multiple zeroes, strip the trailing values


      var processed = typeof value === "string" && value.match(trailingCharMatcherWithPrefix) ? (0,_utils__WEBPACK_IMPORTED_MODULE_2__.asNumber)(value.replace(trailingCharMatcher, "")) : (0,_utils__WEBPACK_IMPORTED_MODULE_2__.asNumber)(value);

      _this.props.onChange(processed);
    });

    _this.state = {
      lastValue: props.value
    };
    return _this;
  }

  _createClass(NumberField, [{
    key: "render",
    value: function render() {
      var StringField = this.props.registry.fields.StringField;

      var _this$props = this.props,
          formData = _this$props.formData,
          props = _objectWithoutProperties(_this$props, ["formData"]);

      var lastValue = this.state.lastValue;
      var value = formData;

      if (typeof lastValue === "string" && typeof value === "number") {
        // Construct a regular expression that checks for a string that consists
        // of the formData value suffixed with zero or one '.' characters and zero
        // or more '0' characters
        var re = new RegExp("".concat(value).replace(".", "\\.") + "\\.?0*$"); // If the cached "lastValue" is a match, use that instead of the formData
        // value to prevent the input value from changing in the UI

        if (lastValue.match(re)) {
          value = lastValue;
        }
      }

      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StringField, _extends({}, props, {
        formData: value,
        onChange: this.handleChange
      }));
    }
  }]);

  return NumberField;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));

if (true) {
  NumberField.propTypes = _types__WEBPACK_IMPORTED_MODULE_1__.fieldProps;
}

NumberField.defaultProps = {
  uiSchema: {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NumberField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/ObjectField.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/ObjectField.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _AddButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../AddButton */ "../../node_modules/@rjsf/core/dist/es/components/AddButton.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../types */ "../../node_modules/@rjsf/core/dist/es/types.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






function DefaultObjectFieldTemplate(props) {
  var TitleField = props.TitleField,
      DescriptionField = props.DescriptionField;
  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("fieldset", {
    id: props.idSchema.$id
  }, (props.uiSchema["ui:title"] || props.title) && react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TitleField, {
    id: "".concat(props.idSchema.$id, "__title"),
    title: props.title || props.uiSchema["ui:title"],
    required: props.required,
    formContext: props.formContext
  }), props.description && react__WEBPACK_IMPORTED_MODULE_1___default().createElement(DescriptionField, {
    id: "".concat(props.idSchema.$id, "__description"),
    description: props.description,
    formContext: props.formContext
  }), props.properties.map(function (prop) {
    return prop.content;
  }), (0,_utils__WEBPACK_IMPORTED_MODULE_3__.canExpand)(props.schema, props.uiSchema, props.formData) && react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_AddButton__WEBPACK_IMPORTED_MODULE_0__["default"], {
    className: "object-property-expand",
    onClick: props.onAddClick(props.schema),
    disabled: props.disabled || props.readonly
  }));
}

var ObjectField =
/*#__PURE__*/
function (_Component) {
  _inherits(ObjectField, _Component);

  function ObjectField() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, ObjectField);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(ObjectField)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "state", {
      wasPropertyKeyModified: false,
      additionalProperties: {}
    });

    _defineProperty(_assertThisInitialized(_this), "onPropertyChange", function (name) {
      var addedByAdditionalProperties = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      return function (value, errorSchema) {
        if (value === undefined && addedByAdditionalProperties) {
          // Don't set value = undefined for fields added by
          // additionalProperties. Doing so removes them from the
          // formData, which causes them to completely disappear
          // (including the input field for the property name). Unlike
          // fields which are "mandated" by the schema, these fields can
          // be set to undefined by clicking a "delete field" button, so
          // set empty values to the empty string.
          value = "";
        }

        var newFormData = _objectSpread({}, _this.props.formData, _defineProperty({}, name, value));

        _this.props.onChange(newFormData, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, name, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onDropPropertyClick", function (key) {
      return function (event) {
        event.preventDefault();
        var _this$props = _this.props,
            onChange = _this$props.onChange,
            formData = _this$props.formData;

        var copiedFormData = _objectSpread({}, formData);

        delete copiedFormData[key];
        onChange(copiedFormData);
      };
    });

    _defineProperty(_assertThisInitialized(_this), "getAvailableKey", function (preferredKey, formData) {
      var index = 0;
      var newKey = preferredKey;

      while (formData.hasOwnProperty(newKey)) {
        newKey = "".concat(preferredKey, "-").concat(++index);
      }

      return newKey;
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyChange", function (oldValue) {
      return function (value, errorSchema) {
        if (oldValue === value) {
          return;
        }

        value = _this.getAvailableKey(value, _this.props.formData);

        var newFormData = _objectSpread({}, _this.props.formData);

        var newKeys = _defineProperty({}, oldValue, value);

        var keyValues = Object.keys(newFormData).map(function (key) {
          var newKey = newKeys[key] || key;
          return _defineProperty({}, newKey, newFormData[key]);
        });
        var renamedObj = Object.assign.apply(Object, [{}].concat(_toConsumableArray(keyValues)));

        _this.setState({
          wasPropertyKeyModified: true
        });

        _this.props.onChange(renamedObj, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, value, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleAddClick", function (schema) {
      return function () {
        var type = schema.additionalProperties.type;

        var newFormData = _objectSpread({}, _this.props.formData);

        if (schema.additionalProperties.hasOwnProperty("$ref")) {
          var _this$props$registry = _this.props.registry,
              registry = _this$props$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getDefaultRegistry)() : _this$props$registry;
          var refSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.retrieveSchema)({
            $ref: schema.additionalProperties["$ref"]
          }, registry.rootSchema, _this.props.formData);
          type = refSchema.type;
        }

        newFormData[_this.getAvailableKey("newKey", newFormData)] = _this.getDefaultValue(type);

        _this.props.onChange(newFormData);
      };
    });

    return _this;
  }

  _createClass(ObjectField, [{
    key: "isRequired",
    value: function isRequired(name) {
      var schema = this.props.schema;
      return Array.isArray(schema.required) && schema.required.indexOf(name) !== -1;
    }
  }, {
    key: "getDefaultValue",
    value: function getDefaultValue(type) {
      switch (type) {
        case "string":
          return "New Value";

        case "array":
          return [];

        case "boolean":
          return false;

        case "null":
          return null;

        case "number":
          return 0;

        case "object":
          return {};

        default:
          // We don't have a datatype for some reason (perhaps additionalProperties was true)
          return "New Value";
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          uiSchema = _this$props2.uiSchema,
          formData = _this$props2.formData,
          errorSchema = _this$props2.errorSchema,
          idSchema = _this$props2.idSchema,
          name = _this$props2.name,
          required = _this$props2.required,
          disabled = _this$props2.disabled,
          readonly = _this$props2.readonly,
          idPrefix = _this$props2.idPrefix,
          onBlur = _this$props2.onBlur,
          onFocus = _this$props2.onFocus,
          _this$props2$registry = _this$props2.registry,
          registry = _this$props2$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getDefaultRegistry)() : _this$props2$registry;
      var rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var SchemaField = fields.SchemaField,
          TitleField = fields.TitleField,
          DescriptionField = fields.DescriptionField;
      var schema = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.retrieveSchema)(this.props.schema, rootSchema, formData);
      var title = schema.title === undefined ? name : schema.title;
      var description = uiSchema["ui:description"] || schema.description;
      var orderedProperties;

      try {
        var properties = Object.keys(schema.properties || {});
        orderedProperties = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.orderProperties)(properties, uiSchema["ui:order"]);
      } catch (err) {
        return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", null, react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", {
          className: "config-error",
          style: {
            color: "red"
          }
        }, "Invalid ", name || "root", " object field configuration:", react__WEBPACK_IMPORTED_MODULE_1___default().createElement("em", null, err.message), "."), react__WEBPACK_IMPORTED_MODULE_1___default().createElement("pre", null, JSON.stringify(schema)));
      }

      var Template = uiSchema["ui:ObjectFieldTemplate"] || registry.ObjectFieldTemplate || DefaultObjectFieldTemplate;
      var templateProps = {
        title: uiSchema["ui:title"] || title,
        description: description,
        TitleField: TitleField,
        DescriptionField: DescriptionField,
        properties: orderedProperties.map(function (name) {
          var addedByAdditionalProperties = schema.properties[name].hasOwnProperty(_utils__WEBPACK_IMPORTED_MODULE_3__.ADDITIONAL_PROPERTY_FLAG);
          var fieldUiSchema = addedByAdditionalProperties ? uiSchema.additionalProperties : uiSchema[name];
          var hidden = fieldUiSchema && fieldUiSchema["ui:widget"] === "hidden";
          return {
            content: react__WEBPACK_IMPORTED_MODULE_1___default().createElement(SchemaField, {
              key: name,
              name: name,
              required: _this2.isRequired(name),
              schema: schema.properties[name],
              uiSchema: fieldUiSchema,
              errorSchema: errorSchema[name],
              idSchema: idSchema[name],
              idPrefix: idPrefix,
              formData: (formData || {})[name],
              wasPropertyKeyModified: _this2.state.wasPropertyKeyModified,
              onKeyChange: _this2.onKeyChange(name),
              onChange: _this2.onPropertyChange(name, addedByAdditionalProperties),
              onBlur: onBlur,
              onFocus: onFocus,
              registry: registry,
              disabled: disabled,
              readonly: readonly,
              onDropPropertyClick: _this2.onDropPropertyClick
            }),
            name: name,
            readonly: readonly,
            disabled: disabled,
            required: required,
            hidden: hidden
          };
        }),
        readonly: readonly,
        disabled: disabled,
        required: required,
        idSchema: idSchema,
        uiSchema: uiSchema,
        schema: schema,
        formData: formData,
        formContext: formContext,
        registry: registry
      };
      return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(Template, _extends({}, templateProps, {
        onAddClick: this.handleAddClick
      }));
    }
  }]);

  return ObjectField;
}(react__WEBPACK_IMPORTED_MODULE_1__.Component);

_defineProperty(ObjectField, "defaultProps", {
  uiSchema: {},
  formData: {},
  errorSchema: {},
  idSchema: {},
  required: false,
  disabled: false,
  readonly: false
});

if (true) {
  ObjectField.propTypes = _types__WEBPACK_IMPORTED_MODULE_2__.fieldProps;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ObjectField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/SchemaField.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/SchemaField.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../IconButton */ "../../node_modules/@rjsf/core/dist/es/components/IconButton.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../types */ "../../node_modules/@rjsf/core/dist/es/types.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }






var REQUIRED_FIELD_SYMBOL = "*";
var COMPONENT_TYPES = {
  array: "ArrayField",
  "boolean": "BooleanField",
  integer: "NumberField",
  number: "NumberField",
  object: "ObjectField",
  string: "StringField",
  "null": "NullField"
};

function getFieldComponent(schema, uiSchema, idSchema, fields) {
  var field = uiSchema["ui:field"];

  if (typeof field === "function") {
    return field;
  }

  if (typeof field === "string" && field in fields) {
    return fields[field];
  }

  var componentName = COMPONENT_TYPES[(0,_utils__WEBPACK_IMPORTED_MODULE_3__.getSchemaType)(schema)]; // If the type is not defined and the schema uses 'anyOf' or 'oneOf', don't
  // render a field and let the MultiSchemaField component handle the form display

  if (!componentName && (schema.anyOf || schema.oneOf)) {
    return function () {
      return null;
    };
  }

  return componentName in fields ? fields[componentName] : function () {
    var UnsupportedField = fields.UnsupportedField;
    return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(UnsupportedField, {
      schema: schema,
      idSchema: idSchema,
      reason: "Unknown field type ".concat(schema.type)
    });
  };
}

function Label(props) {
  var label = props.label,
      required = props.required,
      id = props.id;

  if (!label) {
    return null;
  }

  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("label", {
    className: "control-label",
    htmlFor: id
  }, label, required && react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
    className: "required"
  }, REQUIRED_FIELD_SYMBOL));
}

function LabelInput(props) {
  var id = props.id,
      label = props.label,
      onChange = props.onChange;
  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("input", {
    className: "form-control",
    type: "text",
    id: id,
    onBlur: function onBlur(event) {
      return onChange(event.target.value);
    },
    defaultValue: label
  });
}

function Help(props) {
  var id = props.id,
      help = props.help;

  if (!help) {
    return null;
  }

  if (typeof help === "string") {
    return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("p", {
      id: id,
      className: "help-block"
    }, help);
  }

  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    id: id,
    className: "help-block"
  }, help);
}

function ErrorList(props) {
  var _props$errors = props.errors,
      errors = _props$errors === void 0 ? [] : _props$errors;

  if (errors.length === 0) {
    return null;
  }

  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", null, react__WEBPACK_IMPORTED_MODULE_1___default().createElement("ul", {
    className: "error-detail bs-callout bs-callout-info"
  }, errors.filter(function (elem) {
    return !!elem;
  }).map(function (error, index) {
    return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("li", {
      className: "text-danger",
      key: index
    }, error);
  })));
}

function DefaultTemplate(props) {
  var id = props.id,
      label = props.label,
      children = props.children,
      errors = props.errors,
      help = props.help,
      description = props.description,
      hidden = props.hidden,
      required = props.required,
      displayLabel = props.displayLabel;

  if (hidden) {
    return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: "hidden"
    }, children);
  }

  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(WrapIfAdditional, props, displayLabel && react__WEBPACK_IMPORTED_MODULE_1___default().createElement(Label, {
    label: label,
    required: required,
    id: id
  }), displayLabel && description ? description : null, children, errors, help);
}

if (true) {
  DefaultTemplate.propTypes = {
    id: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
    classNames: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
    children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node.isRequired),
    errors: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element),
    rawErrors: prop_types__WEBPACK_IMPORTED_MODULE_4___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)),
    help: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element),
    rawHelp: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element)]),
    description: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element),
    rawDescription: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element)]),
    hidden: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
    displayLabel: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
    fields: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object),
    formContext: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object)
  };
}

DefaultTemplate.defaultProps = {
  hidden: false,
  readonly: false,
  required: false,
  displayLabel: true
};

function WrapIfAdditional(props) {
  var id = props.id,
      classNames = props.classNames,
      disabled = props.disabled,
      label = props.label,
      onKeyChange = props.onKeyChange,
      onDropPropertyClick = props.onDropPropertyClick,
      readonly = props.readonly,
      required = props.required,
      schema = props.schema;
  var keyLabel = "".concat(label, " Key"); // i18n ?

  var additional = schema.hasOwnProperty(_utils__WEBPACK_IMPORTED_MODULE_3__.ADDITIONAL_PROPERTY_FLAG);

  if (!additional) {
    return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
      className: classNames
    }, props.children);
  }

  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: classNames
  }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "row"
  }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "col-xs-5 form-additional"
  }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "form-group"
  }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(Label, {
    label: keyLabel,
    required: required,
    id: "".concat(id, "-key")
  }), react__WEBPACK_IMPORTED_MODULE_1___default().createElement(LabelInput, {
    label: label,
    required: required,
    id: "".concat(id, "-key"),
    onChange: onKeyChange
  }))), react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "form-additional form-group col-xs-5"
  }, props.children), react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "col-xs-2"
  }, react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_IconButton__WEBPACK_IMPORTED_MODULE_0__["default"], {
    type: "danger",
    icon: "remove",
    className: "array-item-remove btn-block",
    tabIndex: "-1",
    style: {
      border: "0"
    },
    disabled: disabled || readonly,
    onClick: onDropPropertyClick(label)
  }))));
}

function SchemaFieldRender(props) {
  var uiSchema = props.uiSchema,
      formData = props.formData,
      errorSchema = props.errorSchema,
      idPrefix = props.idPrefix,
      name = props.name,
      onChange = props.onChange,
      onKeyChange = props.onKeyChange,
      onDropPropertyClick = props.onDropPropertyClick,
      required = props.required,
      _props$registry = props.registry,
      registry = _props$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getDefaultRegistry)() : _props$registry,
      _props$wasPropertyKey = props.wasPropertyKeyModified,
      wasPropertyKeyModified = _props$wasPropertyKey === void 0 ? false : _props$wasPropertyKey;
  var rootSchema = registry.rootSchema,
      fields = registry.fields,
      formContext = registry.formContext;
  var FieldTemplate = uiSchema["ui:FieldTemplate"] || registry.FieldTemplate || DefaultTemplate;
  var idSchema = props.idSchema;
  var schema = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.retrieveSchema)(props.schema, rootSchema, formData);
  idSchema = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.mergeObjects)((0,_utils__WEBPACK_IMPORTED_MODULE_3__.toIdSchema)(schema, null, rootSchema, formData, idPrefix), idSchema);
  var FieldComponent = getFieldComponent(schema, uiSchema, idSchema, fields);
  var DescriptionField = fields.DescriptionField;
  var disabled = Boolean(props.disabled || uiSchema["ui:disabled"]);
  var readonly = Boolean(props.readonly || uiSchema["ui:readonly"] || props.schema.readOnly || schema.readOnly);
  var autofocus = Boolean(props.autofocus || uiSchema["ui:autofocus"]);

  if (Object.keys(schema).length === 0) {
    return null;
  }

  var displayLabel = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getDisplayLabel)(schema, uiSchema, rootSchema);

  var __errors = errorSchema.__errors,
      fieldErrorSchema = _objectWithoutProperties(errorSchema, ["__errors"]); // See #439: uiSchema: Don't pass consumed class names to child components


  var field = react__WEBPACK_IMPORTED_MODULE_1___default().createElement(FieldComponent, _extends({}, props, {
    idSchema: idSchema,
    schema: schema,
    uiSchema: _objectSpread({}, uiSchema, {
      classNames: undefined
    }),
    disabled: disabled,
    readonly: readonly,
    autofocus: autofocus,
    errorSchema: fieldErrorSchema,
    formContext: formContext,
    rawErrors: __errors
  }));
  var id = idSchema.$id; // If this schema has a title defined, but the user has set a new key/label, retain their input.

  var label;

  if (wasPropertyKeyModified) {
    label = name;
  } else {
    label = uiSchema["ui:title"] || props.schema.title || schema.title || name;
  }

  var description = uiSchema["ui:description"] || props.schema.description || schema.description;
  var errors = __errors;
  var help = uiSchema["ui:help"];
  var hidden = uiSchema["ui:widget"] === "hidden";
  var classNames = ["form-group", "field", "field-".concat(schema.type), errors && errors.length > 0 ? "field-error has-error has-danger" : "", uiSchema.classNames].join(" ").trim();
  var fieldProps = {
    description: react__WEBPACK_IMPORTED_MODULE_1___default().createElement(DescriptionField, {
      id: id + "__description",
      description: description,
      formContext: formContext
    }),
    rawDescription: description,
    help: react__WEBPACK_IMPORTED_MODULE_1___default().createElement(Help, {
      id: id + "__help",
      help: help
    }),
    rawHelp: typeof help === "string" ? help : undefined,
    errors: react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ErrorList, {
      errors: errors
    }),
    rawErrors: errors,
    id: id,
    label: label,
    hidden: hidden,
    onChange: onChange,
    onKeyChange: onKeyChange,
    onDropPropertyClick: onDropPropertyClick,
    required: required,
    disabled: disabled,
    readonly: readonly,
    displayLabel: displayLabel,
    classNames: classNames,
    formContext: formContext,
    formData: formData,
    fields: fields,
    schema: schema,
    uiSchema: uiSchema,
    registry: registry
  };
  var _AnyOfField = registry.fields.AnyOfField;
  var _OneOfField = registry.fields.OneOfField;
  return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(FieldTemplate, fieldProps, react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, field, schema.anyOf && !(0,_utils__WEBPACK_IMPORTED_MODULE_3__.isSelect)(schema) && react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_AnyOfField, {
    disabled: disabled,
    errorSchema: errorSchema,
    formData: formData,
    idPrefix: idPrefix,
    idSchema: idSchema,
    onBlur: props.onBlur,
    onChange: props.onChange,
    onFocus: props.onFocus,
    options: schema.anyOf.map(function (_schema) {
      return (0,_utils__WEBPACK_IMPORTED_MODULE_3__.retrieveSchema)(_schema, rootSchema, formData);
    }),
    baseType: schema.type,
    registry: registry,
    schema: schema,
    uiSchema: uiSchema
  }), schema.oneOf && !(0,_utils__WEBPACK_IMPORTED_MODULE_3__.isSelect)(schema) && react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_OneOfField, {
    disabled: disabled,
    errorSchema: errorSchema,
    formData: formData,
    idPrefix: idPrefix,
    idSchema: idSchema,
    onBlur: props.onBlur,
    onChange: props.onChange,
    onFocus: props.onFocus,
    options: schema.oneOf.map(function (_schema) {
      return (0,_utils__WEBPACK_IMPORTED_MODULE_3__.retrieveSchema)(_schema, rootSchema, formData);
    }),
    baseType: schema.type,
    registry: registry,
    schema: schema,
    uiSchema: uiSchema
  })));
}

var SchemaField =
/*#__PURE__*/
function (_React$Component) {
  _inherits(SchemaField, _React$Component);

  function SchemaField() {
    _classCallCheck(this, SchemaField);

    return _possibleConstructorReturn(this, _getPrototypeOf(SchemaField).apply(this, arguments));
  }

  _createClass(SchemaField, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return !(0,_utils__WEBPACK_IMPORTED_MODULE_3__.deepEquals)(this.props, nextProps);
    }
  }, {
    key: "render",
    value: function render() {
      return SchemaFieldRender(this.props);
    }
  }]);

  return SchemaField;
}((react__WEBPACK_IMPORTED_MODULE_1___default().Component));

SchemaField.defaultProps = {
  uiSchema: {},
  errorSchema: {},
  idSchema: {},
  disabled: false,
  readonly: false,
  autofocus: false
};

if (true) {
  SchemaField.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object.isRequired),
    uiSchema: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object),
    idSchema: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object),
    formData: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().any),
    errorSchema: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object),
    registry: _types__WEBPACK_IMPORTED_MODULE_2__.registry.isRequired
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/StringField.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/StringField.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../types */ "../../node_modules/@rjsf/core/dist/es/types.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }





function StringField(props) {
  var schema = props.schema,
      name = props.name,
      uiSchema = props.uiSchema,
      idSchema = props.idSchema,
      formData = props.formData,
      required = props.required,
      disabled = props.disabled,
      readonly = props.readonly,
      autofocus = props.autofocus,
      onChange = props.onChange,
      onBlur = props.onBlur,
      onFocus = props.onFocus,
      _props$registry = props.registry,
      registry = _props$registry === void 0 ? (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getDefaultRegistry)() : _props$registry,
      rawErrors = props.rawErrors;
  var title = schema.title,
      format = schema.format;
  var widgets = registry.widgets,
      formContext = registry.formContext;
  var enumOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.isSelect)(schema) && (0,_utils__WEBPACK_IMPORTED_MODULE_2__.optionsList)(schema);
  var defaultWidget = enumOptions ? "select" : "text";

  if (format && (0,_utils__WEBPACK_IMPORTED_MODULE_2__.hasWidget)(schema, format, widgets)) {
    defaultWidget = format;
  }

  var _getUiOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema),
      _getUiOptions$widget = _getUiOptions.widget,
      widget = _getUiOptions$widget === void 0 ? defaultWidget : _getUiOptions$widget,
      _getUiOptions$placeho = _getUiOptions.placeholder,
      placeholder = _getUiOptions$placeho === void 0 ? "" : _getUiOptions$placeho,
      options = _objectWithoutProperties(_getUiOptions, ["widget", "placeholder"]);

  var Widget = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Widget, {
    options: _objectSpread({}, options, {
      enumOptions: enumOptions
    }),
    schema: schema,
    uiSchema: uiSchema,
    id: idSchema && idSchema.$id,
    label: title === undefined ? name : title,
    value: formData,
    onChange: onChange,
    onBlur: onBlur,
    onFocus: onFocus,
    required: required,
    disabled: disabled,
    readonly: readonly,
    formContext: formContext,
    autofocus: autofocus,
    registry: registry,
    placeholder: placeholder,
    rawErrors: rawErrors
  });
}

if (true) {
  StringField.propTypes = _types__WEBPACK_IMPORTED_MODULE_1__.fieldProps;
}

StringField.defaultProps = {
  uiSchema: {},
  disabled: false,
  readonly: false,
  autofocus: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StringField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/TitleField.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/TitleField.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);


var REQUIRED_FIELD_SYMBOL = "*";

function TitleField(props) {
  var id = props.id,
      title = props.title,
      required = props.required;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("legend", {
    id: id
  }, title, required && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "required"
  }, REQUIRED_FIELD_SYMBOL));
}

if (true) {
  TitleField.propTypes = {
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TitleField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL2ZpZWxkcy9UaXRsZUZpZWxkLmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwiUHJvcFR5cGVzIiwiUkVRVUlSRURfRklFTERfU1lNQk9MIiwiVGl0bGVGaWVsZCIsInByb3BzIiwiaWQiLCJ0aXRsZSIsInJlcXVpcmVkIiwicHJvY2VzcyIsImVudiIsIk5PREVfRU5WIiwicHJvcFR5cGVzIiwic3RyaW5nIiwiYm9vbCJdLCJtYXBwaW5ncyI6IkFBQUEsT0FBT0EsS0FBUCxNQUFrQixPQUFsQjtBQUNBLE9BQU9DLFNBQVAsTUFBc0IsWUFBdEI7QUFFQSxJQUFNQyxxQkFBcUIsR0FBRyxHQUE5Qjs7QUFFQSxTQUFTQyxVQUFULENBQW9CQyxLQUFwQixFQUEyQjtBQUFBLE1BQ2pCQyxFQURpQixHQUNPRCxLQURQLENBQ2pCQyxFQURpQjtBQUFBLE1BQ2JDLEtBRGEsR0FDT0YsS0FEUCxDQUNiRSxLQURhO0FBQUEsTUFDTkMsUUFETSxHQUNPSCxLQURQLENBQ05HLFFBRE07QUFFekIsU0FDRTtBQUFRLElBQUEsRUFBRSxFQUFFRjtBQUFaLEtBQ0dDLEtBREgsRUFFR0MsUUFBUSxJQUFJO0FBQU0sSUFBQSxTQUFTLEVBQUM7QUFBaEIsS0FBNEJMLHFCQUE1QixDQUZmLENBREY7QUFNRDs7QUFFRCxJQUFJTSxPQUFPLENBQUNDLEdBQVIsQ0FBWUMsUUFBWixLQUF5QixZQUE3QixFQUEyQztBQUN6Q1AsRUFBQUEsVUFBVSxDQUFDUSxTQUFYLEdBQXVCO0FBQ3JCTixJQUFBQSxFQUFFLEVBQUVKLFNBQVMsQ0FBQ1csTUFETztBQUVyQk4sSUFBQUEsS0FBSyxFQUFFTCxTQUFTLENBQUNXLE1BRkk7QUFHckJMLElBQUFBLFFBQVEsRUFBRU4sU0FBUyxDQUFDWTtBQUhDLEdBQXZCO0FBS0Q7O0FBRUQsZUFBZVYsVUFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcblxuY29uc3QgUkVRVUlSRURfRklFTERfU1lNQk9MID0gXCIqXCI7XG5cbmZ1bmN0aW9uIFRpdGxlRmllbGQocHJvcHMpIHtcbiAgY29uc3QgeyBpZCwgdGl0bGUsIHJlcXVpcmVkIH0gPSBwcm9wcztcbiAgcmV0dXJuIChcbiAgICA8bGVnZW5kIGlkPXtpZH0+XG4gICAgICB7dGl0bGV9XG4gICAgICB7cmVxdWlyZWQgJiYgPHNwYW4gY2xhc3NOYW1lPVwicmVxdWlyZWRcIj57UkVRVUlSRURfRklFTERfU1lNQk9MfTwvc3Bhbj59XG4gICAgPC9sZWdlbmQ+XG4gICk7XG59XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViAhPT0gXCJwcm9kdWN0aW9uXCIpIHtcbiAgVGl0bGVGaWVsZC5wcm9wVHlwZXMgPSB7XG4gICAgaWQ6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgdGl0bGU6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgcmVxdWlyZWQ6IFByb3BUeXBlcy5ib29sLFxuICB9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBUaXRsZUZpZWxkO1xuIl19

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/UnsupportedField.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/UnsupportedField.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



function UnsupportedField(_ref) {
  var schema = _ref.schema,
      idSchema = _ref.idSchema,
      reason = _ref.reason;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "unsupported-field"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Unsupported field schema", idSchema && idSchema.$id && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, " for", " field ", react__WEBPACK_IMPORTED_MODULE_0___default().createElement("code", null, idSchema.$id)), reason && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("em", null, ": ", reason), "."), schema && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("pre", null, JSON.stringify(schema, null, 2)));
}

if (true) {
  UnsupportedField.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object.isRequired),
    idSchema: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
    reason: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UnsupportedField);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/fields/index.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/fields/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ArrayField__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ArrayField */ "../../node_modules/@rjsf/core/dist/es/components/fields/ArrayField.js");
/* harmony import */ var _BooleanField__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BooleanField */ "../../node_modules/@rjsf/core/dist/es/components/fields/BooleanField.js");
/* harmony import */ var _DescriptionField__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DescriptionField */ "../../node_modules/@rjsf/core/dist/es/components/fields/DescriptionField.js");
/* harmony import */ var _MultiSchemaField__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MultiSchemaField */ "../../node_modules/@rjsf/core/dist/es/components/fields/MultiSchemaField.js");
/* harmony import */ var _NumberField__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./NumberField */ "../../node_modules/@rjsf/core/dist/es/components/fields/NumberField.js");
/* harmony import */ var _ObjectField__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ObjectField */ "../../node_modules/@rjsf/core/dist/es/components/fields/ObjectField.js");
/* harmony import */ var _SchemaField__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SchemaField */ "../../node_modules/@rjsf/core/dist/es/components/fields/SchemaField.js");
/* harmony import */ var _StringField__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./StringField */ "../../node_modules/@rjsf/core/dist/es/components/fields/StringField.js");
/* harmony import */ var _TitleField__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./TitleField */ "../../node_modules/@rjsf/core/dist/es/components/fields/TitleField.js");
/* harmony import */ var _NullField__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./NullField */ "../../node_modules/@rjsf/core/dist/es/components/fields/NullField.js");
/* harmony import */ var _UnsupportedField__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./UnsupportedField */ "../../node_modules/@rjsf/core/dist/es/components/fields/UnsupportedField.js");











/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  AnyOfField: _MultiSchemaField__WEBPACK_IMPORTED_MODULE_3__["default"],
  ArrayField: _ArrayField__WEBPACK_IMPORTED_MODULE_0__["default"],
  BooleanField: _BooleanField__WEBPACK_IMPORTED_MODULE_1__["default"],
  DescriptionField: _DescriptionField__WEBPACK_IMPORTED_MODULE_2__["default"],
  NumberField: _NumberField__WEBPACK_IMPORTED_MODULE_4__["default"],
  ObjectField: _ObjectField__WEBPACK_IMPORTED_MODULE_5__["default"],
  OneOfField: _MultiSchemaField__WEBPACK_IMPORTED_MODULE_3__["default"],
  SchemaField: _SchemaField__WEBPACK_IMPORTED_MODULE_6__["default"],
  StringField: _StringField__WEBPACK_IMPORTED_MODULE_7__["default"],
  TitleField: _TitleField__WEBPACK_IMPORTED_MODULE_8__["default"],
  NullField: _NullField__WEBPACK_IMPORTED_MODULE_9__["default"],
  UnsupportedField: _UnsupportedField__WEBPACK_IMPORTED_MODULE_10__["default"]
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/AltDateTimeWidget.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/AltDateTimeWidget.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _AltDateWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AltDateWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/AltDateWidget.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }





function AltDateTimeWidget(props) {
  var AltDateWidget = props.registry.widgets.AltDateWidget;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(AltDateWidget, _extends({
    time: true
  }, props));
}

if (true) {
  AltDateTimeWidget.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object.isRequired),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string.isRequired),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
    options: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object)
  };
}

AltDateTimeWidget.defaultProps = _objectSpread({}, _AltDateWidget__WEBPACK_IMPORTED_MODULE_1__["default"].defaultProps, {
  time: true
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AltDateTimeWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/AltDateWidget.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/AltDateWidget.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





function rangeOptions(start, stop) {
  var options = [];

  for (var i = start; i <= stop; i++) {
    options.push({
      value: i,
      label: (0,_utils__WEBPACK_IMPORTED_MODULE_1__.pad)(i, 2)
    });
  }

  return options;
}

function readyForChange(state) {
  return Object.keys(state).every(function (key) {
    return state[key] !== -1;
  });
}

function DateElement(props) {
  var type = props.type,
      range = props.range,
      value = props.value,
      select = props.select,
      rootId = props.rootId,
      disabled = props.disabled,
      readonly = props.readonly,
      autofocus = props.autofocus,
      registry = props.registry,
      onBlur = props.onBlur;
  var id = rootId + "_" + type;
  var SelectWidget = registry.widgets.SelectWidget;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SelectWidget, {
    schema: {
      type: "integer"
    },
    id: id,
    className: "form-control",
    options: {
      enumOptions: rangeOptions(range[0], range[1])
    },
    placeholder: type,
    value: value,
    disabled: disabled,
    readonly: readonly,
    autofocus: autofocus,
    onChange: function onChange(value) {
      return select(type, value);
    },
    onBlur: onBlur
  });
}

var AltDateWidget =
/*#__PURE__*/
function (_Component) {
  _inherits(AltDateWidget, _Component);

  function AltDateWidget(props) {
    var _this;

    _classCallCheck(this, AltDateWidget);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AltDateWidget).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "onChange", function (property, value) {
      _this.setState(_defineProperty({}, property, typeof value === "undefined" ? -1 : value), function () {
        // Only propagate to parent state if we have a complete date{time}
        if (readyForChange(_this.state)) {
          _this.props.onChange((0,_utils__WEBPACK_IMPORTED_MODULE_1__.toDateString)(_this.state, _this.props.time));
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "setNow", function (event) {
      event.preventDefault();
      var _this$props = _this.props,
          time = _this$props.time,
          disabled = _this$props.disabled,
          readonly = _this$props.readonly,
          onChange = _this$props.onChange;

      if (disabled || readonly) {
        return;
      }

      var nowDateObj = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.parseDateString)(new Date().toJSON(), time);

      _this.setState(nowDateObj, function () {
        return onChange((0,_utils__WEBPACK_IMPORTED_MODULE_1__.toDateString)(_this.state, time));
      });
    });

    _defineProperty(_assertThisInitialized(_this), "clear", function (event) {
      event.preventDefault();
      var _this$props2 = _this.props,
          time = _this$props2.time,
          disabled = _this$props2.disabled,
          readonly = _this$props2.readonly,
          onChange = _this$props2.onChange;

      if (disabled || readonly) {
        return;
      }

      _this.setState((0,_utils__WEBPACK_IMPORTED_MODULE_1__.parseDateString)("", time), function () {
        return onChange(undefined);
      });
    });

    _this.state = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.parseDateString)(props.value, props.time);
    return _this;
  }

  _createClass(AltDateWidget, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevProps.value && prevProps.value !== (0,_utils__WEBPACK_IMPORTED_MODULE_1__.parseDateString)(this.props.value, this.props.time)) {
        this.setState((0,_utils__WEBPACK_IMPORTED_MODULE_1__.parseDateString)(this.props.value, this.props.time));
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return (0,_utils__WEBPACK_IMPORTED_MODULE_1__.shouldRender)(this, nextProps, nextState);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props3 = this.props,
          id = _this$props3.id,
          disabled = _this$props3.disabled,
          readonly = _this$props3.readonly,
          autofocus = _this$props3.autofocus,
          registry = _this$props3.registry,
          onBlur = _this$props3.onBlur,
          options = _this$props3.options;
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
        className: "list-inline"
      }, this.dateElementProps.map(function (elemProps, i) {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
          key: i
        }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DateElement, _extends({
          rootId: id,
          select: _this2.onChange
        }, elemProps, {
          disabled: disabled,
          readonly: readonly,
          registry: registry,
          onBlur: onBlur,
          autofocus: autofocus && i === 0
        })));
      }), (options.hideNowButton !== "undefined" ? !options.hideNowButton : true) && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
        href: "#",
        className: "btn btn-info btn-now",
        onClick: this.setNow
      }, "Now")), (options.hideClearButton !== "undefined" ? !options.hideClearButton : true) && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
        href: "#",
        className: "btn btn-warning btn-clear",
        onClick: this.clear
      }, "Clear")));
    }
  }, {
    key: "dateElementProps",
    get: function get() {
      var _this$props4 = this.props,
          time = _this$props4.time,
          options = _this$props4.options;
      var _this$state = this.state,
          year = _this$state.year,
          month = _this$state.month,
          day = _this$state.day,
          hour = _this$state.hour,
          minute = _this$state.minute,
          second = _this$state.second;
      var data = [{
        type: "year",
        range: options.yearsRange,
        value: year
      }, {
        type: "month",
        range: [1, 12],
        value: month
      }, {
        type: "day",
        range: [1, 31],
        value: day
      }];

      if (time) {
        data.push({
          type: "hour",
          range: [0, 23],
          value: hour
        }, {
          type: "minute",
          range: [0, 59],
          value: minute
        }, {
          type: "second",
          range: [0, 59],
          value: second
        });
      }

      return data;
    }
  }]);

  return AltDateWidget;
}(react__WEBPACK_IMPORTED_MODULE_0__.Component);

_defineProperty(AltDateWidget, "defaultProps", {
  time: false,
  disabled: false,
  readonly: false,
  autofocus: false,
  options: {
    yearsRange: [1900, new Date().getFullYear() + 2]
  }
});

if (true) {
  AltDateWidget.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object.isRequired),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string.isRequired),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
    onBlur: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
    time: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    options: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AltDateWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/BaseInput.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/BaseInput.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }




function BaseInput(props) {
  // Note: since React 15.2.0 we can't forward unknown element attributes, so we
  // exclude the "options" and "schema" ones here.
  if (!props.id) {
    console.log("No id for", props);
    throw new Error("no id for props ".concat(JSON.stringify(props)));
  }

  var value = props.value,
      readonly = props.readonly,
      disabled = props.disabled,
      autofocus = props.autofocus,
      onBlur = props.onBlur,
      onFocus = props.onFocus,
      options = props.options,
      schema = props.schema,
      uiSchema = props.uiSchema,
      formContext = props.formContext,
      registry = props.registry,
      rawErrors = props.rawErrors,
      inputProps = _objectWithoutProperties(props, ["value", "readonly", "disabled", "autofocus", "onBlur", "onFocus", "options", "schema", "uiSchema", "formContext", "registry", "rawErrors"]); // If options.inputType is set use that as the input type


  if (options.inputType) {
    inputProps.type = options.inputType;
  } else if (!inputProps.type) {
    // If the schema is of type number or integer, set the input type to number
    if (schema.type === "number") {
      inputProps.type = "number"; // Setting step to 'any' fixes a bug in Safari where decimals are not
      // allowed in number inputs

      inputProps.step = "any";
    } else if (schema.type === "integer") {
      inputProps.type = "number"; // Since this is integer, you always want to step up or down in multiples
      // of 1

      inputProps.step = "1";
    } else {
      inputProps.type = "text";
    }
  }

  if (options.autocomplete) {
    inputProps.autoComplete = options.autocomplete;
  } // If multipleOf is defined, use this as the step value. This mainly improves
  // the experience for keyboard users (who can use the up/down KB arrows).


  if (schema.multipleOf) {
    inputProps.step = schema.multipleOf;
  }

  if (typeof schema.minimum !== "undefined") {
    inputProps.min = schema.minimum;
  }

  if (typeof schema.maximum !== "undefined") {
    inputProps.max = schema.maximum;
  }

  var _onChange = function _onChange(_ref) {
    var value = _ref.target.value;
    return props.onChange(value === "" ? options.emptyValue : value);
  };

  return [react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", _extends({
    key: inputProps.id,
    className: "form-control",
    readOnly: readonly,
    disabled: disabled,
    autoFocus: autofocus,
    value: value == null ? "" : value
  }, inputProps, {
    list: schema.examples ? "examples_".concat(inputProps.id) : null,
    onChange: _onChange,
    onBlur: onBlur && function (event) {
      return onBlur(inputProps.id, event.target.value);
    },
    onFocus: onFocus && function (event) {
      return onFocus(inputProps.id, event.target.value);
    }
  })), schema.examples ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement("datalist", {
    key: "datalist_".concat(inputProps.id),
    id: "examples_".concat(inputProps.id)
  }, _toConsumableArray(new Set(schema.examples.concat(schema["default"] ? [schema["default"]] : []))).map(function (example) {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", {
      key: example,
      value: example
    });
  })) : null];
}

BaseInput.defaultProps = {
  required: false,
  disabled: false,
  readonly: false,
  autofocus: false
};

if (true) {
  BaseInput.propTypes = {
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
    placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
    onBlur: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
    onFocus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseInput);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/CheckboxWidget.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/CheckboxWidget.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");




function CheckboxWidget(props) {
  var schema = props.schema,
      id = props.id,
      value = props.value,
      disabled = props.disabled,
      readonly = props.readonly,
      label = props.label,
      autofocus = props.autofocus,
      onBlur = props.onBlur,
      onFocus = props.onFocus,
      _onChange = props.onChange,
      DescriptionField = props.DescriptionField; // Because an unchecked checkbox will cause html5 validation to fail, only add
  // the "required" attribute if the field value must be "true", due to the
  // "const" or "enum" keywords

  var required = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.schemaRequiresTrueValue)(schema);
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "checkbox ".concat(disabled || readonly ? "disabled" : "")
  }, schema.description && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DescriptionField, {
    description: schema.description
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    type: "checkbox",
    id: id,
    checked: typeof value === "undefined" ? false : value,
    required: required,
    disabled: disabled || readonly,
    autoFocus: autofocus,
    onChange: function onChange(event) {
      return _onChange(event.target.checked);
    },
    onBlur: onBlur && function (event) {
      return onBlur(id, event.target.checked);
    },
    onFocus: onFocus && function (event) {
      return onFocus(id, event.target.checked);
    }
  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, label)));
}

CheckboxWidget.defaultProps = {
  autofocus: false
};

if (true) {
  CheckboxWidget.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object.isRequired),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string.isRequired),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvQ2hlY2tib3hXaWRnZXQuanMiXSwibmFtZXMiOlsiUmVhY3QiLCJQcm9wVHlwZXMiLCJzY2hlbWFSZXF1aXJlc1RydWVWYWx1ZSIsIkNoZWNrYm94V2lkZ2V0IiwicHJvcHMiLCJzY2hlbWEiLCJpZCIsInZhbHVlIiwiZGlzYWJsZWQiLCJyZWFkb25seSIsImxhYmVsIiwiYXV0b2ZvY3VzIiwib25CbHVyIiwib25Gb2N1cyIsIm9uQ2hhbmdlIiwiRGVzY3JpcHRpb25GaWVsZCIsInJlcXVpcmVkIiwiZGVzY3JpcHRpb24iLCJldmVudCIsInRhcmdldCIsImNoZWNrZWQiLCJkZWZhdWx0UHJvcHMiLCJwcm9jZXNzIiwiZW52IiwiTk9ERV9FTlYiLCJwcm9wVHlwZXMiLCJvYmplY3QiLCJpc1JlcXVpcmVkIiwic3RyaW5nIiwiYm9vbCIsImZ1bmMiXSwibWFwcGluZ3MiOiJBQUFBLE9BQU9BLEtBQVAsTUFBa0IsT0FBbEI7QUFDQSxPQUFPQyxTQUFQLE1BQXNCLFlBQXRCO0FBQ0EsU0FBU0MsdUJBQVQsUUFBd0MsYUFBeEM7O0FBRUEsU0FBU0MsY0FBVCxDQUF3QkMsS0FBeEIsRUFBK0I7QUFBQSxNQUUzQkMsTUFGMkIsR0FhekJELEtBYnlCLENBRTNCQyxNQUYyQjtBQUFBLE1BRzNCQyxFQUgyQixHQWF6QkYsS0FieUIsQ0FHM0JFLEVBSDJCO0FBQUEsTUFJM0JDLEtBSjJCLEdBYXpCSCxLQWJ5QixDQUkzQkcsS0FKMkI7QUFBQSxNQUszQkMsUUFMMkIsR0FhekJKLEtBYnlCLENBSzNCSSxRQUwyQjtBQUFBLE1BTTNCQyxRQU4yQixHQWF6QkwsS0FieUIsQ0FNM0JLLFFBTjJCO0FBQUEsTUFPM0JDLEtBUDJCLEdBYXpCTixLQWJ5QixDQU8zQk0sS0FQMkI7QUFBQSxNQVEzQkMsU0FSMkIsR0FhekJQLEtBYnlCLENBUTNCTyxTQVIyQjtBQUFBLE1BUzNCQyxNQVQyQixHQWF6QlIsS0FieUIsQ0FTM0JRLE1BVDJCO0FBQUEsTUFVM0JDLE9BVjJCLEdBYXpCVCxLQWJ5QixDQVUzQlMsT0FWMkI7QUFBQSxNQVczQkMsU0FYMkIsR0FhekJWLEtBYnlCLENBVzNCVSxRQVgyQjtBQUFBLE1BWTNCQyxnQkFaMkIsR0FhekJYLEtBYnlCLENBWTNCVyxnQkFaMkIsRUFlN0I7QUFDQTtBQUNBOztBQUNBLE1BQU1DLFFBQVEsR0FBR2QsdUJBQXVCLENBQUNHLE1BQUQsQ0FBeEM7QUFFQSxTQUNFO0FBQUssSUFBQSxTQUFTLHFCQUFjRyxRQUFRLElBQUlDLFFBQVosR0FBdUIsVUFBdkIsR0FBb0MsRUFBbEQ7QUFBZCxLQUNHSixNQUFNLENBQUNZLFdBQVAsSUFDQyxvQkFBQyxnQkFBRDtBQUFrQixJQUFBLFdBQVcsRUFBRVosTUFBTSxDQUFDWTtBQUF0QyxJQUZKLEVBSUUsbUNBQ0U7QUFDRSxJQUFBLElBQUksRUFBQyxVQURQO0FBRUUsSUFBQSxFQUFFLEVBQUVYLEVBRk47QUFHRSxJQUFBLE9BQU8sRUFBRSxPQUFPQyxLQUFQLEtBQWlCLFdBQWpCLEdBQStCLEtBQS9CLEdBQXVDQSxLQUhsRDtBQUlFLElBQUEsUUFBUSxFQUFFUyxRQUpaO0FBS0UsSUFBQSxRQUFRLEVBQUVSLFFBQVEsSUFBSUMsUUFMeEI7QUFNRSxJQUFBLFNBQVMsRUFBRUUsU0FOYjtBQU9FLElBQUEsUUFBUSxFQUFFLGtCQUFBTyxLQUFLO0FBQUEsYUFBSUosU0FBUSxDQUFDSSxLQUFLLENBQUNDLE1BQU4sQ0FBYUMsT0FBZCxDQUFaO0FBQUEsS0FQakI7QUFRRSxJQUFBLE1BQU0sRUFBRVIsTUFBTSxJQUFLLFVBQUFNLEtBQUs7QUFBQSxhQUFJTixNQUFNLENBQUNOLEVBQUQsRUFBS1ksS0FBSyxDQUFDQyxNQUFOLENBQWFDLE9BQWxCLENBQVY7QUFBQSxLQVIxQjtBQVNFLElBQUEsT0FBTyxFQUFFUCxPQUFPLElBQUssVUFBQUssS0FBSztBQUFBLGFBQUlMLE9BQU8sQ0FBQ1AsRUFBRCxFQUFLWSxLQUFLLENBQUNDLE1BQU4sQ0FBYUMsT0FBbEIsQ0FBWDtBQUFBO0FBVDVCLElBREYsRUFZRSxrQ0FBT1YsS0FBUCxDQVpGLENBSkYsQ0FERjtBQXFCRDs7QUFFRFAsY0FBYyxDQUFDa0IsWUFBZixHQUE4QjtBQUM1QlYsRUFBQUEsU0FBUyxFQUFFO0FBRGlCLENBQTlCOztBQUlBLElBQUlXLE9BQU8sQ0FBQ0MsR0FBUixDQUFZQyxRQUFaLEtBQXlCLFlBQTdCLEVBQTJDO0FBQ3pDckIsRUFBQUEsY0FBYyxDQUFDc0IsU0FBZixHQUEyQjtBQUN6QnBCLElBQUFBLE1BQU0sRUFBRUosU0FBUyxDQUFDeUIsTUFBVixDQUFpQkMsVUFEQTtBQUV6QnJCLElBQUFBLEVBQUUsRUFBRUwsU0FBUyxDQUFDMkIsTUFBVixDQUFpQkQsVUFGSTtBQUd6QnBCLElBQUFBLEtBQUssRUFBRU4sU0FBUyxDQUFDNEIsSUFIUTtBQUl6QmIsSUFBQUEsUUFBUSxFQUFFZixTQUFTLENBQUM0QixJQUpLO0FBS3pCckIsSUFBQUEsUUFBUSxFQUFFUCxTQUFTLENBQUM0QixJQUxLO0FBTXpCcEIsSUFBQUEsUUFBUSxFQUFFUixTQUFTLENBQUM0QixJQU5LO0FBT3pCbEIsSUFBQUEsU0FBUyxFQUFFVixTQUFTLENBQUM0QixJQVBJO0FBUXpCZixJQUFBQSxRQUFRLEVBQUViLFNBQVMsQ0FBQzZCO0FBUkssR0FBM0I7QUFVRDs7QUFFRCxlQUFlM0IsY0FBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcbmltcG9ydCB7IHNjaGVtYVJlcXVpcmVzVHJ1ZVZhbHVlIH0gZnJvbSBcIi4uLy4uL3V0aWxzXCI7XG5cbmZ1bmN0aW9uIENoZWNrYm94V2lkZ2V0KHByb3BzKSB7XG4gIGNvbnN0IHtcbiAgICBzY2hlbWEsXG4gICAgaWQsXG4gICAgdmFsdWUsXG4gICAgZGlzYWJsZWQsXG4gICAgcmVhZG9ubHksXG4gICAgbGFiZWwsXG4gICAgYXV0b2ZvY3VzLFxuICAgIG9uQmx1cixcbiAgICBvbkZvY3VzLFxuICAgIG9uQ2hhbmdlLFxuICAgIERlc2NyaXB0aW9uRmllbGQsXG4gIH0gPSBwcm9wcztcblxuICAvLyBCZWNhdXNlIGFuIHVuY2hlY2tlZCBjaGVja2JveCB3aWxsIGNhdXNlIGh0bWw1IHZhbGlkYXRpb24gdG8gZmFpbCwgb25seSBhZGRcbiAgLy8gdGhlIFwicmVxdWlyZWRcIiBhdHRyaWJ1dGUgaWYgdGhlIGZpZWxkIHZhbHVlIG11c3QgYmUgXCJ0cnVlXCIsIGR1ZSB0byB0aGVcbiAgLy8gXCJjb25zdFwiIG9yIFwiZW51bVwiIGtleXdvcmRzXG4gIGNvbnN0IHJlcXVpcmVkID0gc2NoZW1hUmVxdWlyZXNUcnVlVmFsdWUoc2NoZW1hKTtcblxuICByZXR1cm4gKFxuICAgIDxkaXYgY2xhc3NOYW1lPXtgY2hlY2tib3ggJHtkaXNhYmxlZCB8fCByZWFkb25seSA/IFwiZGlzYWJsZWRcIiA6IFwiXCJ9YH0+XG4gICAgICB7c2NoZW1hLmRlc2NyaXB0aW9uICYmIChcbiAgICAgICAgPERlc2NyaXB0aW9uRmllbGQgZGVzY3JpcHRpb249e3NjaGVtYS5kZXNjcmlwdGlvbn0gLz5cbiAgICAgICl9XG4gICAgICA8bGFiZWw+XG4gICAgICAgIDxpbnB1dFxuICAgICAgICAgIHR5cGU9XCJjaGVja2JveFwiXG4gICAgICAgICAgaWQ9e2lkfVxuICAgICAgICAgIGNoZWNrZWQ9e3R5cGVvZiB2YWx1ZSA9PT0gXCJ1bmRlZmluZWRcIiA/IGZhbHNlIDogdmFsdWV9XG4gICAgICAgICAgcmVxdWlyZWQ9e3JlcXVpcmVkfVxuICAgICAgICAgIGRpc2FibGVkPXtkaXNhYmxlZCB8fCByZWFkb25seX1cbiAgICAgICAgICBhdXRvRm9jdXM9e2F1dG9mb2N1c31cbiAgICAgICAgICBvbkNoYW5nZT17ZXZlbnQgPT4gb25DaGFuZ2UoZXZlbnQudGFyZ2V0LmNoZWNrZWQpfVxuICAgICAgICAgIG9uQmx1cj17b25CbHVyICYmIChldmVudCA9PiBvbkJsdXIoaWQsIGV2ZW50LnRhcmdldC5jaGVja2VkKSl9XG4gICAgICAgICAgb25Gb2N1cz17b25Gb2N1cyAmJiAoZXZlbnQgPT4gb25Gb2N1cyhpZCwgZXZlbnQudGFyZ2V0LmNoZWNrZWQpKX1cbiAgICAgICAgLz5cbiAgICAgICAgPHNwYW4+e2xhYmVsfTwvc3Bhbj5cbiAgICAgIDwvbGFiZWw+XG4gICAgPC9kaXY+XG4gICk7XG59XG5cbkNoZWNrYm94V2lkZ2V0LmRlZmF1bHRQcm9wcyA9IHtcbiAgYXV0b2ZvY3VzOiBmYWxzZSxcbn07XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViAhPT0gXCJwcm9kdWN0aW9uXCIpIHtcbiAgQ2hlY2tib3hXaWRnZXQucHJvcFR5cGVzID0ge1xuICAgIHNjaGVtYTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGlkOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgdmFsdWU6IFByb3BUeXBlcy5ib29sLFxuICAgIHJlcXVpcmVkOiBQcm9wVHlwZXMuYm9vbCxcbiAgICBkaXNhYmxlZDogUHJvcFR5cGVzLmJvb2wsXG4gICAgcmVhZG9ubHk6IFByb3BUeXBlcy5ib29sLFxuICAgIGF1dG9mb2N1czogUHJvcFR5cGVzLmJvb2wsXG4gICAgb25DaGFuZ2U6IFByb3BUeXBlcy5mdW5jLFxuICB9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBDaGVja2JveFdpZGdldDtcbiJdfQ==

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/CheckboxesWidget.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/CheckboxesWidget.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



function selectValue(value, selected, all) {
  var at = all.indexOf(value);
  var updated = selected.slice(0, at).concat(value, selected.slice(at)); // As inserting values at predefined index positions doesn't work with empty
  // arrays, we need to reorder the updated selection to match the initial order

  return updated.sort(function (a, b) {
    return all.indexOf(a) > all.indexOf(b);
  });
}

function deselectValue(value, selected) {
  return selected.filter(function (v) {
    return v !== value;
  });
}

function CheckboxesWidget(props) {
  var id = props.id,
      disabled = props.disabled,
      options = props.options,
      value = props.value,
      autofocus = props.autofocus,
      readonly = props.readonly,
      _onChange = props.onChange;
  var enumOptions = options.enumOptions,
      enumDisabled = options.enumDisabled,
      inline = options.inline;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "checkboxes",
    id: id
  }, enumOptions.map(function (option, index) {
    var checked = value.indexOf(option.value) !== -1;
    var itemDisabled = enumDisabled && enumDisabled.indexOf(option.value) != -1;
    var disabledCls = disabled || itemDisabled || readonly ? "disabled" : "";
    var checkbox = react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
      type: "checkbox",
      id: "".concat(id, "_").concat(index),
      checked: checked,
      disabled: disabled || itemDisabled || readonly,
      autoFocus: autofocus && index === 0,
      onChange: function onChange(event) {
        var all = enumOptions.map(function (_ref) {
          var value = _ref.value;
          return value;
        });

        if (event.target.checked) {
          _onChange(selectValue(option.value, value, all));
        } else {
          _onChange(deselectValue(option.value, value));
        }
      }
    }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, option.label));
    return inline ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
      key: index,
      className: "checkbox-inline ".concat(disabledCls)
    }, checkbox) : react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      key: index,
      className: "checkbox ".concat(disabledCls)
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", null, checkbox));
  }));
}

CheckboxesWidget.defaultProps = {
  autofocus: false,
  options: {
    inline: false
  }
};

if (true) {
  CheckboxesWidget.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object.isRequired),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
    options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
      enumOptions: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array),
      inline: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
    }).isRequired,
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    multiple: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxesWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/ColorWidget.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/ColorWidget.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }




function ColorWidget(props) {
  var disabled = props.disabled,
      readonly = props.readonly,
      BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, _extends({
    type: "color"
  }, props, {
    disabled: disabled || readonly
  }));
}

if (true) {
  ColorWidget.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object.isRequired),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ColorWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/DateTimeWidget.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/DateTimeWidget.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }





function DateTimeWidget(props) {
  var value = props.value,
      _onChange = props.onChange,
      BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, _extends({
    type: "datetime-local"
  }, props, {
    value: (0,_utils__WEBPACK_IMPORTED_MODULE_1__.utcToLocal)(value),
    onChange: function onChange(value) {
      return _onChange((0,_utils__WEBPACK_IMPORTED_MODULE_1__.localToUTC)(value));
    }
  }));
}

if (true) {
  DateTimeWidget.propTypes = {
    value: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DateTimeWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/DateWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/DateWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }




function DateWidget(props) {
  var _onChange = props.onChange,
      BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, _extends({
    type: "date"
  }, props, {
    onChange: function onChange(value) {
      return _onChange(value || undefined);
    }
  }));
}

if (true) {
  DateWidget.propTypes = {
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DateWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvRGF0ZVdpZGdldC5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsIlByb3BUeXBlcyIsIkRhdGVXaWRnZXQiLCJwcm9wcyIsIm9uQ2hhbmdlIiwiQmFzZUlucHV0IiwicmVnaXN0cnkiLCJ3aWRnZXRzIiwidmFsdWUiLCJ1bmRlZmluZWQiLCJwcm9jZXNzIiwiZW52IiwiTk9ERV9FTlYiLCJwcm9wVHlwZXMiLCJzdHJpbmciXSwibWFwcGluZ3MiOiI7O0FBQUEsT0FBT0EsS0FBUCxNQUFrQixPQUFsQjtBQUNBLE9BQU9DLFNBQVAsTUFBc0IsWUFBdEI7O0FBRUEsU0FBU0MsVUFBVCxDQUFvQkMsS0FBcEIsRUFBMkI7QUFBQSxNQUV2QkMsU0FGdUIsR0FNckJELEtBTnFCLENBRXZCQyxRQUZ1QjtBQUFBLE1BSVZDLFNBSlUsR0FNckJGLEtBTnFCLENBR3ZCRyxRQUh1QixDQUlyQkMsT0FKcUIsQ0FJVkYsU0FKVTtBQU96QixTQUNFLG9CQUFDLFNBQUQ7QUFDRSxJQUFBLElBQUksRUFBQztBQURQLEtBRU1GLEtBRk47QUFHRSxJQUFBLFFBQVEsRUFBRSxrQkFBQUssS0FBSztBQUFBLGFBQUlKLFNBQVEsQ0FBQ0ksS0FBSyxJQUFJQyxTQUFWLENBQVo7QUFBQTtBQUhqQixLQURGO0FBT0Q7O0FBRUQsSUFBSUMsT0FBTyxDQUFDQyxHQUFSLENBQVlDLFFBQVosS0FBeUIsWUFBN0IsRUFBMkM7QUFDekNWLEVBQUFBLFVBQVUsQ0FBQ1csU0FBWCxHQUF1QjtBQUNyQkwsSUFBQUEsS0FBSyxFQUFFUCxTQUFTLENBQUNhO0FBREksR0FBdkI7QUFHRDs7QUFFRCxlQUFlWixVQUFmIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gXCJyZWFjdFwiO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tIFwicHJvcC10eXBlc1wiO1xuXG5mdW5jdGlvbiBEYXRlV2lkZ2V0KHByb3BzKSB7XG4gIGNvbnN0IHtcbiAgICBvbkNoYW5nZSxcbiAgICByZWdpc3RyeToge1xuICAgICAgd2lkZ2V0czogeyBCYXNlSW5wdXQgfSxcbiAgICB9LFxuICB9ID0gcHJvcHM7XG4gIHJldHVybiAoXG4gICAgPEJhc2VJbnB1dFxuICAgICAgdHlwZT1cImRhdGVcIlxuICAgICAgey4uLnByb3BzfVxuICAgICAgb25DaGFuZ2U9e3ZhbHVlID0+IG9uQ2hhbmdlKHZhbHVlIHx8IHVuZGVmaW5lZCl9XG4gICAgLz5cbiAgKTtcbn1cblxuaWYgKHByb2Nlc3MuZW52Lk5PREVfRU5WICE9PSBcInByb2R1Y3Rpb25cIikge1xuICBEYXRlV2lkZ2V0LnByb3BUeXBlcyA9IHtcbiAgICB2YWx1ZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgfTtcbn1cblxuZXhwb3J0IGRlZmF1bHQgRGF0ZVdpZGdldDtcbiJdfQ==

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/EmailWidget.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/EmailWidget.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }




function EmailWidget(props) {
  var BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, _extends({
    type: "email"
  }, props));
}

if (true) {
  EmailWidget.propTypes = {
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EmailWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvRW1haWxXaWRnZXQuanMiXSwibmFtZXMiOlsiUmVhY3QiLCJQcm9wVHlwZXMiLCJFbWFpbFdpZGdldCIsInByb3BzIiwiQmFzZUlucHV0IiwicmVnaXN0cnkiLCJ3aWRnZXRzIiwicHJvY2VzcyIsImVudiIsIk5PREVfRU5WIiwicHJvcFR5cGVzIiwidmFsdWUiLCJzdHJpbmciXSwibWFwcGluZ3MiOiI7O0FBQUEsT0FBT0EsS0FBUCxNQUFrQixPQUFsQjtBQUNBLE9BQU9DLFNBQVAsTUFBc0IsWUFBdEI7O0FBRUEsU0FBU0MsV0FBVCxDQUFxQkMsS0FBckIsRUFBNEI7QUFBQSxNQUNsQkMsU0FEa0IsR0FDSkQsS0FBSyxDQUFDRSxRQUFOLENBQWVDLE9BRFgsQ0FDbEJGLFNBRGtCO0FBRTFCLFNBQU8sb0JBQUMsU0FBRDtBQUFXLElBQUEsSUFBSSxFQUFDO0FBQWhCLEtBQTRCRCxLQUE1QixFQUFQO0FBQ0Q7O0FBRUQsSUFBSUksT0FBTyxDQUFDQyxHQUFSLENBQVlDLFFBQVosS0FBeUIsWUFBN0IsRUFBMkM7QUFDekNQLEVBQUFBLFdBQVcsQ0FBQ1EsU0FBWixHQUF3QjtBQUN0QkMsSUFBQUEsS0FBSyxFQUFFVixTQUFTLENBQUNXO0FBREssR0FBeEI7QUFHRDs7QUFFRCxlQUFlVixXQUFmIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gXCJyZWFjdFwiO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tIFwicHJvcC10eXBlc1wiO1xuXG5mdW5jdGlvbiBFbWFpbFdpZGdldChwcm9wcykge1xuICBjb25zdCB7IEJhc2VJbnB1dCB9ID0gcHJvcHMucmVnaXN0cnkud2lkZ2V0cztcbiAgcmV0dXJuIDxCYXNlSW5wdXQgdHlwZT1cImVtYWlsXCIgey4uLnByb3BzfSAvPjtcbn1cblxuaWYgKHByb2Nlc3MuZW52Lk5PREVfRU5WICE9PSBcInByb2R1Y3Rpb25cIikge1xuICBFbWFpbFdpZGdldC5wcm9wVHlwZXMgPSB7XG4gICAgdmFsdWU6IFByb3BUeXBlcy5zdHJpbmcsXG4gIH07XG59XG5cbmV4cG9ydCBkZWZhdWx0IEVtYWlsV2lkZ2V0O1xuIl19

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/FileWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/FileWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





function addNameToDataURL(dataURL, name) {
  return dataURL.replace(";base64", ";name=".concat(encodeURIComponent(name), ";base64"));
}

function processFile(file) {
  var name = file.name,
      size = file.size,
      type = file.type;
  return new Promise(function (resolve, reject) {
    var reader = new window.FileReader();
    reader.onerror = reject;

    reader.onload = function (event) {
      resolve({
        dataURL: addNameToDataURL(event.target.result, name),
        name: name,
        size: size,
        type: type
      });
    };

    reader.readAsDataURL(file);
  });
}

function processFiles(files) {
  return Promise.all([].map.call(files, processFile));
}

function FilesInfo(props) {
  var filesInfo = props.filesInfo;

  if (filesInfo.length === 0) {
    return null;
  }

  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
    className: "file-info"
  }, filesInfo.map(function (fileInfo, key) {
    var name = fileInfo.name,
        size = fileInfo.size,
        type = fileInfo.type;
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
      key: key
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("strong", null, name), " (", type, ", ", size, " bytes)");
  }));
}

function extractFileInfo(dataURLs) {
  return dataURLs.filter(function (dataURL) {
    return typeof dataURL !== "undefined";
  }).map(function (dataURL) {
    var _dataURItoBlob = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.dataURItoBlob)(dataURL),
        blob = _dataURItoBlob.blob,
        name = _dataURItoBlob.name;

    return {
      name: name,
      size: blob.size,
      type: blob.type
    };
  });
}

var FileWidget =
/*#__PURE__*/
function (_Component) {
  _inherits(FileWidget, _Component);

  function FileWidget(props) {
    var _this;

    _classCallCheck(this, FileWidget);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FileWidget).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "onChange", function (event) {
      var _this$props = _this.props,
          multiple = _this$props.multiple,
          onChange = _this$props.onChange;
      processFiles(event.target.files).then(function (filesInfo) {
        var state = {
          values: filesInfo.map(function (fileInfo) {
            return fileInfo.dataURL;
          }),
          filesInfo: filesInfo
        };

        _this.setState(state, function () {
          if (multiple) {
            onChange(state.values);
          } else {
            onChange(state.values[0]);
          }
        });
      });
    });

    var value = props.value;
    var values = Array.isArray(value) ? value : [value];
    _this.state = {
      values: values,
      filesInfo: extractFileInfo(values)
    };
    return _this;
  }

  _createClass(FileWidget, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return (0,_utils__WEBPACK_IMPORTED_MODULE_1__.shouldRender)(this, nextProps, nextState);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          multiple = _this$props2.multiple,
          id = _this$props2.id,
          readonly = _this$props2.readonly,
          disabled = _this$props2.disabled,
          autofocus = _this$props2.autofocus,
          options = _this$props2.options;
      var filesInfo = this.state.filesInfo;
      return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
        ref: function ref(_ref) {
          return _this2.inputRef = _ref;
        },
        id: id,
        type: "file",
        disabled: readonly || disabled,
        onChange: this.onChange,
        defaultValue: "",
        autoFocus: autofocus,
        multiple: multiple,
        accept: options.accept
      })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FilesInfo, {
        filesInfo: filesInfo
      }));
    }
  }]);

  return FileWidget;
}(react__WEBPACK_IMPORTED_MODULE_0__.Component);

FileWidget.defaultProps = {
  autofocus: false
};

if (true) {
  FileWidget.propTypes = {
    multiple: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    value: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().string), prop_types__WEBPACK_IMPORTED_MODULE_2___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_2___default().string))]),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FileWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/HiddenWidget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/HiddenWidget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



function HiddenWidget(_ref) {
  var id = _ref.id,
      value = _ref.value;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    type: "hidden",
    id: id,
    value: typeof value === "undefined" ? "" : value
  });
}

if (true) {
  HiddenWidget.propTypes = {
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
    value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)])
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HiddenWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvSGlkZGVuV2lkZ2V0LmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwiUHJvcFR5cGVzIiwiSGlkZGVuV2lkZ2V0IiwiaWQiLCJ2YWx1ZSIsInByb2Nlc3MiLCJlbnYiLCJOT0RFX0VOViIsInByb3BUeXBlcyIsInN0cmluZyIsImlzUmVxdWlyZWQiLCJvbmVPZlR5cGUiLCJudW1iZXIiLCJib29sIl0sIm1hcHBpbmdzIjoiQUFBQSxPQUFPQSxLQUFQLE1BQWtCLE9BQWxCO0FBQ0EsT0FBT0MsU0FBUCxNQUFzQixZQUF0Qjs7QUFFQSxTQUFTQyxZQUFULE9BQXFDO0FBQUEsTUFBYkMsRUFBYSxRQUFiQSxFQUFhO0FBQUEsTUFBVEMsS0FBUyxRQUFUQSxLQUFTO0FBQ25DLFNBQ0U7QUFDRSxJQUFBLElBQUksRUFBQyxRQURQO0FBRUUsSUFBQSxFQUFFLEVBQUVELEVBRk47QUFHRSxJQUFBLEtBQUssRUFBRSxPQUFPQyxLQUFQLEtBQWlCLFdBQWpCLEdBQStCLEVBQS9CLEdBQW9DQTtBQUg3QyxJQURGO0FBT0Q7O0FBRUQsSUFBSUMsT0FBTyxDQUFDQyxHQUFSLENBQVlDLFFBQVosS0FBeUIsWUFBN0IsRUFBMkM7QUFDekNMLEVBQUFBLFlBQVksQ0FBQ00sU0FBYixHQUF5QjtBQUN2QkwsSUFBQUEsRUFBRSxFQUFFRixTQUFTLENBQUNRLE1BQVYsQ0FBaUJDLFVBREU7QUFFdkJOLElBQUFBLEtBQUssRUFBRUgsU0FBUyxDQUFDVSxTQUFWLENBQW9CLENBQ3pCVixTQUFTLENBQUNRLE1BRGUsRUFFekJSLFNBQVMsQ0FBQ1csTUFGZSxFQUd6QlgsU0FBUyxDQUFDWSxJQUhlLENBQXBCO0FBRmdCLEdBQXpCO0FBUUQ7O0FBRUQsZUFBZVgsWUFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcblxuZnVuY3Rpb24gSGlkZGVuV2lkZ2V0KHsgaWQsIHZhbHVlIH0pIHtcbiAgcmV0dXJuIChcbiAgICA8aW5wdXRcbiAgICAgIHR5cGU9XCJoaWRkZW5cIlxuICAgICAgaWQ9e2lkfVxuICAgICAgdmFsdWU9e3R5cGVvZiB2YWx1ZSA9PT0gXCJ1bmRlZmluZWRcIiA/IFwiXCIgOiB2YWx1ZX1cbiAgICAvPlxuICApO1xufVxuXG5pZiAocHJvY2Vzcy5lbnYuTk9ERV9FTlYgIT09IFwicHJvZHVjdGlvblwiKSB7XG4gIEhpZGRlbldpZGdldC5wcm9wVHlwZXMgPSB7XG4gICAgaWQ6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICB2YWx1ZTogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgICBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgUHJvcFR5cGVzLm51bWJlcixcbiAgICAgIFByb3BUeXBlcy5ib29sLFxuICAgIF0pLFxuICB9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBIaWRkZW5XaWRnZXQ7XG4iXX0=

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/PasswordWidget.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/PasswordWidget.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }




function PasswordWidget(props) {
  var BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, _extends({
    type: "password"
  }, props));
}

if (true) {
  PasswordWidget.propTypes = {
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PasswordWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvUGFzc3dvcmRXaWRnZXQuanMiXSwibmFtZXMiOlsiUmVhY3QiLCJQcm9wVHlwZXMiLCJQYXNzd29yZFdpZGdldCIsInByb3BzIiwiQmFzZUlucHV0IiwicmVnaXN0cnkiLCJ3aWRnZXRzIiwicHJvY2VzcyIsImVudiIsIk5PREVfRU5WIiwicHJvcFR5cGVzIiwidmFsdWUiLCJzdHJpbmciXSwibWFwcGluZ3MiOiI7O0FBQUEsT0FBT0EsS0FBUCxNQUFrQixPQUFsQjtBQUNBLE9BQU9DLFNBQVAsTUFBc0IsWUFBdEI7O0FBRUEsU0FBU0MsY0FBVCxDQUF3QkMsS0FBeEIsRUFBK0I7QUFBQSxNQUNyQkMsU0FEcUIsR0FDUEQsS0FBSyxDQUFDRSxRQUFOLENBQWVDLE9BRFIsQ0FDckJGLFNBRHFCO0FBRTdCLFNBQU8sb0JBQUMsU0FBRDtBQUFXLElBQUEsSUFBSSxFQUFDO0FBQWhCLEtBQStCRCxLQUEvQixFQUFQO0FBQ0Q7O0FBRUQsSUFBSUksT0FBTyxDQUFDQyxHQUFSLENBQVlDLFFBQVosS0FBeUIsWUFBN0IsRUFBMkM7QUFDekNQLEVBQUFBLGNBQWMsQ0FBQ1EsU0FBZixHQUEyQjtBQUN6QkMsSUFBQUEsS0FBSyxFQUFFVixTQUFTLENBQUNXO0FBRFEsR0FBM0I7QUFHRDs7QUFFRCxlQUFlVixjQUFmIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gXCJyZWFjdFwiO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tIFwicHJvcC10eXBlc1wiO1xuXG5mdW5jdGlvbiBQYXNzd29yZFdpZGdldChwcm9wcykge1xuICBjb25zdCB7IEJhc2VJbnB1dCB9ID0gcHJvcHMucmVnaXN0cnkud2lkZ2V0cztcbiAgcmV0dXJuIDxCYXNlSW5wdXQgdHlwZT1cInBhc3N3b3JkXCIgey4uLnByb3BzfSAvPjtcbn1cblxuaWYgKHByb2Nlc3MuZW52Lk5PREVfRU5WICE9PSBcInByb2R1Y3Rpb25cIikge1xuICBQYXNzd29yZFdpZGdldC5wcm9wVHlwZXMgPSB7XG4gICAgdmFsdWU6IFByb3BUeXBlcy5zdHJpbmcsXG4gIH07XG59XG5cbmV4cG9ydCBkZWZhdWx0IFBhc3N3b3JkV2lkZ2V0O1xuIl19

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/RadioWidget.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/RadioWidget.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



function RadioWidget(props) {
  var options = props.options,
      value = props.value,
      required = props.required,
      disabled = props.disabled,
      readonly = props.readonly,
      autofocus = props.autofocus,
      onBlur = props.onBlur,
      onFocus = props.onFocus,
      _onChange = props.onChange,
      id = props.id; // Generating a unique field name to identify this set of radio buttons

  var name = Math.random().toString();
  var enumOptions = options.enumOptions,
      enumDisabled = options.enumDisabled,
      inline = options.inline; // checked={checked} has been moved above name={name}, As mentioned in #349;
  // this is a temporary fix for radio button rendering bug in React, facebook/react#7630.

  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "field-radio-group",
    id: id
  }, enumOptions.map(function (option, i) {
    var checked = option.value === value;
    var itemDisabled = enumDisabled && enumDisabled.indexOf(option.value) != -1;
    var disabledCls = disabled || itemDisabled || readonly ? "disabled" : "";
    var radio = react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
      type: "radio",
      checked: checked,
      name: name,
      required: required,
      value: option.value,
      disabled: disabled || itemDisabled || readonly,
      autoFocus: autofocus && i === 0,
      onChange: function onChange(_) {
        return _onChange(option.value);
      },
      onBlur: onBlur && function (event) {
        return onBlur(id, event.target.value);
      },
      onFocus: onFocus && function (event) {
        return onFocus(id, event.target.value);
      }
    }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, option.label));
    return inline ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
      key: i,
      className: "radio-inline ".concat(disabledCls)
    }, radio) : react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      key: i,
      className: "radio ".concat(disabledCls)
    }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", null, radio));
  }));
}

RadioWidget.defaultProps = {
  autofocus: false
};

if (true) {
  RadioWidget.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object.isRequired),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
    options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
      enumOptions: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array),
      inline: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
    }).isRequired,
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RadioWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/RangeWidget.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/RangeWidget.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }





function RangeWidget(props) {
  var schema = props.schema,
      value = props.value,
      BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "field-range-wrapper"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, _extends({
    type: "range"
  }, props, (0,_utils__WEBPACK_IMPORTED_MODULE_1__.rangeSpec)(schema))), react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "range-view"
  }, value));
}

if (true) {
  RangeWidget.propTypes = {
    value: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)])
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RangeWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/SelectWidget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/SelectWidget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");



var nums = new Set(["number", "integer"]);
/**
 * This is a silly limitation in the DOM where option change event values are
 * always retrieved as strings.
 */

function processValue(schema, value) {
  // "enum" is a reserved word, so only "type" and "items" can be destructured
  var type = schema.type,
      items = schema.items;

  if (value === "") {
    return undefined;
  } else if (type === "array" && items && nums.has(items.type)) {
    return value.map(_utils__WEBPACK_IMPORTED_MODULE_1__.asNumber);
  } else if (type === "boolean") {
    return value === "true";
  } else if (type === "number") {
    return (0,_utils__WEBPACK_IMPORTED_MODULE_1__.asNumber)(value);
  } // If type is undefined, but an enum is present, try and infer the type from
  // the enum values


  if (schema["enum"]) {
    if (schema["enum"].every(function (x) {
      return (0,_utils__WEBPACK_IMPORTED_MODULE_1__.guessType)(x) === "number";
    })) {
      return (0,_utils__WEBPACK_IMPORTED_MODULE_1__.asNumber)(value);
    } else if (schema["enum"].every(function (x) {
      return (0,_utils__WEBPACK_IMPORTED_MODULE_1__.guessType)(x) === "boolean";
    })) {
      return value === "true";
    }
  }

  return value;
}

function getValue(event, multiple) {
  if (multiple) {
    return [].slice.call(event.target.options).filter(function (o) {
      return o.selected;
    }).map(function (o) {
      return o.value;
    });
  } else {
    return event.target.value;
  }
}

function SelectWidget(props) {
  var schema = props.schema,
      id = props.id,
      options = props.options,
      value = props.value,
      required = props.required,
      disabled = props.disabled,
      readonly = props.readonly,
      multiple = props.multiple,
      autofocus = props.autofocus,
      _onChange = props.onChange,
      onBlur = props.onBlur,
      onFocus = props.onFocus,
      placeholder = props.placeholder;
  var enumOptions = options.enumOptions,
      enumDisabled = options.enumDisabled;
  var emptyValue = multiple ? [] : "";
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", {
    id: id,
    multiple: multiple,
    className: "form-control",
    value: typeof value === "undefined" ? emptyValue : value,
    required: required,
    disabled: disabled || readonly,
    autoFocus: autofocus,
    onBlur: onBlur && function (event) {
      var newValue = getValue(event, multiple);
      onBlur(id, processValue(schema, newValue));
    },
    onFocus: onFocus && function (event) {
      var newValue = getValue(event, multiple);
      onFocus(id, processValue(schema, newValue));
    },
    onChange: function onChange(event) {
      var newValue = getValue(event, multiple);

      _onChange(processValue(schema, newValue));
    }
  }, !multiple && schema["default"] === undefined && react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", {
    value: ""
  }, placeholder), enumOptions.map(function (_ref, i) {
    var value = _ref.value,
        label = _ref.label;
    var disabled = enumDisabled && enumDisabled.indexOf(value) != -1;
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", {
      key: i,
      value: value,
      disabled: disabled
    }, label);
  }));
}

SelectWidget.defaultProps = {
  autofocus: false
};

if (true) {
  SelectWidget.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object.isRequired),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string.isRequired),
    options: prop_types__WEBPACK_IMPORTED_MODULE_2___default().shape({
      enumOptions: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().array)
    }).isRequired,
    value: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().any),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    multiple: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
    onBlur: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
    onFocus: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SelectWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvU2VsZWN0V2lkZ2V0LmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwiUHJvcFR5cGVzIiwiYXNOdW1iZXIiLCJndWVzc1R5cGUiLCJudW1zIiwiU2V0IiwicHJvY2Vzc1ZhbHVlIiwic2NoZW1hIiwidmFsdWUiLCJ0eXBlIiwiaXRlbXMiLCJ1bmRlZmluZWQiLCJoYXMiLCJtYXAiLCJldmVyeSIsIngiLCJnZXRWYWx1ZSIsImV2ZW50IiwibXVsdGlwbGUiLCJzbGljZSIsImNhbGwiLCJ0YXJnZXQiLCJvcHRpb25zIiwiZmlsdGVyIiwibyIsInNlbGVjdGVkIiwiU2VsZWN0V2lkZ2V0IiwicHJvcHMiLCJpZCIsInJlcXVpcmVkIiwiZGlzYWJsZWQiLCJyZWFkb25seSIsImF1dG9mb2N1cyIsIm9uQ2hhbmdlIiwib25CbHVyIiwib25Gb2N1cyIsInBsYWNlaG9sZGVyIiwiZW51bU9wdGlvbnMiLCJlbnVtRGlzYWJsZWQiLCJlbXB0eVZhbHVlIiwibmV3VmFsdWUiLCJpIiwibGFiZWwiLCJpbmRleE9mIiwiZGVmYXVsdFByb3BzIiwicHJvY2VzcyIsImVudiIsIk5PREVfRU5WIiwicHJvcFR5cGVzIiwib2JqZWN0IiwiaXNSZXF1aXJlZCIsInN0cmluZyIsInNoYXBlIiwiYXJyYXkiLCJhbnkiLCJib29sIiwiZnVuYyJdLCJtYXBwaW5ncyI6IkFBQUEsT0FBT0EsS0FBUCxNQUFrQixPQUFsQjtBQUNBLE9BQU9DLFNBQVAsTUFBc0IsWUFBdEI7QUFFQSxTQUFTQyxRQUFULEVBQW1CQyxTQUFuQixRQUFvQyxhQUFwQztBQUVBLElBQU1DLElBQUksR0FBRyxJQUFJQyxHQUFKLENBQVEsQ0FBQyxRQUFELEVBQVcsU0FBWCxDQUFSLENBQWI7QUFFQTs7Ozs7QUFJQSxTQUFTQyxZQUFULENBQXNCQyxNQUF0QixFQUE4QkMsS0FBOUIsRUFBcUM7QUFDbkM7QUFEbUMsTUFFM0JDLElBRjJCLEdBRVhGLE1BRlcsQ0FFM0JFLElBRjJCO0FBQUEsTUFFckJDLEtBRnFCLEdBRVhILE1BRlcsQ0FFckJHLEtBRnFCOztBQUduQyxNQUFJRixLQUFLLEtBQUssRUFBZCxFQUFrQjtBQUNoQixXQUFPRyxTQUFQO0FBQ0QsR0FGRCxNQUVPLElBQUlGLElBQUksS0FBSyxPQUFULElBQW9CQyxLQUFwQixJQUE2Qk4sSUFBSSxDQUFDUSxHQUFMLENBQVNGLEtBQUssQ0FBQ0QsSUFBZixDQUFqQyxFQUF1RDtBQUM1RCxXQUFPRCxLQUFLLENBQUNLLEdBQU4sQ0FBVVgsUUFBVixDQUFQO0FBQ0QsR0FGTSxNQUVBLElBQUlPLElBQUksS0FBSyxTQUFiLEVBQXdCO0FBQzdCLFdBQU9ELEtBQUssS0FBSyxNQUFqQjtBQUNELEdBRk0sTUFFQSxJQUFJQyxJQUFJLEtBQUssUUFBYixFQUF1QjtBQUM1QixXQUFPUCxRQUFRLENBQUNNLEtBQUQsQ0FBZjtBQUNELEdBWGtDLENBYW5DO0FBQ0E7OztBQUNBLE1BQUlELE1BQU0sUUFBVixFQUFpQjtBQUNmLFFBQUlBLE1BQU0sUUFBTixDQUFZTyxLQUFaLENBQWtCLFVBQUFDLENBQUM7QUFBQSxhQUFJWixTQUFTLENBQUNZLENBQUQsQ0FBVCxLQUFpQixRQUFyQjtBQUFBLEtBQW5CLENBQUosRUFBdUQ7QUFDckQsYUFBT2IsUUFBUSxDQUFDTSxLQUFELENBQWY7QUFDRCxLQUZELE1BRU8sSUFBSUQsTUFBTSxRQUFOLENBQVlPLEtBQVosQ0FBa0IsVUFBQUMsQ0FBQztBQUFBLGFBQUlaLFNBQVMsQ0FBQ1ksQ0FBRCxDQUFULEtBQWlCLFNBQXJCO0FBQUEsS0FBbkIsQ0FBSixFQUF3RDtBQUM3RCxhQUFPUCxLQUFLLEtBQUssTUFBakI7QUFDRDtBQUNGOztBQUVELFNBQU9BLEtBQVA7QUFDRDs7QUFFRCxTQUFTUSxRQUFULENBQWtCQyxLQUFsQixFQUF5QkMsUUFBekIsRUFBbUM7QUFDakMsTUFBSUEsUUFBSixFQUFjO0FBQ1osV0FBTyxHQUFHQyxLQUFILENBQ0pDLElBREksQ0FDQ0gsS0FBSyxDQUFDSSxNQUFOLENBQWFDLE9BRGQsRUFFSkMsTUFGSSxDQUVHLFVBQUFDLENBQUM7QUFBQSxhQUFJQSxDQUFDLENBQUNDLFFBQU47QUFBQSxLQUZKLEVBR0paLEdBSEksQ0FHQSxVQUFBVyxDQUFDO0FBQUEsYUFBSUEsQ0FBQyxDQUFDaEIsS0FBTjtBQUFBLEtBSEQsQ0FBUDtBQUlELEdBTEQsTUFLTztBQUNMLFdBQU9TLEtBQUssQ0FBQ0ksTUFBTixDQUFhYixLQUFwQjtBQUNEO0FBQ0Y7O0FBRUQsU0FBU2tCLFlBQVQsQ0FBc0JDLEtBQXRCLEVBQTZCO0FBQUEsTUFFekJwQixNQUZ5QixHQWV2Qm9CLEtBZnVCLENBRXpCcEIsTUFGeUI7QUFBQSxNQUd6QnFCLEVBSHlCLEdBZXZCRCxLQWZ1QixDQUd6QkMsRUFIeUI7QUFBQSxNQUl6Qk4sT0FKeUIsR0FldkJLLEtBZnVCLENBSXpCTCxPQUp5QjtBQUFBLE1BS3pCZCxLQUx5QixHQWV2Qm1CLEtBZnVCLENBS3pCbkIsS0FMeUI7QUFBQSxNQU16QnFCLFFBTnlCLEdBZXZCRixLQWZ1QixDQU16QkUsUUFOeUI7QUFBQSxNQU96QkMsUUFQeUIsR0FldkJILEtBZnVCLENBT3pCRyxRQVB5QjtBQUFBLE1BUXpCQyxRQVJ5QixHQWV2QkosS0FmdUIsQ0FRekJJLFFBUnlCO0FBQUEsTUFTekJiLFFBVHlCLEdBZXZCUyxLQWZ1QixDQVN6QlQsUUFUeUI7QUFBQSxNQVV6QmMsU0FWeUIsR0FldkJMLEtBZnVCLENBVXpCSyxTQVZ5QjtBQUFBLE1BV3pCQyxTQVh5QixHQWV2Qk4sS0FmdUIsQ0FXekJNLFFBWHlCO0FBQUEsTUFZekJDLE1BWnlCLEdBZXZCUCxLQWZ1QixDQVl6Qk8sTUFaeUI7QUFBQSxNQWF6QkMsT0FieUIsR0FldkJSLEtBZnVCLENBYXpCUSxPQWJ5QjtBQUFBLE1BY3pCQyxXQWR5QixHQWV2QlQsS0FmdUIsQ0FjekJTLFdBZHlCO0FBQUEsTUFnQm5CQyxXQWhCbUIsR0FnQldmLE9BaEJYLENBZ0JuQmUsV0FoQm1CO0FBQUEsTUFnQk5DLFlBaEJNLEdBZ0JXaEIsT0FoQlgsQ0FnQk5nQixZQWhCTTtBQWlCM0IsTUFBTUMsVUFBVSxHQUFHckIsUUFBUSxHQUFHLEVBQUgsR0FBUSxFQUFuQztBQUNBLFNBQ0U7QUFDRSxJQUFBLEVBQUUsRUFBRVUsRUFETjtBQUVFLElBQUEsUUFBUSxFQUFFVixRQUZaO0FBR0UsSUFBQSxTQUFTLEVBQUMsY0FIWjtBQUlFLElBQUEsS0FBSyxFQUFFLE9BQU9WLEtBQVAsS0FBaUIsV0FBakIsR0FBK0IrQixVQUEvQixHQUE0Qy9CLEtBSnJEO0FBS0UsSUFBQSxRQUFRLEVBQUVxQixRQUxaO0FBTUUsSUFBQSxRQUFRLEVBQUVDLFFBQVEsSUFBSUMsUUFOeEI7QUFPRSxJQUFBLFNBQVMsRUFBRUMsU0FQYjtBQVFFLElBQUEsTUFBTSxFQUNKRSxNQUFNLElBQ0wsVUFBQWpCLEtBQUssRUFBSTtBQUNSLFVBQU11QixRQUFRLEdBQUd4QixRQUFRLENBQUNDLEtBQUQsRUFBUUMsUUFBUixDQUF6QjtBQUNBZ0IsTUFBQUEsTUFBTSxDQUFDTixFQUFELEVBQUt0QixZQUFZLENBQUNDLE1BQUQsRUFBU2lDLFFBQVQsQ0FBakIsQ0FBTjtBQUNELEtBYkw7QUFlRSxJQUFBLE9BQU8sRUFDTEwsT0FBTyxJQUNOLFVBQUFsQixLQUFLLEVBQUk7QUFDUixVQUFNdUIsUUFBUSxHQUFHeEIsUUFBUSxDQUFDQyxLQUFELEVBQVFDLFFBQVIsQ0FBekI7QUFDQWlCLE1BQUFBLE9BQU8sQ0FBQ1AsRUFBRCxFQUFLdEIsWUFBWSxDQUFDQyxNQUFELEVBQVNpQyxRQUFULENBQWpCLENBQVA7QUFDRCxLQXBCTDtBQXNCRSxJQUFBLFFBQVEsRUFBRSxrQkFBQXZCLEtBQUssRUFBSTtBQUNqQixVQUFNdUIsUUFBUSxHQUFHeEIsUUFBUSxDQUFDQyxLQUFELEVBQVFDLFFBQVIsQ0FBekI7O0FBQ0FlLE1BQUFBLFNBQVEsQ0FBQzNCLFlBQVksQ0FBQ0MsTUFBRCxFQUFTaUMsUUFBVCxDQUFiLENBQVI7QUFDRDtBQXpCSCxLQTBCRyxDQUFDdEIsUUFBRCxJQUFhWCxNQUFNLFdBQU4sS0FBbUJJLFNBQWhDLElBQ0M7QUFBUSxJQUFBLEtBQUssRUFBQztBQUFkLEtBQWtCeUIsV0FBbEIsQ0EzQkosRUE2QkdDLFdBQVcsQ0FBQ3hCLEdBQVosQ0FBZ0IsZ0JBQW1CNEIsQ0FBbkIsRUFBeUI7QUFBQSxRQUF0QmpDLEtBQXNCLFFBQXRCQSxLQUFzQjtBQUFBLFFBQWZrQyxLQUFlLFFBQWZBLEtBQWU7QUFDeEMsUUFBTVosUUFBUSxHQUFHUSxZQUFZLElBQUlBLFlBQVksQ0FBQ0ssT0FBYixDQUFxQm5DLEtBQXJCLEtBQStCLENBQUMsQ0FBakU7QUFDQSxXQUNFO0FBQVEsTUFBQSxHQUFHLEVBQUVpQyxDQUFiO0FBQWdCLE1BQUEsS0FBSyxFQUFFakMsS0FBdkI7QUFBOEIsTUFBQSxRQUFRLEVBQUVzQjtBQUF4QyxPQUNHWSxLQURILENBREY7QUFLRCxHQVBBLENBN0JILENBREY7QUF3Q0Q7O0FBRURoQixZQUFZLENBQUNrQixZQUFiLEdBQTRCO0FBQzFCWixFQUFBQSxTQUFTLEVBQUU7QUFEZSxDQUE1Qjs7QUFJQSxJQUFJYSxPQUFPLENBQUNDLEdBQVIsQ0FBWUMsUUFBWixLQUF5QixZQUE3QixFQUEyQztBQUN6Q3JCLEVBQUFBLFlBQVksQ0FBQ3NCLFNBQWIsR0FBeUI7QUFDdkJ6QyxJQUFBQSxNQUFNLEVBQUVOLFNBQVMsQ0FBQ2dELE1BQVYsQ0FBaUJDLFVBREY7QUFFdkJ0QixJQUFBQSxFQUFFLEVBQUUzQixTQUFTLENBQUNrRCxNQUFWLENBQWlCRCxVQUZFO0FBR3ZCNUIsSUFBQUEsT0FBTyxFQUFFckIsU0FBUyxDQUFDbUQsS0FBVixDQUFnQjtBQUN2QmYsTUFBQUEsV0FBVyxFQUFFcEMsU0FBUyxDQUFDb0Q7QUFEQSxLQUFoQixFQUVOSCxVQUxvQjtBQU12QjFDLElBQUFBLEtBQUssRUFBRVAsU0FBUyxDQUFDcUQsR0FOTTtBQU92QnpCLElBQUFBLFFBQVEsRUFBRTVCLFNBQVMsQ0FBQ3NELElBUEc7QUFRdkJ6QixJQUFBQSxRQUFRLEVBQUU3QixTQUFTLENBQUNzRCxJQVJHO0FBU3ZCeEIsSUFBQUEsUUFBUSxFQUFFOUIsU0FBUyxDQUFDc0QsSUFURztBQVV2QnJDLElBQUFBLFFBQVEsRUFBRWpCLFNBQVMsQ0FBQ3NELElBVkc7QUFXdkJ2QixJQUFBQSxTQUFTLEVBQUUvQixTQUFTLENBQUNzRCxJQVhFO0FBWXZCdEIsSUFBQUEsUUFBUSxFQUFFaEMsU0FBUyxDQUFDdUQsSUFaRztBQWF2QnRCLElBQUFBLE1BQU0sRUFBRWpDLFNBQVMsQ0FBQ3VELElBYks7QUFjdkJyQixJQUFBQSxPQUFPLEVBQUVsQyxTQUFTLENBQUN1RDtBQWRJLEdBQXpCO0FBZ0JEOztBQUVELGVBQWU5QixZQUFmIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gXCJyZWFjdFwiO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tIFwicHJvcC10eXBlc1wiO1xuXG5pbXBvcnQgeyBhc051bWJlciwgZ3Vlc3NUeXBlIH0gZnJvbSBcIi4uLy4uL3V0aWxzXCI7XG5cbmNvbnN0IG51bXMgPSBuZXcgU2V0KFtcIm51bWJlclwiLCBcImludGVnZXJcIl0pO1xuXG4vKipcbiAqIFRoaXMgaXMgYSBzaWxseSBsaW1pdGF0aW9uIGluIHRoZSBET00gd2hlcmUgb3B0aW9uIGNoYW5nZSBldmVudCB2YWx1ZXMgYXJlXG4gKiBhbHdheXMgcmV0cmlldmVkIGFzIHN0cmluZ3MuXG4gKi9cbmZ1bmN0aW9uIHByb2Nlc3NWYWx1ZShzY2hlbWEsIHZhbHVlKSB7XG4gIC8vIFwiZW51bVwiIGlzIGEgcmVzZXJ2ZWQgd29yZCwgc28gb25seSBcInR5cGVcIiBhbmQgXCJpdGVtc1wiIGNhbiBiZSBkZXN0cnVjdHVyZWRcbiAgY29uc3QgeyB0eXBlLCBpdGVtcyB9ID0gc2NoZW1hO1xuICBpZiAodmFsdWUgPT09IFwiXCIpIHtcbiAgICByZXR1cm4gdW5kZWZpbmVkO1xuICB9IGVsc2UgaWYgKHR5cGUgPT09IFwiYXJyYXlcIiAmJiBpdGVtcyAmJiBudW1zLmhhcyhpdGVtcy50eXBlKSkge1xuICAgIHJldHVybiB2YWx1ZS5tYXAoYXNOdW1iZXIpO1xuICB9IGVsc2UgaWYgKHR5cGUgPT09IFwiYm9vbGVhblwiKSB7XG4gICAgcmV0dXJuIHZhbHVlID09PSBcInRydWVcIjtcbiAgfSBlbHNlIGlmICh0eXBlID09PSBcIm51bWJlclwiKSB7XG4gICAgcmV0dXJuIGFzTnVtYmVyKHZhbHVlKTtcbiAgfVxuXG4gIC8vIElmIHR5cGUgaXMgdW5kZWZpbmVkLCBidXQgYW4gZW51bSBpcyBwcmVzZW50LCB0cnkgYW5kIGluZmVyIHRoZSB0eXBlIGZyb21cbiAgLy8gdGhlIGVudW0gdmFsdWVzXG4gIGlmIChzY2hlbWEuZW51bSkge1xuICAgIGlmIChzY2hlbWEuZW51bS5ldmVyeSh4ID0+IGd1ZXNzVHlwZSh4KSA9PT0gXCJudW1iZXJcIikpIHtcbiAgICAgIHJldHVybiBhc051bWJlcih2YWx1ZSk7XG4gICAgfSBlbHNlIGlmIChzY2hlbWEuZW51bS5ldmVyeSh4ID0+IGd1ZXNzVHlwZSh4KSA9PT0gXCJib29sZWFuXCIpKSB7XG4gICAgICByZXR1cm4gdmFsdWUgPT09IFwidHJ1ZVwiO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiB2YWx1ZTtcbn1cblxuZnVuY3Rpb24gZ2V0VmFsdWUoZXZlbnQsIG11bHRpcGxlKSB7XG4gIGlmIChtdWx0aXBsZSkge1xuICAgIHJldHVybiBbXS5zbGljZVxuICAgICAgLmNhbGwoZXZlbnQudGFyZ2V0Lm9wdGlvbnMpXG4gICAgICAuZmlsdGVyKG8gPT4gby5zZWxlY3RlZClcbiAgICAgIC5tYXAobyA9PiBvLnZhbHVlKTtcbiAgfSBlbHNlIHtcbiAgICByZXR1cm4gZXZlbnQudGFyZ2V0LnZhbHVlO1xuICB9XG59XG5cbmZ1bmN0aW9uIFNlbGVjdFdpZGdldChwcm9wcykge1xuICBjb25zdCB7XG4gICAgc2NoZW1hLFxuICAgIGlkLFxuICAgIG9wdGlvbnMsXG4gICAgdmFsdWUsXG4gICAgcmVxdWlyZWQsXG4gICAgZGlzYWJsZWQsXG4gICAgcmVhZG9ubHksXG4gICAgbXVsdGlwbGUsXG4gICAgYXV0b2ZvY3VzLFxuICAgIG9uQ2hhbmdlLFxuICAgIG9uQmx1cixcbiAgICBvbkZvY3VzLFxuICAgIHBsYWNlaG9sZGVyLFxuICB9ID0gcHJvcHM7XG4gIGNvbnN0IHsgZW51bU9wdGlvbnMsIGVudW1EaXNhYmxlZCB9ID0gb3B0aW9ucztcbiAgY29uc3QgZW1wdHlWYWx1ZSA9IG11bHRpcGxlID8gW10gOiBcIlwiO1xuICByZXR1cm4gKFxuICAgIDxzZWxlY3RcbiAgICAgIGlkPXtpZH1cbiAgICAgIG11bHRpcGxlPXttdWx0aXBsZX1cbiAgICAgIGNsYXNzTmFtZT1cImZvcm0tY29udHJvbFwiXG4gICAgICB2YWx1ZT17dHlwZW9mIHZhbHVlID09PSBcInVuZGVmaW5lZFwiID8gZW1wdHlWYWx1ZSA6IHZhbHVlfVxuICAgICAgcmVxdWlyZWQ9e3JlcXVpcmVkfVxuICAgICAgZGlzYWJsZWQ9e2Rpc2FibGVkIHx8IHJlYWRvbmx5fVxuICAgICAgYXV0b0ZvY3VzPXthdXRvZm9jdXN9XG4gICAgICBvbkJsdXI9e1xuICAgICAgICBvbkJsdXIgJiZcbiAgICAgICAgKGV2ZW50ID0+IHtcbiAgICAgICAgICBjb25zdCBuZXdWYWx1ZSA9IGdldFZhbHVlKGV2ZW50LCBtdWx0aXBsZSk7XG4gICAgICAgICAgb25CbHVyKGlkLCBwcm9jZXNzVmFsdWUoc2NoZW1hLCBuZXdWYWx1ZSkpO1xuICAgICAgICB9KVxuICAgICAgfVxuICAgICAgb25Gb2N1cz17XG4gICAgICAgIG9uRm9jdXMgJiZcbiAgICAgICAgKGV2ZW50ID0+IHtcbiAgICAgICAgICBjb25zdCBuZXdWYWx1ZSA9IGdldFZhbHVlKGV2ZW50LCBtdWx0aXBsZSk7XG4gICAgICAgICAgb25Gb2N1cyhpZCwgcHJvY2Vzc1ZhbHVlKHNjaGVtYSwgbmV3VmFsdWUpKTtcbiAgICAgICAgfSlcbiAgICAgIH1cbiAgICAgIG9uQ2hhbmdlPXtldmVudCA9PiB7XG4gICAgICAgIGNvbnN0IG5ld1ZhbHVlID0gZ2V0VmFsdWUoZXZlbnQsIG11bHRpcGxlKTtcbiAgICAgICAgb25DaGFuZ2UocHJvY2Vzc1ZhbHVlKHNjaGVtYSwgbmV3VmFsdWUpKTtcbiAgICAgIH19PlxuICAgICAgeyFtdWx0aXBsZSAmJiBzY2hlbWEuZGVmYXVsdCA9PT0gdW5kZWZpbmVkICYmIChcbiAgICAgICAgPG9wdGlvbiB2YWx1ZT1cIlwiPntwbGFjZWhvbGRlcn08L29wdGlvbj5cbiAgICAgICl9XG4gICAgICB7ZW51bU9wdGlvbnMubWFwKCh7IHZhbHVlLCBsYWJlbCB9LCBpKSA9PiB7XG4gICAgICAgIGNvbnN0IGRpc2FibGVkID0gZW51bURpc2FibGVkICYmIGVudW1EaXNhYmxlZC5pbmRleE9mKHZhbHVlKSAhPSAtMTtcbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICA8b3B0aW9uIGtleT17aX0gdmFsdWU9e3ZhbHVlfSBkaXNhYmxlZD17ZGlzYWJsZWR9PlxuICAgICAgICAgICAge2xhYmVsfVxuICAgICAgICAgIDwvb3B0aW9uPlxuICAgICAgICApO1xuICAgICAgfSl9XG4gICAgPC9zZWxlY3Q+XG4gICk7XG59XG5cblNlbGVjdFdpZGdldC5kZWZhdWx0UHJvcHMgPSB7XG4gIGF1dG9mb2N1czogZmFsc2UsXG59O1xuXG5pZiAocHJvY2Vzcy5lbnYuTk9ERV9FTlYgIT09IFwicHJvZHVjdGlvblwiKSB7XG4gIFNlbGVjdFdpZGdldC5wcm9wVHlwZXMgPSB7XG4gICAgc2NoZW1hOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgaWQ6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICBvcHRpb25zOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgZW51bU9wdGlvbnM6IFByb3BUeXBlcy5hcnJheSxcbiAgICB9KS5pc1JlcXVpcmVkLFxuICAgIHZhbHVlOiBQcm9wVHlwZXMuYW55LFxuICAgIHJlcXVpcmVkOiBQcm9wVHlwZXMuYm9vbCxcbiAgICBkaXNhYmxlZDogUHJvcFR5cGVzLmJvb2wsXG4gICAgcmVhZG9ubHk6IFByb3BUeXBlcy5ib29sLFxuICAgIG11bHRpcGxlOiBQcm9wVHlwZXMuYm9vbCxcbiAgICBhdXRvZm9jdXM6IFByb3BUeXBlcy5ib29sLFxuICAgIG9uQ2hhbmdlOiBQcm9wVHlwZXMuZnVuYyxcbiAgICBvbkJsdXI6IFByb3BUeXBlcy5mdW5jLFxuICAgIG9uRm9jdXM6IFByb3BUeXBlcy5mdW5jLFxuICB9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBTZWxlY3RXaWRnZXQ7XG4iXX0=

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/TextWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/TextWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



function TextWidget(props) {
  var BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, props);
}

if (true) {
  TextWidget.propTypes = {
    value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvVGV4dFdpZGdldC5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsIlByb3BUeXBlcyIsIlRleHRXaWRnZXQiLCJwcm9wcyIsIkJhc2VJbnB1dCIsInJlZ2lzdHJ5Iiwid2lkZ2V0cyIsInByb2Nlc3MiLCJlbnYiLCJOT0RFX0VOViIsInByb3BUeXBlcyIsInZhbHVlIiwib25lT2ZUeXBlIiwic3RyaW5nIiwibnVtYmVyIiwiaWQiXSwibWFwcGluZ3MiOiJBQUFBLE9BQU9BLEtBQVAsTUFBa0IsT0FBbEI7QUFDQSxPQUFPQyxTQUFQLE1BQXNCLFlBQXRCOztBQUVBLFNBQVNDLFVBQVQsQ0FBb0JDLEtBQXBCLEVBQTJCO0FBQUEsTUFDakJDLFNBRGlCLEdBQ0hELEtBQUssQ0FBQ0UsUUFBTixDQUFlQyxPQURaLENBQ2pCRixTQURpQjtBQUV6QixTQUFPLG9CQUFDLFNBQUQsRUFBZUQsS0FBZixDQUFQO0FBQ0Q7O0FBRUQsSUFBSUksT0FBTyxDQUFDQyxHQUFSLENBQVlDLFFBQVosS0FBeUIsWUFBN0IsRUFBMkM7QUFDekNQLEVBQUFBLFVBQVUsQ0FBQ1EsU0FBWCxHQUF1QjtBQUNyQkMsSUFBQUEsS0FBSyxFQUFFVixTQUFTLENBQUNXLFNBQVYsQ0FBb0IsQ0FBQ1gsU0FBUyxDQUFDWSxNQUFYLEVBQW1CWixTQUFTLENBQUNhLE1BQTdCLENBQXBCLENBRGM7QUFFckJDLElBQUFBLEVBQUUsRUFBRWQsU0FBUyxDQUFDWTtBQUZPLEdBQXZCO0FBSUQ7O0FBRUQsZUFBZVgsVUFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcblxuZnVuY3Rpb24gVGV4dFdpZGdldChwcm9wcykge1xuICBjb25zdCB7IEJhc2VJbnB1dCB9ID0gcHJvcHMucmVnaXN0cnkud2lkZ2V0cztcbiAgcmV0dXJuIDxCYXNlSW5wdXQgey4uLnByb3BzfSAvPjtcbn1cblxuaWYgKHByb2Nlc3MuZW52Lk5PREVfRU5WICE9PSBcInByb2R1Y3Rpb25cIikge1xuICBUZXh0V2lkZ2V0LnByb3BUeXBlcyA9IHtcbiAgICB2YWx1ZTogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLnN0cmluZywgUHJvcFR5cGVzLm51bWJlcl0pLFxuICAgIGlkOiBQcm9wVHlwZXMuc3RyaW5nLFxuICB9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBUZXh0V2lkZ2V0O1xuIl19

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/TextareaWidget.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/TextareaWidget.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



function TextareaWidget(props) {
  var id = props.id,
      options = props.options,
      placeholder = props.placeholder,
      value = props.value,
      required = props.required,
      disabled = props.disabled,
      readonly = props.readonly,
      autofocus = props.autofocus,
      onChange = props.onChange,
      onBlur = props.onBlur,
      onFocus = props.onFocus;

  var _onChange = function _onChange(_ref) {
    var value = _ref.target.value;
    return onChange(value === "" ? options.emptyValue : value);
  };

  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textarea", {
    id: id,
    className: "form-control",
    value: value ? value : "",
    placeholder: placeholder,
    required: required,
    disabled: disabled,
    readOnly: readonly,
    autoFocus: autofocus,
    rows: options.rows,
    onBlur: onBlur && function (event) {
      return onBlur(id, event.target.value);
    },
    onFocus: onFocus && function (event) {
      return onFocus(id, event.target.value);
    },
    onChange: _onChange
  });
}

TextareaWidget.defaultProps = {
  autofocus: false,
  options: {}
};

if (true) {
  TextareaWidget.propTypes = {
    schema: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object.isRequired),
    id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
    placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
      rows: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
    }),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    readonly: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
    onChange: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
    onBlur: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
    onFocus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextareaWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/URLWidget.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/URLWidget.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }




function URLWidget(props) {
  var BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, _extends({
    type: "url"
  }, props));
}

if (true) {
  URLWidget.propTypes = {
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (URLWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvVVJMV2lkZ2V0LmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwiUHJvcFR5cGVzIiwiVVJMV2lkZ2V0IiwicHJvcHMiLCJCYXNlSW5wdXQiLCJyZWdpc3RyeSIsIndpZGdldHMiLCJwcm9jZXNzIiwiZW52IiwiTk9ERV9FTlYiLCJwcm9wVHlwZXMiLCJ2YWx1ZSIsInN0cmluZyJdLCJtYXBwaW5ncyI6Ijs7QUFBQSxPQUFPQSxLQUFQLE1BQWtCLE9BQWxCO0FBQ0EsT0FBT0MsU0FBUCxNQUFzQixZQUF0Qjs7QUFFQSxTQUFTQyxTQUFULENBQW1CQyxLQUFuQixFQUEwQjtBQUFBLE1BQ2hCQyxTQURnQixHQUNGRCxLQUFLLENBQUNFLFFBQU4sQ0FBZUMsT0FEYixDQUNoQkYsU0FEZ0I7QUFFeEIsU0FBTyxvQkFBQyxTQUFEO0FBQVcsSUFBQSxJQUFJLEVBQUM7QUFBaEIsS0FBMEJELEtBQTFCLEVBQVA7QUFDRDs7QUFFRCxJQUFJSSxPQUFPLENBQUNDLEdBQVIsQ0FBWUMsUUFBWixLQUF5QixZQUE3QixFQUEyQztBQUN6Q1AsRUFBQUEsU0FBUyxDQUFDUSxTQUFWLEdBQXNCO0FBQ3BCQyxJQUFBQSxLQUFLLEVBQUVWLFNBQVMsQ0FBQ1c7QUFERyxHQUF0QjtBQUdEOztBQUVELGVBQWVWLFNBQWYiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSBcInJlYWN0XCI7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gXCJwcm9wLXR5cGVzXCI7XG5cbmZ1bmN0aW9uIFVSTFdpZGdldChwcm9wcykge1xuICBjb25zdCB7IEJhc2VJbnB1dCB9ID0gcHJvcHMucmVnaXN0cnkud2lkZ2V0cztcbiAgcmV0dXJuIDxCYXNlSW5wdXQgdHlwZT1cInVybFwiIHsuLi5wcm9wc30gLz47XG59XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViAhPT0gXCJwcm9kdWN0aW9uXCIpIHtcbiAgVVJMV2lkZ2V0LnByb3BUeXBlcyA9IHtcbiAgICB2YWx1ZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgfTtcbn1cblxuZXhwb3J0IGRlZmF1bHQgVVJMV2lkZ2V0O1xuIl19

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/UpDownWidget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/UpDownWidget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }





function UpDownWidget(props) {
  var BaseInput = props.registry.widgets.BaseInput;
  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(BaseInput, _extends({
    type: "number"
  }, props, (0,_utils__WEBPACK_IMPORTED_MODULE_1__.rangeSpec)(props.schema)));
}

if (true) {
  UpDownWidget.propTypes = {
    value: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string)])
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UpDownWidget);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvVXBEb3duV2lkZ2V0LmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwiUHJvcFR5cGVzIiwicmFuZ2VTcGVjIiwiVXBEb3duV2lkZ2V0IiwicHJvcHMiLCJCYXNlSW5wdXQiLCJyZWdpc3RyeSIsIndpZGdldHMiLCJzY2hlbWEiLCJwcm9jZXNzIiwiZW52IiwiTk9ERV9FTlYiLCJwcm9wVHlwZXMiLCJ2YWx1ZSIsIm9uZU9mVHlwZSIsIm51bWJlciIsInN0cmluZyJdLCJtYXBwaW5ncyI6Ijs7QUFBQSxPQUFPQSxLQUFQLE1BQWtCLE9BQWxCO0FBQ0EsT0FBT0MsU0FBUCxNQUFzQixZQUF0QjtBQUVBLFNBQVNDLFNBQVQsUUFBMEIsYUFBMUI7O0FBRUEsU0FBU0MsWUFBVCxDQUFzQkMsS0FBdEIsRUFBNkI7QUFBQSxNQUdaQyxTQUhZLEdBS3ZCRCxLQUx1QixDQUV6QkUsUUFGeUIsQ0FHdkJDLE9BSHVCLENBR1pGLFNBSFk7QUFNM0IsU0FBTyxvQkFBQyxTQUFEO0FBQVcsSUFBQSxJQUFJLEVBQUM7QUFBaEIsS0FBNkJELEtBQTdCLEVBQXdDRixTQUFTLENBQUNFLEtBQUssQ0FBQ0ksTUFBUCxDQUFqRCxFQUFQO0FBQ0Q7O0FBRUQsSUFBSUMsT0FBTyxDQUFDQyxHQUFSLENBQVlDLFFBQVosS0FBeUIsWUFBN0IsRUFBMkM7QUFDekNSLEVBQUFBLFlBQVksQ0FBQ1MsU0FBYixHQUF5QjtBQUN2QkMsSUFBQUEsS0FBSyxFQUFFWixTQUFTLENBQUNhLFNBQVYsQ0FBb0IsQ0FBQ2IsU0FBUyxDQUFDYyxNQUFYLEVBQW1CZCxTQUFTLENBQUNlLE1BQTdCLENBQXBCO0FBRGdCLEdBQXpCO0FBR0Q7O0FBRUQsZUFBZWIsWUFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcblxuaW1wb3J0IHsgcmFuZ2VTcGVjIH0gZnJvbSBcIi4uLy4uL3V0aWxzXCI7XG5cbmZ1bmN0aW9uIFVwRG93bldpZGdldChwcm9wcykge1xuICBjb25zdCB7XG4gICAgcmVnaXN0cnk6IHtcbiAgICAgIHdpZGdldHM6IHsgQmFzZUlucHV0IH0sXG4gICAgfSxcbiAgfSA9IHByb3BzO1xuICByZXR1cm4gPEJhc2VJbnB1dCB0eXBlPVwibnVtYmVyXCIgey4uLnByb3BzfSB7Li4ucmFuZ2VTcGVjKHByb3BzLnNjaGVtYSl9IC8+O1xufVxuXG5pZiAocHJvY2Vzcy5lbnYuTk9ERV9FTlYgIT09IFwicHJvZHVjdGlvblwiKSB7XG4gIFVwRG93bldpZGdldC5wcm9wVHlwZXMgPSB7XG4gICAgdmFsdWU6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5udW1iZXIsIFByb3BUeXBlcy5zdHJpbmddKSxcbiAgfTtcbn1cblxuZXhwb3J0IGRlZmF1bHQgVXBEb3duV2lkZ2V0O1xuIl19

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/components/widgets/index.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/components/widgets/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _AltDateWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AltDateWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/AltDateWidget.js");
/* harmony import */ var _AltDateTimeWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AltDateTimeWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/AltDateTimeWidget.js");
/* harmony import */ var _BaseInput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BaseInput */ "../../node_modules/@rjsf/core/dist/es/components/widgets/BaseInput.js");
/* harmony import */ var _CheckboxWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CheckboxWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/CheckboxWidget.js");
/* harmony import */ var _CheckboxesWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CheckboxesWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/CheckboxesWidget.js");
/* harmony import */ var _ColorWidget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ColorWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/ColorWidget.js");
/* harmony import */ var _DateWidget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DateWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/DateWidget.js");
/* harmony import */ var _DateTimeWidget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./DateTimeWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/DateTimeWidget.js");
/* harmony import */ var _EmailWidget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./EmailWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/EmailWidget.js");
/* harmony import */ var _FileWidget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./FileWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/FileWidget.js");
/* harmony import */ var _HiddenWidget__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./HiddenWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/HiddenWidget.js");
/* harmony import */ var _PasswordWidget__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./PasswordWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/PasswordWidget.js");
/* harmony import */ var _RadioWidget__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./RadioWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/RadioWidget.js");
/* harmony import */ var _RangeWidget__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./RangeWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/RangeWidget.js");
/* harmony import */ var _SelectWidget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./SelectWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/SelectWidget.js");
/* harmony import */ var _TextareaWidget__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./TextareaWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/TextareaWidget.js");
/* harmony import */ var _TextWidget__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./TextWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/TextWidget.js");
/* harmony import */ var _URLWidget__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./URLWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/URLWidget.js");
/* harmony import */ var _UpDownWidget__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./UpDownWidget */ "../../node_modules/@rjsf/core/dist/es/components/widgets/UpDownWidget.js");



















/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  BaseInput: _BaseInput__WEBPACK_IMPORTED_MODULE_2__["default"],
  PasswordWidget: _PasswordWidget__WEBPACK_IMPORTED_MODULE_11__["default"],
  RadioWidget: _RadioWidget__WEBPACK_IMPORTED_MODULE_12__["default"],
  UpDownWidget: _UpDownWidget__WEBPACK_IMPORTED_MODULE_18__["default"],
  RangeWidget: _RangeWidget__WEBPACK_IMPORTED_MODULE_13__["default"],
  SelectWidget: _SelectWidget__WEBPACK_IMPORTED_MODULE_14__["default"],
  TextWidget: _TextWidget__WEBPACK_IMPORTED_MODULE_16__["default"],
  DateWidget: _DateWidget__WEBPACK_IMPORTED_MODULE_6__["default"],
  DateTimeWidget: _DateTimeWidget__WEBPACK_IMPORTED_MODULE_7__["default"],
  AltDateWidget: _AltDateWidget__WEBPACK_IMPORTED_MODULE_0__["default"],
  AltDateTimeWidget: _AltDateTimeWidget__WEBPACK_IMPORTED_MODULE_1__["default"],
  EmailWidget: _EmailWidget__WEBPACK_IMPORTED_MODULE_8__["default"],
  URLWidget: _URLWidget__WEBPACK_IMPORTED_MODULE_17__["default"],
  TextareaWidget: _TextareaWidget__WEBPACK_IMPORTED_MODULE_15__["default"],
  HiddenWidget: _HiddenWidget__WEBPACK_IMPORTED_MODULE_10__["default"],
  ColorWidget: _ColorWidget__WEBPACK_IMPORTED_MODULE_5__["default"],
  FileWidget: _FileWidget__WEBPACK_IMPORTED_MODULE_9__["default"],
  CheckboxWidget: _CheckboxWidget__WEBPACK_IMPORTED_MODULE_3__["default"],
  CheckboxesWidget: _CheckboxesWidget__WEBPACK_IMPORTED_MODULE_4__["default"]
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/index.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "utils": () => (/* reexport module object */ _utils__WEBPACK_IMPORTED_MODULE_2__),
/* harmony export */   "withTheme": () => (/* reexport safe */ _withTheme__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _components_Form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/Form */ "../../node_modules/@rjsf/core/dist/es/components/Form.js");
/* harmony import */ var _withTheme__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./withTheme */ "../../node_modules/@rjsf/core/dist/es/withTheme.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "../../node_modules/@rjsf/core/dist/es/utils.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_components_Form__WEBPACK_IMPORTED_MODULE_0__["default"]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9pbmRleC5qcyJdLCJuYW1lcyI6WyJGb3JtIiwid2l0aFRoZW1lIiwidXRpbHMiXSwibWFwcGluZ3MiOiJBQUFBLE9BQU9BLElBQVAsTUFBaUIsbUJBQWpCO0FBQ0EsT0FBT0MsU0FBUCxNQUFzQixhQUF0QjtBQUNBLE9BQU8sS0FBS0MsS0FBWixNQUF1QixTQUF2QjtBQUVBLFNBQVNELFNBQVQsRUFBb0JDLEtBQXBCO0FBQ0EsZUFBZUYsSUFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBGb3JtIGZyb20gXCIuL2NvbXBvbmVudHMvRm9ybVwiO1xuaW1wb3J0IHdpdGhUaGVtZSBmcm9tIFwiLi93aXRoVGhlbWVcIjtcbmltcG9ydCAqIGFzIHV0aWxzIGZyb20gXCIuL3V0aWxzXCI7XG5cbmV4cG9ydCB7IHdpdGhUaGVtZSwgdXRpbHMgfTtcbmV4cG9ydCBkZWZhdWx0IEZvcm07XG4iXX0=

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/types.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/types.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "fieldProps": () => (/* binding */ fieldProps),
/* harmony export */   "registry": () => (/* binding */ registry)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);

var registry = prop_types__WEBPACK_IMPORTED_MODULE_0___default().shape({
  ArrayFieldTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().elementType),
  FieldTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().elementType),
  ObjectFieldTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().elementType),
  definitions: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().object.isRequired),
  rootSchema: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().object),
  fields: prop_types__WEBPACK_IMPORTED_MODULE_0___default().objectOf((prop_types__WEBPACK_IMPORTED_MODULE_0___default().elementType)).isRequired,
  formContext: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().object.isRequired),
  widgets: prop_types__WEBPACK_IMPORTED_MODULE_0___default().objectOf(prop_types__WEBPACK_IMPORTED_MODULE_0___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_0___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_0___default().object)])).isRequired
});
var fieldProps = {
  autofocus: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  errorSchema: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().object),
  formData: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().any),
  idSchema: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().object),
  onBlur: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func.isRequired),
  onFocus: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func),
  rawErrors: prop_types__WEBPACK_IMPORTED_MODULE_0___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_0___default().string)),
  readonly: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  registry: registry.isRequired,
  required: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  schema: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().object.isRequired),
  uiSchema: prop_types__WEBPACK_IMPORTED_MODULE_0___default().shape({
    "ui:options": prop_types__WEBPACK_IMPORTED_MODULE_0___default().shape({
      addable: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
      orderable: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
      removable: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool)
    })
  })
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

/***/ }),

/***/ "../../node_modules/@rjsf/core/dist/es/utils.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/core/dist/es/utils.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony exp