# Copyright 2017, Digi International Inc.
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

from digidevice import xbee

def main():
    print(" Reading incomming IO samples...\n")

    local_device = None

    try:
        local_device = xbee.get_device()
        local_device.open()

        local_device.add_io_sample_received_callback(io_callback)

        input()

    finally:
        if local_device is not None:
            local_device.remove_io_sample_received_callback(io_callback)
            if local_device.is_open():
                local_device.close()


def io_callback(sample, remote, time):
    print("New sample received from %s - %s" % (remote.get_64bit_addr(), sample))


if __name__ == '__main__':
    main()
