
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/python/arcor2_calibration:arcor2_calibration_dist

from setuptools import setup

setup(**{
    'author': 'Robo@FIT',
    'author_email': 'imaterna@fit.vut.cz',
    'classifiers': [
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: GNU Lesser General Public License v3 (LGPLv3)',
        'Programming Language :: Python :: 3.8',
        'Natural Language :: English',
        'Topic :: Scientific/Engineering',
    ],
    'description': 'ARCOR2 Calibration',
    'license': 'LGPL',
    'long_description': """# arcor2_calibration
# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),

## [0.3.0] - 2021-03-30
### Changed
- `PUT /calibrate/camera` now has `inverse` parameter. 

## [0.2.0] - 2021-02-08
### Changed
- Part of the code refactored into `arcor2/flask.py`.
- API for getting pixel coordinates of markers corners.
  - Approx. three times faster than camera calibration.

## [0.1.1] - 2020-12-14
### Changed
- Bump version to allow reupload to pypi

## [0.1.0] - 2020-12-14
### Changed
- Initial release of the package.
- Support for camera calibration.
- Support for robot calibration.
  - URDF model of the robot needed.
  - Requires depth camera (e.g. Kinect).
- `--mock` argument to start the service in a simulation mode.""",
    'long_description_content_type': 'text/markdown',
    'name': 'arcor2_calibration',
    'python_requires': '==3.8.*',
    'version': '0.3.0',
    'package_dir': {
        '': 'src',
    },
    'packages': (
        'arcor2_calibration',
        'arcor2_calibration.scripts',
    ),
    'namespace_packages': (
    ),
    'package_data': {
        'arcor2_calibration': (
            'VERSION',
            'py.typed',
        ),
    },
    'install_requires': (
        'Flask==1.1.1',
        'Pillow==8.1.2',
        'arcor2_calibration_data~=0.2.0',
        'arcor2~=0.14.0',
        'numpy-quaternion==2021.3.17.16.51.43',
        'numpy==1.20.1',
        'open3d==0.12.0',
        'opencv-contrib-python==4.5.1.48',
        'urdfpy==0.0.22',
    ),
    'entry_points': {
        'console_scripts': [
            'arcor2_calibration=arcor2_calibration.scripts.calibration:main',
        ],
    },
})
