# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class HPAScalingRules(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'policies': 'list[HPAScalingPolicy]',
        'select_policy': 'ScalingPolicySelect',
        'stabilization_window_seconds': 'int'
    }

    attribute_map = {
        'policies': 'policies',
        'select_policy': 'selectPolicy',
        'stabilization_window_seconds': 'stabilizationWindowSeconds'
    }

    def __init__(self, policies=None, select_policy=None, stabilization_window_seconds=None):  # noqa: E501
        """HPAScalingRules - a model defined in Swagger"""  # noqa: E501

        self._policies = None
        self._select_policy = None
        self._stabilization_window_seconds = None
        self.discriminator = None

        if policies is not None:
            self.policies = policies
        if select_policy is not None:
            self.select_policy = select_policy
        if stabilization_window_seconds is not None:
            self.stabilization_window_seconds = stabilization_window_seconds

    @property
    def policies(self):
        """Gets the policies of this HPAScalingRules.  # noqa: E501

        policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid +optional  # noqa: E501

        :return: The policies of this HPAScalingRules.  # noqa: E501
        :rtype: list[HPAScalingPolicy]
        """
        return self._policies

    @policies.setter
    def policies(self, policies):
        """Sets the policies of this HPAScalingRules.

        policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid +optional  # noqa: E501

        :param policies: The policies of this HPAScalingRules.  # noqa: E501
        :type: list[HPAScalingPolicy]
        """

        self._policies = policies

    @property
    def select_policy(self):
        """Gets the select_policy of this HPAScalingRules.  # noqa: E501


        :return: The select_policy of this HPAScalingRules.  # noqa: E501
        :rtype: ScalingPolicySelect
        """
        return self._select_policy

    @select_policy.setter
    def select_policy(self, select_policy):
        """Sets the select_policy of this HPAScalingRules.


        :param select_policy: The select_policy of this HPAScalingRules.  # noqa: E501
        :type: ScalingPolicySelect
        """

        self._select_policy = select_policy

    @property
    def stabilization_window_seconds(self):
        """Gets the stabilization_window_seconds of this HPAScalingRules.  # noqa: E501

        StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: For scale up: 0 (i.e. no stabilization is done). For scale down: 300 (i.e. the stabilization window is 300 seconds long). +optional  # noqa: E501

        :return: The stabilization_window_seconds of this HPAScalingRules.  # noqa: E501
        :rtype: int
        """
        return self._stabilization_window_seconds

    @stabilization_window_seconds.setter
    def stabilization_window_seconds(self, stabilization_window_seconds):
        """Sets the stabilization_window_seconds of this HPAScalingRules.

        StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: For scale up: 0 (i.e. no stabilization is done). For scale down: 300 (i.e. the stabilization window is 300 seconds long). +optional  # noqa: E501

        :param stabilization_window_seconds: The stabilization_window_seconds of this HPAScalingRules.  # noqa: E501
        :type: int
        """

        self._stabilization_window_seconds = stabilization_window_seconds

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HPAScalingRules, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HPAScalingRules):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
