# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['Vlan']


class Vlan(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 facility: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a resource to allow users to manage Virtual Networks in their projects.

        To learn more about Layer 2 networking in Packet, refer to
        * https://www.packet.com/resources/guides/layer-2-configurations/
        * https://www.packet.com/developers/docs/network/advanced/layer-2/

        ## Example Usage

        ```python
        import pulumi
        import pulumi_packet as packet

        # Create a new VLAN in datacenter "ewr1"
        vlan1 = packet.Vlan("vlan1",
            description="VLAN in New Jersey",
            facility="ewr1",
            project_id=local["project_id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description string
        :param pulumi.Input[str] facility: Facility where to create the VLAN
        :param pulumi.Input[str] project_id: ID of parent project
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            if facility is None:
                raise TypeError("Missing required property 'facility'")
            __props__['facility'] = facility
            if project_id is None:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['vxlan'] = None
        super(Vlan, __self__).__init__(
            'packet:index/vlan:Vlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            facility: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            vxlan: Optional[pulumi.Input[float]] = None) -> 'Vlan':
        """
        Get an existing Vlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description string
        :param pulumi.Input[str] facility: Facility where to create the VLAN
        :param pulumi.Input[str] project_id: ID of parent project
        :param pulumi.Input[float] vxlan: VXLAN segment ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["facility"] = facility
        __props__["project_id"] = project_id
        __props__["vxlan"] = vxlan
        return Vlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description string
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def facility(self) -> pulumi.Output[str]:
        """
        Facility where to create the VLAN
        """
        return pulumi.get(self, "facility")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        ID of parent project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def vxlan(self) -> pulumi.Output[float]:
        """
        VXLAN segment ID
        """
        return pulumi.get(self, "vxlan")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

