# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs

__all__ = [
    'DeviceIpAddress',
    'DeviceNetwork',
    'DevicePort',
    'ProjectBgpConfig',
    'SpotMarketRequestInstanceParameters',
    'VolumeAttachment',
    'VolumeSnapshotPolicy',
    'GetDeviceBgpNeighborsBgpNeighborResult',
    'GetDeviceBgpNeighborsBgpNeighborRoutesInResult',
    'GetDeviceBgpNeighborsBgpNeighborRoutesOutResult',
    'GetDeviceNetworkResult',
    'GetDevicePortResult',
    'GetProjectBgpConfigResult',
    'GetVolumeSnapshotPolicyResult',
]

@pulumi.output_type
class DeviceIpAddress(dict):
    def __init__(__self__, *,
                 type: str,
                 cidr: Optional[float] = None,
                 reservation_ids: Optional[List[str]] = None):
        """
        :param str type: One of [`private_ipv4`, `public_ipv4`, `public_ipv6`]
        :param float cidr: CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        """
        pulumi.set(__self__, "type", type)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if reservation_ids is not None:
            pulumi.set(__self__, "reservation_ids", reservation_ids)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        One of [`private_ipv4`, `public_ipv4`, `public_ipv6`]
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def cidr(self) -> Optional[float]:
        """
        CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="reservationIds")
    def reservation_ids(self) -> Optional[List[str]]:
        return pulumi.get(self, "reservation_ids")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DeviceNetwork(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 cidr: Optional[float] = None,
                 family: Optional[float] = None,
                 gateway: Optional[str] = None,
                 public: Optional[bool] = None):
        """
        :param str address: IPv4 or IPv6 address string
        :param float cidr: CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        :param float family: IP version - "4" or "6"
               * `network_type` Network type of a device, used in [Layer 2 networking](https://www.packet.com/developers/docs/network/advanced/layer-2/). Will be one of `layer3`, `hybrid`, `layer2-individual` and `layer2-bonded`.
        :param str gateway: address of router
        :param bool public: whether the address is routable from the Internet
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if public is not None:
            pulumi.set(__self__, "public", public)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        IPv4 or IPv6 address string
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def cidr(self) -> Optional[float]:
        """
        CIDR suffix for IP address block to be assigned, i.e. amount of addresses.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def family(self) -> Optional[float]:
        """
        IP version - "4" or "6"
        * `network_type` Network type of a device, used in [Layer 2 networking](https://www.packet.com/developers/docs/network/advanced/layer-2/). Will be one of `layer3`, `hybrid`, `layer2-individual` and `layer2-bonded`.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        address of router
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def public(self) -> Optional[bool]:
        """
        whether the address is routable from the Internet
        """
        return pulumi.get(self, "public")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DevicePort(dict):
    def __init__(__self__, *,
                 bonded: Optional[bool] = None,
                 id: Optional[str] = None,
                 mac: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param bool bonded: Whether this port is part of a bond in bonded network setup
               * `project_id`- The ID of the project the device belongs to
        :param str id: ID of the port
        :param str mac: MAC address assigned to the port
        :param str name: Name of the port (e.g. `eth0`, or `bond0`)
        :param str type: One of [`private_ipv4`, `public_ipv4`, `public_ipv6`]
        """
        if bonded is not None:
            pulumi.set(__self__, "bonded", bonded)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bonded(self) -> Optional[bool]:
        """
        Whether this port is part of a bond in bonded network setup
        * `project_id`- The ID of the project the device belongs to
        """
        return pulumi.get(self, "bonded")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the port
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mac(self) -> Optional[str]:
        """
        MAC address assigned to the port
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the port (e.g. `eth0`, or `bond0`)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        One of [`private_ipv4`, `public_ipv4`, `public_ipv6`]
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProjectBgpConfig(dict):
    def __init__(__self__, *,
                 asn: float,
                 deployment_type: str,
                 max_prefix: Optional[float] = None,
                 md5: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param float asn: Autonomous System Number for local BGP deployment
        :param str deployment_type: `private` or `public`, the `private` is likely to be usable immediately, the `public` will need to be review by Packet engineers
        :param float max_prefix: The maximum number of route filters allowed per server
        :param str md5: Password for BGP session in plaintext (not a checksum)
        :param str status: status of BGP configuration in the project
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "deployment_type", deployment_type)
        if max_prefix is not None:
            pulumi.set(__self__, "max_prefix", max_prefix)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def asn(self) -> float:
        """
        Autonomous System Number for local BGP deployment
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        `private` or `public`, the `private` is likely to be usable immediately, the `public` will need to be review by Packet engineers
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="maxPrefix")
    def max_prefix(self) -> Optional[float]:
        """
        The maximum number of route filters allowed per server
        """
        return pulumi.get(self, "max_prefix")

    @property
    @pulumi.getter
    def md5(self) -> Optional[str]:
        """
        Password for BGP session in plaintext (not a checksum)
        """
        return pulumi.get(self, "md5")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        status of BGP configuration in the project
        """
        return pulumi.get(self, "status")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SpotMarketRequestInstanceParameters(dict):
    def __init__(__self__, *,
                 billing_cycle: str,
                 hostname: str,
                 operating_system: str,
                 plan: str,
                 always_pxe: Optional[str] = None,
                 description: Optional[str] = None,
                 features: Optional[List[str]] = None,
                 locked: Optional[str] = None,
                 project_ssh_keys: Optional[List[str]] = None,
                 termintation_time: Optional[str] = None,
                 user_ssh_keys: Optional[List[str]] = None,
                 userdata: Optional[str] = None):
        pulumi.set(__self__, "billing_cycle", billing_cycle)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "plan", plan)
        if always_pxe is not None:
            pulumi.set(__self__, "always_pxe", always_pxe)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if project_ssh_keys is not None:
            pulumi.set(__self__, "project_ssh_keys", project_ssh_keys)
        if termintation_time is not None:
            pulumi.set(__self__, "termintation_time", termintation_time)
        if user_ssh_keys is not None:
            pulumi.set(__self__, "user_ssh_keys", user_ssh_keys)
        if userdata is not None:
            pulumi.set(__self__, "userdata", userdata)

    @property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> str:
        return pulumi.get(self, "billing_cycle")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> str:
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter
    def plan(self) -> str:
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="alwaysPxe")
    def always_pxe(self) -> Optional[str]:
        return pulumi.get(self, "always_pxe")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def features(self) -> Optional[List[str]]:
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def locked(self) -> Optional[str]:
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter(name="projectSshKeys")
    def project_ssh_keys(self) -> Optional[List[str]]:
        return pulumi.get(self, "project_ssh_keys")

    @property
    @pulumi.getter(name="termintationTime")
    def termintation_time(self) -> Optional[str]:
        return pulumi.get(self, "termintation_time")

    @property
    @pulumi.getter(name="userSshKeys")
    def user_ssh_keys(self) -> Optional[List[str]]:
        return pulumi.get(self, "user_ssh_keys")

    @property
    @pulumi.getter
    def userdata(self) -> Optional[str]:
        return pulumi.get(self, "userdata")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VolumeAttachment(dict):
    def __init__(__self__, *,
                 href: Optional[str] = None):
        if href is not None:
            pulumi.set(__self__, "href", href)

    @property
    @pulumi.getter
    def href(self) -> Optional[str]:
        return pulumi.get(self, "href")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VolumeSnapshotPolicy(dict):
    def __init__(__self__, *,
                 snapshot_count: float,
                 snapshot_frequency: str):
        pulumi.set(__self__, "snapshot_count", snapshot_count)
        pulumi.set(__self__, "snapshot_frequency", snapshot_frequency)

    @property
    @pulumi.getter(name="snapshotCount")
    def snapshot_count(self) -> float:
        return pulumi.get(self, "snapshot_count")

    @property
    @pulumi.getter(name="snapshotFrequency")
    def snapshot_frequency(self) -> str:
        return pulumi.get(self, "snapshot_frequency")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetDeviceBgpNeighborsBgpNeighborResult(dict):
    def __init__(__self__, *,
                 address_family: float,
                 customer_as: float,
                 customer_ip: str,
                 md5_enabled: bool,
                 md5_password: str,
                 multihop: bool,
                 peer_as: float,
                 routes_ins: List['outputs.GetDeviceBgpNeighborsBgpNeighborRoutesInResult'],
                 routes_outs: List['outputs.GetDeviceBgpNeighborsBgpNeighborRoutesOutResult'],
                 peer_ips: Optional[List[str]] = None):
        """
        :param float address_family: IP address version, 4 or 6
        :param float customer_as: Local autonomous system number
        :param str customer_ip: Local used peer IP address
        :param bool md5_enabled: Whether BGP session is password enabled
        :param str md5_password: BGP session password in plaintext (not a checksum)
        :param bool multihop: Whether the neighbor is in EBGP multihop session
        :param float peer_as: Peer AS number (different than customer_as for EBGP)
        :param List['GetDeviceBgpNeighborsBgpNeighborRoutesInArgs'] routes_ins: Array of incoming routes. Each route has attributes:
        :param List['GetDeviceBgpNeighborsBgpNeighborRoutesOutArgs'] routes_outs: Array of outgoing routes in the same format
        :param List[str] peer_ips: Array of IP addresses of this neighbor's peers
        """
        pulumi.set(__self__, "address_family", address_family)
        pulumi.set(__self__, "customer_as", customer_as)
        pulumi.set(__self__, "customer_ip", customer_ip)
        pulumi.set(__self__, "md5_enabled", md5_enabled)
        pulumi.set(__self__, "md5_password", md5_password)
        pulumi.set(__self__, "multihop", multihop)
        pulumi.set(__self__, "peer_as", peer_as)
        pulumi.set(__self__, "routes_ins", routes_ins)
        pulumi.set(__self__, "routes_outs", routes_outs)
        if peer_ips is not None:
            pulumi.set(__self__, "peer_ips", peer_ips)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> float:
        """
        IP address version, 4 or 6
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter(name="customerAs")
    def customer_as(self) -> float:
        """
        Local autonomous system number
        """
        return pulumi.get(self, "customer_as")

    @property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> str:
        """
        Local used peer IP address
        """
        return pulumi.get(self, "customer_ip")

    @property
    @pulumi.getter(name="md5Enabled")
    def md5_enabled(self) -> bool:
        """
        Whether BGP session is password enabled
        """
        return pulumi.get(self, "md5_enabled")

    @property
    @pulumi.getter(name="md5Password")
    def md5_password(self) -> str:
        """
        BGP session password in plaintext (not a checksum)
        """
        return pulumi.get(self, "md5_password")

    @property
    @pulumi.getter
    def multihop(self) -> bool:
        """
        Whether the neighbor is in EBGP multihop session
        """
        return pulumi.get(self, "multihop")

    @property
    @pulumi.getter(name="peerAs")
    def peer_as(self) -> float:
        """
        Peer AS number (different than customer_as for EBGP)
        """
        return pulumi.get(self, "peer_as")

    @property
    @pulumi.getter(name="routesIns")
    def routes_ins(self) -> List['outputs.GetDeviceBgpNeighborsBgpNeighborRoutesInResult']:
        """
        Array of incoming routes. Each route has attributes:
        """
        return pulumi.get(self, "routes_ins")

    @property
    @pulumi.getter(name="routesOuts")
    def routes_outs(self) -> List['outputs.GetDeviceBgpNeighborsBgpNeighborRoutesOutResult']:
        """
        Array of outgoing routes in the same format
        """
        return pulumi.get(self, "routes_outs")

    @property
    @pulumi.getter(name="peerIps")
    def peer_ips(self) -> Optional[List[str]]:
        """
        Array of IP addresses of this neighbor's peers
        """
        return pulumi.get(self, "peer_ips")


@pulumi.output_type
class GetDeviceBgpNeighborsBgpNeighborRoutesInResult(dict):
    def __init__(__self__, *,
                 exact: bool,
                 route: str):
        """
        :param bool exact: (bool) Whether the route is exact
        :param str route: CIDR expression of route (ip/mask)
        """
        pulumi.set(__self__, "exact", exact)
        pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter
    def exact(self) -> bool:
        """
        (bool) Whether the route is exact
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def route(self) -> str:
        """
        CIDR expression of route (ip/mask)
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class GetDeviceBgpNeighborsBgpNeighborRoutesOutResult(dict):
    def __init__(__self__, *,
                 exact: bool,
                 route: str):
        """
        :param bool exact: (bool) Whether the route is exact
        :param str route: CIDR expression of route (ip/mask)
        """
        pulumi.set(__self__, "exact", exact)
        pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter
    def exact(self) -> bool:
        """
        (bool) Whether the route is exact
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def route(self) -> str:
        """
        CIDR expression of route (ip/mask)
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class GetDeviceNetworkResult(dict):
    def __init__(__self__, *,
                 address: str,
                 cidr: float,
                 family: float,
                 gateway: str,
                 public: bool):
        """
        :param str address: IPv4 or IPv6 address string
        :param float cidr: Bit length of the network mask of the address
        :param float family: IP version - "4" or "6"
        :param str gateway: Address of router
        :param bool public: Whether the address is routable from the Internet
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "public", public)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        IPv4 or IPv6 address string
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def cidr(self) -> float:
        """
        Bit length of the network mask of the address
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def family(self) -> float:
        """
        IP version - "4" or "6"
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        Address of router
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def public(self) -> bool:
        """
        Whether the address is routable from the Internet
        """
        return pulumi.get(self, "public")


@pulumi.output_type
class GetDevicePortResult(dict):
    def __init__(__self__, *,
                 bonded: bool,
                 id: str,
                 mac: str,
                 name: str,
                 type: str):
        """
        :param bool bonded: Whether this port is part of a bond in bonded network setup
        :param str id: ID of the port
        :param str mac: MAC address assigned to the port
        :param str name: Name of the port (e.g. `eth0`, or `bond0`)
        :param str type: Type of the port (e.g. `NetworkPort` or `NetworkBondPort`)
        """
        pulumi.set(__self__, "bonded", bonded)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bonded(self) -> bool:
        """
        Whether this port is part of a bond in bonded network setup
        """
        return pulumi.get(self, "bonded")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the port
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mac(self) -> str:
        """
        MAC address assigned to the port
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the port (e.g. `eth0`, or `bond0`)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the port (e.g. `NetworkPort` or `NetworkBondPort`)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProjectBgpConfigResult(dict):
    def __init__(__self__, *,
                 asn: float,
                 deployment_type: str,
                 max_prefix: float,
                 status: str,
                 md5: Optional[str] = None):
        """
        :param float asn: Autonomous System Numer for local BGP deployment
        :param str deployment_type: `private` or `public`, the `private` is likely to be usable immediately, the `public` will need to be review by Packet engineers
        :param float max_prefix: The maximum number of route filters allowed per server
        :param str status: status of BGP configuration in the project
        :param str md5: Password for BGP session in plaintext (not a checksum)
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "max_prefix", max_prefix)
        pulumi.set(__self__, "status", status)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)

    @property
    @pulumi.getter
    def asn(self) -> float:
        """
        Autonomous System Numer for local BGP deployment
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        `private` or `public`, the `private` is likely to be usable immediately, the `public` will need to be review by Packet engineers
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="maxPrefix")
    def max_prefix(self) -> float:
        """
        The maximum number of route filters allowed per server
        """
        return pulumi.get(self, "max_prefix")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        status of BGP configuration in the project
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def md5(self) -> Optional[str]:
        """
        Password for BGP session in plaintext (not a checksum)
        """
        return pulumi.get(self, "md5")


@pulumi.output_type
class GetVolumeSnapshotPolicyResult(dict):
    def __init__(__self__, *,
                 snapshot_count: float,
                 snapshot_frequency: str):
        pulumi.set(__self__, "snapshot_count", snapshot_count)
        pulumi.set(__self__, "snapshot_frequency", snapshot_frequency)

    @property
    @pulumi.getter(name="snapshotCount")
    def snapshot_count(self) -> float:
        return pulumi.get(self, "snapshot_count")

    @property
    @pulumi.getter(name="snapshotFrequency")
    def snapshot_frequency(self) -> str:
        return pulumi.get(self, "snapshot_frequency")


