#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

install_requires = \
['setuptools']

extras_require = \
{'all': ['pytest >=4.6',
         'pytest-cov',
         'mypy',
         'black',
         'isort',
         'autoflake',
         'flake8',
         'vulture',
         'pytoml',
         'json5'],
 'dev': ['autoflake', 'vulture', 'json5'],
 'test': ['pytest >=4.6', 'pytest-cov', 'mypy', 'black', 'isort', 'flake8'],
 'toml': ['pytoml']}

setup(name='fhirspec',
      version='0.2.1',
      description='Python representation of FHIR® https://www.hl7.org/fhir/ specification.',
      author='Md Nazrul Islam',
      author_email='email2nazrul@gmail.com',
      url='https://github.com/nazrulworld/fhirspec',
      py_modules=['fhirspec'],
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
