/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts.query;

import ambit2.core.config.Resources;
import ambit2.core.data.MoleculeTools;
import ambit2.smarts.query.AbstractSmartsPattern;
import ambit2.smarts.query.SMARTSException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

public class SmartsPatternCDK
extends AbstractSmartsPattern<IAtomContainer> {
    private static final long serialVersionUID = -63030468038251612L;
    protected transient SMARTSQueryTool sqt;

    public SmartsPatternCDK() {
        this.sqt = null;
    }

    public SmartsPatternCDK(String smarts) throws SMARTSException {
        this(smarts, false);
    }

    public SmartsPatternCDK(String smarts, boolean negate) throws SMARTSException {
        this.setSmarts(smarts);
        this.setNegate(negate);
    }

    @Override
    public QueryAtomContainer getQuery() {
        return null;
    }

    @Override
    public String getSmarts() {
        if (this.sqt == null) {
            return "";
        }
        return this.sqt.getSmarts();
    }

    @Override
    public void setSmarts(String smarts) throws SMARTSException {
        try {
            if (this.sqt == null) {
                this.sqt = new SMARTSQueryTool(smarts);
            } else {
                this.sqt.setSmarts(smarts);
            }
            super.setSmarts(smarts);
        }
        catch (CDKException x) {
            throw new SMARTSException(x);
        }
    }

    @Override
    public int hasSMARTSPattern(IAtomContainer mol) throws SMARTSException {
        if (this.sqt == null) {
            throw new SMARTSException("Undefined SMARTS pattern");
        }
        try {
            if (this.sqt.matches(mol)) {
                return this.sqt.countMatches();
            }
            return 0;
        }
        catch (CDKException x) {
            throw new SMARTSException(x);
        }
    }

    @Override
    public IAtomContainer getObjectToVerify(IAtomContainer mol) {
        return mol;
    }

    public String getImplementationDetails() {
        if (this.sqt == null) {
            return "CDK SMARTS";
        }
        return this.sqt.getClass().getName();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.setSmarts(this.smarts);
        }
        catch (Exception x) {
            this.sqt = null;
        }
    }

    @Override
    public IAtomContainer getMatchingStructure(IAtomContainer mol) throws SMARTSException {
        IAtomContainer selected = MoleculeTools.newAtomContainer(SilentChemObjectBuilder.getInstance());
        List list = this.sqt.getUniqueMatchingAtoms();
        for (int j = 0; j < list.size(); ++j) {
            List l = (List)list.get(j);
            for (int k = 0; k < l.size(); ++k) {
                selected.addAtom(mol.getAtom(((Integer)l.get(k)).intValue()));
            }
        }
        return selected;
    }

    public List<List<Integer>> getUniqueMatchingAtoms(IAtomContainer mol) throws SMARTSException {
        if (this.sqt == null) {
            throw new SMARTSException(Resources.getString("SMARTS_UNDEFINED"));
        }
        return this.sqt.getUniqueMatchingAtoms();
    }

    @Override
    public void useMOEvPrimitive(boolean flag) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("useMOEvPrimitive");
    }

    @Override
    public List<List<Integer>> getUniqueMatchingAtoms() throws SMARTSException {
        if (this.sqt == null) {
            throw new SMARTSException("Undefined SMARTS pattern");
        }
        return this.sqt.getUniqueMatchingAtoms();
    }
}

