# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['novelsave_sources',
 'novelsave_sources.models',
 'novelsave_sources.sources',
 'novelsave_sources.sources.metadata',
 'novelsave_sources.sources.novel',
 'novelsave_sources.utils']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.10.0,<5.0.0',
 'cloudscraper>=1.2.58,<2.0.0',
 'deprecation>=2.1.0,<3.0.0',
 'lxml>=4.6.3,<5.0.0',
 'requests>=2.26.0,<3.0.0']

extras_require = \
{'docs': ['sphinx_rtd_theme>=1.0.0,<2.0.0', 'sphinx>=4.2.0,<5.0.0']}

setup_kwargs = {
    'name': 'novelsave-sources',
    'version': '0.3.2',
    'description': 'A collection of novel sources offering varying amounts of scraping capability.',
    'long_description': '# 📚 Novelsave Sources\n\n![PyPI](https://img.shields.io/pypi/v/novelsave_sources)\n![Python Version](https://img.shields.io/badge/Python-v3.8-blue)\n![Repo Size](https://img.shields.io/github/repo-size/mensch272/novelsave_sources)\n[![Contributors](https://img.shields.io/github/contributors/mensch272/novelsave_sources)](https://github.com/mensch272/novelsave_sources/graphs/contributors)\n![Last Commit](https://img.shields.io/github/last-commit/mensch272/novelsave_sources/main)\n![Issues](https://img.shields.io/github/issues/mensch272/novelsave_sources)\n![Pull Requests](https://img.shields.io/github/issues-pr/mensch272/novelsave_sources)\n[![License](https://img.shields.io/github/license/mensch272/novelsave_sources)](LICENSE)\n[![Tests](https://github.com/mensch272/novelsave_sources/actions/workflows/tests.yml/badge.svg)](https://github.com/mensch272/novelsave_sources/actions/workflows/tests.yml)\n[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/mensch272/novelsave_sources/main.svg)](https://results.pre-commit.ci/latest/github/mensch272/novelsave_sources/main)\n[![Documentation Status](https://readthedocs.org/projects/novelsave-sources/badge/?version=latest)](https://novelsave-sources.readthedocs.io/en/latest/?badge=latest)\n\nA collection of novel sources offering varying amounts of scraping capability.\n\nRead the [docs](https://novelsave-sources.readthedocs.io/en/latest/) for more information.\n\n> Request a new source by [creating a new issue](https://github.com/mensch272/novelsave_sources/issues/new/choose)\n\n### Development\n\nMake sure you complete the following before you start development:\n\n1. Install poetry as described in their [documentation](https://python-poetry.org/docs/#installation).\n\n2. Install all project dependencies\n\n    ```bash\n    poetry install\n    ```\n\n3. And setup git hooks by running\n\n    ```bash\n    pre-commit install\n    ```\n\n___\n\nIf you have updated a source make sure to update the\nsources segment in the README.md by running the following command:\n\n```bash\npython3 manage.py compile\n```\n\n## 📒 Sources\n\n### Novel\n\n#### ✅ Supported\n\n<table>\n    <thead>\n        <tr>\n            <th align="center">Lang</th>\n            <th>Source</th>\n            <th align="center">Search</th>\n            <th align="center">Last Checked</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td align="center">en</td>\n            <td>https://1stkissnovel.love</td>\n            <td align="center"></td>\n            <td align="center">2021-10-14</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://betwixtedbutterfly.com</td>\n            <td align="center"></td>\n            <td align="center">2021-10-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://boxnovel.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://cclawtranslations.home.blog/</td>\n            <td align="center"></td>\n            <td align="center">2021-11-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://chrysanthemumgarden.com/</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://creativenovels.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-17</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://dragontea.ink/</td>\n            <td align="center"></td>\n            <td align="center">2021-10-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://dummynovels.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://forums.spacebattles.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-09</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://forums.sufficientvelocity.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-09</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelfull.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelfun.net</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelgate.net</td>\n            <td align="center"></td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelonlinefull.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelsite.net</td>\n            <td align="center"></td>\n            <td align="center">2021-09-06</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelsonline.net</td>\n            <td align="center"></td>\n            <td align="center">2021-11-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelsrock.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://peachpitting.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://rainofsnow.com/</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://readlightnovels.net</td>\n            <td align="center"></td>\n            <td align="center">2021-09-06</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://readnovelfull.com/</td>\n            <td align="center"></td>\n            <td align="center">2021-10-17</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://wuxiaworld.online</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://wuxiaworld.site</td>\n            <td align="center"></td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.chickengege.org</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.foxaholic.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.lightnovelworld.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.mtlnovel.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.novelhall.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.novelpassion.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.novelpub.com</td>\n            <td align="center">✅</td>\n            <td align="center">2021-10-29</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.readlightnovel.me</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.royalroad.com</td>\n            <td align="center">✅</td>\n            <td align="center">2021-10-29</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.scribblehub.com</td>\n            <td align="center">✅</td>\n            <td align="center">2021-10-29</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.wattpad.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-06</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.webnovel.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.wuxiaworld.co</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.wuxiaworld.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">es</td>\n            <td>https://domentranslations.wordpress.com/</td>\n            <td align="center"></td>\n            <td align="center">2021-11-03</td>\n        </tr>\n        <tr>\n            <td align="center">zh</td>\n            <td>https://book.qidian.com</td>\n            <td align="center"></td>\n            <td align="center">2021-10-29</td>\n        </tr>\n    </tbody>\n</table>\n\n#### ❌ Rejected\n\n<table>\n    <thead>\n        <tr>\n            <th align="center">Lang</th>\n            <th>Source</th>\n            <th>Reason</th>\n            <th>Added</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td align="center">multi</td>\n            <td>https://www.fanfiction.net</td>\n            <td>Has cloudflare bot protection</td>\n            <td>2021-10-30</td>\n        </tr>\n    </tbody>\n</table>\n\n### Metadata\n\n#### ✅ Supported\n\n<table>\n    <thead>\n        <tr>\n            <th align="center">Lang</th>\n            <th>Metadata Source</th>\n            <th align="center">Last Checked</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.novelupdates.com</td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.wlnupdates.com/</td>\n            <td align="center">2021-08-25</td>\n        </tr>\n    </tbody>\n</table>\n\n## 📝 Disclaimer\n\nWe are not affiliated, associated, authorized, endorsed by, or in any way officially\nconnected with any of the [sources](#sources) mentioned above.\n\n## 📜 License\n\n[Apache-2.0](https://github.com/mHaisham/novelsave_sources/blob/master/LICENSE)\n',
    'author': 'Mensch272',
    'author_email': '47662901+mensch272@users.noreply.github.com',
    'maintainer': 'Mensch272',
    'maintainer_email': '47662901+mensch272@users.noreply.github.com',
    'url': 'https://github.com/mensch272/novelsave_sources',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
