import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/role#id Role#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the storage policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/role#name Role#name}
    */
    readonly name: string;
    /**
    * The privileges to be associated with the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/role#role_privileges Role#role_privileges}
    */
    readonly rolePrivileges?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/role vsphere_role}
*/
export declare class Role extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/role vsphere_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleConfig
    */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get label(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rolePrivileges?;
    get rolePrivileges(): string[];
    set rolePrivileges(value: string[]);
    resetRolePrivileges(): void;
    get rolePrivilegesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
