"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsphereProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere vsphere}
*/
class VsphereProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere vsphere} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VsphereProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.2.0',
                providerVersionConstraint: '~> 2.2'
            },
            terraformProviderSource: 'vsphere'
        });
        this._allowUnverifiedSsl = config.allowUnverifiedSsl;
        this._apiTimeout = config.apiTimeout;
        this._clientDebug = config.clientDebug;
        this._clientDebugPath = config.clientDebugPath;
        this._clientDebugPathRun = config.clientDebugPathRun;
        this._password = config.password;
        this._persistSession = config.persistSession;
        this._restSessionPath = config.restSessionPath;
        this._user = config.user;
        this._vcenterServer = config.vcenterServer;
        this._vimKeepAlive = config.vimKeepAlive;
        this._vimSessionPath = config.vimSessionPath;
        this._vsphereServer = config.vsphereServer;
        this._alias = config.alias;
    }
    get allowUnverifiedSsl() {
        return this._allowUnverifiedSsl;
    }
    set allowUnverifiedSsl(value) {
        this._allowUnverifiedSsl = value;
    }
    resetAllowUnverifiedSsl() {
        this._allowUnverifiedSsl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowUnverifiedSslInput() {
        return this._allowUnverifiedSsl;
    }
    get apiTimeout() {
        return this._apiTimeout;
    }
    set apiTimeout(value) {
        this._apiTimeout = value;
    }
    resetApiTimeout() {
        this._apiTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apiTimeoutInput() {
        return this._apiTimeout;
    }
    get clientDebug() {
        return this._clientDebug;
    }
    set clientDebug(value) {
        this._clientDebug = value;
    }
    resetClientDebug() {
        this._clientDebug = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientDebugInput() {
        return this._clientDebug;
    }
    get clientDebugPath() {
        return this._clientDebugPath;
    }
    set clientDebugPath(value) {
        this._clientDebugPath = value;
    }
    resetClientDebugPath() {
        this._clientDebugPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientDebugPathInput() {
        return this._clientDebugPath;
    }
    get clientDebugPathRun() {
        return this._clientDebugPathRun;
    }
    set clientDebugPathRun(value) {
        this._clientDebugPathRun = value;
    }
    resetClientDebugPathRun() {
        this._clientDebugPathRun = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientDebugPathRunInput() {
        return this._clientDebugPathRun;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get persistSession() {
        return this._persistSession;
    }
    set persistSession(value) {
        this._persistSession = value;
    }
    resetPersistSession() {
        this._persistSession = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get persistSessionInput() {
        return this._persistSession;
    }
    get restSessionPath() {
        return this._restSessionPath;
    }
    set restSessionPath(value) {
        this._restSessionPath = value;
    }
    resetRestSessionPath() {
        this._restSessionPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restSessionPathInput() {
        return this._restSessionPath;
    }
    get user() {
        return this._user;
    }
    set user(value) {
        this._user = value;
    }
    // Temporarily expose input value. Use with caution.
    get userInput() {
        return this._user;
    }
    get vcenterServer() {
        return this._vcenterServer;
    }
    set vcenterServer(value) {
        this._vcenterServer = value;
    }
    resetVcenterServer() {
        this._vcenterServer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vcenterServerInput() {
        return this._vcenterServer;
    }
    get vimKeepAlive() {
        return this._vimKeepAlive;
    }
    set vimKeepAlive(value) {
        this._vimKeepAlive = value;
    }
    resetVimKeepAlive() {
        this._vimKeepAlive = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vimKeepAliveInput() {
        return this._vimKeepAlive;
    }
    get vimSessionPath() {
        return this._vimSessionPath;
    }
    set vimSessionPath(value) {
        this._vimSessionPath = value;
    }
    resetVimSessionPath() {
        this._vimSessionPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vimSessionPathInput() {
        return this._vimSessionPath;
    }
    get vsphereServer() {
        return this._vsphereServer;
    }
    set vsphereServer(value) {
        this._vsphereServer = value;
    }
    resetVsphereServer() {
        this._vsphereServer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsphereServerInput() {
        return this._vsphereServer;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_unverified_ssl: cdktf.booleanToTerraform(this._allowUnverifiedSsl),
            api_timeout: cdktf.numberToTerraform(this._apiTimeout),
            client_debug: cdktf.booleanToTerraform(this._clientDebug),
            client_debug_path: cdktf.stringToTerraform(this._clientDebugPath),
            client_debug_path_run: cdktf.stringToTerraform(this._clientDebugPathRun),
            password: cdktf.stringToTerraform(this._password),
            persist_session: cdktf.booleanToTerraform(this._persistSession),
            rest_session_path: cdktf.stringToTerraform(this._restSessionPath),
            user: cdktf.stringToTerraform(this._user),
            vcenter_server: cdktf.stringToTerraform(this._vcenterServer),
            vim_keep_alive: cdktf.numberToTerraform(this._vimKeepAlive),
            vim_session_path: cdktf.stringToTerraform(this._vimSessionPath),
            vsphere_server: cdktf.stringToTerraform(this._vsphereServer),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.VsphereProvider = VsphereProvider;
_a = JSII_RTTI_SYMBOL_1;
VsphereProvider[_a] = { fqn: "@cdktf/provider-vsphere.provider.VsphereProvider", version: "2.0.0" };
// =================
// STATIC PROPERTIES
// =================
VsphereProvider.tfResourceType = "vsphere";
//# sourceMappingURL=data:application/json;base64,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