import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereDynamicConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of tag IDs to match target.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/dynamic#filter DataVsphereDynamic#filter}
    */
    readonly filter: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/dynamic#id DataVsphereDynamic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A regular expression used to match against managed object names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/dynamic#name_regex DataVsphereDynamic#name_regex}
    */
    readonly nameRegex?: string;
    /**
    * The type of managed object to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/dynamic#type DataVsphereDynamic#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/dynamic vsphere_dynamic}
*/
export declare class DataVsphereDynamic extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_dynamic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/dynamic vsphere_dynamic} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereDynamicConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereDynamicConfig);
    private _filter?;
    get filter(): string[];
    set filter(value: string[]);
    get filterInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
