import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeClusterVmDependencyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule#compute_cluster_id ComputeClusterVmDependencyRule#compute_cluster_id}
    */
    readonly computeClusterId: string;
    /**
    * The name of the VM group that this rule depends on. The VMs defined in the group specified by vm_group_name will not be started until the VMs in this group are started.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule#dependency_vm_group_name ComputeClusterVmDependencyRule#dependency_vm_group_name}
    */
    readonly dependencyVmGroupName: string;
    /**
    * Enable this rule in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule#enabled ComputeClusterVmDependencyRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule#id ComputeClusterVmDependencyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When true, prevents any virtual machine operations that may violate this rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule#mandatory ComputeClusterVmDependencyRule#mandatory}
    */
    readonly mandatory?: boolean | cdktf.IResolvable;
    /**
    * The unique name of the virtual machine group in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule#name ComputeClusterVmDependencyRule#name}
    */
    readonly name: string;
    /**
    * The name of the VM group that is the subject of this rule. The VMs defined in this group will not be started until the VMs in the group specified by dependency_vm_group_name are started.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule#vm_group_name ComputeClusterVmDependencyRule#vm_group_name}
    */
    readonly vmGroupName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule vsphere_compute_cluster_vm_dependency_rule}
*/
export declare class ComputeClusterVmDependencyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_compute_cluster_vm_dependency_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster_vm_dependency_rule vsphere_compute_cluster_vm_dependency_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterVmDependencyRuleConfig
    */
    constructor(scope: Construct, id: string, config: ComputeClusterVmDependencyRuleConfig);
    private _computeClusterId?;
    get computeClusterId(): string;
    set computeClusterId(value: string);
    get computeClusterIdInput(): string | undefined;
    private _dependencyVmGroupName?;
    get dependencyVmGroupName(): string;
    set dependencyVmGroupName(value: string);
    get dependencyVmGroupNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mandatory?;
    get mandatory(): boolean | cdktf.IResolvable;
    set mandatory(value: boolean | cdktf.IResolvable);
    resetMandatory(): void;
    get mandatoryInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _vmGroupName?;
    get vmGroupName(): string;
    set vmGroupName(value: string);
    get vmGroupNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
