from aiida_lammps.data.pot_plugins.base_plugin import PotentialAbstract


class Tersoff(PotentialAbstract):
    """Class for creation of Tersoff potential inputs."""

    potential_fname = "potential.pot"

    def validate_data(self, data):
        """Validate the input data."""
        pass

    def get_external_content(self):
        potential_file = (
            "# Potential file generated by aiida plugin "
            "(please check citation in the original file)\n"
        )
        for key in sorted(self.data.keys()):
            potential_file += "{}    {}\n".format(key, self.data[key])

        return {self.potential_fname: potential_file}

    def get_input_potential_lines(self):

        lammps_input_text = "pair_style      tersoff\n"
        lammps_input_text += "pair_coeff      * * {} {{kind_symbols}}\n".format(
            self.potential_fname
        )

        return lammps_input_text

    @property
    def allowed_element_names(self):
        allowed = []
        for key in self.data:
            allowed.extend(key.split())
        return list(set(allowed))

    @property
    def atom_style(self):
        return "atomic"

    @property
    def default_units(self):
        return "metal"
