from aiida_lammps.data.pot_plugins.base_plugin import PotentialAbstract


class EAM(PotentialAbstract):
    """Class for creation of EAM potential inputs."""

    potential_fname = "potential.pot"

    def validate_data(self, data):
        """Validate the input data."""
        # TODO use schema
        assert "file_contents" in data, data
        assert "type" in data, data

    def get_external_content(self):
        # potential_file = (
        #     "# Potential file generated by aiida plugin "
        #     "(please check citation in the orignal file)\n"
        # )
        potential_file = ""
        for line in self.data["file_contents"]:
            potential_file += "{}".format(line)

        return {self.potential_fname: potential_file}

    def get_input_potential_lines(self):

        lammps_input_text = "pair_style      eam/{}\n".format(self.data["type"])
        lammps_input_text += "pair_coeff      * * {0} {{kind_symbols}}\n".format(
            self.potential_fname
        )

        return lammps_input_text

    @property
    def allowed_element_names(self):
        return self.data.get("element_names", None)

    @property
    def atom_style(self):
        return "atomic"

    @property
    def default_units(self):
        return "metal"
