# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AclArgs', 'Acl']

@pulumi.input_type
class AclArgs:
    def __init__(__self__, *,
                 acl_host: pulumi.Input[_builtins.str],
                 acl_operation: pulumi.Input[_builtins.str],
                 acl_permission_type: pulumi.Input[_builtins.str],
                 acl_principal: pulumi.Input[_builtins.str],
                 acl_resource_name: pulumi.Input[_builtins.str],
                 acl_resource_type: pulumi.Input[_builtins.str],
                 resource_pattern_type_filter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Acl resource.
        :param pulumi.Input[_builtins.str] acl_resource_name: The name of the resource
        """
        pulumi.set(__self__, "acl_host", acl_host)
        pulumi.set(__self__, "acl_operation", acl_operation)
        pulumi.set(__self__, "acl_permission_type", acl_permission_type)
        pulumi.set(__self__, "acl_principal", acl_principal)
        pulumi.set(__self__, "acl_resource_name", acl_resource_name)
        pulumi.set(__self__, "acl_resource_type", acl_resource_type)
        if resource_pattern_type_filter is not None:
            pulumi.set(__self__, "resource_pattern_type_filter", resource_pattern_type_filter)

    @_builtins.property
    @pulumi.getter(name="aclHost")
    def acl_host(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "acl_host")

    @acl_host.setter
    def acl_host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_host", value)

    @_builtins.property
    @pulumi.getter(name="aclOperation")
    def acl_operation(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "acl_operation")

    @acl_operation.setter
    def acl_operation(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_operation", value)

    @_builtins.property
    @pulumi.getter(name="aclPermissionType")
    def acl_permission_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "acl_permission_type")

    @acl_permission_type.setter
    def acl_permission_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_permission_type", value)

    @_builtins.property
    @pulumi.getter(name="aclPrincipal")
    def acl_principal(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "acl_principal")

    @acl_principal.setter
    def acl_principal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_principal", value)

    @_builtins.property
    @pulumi.getter(name="aclResourceName")
    def acl_resource_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "acl_resource_name")

    @acl_resource_name.setter
    def acl_resource_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_resource_name", value)

    @_builtins.property
    @pulumi.getter(name="aclResourceType")
    def acl_resource_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "acl_resource_type")

    @acl_resource_type.setter
    def acl_resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_resource_type", value)

    @_builtins.property
    @pulumi.getter(name="resourcePatternTypeFilter")
    def resource_pattern_type_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "resource_pattern_type_filter")

    @resource_pattern_type_filter.setter
    def resource_pattern_type_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_pattern_type_filter", value)


@pulumi.input_type
class _AclState:
    def __init__(__self__, *,
                 acl_host: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_operation: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_permission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_principal: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_pattern_type_filter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Acl resources.
        :param pulumi.Input[_builtins.str] acl_resource_name: The name of the resource
        """
        if acl_host is not None:
            pulumi.set(__self__, "acl_host", acl_host)
        if acl_operation is not None:
            pulumi.set(__self__, "acl_operation", acl_operation)
        if acl_permission_type is not None:
            pulumi.set(__self__, "acl_permission_type", acl_permission_type)
        if acl_principal is not None:
            pulumi.set(__self__, "acl_principal", acl_principal)
        if acl_resource_name is not None:
            pulumi.set(__self__, "acl_resource_name", acl_resource_name)
        if acl_resource_type is not None:
            pulumi.set(__self__, "acl_resource_type", acl_resource_type)
        if resource_pattern_type_filter is not None:
            pulumi.set(__self__, "resource_pattern_type_filter", resource_pattern_type_filter)

    @_builtins.property
    @pulumi.getter(name="aclHost")
    def acl_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "acl_host")

    @acl_host.setter
    def acl_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_host", value)

    @_builtins.property
    @pulumi.getter(name="aclOperation")
    def acl_operation(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "acl_operation")

    @acl_operation.setter
    def acl_operation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_operation", value)

    @_builtins.property
    @pulumi.getter(name="aclPermissionType")
    def acl_permission_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "acl_permission_type")

    @acl_permission_type.setter
    def acl_permission_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_permission_type", value)

    @_builtins.property
    @pulumi.getter(name="aclPrincipal")
    def acl_principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "acl_principal")

    @acl_principal.setter
    def acl_principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_principal", value)

    @_builtins.property
    @pulumi.getter(name="aclResourceName")
    def acl_resource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "acl_resource_name")

    @acl_resource_name.setter
    def acl_resource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_resource_name", value)

    @_builtins.property
    @pulumi.getter(name="aclResourceType")
    def acl_resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "acl_resource_type")

    @acl_resource_type.setter
    def acl_resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_resource_type", value)

    @_builtins.property
    @pulumi.getter(name="resourcePatternTypeFilter")
    def resource_pattern_type_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "resource_pattern_type_filter")

    @resource_pattern_type_filter.setter
    def resource_pattern_type_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_pattern_type_filter", value)


@pulumi.type_token("kafka:index/acl:Acl")
class Acl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_host: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_operation: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_permission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_principal: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_pattern_type_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `Acl` resource manages Apache Kafka Access Control Lists (ACLs). ACLs control access to Kafka resources like topics, consumer groups, and clusters by defining which principals (users or services) can perform specific operations on these resources.

        ## Example Usage

        ### Allow Producer Access to Topic

        ```python
        import pulumi
        import pulumi_kafka as kafka

        producer = kafka.Acl("producer",
            acl_resource_name="orders",
            acl_resource_type="Topic",
            acl_principal="User:producer-service",
            acl_host="*",
            acl_operation="Write",
            acl_permission_type="Allow")
        # Also grant describe permission for producers
        producer_describe = kafka.Acl("producer_describe",
            acl_resource_name="orders",
            acl_resource_type="Topic",
            acl_principal="User:producer-service",
            acl_host="*",
            acl_operation="Describe",
            acl_permission_type="Allow")
        ```

        ### Allow Consumer Group Access

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Allow read access to topic
        consumer_read = kafka.Acl("consumer_read",
            acl_resource_name="orders",
            acl_resource_type="Topic",
            acl_principal="User:consumer-service",
            acl_host="*",
            acl_operation="Read",
            acl_permission_type="Allow")
        # Allow access to consumer group
        consumer_group = kafka.Acl("consumer_group",
            acl_resource_name="order-processors",
            acl_resource_type="Group",
            acl_principal="User:consumer-service",
            acl_host="*",
            acl_operation="Read",
            acl_permission_type="Allow")
        ```

        ### Prefix-Based Access Control

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Grant access to all topics with prefix "logs-"
        logs_access = kafka.Acl("logs_access",
            acl_resource_name="logs-",
            acl_resource_type="Topic",
            resource_pattern_type_filter="Prefixed",
            acl_principal="User:log-aggregator",
            acl_host="*",
            acl_operation="Read",
            acl_permission_type="Allow")
        ```

        ### Admin User with Full Access

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Grant cluster-level admin access
        admin_cluster = kafka.Acl("admin_cluster",
            acl_resource_name="kafka-cluster",
            acl_resource_type="Cluster",
            acl_principal="User:admin",
            acl_host="*",
            acl_operation="All",
            acl_permission_type="Allow")
        ```

        ## Common ACL Patterns

        ### Producer ACLs
        Producers typically need:
        - `Write` and `Describe` on topics
        - `Write` on `TransactionalID` (for transactional producers)
        - `IdempotentWrite` on `Cluster` (for idempotent producers)

        ### Consumer ACLs
        Consumers typically need:
        - `Read` on topics
        - `Read` on consumer groups
        - `Describe` on topics (optional, for metadata)

        ### Admin ACLs
        Administrators typically need:
        - `All` on `Cluster`
        - Or specific operations like `Alter`, `AlterConfigs`, `Create`, `Delete`

        > **Warning:** Be cautious with `Deny` ACLs as they take precedence over `Allow` ACLs. A deny rule will block access even if an allow rule exists.

        ## Import

        Kafka ACLs can be imported using a pipe-delimited string containing all ACL properties:

        Format: ${acl_principal}|${acl_host}|${acl_operation}|${acl_permission_type}|${resource_type}|${resource_name}|${resource_pattern_type_filter}

        ```sh
        $ pulumi import kafka:index/acl:Acl example 'User:producer|*|Write|Allow|Topic|orders|Literal'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_resource_name: The name of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `Acl` resource manages Apache Kafka Access Control Lists (ACLs). ACLs control access to Kafka resources like topics, consumer groups, and clusters by defining which principals (users or services) can perform specific operations on these resources.

        ## Example Usage

        ### Allow Producer Access to Topic

        ```python
        import pulumi
        import pulumi_kafka as kafka

        producer = kafka.Acl("producer",
            acl_resource_name="orders",
            acl_resource_type="Topic",
            acl_principal="User:producer-service",
            acl_host="*",
            acl_operation="Write",
            acl_permission_type="Allow")
        # Also grant describe permission for producers
        producer_describe = kafka.Acl("producer_describe",
            acl_resource_name="orders",
            acl_resource_type="Topic",
            acl_principal="User:producer-service",
            acl_host="*",
            acl_operation="Describe",
            acl_permission_type="Allow")
        ```

        ### Allow Consumer Group Access

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Allow read access to topic
        consumer_read = kafka.Acl("consumer_read",
            acl_resource_name="orders",
            acl_resource_type="Topic",
            acl_principal="User:consumer-service",
            acl_host="*",
            acl_operation="Read",
            acl_permission_type="Allow")
        # Allow access to consumer group
        consumer_group = kafka.Acl("consumer_group",
            acl_resource_name="order-processors",
            acl_resource_type="Group",
            acl_principal="User:consumer-service",
            acl_host="*",
            acl_operation="Read",
            acl_permission_type="Allow")
        ```

        ### Prefix-Based Access Control

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Grant access to all topics with prefix "logs-"
        logs_access = kafka.Acl("logs_access",
            acl_resource_name="logs-",
            acl_resource_type="Topic",
            resource_pattern_type_filter="Prefixed",
            acl_principal="User:log-aggregator",
            acl_host="*",
            acl_operation="Read",
            acl_permission_type="Allow")
        ```

        ### Admin User with Full Access

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Grant cluster-level admin access
        admin_cluster = kafka.Acl("admin_cluster",
            acl_resource_name="kafka-cluster",
            acl_resource_type="Cluster",
            acl_principal="User:admin",
            acl_host="*",
            acl_operation="All",
            acl_permission_type="Allow")
        ```

        ## Common ACL Patterns

        ### Producer ACLs
        Producers typically need:
        - `Write` and `Describe` on topics
        - `Write` on `TransactionalID` (for transactional producers)
        - `IdempotentWrite` on `Cluster` (for idempotent producers)

        ### Consumer ACLs
        Consumers typically need:
        - `Read` on topics
        - `Read` on consumer groups
        - `Describe` on topics (optional, for metadata)

        ### Admin ACLs
        Administrators typically need:
        - `All` on `Cluster`
        - Or specific operations like `Alter`, `AlterConfigs`, `Create`, `Delete`

        > **Warning:** Be cautious with `Deny` ACLs as they take precedence over `Allow` ACLs. A deny rule will block access even if an allow rule exists.

        ## Import

        Kafka ACLs can be imported using a pipe-delimited string containing all ACL properties:

        Format: ${acl_principal}|${acl_host}|${acl_operation}|${acl_permission_type}|${resource_type}|${resource_name}|${resource_pattern_type_filter}

        ```sh
        $ pulumi import kafka:index/acl:Acl example 'User:producer|*|Write|Allow|Topic|orders|Literal'
        ```

        :param str resource_name: The name of the resource.
        :param AclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_host: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_operation: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_permission_type: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_principal: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_pattern_type_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclArgs.__new__(AclArgs)

            if acl_host is None and not opts.urn:
                raise TypeError("Missing required property 'acl_host'")
            __props__.__dict__["acl_host"] = acl_host
            if acl_operation is None and not opts.urn:
                raise TypeError("Missing required property 'acl_operation'")
            __props__.__dict__["acl_operation"] = acl_operation
            if acl_permission_type is None and not opts.urn:
                raise TypeError("Missing required property 'acl_permission_type'")
            __props__.__dict__["acl_permission_type"] = acl_permission_type
            if acl_principal is None and not opts.urn:
                raise TypeError("Missing required property 'acl_principal'")
            __props__.__dict__["acl_principal"] = acl_principal
            if acl_resource_name is None and not opts.urn:
                raise TypeError("Missing required property 'acl_resource_name'")
            __props__.__dict__["acl_resource_name"] = acl_resource_name
            if acl_resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'acl_resource_type'")
            __props__.__dict__["acl_resource_type"] = acl_resource_type
            __props__.__dict__["resource_pattern_type_filter"] = resource_pattern_type_filter
        super(Acl, __self__).__init__(
            'kafka:index/acl:Acl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_host: Optional[pulumi.Input[_builtins.str]] = None,
            acl_operation: Optional[pulumi.Input[_builtins.str]] = None,
            acl_permission_type: Optional[pulumi.Input[_builtins.str]] = None,
            acl_principal: Optional[pulumi.Input[_builtins.str]] = None,
            acl_resource_name: Optional[pulumi.Input[_builtins.str]] = None,
            acl_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_pattern_type_filter: Optional[pulumi.Input[_builtins.str]] = None) -> 'Acl':
        """
        Get an existing Acl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_resource_name: The name of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclState.__new__(_AclState)

        __props__.__dict__["acl_host"] = acl_host
        __props__.__dict__["acl_operation"] = acl_operation
        __props__.__dict__["acl_permission_type"] = acl_permission_type
        __props__.__dict__["acl_principal"] = acl_principal
        __props__.__dict__["acl_resource_name"] = acl_resource_name
        __props__.__dict__["acl_resource_type"] = acl_resource_type
        __props__.__dict__["resource_pattern_type_filter"] = resource_pattern_type_filter
        return Acl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclHost")
    def acl_host(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "acl_host")

    @_builtins.property
    @pulumi.getter(name="aclOperation")
    def acl_operation(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "acl_operation")

    @_builtins.property
    @pulumi.getter(name="aclPermissionType")
    def acl_permission_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "acl_permission_type")

    @_builtins.property
    @pulumi.getter(name="aclPrincipal")
    def acl_principal(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "acl_principal")

    @_builtins.property
    @pulumi.getter(name="aclResourceName")
    def acl_resource_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "acl_resource_name")

    @_builtins.property
    @pulumi.getter(name="aclResourceType")
    def acl_resource_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "acl_resource_type")

    @_builtins.property
    @pulumi.getter(name="resourcePatternTypeFilter")
    def resource_pattern_type_filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "resource_pattern_type_filter")

