# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesClusterArgs', 'KubernetesCluster']

@pulumi.input_type
class KubernetesClusterArgs:
    def __init__(__self__, *,
                 cni: pulumi.Input[str],
                 version: pulumi.Input[str],
                 admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_upgrade: Optional[pulumi.Input['KubernetesClusterAutoUpgradeArgs']] = None,
                 autoscaler_config: Optional[pulumi.Input['KubernetesClusterAutoscalerConfigArgs']] = None,
                 delete_additional_resources: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_id_connect_config: Optional[pulumi.Input['KubernetesClusterOpenIdConnectConfigArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KubernetesCluster resource.
        :param pulumi.Input[str] cni: The Container Network Interface (CNI) for the Kubernetes cluster.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] version: The version of the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admission_plugins: The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apiserver_cert_sans: Additional Subject Alternative Names for the Kubernetes API server certificate
        :param pulumi.Input['KubernetesClusterAutoUpgradeArgs'] auto_upgrade: The auto upgrade configuration.
        :param pulumi.Input['KubernetesClusterAutoscalerConfigArgs'] autoscaler_config: The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        :param pulumi.Input[bool] delete_additional_resources: Delete additional resources like block volumes and loadbalancers that were created in Kubernetes on cluster deletion.
        :param pulumi.Input[str] description: A description for the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] feature_gates: The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        :param pulumi.Input[str] name: The name for the Kubernetes cluster.
        :param pulumi.Input['KubernetesClusterOpenIdConnectConfigArgs'] open_id_connect_config: The OpenID Connect configuration of the cluster
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the cluster is associated with.
        :param pulumi.Input[str] region: `region`) The region in which the cluster should be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Kubernetes cluster.
        :param pulumi.Input[str] type: The type of Kubernetes cluster. Possible values are: `kapsule` or `multicloud`.
        """
        pulumi.set(__self__, "cni", cni)
        pulumi.set(__self__, "version", version)
        if admission_plugins is not None:
            pulumi.set(__self__, "admission_plugins", admission_plugins)
        if apiserver_cert_sans is not None:
            pulumi.set(__self__, "apiserver_cert_sans", apiserver_cert_sans)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if autoscaler_config is not None:
            pulumi.set(__self__, "autoscaler_config", autoscaler_config)
        if delete_additional_resources is not None:
            pulumi.set(__self__, "delete_additional_resources", delete_additional_resources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_gates is not None:
            pulumi.set(__self__, "feature_gates", feature_gates)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def cni(self) -> pulumi.Input[str]:
        """
        The Container Network Interface (CNI) for the Kubernetes cluster.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "cni")

    @cni.setter
    def cni(self, value: pulumi.Input[str]):
        pulumi.set(self, "cni", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The version of the Kubernetes cluster.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="admissionPlugins")
    def admission_plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        """
        return pulumi.get(self, "admission_plugins")

    @admission_plugins.setter
    def admission_plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admission_plugins", value)

    @property
    @pulumi.getter(name="apiserverCertSans")
    def apiserver_cert_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional Subject Alternative Names for the Kubernetes API server certificate
        """
        return pulumi.get(self, "apiserver_cert_sans")

    @apiserver_cert_sans.setter
    def apiserver_cert_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "apiserver_cert_sans", value)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input['KubernetesClusterAutoUpgradeArgs']]:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input['KubernetesClusterAutoUpgradeArgs']]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter(name="autoscalerConfig")
    def autoscaler_config(self) -> Optional[pulumi.Input['KubernetesClusterAutoscalerConfigArgs']]:
        """
        The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        """
        return pulumi.get(self, "autoscaler_config")

    @autoscaler_config.setter
    def autoscaler_config(self, value: Optional[pulumi.Input['KubernetesClusterAutoscalerConfigArgs']]):
        pulumi.set(self, "autoscaler_config", value)

    @property
    @pulumi.getter(name="deleteAdditionalResources")
    def delete_additional_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete additional resources like block volumes and loadbalancers that were created in Kubernetes on cluster deletion.
        """
        return pulumi.get(self, "delete_additional_resources")

    @delete_additional_resources.setter
    def delete_additional_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_additional_resources", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the Kubernetes cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        """
        return pulumi.get(self, "feature_gates")

    @feature_gates.setter
    def feature_gates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "feature_gates", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional[pulumi.Input['KubernetesClusterOpenIdConnectConfigArgs']]:
        """
        The OpenID Connect configuration of the cluster
        """
        return pulumi.get(self, "open_id_connect_config")

    @open_id_connect_config.setter
    def open_id_connect_config(self, value: Optional[pulumi.Input['KubernetesClusterOpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_config", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the cluster is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region in which the cluster should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Kubernetes cluster. Possible values are: `kapsule` or `multicloud`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _KubernetesClusterState:
    def __init__(__self__, *,
                 admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apiserver_url: Optional[pulumi.Input[str]] = None,
                 auto_upgrade: Optional[pulumi.Input['KubernetesClusterAutoUpgradeArgs']] = None,
                 autoscaler_config: Optional[pulumi.Input['KubernetesClusterAutoscalerConfigArgs']] = None,
                 cni: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_additional_resources: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kubeconfigs: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeconfigArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_id_connect_config: Optional[pulumi.Input['KubernetesClusterOpenIdConnectConfigArgs']] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 upgrade_available: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wildcard_dns: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KubernetesCluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admission_plugins: The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apiserver_cert_sans: Additional Subject Alternative Names for the Kubernetes API server certificate
        :param pulumi.Input[str] apiserver_url: The URL of the Kubernetes API server.
        :param pulumi.Input['KubernetesClusterAutoUpgradeArgs'] auto_upgrade: The auto upgrade configuration.
        :param pulumi.Input['KubernetesClusterAutoscalerConfigArgs'] autoscaler_config: The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        :param pulumi.Input[str] cni: The Container Network Interface (CNI) for the Kubernetes cluster.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] created_at: The creation date of the cluster.
        :param pulumi.Input[bool] delete_additional_resources: Delete additional resources like block volumes and loadbalancers that were created in Kubernetes on cluster deletion.
        :param pulumi.Input[str] description: A description for the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] feature_gates: The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeconfigArgs']]] kubeconfigs: The kubeconfig configuration file of the Kubernetes cluster
        :param pulumi.Input[str] name: The name for the Kubernetes cluster.
        :param pulumi.Input['KubernetesClusterOpenIdConnectConfigArgs'] open_id_connect_config: The OpenID Connect configuration of the cluster
        :param pulumi.Input[str] organization_id: The organization ID the cluster is associated with.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the cluster is associated with.
        :param pulumi.Input[str] region: `region`) The region in which the cluster should be created.
        :param pulumi.Input[str] status: The status of the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Kubernetes cluster.
        :param pulumi.Input[str] type: The type of Kubernetes cluster. Possible values are: `kapsule` or `multicloud`.
        :param pulumi.Input[str] updated_at: The last update date of the cluster.
        :param pulumi.Input[bool] upgrade_available: Set to `true` if a newer Kubernetes version is available.
        :param pulumi.Input[str] version: The version of the Kubernetes cluster.
        :param pulumi.Input[str] wildcard_dns: The DNS wildcard that points to all ready nodes.
               - `kubeconfig`
        """
        if admission_plugins is not None:
            pulumi.set(__self__, "admission_plugins", admission_plugins)
        if apiserver_cert_sans is not None:
            pulumi.set(__self__, "apiserver_cert_sans", apiserver_cert_sans)
        if apiserver_url is not None:
            pulumi.set(__self__, "apiserver_url", apiserver_url)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if autoscaler_config is not None:
            pulumi.set(__self__, "autoscaler_config", autoscaler_config)
        if cni is not None:
            pulumi.set(__self__, "cni", cni)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_additional_resources is not None:
            pulumi.set(__self__, "delete_additional_resources", delete_additional_resources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_gates is not None:
            pulumi.set(__self__, "feature_gates", feature_gates)
        if kubeconfigs is not None:
            pulumi.set(__self__, "kubeconfigs", kubeconfigs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wildcard_dns is not None:
            pulumi.set(__self__, "wildcard_dns", wildcard_dns)

    @property
    @pulumi.getter(name="admissionPlugins")
    def admission_plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        """
        return pulumi.get(self, "admission_plugins")

    @admission_plugins.setter
    def admission_plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admission_plugins", value)

    @property
    @pulumi.getter(name="apiserverCertSans")
    def apiserver_cert_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional Subject Alternative Names for the Kubernetes API server certificate
        """
        return pulumi.get(self, "apiserver_cert_sans")

    @apiserver_cert_sans.setter
    def apiserver_cert_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "apiserver_cert_sans", value)

    @property
    @pulumi.getter(name="apiserverUrl")
    def apiserver_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "apiserver_url")

    @apiserver_url.setter
    def apiserver_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apiserver_url", value)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input['KubernetesClusterAutoUpgradeArgs']]:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input['KubernetesClusterAutoUpgradeArgs']]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter(name="autoscalerConfig")
    def autoscaler_config(self) -> Optional[pulumi.Input['KubernetesClusterAutoscalerConfigArgs']]:
        """
        The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        """
        return pulumi.get(self, "autoscaler_config")

    @autoscaler_config.setter
    def autoscaler_config(self, value: Optional[pulumi.Input['KubernetesClusterAutoscalerConfigArgs']]):
        pulumi.set(self, "autoscaler_config", value)

    @property
    @pulumi.getter
    def cni(self) -> Optional[pulumi.Input[str]]:
        """
        The Container Network Interface (CNI) for the Kubernetes cluster.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "cni")

    @cni.setter
    def cni(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cni", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The creation date of the cluster.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deleteAdditionalResources")
    def delete_additional_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete additional resources like block volumes and loadbalancers that were created in Kubernetes on cluster deletion.
        """
        return pulumi.get(self, "delete_additional_resources")

    @delete_additional_resources.setter
    def delete_additional_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_additional_resources", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the Kubernetes cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        """
        return pulumi.get(self, "feature_gates")

    @feature_gates.setter
    def feature_gates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "feature_gates", value)

    @property
    @pulumi.getter
    def kubeconfigs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeconfigArgs']]]]:
        """
        The kubeconfig configuration file of the Kubernetes cluster
        """
        return pulumi.get(self, "kubeconfigs")

    @kubeconfigs.setter
    def kubeconfigs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeconfigArgs']]]]):
        pulumi.set(self, "kubeconfigs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional[pulumi.Input['KubernetesClusterOpenIdConnectConfigArgs']]:
        """
        The OpenID Connect configuration of the cluster
        """
        return pulumi.get(self, "open_id_connect_config")

    @open_id_connect_config.setter
    def open_id_connect_config(self, value: Optional[pulumi.Input['KubernetesClusterOpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_config", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the cluster is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the cluster is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region in which the cluster should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Kubernetes cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Kubernetes cluster. Possible values are: `kapsule` or `multicloud`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The last update date of the cluster.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` if a newer Kubernetes version is available.
        """
        return pulumi.get(self, "upgrade_available")

    @upgrade_available.setter
    def upgrade_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_available", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Kubernetes cluster.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="wildcardDns")
    def wildcard_dns(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS wildcard that points to all ready nodes.
        - `kubeconfig`
        """
        return pulumi.get(self, "wildcard_dns")

    @wildcard_dns.setter
    def wildcard_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wildcard_dns", value)


class KubernetesCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_upgrade: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterAutoUpgradeArgs']]] = None,
                 autoscaler_config: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterAutoscalerConfigArgs']]] = None,
                 cni: Optional[pulumi.Input[str]] = None,
                 delete_additional_resources: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_id_connect_config: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterOpenIdConnectConfigArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Kubernetes clusters can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/kubernetesCluster:KubernetesCluster mycluster fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admission_plugins: The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apiserver_cert_sans: Additional Subject Alternative Names for the Kubernetes API server certificate
        :param pulumi.Input[pulumi.InputType['KubernetesClusterAutoUpgradeArgs']] auto_upgrade: The auto upgrade configuration.
        :param pulumi.Input[pulumi.InputType['KubernetesClusterAutoscalerConfigArgs']] autoscaler_config: The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        :param pulumi.Input[str] cni: The Container Network Interface (CNI) for the Kubernetes cluster.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[bool] delete_additional_resources: Delete additional resources like block volumes and loadbalancers that were created in Kubernetes on cluster deletion.
        :param pulumi.Input[str] description: A description for the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] feature_gates: The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        :param pulumi.Input[str] name: The name for the Kubernetes cluster.
        :param pulumi.Input[pulumi.InputType['KubernetesClusterOpenIdConnectConfigArgs']] open_id_connect_config: The OpenID Connect configuration of the cluster
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the cluster is associated with.
        :param pulumi.Input[str] region: `region`) The region in which the cluster should be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Kubernetes cluster.
        :param pulumi.Input[str] type: The type of Kubernetes cluster. Possible values are: `kapsule` or `multicloud`.
        :param pulumi.Input[str] version: The version of the Kubernetes cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Kubernetes clusters can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/kubernetesCluster:KubernetesCluster mycluster fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_upgrade: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterAutoUpgradeArgs']]] = None,
                 autoscaler_config: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterAutoscalerConfigArgs']]] = None,
                 cni: Optional[pulumi.Input[str]] = None,
                 delete_additional_resources: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_id_connect_config: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterOpenIdConnectConfigArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesClusterArgs.__new__(KubernetesClusterArgs)

            __props__.__dict__["admission_plugins"] = admission_plugins
            __props__.__dict__["apiserver_cert_sans"] = apiserver_cert_sans
            __props__.__dict__["auto_upgrade"] = auto_upgrade
            __props__.__dict__["autoscaler_config"] = autoscaler_config
            if cni is None and not opts.urn:
                raise TypeError("Missing required property 'cni'")
            __props__.__dict__["cni"] = cni
            __props__.__dict__["delete_additional_resources"] = delete_additional_resources
            __props__.__dict__["description"] = description
            __props__.__dict__["feature_gates"] = feature_gates
            __props__.__dict__["name"] = name
            __props__.__dict__["open_id_connect_config"] = open_id_connect_config
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["apiserver_url"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["kubeconfigs"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["upgrade_available"] = None
            __props__.__dict__["wildcard_dns"] = None
        super(KubernetesCluster, __self__).__init__(
            'scaleway:index/kubernetesCluster:KubernetesCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            apiserver_url: Optional[pulumi.Input[str]] = None,
            auto_upgrade: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterAutoUpgradeArgs']]] = None,
            autoscaler_config: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterAutoscalerConfigArgs']]] = None,
            cni: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            delete_additional_resources: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            kubeconfigs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesClusterKubeconfigArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            open_id_connect_config: Optional[pulumi.Input[pulumi.InputType['KubernetesClusterOpenIdConnectConfigArgs']]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            upgrade_available: Optional[pulumi.Input[bool]] = None,
            version: Optional[pulumi.Input[str]] = None,
            wildcard_dns: Optional[pulumi.Input[str]] = None) -> 'KubernetesCluster':
        """
        Get an existing KubernetesCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admission_plugins: The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apiserver_cert_sans: Additional Subject Alternative Names for the Kubernetes API server certificate
        :param pulumi.Input[str] apiserver_url: The URL of the Kubernetes API server.
        :param pulumi.Input[pulumi.InputType['KubernetesClusterAutoUpgradeArgs']] auto_upgrade: The auto upgrade configuration.
        :param pulumi.Input[pulumi.InputType['KubernetesClusterAutoscalerConfigArgs']] autoscaler_config: The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        :param pulumi.Input[str] cni: The Container Network Interface (CNI) for the Kubernetes cluster.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] created_at: The creation date of the cluster.
        :param pulumi.Input[bool] delete_additional_resources: Delete additional resources like block volumes and loadbalancers that were created in Kubernetes on cluster deletion.
        :param pulumi.Input[str] description: A description for the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] feature_gates: The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubernetesClusterKubeconfigArgs']]]] kubeconfigs: The kubeconfig configuration file of the Kubernetes cluster
        :param pulumi.Input[str] name: The name for the Kubernetes cluster.
        :param pulumi.Input[pulumi.InputType['KubernetesClusterOpenIdConnectConfigArgs']] open_id_connect_config: The OpenID Connect configuration of the cluster
        :param pulumi.Input[str] organization_id: The organization ID the cluster is associated with.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the cluster is associated with.
        :param pulumi.Input[str] region: `region`) The region in which the cluster should be created.
        :param pulumi.Input[str] status: The status of the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Kubernetes cluster.
        :param pulumi.Input[str] type: The type of Kubernetes cluster. Possible values are: `kapsule` or `multicloud`.
        :param pulumi.Input[str] updated_at: The last update date of the cluster.
        :param pulumi.Input[bool] upgrade_available: Set to `true` if a newer Kubernetes version is available.
        :param pulumi.Input[str] version: The version of the Kubernetes cluster.
        :param pulumi.Input[str] wildcard_dns: The DNS wildcard that points to all ready nodes.
               - `kubeconfig`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesClusterState.__new__(_KubernetesClusterState)

        __props__.__dict__["admission_plugins"] = admission_plugins
        __props__.__dict__["apiserver_cert_sans"] = apiserver_cert_sans
        __props__.__dict__["apiserver_url"] = apiserver_url
        __props__.__dict__["auto_upgrade"] = auto_upgrade
        __props__.__dict__["autoscaler_config"] = autoscaler_config
        __props__.__dict__["cni"] = cni
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["delete_additional_resources"] = delete_additional_resources
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_gates"] = feature_gates
        __props__.__dict__["kubeconfigs"] = kubeconfigs
        __props__.__dict__["name"] = name
        __props__.__dict__["open_id_connect_config"] = open_id_connect_config
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["upgrade_available"] = upgrade_available
        __props__.__dict__["version"] = version
        __props__.__dict__["wildcard_dns"] = wildcard_dns
        return KubernetesCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="admissionPlugins")
    def admission_plugins(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        """
        return pulumi.get(self, "admission_plugins")

    @property
    @pulumi.getter(name="apiserverCertSans")
    def apiserver_cert_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Additional Subject Alternative Names for the Kubernetes API server certificate
        """
        return pulumi.get(self, "apiserver_cert_sans")

    @property
    @pulumi.getter(name="apiserverUrl")
    def apiserver_url(self) -> pulumi.Output[str]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "apiserver_url")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> pulumi.Output['outputs.KubernetesClusterAutoUpgrade']:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrade")

    @property
    @pulumi.getter(name="autoscalerConfig")
    def autoscaler_config(self) -> pulumi.Output['outputs.KubernetesClusterAutoscalerConfig']:
        """
        The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        """
        return pulumi.get(self, "autoscaler_config")

    @property
    @pulumi.getter
    def cni(self) -> pulumi.Output[str]:
        """
        The Container Network Interface (CNI) for the Kubernetes cluster.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "cni")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The creation date of the cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deleteAdditionalResources")
    def delete_additional_resources(self) -> pulumi.Output[Optional[bool]]:
        """
        Delete additional resources like block volumes and loadbalancers that were created in Kubernetes on cluster deletion.
        """
        return pulumi.get(self, "delete_additional_resources")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the Kubernetes cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        """
        return pulumi.get(self, "feature_gates")

    @property
    @pulumi.getter
    def kubeconfigs(self) -> pulumi.Output[Sequence['outputs.KubernetesClusterKubeconfig']]:
        """
        The kubeconfig configuration file of the Kubernetes cluster
        """
        return pulumi.get(self, "kubeconfigs")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> pulumi.Output['outputs.KubernetesClusterOpenIdConnectConfig']:
        """
        The OpenID Connect configuration of the cluster
        """
        return pulumi.get(self, "open_id_connect_config")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID the cluster is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the cluster is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        `region`) The region in which the cluster should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Kubernetes cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags associated with the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of Kubernetes cluster. Possible values are: `kapsule` or `multicloud`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The last update date of the cluster.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> pulumi.Output[bool]:
        """
        Set to `true` if a newer Kubernetes version is available.
        """
        return pulumi.get(self, "upgrade_available")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version of the Kubernetes cluster.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="wildcardDns")
    def wildcard_dns(self) -> pulumi.Output[str]:
        """
        The DNS wildcard that points to all ready nodes.
        - `kubeconfig`
        """
        return pulumi.get(self, "wildcard_dns")

