# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetIamApplicationResult',
    'AwaitableGetIamApplicationResult',
    'get_iam_application',
    'get_iam_application_output',
]

@pulumi.output_type
class GetIamApplicationResult:
    """
    A collection of values returned by getIamApplication.
    """
    def __init__(__self__, application_id=None, created_at=None, description=None, editable=None, id=None, name=None, organization_id=None, updated_at=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if editable and not isinstance(editable, bool):
            raise TypeError("Expected argument 'editable' to be a bool")
        pulumi.set(__self__, "editable", editable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def editable(self) -> bool:
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[str]:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        return pulumi.get(self, "updated_at")


class AwaitableGetIamApplicationResult(GetIamApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamApplicationResult(
            application_id=self.application_id,
            created_at=self.created_at,
            description=self.description,
            editable=self.editable,
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            updated_at=self.updated_at)


def get_iam_application(application_id: Optional[str] = None,
                        name: Optional[str] = None,
                        organization_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamApplicationResult:
    """
    Gets information about an existing IAM application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    find_by_name = scaleway.get_iam_application(name="foobar")
    find_by_id = scaleway.get_iam_application(application_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str application_id: The ID of the IAM application.
           Only one of the `name` and `application_id` should be specified.
    :param str name: The name of the IAM application.
           Only one of the `name` and `application_id` should be specified.
    :param str organization_id: `organization_id`) The ID of the
           organization the application is associated with.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['name'] = name
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getIamApplication:getIamApplication', __args__, opts=opts, typ=GetIamApplicationResult).value

    return AwaitableGetIamApplicationResult(
        application_id=__ret__.application_id,
        created_at=__ret__.created_at,
        description=__ret__.description,
        editable=__ret__.editable,
        id=__ret__.id,
        name=__ret__.name,
        organization_id=__ret__.organization_id,
        updated_at=__ret__.updated_at)


@_utilities.lift_output_func(get_iam_application)
def get_iam_application_output(application_id: Optional[pulumi.Input[Optional[str]]] = None,
                               name: Optional[pulumi.Input[Optional[str]]] = None,
                               organization_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIamApplicationResult]:
    """
    Gets information about an existing IAM application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    find_by_name = scaleway.get_iam_application(name="foobar")
    find_by_id = scaleway.get_iam_application(application_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str application_id: The ID of the IAM application.
           Only one of the `name` and `application_id` should be specified.
    :param str name: The name of the IAM application.
           Only one of the `name` and `application_id` should be specified.
    :param str organization_id: `organization_id`) The ID of the
           organization the application is associated with.
    """
    ...
