"""
Copyright (c) 2014, Samsung Electronics Co.,Ltd.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of Samsung Electronics Co.,Ltd..
"""

"""
cuda4py - CUDA cffi bindings and helper classes.
URL: https://github.com/ajkxyz/cuda4py
Original author: Alexey Kazantsev <a.kazantsev@samsung.com>
"""

"""
Init module for cuDNN cffi bindings and helper classes.
"""

from cuda4py._impl.cudnn._cffi import (
    initialize,

    CUDNN_STATUS_SUCCESS,
    CUDNN_STATUS_NOT_INITIALIZED,
    CUDNN_STATUS_ALLOC_FAILED,
    CUDNN_STATUS_BAD_PARAM,
    CUDNN_STATUS_INTERNAL_ERROR,
    CUDNN_STATUS_INVALID_VALUE,
    CUDNN_STATUS_ARCH_MISMATCH,
    CUDNN_STATUS_MAPPING_ERROR,
    CUDNN_STATUS_EXECUTION_FAILED,
    CUDNN_STATUS_NOT_SUPPORTED,
    CUDNN_STATUS_LICENSE_ERROR,

    CUDNN_DATA_FLOAT,
    CUDNN_DATA_DOUBLE,
    CUDNN_DATA_HALF,

    CUDNN_TENSOR_NCHW,
    CUDNN_TENSOR_NHWC,

    CUDNN_CONVOLUTION,
    CUDNN_CROSS_CORRELATION,

    CUDNN_CONVOLUTION_FWD_NO_WORKSPACE,
    CUDNN_CONVOLUTION_FWD_PREFER_FASTEST,
    CUDNN_CONVOLUTION_FWD_SPECIFY_WORKSPACE_LIMIT,

    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_GEMM,
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_PRECOMP_GEMM,
    CUDNN_CONVOLUTION_FWD_ALGO_GEMM,
    CUDNN_CONVOLUTION_FWD_ALGO_DIRECT,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT_TILING,

    CUDNN_CONVOLUTION_BWD_FILTER_NO_WORKSPACE,
    CUDNN_CONVOLUTION_BWD_FILTER_PREFER_FASTEST,
    CUDNN_CONVOLUTION_BWD_FILTER_SPECIFY_WORKSPACE_LIMIT,

    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_0,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_1,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_3,

    CUDNN_CONVOLUTION_BWD_DATA_NO_WORKSPACE,
    CUDNN_CONVOLUTION_BWD_DATA_PREFER_FASTEST,
    CUDNN_CONVOLUTION_BWD_DATA_SPECIFY_WORKSPACE_LIMIT,

    CUDNN_CONVOLUTION_BWD_DATA_ALGO_0,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_1,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT_TILING,

    CUDNN_POOLING_MAX,
    CUDNN_POOLING_AVERAGE_COUNT_INCLUDE_PADDING,
    CUDNN_POOLING_AVERAGE_COUNT_EXCLUDE_PADDING,

    CUDNN_NOT_PROPAGATE_NAN,
    CUDNN_PROPAGATE_NAN,

    CUDNN_RNN_RELU,
    CUDNN_RNN_TANH,
    CUDNN_LSTM,
    CUDNN_GRU,

    CUDNN_UNIDIRECTIONAL,
    CUDNN_BIDIRECTIONAL,

    CUDNN_LINEAR_INPUT,
    CUDNN_SKIP_INPUT)

from cuda4py._impl.cudnn._py import (
    CUDNN,
    TensorDescriptor,
    FilterDescriptor,
    ConvolutionDescriptor,
    PoolingDescriptor,
    DropoutDescriptor,
    RNNDescriptor)
