"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

# ### System parameter configuration
#
# A system parameter is a special kind of parameter defined by the API
# system, not by an individual API. It is typically mapped to an HTTP header
# and/or a URL query parameter. This configuration specifies which methods
# change the names of the system parameters.
class SystemParameters(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    RULES_FIELD_NUMBER: builtins.int
    # Define system parameters.
    #
    # The parameters defined here will override the default parameters
    # implemented by the system. If this field is missing from the service
    # config, default system parameters will be used. Default system parameters
    # and names is implementation-dependent.
    #
    # Example: define api key for all methods
    #
    #     system_parameters
    #       rules:
    #         - selector: "*"
    #           parameters:
    #             - name: api_key
    #               url_query_parameter: api_key
    #
    #
    # Example: define 2 api key names for a specific method.
    #
    #     system_parameters
    #       rules:
    #         - selector: "/ListShelves"
    #           parameters:
    #             - name: api_key
    #               http_header: Api-Key1
    #             - name: api_key
    #               http_header: Api-Key2
    #
    # **NOTE:** All service configuration rules follow "last one wins" order.
    @property
    def rules(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SystemParameterRule
    ]: ...
    def __init__(
        self,
        *,
        rules: typing.Optional[typing.Iterable[global___SystemParameterRule]] = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["rules", b"rules"]
    ) -> None: ...

global___SystemParameters = SystemParameters

# Define a system parameter rule mapping system parameter definitions to
# methods.
class SystemParameterRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    SELECTOR_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    # Selects the methods to which this rule applies. Use '*' to indicate all
    # methods in all APIs.
    #
    # Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
    selector: typing.Text = ...
    # Define parameters. Multiple names may be defined for a parameter.
    # For a given method call, only one of them should be used. If multiple
    # names are used the behavior is implementation-dependent.
    # If none of the specified names are present the behavior is
    # parameter-dependent.
    @property
    def parameters(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SystemParameter
    ]: ...
    def __init__(
        self,
        *,
        selector: typing.Text = ...,
        parameters: typing.Optional[typing.Iterable[global___SystemParameter]] = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "parameters", b"parameters", "selector", b"selector"
        ],
    ) -> None: ...

global___SystemParameterRule = SystemParameterRule

# Define a parameter's name and location. The parameter may be passed as either
# an HTTP header or a URL query parameter, and if both are passed the behavior
# is implementation-dependent.
class SystemParameter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    HTTP_HEADER_FIELD_NUMBER: builtins.int
    URL_QUERY_PARAMETER_FIELD_NUMBER: builtins.int
    # Define the name of the parameter, such as "api_key" . It is case sensitive.
    name: typing.Text = ...
    # Define the HTTP header name to use for the parameter. It is case
    # insensitive.
    http_header: typing.Text = ...
    # Define the URL query parameter name to use for the parameter. It is case
    # sensitive.
    url_query_parameter: typing.Text = ...
    def __init__(
        self,
        *,
        name: typing.Text = ...,
        http_header: typing.Text = ...,
        url_query_parameter: typing.Text = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "http_header",
            b"http_header",
            "name",
            b"name",
            "url_query_parameter",
            b"url_query_parameter",
        ],
    ) -> None: ...

global___SystemParameter = SystemParameter
