from typing import Any
from dataclasses import field, dataclass

from _typeshed import Incomplete
from ataraxis_data_structures import YamlConfig

@dataclass
class Main:
    """Stores global settings used to broadly define the suite2p processing configuration."""

    nplanes: int = ...
    nchannels: int = ...
    functional_chan: int = ...
    tau: float = ...
    force_sktiff: bool = ...
    fs: float = ...
    do_bidiphase: bool = ...
    bidiphase: int = ...
    bidi_corrected: bool = ...
    frames_include: int = ...
    multiplane_parallel: bool = ...
    ignore_flyback: list[int] = field(default_factory=list)

@dataclass
class FileIO:
    """Stores I/O settings used to specify input data file locations, formats, and output storage options."""

    fast_disk: list[str] = field(default_factory=list)
    delete_bin: bool = ...
    mesoscan: bool = ...
    bruker: bool = ...
    bruker_bidirectional: bool = ...
    h5py: list[str] = field(default_factory=list)
    h5py_key: str = ...
    nwb_file: str = ...
    nwb_driver: str = ...
    nwb_series: str = ...
    save_path0: list[str] = field(default_factory=list)
    save_folder: list[str] = field(default_factory=list)
    look_one_level_down: bool = ...
    subfolders: list[str] = field(default_factory=list)
    move_bin: bool = ...

@dataclass
class Output:
    """Stores I/O settings used to define the output format and organization of the processing results."""

    preclassify: float = ...
    save_nwb: bool = ...
    save_mat: bool = ...
    combined: bool = ...
    aspect: float = ...
    report_time: bool = ...

@dataclass
class Registration:
    """Stores rigid registration settings used for correcting motion artifacts between frames."""

    do_registration: bool = ...
    align_by_chan: int = ...
    nimg_init: int = ...
    batch_size: int = ...
    maxregshift: float = ...
    smooth_sigma: float = ...
    smooth_sigma_time: float = ...
    keep_movie_raw: bool = ...
    two_step_registration: bool = ...
    reg_tif: bool = ...
    reg_tif_chan2: bool = ...
    subpixel: int = ...
    th_badframes: float = ...
    norm_frames: bool = ...
    force_refImg: bool = ...
    pad_fft: bool = ...

@dataclass
class OnePRegistration:
    """Stores additional pre-registration processing settings used to improve the registration of 1-photon datasets."""

    one_p_reg: bool = ...
    spatial_hp_reg: int = ...
    pre_smooth: float = ...
    spatial_taper: float = ...

@dataclass
class NonRigid:
    """Stores non-rigid registration settings used to improve motion registration in complex datasets."""

    nonrigid: bool = ...
    block_size: list[int] = field(default_factory=Incomplete)
    snr_thresh: float = ...
    maxregshiftNR: float = ...

@dataclass
class ROIDetection:
    """Stores ROI detection and extraction settings used to identify cells and their activity signals."""

    roidetect: bool = ...
    sparse_mode: bool = ...
    spatial_scale: int = ...
    connected: bool = ...
    threshold_scaling: float = ...
    spatial_hp_detect: int = ...
    max_overlap: float = ...
    high_pass: int = ...
    smooth_masks: bool = ...
    max_iterations: int = ...
    nbinned: int = ...
    denoise: bool = ...

@dataclass
class CellposeDetection:
    """Stores Cellpose algorithm settings used for cell detection."""

    anatomical_only: int = ...
    diameter: int = ...
    cellprob_threshold: float = ...
    flow_threshold: float = ...
    spatial_hp_cp: int = ...
    pretrained_model: str = ...

@dataclass
class SignalExtraction:
    """Stores settings used to extract fluorescence signals from ROIs and surrounding neuropil regions."""

    neuropil_extract: bool = ...
    allow_overlap: bool = ...
    min_neuropil_pixels: int = ...
    inner_neuropil_radius: int = ...
    lam_percentile: int = ...

@dataclass
class SpikeDeconvolution:
    """Stores settings used to deconvolve calcium signals to infer spike trains."""

    spikedetect: bool = ...
    neucoeff: float = ...
    baseline: str = ...
    win_baseline: float = ...
    sig_baseline: float = ...
    prctile_baseline: float = ...

@dataclass
class Classification:
    """Stores settings used to classify detected ROIs as real cells or artifacts."""

    soma_crop: bool = ...
    use_builtin_classifier: bool = ...
    classifier_path: str = ...

@dataclass
class Channel2:
    """Stores settings for processing the second channel in multichannel datasets."""

    chan2_thres: float = ...

@dataclass
class Suite2PConfiguration(YamlConfig):
    """Stores the user-addressable suite2p configuration parameters, organized into subsections.

    This class is used during processing to instruct suite2p on how to process the data. Specifically, it provides a
    user-friendly way of specifying all user-addressable parameters through a .YAML file. The sl-forgery library then
    loads the data from .yaml file and uses it to configure the single-day suite2p pipeline and the multiday suite2p
    pipeline.

    Notes:
        The .YAML file uses section names that match the suite2p documentation sections. This way, users can always
        consult the suite2p documentation for information on the purpose of each field inside every subsection.
    """

    main: Main = field(default_factory=Main)
    file_io: FileIO = field(default_factory=FileIO)
    output: Output = field(default_factory=Output)
    registration: Registration = field(default_factory=Registration)
    one_p_registration: OnePRegistration = field(default_factory=OnePRegistration)
    non_rigid: NonRigid = field(default_factory=NonRigid)
    roi_detection: ROIDetection = field(default_factory=ROIDetection)
    cellpose_detection: CellposeDetection = field(default_factory=CellposeDetection)
    signal_extraction: SignalExtraction = field(default_factory=SignalExtraction)
    spike_deconvolution: SpikeDeconvolution = field(default_factory=SpikeDeconvolution)
    classification: Classification = field(default_factory=Classification)
    channel2: Channel2 = field(default_factory=Channel2)
    def to_ops(self) -> dict[str, Any]:
        """Converts the class instance to a dictionary and returns it to caller.

        This dictionary can be passed to suite2p functions either as an 'ops' or 'db' argument to control the
        processing runtime.
        """
