#!/usr/bin/env python
#coding:utf-8
# Author:  mozman <me@mozman.at>
# Purpose: test pretty_xml function
# Created: 28.01.2017
# Copyright (C) 2017, Manfred Moitzi
# License: MIT License
from __future__ import unicode_literals
import unittest

import svgwrite
from svgwrite.utils import pretty_xml, PYTHON3


class TestPrettyXML(unittest.TestCase):
    def test_pretty_print(self):
        result = pretty_xml(XML_UGLY).split('\n')
        expect = XML_PRETTY.split('\n')
        # skip svg tag, order of attributes changes often by new Python releases
        for e, r in zip(expect[1:], result[1:]):
            self.assertEqual(e, r)

    def test_empty_string(self):
        result = pretty_xml("")
        self.assertEqual("", result)

    def test_unicode_compatibility(self):
        if PYTHON3:
            return
        dwg = svgwrite.Drawing()
        dwg.add(dwg.text("•••", insert=(0, 0)))
        result = pretty_xml(dwg.tostring())
        self.assertTrue(type(result) is unicode)


if __name__ == '__main__':
    unittest.main()

XML_UGLY = '<svg baseProfile="full" height="100%" version="1.1" viewBox="0,0,10000,10000" width="100%" xmlns="http://www.w3.org/2000/svg" xmlns:ev="http://www.w3.org/2001/xml-events" xmlns:xlink="http://www.w3.org/1999/xlink"><defs /><polyline fill="blue" points="2228.427,1643.919 2419.889,1643.919 2419.889,1814.927 2431.918,1985.935 2216.397,1985.935 2228.427,1814.927 2228.427,1643.919" stroke="black" /><polyline fill="blue" points="1719.842,2889.033 2073.565,2860.088 2116.739,2773.534 2194.085,2773.534 2194.085,2863.16 2250.427,2863.16 2250.427,3015.934 2180.055,3016.029 2180.055,3105.559 2109.683,3105.559 2040.089,3027.02 1719.842,3019.005 1719.842,2889.033" stroke="black" /><polyline fill="blue" points="2445.051,2773.104 2515.6,2773.104 2523.615,2824.983 2562.791,2863.738 2685.528,2884.683 3229.118,2914.01 3229.118,3019.005 2685.528,3026.946 2562.791,3031.623 2502.958,3038.419 2474.287,3105.559 2431.117,3105.559 2428.09,3021.427 2367.664,3021.365 2368.777,2857.687 2428.09,2857.666 2445.051,2773.104" stroke="black" /><polyline fill="blue" points="2121.799,3217.149 2161.781,3217.149 2161.781,3270.925 2170.281,3373.523 2136.298,3376.256 2121.799,3270.925 2121.799,3217.149" stroke="black" /><polyline fill="blue" points="2185.779,2131.879 2228.573,2138.657 2210.925,2282.81 2154.21,2273.827 2185.779,2131.879" stroke="black" /><polyline fill="blue" points="2467.374,3270.301 2455.239,3380.058 2421.384,3379.643 2427.392,3294.58 2427.392,3216.538 2467.325,3217.933 2467.374,3270.301" stroke="black" /><polyline fill="blue" points="2413.422,2165.617 2449.272,2159.547 2451.045,2170.021 2476.259,2258.082 2479.974,2280.378 2424.208,2289.82 2420.491,2267.511 2415.196,2176.091 2413.422,2165.617" stroke="black" /><polyline fill="blue" points="8916.08,2228.427 8916.08,2419.889 8745.072,2419.889 8574.065,2431.918 8574.065,2216.397 8745.072,2228.427 8916.08,2228.427" stroke="black" /><polyline fill="blue" points="7670.967,1719.842 7699.912,2073.565 7786.466,2116.739 7786.466,2194.085 7696.84,2194.085 7696.84,2250.427 7544.066,2250.427 7543.971,2180.055 7454.44,2180.055 7454.44,2109.683 7532.98,2040.089 7540.995,1719.842 7670.967,1719.842" stroke="black" /><polyline fill="blue" points="7786.896,2445.051 7786.896,2515.6 7735.017,2523.615 7696.262,2562.791 7675.317,2685.528 7645.99,3229.118 7540.995,3229.118 7533.054,2685.528 7528.377,2562.791 7521.581,2502.958 7454.44,2474.287 7454.44,2431.117 7538.572,2428.09 7538.635,2367.664 7702.313,2368.777 7702.334,2428.09 7786.896,2445.051" stroke="black" /><polyline fill="blue" points="7342.851,2121.799 7342.851,2161.781 7289.075,2161.781 7186.477,2170.281 7183.744,2136.298 7289.075,2121.799 7342.851,2121.799" stroke="black" /><polyline fill="blue" points="8428.121,2185.779 8421.344,2228.573 8277.189,2210.925 8286.173,2154.21 8428.121,2185.779" stroke="black" /><polyline fill="blue" points="7289.699,2467.374 7179.942,2455.239 7180.357,2421.384 7265.42,2427.392 7343.462,2427.392 7342.067,2467.325 7289.699,2467.374" stroke="black" /><polyline fill="blue" points="8394.383,2413.422 8400.453,2449.272 8389.979,2451.045 8301.918,2476.259 8279.622,2479.974 8270.18,2424.208 8292.489,2420.491 8383.909,2415.196 8394.383,2413.422" stroke="black" /><polyline fill="blue" points="2229.842,797.843 2390.158,797.843 2400.23,1140.2 2219.77,1140.2 2229.842,797.843" stroke="black" /><polyline fill="blue" points="329.632,2875.177 820.733,2875.204 820.733,3064.851 329.632,3064.823 329.632,2875.177" stroke="black" /><polyline fill="blue" points="3836.175,3032.655 3344.688,3032.673 3344.688,2907.352 3836.175,2907.334 3836.175,3032.655" stroke="black" /><polyline fill="blue" points="9762.156,2229.842 9762.156,2390.158 9419.801,2400.23 9419.801,2219.77 9762.156,2229.842" stroke="black" /><polyline fill="blue" points="7684.823,329.632 7684.796,820.733 7495.149,820.733 7495.177,329.632 7684.823,329.632" stroke="black" /><polyline fill="blue" points="7527.345,3836.175 7527.327,3344.688 7652.648,3344.688 7652.666,3836.175 7527.345,3836.175" stroke="black" /><polyline fill="blue" points="7527.345,3836.175 7527.327,3344.688 7652.648,3344.688 7652.666,3836.175 7527.345,3836.175" stroke="black" /></svg>'

XML_PRETTY = """<svg baseProfile="full" height="100%" version="1.1" viewBox="0,0,10000,10000" width="100%" xmlns="http://www.w3.org/2000/svg" xmlns:ev="http://www.w3.org/2001/xml-events" xmlns:xlink="http://www.w3.org/1999/xlink">
  <defs/>
  <polyline fill="blue" points="2228.427,1643.919 2419.889,1643.919 2419.889,1814.927 2431.918,1985.935 2216.397,1985.935 2228.427,1814.927 2228.427,1643.919" stroke="black"/>
  <polyline fill="blue" points="1719.842,2889.033 2073.565,2860.088 2116.739,2773.534 2194.085,2773.534 2194.085,2863.16 2250.427,2863.16 2250.427,3015.934 2180.055,3016.029 2180.055,3105.559 2109.683,3105.559 2040.089,3027.02 1719.842,3019.005 1719.842,2889.033" stroke="black"/>
  <polyline fill="blue" points="2445.051,2773.104 2515.6,2773.104 2523.615,2824.983 2562.791,2863.738 2685.528,2884.683 3229.118,2914.01 3229.118,3019.005 2685.528,3026.946 2562.791,3031.623 2502.958,3038.419 2474.287,3105.559 2431.117,3105.559 2428.09,3021.427 2367.664,3021.365 2368.777,2857.687 2428.09,2857.666 2445.051,2773.104" stroke="black"/>
  <polyline fill="blue" points="2121.799,3217.149 2161.781,3217.149 2161.781,3270.925 2170.281,3373.523 2136.298,3376.256 2121.799,3270.925 2121.799,3217.149" stroke="black"/>
  <polyline fill="blue" points="2185.779,2131.879 2228.573,2138.657 2210.925,2282.81 2154.21,2273.827 2185.779,2131.879" stroke="black"/>
  <polyline fill="blue" points="2467.374,3270.301 2455.239,3380.058 2421.384,3379.643 2427.392,3294.58 2427.392,3216.538 2467.325,3217.933 2467.374,3270.301" stroke="black"/>
  <polyline fill="blue" points="2413.422,2165.617 2449.272,2159.547 2451.045,2170.021 2476.259,2258.082 2479.974,2280.378 2424.208,2289.82 2420.491,2267.511 2415.196,2176.091 2413.422,2165.617" stroke="black"/>
  <polyline fill="blue" points="8916.08,2228.427 8916.08,2419.889 8745.072,2419.889 8574.065,2431.918 8574.065,2216.397 8745.072,2228.427 8916.08,2228.427" stroke="black"/>
  <polyline fill="blue" points="7670.967,1719.842 7699.912,2073.565 7786.466,2116.739 7786.466,2194.085 7696.84,2194.085 7696.84,2250.427 7544.066,2250.427 7543.971,2180.055 7454.44,2180.055 7454.44,2109.683 7532.98,2040.089 7540.995,1719.842 7670.967,1719.842" stroke="black"/>
  <polyline fill="blue" points="7786.896,2445.051 7786.896,2515.6 7735.017,2523.615 7696.262,2562.791 7675.317,2685.528 7645.99,3229.118 7540.995,3229.118 7533.054,2685.528 7528.377,2562.791 7521.581,2502.958 7454.44,2474.287 7454.44,2431.117 7538.572,2428.09 7538.635,2367.664 7702.313,2368.777 7702.334,2428.09 7786.896,2445.051" stroke="black"/>
  <polyline fill="blue" points="7342.851,2121.799 7342.851,2161.781 7289.075,2161.781 7186.477,2170.281 7183.744,2136.298 7289.075,2121.799 7342.851,2121.799" stroke="black"/>
  <polyline fill="blue" points="8428.121,2185.779 8421.344,2228.573 8277.189,2210.925 8286.173,2154.21 8428.121,2185.779" stroke="black"/>
  <polyline fill="blue" points="7289.699,2467.374 7179.942,2455.239 7180.357,2421.384 7265.42,2427.392 7343.462,2427.392 7342.067,2467.325 7289.699,2467.374" stroke="black"/>
  <polyline fill="blue" points="8394.383,2413.422 8400.453,2449.272 8389.979,2451.045 8301.918,2476.259 8279.622,2479.974 8270.18,2424.208 8292.489,2420.491 8383.909,2415.196 8394.383,2413.422" stroke="black"/>
  <polyline fill="blue" points="2229.842,797.843 2390.158,797.843 2400.23,1140.2 2219.77,1140.2 2229.842,797.843" stroke="black"/>
  <polyline fill="blue" points="329.632,2875.177 820.733,2875.204 820.733,3064.851 329.632,3064.823 329.632,2875.177" stroke="black"/>
  <polyline fill="blue" points="3836.175,3032.655 3344.688,3032.673 3344.688,2907.352 3836.175,2907.334 3836.175,3032.655" stroke="black"/>
  <polyline fill="blue" points="9762.156,2229.842 9762.156,2390.158 9419.801,2400.23 9419.801,2219.77 9762.156,2229.842" stroke="black"/>
  <polyline fill="blue" points="7684.823,329.632 7684.796,820.733 7495.149,820.733 7495.177,329.632 7684.823,329.632" stroke="black"/>
  <polyline fill="blue" points="7527.345,3836.175 7527.327,3344.688 7652.648,3344.688 7652.666,3836.175 7527.345,3836.175" stroke="black"/>
  <polyline fill="blue" points="7527.345,3836.175 7527.327,3344.688 7652.648,3344.688 7652.666,3836.175 7527.345,3836.175" stroke="black"/>
</svg>
"""