<h1>Table of Contets</h1>
<ul>
    <li><a href="#sixauth">sixauth</a></li>
    <ul>
        <li><a href="#insallation">Installation</a></li>
        <li><a href="#usage">Usage</a></li>
        <ul>
            <li><a href="#instance">Instancing</a></li>
            <ul>
                <li><a href="#context">With Context Manager</a></li>
                <li><a href="#nocontext">Without Context Manager</a></li>
            </ul>
            <li><a href="#connection">Remote or Local Connections</a></li>
            <ul>
                <li><a href="#cwd">Current Working Directory</a></li>
                <li><a href="#local">Local Folder</a></li>
                <li><a href="#server">Servers</a></li>
            </ul>
            <li><a href="#setvals">Setting Values</a></li>
            <li><a href="#signup">Signing Up</a></li>
            <li><a href="#login">Logging In</a></li>
            <li><a href="#save">Saving Data</a></li>
            <li><a href="#load">Loading Data</a></li>
            <li><a href="#delete">Deleting Data</a></li>
            <li><a href="#remove">Removing User</a></li>
        </ul>
        <li><a href="#exception">Exceptions</a></li>
    </ul>
    <li><a href="#sixauthauthmain">sixauth.main</a></li>
    <ul>
        <li><a href="#hostserver">Hosting a Server</a></li>
    </ul>
    <li><a href="#license">License and Disclaimer</a></li>
    <li><a href="#authors">Authors</a></li>
</ul>

<h1 id="sixauth">sixauth</h1>
<p dir="auto"><a href="https://github.com/maxwellewxam/sixauth/">sixauth</a> is a collection of tools for user authentication and data management. The library is released under the MIT License and the documentation is generated by an AI trained by OpenAI.</p>
<p>The <code>sixauth</code> module provides a simple way to handle user authentication and data storage on a remote server or your local machine. The <code>AuthSesh</code> class allows you to sign up, log in, and manage their data in the database. For more details and examples, see the <a href="https://github.com/maxwellewxam/sixauth/blob/main/sixauth/auth/auth.py" target="_new">AuthSesh class documentation</a>.</p>
<h2 id="insallation">Installation</h2>
<p>You can install sixauth using Python's built-in package manager:</p>
<div class="snippet-clipboard-content notranslate position-relative overflow-auto"><pre lang="terminal" class="notranslate"><code>$ pip install sixauth</code></pre>
<p> Or by downloading this repo and moving the <a href="https://github.com/maxwellewxam/sixauth/tree/main/sixauth">sixauth folder</a> where its needed.</p>
<h2 id="usage">Usage</h2>
<h3 id="instance">Instancing</h3>
<p>To use the <code>AuthSesh</code> class, you first need to create an instance of the class. There are two ways to do this, with a context manager or without.</p>
<h4 id="context"> With Context Manager</h4>
<p>The <code>AuthSesh</code> class can be used as a context manager:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python"><span class="hljs-keyword">from</span> sixauth <span class="hljs-keyword">import</span> <span class="hljs-class">AuthSesh</span>
<span class="hljs-keyword">with</span> <span class="hljs-class">AuthSesh</span>() <span class="hljs-keyword">as</span> auth:
</span><span class="hljs-comment">    # ...</span></code></div></div></pre>
<p>This will automatically log out and terminate the session when the context ends.</p>
<h4 id="nocontext">Without Context Manager</h4>
<p>The <code>AuthSesh</code> class can also be used without a context manager:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python"><span class="hljs-keyword">from</span> sixauth <span class="hljs-keyword">import</span> <span class="hljs-class">AuthSesh</span>
auth = <span class="hljs-class">AuthSesh</span>()
<span class="hljs-comment"># ...</span></code></div></div></pre>
<p>When you are done with the instance, you have to use the <code>terminate()</code> method to save your work and properly close connections:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.terminate()</code></div></div></pre>
<p>IMPORTANT: If you do not do this, nothing you do will save.</p>
<h3 id="connection">Remote or Local Connections</h3>
<p>When creating a <code>AuthSesh</code> instance there are a few options for where the instance will connect to. You can only pick from one of these, if you provide an address and a path, it will connect to the server and disreguard the path given.</p>
<h4 id="cwd">Current Working Directory</h4>
<p>The simplest is connecting to a database in the current working directory of your script:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python"><span class="hljs-class">AuthSesh</span>()</code></div></div></pre>
<p>This will create a database.db file in the current working directory if one is not already there.</p>
<h4 id="local">Local Folder</h4>
<p>Next is connecting to a database in a path specified as a paramater:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python"><span class="hljs-class">AuthSesh</span>(Path=<span class="hljs-string">"pathto/database/folder"</span>)</code></div></div></pre>
<p>This will create a database.db file in the specified path if one is not already there, it will not make the folder if it doesnt exsist though.</p>
<h4 id="server">Servers</h4>
<p>Lastly, connecting to a remote server:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python"><span class="hljs-class">AuthSesh</span>(Address=<span class="hljs-string">"0.0.0.0:5678"</span>)</code></div></div></pre>
<p>This will establish a secure connection to the remote server provided. If you want to host a server look at <a href="#hostserver">Hosting a Server</a>.</p>
<h3 id="setvals">Setting Values</h3>
<p>In order to authenticate a user we need their name and password. You do that with the <code>set_vals()</code> method:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.set_vals(<span class="hljs-string">"username"</span>, <span class="hljs-string">"password"</span>)</code></div></div></pre>
<p>You can call this method at anytime to change the user. However if <code>login()</code> is not called before attempting to manage data, it will still be connected to the previous user.</p>
<h3 id="signup">Signing Up</h3>
<p>Once a username and password are set, you use the <code>signup()</code> method to sign up:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.signup()
</code></div></div></pre>
<p>If the signup is successful, you then have to login to actually manage user data.</p>
<h3 id="login">Logging In</h3>
<p>Once you're ready to login, you can use the <code>login()</code> method to log in to the server:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.login()
</code></div></div></pre>
<p>If the login is successful, you can start managing the database.</p>
<h3 id="save">Saving Data</h3>
<p>After you've seccessfully logged in, you use the <code>save()</code> mathod to save data into the database:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.save(<span class="hljs-string">"user_data/profile"</span>, {<span class="hljs-string">"name"</span>: <span class="hljs-string">"John Doe"</span>, <span class="hljs-string">"email"</span>: <span class="hljs-string">"johndoe@example.com"</span>})</code></div></div></pre>
<p>Data in the database is stored in a dictonary and is parsed using the <a href="https://github.com/h2non/jsonpath-ng" target="_new">jsonpath-ng</a> module. The location provided goes through a filter and converts numbers to their alphebetical counter-parts.</p>
<h3 id="load">Loading Data</h3>
<p>You access data in the database with the <code>load()</code> method:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">data = auth.load(<span class="hljs-string">"user_data/profile"</span>)</code></div></div></pre>
<p>This will will return the data in the specified location, if no location is provided, it will return the whole dictionary.</p>
<h3 id="delete">Deleting Data</h3>
<p>To delete data in the database, you use the <code>delete()</code> method:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.delete(<span class="hljs-string">"user_data/profile"</span>)</code></div></div></pre>
<h3 id="remove">Removing User</h3>
<p>Finally, if you'd like to delete the user from the database, you use the <code>remove()</code> method:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.remove()</code></div></div></pre>
<h2 id="exception">Exceptions</h2>
<p>The <code>AuthSesh</code> class raises the following exceptions:</p>
<ul><li><code>AuthenticationError</code>: Raised if there is an error authenticating the user.</li><li><code>DataError</code>: Raised if there is an error accessing or modifying the data on the server.</li><li><code>LocationError</code>: Raised if the specified location does not exist on the server.</li><li><code>PasswordError</code>: Raised if the password is incorrect or invalid.</li><li><code>UsernameError</code>: Raised if the username is invalid or already in use.</li></ul>

<h1 id="sixauthauthmain">sixauth.main</h1>
<p>The <code>sixauth.main</code> module provides all of the functionallity of the <code>sixauth</code> module, and then some. The <code>AuthSesh</code> class is basically just a wrapper for all the functions in this module. If you wish to use any of the raw functions in this module, it is recomended that you already have a very strong understanding of authentication, databases, and all the jazz. I tried my best to explain what happens in the comments of each of the functions, you can read them <a href="https://github.com/maxwellewxam/sixauth/blob/main/sixauth/auth/main.py">here</a>.</p>
<h2 id="hostserver">Hosting a Server</h2>
<p>This module provides a very basic python server for <code>AuthSesh</code> instances to connect to. You can start it with the <code>server()</code> function:</p>
<pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python"><span class="hljs-keyword">from</span> sixauth.main <span class="hljs-keyword">import</span> server
server(<span class="hljs-string">"0.0.0.0"</span>, 5678)</code></div></div></pre>
<p>This will start a server in the console on port <code>5678</code> and will look for all incoming ip addresses. There are also a few keyword debug booleans, <code>debug</code> and <code>log_senseitive_info</code>. The keyword option, <code>cache_threshold</code>, sets how long, in seconds, a user has to be inactive on the server before their cache position is deleted.</p>

<h1 id="license">License and Disclaimer</h1>
<p dir="auto">The <a href="https://github.com/maxwellewxam/sixauth/">sixauth</a> library is licensed under the MIT License, which means it is free to use and distribute for both personal and commercial purposes. The documentation for the library has been generated by an AI trained by OpenAI, and may not be entirely accurate or up-to-date. It is recommended to consult the source code of the library for the most accurate information.</p>

<h1 id="authors">Authors</h1>
<ul dir="auto">
<li><a href="https://www.github.com/maxwellewxam">@maxwellewxam</a></li>
<li><a href="https://www.github.com/3008362">@3008362</a></li>
