"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnSleep = exports.toJson_CfnSleepProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnSleepProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnSleepProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Seconds': obj.seconds,
        'SleepOnCreate': obj.sleepOnCreate,
        'SleepOnUpdate': obj.sleepOnUpdate,
        'SleepOnDelete': obj.sleepOnDelete,
        'Triggers': obj.triggers?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnSleepProps = toJson_CfnSleepProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `AwsCommunity::Time::Sleep`
 *
 * @cloudformationResource AwsCommunity::Time::Sleep
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
class CfnSleep extends cdk.CfnResource {
    /**
     * Create a new `AwsCommunity::Time::Sleep`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnSleep.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnSleepProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
    }
}
exports.CfnSleep = CfnSleep;
_a = JSII_RTTI_SYMBOL_1;
CfnSleep[_a] = { fqn: "@cdk-cloudformation/awscommunity-time-sleep.CfnSleep", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnSleep.CFN_RESOURCE_TYPE_NAME = "AwsCommunity::Time::Sleep";
//# sourceMappingURL=data:application/json;base64,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