import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * An example resource schema demonstrating some basic constructs and validation rules.
 *
 * @schema CfnSleepProps
 */
export interface CfnSleepProps {
    /**
     * The number of seconds to sleep for.
     *
     * @schema CfnSleepProps#Seconds
     */
    readonly seconds: number;
    /**
     * If we should sleep on a create.
     *
     * @schema CfnSleepProps#SleepOnCreate
     */
    readonly sleepOnCreate?: boolean;
    /**
     * If we should sleep on an update.
     *
     * @schema CfnSleepProps#SleepOnUpdate
     */
    readonly sleepOnUpdate?: boolean;
    /**
     * If we should sleep on a delete.
     *
     * @schema CfnSleepProps#SleepOnDelete
     */
    readonly sleepOnDelete?: boolean;
    /**
     * A value to represent when a sleep should occur. Any time this is updated this resource will sleep.
     *
     * @schema CfnSleepProps#Triggers
     */
    readonly triggers?: string[];
}
/**
 * Converts an object of type 'CfnSleepProps' to JSON representation.
 */
export declare function toJson_CfnSleepProps(obj: CfnSleepProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AwsCommunity::Time::Sleep`
 *
 * @cloudformationResource AwsCommunity::Time::Sleep
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
export declare class CfnSleep extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "AwsCommunity::Time::Sleep";
    /**
     * Resource props.
     */
    readonly props: CfnSleepProps;
    /**
     * Attribute `AwsCommunity::Time::Sleep.Id`
     * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
     */
    readonly attrId: string;
    /**
     * Create a new `AwsCommunity::Time::Sleep`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnSleepProps);
}
