# SchemaGen
Schema Gen is a simple CLI tool that generates Python GraphQL implementations(using Graphene) from a Graphql Schema file.

# Installation
```shell
pip install schemagen
```

# Usage
Here's the content of a sample input file(we will call it *test.graphql*)
```graphql
type User {
    id: ID!
    username: String
    first_name: String
    last_name: String
    full_name: String
    name: String
    name: String
}
```

Now let's use SchemaGen to generate python code from it.

As a CLI tool:
```shell
schemagen parse test.graphql -o test.py
```
As a Python Package:

```python
from schemagen import SchemaGen

gen = SchemaGen(
  input_file='test.graphql',
  output_file='test.py'
)

# parse input file
gen()
```

Output(*test.py*):
```python
# This file was generated by CodegenTool
from graphene import *

class User(ObjectType):
	id = Field(ID, required=True)
	username = Field(String)
	first_name = Field(String)
	last_name = Field(String)
	full_name = Field(String)
	name = Field(String)

```

# Notes
SchemaGen is currently in its first version so there are some things you need to know:
* GraphQL type declarations in your schema file **must be ordered**. 
  
  Because of the way Python and SchemaGen works, you cannot use a GraphQL type
  before declaring it. For example, the following graphql schema definition would be invalid because we are using the **Url** scalar in our **User** type before declaring it:
  ```graphql
    type User {
        id: ID!
        username: String
        avatar_url: Url
    }
  
    scalar Url    
  ```
  The correct version of the above code is:
    ```graphql
    scalar Url 
     
    type User {
        id: ID!
        username: String
        avatar_url: Url
    }
  ```

* Using a GraphQL SDL keyword as an object field name in your schema will throw an error.

  For example, doing this:
  ```graphql
  enum UserType {
    Example
  }
  
  type User{
    name: String
    type: UserType
  }
  ```
  will throw an error.
  
  Do this instead:
  ```graphql
  enum UserType {
    Example
  }
  
  type User{
    name: String
    user_type: UserType
  }
  ```
  
We plan to fix these issues in the future. Pull requests are welcome!
  


