# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.buildings = BuildingService(self)
        self.countrys = CountryService(self)
        self.districts = DistrictService(self)
        self.freebusys = FreebusyService(self)
        self.instances = InstanceService(self)
        self.rooms = RoomService(self)
        self.summarys = SummaryService(self)
        self.meeting_rooms = MeetingRoomService(self)
        



class BuildingService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def batch_get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> BuildingBatchGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return BuildingBatchGetReqCall(self, request_opts=request_opts)

    def batch_get_id(self, tenant_key=None, timeout=None):
        # type: (str, int) -> BuildingBatchGetIdReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return BuildingBatchGetIdReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (BuildingCreateReqBody, str, int) -> BuildingCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return BuildingCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, body, tenant_key=None, timeout=None):
        # type: (BuildingDeleteReqBody, str, int) -> BuildingDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return BuildingDeleteReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> BuildingListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return BuildingListReqCall(self, request_opts=request_opts)

    def update(self, body, tenant_key=None, timeout=None):
        # type: (BuildingUpdateReqBody, str, int) -> BuildingUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return BuildingUpdateReqCall(self, body, request_opts=request_opts)


class CountryService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> CountryListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return CountryListReqCall(self, request_opts=request_opts)


class DistrictService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> DistrictListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DistrictListReqCall(self, request_opts=request_opts)


class FreebusyService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def batch_get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> FreebusyBatchGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return FreebusyBatchGetReqCall(self, request_opts=request_opts)


class InstanceService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def reply(self, body, tenant_key=None, timeout=None):
        # type: (InstanceReplyReqBody, str, int) -> InstanceReplyReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return InstanceReplyReqCall(self, body, request_opts=request_opts)


class RoomService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def batch_get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> RoomBatchGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return RoomBatchGetReqCall(self, request_opts=request_opts)

    def batch_get_id(self, tenant_key=None, timeout=None):
        # type: (str, int) -> RoomBatchGetIdReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return RoomBatchGetIdReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (RoomCreateReqBody, str, int) -> RoomCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return RoomCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, body, tenant_key=None, timeout=None):
        # type: (RoomDeleteReqBody, str, int) -> RoomDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return RoomDeleteReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> RoomListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return RoomListReqCall(self, request_opts=request_opts)

    def update(self, body, tenant_key=None, timeout=None):
        # type: (RoomUpdateReqBody, str, int) -> RoomUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return RoomUpdateReqCall(self, body, request_opts=request_opts)


class SummaryService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def batch_get(self, body, tenant_key=None, timeout=None):
        # type: (SummaryBatchGetReqBody, str, int) -> SummaryBatchGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return SummaryBatchGetReqCall(self, body, request_opts=request_opts)


class MeetingRoomService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service



class BuildingBatchGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (BuildingService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_building_ids(self, building_ids):
        # type: (List[str]) -> BuildingBatchGetReqCall
        self.query_params['building_ids'] = building_ids
        return self

    def set_fields(self, fields):
        # type: (str) -> BuildingBatchGetReqCall
        self.query_params['fields'] = fields
        return self

    def do(self):
        # type: () -> APIResponse[Type[BuildingBatchGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/meeting_room/building/batch_get', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=BuildingBatchGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class BuildingBatchGetIdReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (BuildingService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_custom_building_ids(self, custom_building_ids):
        # type: (List[str]) -> BuildingBatchGetIdReqCall
        self.query_params['custom_building_ids'] = custom_building_ids
        return self

    def do(self):
        # type: () -> APIResponse[Type[BuildingBatchGetIdResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/meeting_room/building/batch_get_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=BuildingBatchGetIdResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class BuildingCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (BuildingService, BuildingCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[BuildingCreateResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/building/create', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=BuildingCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class BuildingDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (BuildingService, BuildingDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/building/delete', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class BuildingListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (BuildingService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_order_by(self, order_by):
        # type: (str) -> BuildingListReqCall
        self.query_params['order_by'] = order_by
        return self

    def set_fields(self, fields):
        # type: (str) -> BuildingListReqCall
        self.query_params['fields'] = fields
        return self

    def set_page_token(self, page_token):
        # type: (str) -> BuildingListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> BuildingListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> APIResponse[Type[BuildingListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/meeting_room/building/list', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=BuildingListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class BuildingUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (BuildingService, BuildingUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/building/update', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CountryListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CountryService, List[Any]) -> None

        self.service = service
        

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[CountryListResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/country/list', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=CountryListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DistrictListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DistrictService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_country_id(self, country_id):
        # type: (int) -> DistrictListReqCall
        self.query_params['country_id'] = country_id
        return self

    def do(self):
        # type: () -> APIResponse[Type[DistrictListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/meeting_room/district/list', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=DistrictListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FreebusyBatchGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FreebusyService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_room_ids(self, room_ids):
        # type: (List[str]) -> FreebusyBatchGetReqCall
        self.query_params['room_ids'] = room_ids
        return self

    def set_time_min(self, time_min):
        # type: (str) -> FreebusyBatchGetReqCall
        self.query_params['time_min'] = time_min
        return self

    def set_time_max(self, time_max):
        # type: (str) -> FreebusyBatchGetReqCall
        self.query_params['time_max'] = time_max
        return self

    def do(self):
        # type: () -> APIResponse[Type[FreebusyBatchGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/meeting_room/freebusy/batch_get', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=FreebusyBatchGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class InstanceReplyReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (InstanceService, InstanceReplyReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/instance/reply', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class RoomBatchGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (RoomService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_room_ids(self, room_ids):
        # type: (List[str]) -> RoomBatchGetReqCall
        self.query_params['room_ids'] = room_ids
        return self

    def set_fields(self, fields):
        # type: (str) -> RoomBatchGetReqCall
        self.query_params['fields'] = fields
        return self

    def do(self):
        # type: () -> APIResponse[Type[RoomBatchGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/meeting_room/room/batch_get', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=RoomBatchGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class RoomBatchGetIdReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (RoomService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_custom_room_ids(self, custom_room_ids):
        # type: (List[str]) -> RoomBatchGetIdReqCall
        self.query_params['custom_room_ids'] = custom_room_ids
        return self

    def do(self):
        # type: () -> APIResponse[Type[RoomBatchGetIdResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/meeting_room/room/batch_get_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=RoomBatchGetIdResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class RoomCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (RoomService, RoomCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[RoomCreateResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/room/create', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=RoomCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class RoomDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (RoomService, RoomDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/room/delete', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class RoomListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (RoomService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_building_id(self, building_id):
        # type: (str) -> RoomListReqCall
        self.query_params['building_id'] = building_id
        return self

    def set_order_by(self, order_by):
        # type: (str) -> RoomListReqCall
        self.query_params['order_by'] = order_by
        return self

    def set_fields(self, fields):
        # type: (str) -> RoomListReqCall
        self.query_params['fields'] = fields
        return self

    def set_page_token(self, page_token):
        # type: (str) -> RoomListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> RoomListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> APIResponse[Type[RoomListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/meeting_room/room/list', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=RoomListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class RoomUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (RoomService, RoomUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/room/update', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SummaryBatchGetReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SummaryService, SummaryBatchGetReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[SummaryBatchGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/meeting_room/summary/batch_get', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=SummaryBatchGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

