# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import List, Dict, Any
from ....utils.dt import to_json_decorator
from ....event.model.event import *
import attr




@to_json_decorator
@attr.s
class WorkplaceWidget(object):
    min_lark_version = attr.ib(type=str, default=None, metadata={'json': 'min_lark_version'})


@to_json_decorator
@attr.s
class WebApp(object):
    pc_url = attr.ib(type=str, default=None, metadata={'json': 'pc_url'})
    mobile_url = attr.ib(type=str, default=None, metadata={'json': 'mobile_url'})


@to_json_decorator
@attr.s
class UsageTrendItem(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["timestamp", "page_view", "unique_visitor"])
    timestamp = attr.ib(type=int, default=None, metadata={'json': 'timestamp'})
    page_view = attr.ib(type=int, default=None, metadata={'json': 'page_view'})
    unique_visitor = attr.ib(type=int, default=None, metadata={'json': 'unique_visitor'})


@to_json_decorator
@attr.s
class AppUsageTrendItems(object):
    id = attr.ib(type=str, default=None, metadata={'json': 'id'})
    trend = attr.ib(type=List[UsageTrendItem], default=None, metadata={'json': 'trend'})


@to_json_decorator
@attr.s
class AppMessageTrendItem(object):
    chat_type = attr.ib(type=str, default=None, metadata={'json': 'chat_type'})
    event_type = attr.ib(type=str, default=None, metadata={'json': 'event_type'})
    message_type = attr.ib(type=str, default=None, metadata={'json': 'message_type'})
    trend = attr.ib(type=List[UsageTrendItem], default=None, metadata={'json': 'trend'})


@to_json_decorator
@attr.s
class PlusMenu(object):
    pc_app_link = attr.ib(type=str, default=None, metadata={'json': 'pc_app_link'})
    mobile_app_link = attr.ib(type=str, default=None, metadata={'json': 'mobile_app_link'})


@to_json_decorator
@attr.s
class NavigateMeta(object):
    version = attr.ib(type=str, default=None, metadata={'json': 'version'})
    image_url = attr.ib(type=str, default=None, metadata={'json': 'image_url'})
    hover_image_url = attr.ib(type=str, default=None, metadata={'json': 'hover_image_url'})


@to_json_decorator
@attr.s
class Navigate(object):
    pc = attr.ib(type=NavigateMeta, default=None, metadata={'json': 'pc'})
    mobile = attr.ib(type=NavigateMeta, default=None, metadata={'json': 'mobile'})


@to_json_decorator
@attr.s
class MsgActionI18nInfo(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})


@to_json_decorator
@attr.s
class MsgAction(object):
    pc_app_link = attr.ib(type=str, default=None, metadata={'json': 'pc_app_link'})
    mobile_app_link = attr.ib(type=str, default=None, metadata={'json': 'mobile_app_link'})
    i18n = attr.ib(type=List[MsgActionI18nInfo], default=None, metadata={'json': 'i18n'})


@to_json_decorator
@attr.s
class MessageActionI18nInfo(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})


@to_json_decorator
@attr.s
class MessageAction(object):
    pc_app_link = attr.ib(type=str, default=None, metadata={'json': 'pc_app_link'})
    mobile_app_link = attr.ib(type=str, default=None, metadata={'json': 'mobile_app_link'})
    i18n = attr.ib(type=List[MessageActionI18nInfo], default=None, metadata={'json': 'i18n'})


@to_json_decorator
@attr.s
class Gadget(object):
    enable_pc_mode = attr.ib(type=int, default=None, metadata={'json': 'enable_pc_mode'})
    schema_urls = attr.ib(type=List[str], default=None, metadata={'json': 'schema_urls'})
    pc_use_mobile_pkg = attr.ib(type=bool, default=None, metadata={'json': 'pc_use_mobile_pkg'})
    pc_version = attr.ib(type=str, default=None, metadata={'json': 'pc_version'})
    mobile_version = attr.ib(type=str, default=None, metadata={'json': 'mobile_version'})
    mobile_min_lark_version = attr.ib(type=str, default=None, metadata={'json': 'mobile_min_lark_version'})
    pc_min_lark_version = attr.ib(type=str, default=None, metadata={'json': 'pc_min_lark_version'})


@to_json_decorator
@attr.s
class CloudDocI18nInfo(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})
    read_description = attr.ib(type=str, default=None, metadata={'json': 'read_description'})
    write_description = attr.ib(type=str, default=None, metadata={'json': 'write_description'})


@to_json_decorator
@attr.s
class CloudDoc(object):
    space_url = attr.ib(type=str, default=None, metadata={'json': 'space_url'})
    i18n = attr.ib(type=List[CloudDocI18nInfo], default=None, metadata={'json': 'i18n'})
    icon_url = attr.ib(type=str, default=None, metadata={'json': 'icon_url'})
    mode = attr.ib(type=int, default=None, metadata={'json': 'mode'})


@to_json_decorator
@attr.s
class ClientBadgeNum(object):
    web_app = attr.ib(type=int, default=None, metadata={'json': 'web_app'})
    gadget = attr.ib(type=int, default=None, metadata={'json': 'gadget'})


@to_json_decorator
@attr.s
class AppBadge(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["user_id", "version"])
    user_id = attr.ib(type=int, default=None, metadata={'json': 'user_id'})
    version = attr.ib(type=int, default=None, metadata={'json': 'version'})
    pc = attr.ib(type=ClientBadgeNum, default=None, metadata={'json': 'pc'})
    mobile = attr.ib(type=ClientBadgeNum, default=None, metadata={'json': 'mobile'})


@to_json_decorator
@attr.s
class Bot(object):
    card_request_url = attr.ib(type=str, default=None, metadata={'json': 'card_request_url'})


@to_json_decorator
@attr.s
class BlockI18nInfo(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})


@to_json_decorator
@attr.s
class DocsBlock(object):
    block_type_id = attr.ib(type=str, default=None, metadata={'json': 'block_type_id'})
    i18n = attr.ib(type=List[BlockI18nInfo], default=None, metadata={'json': 'i18n'})
    mobile_icon_url = attr.ib(type=str, default=None, metadata={'json': 'mobile_icon_url'})
    pc_icon_url = attr.ib(type=str, default=None, metadata={'json': 'pc_icon_url'})


@to_json_decorator
@attr.s
class AppAbility(object):
    gadget = attr.ib(type=Gadget, default=None, metadata={'json': 'gadget'})
    web_app = attr.ib(type=WebApp, default=None, metadata={'json': 'web_app'})
    bot = attr.ib(type=Bot, default=None, metadata={'json': 'bot'})
    workplace_widgets = attr.ib(type=List[WorkplaceWidget], default=None, metadata={'json': 'workplace_widgets'})
    navigate = attr.ib(type=Navigate, default=None, metadata={'json': 'navigate'})
    cloud_doc = attr.ib(type=CloudDoc, default=None, metadata={'json': 'cloud_doc'})
    docs_blocks = attr.ib(type=List[DocsBlock], default=None, metadata={'json': 'docs_blocks'})
    message_action = attr.ib(type=MessageAction, default=None, metadata={'json': 'message_action'})
    plus_menu = attr.ib(type=PlusMenu, default=None, metadata={'json': 'plus_menu'})


@to_json_decorator
@attr.s
class Block(object):
    block_type_id = attr.ib(type=str, default=None, metadata={'json': 'block_type_id'})
    version_id = attr.ib(type=str, default=None, metadata={'json': 'version_id'})
    i18n = attr.ib(type=List[BlockI18nInfo], default=None, metadata={'json': 'i18n'})
    mobile_icon_url = attr.ib(type=str, default=None, metadata={'json': 'mobile_icon_url'})
    pc_icon_url = attr.ib(type=str, default=None, metadata={'json': 'pc_icon_url'})


@to_json_decorator
@attr.s
class AppVisibleList(object):
    open_ids = attr.ib(type=List[int], default=None, metadata={'json': 'open_ids'})
    department_ids = attr.ib(type=List[int], default=None, metadata={'json': 'department_ids'})


@to_json_decorator
@attr.s
class ApplicationVisibility(object):
    is_all = attr.ib(type=bool, default=None, metadata={'json': 'is_all'})
    visible_list = attr.ib(type=AppVisibleList, default=None, metadata={'json': 'visible_list'})
    invisible_list = attr.ib(type=AppVisibleList, default=None, metadata={'json': 'invisible_list'})


@to_json_decorator
@attr.s
class AppVisibility(object):
    is_all = attr.ib(type=bool, default=None, metadata={'json': 'is_all'})
    visible_list = attr.ib(type=AppVisibleList, default=None, metadata={'json': 'visible_list'})
    invisible_list = attr.ib(type=AppVisibleList, default=None, metadata={'json': 'invisible_list'})


@to_json_decorator
@attr.s
class AppVersionRemark(object):
    remark = attr.ib(type=str, default=None, metadata={'json': 'remark'})
    update_remark = attr.ib(type=str, default=None, metadata={'json': 'update_remark'})
    visibility = attr.ib(type=AppVisibility, default=None, metadata={'json': 'visibility'})


@to_json_decorator
@attr.s
class AppScope(object):
    scope = attr.ib(type=str, default=None, metadata={'json': 'scope'})
    description = attr.ib(type=str, default=None, metadata={'json': 'description'})
    level = attr.ib(type=str, default=None, metadata={'json': 'level'})


@to_json_decorator
@attr.s
class AppI18nInfo(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})
    description = attr.ib(type=str, default=None, metadata={'json': 'description'})
    help_use = attr.ib(type=str, default=None, metadata={'json': 'help_use'})


@to_json_decorator
@attr.s
class ApplicationAppVersion(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["version_id", "create_time", "publish_time"])
    app_id = attr.ib(type=str, default=None, metadata={'json': 'app_id'})
    version = attr.ib(type=str, default=None, metadata={'json': 'version'})
    version_id = attr.ib(type=int, default=None, metadata={'json': 'version_id'})
    app_name = attr.ib(type=str, default=None, metadata={'json': 'app_name'})
    avatar_url = attr.ib(type=str, default=None, metadata={'json': 'avatar_url'})
    description = attr.ib(type=str, default=None, metadata={'json': 'description'})
    scopes = attr.ib(type=List[AppScope], default=None, metadata={'json': 'scopes'})
    back_home_url = attr.ib(type=str, default=None, metadata={'json': 'back_home_url'})
    i18n = attr.ib(type=List[AppI18nInfo], default=None, metadata={'json': 'i18n'})
    common_categories = attr.ib(type=List[str], default=None, metadata={'json': 'common_categories'})
    events = attr.ib(type=List[str], default=None, metadata={'json': 'events'})
    status = attr.ib(type=int, default=None, metadata={'json': 'status'})
    create_time = attr.ib(type=int, default=None, metadata={'json': 'create_time'})
    publish_time = attr.ib(type=int, default=None, metadata={'json': 'publish_time'})
    ability = attr.ib(type=AppAbility, default=None, metadata={'json': 'ability'})
    remark = attr.ib(type=AppVersionRemark, default=None, metadata={'json': 'remark'})


@to_json_decorator
@attr.s
class Application(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["creator_id", "online_version_id", "unaudit_version_id"])
    app_id = attr.ib(type=str, default=None, metadata={'json': 'app_id'})
    creator_id = attr.ib(type=int, default=None, metadata={'json': 'creator_id'})
    status = attr.ib(type=int, default=None, metadata={'json': 'status'})
    scene_type = attr.ib(type=int, default=None, metadata={'json': 'scene_type'})
    redirect_urls = attr.ib(type=List[str], default=None, metadata={'json': 'redirect_urls'})
    online_version_id = attr.ib(type=int, default=None, metadata={'json': 'online_version_id'})
    unaudit_version_id = attr.ib(type=int, default=None, metadata={'json': 'unaudit_version_id'})
    app_name = attr.ib(type=str, default=None, metadata={'json': 'app_name'})
    avatar_url = attr.ib(type=str, default=None, metadata={'json': 'avatar_url'})
    description = attr.ib(type=str, default=None, metadata={'json': 'description'})
    scopes = attr.ib(type=List[AppScope], default=None, metadata={'json': 'scopes'})
    back_home_url = attr.ib(type=str, default=None, metadata={'json': 'back_home_url'})
    i18n = attr.ib(type=List[AppI18nInfo], default=None, metadata={'json': 'i18n'})
    primary_language = attr.ib(type=str, default=None, metadata={'json': 'primary_language'})
    common_categories = attr.ib(type=List[str], default=None, metadata={'json': 'common_categories'})


@to_json_decorator
@attr.s
class UserId(object):
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    open_id = attr.ib(type=str, default=None, metadata={'json': 'open_id'})
    union_id = attr.ib(type=str, default=None, metadata={'json': 'union_id'})


@to_json_decorator
@attr.s
class User(object):
    user_id = attr.ib(type=UserId, default=None, metadata={'json': 'user_id'})


@to_json_decorator
@attr.s
class AppCommonCategory(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    category = attr.ib(type=str, default=None, metadata={'json': 'category'})


@to_json_decorator
@attr.s
class AppCustomCategory(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    description = attr.ib(type=str, default=None, metadata={'json': 'description'})
    app_ids = attr.ib(type=List[str], default=None, metadata={'json': 'app_ids'})


@to_json_decorator
@attr.s
class AppCustomCategoryI18nInfo(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})


@to_json_decorator
@attr.s
class AppScopeI18nInfo(object):
    i18n_key = attr.ib(type=str, default=None, metadata={'json': 'i18n_key'})
    description = attr.ib(type=str, default=None, metadata={'json': 'description'})


@to_json_decorator
@attr.s
class AppScopes(object):
    high_level_scopes = attr.ib(type=List[str], default=None, metadata={'json': 'high_level_scopes'})
    low_level_scopes = attr.ib(type=List[str], default=None, metadata={'json': 'low_level_scopes'})


@to_json_decorator
@attr.s
class AppVersionId(object):
    version = attr.ib(type=str, default=None, metadata={'json': 'version'})
    version_id = attr.ib(type=str, default=None, metadata={'json': 'version_id'})


@to_json_decorator
@attr.s
class MessageOverviewItem(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["page_view", "unique_visitor"])
    page_view = attr.ib(type=int, default=None, metadata={'json': 'page_view'})
    unique_visitor = attr.ib(type=int, default=None, metadata={'json': 'unique_visitor'})
    chat_type = attr.ib(type=str, default=None, metadata={'json': 'chat_type'})
    message_type = attr.ib(type=str, default=None, metadata={'json': 'message_type'})
    event_type = attr.ib(type=str, default=None, metadata={'json': 'event_type'})


@to_json_decorator
@attr.s
class Miniprogram(object):
    enable_pc_mode = attr.ib(type=int, default=None, metadata={'json': 'enable_pc_mode'})
    schema_urls = attr.ib(type=List[str], default=None, metadata={'json': 'schema_urls'})
    pc_use_mobile_pkg = attr.ib(type=bool, default=None, metadata={'json': 'pc_use_mobile_pkg'})
    pc_version_id = attr.ib(type=str, default=None, metadata={'json': 'pc_version_id'})
    mobile_version_id = attr.ib(type=str, default=None, metadata={'json': 'mobile_version_id'})
    mobile_min_lark_version = attr.ib(type=str, default=None, metadata={'json': 'mobile_min_lark_version'})
    pc_min_lark_version = attr.ib(type=str, default=None, metadata={'json': 'pc_min_lark_version'})


@to_json_decorator
@attr.s
class Scope(object):
    scope_name = attr.ib(type=str, default=None, metadata={'json': 'scope_name'})
    grant_status = attr.ib(type=int, default=None, metadata={'json': 'grant_status'})


@to_json_decorator
@attr.s
class UsageOverviewItem(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["page_view", "unique_visitor"])
    page_view = attr.ib(type=int, default=None, metadata={'json': 'page_view'})
    unique_visitor = attr.ib(type=int, default=None, metadata={'json': 'unique_visitor'})
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})


@to_json_decorator
@attr.s
class UsageUser(object):
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})


@to_json_decorator
@attr.s
class ApplicationAppUsage(object):
    metric_name = attr.ib(type=str, default=None, metadata={'json': 'metric_name'})
    metric_value = attr.ib(type=int, default=None, metadata={'json': 'metric_value'})



@to_json_decorator
@attr.s
class ApplicationAppUsageOverviewReqBody(object):
    date = attr.ib(type=str, default=None, metadata={'json': 'date'})
    cycle_type = attr.ib(type=int, default=None, metadata={'json': 'cycle_type'})
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})
    ability = attr.ib(type=str, default=None, metadata={'json': 'ability'})


@attr.s
class ApplicationAppUsageOverviewResult(object):
    items = attr.ib(type=List[ApplicationAppUsage], default=None, metadata={'json': 'items'})


@attr.s
class ApplicationVisibilityAddedEventData(object):
    users = attr.ib(type=List[User], default=None, metadata={'json': 'users'})
    source = attr.ib(type=int, default=None, metadata={'json': 'source'})


@attr.s
class ApplicationVisibilityAddedEvent(BaseEventV2):
    event = attr.ib(type=ApplicationVisibilityAddedEventData, default=None)
