# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.application_visibilitys = ApplicationVisibilityService(self)
        self.application_app_usages = ApplicationAppUsageService(self)
        



class ApplicationVisibilityService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service


class ApplicationAppUsageService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def overview(self, body, tenant_key=None, timeout=None):
        # type: (ApplicationAppUsageOverviewReqBody, str, int) -> ApplicationAppUsageOverviewReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ApplicationAppUsageOverviewReqCall(self, body, request_opts=request_opts)



class ApplicationAppUsageOverviewReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ApplicationAppUsageService, ApplicationAppUsageOverviewReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_app_id(self, app_id):
        # type: (str) -> ApplicationAppUsageOverviewReqCall
        self.path_params['app_id'] = app_id
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> ApplicationAppUsageOverviewReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[ApplicationAppUsageOverviewResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/application/v6/applications/:app_id/app_usage/overview', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=ApplicationAppUsageOverviewResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

