import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export interface TextractClassificationConfiguratorProps {
    /** memory of Lambda function (may need to increase for larger documents) */
    readonly lambdaMemoryMB?: number;
    readonly lambdaTimeout?: number;
    readonly lambdaLogLevel?: string;
}
export declare class TextractClassificationConfigurator extends sfn.StateMachineFragment {
    readonly startState: sfn.State;
    readonly endStates: sfn.INextable[];
    configuratorFunction: lambda.IFunction;
    configuratorFunctionLogGroupName: string;
    constructor(parent: Construct, id: string, props: TextractClassificationConfiguratorProps);
}
